{$I DEFINES.INC}
UNIT _SCRIPT; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ  v2.11

  The Universal Multimedia Interface For BBS Software
  Copyright 1995-Current * Larry L. Athey * BBS Utiliteez Software


  Information Regarding MAX Graphics:
  
  Notice is hereby given that the MAXscript/MAXcontrol/MAXcolor language,
  and MAXterm are products of BBS Utiliteez Software and are protected by
  US copyrights listed with the US Library Of Congress (1996)....

  No changes, additions, subtractions, or other modifications shall be made
  to MAXscript/MAXcontrol/MAXcolor language or the MAX Graphics development
  kit without express written permission from Larry L. Athey, BBS Utiliteez
  Software, Alliance, Nebraska, USA....

  The MAXscript/MAXcontrol/MAXcolor language may be used in any BBS or Door
  software 100% royalty free. You are also allowed to implement full local
  graphics viewing in any BBS or Door software 100% royalty free. However,
  any program that uses the MAXscript/MAXcontrol/MAXcolor language *MUST*
  bear the MAX Graphics/BBS Utiliteez Software copyright notice....


  Example: MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is
             (C) 1995-Current * Larry L. Athey * BBS Utiliteez Software



  This is the main MAXscript/MAXcontrol/MAXcolor interpreter unit. This unit
  is used to read strings of text and convert them into local graphics.  You
  will notice there are quite a few re-used procedures and variables in here
  which may be a bit confusing.  This is done in order to keep the code to a
  minimum, sorry about the added confusion....

 }

INTERFACE

VAR
  ResPath    : STRING[80];     {Resource Path                               }
  SesPath    : STRING[80];     {Session Path                                }
  DownPath1  : STRING[80];     {System download path                        }
  DownPath2  : STRING[80];     {System download path backup                 }
  ScrStr     : STRING;         {String that holds the current script command}
  ScreenDone : BOOLEAN;        {Becomes TRUE upon the End_Screen() command  }
  TextFile   : TEXT;           {Text file created by Start_Text_File()      }

PROCEDURE PlayButtonSound(FName : STRING);
{^ Plays a button sound file attachment.}
PROCEDURE WriteSystemInfo;
{^ This procedure writes the SYSTEM.NFO file.}
PROCEDURE IndexResources;
{^ This procedure is used to create a local resource list.}
PROCEDURE ShowRemoteScreen(FName : STRING);
{^ Called by the Show_Remote_Screen() MAX command.}
PROCEDURE CheckControlLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXscript commands.}
PROCEDURE CheckScriptLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcontrol commands.}
PROCEDURE CheckColorCommand(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcolor commands.}

IMPLEMENTATION

USES DOS, MYCRT, TERMVARS, GUI_UNIT, GUI_UTIL, GUI_IMAG, GUI_FONT, GUI_ICON,
     GUI_ANSI, GUI_MOUS, FGMAIN, FGMISC, FGSVGA, CRCUNIT, APVARS, PORTUNIT,
     APTIMER,{WAV_UNIT,}{ VOC_UNIT,}MOD_UNIT;

TYPE Max_Data = RECORD               {The MAX data record for conversions   }
     Text     : STRING;              {Text string for the current record    }
     Code     : BYTE;                {MAXcontrol/MAXcolor command code      }
     VType    : BYTE;                {126-MAXcontrol, 125-MAXcolor          }
     V        : ARRAY[1..10] OF INTEGER;{Array of command variables         }
     END;
VAR
  _Max       : Max_Data;                 {Record variable for the MAX data. }
  PolyX      : ARRAY[1..128] OF INTEGER; {Polygon/PolyLine X Coord Array.   }
  PolyY      : ARRAY[1..128] OF INTEGER; {Polygon/PolyLine Y Coord Array.   }

PROCEDURE PlayButtonSound(FName : STRING);
VAR
  PStr : STRING;
BEGIN
  IF (NOT DD.UseSB) OR (FExist('NOSOUND.FLG')) THEN EXIT;
  FName := AllCaps(FName);
  IF FExist(SesPath + FName) THEN BEGIN
    IF ModPlaying THEN ModShutDown;
    PStr := '-I'+SB.IRQ+' -P$'+SB.Address+' -D'+SB.DMA+' /B';
    IF (POS('.WAV',FName) > 0) OR (POS('.VOC',FName) > 0) THEN Execute('MAXSOUND.EXE',SesPath+FName+' '+PStr)
    ELSE IF POS('.MOD',FName) > 0 THEN BEGIN
      InitModUnit(SB.Address,SB.IRQ);
      PlayMOD(SesPath + FName);
      Show_Mem;
    END;
    (*
    IF POS('.WAV',AllCaps(FName)) > 0 THEN BEGIN
     {InitWavUnit(SB.Address,SB.IRQ,SB.DMA,'');
      PlayWAV(SesPath + FName);}
    END ELSE IF POS('.VOC',AllCaps(FName)) > 0 THEN BEGIN
     {InitVocUnit(SB.Address,SB.IRQ,SB.DMA);
      PlayVOC(SesPath + FName);}
    END ELSE IF POS('.MOD',AllCaps(FName)) > 0 THEN BEGIN
      InitModUnit(SB.Address,SB.IRQ);
      PlayMOD(SesPath + FName);
      Show_Mem;
    END;
    *)
  END;
END;

PROCEDURE WriteSystemInfo;
VAR
  Major : INTEGER;
  Minor : INTEGER;
  Txt   : TEXT;
BEGIN
  FG_SvgaVer(Major,Minor);
  ASSIGN(Txt,HomeDir+'\SYSTEM.NFO');
  REWRITE(Txt);
  WRITELN(Txt,'Program Name..........: '+ProgramName+' '+ProgramVersion);
  WRITELN(Txt,'MAXscript Version.....: '+MaxID);
  WRITELN(Txt,'Current Directory.....: '+HomeDir);
  WRITELN(Txt,'Download Path.........: '+AllCaps(DownPath1));
  WRITELN(Txt,'User Name.............: '+DD.UserName);
  WRITELN(Txt,'User Password.........: '+DD.Password);
  WRITELN(Txt,'Operating System......: '+OsStr);
  WRITELN(Txt,'Conventional Memory...: '+IntToStr(MEMAVAIL)+' Bytes');
  WRITELN(Txt,'Free Disk Space.......: '+IntToStr(DISKFREE(0))+' Bytes');
  WRITELN(Txt,'Video Chipset.........: '+FG_ChipSet);
  WRITELN(Txt,'Video RAM In Use......: '+IntToStr(FG_Memory)+'K Bytes');
  CASE CommDef.Device OF
    1 : WRITELN(Txt,'Comm Device In Use....: UART');
    2 : WRITELN(Txt,'Comm Device In Use....: FOSSIL');
    3 : WRITELN(Txt,'Comm Device In Use....: DIGIBOARD');
  END;
  IF DD.PhoneNumber <> '' THEN BEGIN
    IF DD.AnsiMode = 2 THEN WRITELN(Txt,'ANSI Emulation Mode...: SVGA')
                       ELSE WRITELN(Txt,'ANSI Emulation Mode...: TEXT');
    IF (FExist('NOSOUND.FLG')) OR (NOT DD.UseSB) THEN WRITELN(Txt,'Using SoundBlaster....: FALSE')
                                                 ELSE WRITELN(Txt,'Using SoundBlaster....: TRUE');
  END;
  WRITELN(Txt,'MaxModem Support......: TRUE');
  CLOSE(Txt);
END;

PROCEDURE IndexResources;
VAR
  WorkFile : STRING[12];
  WorkCrc  : STRING[8];
  DirInfo  : SEARCHREC;
  TheList  : TEXT;
BEGIN
  IF NOT DebugOn THEN BEGIN
    HideMouse;
    Draw_Window(253,197,384,248,5,'Processing:');
    OutText_XY(262,226,1,2,'Indexing Resources.');
  END;
  ASSIGN(TheList,HomeDir+'\RES.NFO');
  REWRITE(TheList);
  FINDFIRST(SesPath+'*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WorkFile := AllCaps(DirInfo.Name);
    IF (POS('ICON_LIB.',WorkFile) = 0) AND (POS('.PKG',WorkFile) = 0) THEN BEGIN
      WorkCrc  := AllCaps(FileToCrc(SesPath+WorkFile));
      WRITELN(TheList,WorkFile+' '+WorkCrc);
    END;
    FINDNEXT(DirInfo);
  END;
  CLOSE(TheList);
  IF NOT DebugOn THEN Kill_Window;
END;

PROCEDURE ShowRemoteScreen(FName : STRING);
VAR
  Txt : TEXT;
BEGIN
  IF NOT FExist(SesPath + FName) THEN BEGIN
    OutText_XY(10,30,15,1,SesPath + FName + ' Not Found!');
    OutText_XY(10,40,15,1,'Please Update Your Resources!');
    CheckScriptLine('Siren()');
    EXIT;
  END;
  ASSIGN(Txt,SesPath + FName);
  RESET(Txt);
  WHILE NOT EOF(Txt) DO BEGIN
    READLN(Txt,ScrStr);
    ScrStr := StripBoth(ScrStr,' ');
    ScrStr := StripBoth(ScrStr,#2);
    IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE
    IF POS(#255#125,ScrStr) = 1 THEN CheckColorCommand(ScrStr) ELSE
    IF ScrStr <> '' THEN CheckScriptLine(ScrStr);
  END;
  CLOSE(Txt);
END;

PROCEDURE Do_ADDTO_PICKLIST(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  AddTo_PickList(P);
END;

PROCEDURE Do_ANIMATE_ICON(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 255;
  _Max.V[7] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 255 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF (_Max.V[6] > 3) OR (_Max.V[6] < 1) THEN _Max.V[6] := 1;
            Temp := '';
          END;
      7 : IF _Max.V[7] = 255 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            IF _Max.V[7] > 99 THEN _Max.V[7] := 99;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO AnimateIcon(V[1],V[2],V[3],V[4],V[5],V[6],V[7]);
END;

PROCEDURE Do_DRAW_BEZIER(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp       := '';
  PCount     := 0;
  _Max.V[1]  := 1000;
  _Max.V[2]  := 1000;
  _Max.V[3]  := 1000;
  _Max.V[4]  := 1000;
  _Max.V[5]  := 1000;
  _Max.V[6]  := 1000;
  _Max.V[7]  := 1000;
  _Max.V[8]  := 1000;
  _Max.V[9]  := 1000;
  _Max.V[10] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            Temp := '';
          END;
      7 : IF _Max.V[7] = 1000 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            Temp := '';
          END;
      8 : IF _Max.V[8] = 1000 THEN BEGIN
            _Max.V[8] := StrToInt(Temp);
            Temp := '';
          END;
      9 : IF _Max.V[9] = 1000 THEN BEGIN
            _Max.V[9] := StrToInt(Temp);
            Temp := '';
          END;
     10 : IF _Max.V[10] = 1000 THEN BEGIN
            _Max.V[10] := StrToInt(Temp);
            IF _Max.V[10] > 255 THEN _Max.V[10] := 15;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO
  Draw_Bezier(V[1],V[2],V[3],V[4],V[5],V[6],V[7],V[8],V[9],V[10],FALSE);
END;

PROCEDURE Do_SQUARE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp   := '';
  PCount := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    FG_SetColor(V[5]);
    CASE WhichOne OF
      1 : FG_ClpRect(V[1],V[3],V[2],V[4]);
      2 : FrameHigh(V[1],V[2],V[3],V[4]);
      3 : FrameLow(V[1],V[2],V[3],V[4]);
      4 : FG_Box(V[1],V[3],V[2],V[4]);
      5 : LoweredBox(V[1],V[2],V[3],V[4]);
      6 : RaisedBox(V[1],V[2],V[3],V[4]);
      7 : Draw_Line(V[1],V[2],V[3],V[4],V[5]);
      8 : Draw_Mesh(V[1],V[2],V[3],V[4],V[5]);
      9 : Click_Zone(V[1],V[2],V[3],V[4],V[5]);
     10 : User_Button(V[1],V[2],V[3],V[4],V[5]);
     11 : Text_View_Port(V[1],V[2],V[3],V[4]);
     12 : Mouse_Field(V[1],V[2],V[3],V[4],V[5]);
    END;
  END;
END;

PROCEDURE Do_CHANGE_FIELD(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  ChangeField(StrToInt(P));
  RedrawField;
END;

PROCEDURE Do_CLEAR_SCREEN(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  FG_SetColor(0); FG_Box(0,639,0,479);
  FG_SetColor(StrToInt(P)); FG_ClpRect(1,638,21,458);
END;

PROCEDURE Do_DRAW_BUTTON(P : STRING);
VAR
  Loop    : BYTE;
  PCount  : BYTE;
  UseIcon : BOOLEAN;
  DoAll   : BOOLEAN;
  Temp    : STRING;
  Scrap   : CHAR;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  _Max.V[5] := 0;
  _Max.V[6] := 1000;
  UseIcon   := FALSE;
  DoAll     := FALSE;
  Scrap     := '!';
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF Scrap = '!' THEN BEGIN
            IF Temp = '1' THEN BEGIN
              UseIcon := TRUE;
              _Max.V[5] := 1;
            END;
            Scrap := '.';
            Temp  := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF _Max.V[6] > 99 THEN _Max.V[6] := 99;
            Temp := ''
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO Draw_Button(V[1],V[2],V[3],V[4],UseIcon,V[6],Text);
END;

PROCEDURE Do_DRAW_CIRCLE(P : STRING ; WhichOne : BYTE);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : BEGIN
            FG_SetColor(V[4]);
            FG_Move(V[1],V[2]);
            FG_Circle(V[3]);
          END;
      2 : BEGIN
            FG_SetColor(V[4]);
            FG_Move(V[1],V[2]);
            FG_CircleF(V[3]);
          END;
    END;
  END;
END;

PROCEDURE Do_ELLIPSE(P : STRING ; WhichOne : BYTE);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 1000;
  _Max.V[7] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            Temp := '';
          END;
      7 : IF _Max.V[7] = 1000 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    IF WhichOne < 3 THEN FG_SetColor(V[7]);
    CASE WhichOne OF
      1 : BEGIN
            FG_SetColor(V[5]);
            FG_Move(V[1],V[2]);
            FG_Ellipse(V[3],V[4]);
          END;
      2 : BEGIN
            FG_SetColor(V[5]);
            FG_Move(V[1],V[2]);
            FG_EllipseF(V[3],V[4]);
          END;
      3 : BEGIN
            IF V[3] > 99 THEN V[3] := 99;
            IF V[4] > 99 THEN V[4] := 99;
            IF V[5] > 3  THEN V[5] := 3;
            Ani_Button(V[1],V[2],V[3],V[4],V[5],V[6],V[7]);
          END;
     {4 : BEGIN
            Draw_Line(V[1],V[2],V[3],V[4],V[7]);
            Draw_Line(V[3],V[4],V[5],V[6],V[7]);
            Draw_Line(V[5],V[6],V[1],V[2],V[7]);
          END;} {Duh...MAX v1.XX leftover...}
      5 : BEGIN
            IF V[3] > 99 THEN V[3] := 99;
            IF V[4] > 99 THEN V[4] := 99;
            IF V[5] > 99 THEN V[5] := 99;
            IF V[6] > 99 THEN V[6] := 99;
            IF (V[7] > 3) AND (V[7] < 1) THEN V[7] := 1;
            Flip_Icon(V[1],V[2],V[3],V[4],V[5],V[6],V[7]);
          END;
    END;
  END;
END;

PROCEDURE Do_DRAW_WINDOW(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO Draw_Window(V[1],V[2],V[3],V[4],V[5],Text);
  AllowDragging := TRUE;
END;

PROCEDURE Do_END_SCREEN;
BEGIN
  IF PickInfo.Active AND NOT PickInfo.Running THEN SetUp_PickList;
  IF TextReader.Active AND NOT TextReader.Running THEN ShowTextPage;
  IF TextEditor.Active AND NOT TextEditor.Running THEN RunTextEditor;
  IF TvPort.Active THEN BEGIN
    Clr_Scr;
    HandleMouse := TRUE;
  END;
  ScreenDone := TRUE;
END;

PROCEDURE Do_ENTRY_FIELD(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 255;
  _Max.V[4] := 255;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 255 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            IF _Max.V[5] > 1 THEN _Max.V[5] := 0;
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO Entry_Field(V[1],V[2],V[3],V[4],V[5],Text);
END;

PROCEDURE Do_FIELD_TEXT(P : STRING ; WhichOne : BYTE);
VAR
  F      : INTEGER;
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
  Txt    : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            F    := _Max.V[1];
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  CASE WhichOne OF
    1 : IF NFields  > 0 THEN BEGIN
          Fields^[F].Text            := _Max.Text;
          Fields^[NFields].CursorPos := LENGTH(_Max.Text) + 1;
        END;
    2 : IF NButtons > 0 THEN Buttons^[F].ButStr := _Max.Text;
    3 : IF NButtons > 0 THEN Buttons^[F].Sound  := _Max.Text;
  END;
END;

PROCEDURE Do_GET_EDITOR_TEXT;
VAR
  Loop  : BYTE;
  TFile : TEXT;
  TStr  : String[80];
BEGIN
  IF NOT Carrier THEN EXIT;
  RaisedBox(0,459,639,479);
  OutText_XY(282,461,4,2,'Sending Editor Text');
  IF FExist(EditorFile) THEN BEGIN
    ASSIGN(TFile,EditorFile);
    RESET(TFile);
    WHILE NOT EOF(TFile) DO BEGIN
      READLN(TFile,TStr);
      SendStr(TStr+#13+#10);
    END;
    CLOSE(TFile);
    SendStr(#255#255#13#10);
  END;
  RaisedBox(0,459,639,479);
  OutText_XY(7,462,1,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE Do_GET_FIELD_DATA;
VAR
  Loop : BYTE;
BEGIN
  IF (NOT Carrier) OR (NFields = 0) THEN EXIT;
  RaisedBox(0,459,639,479);
  OutText_XY(282,461,4,2,'Sending Field Data');
  FOR Loop := 1 TO NFields DO SendStr(Fields^[Loop].Text+#13+#10);
  SendStr(#255#255#13#10);
  RaisedBox(0,459,639,479);
  OutText_XY(7,462,1,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE Do_GET_PICK_INFO;
VAR
  Loop : BYTE;
BEGIN
  IF (NOT Carrier) OR (NOT PickInfo.Active) THEN EXIT;
  RaisedBox(0,459,639,479);
  OutText_XY(282,461,4,2,'Sending Pick Info');
  SendStr(IntToStr(PickInfo.Current)+#13+#10);
  SendStr(PickList^[PickInfo.Current]+#13+#10);
  SendStr(#255#255#13#10);
  RaisedBox(0,459,639,479);
  OutText_XY(7,462,1,2,'Running Under '+OsStr);
  Show_Mem;
END;

PROCEDURE Do_LOAD_TEXT_FILE(P : STRING);
BEGIN
  P := GetFileName(StripBoth(P,#39));
  FillTextBuffer(SesPath + P);
END;

PROCEDURE Do_MOUSE_MASK(P : STRING);
VAR
  M : WORD;
BEGIN
  M := StrToInt(P);
  IF M > 18 THEN M := MouseClockCursor;
  MouseMask(M);
END;

PROCEDURE Do_NEW_PICKLIST(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 30 THEN _Max.V[3] := 30;
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            IF _Max.V[4] > 77 THEN _Max.V[4] := 77;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO New_PickList(V[1],V[2],V[3],V[4]);
END;

PROCEDURE Do_NEW_TEXT_EDITOR(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  IF FExist(EditorFile) THEN FErase(EditorFile);
  New_TextEditor(StrToInt(P));
END;

PROCEDURE Do_NEW_TEXT_READER(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  New_TextReader(StrToInt(P));
END;

PROCEDURE Do_PLAY_SOUND(P : STRING);
VAR
  PStr : STRING;
BEGIN
  IF (NOT DD.UseSB) OR (FExist('NOSOUND.FLG')) THEN EXIT;
  P := AllCaps(GetFileName(StripBoth(P,#39)));
  IF FExist(SesPath + P) THEN BEGIN
    IF ModPlaying THEN ModShutDown;
    PStr := '-I'+SB.IRQ+' -P$'+SB.Address+' -D'+SB.DMA+' /B';
    IF (POS('.WAV',P) > 0) OR (POS('.VOC',P) > 0) THEN Execute('MAXSOUND.EXE',SesPath+P+' '+PStr)
    ELSE IF POS('.MOD',P) > 0 THEN BEGIN
      InitModUnit(SB.Address,SB.IRQ);
      PlayMOD(SesPath + P);
      Show_Mem;
    END;
    (*
    IF POS('.WAV',(P)) > 0 THEN BEGIN
     {InitWavUnit(SB.Address,SB.IRQ,SB.DMA,'');
      PlayWAV(SesPath + P);}
    END ELSE IF POS('.VOC',P) > 0 THEN BEGIN
     {InitVocUnit(SB.Address,SB.IRQ,SB.DMA);
      PlayVOC(SesPath + P);}
    END ELSE IF POS('.MOD',P) > 0 THEN BEGIN
      InitModUnit(SB.Address,SB.IRQ);
      PlayMOD(SesPath + P);
      Show_Mem;
    END;
    *)
  END;
END;

PROCEDURE Do_PUT_IMAGE(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := GetFileName(StripBoth(Temp,#39));
  WITH _Max DO Put_Image(V[1],V[2],SesPath + Text);
END;

PROCEDURE Do_PUT_ICON(P : STRING ; IconSize : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 99 THEN _Max.V[3] := 99;
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF _Max.V[4] = 1000 THEN _Max.V[4] := 0;
  WITH _Max DO CASE IconSize OF
    1 : PutIcon16(V[1],V[2],V[3],V[4]);
    2 : PutIcon30(V[1],V[2],V[3],V[4]);
    3 : PutIcon60(V[1],V[2],V[3],V[4]);
  END;
END;

PROCEDURE Do_TRIANGLE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO CASE WhichOne OF
    1 : Radio_Button(V[1],V[2],V[3]);
    2 : BEGIN
          FG_SetColor(V[3]);
          FG_Point(V[1],V[2]);
        END;
    3 : BEGIN
          FG_SetColor(V[3]);
          FG_Flood(V[1],V[2]);
        END;
    4 : IF V[1] <= 128 THEN BEGIN
          PolyX[V[1]] := V[2];
          PolyY[V[1]] := V[3];
        END;
  END;
END;

PROCEDURE Do_POLY(P : STRING ; WhichOne : BYTE);
TYPE Polygon_Array = ARRAY[1..256] OF INTEGER;
TYPE Work_Array    = ARRAY[1..32000] OF INTEGER;
VAR
  PArray : ^Polygon_Array;
  WArray : ^Work_Array;
  Point  : INTEGER;
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO CASE WhichOne OF
    1 : BEGIN
          IF V[1] > 128 THEN V[1] := 128;
          IF V[2] > 255 THEN V[2] := 15;
          FG_SetColor(V[2]);
          FG_Polygon(PolyX,PolyY,V[1]);
        END;
    2 : BEGIN
          IF V[1] > 128 THEN V[1] := 128;
          IF V[2] > 255 THEN V[2] := 15;
          NEW(PArray);
          NEW(WArray);
          FILLCHAR(WArray^,SIZEOF(WArray^),0);
          Point := 0;
          FOR Loop := 1 TO 128 DO BEGIN
            INC(Point);
            PArray^[Point] := PolyX[Loop];
            INC(Point);
            PArray^[Point] := PolyY[Loop];
          END;
          FG_SetColor(V[2]);
          FG_Polygon(PArray,WArray,V[1]);
          DISPOSE(WArray);
          DISPOSE(PArray);
        END;
    3 : BEGIN
          IF V[1] > 639 THEN V[1] := 639;
          IF V[2] > 439 THEN V[2] := 439;
          IF MouseOn THEN HideMouse;
          FG_MouseMov(V[1],V[2]);
          IF MouseOn THEN ShowMouse;
        END;
  END;
END;

PROCEDURE Do_RESET_PICKLIST(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  Reset_PickList(StrToInt(P));
END;

PROCEDURE Do_STANDARD_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 4 THEN _Max.V[4] := 3;
  WITH _Max DO OutText_XY(V[1],V[2],V[3],V[4],Text);
END;

PROCEDURE Do_SHADOW_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 255 THEN _Max.V[4] := 0;
  IF _Max.V[5] > 4 THEN _Max.V[5] := 3;
  WITH _Max DO ShadowText(V[1],V[2],V[3],V[4],V[5],Text);
END;

PROCEDURE Do_RESET_REMOTE;
BEGIN
  InitPalette;
  ResetGraphics;
  EditorFile  := SesPath + 'TEXTFILE.TXT';
  IconLib16   := SesPath + 'ICON_LIB.001';
  IconLib30   := SesPath + 'ICON_LIB.002';
  IconLib60   := SesPath + 'ICON_LIB.003';
  BBSmessages := TRUE;
END;

PROCEDURE Do_SIREN;
VAR
  Frequency : INTEGER;
  Count     : BYTE;
BEGIN
  Count := 0;
  REPEAT
    INC(Count);
    Frequency := 600;
    REPEAT
      INC(Frequency,10);
      DELAY(1);
      SOUND(Frequency);
    UNTIL Frequency = 1200;
    REPEAT
      DEC(Frequency,10);
      DELAY(1);
      SOUND(Frequency);
    UNTIL Frequency = 600;
  UNTIL Count = 5;
  NOSOUND;
END;

PROCEDURE Do_BLIP;
VAR
  Frequency : INTEGER;
BEGIN
  Frequency := 300;
  REPEAT
    INC(Frequency,7);
    DELAY(1);
    SOUND(Frequency);
  UNTIL Frequency > 700;
  NOSOUND;
END;

PROCEDURE Do_MAXECUTE(TheFile : STRING);
BEGIN
  TheFile := StripBoth(TheFile,#39);
  IF ModPlaying THEN ModShutDown;
  ShutDownSvga;
  DeInitComport;
  CHDIR(NoPath(SesPath));
  Execute(TheFile,HomeDir);
  FErase('MAXINFO.DEF');
  CHDIR(HomeDir);
  RestartSvga;
  IF NOT MouseOn THEN HideMouse;
  IF NOT InitComport THEN BEGIN
    ShutDownGui;
    WRITELN('Comport Error!');
    Do_SIREN;
    HALT;
  END;
  IF Carrier THEN SendChar(#13);
END;

PROCEDURE Do_EDITOR_FILE(P : STRING ; WhichOne : BYTE);
BEGIN
  CASE WhichOne OF
    1 : EditorFile := SesPath + GetFileName(StripBoth(P,#39));
    2 : MouseMask256(SesPath + GetFileName(StripBoth(P,#39)));
  END;
END;

PROCEDURE Do_HIDE_MOUSE;
BEGIN
  HideMouse;
  MouseOn     := FALSE;
  HandleMouse := FALSE;
END;

PROCEDURE Do_SHOW_MOUSE;
BEGIN
  ShowMouse;
  MouseOn     := TRUE;
  HandleMouse := TRUE;
END;

PROCEDURE Do_KILL_WINDOW;
BEGIN
  IF WindowNumber > 2 THEN Kill_Window;
  IF NOT MouseOn THEN HideMouse;
END;

PROCEDURE Do_LARGE_ICON_LIB(P : STRING);
BEGIN
  IconLib60 := SesPath + GetFileName(StripBoth(P,#39));
END;

PROCEDURE Do_MEDIUM_ICON_LIB(P : STRING);
BEGIN
  IconLib30 := SesPath + GetFileName(StripBoth(P,#39));
END;

PROCEDURE Do_SMALL_ICON_LIB(P : STRING);
BEGIN
  IconLib16 := SesPath + GetFileName(StripBoth(P,#39));
END;

PROCEDURE Do_LOAD_FONT(P : STRING);
BEGIN
  LoadUserFont(SesPath + GetFileName(StripBoth(P,#39)));
END;

PROCEDURE Do_RUN_TEXT_EDITOR;
BEGIN
  IF TBuff <> NIL THEN RunTextEditor;
END;

PROCEDURE Do_SETUP_PICKLIST;
BEGIN
  IF PickList <> NIL THEN SetUp_PickList;
END;

PROCEDURE Do_SHOW_TEXT_PAGE;
BEGIN
  IF Tbuff <> NIL THEN ShowTextPage;
END;

PROCEDURE Do_SHOW_REMOTE_SCREEN(P : STRING);
BEGIN
  {Duh, What???}
END;

PROCEDURE Do_START_SCREEN;
BEGIN
  ExplodeOn     := FALSE;
  AllowDragging := TRUE;
  FILLCHAR(PolyX,SIZEOF(PolyX),0);
  FILLCHAR(PolyY,SIZEOF(PolyY),0);
END;

PROCEDURE Do_START_TEXT_FILE(P : STRING);
BEGIN
  RaisedBox(0,459,639,479);
  OutText_XY(280,461,4,2,'Receiving Text');
  ASSIGN(TextFile,SesPath+GetFileName(StripBoth(P,#39)));
  REWRITE(TextFile);
END;

PROCEDURE Do_PUT_TEXT_FILE(P : STRING);
BEGIN
  DELETE(P,1,1);
  DELETE(P,LENGTH(P),1);
  WRITELN(TextFile,P);
END;

PROCEDURE Do_END_TEXT_FILE;
BEGIN
  RaisedBox(0,459,639,479);
  OutText_XY(7,462,1,2,'Running Under '+OsStr);
  Show_Mem;
  CLOSE(TextFile);
END;

PROCEDURE Do_HTML_BROWSER(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  IF FExist(SesPath + P) THEN BEGIN
    IF ModPlaying THEN ModShutDown;
    ShutDownSvga;
    DeInitComport;
    Execute(GetEnv('COMSPEC'),'/C BROWSER.BAT ' + SesPath + P);
    CHDIR(HomeDir);
    RestartSvga;
    IF NOT MouseOn THEN HideMouse;
    IF NOT InitComport THEN BEGIN
      ShutDownGui;
      WRITELN('Comport Error!');
      Do_SIREN;
      HALT;
    END;
  END;
END;

PROCEDURE Do_WINDOW_EFFECTS(P : STRING ; WhichOne : BYTE);
BEGIN
  CASE WhichOne OF
    1 : IF StrToInt(P) = 1 THEN AllowDragging := TRUE ELSE AllowDragging := FALSE;
    2 : IF StrToInt(P) = 1 THEN ExplodeOn := TRUE ELSE ExplodeOn := FALSE;
  END;
END;

PROCEDURE Do_PLAY_FLI(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO Play_FLI(V[1],V[2],SesPath + Text);
  IF NOT MouseOn THEN HideMouse;
END;

PROCEDURE Do_MUTE_MOD;
BEGIN
  IF ModPlaying THEN ModShutDown;
END;

PROCEDURE CheckControlLine(Command : STRING);
VAR
  Code : CHAR;
BEGIN
  IF DebugOn THEN BEGIN
    ScrStr := '';
    EXIT;
  END;
  Code       := Command[3];
  ScreenDone := FALSE;
  DELETE(Command,1,3);
  IF Command[LENGTH(Command)] = #255 THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    CASE Code OF
      #128 : Do_DRAW_WINDOW(Command);
      #129 : Do_KILL_WINDOW;
      #130 : Do_DRAW_BUTTON(Command);
      #131 : Do_ENTRY_FIELD(Command);
      #132 : Do_SQUARE(Command,7);
      #133 : Do_SMALL_ICON_LIB(Command);
      #134 : Do_MEDIUM_ICON_LIB(Command);
      #135 : Do_LARGE_ICON_LIB(Command);
      #136 : Do_PUT_ICON(Command,3);
      #137 : Do_PUT_ICON(Command,2);
      #138 : Do_PUT_ICON(Command,1);
      #139 : Do_HIDE_MOUSE;
      #140 : Do_SHOW_MOUSE;
      #141 : Do_MOUSE_MASK(Command);
      #142 : Do_STANDARD_TEXT(Command);
      #143 : Do_SHADOW_TEXT(Command);
      #144 : Do_SQUARE(Command,2);
      #145 : Do_SQUARE(Command,3);
      #146 : Do_SQUARE(Command,6);
      #147 : Do_SQUARE(Command,5);
      #148 : Do_LOAD_FONT(Command);
      #149 : Do_ADDTO_PICKLIST(Command);
      #150 : Do_SETUP_PICKLIST;
      #151 : Do_RESET_PICKLIST(Command);
      #152 : Do_CHANGE_FIELD(Command);
      #153 : Do_DRAW_CIRCLE(Command,2);
      #154 : Do_NEW_TEXT_EDITOR(Command);
      #155 : Do_RUN_TEXT_EDITOR;
      #156 : Do_NEW_TEXT_READER(Command);
      #157 : Do_SHOW_TEXT_PAGE;
      #158 : Do_DRAW_CIRCLE(Command,1);
      #159 : Do_SQUARE(Command,1);
      #160 : Do_SQUARE(Command,12);
      #161 : Do_CLEAR_SCREEN(Command);
      #162 : Do_SQUARE(Command,4);
      #163 : Do_PLAY_SOUND(Command);
      #164 : Do_PUT_IMAGE(Command);
      #165 : Do_TRIANGLE(Command,3);
      #166 : Do_ELLIPSE(Command,1);
      #167 : Do_LOAD_TEXT_FILE(Command);
      #168 : Do_NEW_PICKLIST(Command);
      #169 : Do_RESET_REMOTE;
      #170 : Do_TRIANGLE(Command,1);
      #171 : Do_SQUARE(Command,9);
      #172 : Do_ELLIPSE(Command,2);
      #173 : Do_ANIMATE_ICON(Command);
      #174 : Do_SQUARE(Command,10);
      #175 : Do_WINDOW_EFFECTS(Command,1);
      #176 : Do_EDITOR_FILE(Command,1);
      #177 : Do_TRIANGLE(Command,2);
      #178 : Do_FIELD_TEXT(Command,3);
      #179 : Do_ELLIPSE(Command,5);
      #180 : Do_START_TEXT_FILE(Command);
      #181 : Do_PUT_TEXT_FILE(Command);
      #182 : Do_END_TEXT_FILE;
      #183 : Do_FIELD_TEXT(Command,2);
      #184 : Do_SIREN;
      #185 : Do_MAXECUTE(Command);
      #186 : Do_SQUARE(Command,11);
      #187 : Do_HTML_BROWSER(Command);
      #188 : Do_WINDOW_EFFECTS(Command,2);
      #189 : Do_PLAY_FLI(Command);
      #190 : Do_ELLIPSE(Command,3);
      #191 : Do_BLIP;
      #192 : Do_EDITOR_FILE(Command,2);
      #193 : Do_DRAW_BEZIER(Command);
      #194 : Do_TRIANGLE(Command,4);
      #195 : Do_POLY(Command,1);
      #196 : Do_POLY(Command,2);
      #197 : Do_POLY(Command,3);
      #198 : Do_MUTE_MOD;
      #247 : Do_GET_PICK_INFO;
      #248 : Do_FIELD_TEXT(Command,1);
      #249 : Do_GET_EDITOR_TEXT;
      #250 : Do_GET_FIELD_DATA;
      #251 : Do_SHOW_REMOTE_SCREEN(Command);
      #252 : Do_SQUARE(Command,8);
      #253 : Do_START_SCREEN;
      #254 : Do_END_SCREEN;
    END;
  END;
  ScrStr := '';
END;

PROCEDURE CheckScriptLine(Command : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
  Stop : BYTE;
BEGIN
  IF DebugOn THEN BEGIN
    ScrStr := '';
    EXIT;
  END;
  Temp       := '';
  ScreenDone := FALSE;
  FOR Loop := 1 TO LENGTH(Command) DO BEGIN
    Stop := Loop;
    IF Command[Loop] <> '(' THEN Temp := Temp + UPCASE(Command[Loop]);
    IF Command[Loop] = '(' THEN Break;
  END;
  DELETE(Command,1,Stop);
  IF Command[LENGTH(Command)] = ')' THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    IF Temp = 'ADDTO_PICKLIST' THEN Do_ADDTO_PICKLIST(Command) ELSE
    IF Temp = 'ANIMATE_ICON' THEN Do_ANIMATE_ICON(Command) ELSE
    IF Temp = 'ANI_BUTTON' THEN Do_ELLIPSE(Command,3) ELSE
    IF Temp = 'BAR' THEN Do_SQUARE(Command,1) ELSE
    IF Temp = 'BLIP' THEN Do_BLIP ELSE
    IF Temp = 'BUTTON_EXTENSION' THEN Do_FIELD_TEXT(Command,2) ELSE
    IF Temp = 'BUTTON_SOUND' THEN Do_FIELD_TEXT(Command,3) ELSE
    IF Temp = 'CHANGE_FIELD' THEN Do_CHANGE_FIELD(Command) ELSE
    IF Temp = 'CLEAR_SCREEN' THEN Do_CLEAR_SCREEN(Command) ELSE
    IF Temp = 'CLICK_ZONE' THEN Do_SQUARE(Command,9) ELSE
    IF Temp = 'DRAW_BEZIER' THEN Do_DRAW_BEZIER(Command) ELSE
    IF Temp = 'DRAW_BUTTON' THEN Do_DRAW_BUTTON(Command) ELSE
    IF Temp = 'DRAW_CIRCLE' THEN Do_DRAW_CIRCLE(Command,1) ELSE
    IF Temp = 'DRAW_ELLIPSE' THEN Do_ELLIPSE(Command,1) ELSE
    IF Temp = 'DRAW_FILLED_CIRCLE' THEN Do_DRAW_CIRCLE(Command,2) ELSE
    IF Temp = 'DRAW_FILLED_ELLIPSE' THEN Do_ELLIPSE(Command,2) ELSE
    IF Temp = 'DRAW_FILLED_POLYGON' THEN Do_POLY(Command,2) ELSE
    IF Temp = 'DRAW_LINE' THEN Do_SQUARE(Command,7) ELSE
    IF Temp = 'DRAW_MESH' THEN Do_SQUARE(Command,8) ELSE
    IF Temp = 'DRAW_POLYGON' THEN Do_POLY(Command,1) ELSE
    IF Temp = 'DRAW_RECTANGLE' THEN Do_SQUARE(Command,4) ELSE
    IF Temp = 'DRAW_WINDOW' THEN Do_DRAW_WINDOW(Command) ELSE
    IF Temp = 'EDITOR_FILE' THEN Do_EDITOR_FILE(Command,1) ELSE
    IF Temp = 'END_SCREEN' THEN Do_END_SCREEN ELSE
    IF Temp = 'END_TEXT_FILE' THEN Do_END_TEXT_FILE ELSE
    IF Temp = 'ENTRY_FIELD' THEN Do_ENTRY_FIELD(Command) ELSE
    IF Temp = 'EXPLODING_WINDOWS' THEN Do_WINDOW_EFFECTS(Command,2) ELSE
    IF Temp = 'FIELD_TEXT' THEN Do_FIELD_TEXT(Command,1) ELSE
    IF Temp = 'FLIP_ICON' THEN Do_ELLIPSE(Command,5) ELSE
    IF Temp = 'FLOOD_FILL' THEN Do_TRIANGLE(Command,3) ELSE
    IF Temp = 'FRAME_HIGH' THEN Do_SQUARE(Command,2) ELSE
    IF Temp = 'FRAME_LOW' THEN Do_SQUARE(Command,3) ELSE
    IF Temp = 'GET_EDITOR_TEXT' THEN Do_GET_EDITOR_TEXT ELSE
    IF Temp = 'GET_FIELD_DATA' THEN Do_GET_FIELD_DATA ELSE
    IF Temp = 'GET_PICK_INFO' THEN Do_GET_PICK_INFO ELSE
    IF Temp = 'HIDE_MOUSE' THEN Do_HIDE_MOUSE ELSE
    IF Temp = 'HTML_BROWSER' THEN Do_HTML_BROWSER(Command) ELSE
    IF Temp = 'KILL_WINDOW' THEN Do_KILL_WINDOW ELSE
    IF Temp = 'LARGE_ICON_LIB' THEN Do_LARGE_ICON_LIB(Command) ELSE
    IF Temp = 'LOAD_FONT' THEN Do_LOAD_FONT(Command) ELSE
    IF Temp = 'LOAD_TEXT_FILE' THEN Do_LOAD_TEXT_FILE(Command) ELSE
    IF Temp = 'LOWERED_BOX' THEN Do_SQUARE(Command,5) ELSE
    IF Temp = 'MAXECUTE' THEN Do_MAXECUTE(Command) ELSE
    IF Temp = 'MEDIUM_ICON_LIB' THEN Do_MEDIUM_ICON_LIB(Command) ELSE
    IF Temp = 'MOUSE_FIELD' THEN Do_SQUARE(Command,12) ELSE
    IF Temp = 'MOUSE_MASK' THEN Do_MOUSE_MASK(Command) ELSE
    IF Temp = 'MOUSE_MASK_256' THEN Do_EDITOR_FILE(Command,2) ELSE
    IF Temp = 'MOVE_MOUSE' THEN Do_POLY(Command,3) ELSE
    IF Temp = 'MUTE_MOD' THEN Do_MUTE_MOD ELSE
    IF Temp = 'NEW_PICKLIST' THEN Do_NEW_PICKLIST(Command) ELSE
    IF Temp = 'NEW_TEXT_EDITOR' THEN Do_NEW_TEXT_EDITOR(Command) ELSE
    IF Temp = 'NEW_TEXT_READER' THEN Do_NEW_TEXT_READER(Command) ELSE
    IF Temp = 'PLAY_FLI' THEN Do_PLAY_FLI(Command) ELSE
    IF Temp = 'PLAY_SOUND' THEN Do_PLAY_SOUND(Command) ELSE
    IF Temp = 'POLYPOINT' THEN Do_TRIANGLE(Command,4) ELSE
    IF Temp = 'PUT_IMAGE' THEN Do_PUT_IMAGE(Command) ELSE
    IF Temp = 'PUT_LARGE_ICON' THEN Do_PUT_ICON(Command,3) ELSE
    IF Temp = 'PUT_MEDIUM_ICON' THEN Do_PUT_ICON(Command,2) ELSE
    IF Temp = 'PUT_PIXEL' THEN Do_TRIANGLE(Command,2) ELSE
    IF Temp = 'PUT_SMALL_ICON' THEN Do_PUT_ICON(Command,1) ELSE
    IF Temp = 'PUT_TEXT_FILE' THEN Do_PUT_TEXT_FILE(Command) ELSE
    IF Temp = 'RADIO_BUTTON' THEN Do_TRIANGLE(Command,1) ELSE
    IF Temp = 'RAISED_BOX' THEN Do_SQUARE(Command,6) ELSE
    IF Temp = 'RESET_PICKLIST' THEN Do_RESET_PICKLIST(Command) ELSE
    IF Temp = 'RESET_REMOTE' THEN Do_RESET_REMOTE ELSE
    IF Temp = 'RUN_TEXT_EDITOR' THEN Do_RUN_TEXT_EDITOR ELSE
    IF Temp = 'SETUP_PICKLIST' THEN Do_SETUP_PICKLIST ELSE
    IF Temp = 'SHADOW_TEXT' THEN Do_SHADOW_TEXT(Command) ELSE
    IF Temp = 'SHOW_MOUSE' THEN Do_SHOW_MOUSE ELSE
    IF Temp = 'SHOW_REMOTE_SCREEN' THEN Do_SHOW_REMOTE_SCREEN(Command) ELSE
    IF Temp = 'SHOW_TEXT_PAGE' THEN Do_SHOW_TEXT_PAGE ELSE
    IF Temp = 'SIREN' THEN Do_SIREN ELSE
    IF Temp = 'SMALL_ICON_LIB' THEN Do_SMALL_ICON_LIB(Command) ELSE
    IF Temp = 'STANDARD_TEXT' THEN Do_STANDARD_TEXT(Command) ELSE
    IF Temp = 'START_SCREEN' THEN Do_START_SCREEN ELSE
    IF Temp = 'START_TEXT_FILE' THEN Do_START_TEXT_FILE(Command) ELSE
    IF Temp = 'TEXT_VIEW_PORT' THEN Do_SQUARE(Command,11) ELSE
    IF Temp = 'USER_BUTTON' THEN Do_SQUARE(Command,10) ELSE
    IF Temp = 'WINDOW_DRAGGING' THEN Do_WINDOW_EFFECTS(Command,1);
  END;
  ScrStr := '';
END;

PROCEDURE GetUserInfo;
BEGIN
  IF Carrier THEN BEGIN
    SendStr(DD.UserName+#13+#10);
    SendStr(DD.Password+#13+#10);
    SendStr(#255#255#13#10);
  END;
END;

PROCEDURE GetResourceInfo;
VAR
  FName   : STRING;
  TheList : TEXT;
BEGIN
  {NOTE: The file RES.NFO is a list of all resources available on this
         system for the current BBS. This is a plain text file with the
         file name and its CRC32 value on the same line separated by
         one space. Each line is "Upper Cased" by default....}
  IF NOT Carrier THEN EXIT;
  IF NOT DebugOn THEN BEGIN
    RaisedBox(0,459,639,479);
    OutText_XY(272,461,4,2,'Sending Resource Info');
  END;
  ASSIGN(TheList,HomeDir+'\RES.NFO');
  RESET(TheList);
  WHILE NOT EOF(TheList) DO BEGIN
    READLN(TheList,FName);
    SendStr(FName+#13+#10);
  END;
  SendStr(#255#255#13#10);
  CLOSE(TheList);
  IF NOT DebugOn THEN BEGIN
    RaisedBox(0,459,639,479);
    OutText_XY(7,462,1,2,'Running Under '+OsStr);
    Show_Mem;
  END;
END;

PROCEDURE GetSystemInfo;
VAR
  Txt     : TEXT;
  InfoStr : STRING;
BEGIN
  WriteSystemInfo;
  IF NOT Carrier THEN EXIT;
  IF NOT DebugOn THEN BEGIN
    RaisedBox(0,459,639,479);
    OutText_XY(275,461,4,2,'Sending System Info');
  END;
  ASSIGN(Txt,HomeDir+'\SYSTEM.NFO');
  RESET(Txt);
  WHILE NOT EOF(Txt) DO BEGIN
    READLN(Txt,InfoStr);
    SendStr(InfoStr+#13+#10);
  END;
  SendStr(#255#255#13#10);
  CLOSE(Txt);
  IF NOT DebugOn THEN BEGIN
    RaisedBox(0,459,639,479);
    OutText_XY(7,462,1,2,'Running Under '+OsStr);
    Show_Mem;
  END;
END;

PROCEDURE CheckColorCommand(Command : STRING);
VAR
  CCode : CHAR;
  Color : INTEGER;
BEGIN
  CCode := Command[3];
  DELETE(Command,1,3);
  IF Command[LENGTH(Command)] = #255 THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    Color := StrToInt(Command);
    IF Color > 255 THEN Color := 0;
    FILLCHAR(_Max,SIZEOF(_Max),0);
    IF CCode IN [#127..#199] THEN BEGIN
      IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host sent a MAXcolor command.',' ',79));
    END;
    IF CCode IN [#127..#199] THEN WITH C DO CASE CCode OF
      {---- MAXcolor  Commands ----}
      #127 : Win1Back      := Color;
      #128 : Win4Back      := Color;
      #129 : Win1High      := Color;
      #130 : Win4High      := Color;
      #131 : Win1Low       := Color;
      #132 : Win4Low       := Color;
      #133 : Win1Frame1    := Color;
      #134 : Win1Frame2    := Color;
      #135 : Win4Frame     := Color;
      #136 : ActiveHdr     := Color;
      #137 : InactiveHdr   := Color;
      #138 : HdrTitle      := Color;
      #139 : ButtonFrame   := Color;
      #140 : ButtonFace    := Color;
      #141 : ButtonHigh    := Color;
      #142 : ButtonLow     := Color;
      #143 : ButtonHot     := Color;
      #144 : ButtonText    := Color;
      #145 : FrameHigh     := Color;
      #146 : FrameLow      := Color;
      #147 : BoxBack       := Color;
      #148 : BoxHigh       := Color;
      #149 : BoxLow        := Color;
      #150 : FieldTextHigh := Color;
      #151 : FieldTextLow  := Color;
      #152 : FieldBack     := Color;
     {#153 : FieldFrame    := Color;}
     {#154 : FieldHigh     := Color;}
      #155 : QuoteColor    := Color;
      #156 : MsgColor      := Color;
      #157 : TearColor     := Color;
      #158 : FlagColor     := Color;
      #159 : MsgIDcolor    := Color;
      #160 : TextBack      := Color;
      #161 : PickHighFore  := Color;
      #162 : PickHighBack  := Color;
      #163 : ScreenColor   := Color;
    END ELSE IF CCode IN [#200..#254] THEN CASE CCode OF
    {------- Special System Commands -------}
      #200 : BEGIN
               GetUserInfo;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host requested user name and password.',' ',79));
             END;
      #201 : BEGIN
               GetResourceInfo;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host requested a graphics resource list.',' ',79));
             END;
      #202 : BEGIN
               DownPath1 := SesPath;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Download path changed to ' + DownPath1,' ',79));
             END;
      #203 : BEGIN
               DownPath1 := ResPath;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Download path changed to ' + DownPath1,' ',79));
             END;
      #204 : BEGIN
               DownPath1 := DownPath2;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Download path changed to ' + DownPath1,' ',79));
             END;
      #205 : BEGIN
               GetSystemInfo;
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host requested a system information report.',' ',79));
             END;
      #206 : BEGIN
               Command := GetFileName(StripBoth(Command,#39));
               IF POS('ICON_LIB.',Command) = 0 THEN FErase(SesPath+Command);
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host erasing ' + SesPath+Command,' ',79));
             END;
      #207 : BEGIN
               Command := GetFileName(StripBoth(Command,#39));
               IF Command <> 'DEFAULT.PKG' THEN FErase(ResPath+Command);
               IF DebugOn THEN OutTextXY(1,24,10,0,PadRight('Host erasing ' + ResPath+Command,' ',79));
             END;
      #208 : IF NOT DebugOn THEN BEGIN
               IF WindowNumber > 2 THEN REPEAT Kill_Window UNTIL WindowNumber = 2;
               IndexResources;
               IF NOT MouseOn THEN HideMouse;
             END ELSE BEGIN
               OutTextXY(1,24,10,0,PadRight('Host re-indexing resource list.',' ',79));
               IndexResources;
             END;
    END;
    {---------------------------------------}
  END;
  ScrStr := '';
END;

BEGIN
  ResPath   := '';
  SesPath   := '';
  DownPath1 := '';
  DownPath2 := '';
  ScrStr    := '';
END.
