{$I DEFINES.INC}
UNIT _PROTO2;

INTERFACE

PROCEDURE TransmitFiles(Filename : STRING; Protocl : BYTE);
PROCEDURE ReceiveFiles(Filename : STRING; Protocl : BYTE);

IMPLEMENTATION

USES MyCrt,Dos,FgMain,Gui_Unit,Gui_Util,MxModem2,ApVars,ApMisc,ApTimer,ApPort,
     ApUart,ApCom,ApAbsPcl,ApXmodem,ApYmodem,ApZmodem,ApFossil,ApDigi14;

TYPE TransferModeType = (Transmit,Receive);

VAR
  Proto        : ProtocolRecPtr;
  TProtocol    : BYTE;
  TransferMode : TransferModeType;
  OldFile,
  SrcFileName  : STRING[80];

FUNCTION KbdAbort : BOOLEAN;
CONST
  Escape = #$1B;
VAR
  Ch     : CHAR;
BEGIN
  KbdAbort := FALSE;
  IF KEYPRESSED THEN BEGIN
    Ch := READKEY;
    IF Ch = #0 THEN Ch := READKEY;
    IF Ch = Escape THEN BEGIN
      KbdAbort := TRUE;
      WeAbort  := TRUE;
    END;
  END;
END;

FUNCTION GetNextFile(PROTO : ProtocolRecPtr; VAR FName : PathStr) : BOOLEAN;
BEGIN
  INC(CurrentFileNum);
  FName := FileQueue[CurrentFileNum];
  IF (CurrentFileNum > FilesInQueue) THEN BEGIN
    GetNextFile := FALSE;
    FName       := '';
  END ELSE GetNextFile := TRUE;
END;

FUNCTION FormatMinSec(TotalSecs : LONGINT) : STRING;
VAR
  Min,Sec : LONGINT;
  S       : STRING;
BEGIN
  Min := TotalSecs DIV 60;
  Sec := TotalSecs MOD 60;
  STR(Sec : 2,S);
  IF S[1] = ' ' THEN S[1] := '0';
  FormatMinSec := PadRight(IntToStr(Min) + ':' + S,' ',6);
END;

PROCEDURE WindowStatus(P : ProtocolRecPtr; Starting,Ending : BOOLEAN);
CONST
  Progress : STRING[30] = '';
VAR
  CurFileSize         : LONGINT;
  CurBytesRemaining   : LONGINT;
  CurBytesTransferred : LONGINT;
  CurProtocol         : LONGINT;
  CurElapsedTics      : LONGINT;
  LastBytesSent       : LONGINT;
  S                   : STRING;
  R                   : LONGINT;
  ActualCPS           : LONGINT;
  Temp                : STRING;
  Work                : WORD;

PROCEDURE ClearProgress;
BEGIN
  FG_SetColor(C.Win1Frame2);
  FG_Box(189,430,265,282);
  FG_SetColor(1);
  FG_Rect(190,429,266,281);
END;

BEGIN
  IF Starting THEN BEGIN
    OldFile := '';
    HideMouse;
    IF Doing_Receive THEN Draw_Window(171,165,450,300,5,'Receiving File(s)')
                     ELSE Draw_Window(171,165,450,300,5,'Sending File(s)');
    OutText_XY(180,192,1,2,'Protocol:');
    OutText_XY(209,207,1,2,'File:');
    OutText_XY(205,222,1,2,'Size:');
    IF Doing_Receive THEN OutText_XY(201,237,1,2,'Rcvd:')
                     ELSE OutText_XY(203,237,1,2,'Sent:');
    OutText_XY(350,192,1,2,'Baud:');
    OutText_XY(350,207,1,2,'Time:');
    OutText_XY(354,222,1,2,'Left:');
    OutText_XY(359,237,1,2,'CPS:');
    {Progress Indicator}
    FrameLow(180,257,440,290);
    ClearProgress;
    {Baud Rate}
    OutText_XY(385,192,0,2,IntToStr(ActualBaud));
    {Protocol}
    CurProtocol := GetProtocol(P);
    S           := ProtocolTypeString[CurProtocol];
    CASE GetCheckType(P) OF
      bcCrc16 : S := S + '/CRC16';
      bcCrc32 : S := S + '/CRC32';
      bcCrcK  : S := S + '/CRC';
    END;
    OutText_XY(235,192,0,2,S);
  END;
  {Update the data areas}
  IF ((NOT(Starting)) AND (NOT(Ending))) THEN BEGIN
    WITH P^.PData^ DO BEGIN
      CurFileSize         := GetFileSize(P);
      CurBytesRemaining   := GetBytesRemaining(P);
      CurBytesTransferred := GetBytesTransferred(P);
      CurElapsedTics      := GetElapsedTics(P);
      {File Name}
      IF OldFile <> GetFileName(P) THEN BEGIN
        FG_SetColor(C.Win1Back);
        FG_Rect(235,340,207,221);
        OutText_XY(235,207,0,2,GetFileName(P));
      END;
      {File Size}
      IF OldFile <> GetFileName(P) THEN BEGIN
        IF CurFileSize = 0 THEN S := '' ELSE S := IntToStr(CurFileSize);
        FG_SetColor(C.Win1Back);
        FG_Rect(235,340,222,236);
        OutText_XY(235,222,0,2,S);
      END;
      {Bytes Transferred}
      FG_SetColor(C.Win1Back);
      FG_Rect(235,340,237,251);
      OutText_XY(235,237,0,2,IntToStr(CurBytesTransferred));
      {Estimated Time}
      IF OldFile <> GetFileName(P) THEN BEGIN
        FG_SetColor(C.Win1Back);
        FG_Rect(385,440,207,221);
        OutText_XY(385,207,0,2,FormatMinSec(EstimateTransferSecs(P,CurFileSize)));
      END;
      {Time Remaining}
      FG_SetColor(C.Win1Back);
      FG_Rect(385,440,222,236);
      OutText_XY(385,222,0,2,FormatMinSec(EstimateTransferSecs(P,CurBytesRemaining)));
      {CPS}
      IF CurElapsedTics > 0 THEN BEGIN
        R         := CurBytesTransferred - GetInitialFilePos(P);
        ActualCPS := TRUNC(R / (CurElapsedTics / 18.2));
      END ELSE ActualCPS := 0;
      FG_SetColor(C.Win1Back);
      FG_Rect(385,440,237,251);
      OutText_XY(385,237,0,2,IntToStr(ActualCPS));
      {Progress Indicator}
      IF CurFileSize = 0 THEN ClearProgress ELSE BEGIN
        Work := TRUNC((CurBytesTransferred / CurFileSize) * 30);
        IF ((Work > 0) AND (Work < 31)) THEN BEGIN
          MOVE(Progress[1],Temp[1],Work);
          Temp[0] := CHR(Work);
          OutText_XY(190,266,9,3,Temp);
        END ELSE ClearProgress;
      END;
      IF OldFile <> GetFileName(P) THEN OldFile := GetFileName(P);
    END;
  END;
END;

PROCEDURE TransferFiles;

PROCEDURE DoFinishParams;
BEGIN
  CASE TProtocol OF
    Xmodem,
    Xmodem1K,
    Xmodem1KG : BEGIN
                  SetFinishWaitXM(PROTO,Secs2Tics(20));
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
    Ymodem,
    YmodemG   : BEGIN
                  SetFinishWaitXM(PROTO,Secs2Tics(20));
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
    Zmodem    : BEGIN
                  SetFinishWaitZM(PROTO,Secs2Tics(20),3);
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
  END;
END;

BEGIN
  SetAbortFunc(BBSPort,KbdAbort);
  DefProtocolOptions := 0;
  CASE TProtocol OF
    Xmodem,
    Xmodem1K,
    Xmodem1KG : BEGIN
                  InitXmodem(PROTO,BBSPort,(TProtocol = Xmodem1K),TProtocol = Xmodem1KG);
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    SetBlockWait(PROTO,RelaxedBlockWait);
                    DoFinishParams;
                    SetShowStatusProc(PROTO,WindowStatus);
                    SetOverwriteOption(PROTO,WriteRename);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : BEGIN
                                   SetFileMask(PROTO,SrcFileName);
                                   ProtocolTransmitXM(PROTO);
                                 END;
                      Receive  : BEGIN
                                   SetReceiveFileName(PROTO,SrcFileName);
                                   ProtocolReceiveXM(PROTO);
                                 END;
                    END;
                    DoneXmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                  END;
                END;
     Ymodem,
     YmodemG  : BEGIN
                  InitYmodem(PROTO,BBSPort,TRUE,(TProtocol = YmodemG));
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    IF transferMode = transmit THEN SetNextFileFunc(PROTO,GetNextFile);
                    SetShowStatusProc(PROTO,WindowStatus);
                    SetBlockWait(PROTO,RelaxedBlockWait);
                    DoFinishParams;
                    SetOverwriteOption(PROTO,WriteRename);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : ProtocolTransmitYM(PROTO);
                      Receive  : BEGIN
                                   SetDestinationDirectory(PROTO,NoPath(SrcFileName));
                                   ProtocolReceiveYM(PROTO);
                                 END;
                    END;
                    DoneYmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                    IF TransferMode = Receive THEN PutChar(BBSPort,#6);
                  END;
                END;
     Zmodem   : BEGIN
                  InitZmodem(PROTO,BBSPort);
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    IF transferMode = transmit THEN SetNextFileFunc(PROTO,GetNextFile);
                    SetShowStatusProc(PROTO,WindowStatus);
                    DoFinishParams;
                    SetRecoverOption(PROTO,TRUE);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : ProtocolTransmitZM(PROTO);
                      Receive  : BEGIN
                                   SetDestinationDirectory(PROTO,NoPath(SrcFileName));
                                   ProtocolReceiveZM(PROTO);
                                 END;
                    END;
                    DoneZmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                  END;
                END;
  END;
END;

PROCEDURE HandleAbort;
BEGIN
  IF WeAbort THEN BEGIN
    IF Doing_Receive THEN FlushInBuffer(BBSPort) ELSE FlushOutBuffer(BBSPort);
    PutString(BBSPort,#24#24#24#24#24);
    DELAY(2000);
    FlushOutBuffer(BBSPort);
    FlushInBuffer(BBSPort);
  END ELSE BEGIN
    IF AbortedProtocol THEN BEGIN
      DELAY(2000);
      FlushOutBuffer(BBSPort);
      FlushInBuffer(BBSPort);
    END ELSE DELAY(2000);
  END;
END;

PROCEDURE TransmitFiles(Filename : STRING; Protocl : BYTE);
BEGIN
  Doing_Receive := FALSE;
  WeAbort       := FALSE;
  CASE Protocl OF
    1 : TProtocol := ZModem;
    2 : TProtocol := XModem;
    3 : TProtocol := XModem1K;
    4 : TProtocol := YModem;
    5 : TProtocol := YModemG;
    6 : BEGIN
          IF FilesInQueue = 1 THEN FileQueue[1] := Filename;
          WorkPath := FixPath(Filename);
          SendMaxModem;
        END;
  END;
  TransferMode   := Transmit;
  SrcFilename    := FileName;
  CurrentFileNum := 0;
  SetDTR(BBSPort,TRUE);
  SetRTS(BBSPort,TRUE);
  IF Protocl <> 6 THEN BEGIN
    TransferFiles;
    HandleAbort;
    Kill_Window;
  END;
END;

PROCEDURE ReceiveFiles(Filename : STRING; Protocl : BYTE);
BEGIN
  Doing_Receive := TRUE;
  WeAbort      := FALSE;
  CASE Protocl OF
    1 : TProtocol := ZModem;
    2 : TProtocol := XModem;
    3 : TProtocol := XModem1K;
    4 : TProtocol := YModem;
    5 : TProtocol := YModemG;
    6 : BEGIN
          WorkPath := FixPath(Filename);
          ReceiveMaxModem;
        END;
  END;
  TransferMode   := Receive;
  SrcFilename    := FileName;
  CurrentFileNum := 0;
  SetDTR(BBSPort,TRUE);
  SetRTS(BBSPort,TRUE);
  IF Protocl <> 6 THEN BEGIN
    TransferFiles;
    HandleAbort;
    Kill_Window;
  END;
END;

END.
