{$I DEFINES.INC}
UNIT _PROTO;

INTERFACE

USES MyCrt,Dos,TextUnit,Gui_Util,MxModem1,ApVars,ApMisc,ApTimer,ApPort,ApUart,
     ApCom,ApAbsPcl,ApXmodem,ApYmodem,ApZmodem,ApFossil,ApDigi14;

PROCEDURE TransmitFiles(Filename : STRING; Protocl : BYTE);
PROCEDURE ReceiveFiles(Filename : STRING; Protocl : BYTE);

IMPLEMENTATION

TYPE InfoRec  = RECORD
     Protocol : ARRAY[1..2] OF BYTE;
     FileName : ARRAY[1..2] OF BYTE;
     Size     : ARRAY[1..2] OF BYTE;
     Sent     : ARRAY[1..2] OF BYTE;
     Speed    : ARRAY[1..2] OF BYTE;
     Time     : ARRAY[1..2] OF BYTE;
     Left     : ARRAY[1..2] OF BYTE;
     CPS      : ARRAY[1..2] OF BYTE;
     END;

TYPE TransferModeType = (Transmit,Receive);

VAR
  PROTO        : ProtocolRecPtr;
  TProtocol    : BYTE;
  TransferMode : TransferModeType;
  SrcFileName  : STRING[80];
  Info         : InfoRec;

{.$F+}
FUNCTION KbdAbort : BOOLEAN;
CONST
  Escape = #$1B;
VAR
  Ch     : CHAR;
BEGIN
  KbdAbort := FALSE;
  IF KEYPRESSED THEN BEGIN
    Ch := READKEY;
    IF Ch = #0 THEN Ch := READKEY;
    IF Ch = Escape THEN BEGIN
      KbdAbort := TRUE;
      WeAbort  := TRUE;
    END;
  END;
END;
{.$F-}

{.$F+}
FUNCTION GetNextFile(PROTO : ProtocolRecPtr; VAR FName : PathStr) : BOOLEAN;
BEGIN
  INC(CurrentFileNum);
  FName := FileQueue[CurrentFileNum];
  IF (CurrentFileNum > FilesInQueue) THEN BEGIN
    GetNextFile := FALSE;
    FName       := '';
  END ELSE GetNextFile := TRUE;
END;
{.$F-}

FUNCTION FormatMinSec(TotalSecs : LONGINT) : STRING;
VAR
  Min,Sec : LONGINT;
  S       : STRING;
BEGIN
  Min := TotalSecs DIV 60;
  Sec := TotalSecs MOD 60;
  STR(Sec : 2,S);
  IF S[1] = ' ' THEN S[1] := '0';
  FormatMinSec := PadRight(IntToStr(Min) + ':' + S,' ',6);
END;

{.$F+}
PROCEDURE WindowStatus(P : ProtocolRecPtr; Starting,Ending : BOOLEAN);
CONST
  Progress : STRING[30] = '';
VAR
  CurFileSize         : LONGINT;
  CurBytesRemaining   : LONGINT;
  CurBytesTransferred : LONGINT;
  CurProtocol         : LONGINT;
  CurElapsedTics      : LONGINT;
  LastBytesSent       : LONGINT;
  S                   : STRING;
  R                   : LONGINT;
  ActualCPS           : LONGINT;
  Temp                : STRING;
  Work                : WORD;

PROCEDURE ClearProgress;
BEGIN
  OutTextXY(27,15,1,0,'');
END;

BEGIN
  IF Starting THEN BEGIN
    IF Doing_Receive THEN DrawWindow(18,8,65,17,'Receiving File(s)')
                     ELSE DrawWindow(18,8,65,17,'Sending File(s)');
    OutTextXY(21,10,11,1,' Protocol:                   Baud:  ');
    OutTextXY(21,11,11,1,'     File:                   Time:  ');
    OutTextXY(21,12,11,1,'     Size:                   Left:  ');
    IF Doing_Receive THEN OutTextXY(21,13,11,1,'     Rcvd:                    CPS:  ')
                     ELSE OutTextXY(21,13,11,1,'     Sent:                    CPS:  ');
    {Progress indicator}
    InvertedBox(25,14,58,16);
    ClearProgress;
    {Baud Rate}
    OutTextXY(Info.Speed[1],Info.Speed[2],15,1,IntToStr(ActualBaud));
    {Protocol}
    CurProtocol := GetProtocol(P);
    S           := ProtocolTypeString[CurProtocol];
    CASE GetCheckType(P) OF
      bcCrc16 : S := S + '/CRC16';
      bcCrc32 : S := S + '/CRC32';
      bcCrcK  : S := S + '/CRC';
    END;
    OutTextXY(Info.Protocol[1],Info.Protocol[2],15,1,S);
  END;
  {Update the data areas}
  IF ((NOT(Starting)) AND (NOT(Ending))) THEN BEGIN
    WITH P^.PData^ DO BEGIN
      CurFileSize         := GetFileSize(P);
      CurBytesRemaining   := GetBytesRemaining(P);
      CurBytesTransferred := GetBytesTransferred(P);
      CurElapsedTics      := GetElapsedTics(P);
      {File Name}
      OutTextXY(Info.FileName[1],Info.FileName[2],15,1,PadRight(GetFileName(P),' ',12));
      {File Size}
      IF CurFileSize = 0 THEN S := '' ELSE S := IntToStr(CurFileSize);
      OutTextXY(Info.Size[1],Info.Size[2],15,1,PadRight(S,' ',9));
      {Estimated time}
      OutTextXY(Info.Time[1],Info.Time[2],15,1,FormatMinSec(EstimateTransferSecs(P,CurFileSize)));
      {Time remaining}
      OutTextXY(Info.Left[1],Info.Left[2],15,1,FormatMinSec(EstimateTransferSecs(P,CurBytesRemaining)));
      {Bytes Transferred}
      OutTextXY(Info.Sent[1],Info.Sent[2],15,1,PadRight(IntToStr(CurBytesTransferred),' ',9));
      {CPS}
      IF CurElapsedTics > 0 THEN BEGIN
        R         := CurBytesTransferred - GetInitialFilePos(P);
        ActualCPS := TRUNC(R / (CurElapsedTics / 18.2));
      END ELSE ActualCPS := 0;
      OutTextXY(Info.CPS[1],Info.CPS[2],15,1,PadRight(IntToStr(ActualCPS),' ',6));
      {Progress Indicator}
      IF CurFileSize = 0 THEN ClearProgress
      ELSE BEGIN
        Work := TRUNC((CurBytesTransferred / CurFileSize) * 30);
        IF ((Work > 0) AND (Work < 31)) THEN BEGIN
          MOVE(Progress[1],Temp[1],Work);
          Temp[0] := CHR(Work);
          OutTextXY(27,15,9,0,Temp);
        END ELSE ClearProgress;
      END;
    END;
  END;
END;
{.$F-}

PROCEDURE TransferFiles;

PROCEDURE DoFinishParams;
BEGIN
  CASE TProtocol OF
    Xmodem,
    Xmodem1K,
    Xmodem1KG : BEGIN
                  SetFinishWaitXM(PROTO,Secs2Tics(20));
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
    Ymodem,
    YmodemG   : BEGIN
                  SetFinishWaitXM(PROTO,Secs2Tics(20));
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
    Zmodem    : BEGIN
                  SetFinishWaitZM(PROTO,Secs2Tics(20),3);
                  SetHandshakeWait(PROTO,Secs2Tics(5),10);
                END;
  END;
END;

BEGIN
  SetAbortFunc(BBSPort,KbdAbort);
  DefProtocolOptions := 0;
  CASE TProtocol OF
    Xmodem,
    Xmodem1K,
    Xmodem1KG : BEGIN
                  InitXmodem(PROTO,BBSPort,(TProtocol = Xmodem1K),TProtocol = Xmodem1KG);
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    SetBlockWait(PROTO,RelaxedBlockWait);
                    DoFinishParams;
                    SetShowStatusProc(PROTO,WindowStatus);
                    SetOverwriteOption(PROTO,WriteRename);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : BEGIN
                                   SetFileMask(PROTO,SrcFileName);
                                   ProtocolTransmitXM(PROTO);
                                 END;
                      Receive  : BEGIN
                                   SetReceiveFileName(PROTO,SrcFileName);
                                   ProtocolReceiveXM(PROTO);
                                 END;
                    END;
                    DoneXmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                  END;
                END;
     Ymodem,
     YmodemG  : BEGIN
                  InitYmodem(PROTO,BBSPort,TRUE,(TProtocol = YmodemG));
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    IF transferMode = transmit THEN SetNextFileFunc(PROTO,GetNextFile);
                    SetShowStatusProc(PROTO,WindowStatus);
                    SetBlockWait(PROTO,RelaxedBlockWait);
                    DoFinishParams;
                    SetOverwriteOption(PROTO,WriteRename);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : ProtocolTransmitYM(PROTO);
                      Receive  : BEGIN
                                   SetDestinationDirectory(PROTO,NoPath(SrcFileName));
                                   ProtocolReceiveYM(PROTO);
                                 END;
                    END;
                    DoneYmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                    IF TransferMode = Receive THEN PutChar(BBSPort,#6);
                  END;
                END;
     Zmodem   : BEGIN
                  InitZmodem(PROTO,BBSPort);
                  IF GetAsyncStatus = ecOk THEN BEGIN
                    IF transferMode = transmit THEN SetNextFileFunc(PROTO,GetNextFile);
                    SetShowStatusProc(PROTO,WindowStatus);
                    DoFinishParams;
                    SetRecoverOption(PROTO,TRUE);
                    SetActualBps(PROTO,ActualBaud);
                    CASE TransferMode OF
                      Transmit : ProtocolTransmitZM(PROTO);
                      Receive  : BEGIN
                                   SetDestinationDirectory(PROTO,NoPath(SrcFileName));
                                   ProtocolReceiveZM(PROTO);
                                 END;
                    END;
                    DoneZmodem(PROTO);
                    IF GetAsyncStatus <> ecOk THEN AbortedProtocol := TRUE;
                  END;
                END;
  END;
END;

PROCEDURE HandleAbort;
BEGIN
  IF WeAbort THEN BEGIN
    IF Doing_Receive THEN FlushInBuffer(BBSPort) ELSE FlushOutBuffer(BBSPort);
    PutString(BBSPort,#24#24#24#24#24);
    DELAY(2000);
    FlushOutBuffer(BBSPort);
    FlushInBuffer(BBSPort);
  END ELSE BEGIN
    IF AbortedProtocol THEN BEGIN
      DELAY(2000);
      FlushOutBuffer(BBSPort);
      FlushInBuffer(BBSPort);
    END ELSE DELAY(2000);
  END;
END;

PROCEDURE TransmitFiles(Filename : STRING; Protocl : BYTE);
BEGIN
  Doing_Receive := FALSE;
  WeAbort       := FALSE;
  CASE Protocl OF
    1 : TProtocol := ZModem;
    2 : TProtocol := XModem;
    3 : TProtocol := XModem1K;
    4 : TProtocol := YModem;
    5 : TProtocol := YModemG;
    6 : BEGIN
          IF FilesInQueue = 1 THEN FileQueue[1] := Filename;
          WorkPath := FixPath(Filename);
          SendMaxModem;
        END;
  END;
  TransferMode   := Transmit;
  SrcFilename    := FileName;
  CurrentFileNum := 0;
  SetDTR(BBSPort,TRUE);
  SetRTS(BBSPort,TRUE);
  IF Protocl <> 6 THEN BEGIN
    HideCursor;
    TransferFiles;
    HandleAbort;
    KillWindow;
    ShowCursor;
  END;
END;

PROCEDURE ReceiveFiles(Filename : STRING; Protocl : BYTE);
BEGIN
  Doing_Receive := TRUE;
  WeAbort       := FALSE;
  CASE Protocl OF
    1 : TProtocol := ZModem;
    2 : TProtocol := XModem;
    3 : TProtocol := XModem1K;
    4 : TProtocol := YModem;
    5 : TProtocol := YModemG;
    6 : BEGIN
          WorkPath := FixPath(Filename);
          ReceiveMaxModem;
        END;
  END;
  TransferMode   := Receive;
  SrcFilename    := FileName;
  CurrentFileNum := 0;
  SetDTR(BBSPort,TRUE);
  SetRTS(BBSPort,TRUE);
  IF Protocl <> 6 THEN BEGIN
    HideCursor;
    TransferFiles;
    HandleAbort;
    KillWindow;
    ShowCursor;
  END;
END;

BEGIN
  Info.Protocol[1] := 32;  Info.Protocol[2] := 10;
  Info.FileName[1] := 32;  Info.FileName[2] := 11;
  Info.Size[1]     := 32;  Info.Size[2]     := 12;
  Info.Sent[1]     := 32;  Info.Sent[2]     := 13;
  Info.Speed[1]    := 56;  Info.Speed[2]    := 10;
  Info.Time[1]     := 56;  Info.Time[2]     := 11;
  Info.Left[1]     := 56;  Info.Left[2]     := 12;
  Info.CPS[1]      := 56;  Info.CPS[2]      := 13;
END.
