{$I DEFINES.INC}
UNIT WAV_UNIT;

INTERFACE

PROCEDURE InitWavUnit(P,I,D,H : STRING);
PROCEDURE PlayWAV(FName : STRING);

IMPLEMENTATION

USES MYCRT, DOS, GUI_UTIL, APTIMER;

CONST Dma       = 4096;
TYPE  Id_T      = ARRAY[1..4] OF CHAR;
TYPE  Riff_T    = RECORD
      R_Ident   : Id_T;
      Length    : LONGINT;
      C_Ident   : Id_T;
      S_Ident   : Id_T;
      S_Length  : LONGINT;
      Format,
      Modus     : WORD;
      Freq,
      Byte_P_S  : LONGINT;
      Byte_Sam,
      Bit_Sam   : WORD;
      D_Ident   : Id_T;
      D_Length  : LONGINT;
      END;

TYPE  Blaster_T = RECORD
      Port      : WORD;
      Dmac,
      HDmac,
      Irq       : BYTE;
      END;

TYPE  Buffer_T  = ARRAY[1..Dma] OF BYTE;

VAR ID          : Riff_T;
    FN          : STRING[80];
    Wav         : FILE;
    Sbb         : WORD;
    Ende        : BOOLEAN;
    Blaster     : Blaster_T;
    Alt_Irq     : POINTER;
    Dma_Buf_1,
    Dma_Buf_2,
    Zwi         : ^Buffer_T;
    Channel     : BYTE;

CONST RIFF      : id_t = ('R','I','F','F');
      WAVE      : id_t = ('W','A','V','E');
      FMT_      : id_t = ('f','m','t',' ');
      DATA      : id_t = ('d','a','t','a');
      DMA_Dat   : ARRAY [0..7,1..6] OF BYTE = (($A,$C,$B,$0,$87,$1),
                                               ($A,$C,$B,$2,$83,$3),
                                               ($A,$C,$B,$4,$81,$5),
                                               ($A,$C,$B,$6,$82,$7),
                                               ($D4,$D8,$D6,$C0,$8F,$C2),
                                               ($D4,$D8,$D6,$C4,$8B,$C6),
                                               ($D4,$D8,$D6,$C8,$89,$CA),
                                               ($D4,$D8,$D6,$CC,$8A,$CE));

PROCEDURE Blaster_Command(C : BYTE); Assembler;
Asm
  Mov dx,WORD PTR sbb
  Add dx,$c
@t : IN al,dx
  AND al,128
  Jnz @t
  Mov al,c
  Out dx,al
END;

FUNCTION Init_SB(Base : WORD) : BOOLEAN;
VAR
  W,W2 : WORD;
BEGIN
  Init_SB := FALSE;
  Sbb     := Base;
  Port[Base + 6] := 1;
  DELAY(4);
  Port[Base + 6] := 0;
  W  := 0;
  W2 := 0;
  REPEAT
    REPEAT INC(W) UNTIL ((Port[Base + $E] AND 128) = 128) OR (W > 29);
    INC(W2);
  UNTIL (Port[Base + $A] = $AA) OR (W2 > 30);
  IF W2 > 30 THEN EXIT;
  Blaster_Command($D1);
  Init_SB := TRUE;
END;

PROCEDURE Set_Stereo; Assembler;
Asm
  Mov dx,WORD PTR sbb
  Add dx,$4
  Mov al,$e
  Out dx,al
  INC dx
  IN  al,dx
  AND al,253
  OR  al,2
  Out dx,al
END;

PROCEDURE Clear_Stereo; Assembler;
Asm
  Mov dx,WORD PTR sbb
  Add dx,$4
  Mov al,$e
  Out dx,al
  INC dx
  IN  al,dx
  AND al,253
  Out dx,al
END;

FUNCTION No_Wave(VAR ID : Riff_T) : BOOLEAN;

BEGIN
  WITH ID DO No_Wave := (R_Ident <> RIFF) OR
                        (C_Ident <> WAVE) OR
                        (S_Ident <> FMT_) OR
                        (D_Ident <> DATA);
END;

FUNCTION Init : BOOLEAN;
VAR
  B : BYTE;
BEGIN
  Init := FALSE;
  IF NOT Init_SB(Blaster.Port) THEN EXIT;
  ASSIGN(Wav,FN);
  RESET(Wav,1);
  BLOCKREAD(Wav,ID,SIZEOF(ID));
  IF No_Wave(ID) THEN BEGIN
    CLOSE(Wav);
    EXIT;
  END;
  IF ID.Modus = 2 THEN Set_Stereo ELSE Clear_Stereo;
  IF (ID.Bit_Sam > 8) AND (Blaster.Hdmac > 3) THEN Channel := Blaster.hDmac
                                              ELSE Channel := Blaster.Dmac;
  Init := TRUE;
END;

PROCEDURE Stelle_DMA(Freq : WORD; VAR size : WORD);
VAR
  PageNr,PageAdress,DMALength : WORD;
BEGIN
  INLINE($FA);
  Asm
    Mov ax,WORD PTR DMA_Buf_1[2]
    SHR ax,12
    Mov WORD PTR PageNr,ax
    Mov ax,WORD PTR DMA_Buf_1[2]
    SHL ax,4
    Mov WORD PTR PageAdress,ax
    Mov ax,WORD PTR DMA_Buf_1
    Add WORD PTR PageAdress,ax
    Adc WORD PTR PageNr,0
  END;
  DMALength := Size;
  Freq := 256 - TRUNC(1000000 / Freq);
  IF Channel > 3 THEN BEGIN
    DMALength := DMALength DIV 2;
    PageAdress := PageAdress DIV 2;
    IF ODD(PageNr) THEN BEGIN
      DEC(PageNr);
      PageAdress := PageAdress + $8000
    END;
  END;
  IF id.Modus = 2 THEN BEGIN
    IF id.bit_sam = 16 THEN Blaster_Command($A4)
                       ELSE Blaster_Command($A8);
  END ELSE IF id.bit_sam = 16 THEN Blaster_Command($A4);
  DEC(DMALength);
  Port[DMA_dat[Channel,1]] := $4 OR (Channel AND $3);
  Port[DMA_dat[Channel,2]] := $0;
  Port[DMA_dat[Channel,3]] := $49;
  Port[DMA_dat[Channel,4]] := LO(PageAdress);
  Port[DMA_dat[Channel,4]] := HI(PageAdress);
  Port[DMA_dat[Channel,5]] := LO(PageNr);
  Port[DMA_dat[Channel,6]] := LO(DMALength);
  Port[DMA_dat[Channel,6]] := HI(DMALength);
  Port[DMA_dat[Channel,1]] := (Channel AND $3);
  Blaster_Command($40);
  Blaster_Command(LO(Freq));
  Blaster_Command($48);
  Blaster_Command(LO(DMALength));
  Blaster_Command(HI(DMALength));
  Blaster_Command($91);
  INLINE($FB);
END;

PROCEDURE Ausgabe_IRQ; INTERRUPT;
VAR
  Test : BYTE;
BEGIN
  INLINE($FA);
  Port[$20] := $20;
  Test      := Port[Sbb + $E];
  Ende      := TRUE;
  INLINE($FB);
END;

PROCEDURE Play;
VAR
  P,S,S2 : WORD;
  W      : LONGINT;
BEGIN
  GETMEM(zwi,16);
  GETMEM(dma_buf_1,dma);
  P := 16;
  WHILE (SEG(dma_buf_1^[1]) MOD 4096) > (4096 - (dma * 2 DIV 16)) DO BEGIN
    FREEMEM(dma_buf_1,dma);
    FREEMEM(zwi,p);
    INC(P,16);
    IF P > 65525 THEN HALT;
    GETMEM(zwi,p);
    GETMEM(dma_buf_1,dma);
  END;
  GETMEM(dma_buf_2,dma);
  FREEMEM(zwi,p);
  Port[$21] := Port[$21] AND (255 XOR (1 SHL Blaster.IRQ));
  GETINTVEC(Blaster.IRQ + 8,Alt_irq);
  SETINTVEC(Blaster.IRQ + 8,@Ausgabe_IRQ);
  W := id.freq * id.modus;
  BLOCKREAD(wav,dma_buf_1^[1],dma,s);
  REPEAT
    Ende := FALSE;
    Stelle_DMA(W,S);
    BLOCKREAD(wav,dma_buf_2^[1],dma,s2);
    REPEAT UNTIL Ende;
    S         := s2;
    Zwi       := Dma_buf_1;
    Dma_buf_1 := Dma_buf_2;
    Dma_buf_2 := Zwi;
  UNTIL EOF(Wav) OR KEYPRESSED;
  WHILE KEYPRESSED DO READKEY;
  IF EOF(Wav) THEN BEGIN
    Ende := FALSE;
    Stelle_DMA(W,S);
    REPEAT UNTIL Ende;
  END;
  SETINTVEC(Blaster.IRQ + 8,Alt_IRQ);
  FREEMEM(dma_buf_1,dma);
  FREEMEM(dma_buf_2,dma);
  Port[$21] := Port[$21] OR (1 SHL Blaster.IRQ);
  Blaster_Command($D3);
  CLOSE(Wav);
END;

PROCEDURE InitWavUnit(P,I,D,H : STRING);
BEGIN
  Blaster.Port  := HexToInt('$'+P);
  Blaster.Dmac  := StrToInt(D);
  Blaster.HDmac := ORD(H[1]) - 48;
  Blaster.Irq   := StrToInt(I);
END;

PROCEDURE PlayWAV(FName : STRING);
BEGIN
  IF NOT FExist(FName) THEN EXIT ELSE FN := FName;
  IF Init THEN Play;
END;

END.
