{       SBDSP is Copyright 1994 by Ethan Brodsky.  All rights reserved.      }
{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT VOICE;

INTERFACE

CONST
  EndBlockNum            = 0;
  VoiceBlockNum          = 1;
  VoiceContinueBlockNum  = 2;
  SilenceBlockNum        = 3;
  MarkerBlockNum         = 4;
  MessageBlockNum        = 5;
  RepeatBlockNum         = 6;
  RepeatEndBlockNum      = 7;
  ExtendedInfoBlockNum   = 8;
  NewVoiceBlockNum       = 9;
 {BlockNames : ARRAY[0..9] OF STRING = ('Terminator',
                                        'Voice Data',
                                        'Voice Continuation',
                                        'Silence',
                                        'Marker',
                                        'Message',
                                        'Repeat Loop',
                                        'End Repeat Loop',
                                        'Extended Info',
                                        'New Voice Data');}
 {Used in block type 1 and 8}
 {Unpacked8  = 0; {8 bit (Uncompressed)}
 {Packed4    = 1; {4 bit}
 {Packed26   = 2; {2.6 bit}
 {Packed2    = 3; {2 bit}
 {PackingNames : ARRAY[0..10] OF STRING = ('8 bit unpacked',
                                           '4 bit packed',
                                           '2.6 bit packed',
                                           '2 bit packed',
                                           '1 channel multi',
                                           '2 channel multi',
                                           '3 channel multi',
                                           '4 channel multi',
                                           '5 channel multi',
                                           '6 channel multi',
                                           '7 channel multi');}
 {Used in block type 9}
 {Uncompressed8     = $0000;
  Compressed4       = $0001;
  Compressed26      = $0002;
  Compressed2       = $0003;
  Uncompressed16    = $0004;
  CompressedALAW    = $0006;
  CompressedMULAW   = $0007;
  CompressedADPCM   = $0200; {Why couldn't they make this $0008?}
 {CompressionNames  : ARRAY[0..7] OF STRING = ('8 bit uncompressed',
                                               '4 bit compressed',
                                               '2.6 bit compressed',
                                               '2 bit compressed',
                                               '16 bit uncompressed',
                                               '',
                                               'ALAW compressed',
                                               'MULAW compressed');}
  ExtendedMono   = 0;
  ExtendedStereo = 1;
  ExtendedModeNames : ARRAY[0..1] OF STRING = ('Mono','Stereo');
  NewMono   = 1; {This is Creative Labs' fault}
  NewStereo = 2; {Blame it on Creative Labs}
 {NewModeNames : ARRAY[1..2] OF STRING = ('Mono','Stereo');}

TYPE PSound = ^TSound;
     TSound = ARRAY[0..65520] OF BYTE;

     PVOCHeader = ^TVOCHeader;
     TVOCHeader = ARRAY[1..26] OF BYTE;

     TripleByte = ARRAY[1..3] OF BYTE;

     PBlock = ^TBlock;
     TBlock = RECORD
              BlockType : BYTE;
              BlockLength : TripleByte;
              END;

     PEndBlock = ^TEndBlock;
     TEndBlock = RECORD
                 BlockType : BYTE;
                 END;

     PVoiceBlock = ^TVoiceBlock;
     TVoiceBlock = RECORD
                   BlockType   : BYTE;
                   BlockLength : TripleByte;
                   SR          : BYTE;
                   Packing     : BYTE;
                   Data        : ARRAY[0..65520] OF BYTE;
                   END;

     PVoiceContinueBlock = ^TVoiceContinueBlock;
     TVoiceContinueBlock = RECORD
                           BlockType   : BYTE;
                           BlockLength : TripleByte;
                           Data        : ARRAY[0..65520] OF BYTE;
                           END;

     PSilenceBlock = ^TSilenceBlock;
     TSilenceBlock = RECORD
                     BlockType   : BYTE;
                     BlockLength : TripleByte;
                     Duration    : WORD;
                     SR          : BYTE;
                     END;

    PMarkerBlock = ^TMarkerBlock;
    TMarkerBlock = RECORD
                   BlockType   : BYTE;
                   BlockLength : TripleByte;
                   Marker      : WORD;
                   END;

    PMessageBlock = ^TMessageBlock;
    TMessageBlock = RECORD
                    BlockType   : BYTE;
                    BlockLength : TripleByte;
                    Data        : ARRAY[0..65520] OF CHAR;
                    END;

    PRepeatBlock = ^TRepeatBlock;
    TRepeatBlock = RECORD
                   BlockType   : BYTE;
                   BlockLength : TripleByte;
                   Count       : WORD;
                   END;

    PRepeatEndBlock = ^TRepeatEndBlock;
    TRepeatEndBlock = RECORD
                      BlockType   : BYTE;
                      BlockLength : TripleByte;
                      END;

    PExtendedInfoBlock = ^TExtendedInfoBlock;
    TExtendedInfoBlock = RECORD
                         BlockType : BYTE;
                         BlockLength : TripleByte;
                         ExtendedSR : WORD;
                         Packing : BYTE;
                         Mode : BYTE; {0 = mono, 1 = stereo}
                         END;

    PNewVoiceBlock = ^TNewVoiceBlock;
    TNewVoiceBlock = RECORD
                     BlockType     : BYTE;
                     BlockLength   : TripleByte;
                     SamplingRate  : WORD; {HZ}
                     Dummy1        : ARRAY[1..2] OF BYTE;
                     BitsPerSample : BYTE; {Uncompressed bits per sample}
                     Mode          : BYTE; {1 = mono, 2 = stereo}
                     Compression   : WORD;
                     Dummy2        : ARRAY[1..4] OF BYTE;
                     Data          : ARRAY[0..64000] OF BYTE;
                     END;

FUNCTION TripleByteToLongint(TB : TripleByte) : LONGINT;
FUNCTION GetSamplingRate(SR : BYTE) : LONGINT;
FUNCTION GetSRByte(SamplingRate : WORD) : BYTE;
FUNCTION GetExtendedSamplingRate(ExtendedSR : WORD; Mode : BYTE) : LONGINT;
FUNCTION BlockSize(Block : PBlock) : LONGINT;
PROCEDURE IncrementPtr(VAR P : POINTER; Count : WORD);
FUNCTION FindNextBlock(Block : PBlock) : PBlock;
FUNCTION LoadVOCFile(FileName : STRING; VAR SOUND : PSound) : LONGINT;

IMPLEMENTATION

USES MEM;

FUNCTION TripleByteToLongint(TB : TripleByte) : LONGINT;
BEGIN
  TripleByteToLongint := LONGINT(TB[1]) + LONGINT(TB[2]) SHL 8 + LONGINT(TB[3]) SHL 16;
END;

FUNCTION GetSamplingRate(SR : BYTE) : LONGINT;
BEGIN
  GetSamplingRate := - 1000000 DIV (SR - 256);
END;

FUNCTION GetSRByte(SamplingRate : WORD) : BYTE;
BEGIN
  GetSRByte := 256 - (1000000 DIV SamplingRate);
END;

FUNCTION GetExtendedSamplingRate(ExtendedSR : WORD; Mode : BYTE) : LONGINT;
BEGIN
  CASE Mode OF
    ExtendedMono   : GetExtendedSamplingRate := - 256000000 DIV (ExtendedSR - 65536);
    ExtendedStereo : GetExtendedSamplingRate := ( - 256000000 DIV (ExtendedSR - 65536)) DIV 2;
  END;
END;

FUNCTION BlockSize(Block : PBlock) : LONGINT;
BEGIN
  BlockSize := TripleByteToLongInt(Block^.BlockLength) + 4;
END;

PROCEDURE IncrementPtr(VAR P : POINTER; Count : WORD);
{Easier to implement in assembly}
BEGIN
  Asm
  LES  DI, P
  MOV  BX, Count
  MOV  AX, ES : [DI]
  MOV  DX, ES : [DI + 2]
  ADD  AX, BX
  CMP  AX, $000F
  JNA  @1
  MOV  BX, AX
  AND  AX, $F
  AND  BX, $FFF0
  MOV  CL, 4
  SHR  BX, CL
  ADD  DX, BX
 @1 :
  MOV  ES : [DI], AX
  MOV  ES : [DI + 2], DX
  END;
END;

FUNCTION FindNextBlock(Block : PBlock) : PBlock;
VAR
  NewBlock : PBlock;
  BlockSize : LONGINT;
BEGIN
  IF Block^.BlockType = EndBlockNum THEN BEGIN
    FindNextBlock := NIL;
    EXIT;
  END;
  NewBlock := Block;
  BlockSize := TripleByteToLongInt(Block^.BlockLength) + 4;
  WHILE BlockSize > 0 DO BEGIN
    IF BlockSize > 64000 THEN BEGIN
      IncrementPtr(POINTER(NewBlock), 64000);
      DEC(BlockSize, 64000);
    END ELSE BEGIN
      IncrementPtr(POINTER(NewBlock), BlockSize);
      BlockSize := 0;
    END;
  END;
  FindNextBlock := NewBlock;
END;

FUNCTION LoadVOCFile(FileName : STRING; VAR SOUND : PSound) : LONGINT;
VAR
  F          : FILE;
  Dummy      : POINTER;
  LeftToRead : LONGINT;
  Header     : PVOCHeader;
BEGIN
  ASSIGN(F,FileName);
  {$I-}RESET(F,1);{$I+}
  IF IORESULT <> 0 THEN BEGIN
    LoadVOCFile := 0; {Couldn't open file}
    EXIT;
  END;
  LeftToRead  := FILESIZE(F) - SIZEOF(Header^);
  LoadVOCFile := LeftToRead;
  NEW(Header);
  BLOCKREAD(F, Header^, SIZEOF(Header^));

  IF GetBuffer(POINTER(SOUND), LeftToRead) <> TRUE THEN BEGIN
    LoadVOCfile := 0; {Failed to allocate memory}
    EXIT;
  END;
  Dummy := SOUND;
  WHILE LeftToRead > 0 DO BEGIN
    IF LeftToRead < 64000 THEN BEGIN
      BLOCKREAD(F, Dummy^, LeftToRead);
      LeftToRead := 0;
    END ELSE BEGIN
      BLOCKREAD(F, Dummy^, 64000);
      LeftToRead := LeftToRead - 64000;
      IncrementPtr(Dummy, 64000);
    END;
  END;
  CLOSE(F);
  DISPOSE(Header);
END;

END.
