{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT VOC_UNIT;

INTERFACE

PROCEDURE InitVocUnit(P,I,D : STRING);
PROCEDURE PlayVOC(FName : STRING);

IMPLEMENTATION

USES GUI_UTIL, MEM, SBDSP, VOICE;

CONST
  IRQ        : BYTE = 2;
  BaseIO     : WORD = $220;
  DMAChannel : BYTE = 1;

VAR
  VOCFileName   : STRING[80];
  SoundSize     : LONGINT;
  Sound         : PSound;
  OldMarkerProc : POINTER;

FUNCTION GetHexWordStr(W : WORD) : STRING;
CONST
  HexChars : ARRAY [0..$F] OF CHAR = '0123456789ABCDEF';
BEGIN
  GetHexWordStr := HexChars[HI(W) SHR 4] + HexChars[HI(W) AND $F] +
                   HexChars[LO(W) SHR 4] + HexChars[LO(W) AND $F];
END;

PROCEDURE DisplayMarker; FAR;
BEGIN
  IF (OldMarkerProc <> NIL) THEN Proc(OldMarkerProc);
END;

PROCEDURE InitVocUnit(P,I,D : STRING);
BEGIN
  IRQ        := StrToInt(I);
  BaseIO     := HexToInt('$'+P);
  DMAChannel := StrToInt(D);
END;

PROCEDURE PlayVOC(FName : STRING);
BEGIN
  IF NOT FExist(FName) THEN EXIT;
  IF EnvironmentSet THEN BEGIN
    IF NOT InitSBFromEnv THEN EXIT;
  END ELSE BEGIN
    IF NOT InitSB(IRQ,BaseIO,DMAChannel) THEN EXIT;
  END;
  VOCFileName := FName;
  SoundSize   := LoadVOCfile(VOCFileName,Sound);
  IF SoundSize = 0 THEN EXIT;
  GetMarkerProc(OldMarkerProc);
  SetMarkerProc(@DisplayMarker);
  TurnSpeakerOn;
  PlaySound(Sound);
  REPEAT
    IF UnknownBlock THEN UnknownBlock := FALSE;
    IF UnplayedBlock THEN UnplayedBlock := FALSE;
  UNTIL (SoundPlaying = FALSE);
  TurnSpeakerOff;
  SetMarkerProc(OldMarkerProc);
  FreeBuffer(POINTER(Sound),SoundSize);
  ShutDownSB;
END;

END.
