{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT TRMUNIT1;

INTERFACE

PROCEDURE DialingWindow;
PROCEDURE DoTaggedDial;
PROCEDURE StartUp;
PROCEDURE Auto_Mode;

IMPLEMENTATION

{$IFDEF InternalComp}
USES MYCRT, DOS, TERMVARS, APVARS, GUI_UTIL, GUI_UNIT, GUI_ICON,
     GUI_FONT, GUI_ANSI, GUI_MOUS, GUI_IMAG, CRCUNIT, FGMAIN, MAXCOMPG,
     TRMUNIT2, TRMUNIT3, TRMUNIT4, _SCRIPT, PORTUNIT, APTIMER;
{$ELSE}
USES MYCRT, DOS, TERMVARS, APVARS, GUI_UTIL, GUI_UNIT, GUI_ICON,
     GUI_FONT, GUI_ANSI, GUI_MOUS, GUI_IMAG, CRCUNIT, FGMAIN, TRMUNIT2,
     TRMUNIT3, TRMUNIT4, _SCRIPT, PORTUNIT, APTIMER;
{$ENDIF}

VAR
  ScreenFile : STRING[50];
  Connected  : BOOLEAN;

PROCEDURE CleanUpWorkDirectory;
VAR
  WorkFile : STRING[12];
  DirInfo  : SEARCHREC;
BEGIN
  CHDIR(NoPath(SesPath));
  FINDFIRST('*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WorkFile := AllCaps(DirInfo.Name);
    FErase(WorkFile);
    FINDNEXT(DirInfo);
  END;
  CHDIR(HomeDir);
END;

PROCEDURE RepackResources;
VAR
  Temp : STRING;
BEGIN
  IF LastPkg = '' THEN EXIT;
  ExplodeOn := TRUE;
{$IFNDEF InternalComp}
  HideMouse;
  Draw_Window(220,186,411,239,5,'One Moment Please...');
  ShadowText(229,216,15,0,2,'Repacking Graphics Resources');
{$ENDIF}
  CHDIR(NoPath(SesPath));
  FErase(LastPkg + '.PKG');
{$IFDEF InternalComp}
  MakeArchive(LastPkg + '.PKG');
{$ELSE}
  Execute(HomeDir + '\MAXCOMP.EXE',LastPkg + '.PKG C B');
{$ENDIF}
  ExplodeOn := FALSE;
  CHDIR(HomeDir);
{$IFNDEF InternalComp}
  Kill_Window;
{$ENDIF}
  CopyFile(SesPath + LastPkg + '.PKG',ResPath + LastPkg + '.PKG');
END;

PROCEDURE UnpackResources;
VAR
  WorkFile : STRING[12];
BEGIN
  IF (NOT DD.UseMAX) OR (LastPKG = DD.BoardID) THEN EXIT;
  IF LastPKG <> '' THEN RepackResources;
  LastPKG  := DD.BoardID;
  WorkFile := DD.BoardID + '.PKG';
  IF NOT FExist(ResPath + WorkFile) THEN EXIT;
  ExplodeOn := TRUE;
  CleanUpWorkDirectory;
  CopyFile(ResPath + WorkFile,SesPath + WorkFile);
{$IFNDEF InternalComp}
  HideMouse;
  Draw_Window(220,186,411,239,5,'One Moment Please...');
  ShadowText(229,216,15,0,2,'Unpacking Graphics Resources');
{$ENDIF}
  CHDIR(NoPath(SesPath));
{$IFDEF InternalComp}
  ExtractArchive(WorkFile);
  MouseMask(MouseHourGlass);
{$ELSE}
  Execute(HomeDir + '\MAXCOMP.EXE ',WorkFile + ' D B');
{$ENDIF}
  CHDIR(NoPath(SesPath));
  CopyFile(ResPath + 'DEFAULT.PKG',SesPath + 'DEFAULT.PKG');
{$IFDEF InternalComp}
  BlindExtract('DEFAULT.PKG');
  MouseMask(MouseStandard);
{$ELSE}
  Execute(HomeDir + '\MAXCOMP.EXE','DEFAULT.PKG D B');
{$ENDIF}
  FErase(SesPath + 'DEFAULT.PKG');
  CHDIR(HomeDir);
{$IFNDEF InternalComp}
  Kill_Window;
{$ENDIF}
  ExplodeOn := FALSE;
END;

FUNCTION Confirmed : BOOLEAN;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Window(220,186,430,252,5,'Confirmation:');
  OutText_XY(230,215,1,2,'You Are About To Delete An Item.');
  OutText_XY(230,231,1,2,'Should We Continue?    {4}Y{0}es    {4}N{0}o');
  Mouse_Field(359,230,31,17,21);
  Mouse_Field(394,230,31,17,49);
  WRITE(^G);
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  Kill_Window;
  IF ButNum = 1 THEN Confirmed := TRUE ELSE Confirmed := FALSE;
END;

PROCEDURE BlankTopMenu;
BEGIN
  OutText_XY(6,3,240,2,'Dialing Directory');
  OutText_XY(112,3,240,2,'Modem Setup');
  OutText_XY(218,3,240,2,'Path Setup');
  OutText_XY(324,3,240,2,'Other Stuff');
  OutText_XY(585,3,240,2,'Quit');
END;

PROCEDURE DeleteRecord(RecordNum : WORD);
VAR
  Loop  : WORD;
  XDat  : FILE OF Dialing_Directory;
  DDdat : FILE OF Dialing_Directory;
BEGIN
  ASSIGN(DDdat,'MAXPHONE.DIR');
  ASSIGN(XDat,'MAXPHONE.DIX');
  RESET(DDdat);
  REWRITE(XDat);
  FOR Loop := 0 TO (FILESIZE(DDdat) - 1) DO BEGIN
    SEEK(DDdat,Loop);
    READ(DDdat,DD);
    IF Loop <> RecordNum THEN BEGIN
      WRITE(XDat,DD);
    END ELSE BEGIN
      IF DD.BoardID <> 'DEFAULT' THEN FErase(ResPath + DD.BoardID + '.PKG');
    END;
  END;
  CLOSE(DDdat);
  CLOSE(XDat);
  FErase('MAXPHONE.DIR');
  CopyFile('MAXPHONE.DIX','MAXPHONE.DIR');
  FErase('MAXPHONE.DIX');
END;

PROCEDURE MaxWarning;
BEGIN
  C.ActiveHdr := 4;
  HideMouse;
  Draw_Window(180,141,487,311,5,'MAX Graphics Emulation Warning!!!');
  OutText_XY(189,171,4,2,'Be absolutely sure that this BBS has MAX Graphics');
  OutText_XY(189,186,4,2,'before activating this feature in MAXterm...If this');
  OutText_XY(189,201,4,2,'BBS uses RIP instead of MAX, MAXterm will appear');
  OutText_XY(189,216,4,2,'to lock up, or may drop carrier immediately upon');
  OutText_XY(189,231,4,2,'host/terminal emulation detection...Call this BBS in');
  OutText_XY(189,246,4,2,'straight ANSI mode first and verify that MAX is in');
  OutText_XY(189,261,4,2,'use on this system before using MAX emulation....');
  Draw_Button(417,281,60,24,TRUE,4,'Okay');
  CheckControlLine(#255#126#184#255);
  ShowMouse;
  REPEAT UNTIL MouseHandler(TRUE) <> 0;
  C.ActiveHdr := 57;
  Kill_Window;
END;

PROCEDURE EditRecord(Location : WORD);
VAR
  ButNum : BYTE;
  FDD    : FILE OF Dialing_Directory;
BEGIN
  ASSIGN(FDD,'MAXPHONE.DIR');
  RESET(FDD);
  IF FILESIZE(FDD) = 0 THEN BEGIN
    CLOSE(FDD);
    EXIT;
  END;
  SEEK(FDD,Location);
  READ(FDD,DD);
  HideMouse;
 {StartOffScreenDraw;}
  Draw_Window(136,100,505,345,5,'Add/Edit Phone Record');
  OutText_XY(180,130,1,2,'BBS Name:');       Entry_Field(244,128,2,30,1,DD.BBSname);
  OutText_XY(152,154,1,2,'Phone Number:');   Entry_Field(244,152,0,30,1,DD.PhoneNumber);
  OutText_XY(174,178,1,2,'User Name:');      Entry_Field(244,176,2,30,1,DD.UserName);
  OutText_XY(150,202,1,2,'User Password:');  Entry_Field(244,200,0,30,1,DD.Password);
  OutText_XY(145,226,1,2,'Modem Pre-Init:'); Entry_Field(244,224,5,30,1,DD.PreInit);
  OutText_XY(163,250,1,2,'Board PKG ID:');   Entry_Field(244,248,5,8,1,DD.BoardID);
  OutText_XY(177,274,1,2,'ANSI Mode:'); FrameLow(244,272,324,292); FrameLow(245,273,323,291);
  FG_SetColor(0); FG_Rect(246,322,274,290);
  IF DD.AnsiMode = 1 THEN OutText_XY(250,275,15,2,'Text Mode') ELSE OutText_XY(250,275,15,2,'SVGA Mode');
  Radio_Button(329,275,120);
  OutText_XY(159,298,1,2,'MAX Graphics:'); FrameLow(244,296,324,316); FrameLow(245,297,323,315);
  FG_SetColor(0); FG_Rect(246,322,298,314);
  IF DD.UseMAX THEN OutText_XY(250,299,15,2,'YES') ELSE OutText_XY(250,299,15,2,'NO');
  Radio_Button(329,299,121);
  OutText_XY(158,322,1,2,'Sound Blaster:'); FrameLow(244,320,324,340); FrameLow(245,321,323,339);
  FG_SetColor(0); FG_Rect(246,322,322,338);
  IF DD.UseSB THEN OutText_XY(250,323,15,2,'YES') ELSE OutText_XY(250,323,15,2,'NO');
  Radio_Button(329,323,122);
  Draw_Button(376,320,60,31,TRUE,60,'Save');
  Draw_Button(440,320,60,16,TRUE,29,'Quit');
 {EndOffScreenDraw;}
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum > 0;
    FG_SetColor(0);
    CASE ButNum OF
      1 : BEGIN
            IF DD.AnsiMode = 1 THEN DD.AnsiMode := 2 ELSE DD.AnsiMode := 1;
            FG_Rect(WRec.X1 + 110,WRec.X1 + 186,WRec.Y1 + 174,WRec.Y1 + 190);
            IF DD.AnsiMode = 1 THEN OutText_XY(WRec.X1 + 114,WRec.Y1 + 175,15,2,'Text Mode')
                               ELSE OutText_XY(WRec.X1 + 114,WRec.Y1 + 175,15,2,'SVGA Mode');
          END;
      2 : BEGIN
            DD.UseMAX := NOT DD.UseMAX;
            FG_Rect(WRec.X1 + 110,WRec.X1 + 186,WRec.Y1 + 198,WRec.Y1 + 214);
            IF DD.UseMAX THEN OutText_XY(WRec.X1 + 114,WRec.Y1 + 199,15,2,'YES')
                         ELSE OutText_XY(WRec.X1 + 114,WRec.Y1 + 199,15,2,'NO');
          END;
      3 : BEGIN
            DD.UseSB := NOT DD.UseSB;
            FG_Rect(WRec.X1 + 110,WRec.X1 + 186,WRec.Y1 + 222,WRec.Y1 + 238);
            IF DD.UseSB THEN OutText_XY(WRec.X1 + 114,WRec.Y1 + 223,15,2,'YES')
                        ELSE OutText_XY(WRec.X1 + 114,WRec.Y1 + 223,15,2,'NO');
          END;
    END;
  UNTIL ButNum > 3;
  IF ButNum = 4 THEN BEGIN
    WITH DD DO BEGIN
      BBSname     := StripBoth(Fields^[1].Text,' ');
      PhoneNumber := StripBoth(Fields^[2].Text,' ');
      UserName    := StripBoth(Fields^[3].Text,' ');
      Password    := StripBoth(Fields^[4].Text,' ');
      PreInit     := StripBoth(Fields^[5].Text,' ');
      BoardID     := StripBoth(Fields^[6].Text,' ');
      IF (BoardID = '') OR (BoardID = 'DEFAULT') THEN BoardID := 'BBS' + IntToStr(Location + 1);
    END;
    SEEK(FDD,Location);
    WRITE(FDD,DD);
  END;
  IF DD.UseMax THEN MaxWarning;
  Kill_Window;
  CLOSE(FDD);
END;

PROCEDURE AddRecord;
VAR
  FDD : FILE OF Dialing_Directory;
  Rec : WORD;
BEGIN
  FILLCHAR(DD,SIZEOF(DD),0);
  ASSIGN(FDD,'MAXPHONE.DIR');
  RESET(FDD);
  WITH DD DO BEGIN
    AnsiMode := 1;
    UseMAX   := TRUE;
    UseSB    := TRUE;
    BoardID  := 'BBS' + IntToStr(FILESIZE(FDD) + 1);
  END;
  SEEK(FDD,FILESIZE(FDD));
  WRITE(FDD,DD);
  Rec := (FILESIZE(FDD) - 1);
  CLOSE(FDD);
  EditRecord(Rec);
END;

PROCEDURE InsertRecord(NewRecord : WORD);
VAR
  DDdat   : FILE OF Dialing_Directory;
  Temp    : Dialing_Directory;
  TempDat : FILE OF Dialing_Directory;
  Loop    : WORD;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),0);
  WITH TEMP DO BEGIN
    AnsiMode := 1;
    UseMAX   := TRUE;
    UseSB    := TRUE;
    BoardID  := 'BBS' + IntToStr(NewRecord + 1);
  END;
  ASSIGN(DDdat,'MAXPHONE.DIR');
  ASSIGN(TempDat,'TEMP.DAT');
  RESET(DDdat);
  REWRITE(TempDat);
  FOR Loop := 0 TO (FILESIZE(DDdat) - 1) DO BEGIN
    READ(DDdat,DD);
    IF Loop <> NewRecord THEN WRITE(TempDat,DD) ELSE BEGIN
      WRITE(TempDat,Temp);
      WRITE(TempDat,DD);
    END;
  END;
  CLOSE(DDdat);
  CLOSE(TempDat);
  CopyFile('TEMP.DAT','MAXPHONE.DIR');
  ERASE(TempDat);
  EditRecord(NewRecord);
END;

PROCEDURE RedrawQueue;
VAR
  FQueue : FILE OF Dialing_Directory;
  Q      : Dialing_Directory;
  Y      : WORD;
BEGIN
  HideMouse;
  ASSIGN(FQueue,'QUEUE.DIR');
  FG_SetColor(239);
  FG_Rect(WRec.X1 + 272,WRec.X1 + 460,WRec.Y1 + 29,WRec.Y1 + 158);
  Y := WRec.Y1 + 32;
  IF NOT FExist('QUEUE.DIR') THEN EXIT;
  RESET(FQueue);
  WHILE NOT EOF(FQueue) DO BEGIN
    READ(FQueue,Q);
    PickText(WRec.X1 + 274,Y,15,Q.BBSname);
    INC(Y,13);
  END;
  CLOSE(FQueue);
  ShowMouse;
END;

PROCEDURE AddToQueue;
VAR
  FQueue : FILE OF Dialing_Directory;
BEGIN
  ASSIGN(FQueue,'QUEUE.DIR');
  RESET(FQueue);
  IF FILESIZE(FQueue) < 10 THEN BEGIN
    SEEK(FQueue,FILESIZE(FQueue));
    WRITE(FQueue,DD);
  END;
  QueueSize := FILESIZE(FQueue);
  CLOSE(FQueue);
END;

PROCEDURE RemoveFromQueue;
VAR
  FFQueue : FILE OF Dialing_Directory;
  FQueue  : FILE OF Dialing_Directory;
  Q       : Dialing_Directory;
BEGIN
  ASSIGN(FQueue,'QUEUE.DIR');
  ASSIGN(FFQueue,'QUEUE.DIX');
  RESET(FQueue);
  REWRITE(FFQueue);
  WHILE NOT EOF(FQueue) DO BEGIN
    READ(FQueue,Q);
    IF Q.BBSname <> DD.BBSname THEN WRITE(FFQueue,Q);
  END;
  QueueSize := FILESIZE(FFQueue);
  CLOSE(FQueue);
  CLOSE(FFQueue);
  CopyFile('QUEUE.DIX','QUEUE.DIR');
  FErase('QUEUE.DIX');
END;

PROCEDURE TagBBS(BBS : WORD);
VAR
  FQueue : FILE OF Dialing_Directory;
  FDD    : FILE OF Dialing_Directory;
  Q      : Dialing_Directory;
  GotIt  : BOOLEAN;
BEGIN
  GotIt := FALSE;
  ASSIGN(FQueue,'QUEUE.DIR');
  ASSIGN(FDD,'MAXPHONE.DIR');
  RESET(FDD);
  SEEK(FDD,BBS);
  READ(FDD,DD);
  CLOSE(FDD);
  IF NOT FExist('QUEUE.DIR') THEN BEGIN
    REWRITE(FQueue);
    WRITE(FQueue,DD);
    CLOSE(FQueue);
    RedrawQueue;
    EXIT;
  END;
  RESET(FQueue);
  WHILE NOT EOF(FQueue) DO BEGIN
    READ(FQueue,Q);
    IF Q.BBSname = DD.BBSname THEN GotIt := TRUE;
  END;
  CLOSE(FQueue);
  IF GotIt THEN RemoveFromQueue ELSE AddToQueue;
  RedrawQueue;
END;

PROCEDURE DoDialingDirectory;
VAR
  FDD    : FILE OF Dialing_Directory;
  ButNum : BYTE;
  Count  : WORD;
  Index  : WORD;
BEGIN
  Index    := 1;
  DialMode := 0;
  DebugOn  := FALSE;
  IF FExist('QUEUE.DIR') THEN FErase('QUEUE.DIR');
  HideMouse;
 {StartOffScreenDraw;}
  Draw_Window(55,130,582,318,5,'Dialing Directory');
  New_PickList(61,159,10,30);
  ASSIGN(FDD,'MAXPHONE.DIR');
  IF FExist('MAXPHONE.DIR') THEN BEGIN
    Count := 0;
    RESET(FDD);
    WHILE (NOT EOF(FDD)) AND (Count <= 800) DO BEGIN
      READ(FDD,DD);
      AddTo_PickList(IntToStr(Count + 1) + ' - ' + DD.BBSname);
      INC(Count);
    END;
  END ELSE BEGIN
    REWRITE(FDD);
    FILLCHAR(DD,SIZEOF(DD),0);
    WITH DD DO BEGIN
      BBSname     := 'USA MAX Graphics HQ-BBS';
      PhoneNumber := '1-308-762-2239';
      UseMAX      := TRUE;
      BoardID     := 'MAXHQBBS';
      AnsiMode    := 1;
      UseSB       := TRUE;
    END;
    WRITE(FDD,DD);
    AddTo_PickList('1 - ' + DD.BBSname);
    FILLCHAR(DD,SIZEOF(DD),0);
    WITH DD DO BEGIN
      BBSname     := 'Vast 99 ConnecTIon';
      PhoneNumber := '1-602-267-1419';
      UseMAX      := TRUE;
      BoardID     := 'VAST_99';
      AnsiMode    := 1;
      UseSB       := TRUE;
    END;
    WRITE(FDD,DD);
    AddTo_PickList('2 - ' + DD.BBSname);
  END;
  CLOSE(FDD);
  SetUp_PickList;
  FrameLow(326,158,577,289);
  FG_SetColor(239);
  FG_Rect(327,576,159,288);
  Draw_Button(60,293,50,32,FALSE,0,'Dial');
  Draw_Button(114,293,50,18,FALSE,0,'Edit');
  Draw_Button(168,293,50,30,FALSE,0,'Add');
  Draw_Button(222,293,50,23,FALSE,0,'Insert');
  Draw_Button(276,293,50,37,FALSE,0,'Kill');
  Draw_Button(330,293,50,20,FALSE,0,'Tag');
  Draw_Button(504,293,73,16,TRUE,29,'Quit');
 {EndOffScreenDraw;}
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum > 2;
    Index := PickInfo.Current;
    CASE ButNum OF
      3 : IF QueueSize = 0 THEN BEGIN
            RESET(FDD);
            SEEK(FDD,(PickInfo.Current - 1));
            READ(FDD,DD);
            IF (DD.BoardID = '') OR (DD.BoardID = 'DEFAULT') THEN BEGIN
              DD.BoardID := 'BBS' + IntToStr(PickInfo.Current);
              SEEK(FDD,(PickInfo.Current - 1));
              WRITE(FDD,DD);
            END;
            CLOSE(FDD);
            DialMode := 1;
            RipFake  := DD.UseMax;
          END ELSE DialMode := 2;
      4 : EditRecord(PickInfo.Current - 1);
      5 : AddRecord;
      6 : InsertRecord(PickInfo.Current - 1);
      7 : IF Confirmed THEN BEGIN
            DeleteRecord(PickInfo.Current - 1);
            DEC(Index);
            IF Index = 0 THEN INC(Index);
          END;
      8 : TagBBS(PickInfo.Current - 1);
    END;
    IF ButNum IN [4,5,6,7] THEN BEGIN
      HideMouse;
      DISPOSE(PickList);
      New_PickList(WRec.X1 + 6,WRec.Y1 + 29,10,30);
      Count := 0;
      RESET(FDD);
      WHILE (NOT EOF(FDD)) AND (Count <= 800) DO BEGIN
        READ(FDD,DD);
        AddTo_PickList(IntToStr(Count + 1) + ' - ' + DD.BBSname);
        INC(Count);
      END;
      CLOSE(FDD);
      Reset_PickList(Index);
      SetUp_PickList;
      IF FExist('QUEUE.DIR') THEN FErase('QUEUE.DIR');
      RedrawQueue;
      ShowMouse;
    END;
  UNTIL ButNum IN [3,9];
  Kill_Window;
END;

PROCEDURE GetDevice(Device : BYTE);
VAR
  ButNum : BYTE;
BEGIN
  CommDef.Device := Device;
  HideMouse;
  Draw_Window(467,77,561,228,5,'Comm Device');
  FrameLow(471,105,556,127);
  FrameLow(472,106,555,126);
  FG_SetColor(0);
  FG_Rect(473,554,107,125);
  CASE Device OF
    1 : OutText_XY(477,109,15,2,'UART');
    2 : OutText_XY(477,109,15,2,'Fossil');
    3 : OutText_XY(477,109,15,2,'DigiBoard');
  END;
  Draw_Button(471,131,85,22,FALSE,0,'UART');
  Draw_Button(471,155,85,33,FALSE,0,'Fossil');
  Draw_Button(471,179,85,32,FALSE,0,'DigiBoard');
  Draw_Button(471,203,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    IF ButNum < 4 THEN BEGIN
      CommDef.Device := ButNum;
      FG_SetColor(0);
      FG_Rect(WRec.X1 + 6,WRec.X1 + 87,WRec.Y1 + 30,WRec.Y1 + 48);
      CASE ButNum OF
        1 : OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,'UART');
        2 : OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,'Fossil');
        3 : OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,'DigiBoard');
      END;
    END;
  UNTIL ButNum = 4;
  Kill_Window;
END;

PROCEDURE GetPort(Port : BYTE);
VAR
  ButNum : BYTE;
BEGIN
  CommDef.Port := Port;
  HideMouse;
  Draw_Window(467,77,561,154,5,'Comport');
  Draw_Button(471,105,20,72,TRUE,31,'');
  Draw_Button(491,105,20,80,TRUE,32,'');
  FrameLow(535,105,556,125);
  FrameLow(536,106,555,124);
  FG_SetColor(0);
  FG_Rect(537,554,107,123);
  OutText_XY(542,108,15,2,IntToStr(CommDef.Port));
  Draw_Button(471,129,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    IF ButNum < 3 THEN BEGIN
      FG_SetColor(0);
      FG_Rect(WRec.X1 + 70,WRec.X1 + 87,WRec.Y1 + 30,WRec.Y1 + 46);
      CASE ButNum OF
        1 : BEGIN
              INC(CommDef.Port);
              IF CommDef.Port > 8 THEN CommDef.Port := 8;
            END;
        2 : BEGIN
              DEC(CommDef.Port);
              IF CommDef.Port < 1 THEN CommDef.Port := 1;
            END;
      END;
      OutText_XY(WRec.X1 + 75,WRec.Y1 + 31,15,2,IntToStr(CommDef.Port));
    END;
  UNTIL ButNum = 3;
  Kill_Window;
END;

PROCEDURE GetIRQ(IRQ : INTEGER);
VAR
  ButNum : BYTE;
BEGIN
  CommDef.IRQ := IRQ;
  HideMouse;
  Draw_Window(467,77,561,185,5,'Comport IRQ');
  Draw_Button(471,105,20,72,TRUE,31,'');
  Draw_Button(491,105,20,80,TRUE,32,'');
  FrameLow(530,105,556,125);
  FrameLow(531,106,555,124);
  FG_SetColor(0);
  FG_Rect(532,554,107,123);
  OutText_XY(537,108,15,2,IntToStr(CommDef.IRQ));
  ShadowText(472,130,15,0,1,'Set IRQ to 0');
  ShadowText(472,139,15,0,1,'for standard');
  ShadowText(472,148,15,0,1,'port IRQ.');
  Draw_Button(471,160,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    IF ButNum < 3 THEN BEGIN
      FG_SetColor(0);
      FG_Rect(WRec.X1 + 65,WRec.X1 + 87,WRec.Y1 + 30,WRec.Y1 + 46);
      CASE ButNum OF
        1 : BEGIN
              INC(IRQ);
              IF IRQ > 99 THEN IRQ := 99;
            END;
        2 : BEGIN
              DEC(IRQ);
              IF IRQ < 0 THEN IRQ := 0;
            END;
      END;
      CommDef.IRQ := IRQ;
      OutText_XY(WRec.X1 + 70,WRec.Y1 + 31,15,2,IntToStr(CommDef.IRQ));
    END;
  UNTIL ButNum = 3;
  Kill_Window;
END;

PROCEDURE GetPortAddress;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Window(467,77,561,185,5,'Port Address');
  OutText_XY(475,108,1,2,'Addr:');
  Entry_Field(509,105,5,4,1,CommDef.PortAddr);
  ShadowText(472,130,15,0,1,'Set address to');
  ShadowText(472,139,15,0,1,'0 for standard');
  ShadowText(472,148,15,0,1,'port address.');
  Draw_Button(471,160,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  CommDef.PortAddr := StripBoth(Fields^[1].Text,' ');
  CommDef.PortAddr := StripBoth(CommDef.PortAddr,'$');
  IF (CommDef.PortAddr = '') OR (LENGTH(CommDef.PortAddr) < 4) THEN CommDef.PortAddr := '0';
  Kill_Window;
END;

PROCEDURE GetPortSpeed(Speed : LONGINT);
VAR
  ButNum : BYTE;
BEGIN
  CommDef.Baud := Speed;
  HideMouse;
  Draw_Window(467,77,561,396,5,'Port Speed');
  FrameLow(471,105,556,127);
  FrameLow(472,106,555,126);
  FG_SetColor(0);
  FG_Rect(473,554,107,125);
  OutText_XY(477,109,15,2,IntToStr(CommDef.Baud));
  Draw_Button(471,131,85,120,FALSE,0,#0'300');
  Draw_Button(471,155,85,121,FALSE,0,#0'600');
  Draw_Button(471,179,85,122,FALSE,0,#0'1200');
  Draw_Button(471,203,85,123,FALSE,0,#0'2400');
  Draw_Button(471,227,85,124,FALSE,0,#0'4800');
  Draw_Button(471,251,85,125,FALSE,0,#0'9600');
  Draw_Button(471,275,85,126,FALSE,0,#0'19200');
  Draw_Button(471,299,85,127,FALSE,0,#0'38400');
  Draw_Button(471,323,85,128,FALSE,0,#0'57600');
  Draw_Button(471,347,85,123,FALSE,0,#0'115200');
  Draw_Button(471,371,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    IF ButNum < 11 THEN BEGIN
      FG_SetColor(0);
      FG_Rect(WRec.X1 + 6,WRec.X1 + 87,WRec.Y1 + 30,WRec.Y1 + 48);
      CASE ButNum OF
        1  : CommDef.Baud := 300;
        2  : CommDef.Baud := 600;
        3  : CommDef.Baud := 1200;
        4  : CommDef.Baud := 2400;
        5  : CommDef.Baud := 4800;
        6  : CommDef.Baud := 9600;
        7  : CommDef.Baud := 19200;
        8  : CommDef.Baud := 38400;
        9  : CommDef.Baud := 57600;
        10 : CommDef.Baud := 115200;
      END;
      OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,IntToStr(CommDef.Baud));
    END;
  UNTIL ButNum = 11;
  Kill_Window;
END;

PROCEDURE GetFlowControl;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Window(467,77,561,204,5,'Flow Control');
  FrameLow(471,105,556,127);
  FrameLow(472,106,555,126);
  FG_SetColor(0);
  FG_Rect(473,554,107,125);
  IF CommDef.HwFlow THEN OutText_XY(477,109,15,2,'Hardware')
                    ELSE OutText_XY(477,109,15,2,'Software');
  Draw_Button(471,131,85,35,FALSE,0,'Hardware');
  Draw_Button(471,155,85,31,FALSE,0,'Software');
  Draw_Button(471,179,85,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    IF ButNum < 4 THEN BEGIN
      FG_SetColor(0);
      FG_Rect(WRec.X1 + 6,WRec.X1 + 87,WRec.Y1 + 30,WRec.Y1 + 48);
      CASE ButNum OF
        1 : CommDef.HwFlow := TRUE;
        2 : CommDef.HwFlow := FALSE;
      END;
      IF CommDef.HwFlow THEN OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,'Hardware')
                        ELSE OutText_XY(WRec.X1 + 10,WRec.Y1 + 32,15,2,'Software');
    END;
  UNTIL ButNum = 3;
  Kill_Window;
END;

PROCEDURE CommWarning;
BEGIN
  ExplodeOn   := FALSE;
  C.ActiveHdr := 4;
  HideMouse;
  Draw_Window(180,141,462,297,5,'Fossil/DigiBoard Warning!!!');
  OutText_XY(189,171,4,2,'Be advised that not all communications driver');
  OutText_XY(189,186,4,2,'programs are created equally...If problems in');
  OutText_XY(189,201,4,2,'automatic Zmodem downloads arise or if the');
  OutText_XY(189,216,4,2,'program is forced to download new graphics');
  OutText_XY(189,231,4,2,'resources on every call, you should switch to');
  OutText_XY(189,246,4,2,'UART communications routines instead....');
  Draw_Button(392,266,60,24,TRUE,4,'Okay');
  CheckControlLine(#255#126#184#255);
  ShowMouse;
  REPEAT UNTIL MouseHandler(TRUE) <> 0;
  C.ActiveHdr := 57;
  Kill_Window;
END;

PROCEDURE DoModemSetUp;
VAR
  ButNum   : BYTE;
  FCommDef : FILE OF ComPortDefinition;
  FModem   : FILE OF Modem_Commands;
BEGIN
  ASSIGN(FModem,'MAXMODEM.CFG');
  ASSIGN(FCommDef,'MAX_PORT.CFG');
  IF (FExist('MAXMODEM.CFG')) AND (FExist('MAX_PORT.CFG')) THEN BEGIN
    RESET(FCommDef);
    RESET(FModem);
    READ(FCommDef,CommDef);
    READ(FModem,Modem);
  END ELSE BEGIN
    REWRITE(FCommDef);
    REWRITE(FModem);
    WRITE(FCommDef,CommDef);
    WRITE(FModem,Modem);
  END;
  HideMouse;
 {StartOffScreenDraw;}
  Draw_Window(98,100,540,369,5,'Modem Configuration');
  FrameLow(299,200,535,268);
  OutText_XY(107,130,1,2,'Modem Init #1:'); Entry_Field(199,128,5,40,1,Modem.Init1);
  OutText_XY(107,154,1,2,'Modem Init #2:'); Entry_Field(199,152,5,40,1,Modem.Init2);
  OutText_XY(107,178,1,2,'Modem Init #3:'); Entry_Field(199,176,5,40,1,Modem.Init3);
  OutText_XY(148,202,1,2,'Answer:');        Entry_Field(199,200,5,10,1,Modem.Answer);
  OutText_XY(146,226,1,2,'On Hook:');       Entry_Field(199,224,5,10,1,Modem.OnHook);
  OutText_XY(141,250,1,2,'Off Hook:');      Entry_Field(199,248,5,10,1,Modem.OffHook);
  OutText_XY(145,274,1,2,'Pre-Dial:');      Entry_Field(199,272,5,10,1,Modem.Dial);
  OutText_XY(300,274,1,2,'Use "ATDT*70," To Disable Call Waiting');
  OutText_XY(114,298,1,2,'Modem Delay:');   Entry_Field(199,296,1,4,1,IntToStr(CommDef.Command_Delay));
  OutText_XY(252,298,1,2,'In Milliseconds');
  OutText_XY(120,322,1,2,'Input Buffer:');  Entry_Field(199,320,1,4,1,IntToStr(CommDef.In_Buffer));
  OutText_XY(252,322,1,2,'In Bytes');
  OutText_XY(111,346,1,2,'Output Buffer:'); Entry_Field(199,344,1,4,1,IntToStr(CommDef.Out_Buffer));
  OutText_XY(252,346,1,2,'In Bytes');
  OutText_XY(306,204,0,2,'Comm Device');     Mouse_Field(302,203,115,18,120);
  OutText_XY(306,227,0,2,'Comport ##');      Mouse_Field(302,226,115,18,121);
  OutText_XY(306,249,0,2,'Comport IRQ');     Mouse_Field(302,248,115,18,122);
  OutText_XY(422,204,0,2,'Comport Address'); Mouse_Field(418,203,115,18,123);
  OutText_XY(422,227,0,2,'Comport Speed');   Mouse_Field(418,226,115,18,124);
  OutText_XY(422,249,0,2,'Flow Control');    Mouse_Field(418,248,115,18,125);
  Draw_Button(411,344,60,31,TRUE,60,'Save');
  Draw_Button(475,344,60,16,TRUE,29,'Quit');
 {EndOffScreenDraw;}
  ShowMouse;
  REPEAT
    ExplodeOn := TRUE;
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    CASE ButNum OF
      1 : GetDevice(CommDef.Device);
      2 : GetPort(CommDef.Port);
      3 : GetIRQ(CommDef.IRQ);
      4 : GetPortAddress;
      5 : GetPortSpeed(CommDef.Baud);
      6 : GetFlowControl;
    END;
  UNTIL ButNum > 6;
  SEEK(FCommDef,0);
  SEEK(FModem,0);
  IF ButNum = 7 THEN BEGIN
    WITH Modem DO BEGIN
      Init1   := StripBoth(Fields^[1].Text,' ');
      Init2   := StripBoth(Fields^[2].Text,' ');
      Init3   := StripBoth(Fields^[3].Text,' ');
      Answer  := StripBoth(Fields^[4].Text,' ');
      OnHook  := StripBoth(Fields^[5].Text,' ');
      OffHook := StripBoth(Fields^[6].Text,' ');
      Dial    := StripBoth(Fields^[7].Text,' ');
    END;
    WITH CommDef DO BEGIN
      Command_Delay := StrToInt(StripBoth(Fields^[8].Text,' '));
      In_Buffer     := StrToInt(StripBoth(Fields^[9].Text,' '));
      Out_Buffer    := StrToInt(StripBoth(Fields^[10].Text,' '));
    END;
    WRITE(FCommDef,CommDef);
    WRITE(FModem,Modem);
  END ELSE BEGIN
    READ(FCommDef,CommDef);
    READ(FModem,Modem);
  END;
  CLOSE(FCommDef);
  CLOSE(FModem);
  IF CommDef.Device IN [2,3] THEN CommWarning;
  Kill_Window;
END;

PROCEDURE DoPathSetup;
VAR
  FMisc  : FILE OF Misc_Information;
  ButNum : BYTE;
BEGIN
  ASSIGN(FMisc,'MAX_MISC.CFG');
  IF FExist('MAX_MISC.CFG') THEN BEGIN
    RESET(FMisc);
    READ(FMisc,Misc);
  END ELSE BEGIN
    REWRITE(FMisc);
    WITH Misc DO BEGIN
      UpPath     := HomeDir + '\UPS\';
      DownPath   := HomeDir + '\DOWNS\';
     {ArcPath    := HomeDir + '\';
      DefaultArc := 1;
      ArcBAT     := HomeDir + '\MYARC.BAT';
      UnArcBAT   := HomeDir + '\MYUNARC.BAT';}
      UpProto    := HomeDir + '\UPLOAD.BAT';
      DownProto  := HomeDir + '\DOWNLOAD.BAT';
      Retries    := 10;
      RetryDelay := 60;
      EditorPKG  := 'DEFAULT';
    END;
    WRITE(FMisc,Misc);
  END;
  HideMouse;
 {StartOffScreenDraw;}
  Draw_Window(88,128,554,340,5,'Path Configuration');
  OutText_XY(138,158,1,2,'Upload Path:');     Entry_Field(213,156,5,40,1,Misc.UpPath);
  OutText_XY(120,182,1,2,'Download Path:');   Entry_Field(213,180,5,40,1,Misc.DownPath);
  Draw_Line(93,209,549,209,239);
  Draw_Line(93,210,549,210,249);
  OutText_XY(122,221,1,2,'Custom Upload:');   Entry_Field(213,219,5,40,1,Misc.UpProto);
  OutText_XY(104,245,1,2,'Custom Download:'); Entry_Field(213,243,5,40,1,Misc.DownProto);
  OutText_XY(142,269,1,2,'Call Retries:');    Entry_Field(213,267,1,3,1,IntToStr(Misc.Retries));
  OutText_XY(139,293,1,2,'Retry Delay:');     Entry_Field(213,291,1,3,1,IntToStr(Misc.RetryDelay));
  OutText_XY(259,293,1,2,'In Seconds [0..255]');
  OutText_XY(116,317,1,2,'Viewer PKG File:'); Entry_Field(213,315,5,8,1,Misc.EditorPKG);
  OutText_XY(299,317,1,2,'With No .PKG');
  Draw_Button(425,315,60,31,TRUE,60,'Save');
  Draw_Button(489,315,60,16,TRUE,29,'Quit');
 {EndOffScreenDraw;}
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  SEEK(FMisc,0);
  IF ButNum = 1 THEN BEGIN
    WITH Misc DO BEGIN
      UpPath     := FixPath(Fields^[1].Text);
      DownPath   := FixPath(Fields^[2].Text);
     {ArcPath    := FixPath(Fields^[3].Text);
      ArcBAT     := StripBoth(Fields^[4].Text,' ');
      UnArcBAT   := StripBoth(Fields^[5].Text,' ');}
      UpProto    := StripBoth(Fields^[3].Text,' ');
      DownProto  := StripBoth(Fields^[4].Text,' ');
      Retries    := StrToInt(Fields^[5].Text);
      RetryDelay := StrToInt(Fields^[6].Text);
      EditorPKG  := StripBoth(Fields^[7].Text,' ');
      IF EditorPKG = '' THEN EditorPKG := 'DEFAULT';
    END;
    WRITE(FMisc,Misc);
  END ELSE READ(FMisc,Misc);
  CLOSE(FMisc);
  Kill_Window;
END;

PROCEDURE ViewScreen;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Window(69,183,563,260,5,'View Screen File');
  OutText_XY(79,213,1,2,'File Name:');
  Entry_Field(142,211,5,50,1,ScreenFile);
  Draw_Button(498,235,60,24,TRUE,4,'Okay');
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  ScreenFile := StripBoth(Fields^[1].Text,' ');
  Kill_Window;
  IF FExist(ScreenFile) THEN BEGIN
    DD.BoardID := Misc.EditorPKG;
    DD.UseMAX  := TRUE;
    IF DD.BoardID <> 'DEFAULT' THEN UnpackResources;
    ShutDownSvga;
    Execute(GetEnv('COMSPEC'),'/C SCRNVIEW.BAT ' + SesPath + ' ' + ScreenFile);
    RestartSvga;
  END;
END;

PROCEDURE EditTextFile;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Window(69,183,563,260,5,'Edit Text File');
  OutText_XY(79,213,1,2,'File Name:');
  Entry_Field(142,211,5,50,1,ScreenFile);
  Draw_Button(498,235,60,24,TRUE,4,'Okay');
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  ScreenFile := StripBoth(Fields^[1].Text,' ');
  Kill_Window;
  IF FExist(ScreenFile) THEN BEGIN
    ShutDownSvga;
    Execute(GetEnv('COMSPEC'),'/C TEXTEDIT.BAT ' + ScreenFile);
    RestartSvga;
  END;
END;

PROCEDURE DoSoundCard;
VAR
  ButNum : BYTE;
  FSB    : FILE OF SB_Information;
BEGIN
  ASSIGN(FSB,'MAXSOUND.CFG');
  IF NOT FExist('MAXSOUND.CFG') THEN BEGIN
    REWRITE(FSB);
    WITH SB DO BEGIN
      IRQ     := '2';
      DMA     := '1';
      Address := '220';
    END;
    WRITE(FSB,SB);
    CLOSE(FSB);
  END;
  RESET(FSB);
  READ(FSB,SB);
  HideMouse;
  Draw_Window(190,176,430,277,5,'Sound Card Settings');
  OutText_XY(199,207,1,2,'Port Hex Address:');
  Entry_Field(306,204,1,3,1,SB.Address);
  OutText_XY(253,231,1,2,'Port IRQ:');
  Entry_Field(306,228,1,2,1,SB.IRQ);
  OutText_XY(226,254,1,2,'DMA Channel:');
  Entry_Field(306,252,1,2,1,SB.DMA);
  Draw_Button(365,228,60,31,TRUE,60,'Save');
  Draw_Button(365,252,60,16,TRUE,29,'Quit');
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  SEEK(FSB,0);
  IF ButNum = 1 THEN WITH SB DO BEGIN
    Address := StripBoth(Fields^[1].Text,' ');
    Address := StripBoth(Address,'$');
    IRQ     := StripBoth(Fields^[2].Text,' ');
    DMA     := StripBoth(Fields^[3].Text,' ');
    WRITE(FSB,SB);
  END ELSE READ(FSB,SB);
  CLOSE(FSB);
  Kill_Window;
END;

PROCEDURE DoOtherMenu;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  ExplodeOn := TRUE;
  Draw_Window(318,20,424,240,3,'');
  BlankTopMenu;
  Draw_Button(322,24,98,31,FALSE,0,'Sound Card');
  Draw_Button(322,48,98,20,FALSE,0,'Terminal Mode');
  Draw_Button(322,72,98,32,FALSE,0,'Debug Term');
  Draw_Button(322,96,98,120,FALSE,0,'1 TEXTEDIT.BAT');
  Draw_Button(322,120,98,121,FALSE,0,'2 SCRNVIEW.BAT');
  Draw_Button(322,144,98,122,FALSE,0,'3 ICONEDIT.BAT');
  Draw_Button(322,168,98,123,FALSE,0,'4 OLMR.BAT');
  Draw_Button(322,192,98,124,FALSE,0,'5 FAX.BAT');
  Draw_Button(322,216,98,16,TRUE,29,'Quit');
  ExplodeOn := FALSE;
  ShowMouse;
  REPEAT
    MouseOn := TRUE;
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    CASE ButNum OF
      1 : DoSoundCard;
      4 : EditTextFile;
      5 : ViewScreen;
      6 : BEGIN
            DD.BoardID := Misc.EditorPKG;
            DD.UseMAX  := TRUE;
            IF DD.BoardID <> 'DEFAULT' THEN UnpackResources;
            ShutDownSvga;
            Execute(GetEnv('COMSPEC'),'/C ICONEDIT.BAT ' + SesPath);
            RestartSvga;
          END;
      7 : BEGIN
            ShutDownSvga;
            Execute(GetEnv('COMSPEC'),'/C OLMR.BAT');
            RestartSvga;
          END;
      8 : BEGIN
            ShutDownSvga;
            Execute(GetEnv('COMSPEC'),'/C FAX.BAT');
            RestartSvga;
          END;
    END;
  UNTIL ButNum IN [2,3,9];
  Kill_Window;
  IF ButNum IN [2,3] THEN BEGIN
    IF NOT InitComport THEN BEGIN
      DialMode := 0;
      EXIT;
    END ELSE DialMode := 1;
    WITH DD DO BEGIN
      BBSname     := '';
      PhoneNumber := '';
      UseMAX      := FALSE;
      BoardID     := '';
      AnsiMode    := 1;
      UseSB       := FALSE;
      UserName    := '';
      PassWord    := '';
      PreInit     := '';
    END;
    IF ButNum = 3 THEN BEGIN
      DebugOn   := TRUE;
      DD.UseMAX := TRUE;
    END ELSE DebugOn := FALSE;
    RIPfake := DD.UseMax;
    ShutDownSvga;
    StartUpTextTerminal;
    IF Modem.Init1 <> '' THEN ModemCommand(Modem.Init1);
    IF Modem.Init2 <> '' THEN ModemCommand(Modem.Init2);
    IF Modem.Init3 <> '' THEN ModemCommand(Modem.Init3);
    ModemResult := '';
    WRITELN('OK');
    TerminalMode;
  END;
  ResetTerminal;
END;

PROCEDURE DoEvil;
TYPE MIFdata = ARRAY[0..5243] OF BYTE;
VAR
  F1 : FILE;
  F2 : FILE;
  M  : ^MIFdata;
BEGIN
  IF FSize('MIF.EXE') <> 16337 THEN EXIT;
  NEW(M);
  FILLCHAR(M^,SIZEOF(M^),0);
  ASSIGN(F1,'MIF.EXE');
  ASSIGN(F2,'EXE.MIF');
  RESET(F1,1);
  REWRITE(F2,1);
  SEEK(F1,(FILESIZE(F1) - 5244));
  BLOCKREAD(F1,M^,SIZEOF(M^));
  BLOCKWRITE(F2,M^,SIZEOF(M^));
  CLOSE(F1);
  CLOSE(F2);
  DISPOSE(M);
  C.ActiveHdr := 4;
  HideMouse;
  StartOffScreenDraw;
  Draw_Window(200,150,439,317,1,'Oh No - Not A MAX Program!  ;-)');
  FG_SetColor(0);
  FG_Rect(204,435,174,313);
  Put_Image(287,174,'EXE.MIF');
  ERASE(F2);
  OutText_XY(208,180,111,1,'Hey, did you know there');
  OutText_XY(208,190,111,1,'are some sysops out');
  OutText_XY(208,200,111,1,'there that are so');
  OutText_XY(208,210,111,1,'painfully jealous');
  OutText_XY(208,220,111,1,'of MAX Graphics');
  OutText_XY(208,230,111,1,'that they claim');
  OutText_XY(208,240,111,1,'it is ''Evil'' and');
  OutText_XY(208,250,111,1,'''Nobody'' in the');
  OutText_XY(208,260,111,1,'world will ever');
  OutText_XY(208,270,111,1,'use it? It sure');
  OutText_XY(208,280,111,1,'looks like you''re');
  OutText_XY(208,290,111,1,'using it huh? Well,');
  OutText_XY(208,300,111,1,'I guess they''re wrong.');
  Draw_Button(411,290,21,16,TRUE,29,'');
  EndOffScreenDraw;
  ShowMouse;
  REPEAT UNTIL MouseHandler(TRUE) <> 0;
  C.ActiveHdr := 57;
  Kill_Window;
END;

PROCEDURE MainMenu;
VAR
  ButNum : BYTE;
BEGIN
  HideMouse;
  Draw_Button(0,0,106,32,FALSE,0,'Dialing Directory');
  Draw_Button(106,0,106,50,FALSE,0,'Modem Setup');
  Draw_Button(212,0,106,25,FALSE,0,'Path Setup');
  Draw_Button(318,0,106,24,FALSE,0,'Other Stuff');
  RaisedBox(424,0,579,20);
  Draw_Button(579,0,60,16,TRUE,29,'Quit');
  Mouse_Field(540,419,91,32,120);
  ShowMouse;
  REPEAT
    ExplodeOn := FALSE;
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    CASE ButNum OF
      1 : BEGIN
            DoDialingDirectory;
            IF DialMode = 1 THEN BEGIN
              IF DD.UseMAX THEN BEGIN
                IF NOT FExist(ResPath + DD.BoardID + '.PKG') THEN
                CopyFile(ResPath + 'DEFAULT.PKG',ResPath + DD.BoardID + '.PKG');
                UnpackResources;
              END;
              DialingWindow;
            END;
            IF DialMode = 2 THEN DoTaggedDial;
          END;
      2 : DoModemSetUp;
      3 : DoPathSetup;
      4 : DoOtherMenu;
      6 : DoEvil;
    END;
  UNTIL (ButNum = 5) OR (FExist('UPDATE.FLG'));
END;

PROCEDURE StartUpSvgaTerminal;
BEGIN
  RIPfake := DD.UseMAX;
  HideMouse;
  Draw_Window(0,0,639,439,2,'');
  RaisedBox(0,0,639,20);
  ShadowText(7,2,15,0,2,'F1 = Menu');
  ShadowText(275,2,15,0,2,ProgramName + ' ' + ProgramVersion);
  IF DD.UseMAX THEN BEGIN
    ShadowText(560,2,15,0,2,'RIP Fake: ON');
    IF FExist(SesPath + 'BACKDROP.MAX') THEN ShowRemoteScreen('BACKDROP.MAX');
  END ELSE ShadowText(560,2,15,0,2,'RIP Fake: OFF');
  UnloadGemFont(FPtr);
  Show_Mem;
  ResetTerminal;
  FrameHigh(540,419,630,450);
  PutIcon30(541,420,97,0);
  PutIcon30(571,420,98,0);
  PutIcon30(600,420,99,0);
  IF DD.AnsiMode = 1 THEN EXIT;
  Draw_Window(0,0,639,439,2,'');
  AnsiFullScreen;
END;

PROCEDURE DialingWindow;
VAR
  Finished : BOOLEAN;
  Loop     : BYTE;
  Tries    : BYTE;
  Result   : STRING;
  BStr     : STRING[6];
  Ch       : CHAR;

PROCEDURE DialStartUp;
VAR
  Loop : BYTE;
BEGIN
  INC(Tries);
  IF Tries = (Misc.Retries + 1) THEN BEGIN
    Finished := TRUE;
    EXIT;
  END;
  ANSI_FG := 7;
  ANSI_BG := 0;
  Clr_Scr;
  Goto_XY(1,10);
  Display_ANSIstr('Call Attempt: #' + IntToStr(Tries) + #13#10);
  Display_ANSIstr('Initializing Modem' + #13#10);
  Display_ANSIstr(#13#10);
  ClearModem;
  WITH Modem DO BEGIN
    IF Init1 <> '' THEN BEGIN ModemCommand(Init1); Display_ANSIstr(ModemResult+#13#10); END;
    IF Init2 <> '' THEN BEGIN ModemCommand(Init2); Display_ANSIstr(ModemResult+#13#10); END;
    IF Init3 <> '' THEN BEGIN ModemCommand(Init3); Display_ANSIstr(ModemResult+#13#10); END;
    IF DD.PreInit <> '' THEN BEGIN ModemCommand(DD.PreInit); Display_ANSIstr(ModemResult+#13#10); END;
    ModemCommand(Dial + DD.PhoneNumber);
  END;
  Result := ModemResult;
  IF POS('CONNECT',Result) = 0 THEN Result := '';
END;

PROCEDURE CountDown;
VAR
  Count : BYTE;
  Ch    : CHAR;
BEGIN
  Result := '';
  IF Tries = Misc.Retries THEN BEGIN
    DialStartUp;
    EXIT;
  END;
  Count   := Misc.RetryDelay;
  ANSI_FG := 10;
  ANSI_BG := 0;
  Display_ANSIstr('Seconds Until Next Attempt: ');
  REPEAT
    Goto_XY(29,10);
    Display_ANSIstr(PadRight(IntToStr(Count),' ',3));
    IF KEYPRESSED THEN Ch := READKEY;
    IF Ch = #27 THEN BEGIN
      Finished := TRUE;
      EXIT;
    END;
    DEC(Count);
    DELAY(1000);
  UNTIL COUNT = 0;
  DialStartUp;
END;

BEGIN
  IF DD.PhoneNumber = '' THEN EXIT;
  IF NOT InitComport THEN BEGIN
    DialMode    := 0;
    EXIT;
  END;
  RIPfake   := DD.UseMax;
  Connected := FALSE;
  IndexResources;
  HideMouse;
 {StartOffScreenDraw;}
  Draw_Window(185,115,451,325,5,'Calling: ' + DD.BBSname);
  Text_View_Port(190,143,32,10); Goto_XY(1,10);
  ShadowText(211,306,14,0,2,'Press The <ESC> Key To Cancel Dialing');
 {EndOffScreenDraw;}
  BlankTopMenu;
  ClearKeyBuffer;
  Finished := FALSE;
  Tries    := 0;
  Result   := '';
  DialStartUp;
  REPEAT
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #27 THEN SendChar(Ch);
      Finished := TRUE;
    END;
    IF (DataAvailable) AND (NOT Finished) THEN BEGIN
      Ch     := ReadChar;
      Result := Result + Ch;
      IF Ch < #32 THEN BEGIN
        Display_ANSIstr(Result);
        Result := AllCaps(Result);
        IF (POS('BUSY',Result) > 0) OR (POS('NO ANSWER',Result) > 0) THEN BEGIN
          IF QueueSize > 0 THEN BEGIN
            ClearModem;
            DeInitComport;
            ShowMouse;
            Kill_Window;
            EXIT;
          END;
          CountDown;
        END;
        IF POS('NO CARRIER',Result) > 0 THEN Finished := TRUE;
        IF POS('VOICE',Result) > 0 THEN Finished := TRUE;
        IF (POS('RING',Result) > 0) AND (POS('RINGING',Result) = 0) THEN Finished := TRUE;
        IF POS('FAX',Result) > 0 THEN Finished := TRUE;
        IF POS('FCON',Result) > 0 THEN Finished := TRUE;
        IF POS('ERROR',Result) > 0 THEN Finished := TRUE;
        IF (POS('CONNECT',Result) > 0) OR ((POS('CARRIER',Result) > 0) AND (POS('NO',Result) = 0)) THEN BEGIN
          BStr := '';
          DELETE(Result,1,8);
          FOR Loop := 1 TO LENGTH(Result) DO BEGIN
           {IF (Result[Loop] > #47) AND (Result[Loop] < #58) THEN BStr := BStr + Result[Loop];}
            IF NOT (Result[Loop] IN ['0'..'9']) THEN BREAK ELSE BStr := BStr + Result[Loop];
          END;
          IF (StrToInt(BStr) > 0) AND
             (StrToInt(BStr) <= CommDef.Baud) THEN ActualBaud := StrToInt(BStr)
                                              ELSE ActualBaud := CommDef.Baud;
          ClearModem; DELAY(1000);
          ModemResult := '';
          Finished    := TRUE;
          Connected   := TRUE;
          IF DD.AnsiMode = 1 THEN BEGIN
            Kill_Window;
            StartUpSvgaTerminal;
            ShutDownSvga;
            StartUpTextTerminal;
            TerminalMode;
          END ELSE BEGIN
            Kill_Window;
            StartUpSvgaTerminal;
            TerminalMode;
            ShowMouse;
          END;
          EXIT;
        END;
        Result := '';
      END;
    END ELSE TimeSlice;
  UNTIL Finished;
  ClearModem;
  IF Carrier THEN HangUp;
  DeInitComport;
  ShowMouse;
  Kill_Window;
END;

PROCEDURE DoTaggedDial; {This is lame and unfinished, but it works...}
VAR
  FDD  : FILE OF Dialing_Directory;
  Loop : BYTE;
  Ch   : CHAR;
BEGIN
  ASSIGN(FDD,'QUEUE.DIR');
  RESET(FDD);
  FOR Loop := 0 TO (FILESIZE(FDD) - 1) DO BEGIN
    MouseMask(MouseHourGlass);
    SEEK(FDD,Loop);
    READ(FDD,DD);
    IF (DD.BoardID = '') OR (DD.BoardID = 'DEFAULT') THEN BEGIN
      DD.BoardID := 'TAG_TEMP';
      SEEK(FDD,Loop);
      WRITE(FDD,DD);
    END;
    IF KEYPRESSED THEN Ch := READKEY;
    IF (Ch = #27) OR (FExist('UPDATE.FLG')) THEN BEGIN
      MouseMask(MouseHourGlass);
      CLOSE(FDD);
      FErase('QUEUE.DIR');
      CleanUpWorkDirectory;
      LastPkg   := '';
      DialMode  := 0;
      QueueSize := 0;
      CHDIR(NoPath(SesPath));
      CopyFile(ResPath + 'DEFAULT.PKG',SesPath + 'DEFAULT.PKG');
{$IFDEF InternalComp}
      BlindExtract('DEFAULT.PKG');
{$ELSE}
      Execute(HomeDir + '\MAXCOMP.EXE','DEFAULT.PKG D B');
{$ENDIF}
      FErase(SesPath + 'DEFAULT.PKG');
      CHDIR(HomeDir);
      MouseMask(MouseStandard);
      EXIT;
    END;
    IF (DD.BBSname <> '') AND (DD.PhoneNumber <> '') THEN BEGIN
      IF DD.UseMAX THEN BEGIN
        IF NOT FExist(ResPath + DD.BoardID + '.PKG') THEN
        CopyFile(ResPath + 'DEFAULT.PKG',ResPath + DD.BoardID + '.PKG');
        UnpackResources;
      END;
      MouseMask(MouseStandard);
      DialingWindow;
      MouseMask(MouseHourGlass);
      IF Connected THEN BEGIN
        RepackResources;
        FILLCHAR(DD,SIZEOF(DD),0);
        SEEK(FDD,Loop);
        WRITE(FDD,DD);
      END;
      CleanUpWorkDirectory;
      LastPkg := '';
      CHDIR(NoPath(SesPath));
      CopyFile(ResPath + 'DEFAULT.PKG',SesPath + 'DEFAULT.PKG');
{$IFDEF InternalComp}
      BlindExtract('DEFAULT.PKG');
{$ELSE}
      Execute(HomeDir + '\MAXCOMP.EXE','DEFAULT.PKG D B');
{$ENDIF}
      FErase(SesPath + 'DEFAULT.PKG');
      CHDIR(HomeDir);
    END;
  END;
  CLOSE(FDD);
  FErase('QUEUE.DIR');
  DialMode  := 0;
  QueueSize := 0;
  MouseMask(MouseStandard);
END;

PROCEDURE ProgramBanner;
BEGIN
  CLRSCR;
  OutTextXY(1,1,11,0,ProgramName + ' ' + ProgramVersion);
  OutTextXY(1,2,3,0,Copyright);
  HideCursor;
  GOTOXY(1,4);
END;

PROCEDURE Error(Code : BYTE);
BEGIN
  ProgramBanner;
  OutTextXY(1,6,12,0,'MAXterm System Error: ' + IntToStr(Code));
  OutTextXY(1,8,12,0,'See MAXTERM.DOC For Details...');
  WRITE(^G);
  FErase('MAXTERM.PCX');
  ShowCursor;
  HALT;
END;

PROCEDURE ReadCfg;
VAR
  FMisc    : FILE OF Misc_Information;
  FSB      : FILE OF SB_Information;
  FCommDef : FILE OF ComPortDefinition;
  FModem   : FILE OF Modem_Commands;
  ButNum   : BYTE;
PROCEDURE ChangeHomeDir;
BEGIN
  HomeDir := GetFilePath(ParamStr(0));
  HomeDir := NoPath(HomeDir);
  CHDIR(HomeDir);
END;
BEGIN
  GETDIR(0,HomeDir);
  IF NOT FExist(HomeDir + '\MIF.EXE') THEN ChangeHomeDir;
  ResPath    := HomeDir + '\RESOURCE\';
  SesPath    := HomeDir + '\SESSION\';
  MsgInfPath := SesPath;
  IconLib16  := SesPath + 'ICON_LIB.001';
  IconLib30  := SesPath + 'ICON_LIB.002';
  IconLib60  := SesPath + 'ICON_LIB.003';
  DialMode   := 0;
  MakeDir(ResPath);
  MakeDir(SesPath);
  ASSIGN(FMisc,'MAX_MISC.CFG');
  IF FExist('MAX_MISC.CFG') THEN BEGIN
    RESET(FMisc);
    READ(FMisc,Misc);
  END ELSE BEGIN
    REWRITE(FMisc);
    WITH Misc DO BEGIN
      UpPath     := HomeDir + '\UPS\';
      DownPath   := HomeDir + '\DOWNS\';
      ArcPath    := HomeDir + '\';
      DefaultArc := 1;
      ArcBAT     := HomeDir + '\MYARC.BAT';
      UnArcBAT   := HomeDir + '\MYUNARC.BAT';
      UpProto    := HomeDir + '\UPLOAD.BAT';
      DownProto  := HomeDir + '\DOWNLOAD.BAT';
      Retries    := 10;
      RetryDelay := 60;
      EditorPKG  := 'DEFAULT';
    END;
    WRITE(FMisc,Misc);
  END;
  CLOSE(FMisc);
  DownPath1 := Misc.DownPath;
  ASSIGN(FModem,'MAXMODEM.CFG');
  ASSIGN(FCommDef,'MAX_PORT.CFG');
  IF (FExist('MAXMODEM.CFG')) AND (FExist('MAX_PORT.CFG')) THEN BEGIN
    RESET(FCommDef);
    RESET(FModem);
    READ(FCommDef,CommDef);
    READ(FModem,Modem);
  END ELSE BEGIN
    REWRITE(FCommDef);
    REWRITE(FModem);
    WRITE(FCommDef,CommDef);
    WRITE(FModem,Modem);
  END;
  CLOSE(FModem);
  CLOSE(FCommDef);
  ASSIGN(FSB,'MAXSOUND.CFG');
  IF NOT FExist('MAXSOUND.CFG') THEN BEGIN
    REWRITE(FSB);
    WITH SB DO BEGIN
      IRQ     := '2';
      DMA     := '1';
      Address := '220';
    END;
    WRITE(FSB,SB);
    CLOSE(FSB);
  END;
  RESET(FSB);
  READ(FSB,SB);
  CLOSE(FSB);
  ProgramBanner;
  IF NOT Fexist(ResPath + 'DEFAULT.PKG') THEN Error(100);
  IF AllCaps(FileToCrc(ResPath + 'DEFAULT.PKG')) <> '9A1E5DF3' THEN Error(101);
  IF MEMAVAIL < 102400 THEN Error(102);
  CleanUpWorkDirectory;
  OutTextXY(1,4,2,0,'Unpacking Graphics Resources...One Moment Please...');
  CHDIR(NoPath(SesPath));
  CopyFile(ResPath + 'DEFAULT.PKG',SesPath + 'DEFAULT.PKG');
{$IFDEF InternalComp}
  BlindExtract('DEFAULT.PKG');
{$ELSE}
  Execute(HomeDir + '\MAXCOMP.EXE','DEFAULT.PKG D B');
{$ENDIF}
  FErase(SesPath + 'DEFAULT.PKG');
  CHDIR(HomeDir);
  IF (NOT FExist(SesPath + 'ICON_LIB.001')) OR
     (NOT FExist(SesPath + 'ICON_LIB.002')) OR
     (NOT FExist(SesPath + 'ICON_LIB.003')) THEN Error(103);
END;

PROCEDURE CheckForUpdate;
BEGIN
  IF FExist('UPDATE.FLG') THEN BEGIN
    WRITELN('On your last call you received a terminal program update and this');
    WRITELN('program will not run until you have applied the update to it...');
    WRITELN;
    WRITELN('Please change to your download directory and run SETUP.EXE before');
    WRITELN('you attempt to run this program again...');
    ShowCursor;
    HALT;
  END;
END;

PROCEDURE StartUp;
BEGIN
  ReadCfg;
  CheckForUpdate;
  Execute('MIF.EXE','MAXTERM.BMX MAXTERM.PCX DD');
  IF NOT FireUpGui THEN Error(104);
  FErase('MAXTERM.PCX');
  WriteSystemInfo;
  MainMenu;
  RepackResources;
  CleanUpWorkDirectory;
  ShutDownGui;
  FErase('QUEUE.DIR');
  FErase('RES.NFO');
  ProgramBanner;
  CheckForUpdate;
  ShowCursor;
END;

PROCEDURE Auto_Mode;
VAR
  BBS   : INTEGER;
  DDdat : FILE OF Dialing_Directory;
BEGIN
  ReadCfg;
  CheckForUpdate;
  ShowBanner := FALSE;
  AutoMode   := TRUE;
  Execute('MIF.EXE','MAXTERM.BMX MAXTERM.PCX DD');
  IF NOT FireUpGui THEN Error(104);
  FErase('MAXTERM.PCX');
  WriteSystemInfo;
  FILLCHAR(DD,SIZEOF(DD),0);
  ActualBaud  := CommDef.Baud;
  DialMode    := 2;
  MAXmode     := FALSE;
  FullMAX     := FALSE;
  DD.BoardID  := 'DEFAULT';
  DD.ANSImode := 1;
  DD.UseSB    := TRUE;
  DD.UseMAX   := TRUE;
  BBS         := StrToInt(PARAMSTR(2));
  IF BBS > 0 THEN BEGIN
    ASSIGN(DDdat,'MAXPHONE.DIR');
    RESET(DDdat);
    IF BBS <= FILESIZE(DDdat) THEN BEGIN
      DEC(BBS);
      SEEK(DDdat,BBS);
      READ(DDdat,DD);
    END;
    CLOSE(DDdat);
  END ELSE BEGIN
    IF FExist(ResPath+AllCaps(PARAMSTR(2))+'.PKG') THEN DD.BoardID := AllCaps(PARAMSTR(2))
                                                   ELSE DD.BoardID := 'TEMPBBS';
  END;
  IF NOT FExist(ResPath + DD.BoardID + '.PKG') THEN CopyFile(ResPath + 'DEFAULT.PKG',ResPath + DD.BoardID + '.PKG');
  UnpackResources;
  IndexResources;
  IF DD.AnsiMode = 1 THEN BEGIN
    StartUpSvgaTerminal;
    ShutDownSvga;
    StartUpTextTerminal;
    IF InitComport THEN TerminalMode;
  END ELSE BEGIN
    StartUpSvgaTerminal;
    IF InitComport THEN TerminalMode;
    ShowMouse;
  END;
  RepackResources;
  CleanUpWorkDirectory;
  ShutDownGui;
  FErase('QUEUE.DIR');
  FErase('RES.NFO');
  ProgramBanner;
  CheckForUpdate;
  ShowCursor;
END;

BEGIN
  ScreenFile := '';
  DebugOn    := FALSE;
  AutoMode   := FALSE;
END.
