{$I DEFINES.INC}
UNIT TEXT_GUI;{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  BMP Color Averaging procedure is courtesy of Sean Price (Rude Dog Software).
}

INTERFACE

{$L STRING2}

TYPE  Colour_Scheme = RECORD
      CurrentBackGround : BYTE;
      CurrentForeGround : BYTE;
      RaisedBoxBack     : BYTE;
      RaisedBoxDark     : BYTE;
      RaisedBoxLight    : BYTE;
      InvertedBoxBack   : BYTE;
      InvertedBoxDark   : BYTE;
      InvertedBoxLight  : BYTE;
      WindowBack        : BYTE;
      WindowHeaderBack  : BYTE;
      WindowHeaderForeE : BYTE;
      WindowHeaderForeD : BYTE;
      WindowFrameLight  : BYTE;
      WindowFrameDark   : BYTE;
      ButtonBack        : BYTE;
      ButtonFore        : BYTE;
      ButtonHighlight   : BYTE;
      ArrowsBack        : BYTE;
      ArrowsFore        : BYTE;
      PickListBack      : BYTE;
      PickListFore      : BYTE;
      PickListBackS     : BYTE;
      PickListForeS     : BYTE;
      ScrollBars        : BYTE;
      LocatorFore       : BYTE;
      LocatorBack       : BYTE;
      FieldBack         : BYTE;
      FieldFore         : BYTE;
      FieldBackS        : BYTE;
      FieldForeS        : BYTE;
      FieldHighlight    : BYTE;
      FieldDashes       : BYTE;
      MenuText          : BYTE;
      MenuHotkey        : BYTE;
      MenuBarText       : BYTE;
      MenuBarHotkey     : BYTE;
      HiddenFG          : BYTE;
      HiddenBG          : BYTE;
      END;
TYPE  GetPutRecord      = RECORD
      LineLength        : BYTE;
      LINE              : ARRAY[1..160] OF BYTE;
      END;
TYPE  Get_Put1          = RECORD
      NumLines          : BYTE;
      Lines             : ARRAY[1..25] OF GetPutRecord;
      END;
TYPE  Get_Put2          = RECORD
      NumLines          : BYTE;
      Lines             : ARRAY[1..25] OF GetPutRecord;
      END;
TYPE  ScreenCutouts     = RECORD
      NumLines          : BYTE;
      Lines             : ARRAY[1..25] OF GetPutRecord;
      END;
TYPE  Sv_Screen1        = ARRAY[1..4000] OF BYTE;
TYPE  Sv_Screen2        = ARRAY[1..4000] OF BYTE;
TYPE  Saved_Cutouts     = ARRAY[1..4000] OF BYTE;
TYPE  Screen_Info       = RECORD
      Index             : BYTE;
      OrigX1            : WORD;
      OrigY1            : WORD;
      OrigX2            : WORD;
      OrigY2            : WORD;
      XOffset           : INTEGER;
      YOffSet           : INTEGER;
      Title             : STRING;
      END;
TYPE  ButtonInfo        = RECORD
      x                 : BYTE;
      y                 : BYTE;
      Text              : STRING[30];
      Holdable          : BOOLEAN;
      ReturnValue       : BYTE;
      Style             : BYTE;
      END;
TYPE  FieldInfo         = RECORD
      x                 : BYTE;
      y                 : BYTE;
      Text              : STRING;
      CursorPos         : BYTE;
      EntryType         : BYTE; {0-Plain String  1-Plain Numeric  2-Proper String}
                                {3-Date          4-Phone Number   5-Upper Case}
      MaxLength         : BYTE;
      Active            : BOOLEAN;
      END;
TYPE  Pick_Info         = RECORD
      Active            : BOOLEAN;
      x                 : BYTE;
      y                 : BYTE;
      Top               : WORD;
      NumItems          : WORD;
      ItemsOnScrn       : BYTE;
      Current           : WORD;
      MaxChars          : BYTE;
      Locator           : WORD;
      END;
TYPE  Pick_List         = ARRAY[1..800] OF STRING[80];
VAR
      SvScreen          : ^Sv_Screen1;
      SvScreen2         : ^Sv_Screen2;
      GetPut1           : ^Get_Put1;
      GetPut2           : ^Get_Put2;
      Colours           : Colour_Scheme;
      CurrentWindow     : BYTE;
      ScreenInfo        : Screen_Info;
      CutActive         : ARRAY[1..10,0..1] OF BOOLEAN;
      Cutout1           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout2           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout3           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout4           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout5           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout6           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout7           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout8           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout9           : ARRAY[0..1] OF ^Saved_Cutouts;
      Cutout10          : ARRAY[0..1] OF ^Saved_Cutouts;
      Buttons           : ARRAY[1..30] OF ButtonInfo;
      Fields            : ARRAY[1..30] OF FieldInfo;
      PickList          : ^Pick_List;
      PickInfo          : Pick_Info;
      NFields           : BYTE;
      NButtons          : BYTE;
      FieldNum          : BYTE;
      LastPressed       : BYTE;
      MenuWidth         : BYTE;
      MemFG             : BYTE;
      MemBG             : BYTE;
      SysClk            : ^WORD; {Real mem $40:$6C} {BIOS system clock counter.    }

      {Startup - Call at the VERY beginning of every program}
      PROCEDURE FireUpText;

      {Main Loop Function}
      FUNCTION  MouseHandler(DoKeys : BOOLEAN) : BYTE;
      PROCEDURE SliceMouse;

      {Pick List Functions - In Order Of Function}
      PROCEDURE NewPickList(x,y,OnScreen,MaxChars : BYTE);
      PROCEDURE AddToPickList(InString : STRING);
      PROCEDURE SetUpPickList;
      PROCEDURE ResetPickList(Item : WORD);

      {General Drawing}
      PROCEDURE SystemField       (x,y,EntryType,MaxLength : BYTE; Stuff : STRING);
      PROCEDURE SystemButton      (x,y,return,Style : BYTE; Hold,Redraw : BOOLEAN; Title : STRING);
      PROCEDURE DrawWindow        (x1,y1,x2,y2 : BYTE; title : STRING);
      PROCEDURE WindowHeader      (title : STRING; Enabled : BOOLEAN);
      PROCEDURE OutTextXY         (x,y,f,b : BYTE; s : STRING);
      PROCEDURE OutTextXYFR       (x,y,f,b : BYTE; s : STRING);
      PROCEDURE TextBackGround_BS (Back : BYTE);
      PROCEDURE TextColor_BS      (Fore : BYTE);
      PROCEDURE SetPixeltoMickey  (Horiz,Verti : BYTE);
      PROCEDURE Put               (x,y : WORD; Kill : BOOLEAN);
      PROCEDURE Put2              (x,y : WORD; Kill : BOOLEAN);
      PROCEDURE Get               (x1,y1,x2,y2 : WORD);
      PROCEDURE Get2              (x1,y1,x2,y2 : WORD);
      PROCEDURE InvertedBox       (x1,y1,x2,y2 : BYTE);
      PROCEDURE RaisedBox         (x1,y1,x2,y2 : BYTE);
      PROCEDURE ChangeField       (Number : BYTE);
      PROCEDURE RedrawField;
      PROCEDURE Save_Screen2;
      PROCEDURE Load_Screen2;
      PROCEDURE Save_Screen;
      PROCEDURE Load_Screen;
      PROCEDURE KillWindow;
      PROCEDURE HideMouse;
      PROCEDURE ShowMouse;
      PROCEDURE HideCursor;
      PROCEDURE ShowCursor;

      {Shutdown}
      PROCEDURE ShutdownText;

      {Miscellaneous Procedures}
      PROCEDURE DoTextColors;
      PROCEDURE NewWin;
      PROCEDURE RedWin;
      PROCEDURE BlueWin;
      PROCEDURE PurpleWin;
      PROCEDURE GreenWin;
      PROCEDURE CyanWin;
      PROCEDURE Show_Mem;
      PROCEDURE CustomButton(X,Y,FG,BG,Return : BYTE ; Title : STRING);
      PROCEDURE AddArrows;
      PROCEDURE NewMenu(X1,Y1,X2,Y2 : BYTE ; Title : STRING);
      PROCEDURE AddMenuItem(X,Y,Return : BYTE ; Title : STRING);
      PROCEDURE AddMenuBarItem(X,Y,Return : BYTE ; Title : STRING);

IMPLEMENTATION

USES DOS, CRT, GUI_UTIL, FASTW1;

VAR Mouse_Installed : BOOLEAN;
    Mouse_Error     : WORD;

FUNCTION Replicate(Ch : CHAR; Count : WORD) : STRING; EXTERNAL;

PROCEDURE NewWin;
BEGIN
  HideMouse;
  NFields  := 0;
  NButtons := 0;
END;

PROCEDURE RedWin;
BEGIN
  Colours.WindowBack := 4;
  Colours.WindowFrameLight := 12;
  Colours.WindowHeaderForeE := 15;
  Colours.WindowHeaderBack := 12;
END;

PROCEDURE BlueWin;
BEGIN
  Colours.WindowBack := 1;
  Colours.WindowFrameLight := 9;
  Colours.WindowHeaderForeE := 15;
  Colours.WindowHeaderBack := 9;
END;

PROCEDURE PurpleWin;
BEGIN
  Colours.WindowBack := 5;
  Colours.WindowFrameLight := 13;
  Colours.WindowHeaderForeE := 15;
  Colours.WindowHeaderBack := 13;
END;

PROCEDURE GreenWin;
BEGIN
  Colours.WindowBack := 2;
  Colours.WindowFrameLight := 10;
  Colours.WindowHeaderForeE := 0;
  Colours.WindowHeaderBack := 10;
END;

PROCEDURE CyanWin;
BEGIN
  Colours.WindowBack := 3;
  Colours.WindowFrameLight := 11;
  Colours.WindowHeaderForeE := 1;
  Colours.WindowHeaderBack := 11;
END;

PROCEDURE CustomButton(X,Y,FG,BG,Return : BYTE ; Title : STRING);
VAR
  OldFore,
  OldBack : BYTE;
BEGIN
  OldFore := Colours.ArrowsFore; OldBack := Colours.ArrowsBack;
  Colours.ArrowsFore := FG;
  Colours.ArrowsBack := BG;
  SystemButton(X,Y,Return,2,FALSE,TRUE,Title);
  Colours.ArrowsFore := OldFore;
  Colours.ArrowsBack := OldBack;
END;

PROCEDURE AddArrows;
VAR
  OldFore,
  OldBack : BYTE;
BEGIN
  OldFore := Colours.ArrowsFore; OldBack := Colours.ArrowsBack;
  Colours.ArrowsFore := Colours.HiddenFG;
  Colours.ArrowsBack := Colours.HiddenBG;
  SystemButton(1,1,75,2,FALSE,TRUE,'    ');
  SystemButton(76,1,77,2,FALSE,TRUE,'    ');
  Colours.ArrowsFore := OldFore;
  Colours.ArrowsBack := OldBack;
END;

PROCEDURE Show_Mem;
BEGIN
{$IFNDEF DPMI}
  OutTextXY(61,25,MemFG,MemBG,'Free Memory: ' + PadRight(IntToStr(MEMAVAIL),' ',6));
{$ELSE}
  OutTextXY(59,25,MemFG,MemBG,'Free Memory: ' + PadRight(IntToStr(MEMAVAIL),' ',8));
{$ENDIF}
END;

PROCEDURE NewMenu(X1,Y1,X2,Y2 : BYTE ; Title : STRING);
BEGIN
  IF CurrentWindow > 0 THEN KillWindow;
  DrawWindow(X1,Y1,X2,Y2,Title);
  MenuWidth := X2 - X1 - 2;
END;

PROCEDURE AddMenuItem(X,Y,Return : BYTE ; Title : STRING);
VAR
  OldFore,
  OldBack : BYTE;
  HotKey  : STRING[1];
BEGIN
  OldFore := Colours.ArrowsFore; OldBack := Colours.ArrowsBack;
  Colours.ArrowsFore := Colours.WindowBack;
  Colours.ArrowsBack := Colours.WindowBack;
  HotKey := COPY(Title,1,1);
  Title := ' ' + Title;
  IF LENGTH(Title) < MenuWidth THEN REPEAT Title := Title + ' ' UNTIL LENGTH(Title) = MenuWidth;
  SystemButton(X,Y,Return,2,FALSE,TRUE,Title);
  OutTextXY(X,Y,Colours.MenuText,Colours.WindowBack,Title);
  OutTextXY(X + 1,Y,Colours.MenuHotkey,Colours.WindowBack,HotKey);
  Colours.ArrowsFore := OldFore;
  Colours.ArrowsBack := OldBack;
END;

PROCEDURE AddMenuBarItem(X,Y,Return : BYTE ; Title : STRING);
VAR
  OldFore,
  OldBack : BYTE;
  HotKey  : STRING[1];
BEGIN
  OldFore := Colours.ArrowsFore; OldBack := Colours.ArrowsBack;
  Colours.ArrowsFore := Colours.WindowBack;
  Colours.ArrowsBack := Colours.WindowBack;
  HotKey := COPY(Title,1,1);
  SystemButton(X,Y,Return,2,FALSE,TRUE,Title);
  OutTextXY(X,Y,Colours.MenuBarText,MemBG,Title);
  OutTextXY(X,Y,Colours.MenuBarHotkey,MemBG,HotKey);
  Colours.ArrowsFore := OldFore;
  Colours.ArrowsBack := OldBack;
END;

PROCEDURE HideCursor; Assembler;
ASM
  MOV ax,$0100
  MOV cx,$2607
  INT $10
END;

PROCEDURE ShowCursor; Assembler;
ASM
  MOV ax,$0100
  MOV cx,$0506
  INT $10
END;

PROCEDURE SetPixeltoMickey(Horiz,Verti : BYTE);
VAR
  Regs : REGISTERS;
BEGIN
  Regs.Ax := 15;
  Regs.Cx := Horiz;
  Regs.Dx := Verti;
  INTR($33,Regs);
END;

FUNCTION InitMouse : WORD;
VAR
  Regs : REGISTERS;
BEGIN
  WITH Regs DO Ax := 0;
  INTR($33,Regs);
  InitMouse := Regs.Ax;
END;

PROCEDURE ShowMouse;
VAR
  Regs : REGISTERS;
BEGIN
  Regs.Ax := 1;
  INTR($33,Regs);
END;

PROCEDURE HideMouse;
VAR
  Regs : REGISTERS;
BEGIN
  Regs.AX := 2;
  INTR($33,Regs);
END;

FUNCTION GetMouseX : BYTE;
VAR
  Regs : REGISTERS;
BEGIN
  Regs.Ax := 3;
  INTR($33,Regs);
  GetMouseX := TRUNC((SUCC(Regs.Cx) + 7) / 8);
END;

FUNCTION GetMouseY : BYTE;
VAR
  Regs : REGISTERS;
BEGIN
  Regs.Ax := 3;
  INTR($33,Regs);
  GetMouseY := TRUNC((SUCC(Regs.Dx) + 7) / 8);
END;

FUNCTION GetMouseButtons : BYTE;
VAR
  Regs : REGISTERS;
BEGIN
  Regs.Ax := 3;
  INTR($33,Regs);
  GetMouseButtons := Regs.Bx;
END;

PROCEDURE HighBackGrounds(TurnOn : BOOLEAN);
VAR
  Regs : REGISTERS;
BEGIN
  IF TurnOn THEN Regs.BL := 0
            ELSE Regs.BL := 1;
  Regs.AX := $1003;
  INTR($10,Regs);
END;

PROCEDURE TextColor_BS(Fore : BYTE);
BEGIN
  Colours.CurrentForeGround := Fore;
  TextAttr := (Colours.CurrentForeGround + Colours.CurrentBackGround * 16);
END;

PROCEDURE TextBackGround_BS(Back : BYTE);
BEGIN
  Colours.CurrentBackGround := Back;
  TextAttr := (Colours.CurrentForeGround + Colours.CurrentBackGround * 16);
END;

PROCEDURE DoTextColors;
BEGIN
  Colours.RaisedBoxBack     := 1;
  Colours.RaisedBoxDark     := 0;
  Colours.RaisedBoxLight    := 9;
  Colours.InvertedBoxBack   := 1;
  Colours.InvertedBoxDark   := 0;
  Colours.InvertedBoxLight  := 9;
  Colours.WindowBack        := 1;
  Colours.WindowHeaderBack  := 9;
  Colours.WindowHeaderForeE := 15;
  Colours.WindowHeaderForeD := 7;
  Colours.WindowFrameLight  := 9;
  Colours.WindowFrameDark   := 0;
  Colours.ButtonBack        := 7;
  Colours.ButtonFore        := 0;
  Colours.ButtonHighlight   := 4;
  Colours.ArrowsBack        := 15;
  Colours.ArrowsFore        := 0;
  Colours.PickListBack      := 7;
  Colours.PickListFore      := 0;
  Colours.PickListBackS     := 3;
  Colours.PickListForeS     := 15;
  Colours.ScrollBars        := 8;
  Colours.LocatorFore       := 0;
  Colours.LocatorBack       := 15;
  Colours.FieldBack         := 0;
  Colours.FieldFore         := 3;
  Colours.FieldBackS        := 0;
  Colours.FieldForeS        := 11;
  Colours.FieldHighlight    := 15;
  Colours.FieldDashes       := 8;
  Colours.MenuText          := 11;
  Colours.MenuHotkey        := 15;
  Colours.MenuBarText       := 0;
  Colours.MenuBarHotKey     := 4;
  Colours.HiddenFG          := 8;
  Colours.HiddenBG          := 8;
  MemFG                     := 0;
  MemBG                     := 7;
END;

PROCEDURE FireUpText;
BEGIN
     FileMode := 66;
     HIGHVIDEO;
     TEXTMODE(C80);
     HighBackGrounds(TRUE);
     TextColor_BS(7);
     TextBackground_BS(0);
     CLRSCR;
     DoTextColors;
     InitMouse;
     ShowMouse;
     SetPixeltoMickey(5,10);
     NButtons    := 0;
     NFields     := 0;
     FieldNum    := 0;
     LastPressed := 0;
     FILLCHAR(ScreenInfo,SIZEOF(ScreenInfo),0);
     FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
     FILLCHAR(Buttons,SIZEOF(Buttons),0);
     FILLCHAR(Fields,SIZEOF(Fields),0);
END;

PROCEDURE ShutdownText;
BEGIN
     HideMouse;
     TEXTMODE(C80);
     HighBackGrounds(FALSE);
     TEXTCOLOR(7);
     TEXTBACKGROUND(0);
     CLRSCR;
     ShowCursor;
     NButtons    := 0;
     NFields     := 0;
     FieldNum    := 0;
     LastPressed := 0;
     FILLCHAR(ScreenInfo,SIZEOF(ScreenInfo),0);
     FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
     FILLCHAR(Buttons,SIZEOF(Buttons),0);
     FILLCHAR(Fields,SIZEOF(Fields),0);
END;

PROCEDURE InvertedBox(x1,y1,x2,y2 : BYTE);
VAR  Loop : BYTE;
     Temp : STRING;
BEGIN
     WITH Colours DO
     BEGIN
          Temp := '' + Replicate('',x2 - x1 - 1);
          FastWrite(Temp,y1,x1,(InvertedBoxBack * 16) + InvertedBoxDark);
          FastWrite('',y1,x2,(InvertedBoxBack * 16) + InvertedBoxLight);
          FOR Loop := y1 + 1 TO y2 - 1 DO
          BEGIN
               FastWrite('',Loop,x1,(InvertedBoxBack * 16) + InvertedBoxDark);
               FastWrite('',Loop,x2,(InvertedBoxBack * 16) + InvertedBoxLight);
          END;
          Temp := Replicate('',x2 - x1 - 1) + '';
          FastWrite(Temp,y2,x1 + 1,(InvertedBoxBack * 16) + InvertedBoxLight);
          FastWrite('',y2,x1,(InvertedBoxBack * 16) + InvertedBoxDark);
     END;
END;

PROCEDURE RaisedBox(x1,y1,x2,y2 : BYTE);
VAR  Loop : BYTE;
     Temp : STRING;
BEGIN
     WITH Colours DO
     BEGIN
          Temp := '' + Replicate('',x2 - x1 - 1);
          FastWrite(Temp,y1,x1,(RaisedBoxBack * 16) + RaisedBoxLight);
          FastWrite('',y1,x2,(RaisedBoxBack * 16) + RaisedBoxDark);
          FOR Loop := y1 + 1 TO y2 - 1 DO
          BEGIN
               FastWrite('',Loop,x1,(RaisedBoxBack * 16) + RaisedBoxLight);
               FastWrite('',Loop,x2,(RaisedBoxBack * 16) + RaisedBoxDark);
          END;
          Temp := Replicate('',x2 - x1 - 1) + '';
          FastWrite(Temp,y2,x1 + 1,(RaisedBoxBack * 16) + RaisedBoxDark);
          FastWrite('',y2,x1,(RaisedBoxBack * 16) + RaisedBoxLight);
     END;
END;

PROCEDURE OutTextXY(x,y,f,b : BYTE; s : STRING);
BEGIN
     FastWrite(s,y,x,(b * 16) + f);
END;

PROCEDURE OutTextXYFR(x,y,f,b : BYTE; s : STRING);
BEGIN
     FastWrite(s,y,x - LENGTH(s) + 1,(b * 16) + f);
END;

PROCEDURE save_screen;
BEGIN
     NEW(SvScreen);
     MOVE(MEM[SegB800 : 0],SvScreen^,4000);
END;

PROCEDURE load_screen;
BEGIN
     MOVE(SvScreen^,MEM[SegB800 : 0],4000);
     DISPOSE(SvScreen);
END;

PROCEDURE save_screen2;
BEGIN
     NEW(SvScreen2);
     MOVE(MEM[SegB800 : 0],SvScreen2^,4000);
END;

PROCEDURE load_screen2;
BEGIN
     MOVE(SvScreen2^,MEM[SegB800 : 0],4000);
     DISPOSE(SvScreen2);
END;

PROCEDURE Get(x1,y1,x2,y2 : WORD);
VAR  Loop   : WORD;
     Count  : WORD;
BEGIN
     NEW(GetPut1);
     GetPut1^.NumLines := y2 - y1 + 1;
     Count := 1;
     FOR Loop := y1 TO y2 DO
     BEGIN
          GetPut1^.Lines[Count].LineLength := x2 - x1 + 1;
          MOVE(MEM[SegB800 : (((Loop - 1) * 160) + ((x1 - 1) * 2))],GetPut1^.Lines[Count].LINE,(x2 - x1 + 1) * 2);
          INC(Count);
     END;
END;

PROCEDURE Put(x,y : WORD; Kill : BOOLEAN);
VAR  Loop   : WORD;
     Count  : WORD;
BEGIN
     Count := 1;
     FOR Loop := y TO (y + GetPut1^.NumLines - 1) DO
     BEGIN
          MOVE(GetPut1^.Lines[Count].LINE,MEM[SegB800 : (((Loop - 1) * 160) +
          ((x - 1) * 2))],(GetPut1^.Lines[Count].LineLength) * 2);
          INC(Count);
     END;
     IF Kill THEN DISPOSE(GetPut1);
END;

PROCEDURE Get2(x1,y1,x2,y2 : WORD);
VAR  Loop   : WORD;
     Count  : WORD;
BEGIN
     NEW(GetPut2);
     GetPut2^.NumLines := y2 - y1 + 1;
     Count := 1;
     FOR Loop := y1 TO y2 DO
     BEGIN
          GetPut2^.Lines[Count].LineLength := x2 - x1 + 1;
          MOVE(MEM[SegB800 : (((Loop - 1) * 160) + ((x1 - 1) * 2))],GetPut2^.Lines[Count].LINE,(x2 - x1 + 1) * 2);
          INC(Count);
     END;
END;

PROCEDURE Put2(x,y : WORD; Kill : BOOLEAN);
VAR  Loop   : WORD;
     Count  : WORD;
BEGIN
     Count := 1;
     FOR Loop := y TO (y + GetPut2^.NumLines - 1) DO
     BEGIN
          MOVE(GetPut2^.Lines[Count].LINE,MEM[SegB800 : (((Loop - 1) * 160) +
          ((x - 1) * 2))],(GetPut2^.Lines[Count].LineLength) * 2);
          INC(Count);
     END;
     IF Kill THEN DISPOSE(GetPut2);
END;

PROCEDURE Shadow(x1,y1,x2,y2 : WORD);
VAR  xshad   : WORD;
     yshad   : WORD;
     x       : WORD;
     y       : WORD;
     Loop    : WORD;
BEGIN
     x := ((y2 * 160) + (x1 * 2)) + 1;
     FOR Loop := x1 TO x2 DO
     BEGIN
          Mem[SegB800 : x] := 8;
          INC(x,2);
     END;
     y := ((y1 * 160) + ((x2) * 2)) + 1;
     FOR Loop := y1 TO y2 DO
     BEGIN
          Mem[SegB800 : y] := 8;
          INC(y,160);
     END;
END;

PROCEDURE save_cutout(IndexNum,ForeBack : WORD);
BEGIN
     CASE IndexNum OF
     1 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout1[ForeBack]);
     2 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout2[ForeBack]);
     3 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout3[ForeBack]);
     4 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout4[ForeBack]);
     5 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout5[ForeBack]);
     6 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout6[ForeBack]);
     7 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout7[ForeBack]);
     8 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout8[ForeBack]);
     9 :   IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout9[ForeBack]);
     10 :  IF CutActive[IndexNum,ForeBack] = FALSE THEN NEW(Cutout10[ForeBack]);
     END;
     CASE IndexNum OF
     1 :   MOVE(MEM[SegB800 : 0],Cutout1[ForeBack]^,4000);
     2 :   MOVE(MEM[SegB800 : 0],Cutout2[ForeBack]^,4000);
     3 :   MOVE(MEM[SegB800 : 0],Cutout3[ForeBack]^,4000);
     4 :   MOVE(MEM[SegB800 : 0],Cutout4[ForeBack]^,4000);
     5 :   MOVE(MEM[SegB800 : 0],Cutout5[ForeBack]^,4000);
     6 :   MOVE(MEM[SegB800 : 0],Cutout6[ForeBack]^,4000);
     7 :   MOVE(MEM[SegB800 : 0],Cutout7[ForeBack]^,4000);
     8 :   MOVE(MEM[SegB800 : 0],Cutout8[ForeBack]^,4000);
     9 :   MOVE(MEM[SegB800 : 0],Cutout9[ForeBack]^,4000);
     10 :  MOVE(MEM[SegB800 : 0],Cutout10[ForeBack]^,4000);
     END;
     CutActive[IndexNum,ForeBack] := TRUE;
END;

PROCEDURE load_cutout(IndexNum,ForeBack : WORD);
BEGIN
     IF CutActive[IndexNum,ForeBack] = TRUE THEN
     BEGIN
          CASE IndexNum OF
          1 :   MOVE(Cutout1[ForeBack]^,MEM[SegB800 : 0],4000);
          2 :   MOVE(Cutout2[ForeBack]^,MEM[SegB800 : 0],4000);
          3 :   MOVE(Cutout3[ForeBack]^,MEM[SegB800 : 0],4000);
          4 :   MOVE(Cutout4[ForeBack]^,MEM[SegB800 : 0],4000);
          5 :   MOVE(Cutout5[ForeBack]^,MEM[SegB800 : 0],4000);
          6 :   MOVE(Cutout6[ForeBack]^,MEM[SegB800 : 0],4000);
          7 :   MOVE(Cutout7[ForeBack]^,MEM[SegB800 : 0],4000);
          8 :   MOVE(Cutout8[ForeBack]^,MEM[SegB800 : 0],4000);
          9 :   MOVE(Cutout9[ForeBack]^,MEM[SegB800 : 0],4000);
          10 :  MOVE(Cutout10[ForeBack]^,MEM[SegB800 : 0],4000);
          END;
     END;
END;

PROCEDURE kill_cutout(IndexNum,ForeBack : WORD);
BEGIN
     IF CutActive[IndexNum,ForeBack] = TRUE THEN
     BEGIN
          CASE IndexNum OF
          1 :   DISPOSE(Cutout1[ForeBack]);
          2 :   DISPOSE(Cutout2[ForeBack]);
          3 :   DISPOSE(Cutout3[ForeBack]);
          4 :   DISPOSE(Cutout4[ForeBack]);
          5 :   DISPOSE(Cutout5[ForeBack]);
          6 :   DISPOSE(Cutout6[ForeBack]);
          7 :   DISPOSE(Cutout7[ForeBack]);
          8 :   DISPOSE(Cutout8[ForeBack]);
          9 :   DISPOSE(Cutout9[ForeBack]);
          10 :  DISPOSE(Cutout10[ForeBack]);
          END;
          CutActive[IndexNum,ForeBack] := FALSE;
     END;
END;

PROCEDURE WindowHeader(title : STRING; Enabled : BOOLEAN);
VAR  X1,Y1,X2,Y2 : WORD;
     Temp        : STRING;
BEGIN
     X1 := ScreenInfo.OrigX1 + ScreenInfo.XOffset;
     Y1 := ScreenInfo.OrigY1 + ScreenInfo.YOffset;
     X2 := ScreenInfo.OrigX2 + ScreenInfo.XOffset;
     Y2 := ScreenInfo.OrigY2 + ScreenInfo.YOffset;
     FILLCHAR(Temp,SIZEOF(Temp),#32);
     MOVE(Title[1],Temp[2],LENGTH(Title));
     Temp[0] := CHR(x2 - x1 + 1);
     HideMouse;
     IF Enabled THEN FastWrite(Temp,y1,x1,(Colours.WindowHeaderBack * 16) + Colours.WindowHeaderForeE)
                ELSE FastWrite(Temp,y1,x1,(Colours.WindowHeaderBack * 16) + Colours.WindowHeaderForeD);
     ShowMouse;
END;

FUNCTION _String(InLongint : LONGINT) : STRING;
VAR  Temp : STRING;
BEGIN
  STR(InLongint,Temp);
 _String := Temp;
END;

PROCEDURE SaveLastWindow;
VAR  FFile : FILE;
BEGIN
     WindowHeader(ScreenInfo.Title,FALSE);
     ASSIGN(FFile,'$$SV$$.' + _String(CurrentWindow));
     REWRITE(FFile,1);
     BLOCKWRITE(FFile,Buttons,SIZEOF(Buttons));
     BLOCKWRITE(FFile,Fields,SIZEOF(Fields));
     BLOCKWRITE(FFile,PickInfo,SIZEOF(PickInfo));
     BLOCKWRITE(FFile,ScreenInfo,SIZEOF(ScreenInfo));
     BLOCKWRITE(FFile,NFields,SIZEOF(NFields));
     BLOCKWRITE(FFile,NButtons,SIZEOF(NButtons));
     BLOCKWRITE(FFile,FieldNum,SIZEOF(FieldNum));
     IF PickInfo.Active THEN BLOCKWRITE(FFile,PickList^,SIZEOF(PickList^));
     CLOSE(FFile);
     NButtons    := 0;
     NFields     := 0;
     FieldNum    := 0;
     LastPressed := 0;
     IF PickInfo.Active THEN DISPOSE(PickList);
     FILLCHAR(ScreenInfo,SIZEOF(ScreenInfo),0);
     FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
     FILLCHAR(Buttons,SIZEOF(Buttons),0);
     FILLCHAR(Fields,SIZEOF(Fields),0);
END;

PROCEDURE LoadLastWindow;
VAR  FFile : FILE;
BEGIN
     FieldNum := 0;
     ASSIGN(FFile,'$$SV$$.' + _String(CurrentWindow));
     RESET(FFile,1);
     BLOCKREAD(FFile,Buttons,SIZEOF(Buttons));
     BLOCKREAD(FFile,Fields,SIZEOF(Fields));
     BLOCKREAD(FFile,PickInfo,SIZEOF(PickInfo));
     BLOCKREAD(FFile,ScreenInfo,SIZEOF(ScreenInfo));
     BLOCKREAD(FFile,NFields,SIZEOF(NFields));
     BLOCKREAD(FFile,NButtons,SIZEOF(NButtons));
     BLOCKREAD(FFile,FieldNum,SIZEOF(FieldNum));
     IF PickInfo.Active THEN
     BEGIN
          NEW(PickList);
          BLOCKREAD(FFile,PickList^,SIZEOF(PickList^));
     END;
     CLOSE(FFile);
     ERASE(FFile);
     LastPressed := 0;
     WindowHeader(ScreenInfo.Title,TRUE);
END;

PROCEDURE KillWindow;
BEGIN
     IF PickInfo.Active THEN BEGIN
       DISPOSE(PickList);
       PickInfo.Active := FALSE;
     END;
     HideMouse;
     Load_Cutout(ScreenInfo.Index,0);
     ShowMouse;
     Kill_Cutout(ScreenInfo.Index,0);
     Kill_Cutout(ScreenInfo.Index,1);
     ScreenInfo.XOffSet := 0;
     ScreenInfo.YOffSet := 0;
     ScreenInfo.OrigX1  := 999;
     ScreenInfo.OrigX2  := 999;
     ScreenInfo.OrigY1  := 999;
     ScreenInfo.OrigY1  := 999;
     LastPressed        := 0;
     DEC(CurrentWindow);
     IF (CurrentWindow <> 0) THEN LoadLastWindow;
END;

PROCEDURE DrawWindow(x1,y1,x2,y2 : BYTE; title : STRING);
VAR  Temp : STRING;
     Loop : BYTE;
BEGIN
     IF (CurrentWindow <> 0) THEN SaveLastWindow;
     INC(CurrentWindow);
     ScreenInfo.OrigX1  := x1;
     ScreenInfo.OrigY1  := y1;
     ScreenInfo.OrigX2  := x2;
     ScreenInfo.OrigY2  := y2;
     ScreenInfo.XOffset := 0;
     ScreenInfo.YOffSet := 0;
     ScreenInfo.Index   := CurrentWindow;
     ScreenInfo.Title   := Title;
     Save_Cutout(CurrentWindow,0);
     FILLCHAR(Temp,SIZEOF(Temp),#32);
     MOVE(Title[1],Temp[2],LENGTH(Title));
     Temp[0] := CHR(x2 - x1 + 1);
     FastWrite(Temp,y1,x1,(Colours.WindowHeaderBack * 16) + Colours.WindowHeaderForeE);
     Shadow(x1,y1,x2,y2);
     WITH Colours DO
     BEGIN
          Temp := '' + Replicate('',x2 - x1 - 1);
          FastWrite(Temp,y1 + 1,x1,(WindowBack * 16) + WindowFrameLight);
          FastWrite('',y1 + 1,x2,(WindowBack * 16) + WindowFrameDark);
          FOR Loop := y1 + 2 TO y2 - 1 DO
          BEGIN
               FastWrite('' + Replicate(' ',x2 - x1 - 1),Loop,x1,(WindowBack * 16) + WindowFrameLight);
               FastWrite('',Loop,x2,(WindowBack * 16) + WindowFrameDark);
          END;
          Temp := Replicate('',x2 - x1 - 1) + '';
          FastWrite(Temp,y2,x1 + 1,(WindowBack * 16) + WindowFrameDark);
          FastWrite('',y2,x1,(WindowBack * 16) + WindowFrameLight);
     END;
END;

PROCEDURE SystemButton(x,y,return,style : BYTE; Hold,Redraw : BOOLEAN; Title : STRING);
VAR  Temp : STRING;
BEGIN
     LastPressed := 0;
     INC(NButtons);
     Buttons[NButtons].Holdable    := Hold;
     Buttons[NButtons].x           := x;
     Buttons[NButtons].y           := y;
     Buttons[NButtons].Text        := Title;
     Buttons[NButtons].Style       := Style;
     Buttons[NButtons].ReturnValue := Return;
     IF Redraw THEN
     BEGIN
          CASE Style OF
          1 :   BEGIN
                    Temp := Title;
                    DELETE(Title,1,1);
                    DELETE(Temp,2,LENGTH(Temp) - 1);
                    FastWrite(' ' + Temp,y,x,(Colours.ButtonBack * 16) + Colours.ButtonHighlight);
                    FastWrite(Title + ' ',y,x + 2,(Colours.ButtonBack * 16) + Colours.ButtonFore);
                    FastWrite('',y,x + LENGTH(Title) + 3,(Colours.WindowBack * 16) + 0);
                    FastWrite(Replicate('',LENGTH(Title) + 3),y + 1,x + 1,(Colours.WindowBack * 16) + 0);
               END;
          2 :   FastWrite(Title,y,x,(Colours.ArrowsBack * 16) + Colours.ArrowsFore);
          END;
     END;
END;

PROCEDURE DrawPickListLocator;
VAR  Work      : WORD;
     Percent   : REAL;
     Pixels    : WORD;
     YRelative : WORD;
     Loop      : WORD;
BEGIN
     IF PickInfo.NumItems > PickInfo.ItemsOnScrn THEN
     BEGIN
          Work             := PickInfo.NumItems - PickInfo.ItemsOnScrn;
          Percent          := (PickInfo.Top - 1) / Work;
          Pixels           := PickInfo.ItemsOnScrn - 2;
          YRelative        := ROUND(Pixels * Percent);
          IF YRelative = 0 THEN YRelative := 1;
          PickInfo.Locator := PickInfo.y + YRelative;
     END
     ELSE PickInfo.Locator := PickInfo.y + 1;
     {Scroll Bar}
     FOR Loop := PickInfo.y + 1 TO PickInfo.y + PickInfo.ItemsOnScrn - 2 DO
         FastWrite('',Loop,PickInfo.x + PickInfo.MaxChars + 2,Colours.ScrollBars);
     FastWrite('',PickInfo.Locator,PickInfo.x + PickInfo.MaxChars + 2,(Colours.LocatorBack * 16) + Colours.LocatorFore);
END;

PROCEDURE NewPickList(x,y,OnScreen,MaxChars : BYTE);
VAR  Temp : STRING;
     Loop : BYTE;
BEGIN
     NEW(PickList);
     PickInfo.Active      := TRUE;
     PickInfo.x           := x;
     PickInfo.y           := y;
     PickInfo.Top         := 1;
     PickInfo.NumItems    := 0;
     PickInfo.ItemsOnScrn := OnScreen;
     PickInfo.Current     := 1;
     PickInfo.MaxChars    := MaxChars;
     PickInfo.Locator     := PickInfo.y + 1;
     {Play area}
     Temp := Replicate(' ',PickInfo.MaxChars + 2);
     FOR Loop := y TO y + PickInfo.ItemsOnScrn - 1 DO FastWrite(Temp,Loop,x,(Colours.PickListBack * 16));
     {Scroll Bar}
     FOR Loop := y TO y + PickInfo.ItemsOnScrn - 1 DO FastWrite('',Loop,x + LENGTH(Temp),Colours.ScrollBars);
     {Scroll Bar Buttons}
     SystemButton(x + LENGTH(Temp),PickInfo.y,72,2,TRUE,TRUE,'');
     SystemButton(x + LENGTH(Temp),PickInfo.y + PickInfo.ItemsOnScrn - 1,80,2,TRUE,TRUE,'');
     DrawPickListLocator;
END;

PROCEDURE AddToPickList(InString : STRING);
VAR  Temp : STRING;
BEGIN
     FILLCHAR(Temp,SIZEOF(Temp),#32);
     MOVE(InString[1],Temp[1],LENGTH(InString));
     Temp[0] := CHR(PickInfo.MaxChars);
     IF PickInfo.NumItems < 800 THEN
     BEGIN
          INC(PickInfo.NumItems);
          PickList^[PickInfo.NumItems] := Temp;
     END;
END;

PROCEDURE SetUpPickList;
VAR  Loop : WORD;
     Y    : WORD;
     Cnt  : WORD;
BEGIN
     Cnt := PickInfo.Top;
     Y   := PickInfo.y;
     FOR Loop := 1 TO PickInfo.ItemsOnScrn DO
     BEGIN
          IF Cnt <= PickInfo.NumItems THEN
          BEGIN
               IF Cnt = PickInfo.Current
                  THEN OutTextXY(PickInfo.x,y,Colours.PickListForeS,Colours.PickListBackS,' ' + PickList^[Cnt] + ' ')
                  ELSE OutTextXY(PickInfo.x,y,Colours.PickListFore,Colours.PickListBack,' ' + PickList^[Cnt] + ' ');
          END
          ELSE OutTextXY(PickInfo.x,y,Colours.PickListFore,Colours.PickListBack,Replicate(' ',PickInfo.MaxChars + 2));
          INC(y);
          INC(Cnt);
     END;
END;

PROCEDURE ResetPickList(Item : WORD);
BEGIN
  PickInfo.Current := Item;
  PickInfo.Top     := Item;
  IF PickInfo.Top > (PickInfo.NumItems - PickInfo.ItemsOnScrn) THEN DEC(PickInfo.Top,(PickInfo.ItemsOnScrn - 1));
  IF (PickInfo.Top < 1) OR (PickInfo.Top > 800) THEN PickInfo.Top := 1;
  DrawPickListLocator;
END;

PROCEDURE SystemField(x,y,EntryType,MaxLength : BYTE; Stuff : STRING);
VAR  Temp : STRING;
BEGIN
     INC(NFields);
     Fields[NFields].Active := FALSE;
     IF NFields = 1 THEN
     BEGIN
          Fields[NFields].Active := TRUE;
          FieldNum               := 1;
     END;
     Fields[NFields].x          := x;
     Fields[NFields].y          := y;
     Fields[NFields].Text       := Stuff;
     Fields[NFields].CursorPos  := LENGTH(Stuff) + 1;
     Fields[NFields].EntryType  := EntryType;
     Fields[NFields].MaxLength  := MaxLength;
     Temp := Replicate('_',Fields[NFields].MaxLength);
     IF NFields = FieldNum THEN
     BEGIN
          FastWrite(Temp,Fields[NFields].y,Fields[NFields].x,(Colours.FieldBackS * 16) + Colours.FieldDashes);
          FastWrite(Fields[NFields].Text,Fields[NFields].y,Fields[NFields].x,(Colours.FieldBackS * 16) + Colours.FieldForeS);
          FastWrite('[',Fields[NFields].y,Fields[NFields].x - 1,
                   (Colours.WindowBack * 16) + Colours.FieldHighLight);
          FastWrite(']',Fields[NFields].y,Fields[NFields].x + Fields[NFields].MaxLength,
                   (Colours.WindowBack * 16) + Colours.FieldHighLight);
          GOTOXY(Fields[FieldNum].x + Fields[FieldNum].CursorPos - 1,Fields[FieldNum].y);
     END
     ELSE
     BEGIN
          FastWrite(Temp,Fields[NFields].y,Fields[NFields].x,(Colours.FieldBack * 16) + Colours.FieldDashes);
          FastWrite(Fields[NFields].Text,Fields[NFields].y,Fields[NFields].x,(Colours.FieldBack * 16) + Colours.FieldFore);
          FastWrite(' ',Fields[NFields].y,Fields[NFields].x - 1,
                   (Colours.WindowBack * 16) + Colours.FieldHighLight);
          FastWrite(' ',Fields[NFields].y,Fields[NFields].x + Fields[NFields].MaxLength,
                   (Colours.WindowBack * 16) + Colours.FieldHighLight);
     END;
END;

PROCEDURE RedrawField;
VAR  Temp : STRING;
BEGIN
     Temp := Replicate('_',Fields[FieldNum].MaxLength);
     FastWrite(Temp,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBackS * 16) + Colours.FieldDashes);
     FastWrite(Fields[FieldNum].Text,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBackS * 16) + Colours.FieldForeS);
     GOTOXY(Fields[FieldNum].x + Fields[FieldNum].CursorPos - 1,Fields[FieldNum].y);
END;

PROCEDURE ChangeField(Number : BYTE);
VAR  x2,y2 : WORD;
     Temp  : STRING;
BEGIN
     IF NFields <= 1 THEN EXIT;
     Temp := Replicate('_',Fields[FieldNum].MaxLength);
     {First, kill the last one}
     Fields[FieldNum].Active := FALSE;
     FastWrite(Temp,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBack * 16) + Colours.FieldDashes);
     FastWrite(Fields[FieldNum].Text,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBack * 16) + Colours.FieldFore);
     FastWrite(' ',Fields[FieldNum].y,Fields[FieldNum].x - 1,
              (Colours.WindowBack * 16) + Colours.FieldHighLight);
     FastWrite(' ',Fields[FieldNum].y,Fields[FieldNum].x + Fields[FieldNum].MaxLength,
              (Colours.WindowBack * 16) + Colours.FieldHighLight);
     {Set the new one active}
     FieldNum := Number;
     Temp := Replicate('_',Fields[FieldNum].MaxLength);
     Fields[FieldNum].Active := TRUE;
     Fields[FieldNum].CursorPos := LENGTH(Fields[FieldNum].Text) + 1;
     {Draw it out}
     FastWrite(Temp,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBack * 16) + Colours.FieldDashes);
     FastWrite(Fields[FieldNum].Text,Fields[FieldNum].y,Fields[FieldNum].x,(Colours.FieldBackS * 16) + Colours.FieldForeS);
     FastWrite('[',Fields[FieldNum].y,Fields[FieldNum].x - 1,
              (Colours.WindowBack * 16) + Colours.FieldHighLight);
     FastWrite(']',Fields[FieldNum].y,Fields[FieldNum].x + Fields[FieldNum].MaxLength,
              (Colours.WindowBack * 16) + Colours.FieldHighLight);
     GOTOXY(Fields[FieldNum].x + Fields[FieldNum].CursorPos - 1,Fields[FieldNum].y);
END;

PROCEDURE ReleaseButton(Num : BYTE);
VAR  Temp        : STRING;
     Title       : STRING;
BEGIN
     IF Buttons[Num].Style = 1 THEN
     BEGIN
          Title := Buttons[Num].Text;
          Temp := Title;
          DELETE(Title,1,1);
          DELETE(Temp,2,LENGTH(Temp) - 1);
          HideMouse;
          FastWrite(' ' + Temp,Buttons[Num].y,Buttons[Num].x,(Colours.ButtonBack * 16) + Colours.ButtonHighlight);
          FastWrite(Title + ' ',Buttons[Num].y,Buttons[Num].x + 2,(Colours.ButtonBack * 16) + Colours.ButtonFore);
          FastWrite('',Buttons[Num].y,Buttons[Num].x + LENGTH(Title) + 3,(Colours.WindowBack * 16) + 0);
          FastWrite(Replicate('',LENGTH(Title) + 3),Buttons[Num].y + 1,Buttons[Num].x + 1,(Colours.WindowBack * 16) + 0);
          ShowMouse;
     END;
END;

PROCEDURE PressButton(Num : BYTE);
VAR  Temp        : STRING;
     Title       : STRING;
BEGIN
     IF Buttons[Num].Style = 1 THEN
     BEGIN
          Title := Buttons[Num].Text;
          Temp := Title;
          DELETE(Title,1,1);
          DELETE(Temp,2,LENGTH(Temp) - 1);
          HideMouse;
          FastWrite(' ',Buttons[Num].y,Buttons[Num].x,(Colours.WindowBack * 16));
          FastWrite(' ' + Temp,Buttons[Num].y,Buttons[Num].x + 1,(Colours.ButtonBack * 16) + Colours.ButtonHighlight);
          FastWrite(Title + ' ',Buttons[Num].y,Buttons[Num].x + 3,(Colours.ButtonBack * 16) + Colours.ButtonFore);
          FastWrite(Replicate(' ',LENGTH(Title) + 3),Buttons[Num].y + 1,Buttons[Num].x + 1,(Colours.WindowBack * 16));
          ShowMouse;
     END;
END;

PROCEDURE ProcessButton(xx,yy : BYTE);
VAR  Loop  : WORD;
BEGIN
     IF NFields <> 0 THEN
     BEGIN
          FOR Loop := 1 TO NFields DO
          BEGIN
               IF ((xx > Fields[Loop].x) AND (xx < Fields[Loop].x + Fields[Loop].MaxLength) AND (yy = Fields[Loop].y)) THEN
               BEGIN
                    IF Loop <> FieldNum THEN
                    BEGIN
                         HideMouse;
                         ChangeField(Loop);
                         ShowMouse;
                         EXIT;
                    END;
               END;
          END;
     END;
     IF ((LastPressed = 0) AND (NButtons <> 0)) THEN
     BEGIN
          FOR Loop := 1 TO NButtons DO
          BEGIN
               IF ((xx >= Buttons[Loop].x) AND (xx < Buttons[Loop].x + LENGTH(Buttons[Loop].Text) + 2)) THEN
               BEGIN
                    IF yy = Buttons[Loop].y THEN
                    BEGIN
                         LastPressed := Loop;
                         PressButton(LastPressed);
                         EXIT;
                    END;
               END;
          END;
     END
     ELSE IF (LastPressed <> 0) THEN
     BEGIN
          {CHECK TO SEE IF THE USER MOVED OFF OF THE BUTTON}
          IF ((xx < Buttons[LastPressed].x) OR
             (xx > Buttons[LastPressed].x + LENGTH(Buttons[LastPressed].Text) + 2) OR
             (yy <> Buttons[LastPressed].y)) THEN
          BEGIN
               ReleaseButton(LastPressed);
               LastPressed := 0;
          END;
     END;
END;

PROCEDURE ScrollPickPgUp;
VAR  Temp : INTEGER;
BEGIN
     IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
     IF (PickInfo.Top > 1) THEN
     BEGIN
          Temp := PickInfo.Top - PickInfo.ItemsOnScrn;
          IF Temp < 1 THEN Temp := 1;
          PickInfo.Top := Temp;
          IF (PickInfo.Current < PickInfo.Top)
             THEN PickInfo.Current := PickInfo.Top
          ELSE IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
             THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END
     ELSE IF (PickInfo.Current <> 1) THEN
     BEGIN
          PickInfo.Top := 1;
          PickInfo.Current := 1;
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END;
END;

PROCEDURE ScrollPickPgDown;
VAR  Temp : INTEGER;
BEGIN
     IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
     IF ((PickInfo.Top + PickInfo.ItemsOnScrn - 1) < PickInfo.NumItems) THEN
     BEGIN
          Temp := PickInfo.Top + PickInfo.ItemsOnScrn;
          IF (Temp > (PickInfo.NumItems - PickInfo.ItemsOnScrn + 1))
             THEN Temp := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
          PickInfo.Top := Temp;
          IF (PickInfo.Current < PickInfo.Top)
             THEN PickInfo.Current := PickInfo.Top
          ELSE IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
             THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END
     ELSE IF (PickInfo.Current <> PickInfo.NumItems) THEN
     BEGIN
          PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
          PickInfo.Current := PickInfo.NumItems;
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END;
END;

PROCEDURE ScrollPickUp;
BEGIN
     IF PickInfo.Current > 1 THEN
     BEGIN
          DEC(PickInfo.Current);
          IF (PickInfo.Top > PickInfo.Current) THEN DEC(PickInfo.Top);
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END;
END;

PROCEDURE ScrollPickDown;
BEGIN
     IF PickInfo.Current < PickInfo.NumItems THEN
     BEGIN
          INC(PickInfo.Current);
          IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1) THEN INC(PickInfo.Top);
          HideMouse;
          DrawPickListLocator;
          SetUpPickList;
          ShowMouse;
     END;
END;

FUNCTION _Mid(InString : STRING; Starting,Ending : BYTE) : STRING;
VAR  NumberOfChars : BYTE;
BEGIN
     IF Ending >= Starting THEN
     BEGIN
          NumberOfChars := Ending - Starting + 1;
          _Mid := COPY(InString,Starting,NumberOfChars);
     END
     ELSE _Mid := '';
END;

PROCEDURE SliceMouse;
CONST
  OldClk : WORD = 0;
BEGIN
  IF SysClk^ AND $FFFC = OldClk THEN EXIT;
  OldClk := SysClk^ AND $FFFC;
  TimeSlice;
END;

FUNCTION MouseHandler(DoKeys : BOOLEAN) : BYTE;
VAR  w         : BYTE;
     xx        : BYTE;
     yy        : BYTE;
     TheOne    : BYTE;
     DidAPress : BOOLEAN;
     ThePress  : BYTE;
     Loop      : BYTE;

     PROCEDURE HandleKeys;
     VAR  c      : CHAR;
          ThePos : BYTE;
     LABEL         DnArrow;
     BEGIN
          C := READKEY;
          IF NFields = 0 THEN
          BEGIN
               IF ORD(c) = 0 THEN
               BEGIN
                    c := READKEY;
                    IF PickInfo.Active THEN
                    BEGIN
                         CASE ORD(C) OF
                         72 :  BEGIN {Up}
                                   ScrollPickUp;
                              END;
                         80 :  BEGIN {Down}
                                   ScrollPickDown;
                              END;
                         73 :  BEGIN {PgUp}
                                   ScrollPickPgUp;
                              END;
                         81 :  BEGIN {PgDn}
                                   ScrollPickPgDown;
                              END;
                         132 : BEGIN {CTRL+PgUp}
                                   IF (PickInfo.Current <> 1) THEN
                                   BEGIN
                                        PickInfo.Top := 1;
                                        PickInfo.Current := 1;
                                        HideMouse;
                                        DrawPickListLocator;
                                        SetUpPickList;
                                        ShowMouse;
                                   END;
                              END;
                         118 : BEGIN {CTRL+PgDn}
                                   IF (PickInfo.NumItems > PickInfo.ItemsOnScrn) THEN
                                   BEGIN
                                        IF (PickInfo.Top <> PickInfo.NumItems - PickInfo.ItemsOnScrn + 1) THEN
                                        BEGIN
                                             PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
                                             PickInfo.Current := PickInfo.NumItems;
                                             HideMouse;
                                             DrawPickListLocator;
                                             SetUpPickList;
                                             ShowMouse;
                                        END;
                                   END;
                              END;
                         ELSE BEGIN
                                   DidAPress := TRUE;
                                   ThePress  := ORD(c);
                              END;
                         END;
                    END
                    ELSE
                    BEGIN
                         DidAPress := TRUE;
                         ThePress  := ORD(c);
                    END;
               END;
               EXIT;
          END;
          HideMouse;
          CASE ORD(c) OF
          13 :  GOTO DnArrow;
          0 :   BEGIN
                    C := READKEY;
                    CASE ORD(c) OF
                    15,72 : BEGIN {SHIFT TAB & UpArrow}
                                IF FieldNum = 1 THEN ChangeField(NFields)
                                              ELSE ChangeField(FieldNum - 1);
                           END;
                    80 :    BEGIN {DownArrow}
                                DnArrow :
                                IF FieldNum = NFields THEN ChangeField(1)
                                                    ELSE ChangeField(FieldNum + 1);
                           END;
                    71 :    BEGIN {HOME}
                                IF (Fields[FieldNum].CursorPos <> 1) THEN
                                BEGIN
                                     Fields[FieldNum].CursorPos := 1;
                                     RedrawField;
                                END;
                           END;
                    79 :    BEGIN {END}
                                IF (Fields[FieldNum].CursorPos <> LENGTH(Fields[FieldNum].Text) + 1) THEN
                                BEGIN
                                     Fields[FieldNum].CursorPos := LENGTH(Fields[FieldNum].Text) + 1;
                                     RedrawField;
                                END;
                           END;
                    75 :    BEGIN {Left}
                                IF (Fields[FieldNum].CursorPos > 1) THEN
                                BEGIN
                                     DEC(Fields[FieldNum].CursorPos);
                                     RedrawField;
                                END;
                           END;
                    77 :    BEGIN {Right}
                                IF (Fields[FieldNum].CursorPos < LENGTH(Fields[FieldNum].Text) + 1) THEN
                                BEGIN
                                     INC(Fields[FieldNum].CursorPos);
                                     RedrawField;
                                END;
                           END;
                    83 :    BEGIN {DELETE}
                                ThePos := Fields[FieldNum].CursorPos;
                                IF (ThePos <= LENGTH(Fields[FieldNum].Text)) THEN
                                BEGIN
                                     Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) +
                                           _Mid(Fields[FieldNum].Text,ThePos + 1,LENGTH(Fields[FieldNum].Text));
                                     RedrawField;
                                END;
                           END;
                    ELSE   BEGIN
                                DidAPress := TRUE;
                                ThePress  := ORD(c);
                           END;
                    END;
               END;
          8 :   BEGIN {BACKSPACE}
                    ThePos := Fields[FieldNum].CursorPos;
                    IF ThePos > 1 THEN
                    BEGIN
                         Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 2) +
                               _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                         DEC(Fields[FieldNum].CursorPos);
                         RedrawField;
                    END;
               END;
          9 :   BEGIN {TAB}
                    IF FieldNum = NFields THEN ChangeField(1)
                                        ELSE ChangeField(FieldNum + 1);
               END;
          127 : BEGIN {Ctrl-Backspace}
                    Fields[FieldNum].Text := '';
                    Fields[FieldNum].CursorPos := 1;
                    RedrawField;
               END;
          ELSE
            BEGIN
               IF ((ORD(c) > 31) AND (ORD(c) < 128)) THEN
               BEGIN
                    IF (LENGTH(Fields[FieldNum].Text) < Fields[FieldNum].MaxLength) THEN
                    BEGIN
                         CASE Fields[FieldNum].EntryType OF
                         0 :   BEGIN {0-Plain String}
                                   ThePos := Fields[FieldNum].CursorPos;
                                   Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                         _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                   INC(Fields[FieldNum].CursorPos);
                              END;
                         1 :   BEGIN {1-Plain Numeric}
                                   IF ((ORD(c) > 47) AND (ORD(c) < 58)) OR (c = '.') THEN
                                   BEGIN
                                        ThePos := Fields[FieldNum].CursorPos;
                                        Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                              _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                        INC(Fields[FieldNum].CursorPos);
                                   END;
                              END;
                         2 :   BEGIN {2-Proper String}
                                   ThePos := Fields[FieldNum].CursorPos;
                                   IF ThePos = 1 THEN C := UPCASE(C)
                                   ELSE
                                   BEGIN
                                        IF (ThePos <> 2) THEN
                                        BEGIN
                                             IF Fields[FieldNum].Text[ThePos - 1] = ' ' THEN C := UPCASE(C);
                                        END;
                                   END;
                                   Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                         _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                   INC(Fields[FieldNum].CursorPos);
                              END;
                         3 :   BEGIN {3-Date}
                                   IF (((ORD(c) > 47) AND (ORD(c) < 58)) OR (c = '-') OR (c = '/'))
                                   THEN
                                   BEGIN
                                        ThePos := Fields[FieldNum].CursorPos;
                                        Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                              _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                        INC(Fields[FieldNum].CursorPos);
                                   END;
                              END;
                         4 :   BEGIN {4-Phone Number}
                                   IF (((ORD(c) > 47) AND (ORD(c) < 58)) OR (c = '-') OR (c = '(') OR (c = ')'))
                                   THEN
                                   BEGIN
                                        ThePos := Fields[FieldNum].CursorPos;
                                        Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                              _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                        INC(Fields[FieldNum].CursorPos);
                                   END;
                              END;
                         5 :   BEGIN {5-Filename}
                                   C := UPCASE(C);
                                  {IF (((ORD(c)>47) AND (ORD(c)<58)) OR ((ORD(c)>64) AND (ORD(c)<91)) OR (c=':') OR
                                      (c='~') OR (c='@') OR (c='#') OR (c='$') OR (c='-') OR (c='.') OR (c='_')) THEN
                                   BEGIN}
                                        ThePos := Fields[FieldNum].CursorPos;
                                        Fields[FieldNum].Text := _Mid(Fields[FieldNum].Text,1,ThePos - 1) + C +
                                              _Mid(Fields[FieldNum].Text,ThePos,LENGTH(Fields[FieldNum].Text));
                                        INC(Fields[FieldNum].CursorPos);
                                  {END;}
                              END;
                         END;
                         RedrawField;
                    END;
               END
               ELSE
               BEGIN
                    DidAPress := TRUE;
                    ThePress  := ORD(c);
               END;
            END;
          END;
          ShowMouse;
     END;

BEGIN
     SliceMouse;
     DidAPress := FALSE;
     IF ((KEYPRESSED) AND (DoKeys)) THEN HandleKeys;
     IF DidAPress THEN
     BEGIN
          IF (NButtons <> 0) THEN
          BEGIN
               FOR Loop := 1 TO NButtons DO
               BEGIN
                    IF Buttons[Loop].ReturnValue = ThePress THEN
                    BEGIN
                         LastPressed  := Loop;
                         MouseHandler := Loop;
                         EXIT;
                    END;
               END;
          END;
     END;
     w  := 0;
     IF GetMouseButtons = 1 THEN
     BEGIN
          xx := GetMouseX;
          yy := GetMouseY;
          IF ((PickInfo.Active) AND (xx = PickInfo.x + PickInfo.MaxChars + 2) AND (yy = PickInfo.Locator)) THEN
          BEGIN
               {IF MoveLocator THEN
               BEGIN

                    I'll DO THIS LATER!

                    HideMouse;
                    DrawPickListLocator;
                    SetUpPickList;
                    ShowMouse;
               END;}
          END
          ELSE IF ((PickInfo.Active) AND (xx = PickInfo.x + PickInfo.MaxChars + 2) AND
                  (yy > PickInfo.y) AND (yy < PickInfo.Locator)) THEN
          BEGIN
               ScrollPickPgUp;
               REPEAT
                     TimeSlice;
               UNTIL (GetMouseButtons <> 1);
          END
          ELSE IF ((PickInfo.Active) AND (xx = PickInfo.x + PickInfo.MaxChars + 2) AND
                  (yy > PickInfo.Locator) AND (yy < PickInfo.y + PickInfo.ItemsOnScrn - 1)) THEN
          BEGIN
               ScrollPickPgDown;
               REPEAT
                     TimeSlice;
               UNTIL (GetMouseButtons <> 1);
          END
          ELSE
          BEGIN
               IF ((LastPressed <> 0) AND (Buttons[LastPressed].Holdable)) THEN
               BEGIN
                    IF ((xx < Buttons[LastPressed].x) OR
                       (xx > Buttons[LastPressed].x + LENGTH(Buttons[LastPressed].Text) + 2) OR
                       (yy <> Buttons[LastPressed].y)) THEN
                    BEGIN
                         ReleaseButton(LastPressed);
                         LastPressed := 0;
                    END
                    ELSE
                    BEGIN
                         {BUTTON IS STILL PRESSED}
                         IF PickInfo.Active THEN
                         BEGIN
                              w := LastPressed;
                              IF ((xx = PickInfo.x + PickInfo.MaxChars + 2) AND (yy = PickInfo.y)) THEN
                              BEGIN
                                   ScrollPickUp;
                              END
                              ELSE IF ((xx = PickInfo.x + PickInfo.MaxChars + 2)
                              AND (yy = PickInfo.y + PickInfo.ItemsOnScrn - 1)) THEN
                              BEGIN
                                   ScrollPickDown;
                              END;
                         END;
                    END;
               END
               ELSE
               BEGIN
                    ProcessButton(xx,yy);
                    IF PickInfo.Active THEN
                    BEGIN
                         IF ((xx >= PickInfo.x) AND (xx <= PickInfo.x + PickInfo.MaxChars + 1) AND
                            (yy >= PickInfo.y) AND (yy <= PickInfo.y + PickInfo.ItemsOnScrn - 1)) THEN
                         BEGIN
                              TheOne := PickInfo.Top + (yy - PickInfo.y);
                              IF TheOne <> PickInfo.Current THEN
                              BEGIN
                                   IF ((TheOne >= PickInfo.Top) AND (TheOne <= (PickInfo.Top + PickInfo.ItemsOnScrn - 1))) THEN
                                   BEGIN
                                        IF TheOne <= PickInfo.NumItems THEN
                                        BEGIN
                                             PickInfo.Current := TheOne;
                                             HideMouse;
                                             SetUpPickList;
                                             ShowMouse;
                                        END;
                                   END;
                              END;
                         END;
                    END;
               END;
          END;
     END
     ELSE
     BEGIN
          IF LastPressed <> 0 THEN
          BEGIN
               xx := GetMouseX;
               yy := GetMouseY;
               ReleaseButton(LastPressed);
               IF ((xx < Buttons[LastPressed].x) OR
                  (xx > Buttons[LastPressed].x + LENGTH(Buttons[LastPressed].Text) + 2) OR
                  (yy <> Buttons[LastPressed].y))
                  THEN w := 0
                  ELSE w := LastPressed;
               LastPressed := 0;
          END;
     END;
     MouseHandler := w;
END;

BEGIN
  SysClk          := PTR(Seg0040,$6C); {Location of BIOS system clock counter}
  Mouse_Error     := InitMouse;
  Mouse_Installed := Mouse_Error = 65535;
  DetectOS;
END.
