{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S+,T-,V+,X+}
UNIT TEXTUNIT;

INTERFACE

TYPE Pick_List   = ARRAY[1..800] OF STRING[80];
TYPE V_Buffer    = ARRAY[1..4000] OF BYTE;

TYPE Pick_Info   = RECORD
     Active      : BOOLEAN;
     X           : BYTE;
     Y           : BYTE;
     Top         : WORD;
     NumItems    : WORD;
     ItemsOnScrn : BYTE;
     Current     : WORD;
     MaxChars    : BYTE;
     Locator     : WORD;
     END;

{PROCEDURE MenuPrompt(X,Y : BYTE ; HotKey : CHAR ; St : STRING);}
PROCEDURE DrawButton(X,Y : BYTE ; HotKey : CHAR ; St : STRING);
PROCEDURE InvertedBox(x1,y1,x2,y2 : BYTE);

PROCEDURE DrawWindow(x1,y1,x2,y2 : BYTE; Title : STRING);
PROCEDURE KillWindow;

PROCEDURE NewPickList(X,Y,OnScreen,MaxChars : BYTE);
PROCEDURE AddToPickList(InString : STRING);
PROCEDURE ResetPickList(Item : WORD);
PROCEDURE SetUpPickList;
FUNCTION  GetPickList : STRING;

FUNCTION  GetString(X,Y,Size : BYTE ; ST : STRING) : STRING;
PROCEDURE DummyField(X,Y,Size : BYTE ; ST : STRING);

PROCEDURE SaveScreen;
PROCEDURE RestoreScreen;

IMPLEMENTATION

USES MYCRT, GUI_UTIL;

VAR
  PickList : ^Pick_List;
  VBuff    : ^V_Buffer;
  PickInfo : Pick_Info;

{$L STRING2}
FUNCTION Replicate(Ch : CHAR; Count : WORD) : STRING; EXTERNAL;

{PROCEDURE MenuPrompt(X,Y : BYTE ; HotKey : CHAR ; St : STRING);
BEGIN
  OutTextXY(X,Y,3,1,'[ ]');
  OutTextXY(X + 1,Y,15,1,HotKey);
  OutTextXY(X + 4,Y,11,1,St);
END;}

PROCEDURE DrawButton(X,Y : BYTE ; HotKey : CHAR ; St : STRING);
BEGIN
  OutTextXY(X,Y,8,1,'');
  OutTextXY(X + 1,Y,4,7,' ' + HotKey);
  OutTextXY(X + 3,Y,0,7,St + ' ');
  OutTextXY(X + LENGTH(St + HotKey) + 3,Y,8,1,'');
END;

PROCEDURE InvertedBox(x1,y1,x2,y2 : BYTE);
VAR
  Loop : BYTE;
  Temp : STRING;
BEGIN
  Temp := '' + Replicate('',x2 - x1 - 1);
  OutTextXY(x1,y1,0,1,Temp);
  OutTextXY(x2,y1,9,1,'');
  FOR Loop := y1 + 1 TO y2 - 1 DO BEGIN
    OutTextXY(x1,Loop,0,1,'');
    OutTextXY(x2,Loop,9,1,'');
  END;
  Temp := Replicate('',x2 - x1 - 1) + '';
  OutTextXY(x1,y2,0,1,'');
  OutTextXY(x1+1,y2,9,1,Temp);
END;

PROCEDURE Shadow(x1,y1,x2,y2 : WORD);
VAR
  X    : WORD;
  Y    : WORD;
  Loop : WORD;
BEGIN
  X := ((y2 * 160) + (x1 * 2)) + 1;
  FOR Loop := x1 TO x2 DO BEGIN
    Mem[SegB800 : X] := 8;
    INC(X,2);
  END;
  Y := ((y1 * 160) + ((x2) * 2)) + 1;
  FOR Loop := y1 TO y2 DO BEGIN
    Mem[SegB800 : Y] := 8;
    INC(Y,160);
  END;
END;

PROCEDURE DrawWindow(x1,y1,x2,y2 : BYTE; Title : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
BEGIN
  SaveScreen;
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(Title[1],Temp[2],LENGTH(Title));
  Temp[0] := CHR(x2 - x1 + 1);
  OutTextXY(x1,y1,15,3,Temp);
  Shadow(x1,y1,x2,y2);
  Temp := '' + Replicate('',x2 - x1 - 1);
  OutTextXY(x1,y1 + 1,9,1,Temp);
  OutTextXY(x2,y1 + 1,0,1,'');
  FOR Loop := y1 + 2 TO y2 - 1 DO BEGIN
    OutTextXY(x1,Loop,9,1,'' + Replicate(' ',x2 - x1 - 1));
    OutTextXY(x2,Loop,0,1,'');
  END;
  Temp := Replicate('',x2 - x1 - 1) + '';
  OutTextXY(x1,y2,9,1,'');
  OutTextXY(x1 + 1,y2,0,1,Temp);
END;

PROCEDURE KillWindow;
BEGIN
  RestoreScreen;
  IF PickInfo.Active THEN BEGIN
    DISPOSE(PickList);
    PickList := NIL;
    FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
  END;
END;

PROCEDURE DrawPickListLocator;
VAR
  Work      : WORD;
  Percent   : REAL;
  Pixels    : WORD;
  YRelative : WORD;
  Loop      : WORD;
BEGIN
  IF PickInfo.NumItems > PickInfo.ItemsOnScrn THEN BEGIN
    Work             := PickInfo.NumItems - PickInfo.ItemsOnScrn;
    Percent          := (PickInfo.Top - 1) / Work;
    Pixels           := PickInfo.ItemsOnScrn - 2;
    YRelative        := ROUND(Pixels * Percent);
    IF YRelative = 0 THEN YRelative := 1;
    PickInfo.Locator := PickInfo.y + YRelative;
  END ELSE PickInfo.Locator := PickInfo.Y + 1;
 {Scroll Bar}
  FOR Loop := PickInfo.Y + 1 TO PickInfo.Y + PickInfo.ItemsOnScrn - 2 DO
  OutTextXY(PickInfo.X + PickInfo.MaxChars + 2,Loop,7,0,'');
  OutTextXY(PickInfo.X + PickInfo.MaxChars + 2,PickInfo.Locator,15,0,'');
END;

PROCEDURE NewPickList(X,Y,OnScreen,MaxChars : BYTE);
VAR
  Temp : STRING;
  Loop : BYTE;
BEGIN
  NEW(PickList);
  PickInfo.Active      := TRUE;
  PickInfo.X           := X;
  PickInfo.Y           := Y;
  PickInfo.Top         := 1;
  PickInfo.NumItems    := 0;
  PickInfo.ItemsOnScrn := OnScreen;
  PickInfo.Current     := 1;
  PickInfo.MaxChars    := MaxChars;
  PickInfo.Locator     := PickInfo.Y + 1;
 {Play area}
  Temp := Replicate(' ',PickInfo.MaxChars + 2);
  FOR Loop := Y TO Y + PickInfo.ItemsOnScrn - 1 DO OutTextXY(X,Loop,7,7,Temp);
 {Scroll Bar}
  FOR Loop := Y TO Y + PickInfo.ItemsOnScrn - 1 DO OutTextXY(X + LENGTH(Temp),Loop,7,0,'');
 {Scroll Bar Buttons}
  OutTextXY(X + LENGTH(Temp),PickInfo.Y,15,0,'');
  OutTextXY(X + LENGTH(Temp),PickInfo.Y + PickInfo.ItemsOnScrn - 1,15,0,'');
  DrawPickListLocator;
END;

PROCEDURE AddToPickList(InString : STRING);
VAR
  Temp : STRING;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(InString[1],Temp[1],LENGTH(InString));
  Temp[0] := CHR(PickInfo.MaxChars);
  IF PickInfo.NumItems < 800 THEN BEGIN
    INC(PickInfo.NumItems);
    PickList^[PickInfo.NumItems] := Temp;
  END;
END;

PROCEDURE SetUpPickList;
VAR
  Loop : WORD;
  Y    : WORD;
  Cnt  : WORD;
BEGIN
  Cnt := PickInfo.Top;
  Y   := PickInfo.Y;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
    IF Cnt <= PickInfo.NumItems THEN BEGIN
      IF Cnt = PickInfo.Current THEN OutTextXY(PickInfo.X,Y,15,3,' ' + PickList^[Cnt] + ' ')
                                ELSE OutTextXY(PickInfo.X,Y,0,7,' ' + PickList^[Cnt] + ' ');
    END ELSE OutTextXY(PickInfo.X,Y,0,7,Replicate(' ',PickInfo.MaxChars + 2));
    INC(Y);
    INC(Cnt);
  END;
END;

PROCEDURE ResetPickList(Item : WORD);
BEGIN
  PickInfo.Current := Item;
  PickInfo.Top     := Item;
  IF PickInfo.Top > (PickInfo.NumItems - PickInfo.ItemsOnScrn) THEN DEC(PickInfo.Top,(PickInfo.ItemsOnScrn - 1));
  IF (PickInfo.Top < 1) OR (PickInfo.Top > 800) THEN PickInfo.Top := 1;
  DrawPickListLocator;
END;

PROCEDURE ScrollPickPgUp;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF (PickInfo.Top > 1) THEN BEGIN
    Temp := PickInfo.Top - PickInfo.ItemsOnScrn;
    IF Temp < 1 THEN Temp := 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top ELSE
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
    THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
    DrawPickListLocator;
    SetUpPickList;
  END ELSE IF (PickInfo.Current <> 1) THEN BEGIN
    PickInfo.Top := 1;
    PickInfo.Current := 1;
    DrawPickListLocator;
    SetUpPickList;
  END;
END;

PROCEDURE ScrollPickPgDown;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF ((PickInfo.Top + PickInfo.ItemsOnScrn - 1) < PickInfo.NumItems) THEN BEGIN
    Temp := PickInfo.Top + PickInfo.ItemsOnScrn;
    IF (Temp > (PickInfo.NumItems - PickInfo.ItemsOnScrn + 1)) THEN Temp := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top ELSE
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
    THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
    DrawPickListLocator;
    SetUpPickList;
  END ELSE IF (PickInfo.Current <> PickInfo.NumItems) THEN BEGIN
    PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Current := PickInfo.NumItems;
    DrawPickListLocator;
    SetUpPickList;
  END;
END;

PROCEDURE ScrollPickUp;
BEGIN
  IF PickInfo.Current > 1 THEN BEGIN
    DEC(PickInfo.Current);
    IF (PickInfo.Top > PickInfo.Current) THEN DEC(PickInfo.Top);
    DrawPickListLocator;
    SetUpPickList;
  END;
END;

PROCEDURE ScrollPickDown;
BEGIN
  IF PickInfo.Current < PickInfo.NumItems THEN BEGIN
    INC(PickInfo.Current);
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1) THEN INC(PickInfo.Top);
    DrawPickListLocator;
    SetUpPickList;
  END;
END;

FUNCTION GetPickList : STRING;
VAR
  Ch : CHAR;
BEGIN
  SetUpPickList;
  REPEAT
    Ch := READKEY;
    IF Ch = #0 THEN CH := READKEY;
    CASE ORD(Ch) OF
      13 :  BEGIN
              GetPickList := #13;
              EXIT;
            END;
      32 :  BEGIN
              GetPickList := PickList^[PickInfo.Current];
              EXIT;
            END;
      27 :  BEGIN
              GetPickList := #27;
              EXIT;
            END;
      72 :  BEGIN {Up}
              ScrollPickUp;
            END;
      80 :  BEGIN {Down}
              ScrollPickDown;
            END;
      73 :  BEGIN {PgUp}
              ScrollPickPgUp;
            END;
      81 :  BEGIN {PgDn}
              ScrollPickPgDown;
            END;
      132 : BEGIN {CTRL+PgUp}
              IF (PickInfo.Current <> 1) THEN BEGIN
                PickInfo.Top := 1;
                PickInfo.Current := 1;
                DrawPickListLocator;
                SetUpPickList;
              END;
            END;
      118 : BEGIN {CTRL+PgDn}
              IF (PickInfo.NumItems > PickInfo.ItemsOnScrn) THEN BEGIN
                IF (PickInfo.Top <> PickInfo.NumItems - PickInfo.ItemsOnScrn + 1) THEN BEGIN
                  PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
                  PickInfo.Current := PickInfo.NumItems;
                  DrawPickListLocator;
                  SetUpPickList;
                END;
              END;
            END;
    END;
  UNTIL (Ch = #13) OR (Ch = #32) OR (Ch = #27);
END;

FUNCTION GetString(X,Y,Size : BYTE ; ST : STRING) : STRING;
CONST
  BS       =  #8;
  CR       = #13;
  SP       = #32;
  Esc      = #27;
  LeftKey  = #75;
  RightKey = #77;
  HomeKey  = #71;
  EndKey   = #79;
  InsKey   = #82;
  DelKey   = #83;

VAR
  CurrLen   : BYTE ABSOLUTE ST;
  CurrPos   : BYTE;
  Ins       : BOOLEAN;
  I         : INTEGER;
  T         : CHAR;
  Fill      : CHAR;
BEGIN
  Fill    := '_';
  Ins     := TRUE;
  CurrLen := LENGTH(St);
  CurrPos := LENGTH(St);
  OutTextXY(X-1,Y,15,1,'[');
  OutTextXY(X+Size,Y,15,1,']');
  REPEAT
    OutTextXY(X,Y,7,0,PadRight(ST,Fill,Size));
    GOTOXY(X + CurrPos,Y);
    T := READKEY;
    IF T = #0 THEN BEGIN
      T := READKEY;
      CASE T OF
        LeftKey  : IF CurrPos > 0 THEN DEC(CurrPos);
        RightKey : IF (CurrPos < CurrLen) AND (CurrPos < Size) THEN INC(CurrPos);
        InsKey   : Ins := NOT Ins;
        HomeKey  : CurrPos := 0;
        EndKey   : CurrPos := CurrLen;
        DelKey   : IF CurrLen > CurrPos THEN BEGIN
                     FOR I := CurrPos + 1 TO CurrLen - 1 DO ST[I] := ST[I + 1];
                     DEC(CurrLen)
                   END;
      END;
    END ELSE BEGIN
      CASE T OF
        BS       : IF CurrPos > 0 THEN BEGIN
                     FOR I := CurrPos TO CurrLen - 1 DO ST[I] := ST[I + 1];
                     DEC(CurrPos);
                     DEC(CurrLen);
                   END;
        SP..#255 : IF CurrLen < Size THEN BEGIN
                     INC(CurrPos);
                     IF Ins THEN BEGIN
                       FOR I := CurrLen DOWNTO CurrPos DO ST[I + 1] := ST[I];
                       INC(CurrLen);
                     END;
                     ST[CurrPos] := T;
                   END;
      END;
    END;
  UNTIL (T = CR) OR (T = Esc);
  IF T = Esc THEN GetString := #27 ELSE GetString := ST;
END;

PROCEDURE DummyField(X,Y,Size : BYTE ; ST : STRING);
BEGIN
  OutTextXY(X-1,Y,15,1,'[');
  OutTextXY(X,Y,7,0,PadRight(St,'_',Size));
  OutTextXY(X+Size,Y,15,1,']');
END;

PROCEDURE SaveScreen;
BEGIN
  IF VBuff <> NIL THEN EXIT;
  NEW(VBuff);
  MOVE(Mem[$B800 : 0000],VBuff^,4000);
END;

PROCEDURE RestoreScreen;
BEGIN
  IF VBuff = NIL THEN EXIT;
  MOVE(VBuff^,Mem[$B800 : 0000],4000);
  DISPOSE(VBuff);
  VBuff := NIL;
END;

BEGIN
  VBuff    := NIL;
  PickList := NIL;
END.
