{$I DEFINES.INC}
PROGRAM SETUP;

USES CRT, DOS, FGMAIN, FGSVGA, CRCUNIT, FASTW1, ARCHUNIT,
     TEXT_GUI, GUI_UTIL, TERMVARS, APVARS, APTIMER, RAINBOW;

TYPE Big_Buffer = ARRAY[1..800] OF STRING[80];

TYPE Modems       = RECORD
     Name         : STRING[60];
     Init1        : STRING[40];
     Init2        : STRING[40];
     Init3        : STRING[40];
     Answer       : STRING[10];
     OnHook       : STRING[10];
     OffHook      : STRING[10];
     Dial         : STRING[10];
     Baud         : LONGINT;
     Delay        : WORD;
     HwFlow       : BOOLEAN;
     END;

CONST
  BackColour = 9;
  BarColour  = 1;
  TextColour = 15;
  StatColour = 15;

VAR
  Mdm         : Modems;
  FMdm        : FILE OF Modems;
  BigBuffer   : ^Big_Buffer;
  TFile       : TEXT;
  OldDir      : STRING;
  NewPkg      : STRING[12];
  ArcPath     : STRING[80];
  WorkDir     : STRING[80];
  VRAM        : WORD;
  VCARD       : WORD;
  Lines       : WORD;
  AllDone     : BOOLEAN;
  KillIt      : BOOLEAN;
  UpdatePKGs  : BOOLEAN;
  Top         : INTEGER;
  C           : CHAR;

PROCEDURE LoadFile(FName : STRING);
VAR
  Temp : STRING;
BEGIN
   Lines := 0;
   ASSIGN(TFile,FName);
   RESET(TFile);
   REPEAT
     READLN(TFile,Temp);
     INC(Lines);
     BigBuffer^[Lines] := PadRight(Temp,' ',80);
   UNTIL (EOF(TFile)) OR (Lines = 800);
   CLOSE(TFile);
END;

PROCEDURE DrawMain(FName : STRING);
BEGIN
  TextBackground_BS(BackColour);
  CLRSCR;
  TextBackground_BS(BarColour);
  GOTOXY(1,1); CLREOL;
  GOTOXY(1,25); CLREOL;
  TextColor_BS(StatColour);
  GOTOXY(1,1);  WRITE('   Reading Text File: ' + FName + '  ');
  GOTOXY(1,25); WRITE(' User Keys:  /  PgUp/PgDn  Home/End  ENTER/ESC=Exit');
  Show_Mem;
END;

PROCEDURE DrawFromCursor;
VAR
  TheAttr : BYTE;
BEGIN
  TheAttr := (BackColour * 16) + TextColour;
  FastWrite(BigBuffer^[Top],2,1,TheAttr);
  FastWrite(BigBuffer^[Top + 1],3,1,TheAttr);
  FastWrite(BigBuffer^[Top + 2],4,1,TheAttr);
  FastWrite(BigBuffer^[Top + 3],5,1,TheAttr);
  FastWrite(BigBuffer^[Top + 4],6,1,TheAttr);
  FastWrite(BigBuffer^[Top + 5],7,1,TheAttr);
  FastWrite(BigBuffer^[Top + 6],8,1,TheAttr);
  FastWrite(BigBuffer^[Top + 7],9,1,TheAttr);
  FastWrite(BigBuffer^[Top + 8],10,1,TheAttr);
  FastWrite(BigBuffer^[Top + 9],11,1,TheAttr);
  FastWrite(BigBuffer^[Top + 10],12,1,TheAttr);
  FastWrite(BigBuffer^[Top + 11],13,1,TheAttr);
  FastWrite(BigBuffer^[Top + 12],14,1,TheAttr);
  FastWrite(BigBuffer^[Top + 13],15,1,TheAttr);
  FastWrite(BigBuffer^[Top + 14],16,1,TheAttr);
  FastWrite(BigBuffer^[Top + 15],17,1,TheAttr);
  FastWrite(BigBuffer^[Top + 16],18,1,TheAttr);
  FastWrite(BigBuffer^[Top + 17],19,1,TheAttr);
  FastWrite(BigBuffer^[Top + 18],20,1,TheAttr);
  FastWrite(BigBuffer^[Top + 19],21,1,TheAttr);
  FastWrite(BigBuffer^[Top + 20],22,1,TheAttr);
  FastWrite(BigBuffer^[Top + 21],23,1,TheAttr);
  FastWrite(BigBuffer^[Top + 22],24,1,TheAttr);
END;

PROCEDURE ReadTextFile(FName : STRING);
BEGIN
  IF NOT FExist(FName) THEN EXIT;
  HideMouse;
  NEW(BigBuffer);
  FILLCHAR(BigBuffer^,SIZEOF(BigBuffer^),0);
  LoadFile(FName);
  DrawMain(FName);
  Top     := 1;
  AllDone := FALSE;
  DrawFromCursor;
  REPEAT
    IF NOT KEYPRESSED THEN SliceMouse ELSE BEGIN
      C := READKEY;
      IF ORD(C) = 0 THEN BEGIN
        C := READKEY;
        CASE ORD(C) OF
          72   : BEGIN {UP}
                   IF Top > 1 THEN BEGIN
                     DEC(Top);
                     DrawFromCursor;
                   END;
                 END;
           80  : BEGIN {DOWN}
                   IF Top + 22 < Lines THEN BEGIN
                     INC(Top);
                     DrawFromCursor;
                   END;
                 END;
           73  : BEGIN {PGUP}
                   IF Top > 1 THEN BEGIN
                     DEC(Top,23);
                     IF Top < 1 THEN Top := 1;
                     DrawFromCursor;
                   END;
                 END;
           81  : BEGIN {PGDN}
                   IF Top + 22 < Lines THEN BEGIN
                     INC(Top,23);
                     IF Top + 22 > Lines THEN Top := Lines - 22;
                     DrawFromCursor;
                   END;
                 END;
           71,
           132 : BEGIN {HOME/CRTL-PGUP}
                   Top := 1;
                   DrawFromCursor;
                 END;
           79,
           118 : BEGIN {END/CTRL-PGDN}
                   Top := Lines - 22;
                   DrawFromCursor;
                 END;
        END;
      END ELSE BEGIN
        CASE ORD(C) OF
          27,
          13 : AllDone := TRUE;
        END;
      END;
    END;
  UNTIL AllDone;
  DISPOSE(BigBuffer);
  ShowMouse;
END;

PROCEDURE SetUpScreen;
VAR
  ButNum : BYTE;
BEGIN
  FireUpText; HideCursor; HideMouse;
  MemFG := 15;
  MemBG := 1;
  TextBackground_BS(8);
  CLRSCR;
  OutTextXY(1,1,15,1,Center(ProgramName + ' Setup',80));
  OutTextXY(1,25,15,1,PadRight(' Running Under ' + OsStr,' ',80));
  Show_Mem;
  DrawWindow(9,8,72,16,'Welcome To ' + ProgramName);
  OutTextXY(10,10,14,1,'MAX Graphics and the MAXscript/MAXcontrol/MAXcolor language is');
  OutTextXY(12,11,14,1,'(C) 1995-Current  Larry L. Athey  BBS Utiliteez Software');
  OutTextXY(10,12,9,1,PadRight(#196,#196,62));
  OutTextXY(11,14,11,1,'Do you wish to continue installing MAXterm?');
  SystemButton(57,14,21,1,FALSE,TRUE,'Yes');
  SystemButton(64,14,49,1,FALSE,TRUE,'No ');
  Show_Mem;
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  KillWindow;
  IF ButNum = 2 THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN(ProgramName + ' installation aborted...');
    HALT;
  END;
END;

PROCEDURE UserNote;
VAR
  ButNum : BYTE;
BEGIN
  NewWin;
  DrawWindow(3,3,78,23,'Welcome To ' + ProgramName);
  OutTextXY(5,5,11,1,'Before this program can continue installing, you will need to know a few');
  OutTextXY(5,6,11,1,'things about your system in advance. First of all, you will need to have');
  OutTextXY(5,7,11,1,'a Microsoft compatible mouse installed. Without one, you could get stuck');
  OutTextXY(5,8,11,1,'in the program with no visible escape. You will also want make sure that');
  OutTextXY(5,9,11,1,'you have as much free conventional memory as possible (600K or better)..');
  OutTextXY(4,10,9,1,PadRight(#196,#196,74));
  OutTextXY(5,11,11,1,'You will also need to know the comport number and IRQ that your modem is');
  OutTextXY(5,12,11,1,'attached to. This program will default to UART communications as well as');
  OutTextXY(5,13,11,1,'to a 38400 baud locked port speed. You can change these settings to suit');
  OutTextXY(5,14,11,1,'your system as needed..');
  OutTextXY(4,15,9,1,PadRight(#196,#196,74));
  OutTextXY(5,16,11,1,'Lastly, if you have a "SoundBlaster" compatible sound card installed you');
  OutTextXY(5,17,11,1,'will need to know the port hex address, IRQ, and DMA channel of the card');
  OutTextXY(5,18,11,1,'as well.  This information is usually available in your AUTOEXEC.BAT, or');
  OutTextXY(5,19,11,1,'if you run MS Windows, check the "Control Panel" settings for your sound');
  OutTextXY(5,20,11,1,'card to obtain this information..');
  OutTextXY(39,21,14,1,'Continue Installation?');
  SystemButton(63,21,21,1,FALSE,TRUE,'Yes');
  SystemButton(71,21,49,1,FALSE,TRUE,'No ');
  Show_Mem; ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  KillWindow;
  IF ButNum = 2 THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN(ProgramName + ' installation aborted...');
    HALT;
  END;
END;

PROCEDURE GetHomeDir;
VAR
  Drive    : STRING[3];
  Done     : BOOLEAN;
  ButNum   : BYTE;
BEGIN
  Done := FALSE;
  GETDIR(0,Drive);
  IF (Drive = 'A:\') OR (Drive = 'B:\') THEN Drive := 'C:\';
  REPEAT
    NewWin;
    DrawWindow(17,10,64,14,'Enter Program Destination Directory');
    OutTextXY(19,12,11,1,'Destination Directory:');
    SystemField(43,12,5,11,Drive + 'MAXTERM');
    SystemButton(56,12,24,1,FALSE,TRUE,'Okay');
    Show_Mem; ShowMouse; ShowCursor;
    REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
    HideCursor;
    HomeDir := StripBoth(NoPath(Fields[1].Text),' ');
    KillWindow;
    IF FExist(HomeDir + '\MAXPAINT.EXE') THEN BEGIN
      RedWin;
      NewWin;
      DrawWindow(22,8,58,16,'Directory Error!');
      OutTextXY(24,10,14,4,'Sorry, due to directory and file');
      OutTextXY(24,11,14,4,'name conflicts you cannot install');
      OutTextXY(24,12,14,4,'MAXterm and MAXpaint in the same');
      OutTextXY(24,13,14,4,'directory...');
      SystemButton(50,14,24,1,FALSE,TRUE,'Okay');
      WRITE(^G);
      Show_Mem; ShowMouse;
      REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
      KillWindow;
      BlueWin;
    END ELSE Done := TRUE;
  UNTIL Done;
  IF HomeDir = '' THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN('No program destination directory specified,');
    WRITELN(ProgramName + ' installation terminated...');
    HALT;
  END;
  MakeDir(HomeDir);
  MakeDir(HomeDir + '\SESSION');
  MakeDir(HomeDir + '\RESOURCE');
  IF (FExist(HomeDir + '\RESOURCE\DEFAULT.PKG')) AND
     (AllCaps(FileToCRC(HomeDir + '\RESOURCE\DEFAULT.PKG')) <> '9A1E5DF3')
     THEN UpdatePKGs := TRUE;
END;

PROCEDURE ExtractFiles;
VAR
  F        : TEXT;
  Count    : WORD;
  Found1   : BOOLEAN;
  Found2   : BOOLEAN;
  WorkFile : STRING[12];
  DirInfo  : SEARCHREC;
  FDD      : FILE OF Dialing_Directory;
  FFDD     : FILE OF Dialing_Directory;
BEGIN
  IF NOT FExist('MXT.RES') THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN('Program installation resource files not found,');
    WRITELN(ProgramName + ' installation terminated...');
    HALT;
  END;
  HideMouse;
  OutTextXY(1,12,15,8,Center('Preparing installation files...',80));
  ShowMouse;
  NewPkg := '';
  CopyFile('MXT.RES',HomeDir + '\MXT.EXE');
  IF FExist('MAXPHONE.DIR') THEN BEGIN
    CopyFile('MAXPHONE.DIR','MAXPHONE.ORG');
    ASSIGN(FDD,'MAXPHONE.DIR');
    ASSIGN(FFDD,'MAXPHONE.ORG');
    REWRITE(FDD);
    RESET(FFDD);
    FILLCHAR(DD,SIZEOF(DD),0);
    WITH DD DO BEGIN
      BBSname     := 'USA MAX Graphics HQ-BBS';
      PhoneNumber := '1-308-762-2239';
      UseMAX      := TRUE;
      BoardID     := 'MAXHQBBS';
      AnsiMode    := 1;
      UseSB       := TRUE;
    END;
    WRITE(FDD,DD);
    WITH DD DO BEGIN
      BBSname     := 'Vast 99 ConnecTIon';
      PhoneNumber := '1-602-267-1419';
      UseMAX      := TRUE;
      BoardID     := 'VAST_99';
      AnsiMode    := 1;
      UseSB       := TRUE;
    END;
    WRITE(FDD,DD);
    READ(FFDD,DD);
    IF DD.BoardID = 'DEFAULT' THEN DD.BoardID := 'BBS1';
    NewPkg := DD.BoardID + '.PKG';
    WRITE(FDD,DD);
    CLOSE(FDD);
    CLOSE(FFDD);
    ERASE(FFDD);
    CopyFile('MAXPHONE.DIR',HomeDir + '\MAXPHONE.DIR');
  END;
  HideMouse; ShutDownText; HideCursor;
  CHDIR(HomeDir);
  IF DExist(HomeDir + '\SPOOL') THEN BEGIN
    CHDIR(HomeDir + '\SPOOL');
    FINDFIRST('*.*',Anyfile - Directory - VolumeID,DirInfo);
    WHILE DOSERROR = 0 DO BEGIN
      WorkFile := AllCaps(DirInfo.Name);
      FErase(WorkFile);
      FINDNEXT(DirInfo);
    END;
    CHDIR(HomeDir);
    RMDIR(HomeDir + '\SPOOL');
  END;
  {----- Delete v1.XX Files -----}
  FErase('BBS-UTIL.TXT');
  FErase('DX2.EXE');
  FErase('MAXTERM.MIF');
  FErase('MAXTERM.OVR');
  FErase('SCRNEDIT.EXE');
  FErase('ICONEDIT.EXE');
  FErase('MAXGRAPH.TXT');
  FErase('MAXGRAPH.PAL');
  FErase('MAXTERM.CMD');
  FErase('LA-SOFT.COM');
  FErase('WARNING.TXT');
  {----- Delete v2.XX Files -----}
  FErase('BETATERM.BAT');
  FErase('BUG_RPRT.FRM');
  FErase('CAM50.FNT');
  FErase('FREQ.LST');
  FErase('FILE_ID.DIZ');
  FErase('FGDRIVER.EXE');
  FErase('MAXCOMP.EXE');
  FErase('MAXSOUND.EXE');
  FErase('MAXTERM.EXE');
  FErase('MAXTERM.DOC');
  FErase('MAXTERM.BMX');
  FErase('MAXTERM.NEW');
  FErase('MODEM.LIB');
  FErase('MIF.EXE');
  FErase('PALETTE.DAT');
  {------------------------------}
  Execute('MXT.EXE','');
  FireUpText; HideCursor; HideMouse;
  MemFG := 15;
  MemBG := 1;
  TextBackground_BS(8);
  CLRSCR;
  OutTextXY(1,1,15,1,Center(ProgramName + ' Setup',80));
  OutTextXY(1,25,15,1,PadRight(' Running Under ' + OsStr,' ',80));
  Show_Mem;
  ShowMouse;
  IF NOT FExist('BROWSER.BAT') THEN BEGIN
    ASSIGN(F,'BROWSER.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'HTMLVIEW.EXE %1');
    CLOSE(F);
  END;
  IF NOT FExist('TEXTEDIT.BAT') THEN BEGIN
    ASSIGN(F,'TEXTEDIT.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'C:\QEDIT\Q.EXE %1');
    CLOSE(F);
  END;
  IF NOT FExist('ICONEDIT.BAT') THEN BEGIN
    ASSIGN(F,'ICONEDIT.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'ICON.EXE %1');
    CLOSE(F);
  END;
  IF NOT FExist('SCRNVIEW.BAT') THEN BEGIN
    ASSIGN(F,'SCRNVIEW.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'SCRIPT.EXE %1 %2');
    CLOSE(F);
  END;
  IF NOT FExist('OLMR.BAT') THEN BEGIN
    ASSIGN(F,'OLMR.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'CD\VESAQWK');
    WRITELN(F,'VESAQWK.EXE');
    CLOSE(F);
  END;
  IF NOT FExist('FAX.BAT') THEN BEGIN
    ASSIGN(F,'FAX.BAT');
    REWRITE(F);
    WRITELN(F,'@ECHO OFF');
    WRITELN(F,'MAXFAX.EXE');
    CLOSE(F);
  END;
  FErase('MXT.EXE');
  IF FExist(HomeDir + '\RESOURCE\DEFAULT.PKG') THEN BEGIN
    CopyFile(HomeDir + '\RESOURCE\DEFAULT.PKG',HomeDir + '\RESOURCE\DEFAULT.OLD');
    FErase(HomeDir + '\RESOURCE\DEFAULT.PKG');
  END;
  IF NOT FExist('DEFAULT.PKG') THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('The file DEFAULT.PKG is missing from this archive which means');
    WRITELN('the person you got MAXterm from has tampered with it, or they');
    WRITELN('have not yet figured out how to set their upload processor to');
    WRITELN('leave internal archives alone and/or not rename them...');
    WRITELN;
    WRITELN(ProgramName + ' installation terminated...');
    WRITE(^G);
    FErase('MAXTERM.EXE');
    HALT;
  END;
  IF AllCaps(FileToCrc('DEFAULT.PKG')) <> '9A1E5DF3' THEN BEGIN
    HideMouse;
    ShutDownText;
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('The DEFAULT.PKG in this archive has a CRC error in it which means');
    WRITELN('either the person you got MAXterm from, or a virus has altered it');
    WRITELN('one way or another...');
    WRITELN;
    WRITELN(ProgramName + ' installation terminated...');
    WRITE(^G);
    FErase('MAXTERM.EXE');
    HALT;
  END;
  CopyFile('DEFAULT.PKG',HomeDir + '\RESOURCE\DEFAULT.PKG');
  FErase('DEFAULT.PKG');
  IF NewPkg <> '' THEN BEGIN
    CopyFile(OldDir + '\' + NewPkg,HomeDir + '\RESOURCE\' + NewPkg);
    FErase(OldDir + '\' + NewPkg);
  END;
  CopyFile(OldDir + '\MAXPHONE.DIR',HomeDir + '\MAXPHONE.DIR');
  IF FExist('MAXPHONE.DIR') THEN BEGIN
    Found1 := FALSE;
    Found2 := FALSE;
    ASSIGN(FDD,'MAXPHONE.DIR');
    RESET(FDD);
    Count := 0;
    WHILE NOT EOF(FDD) DO BEGIN
      READ(FDD,DD);
      IF DD.BoardID = 'DEFAULT' THEN BEGIN
        DD.BoardID := 'BBS' + IntToStr(Count + 1);
        SEEK(FDD,Count);
        WRITE(FDD,DD);
      END;
      IF POS('762-2239',DD.PhoneNumber) > 0 THEN BEGIN
        Found1 := TRUE;
        WITH DD DO BEGIN
          BBSname     := 'USA MAX Graphics HQ-BBS';
          PhoneNumber := '1-308-762-2239';
          UseMAX      := TRUE;
          BoardID     := 'MAXHQBBS';
          AnsiMode    := 1;
          UseSB       := TRUE;
        END;
        SEEK(FDD,Count);
        WRITE(FDD,DD);
      END;
      IF POS('267-1419',DD.PhoneNumber) > 0 THEN BEGIN
        Found2 := TRUE;
        WITH DD DO BEGIN
          BBSname     := 'Vast 99 ConnecTIon';
          PhoneNumber := '1-602-267-1419';
          UseMAX      := TRUE;
          BoardID     := 'VAST_99';
          AnsiMode    := 1;
          UseSB       := TRUE;
        END;
        SEEK(FDD,Count);
        WRITE(FDD,DD);
      END;
      INC(Count);
    END;
    IF NOT Found1 THEN WITH DD DO BEGIN
      BBSname     := 'USA MAX Graphics HQ-BBS';
      PhoneNumber := '1-308-762-2239';
      UseMAX      := TRUE;
      BoardID     := 'MAXHQBBS';
      AnsiMode    := 1;
      UseSB       := TRUE;
      WRITE(FDD,DD);
    END;
    IF NOT Found2 THEN WITH DD DO BEGIN
      BBSname     := 'Vast 99 ConnecTIon';
      PhoneNumber := '1-602-267-1419';
      UseMAX      := TRUE;
      BoardID     := 'VAST_99';
      AnsiMode    := 1;
      UseSB       := TRUE;
      WRITE(FDD,DD);
    END;
    CLOSE(FDD);
  END;
  FErase(OldDir + '\MAXPHONE.DIR');
END;

FUNCTION GetModem : WORD;
VAR
  ButNum : BYTE;
BEGIN
  GetModem := 65535;
  IF NOT FExist('MODEM.LIB') THEN EXIT;
  ASSIGN(FMdm,'MODEM.LIB');
  NewWin;
  DrawWindow(7,5,73,20,'Select Modem Settings');
  NewPickList(9,7,10,60);
  AddToPickList('Use Existing MAXterm Modem Settings');
  RESET(FMdm);
  WHILE NOT EOF(FMdm) DO BEGIN
    READ(FMdm,Mdm);
    AddToPickList(Mdm.Name);
  END;
  CLOSE(FMdm);
  SetUpPickList;
  SystemButton(9,18,31,1,FALSE,TRUE,'Select');
  Show_Mem;
  ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum > 2;
  IF PickInfo.Current > 1 THEN GetModem := (PickInfo.Current - 2);
  KillWindow;
END;

PROCEDURE DoModemSetup;
VAR
  ButNum   : BYTE;
  TheModem : WORD;
  PortDat  : FILE OF ComPortDefinition;
  ModemDat : FILE OF Modem_Commands;
BEGIN
  ASSIGN(ModemDat,'MAXMODEM.CFG');
  IF NOT FExist('MAXMODEM.CFG') THEN BEGIN
    REWRITE(ModemDat);
    WRITE(ModemDat,Modem);
    CLOSE(ModemDat);
  END;
  RESET(ModemDat);
  READ(ModemDat,Modem);
  CLOSE(ModemDat);
  ASSIGN(PortDat,'MAX_PORT.CFG');
  IF NOT FExist('MAX_PORT.CFG') THEN BEGIN
    REWRITE(PortDat);
    WRITE(PortDat,CommDef);
    CLOSE(PortDat);
  END;
  RESET(PortDat);
  READ(PortDat,CommDef);
  CLOSE(PortDat);
  TheModem := GetModem;
  IF TheModem <> 65535 THEN BEGIN
    ASSIGN(FMdm,'MODEM.LIB');
    RESET(FMdm);
    SEEK(FMdm,TheModem);
    READ(FMdm,Mdm);
    CLOSE(FMdm);
    WITH Mdm DO BEGIN
      Modem.Init1           := Init1;
      Modem.Init2           := Init2;
      Modem.Init3           := Init3;
      Modem.Answer          := Answer;
      Modem.OnHook          := OnHook;
      Modem.OffHook         := OffHook;
      Modem.Dial            := Dial;
      CommDef.Command_Delay := Delay;
      CommDef.Baud          := Baud;
      CommDef.HwFlow        := HwFlow;
    END;
  END;
  NewWin;
  DrawWindow(10,3,70,23,'Modem Configuration');
  OutTextXY(12,5,11,1, 'Init String #1 :'); SystemField(29,5,0,40,Modem.Init1);
  OutTextXY(12,6,11,1, 'Init String #2 :'); SystemField(29,6,0,40,Modem.Init2);
  OutTextXY(12,7,11,1, 'Init String #3 :'); SystemField(29,7,0,40,Modem.Init3);
  OutTextXY(12,8,11,1, ' Answer String :'); SystemField(29,8,0,10,Modem.Answer);
  OutTextXY(12,9,11,1, 'On Hook String :'); SystemField(29,9,0,10,Modem.OnHook);
  OutTextXY(12,10,11,1,' Off Hook Str. :'); SystemField(29,10,0,10,Modem.OffHook);
  OutTextXY(12,11,11,1,' Pre Dial Str. :'); SystemField(29,11,0,10,Modem.Dial);
  OutTextXY(12,12,11,1,' Command Delay :'); SystemField(29,12,1,4,IntToStr(CommDef.Command_Delay));
    OutTextXY(35,12,14,1,'In Milliseconds');
  OutTextXY(12,13,11,1,'   Device Type :'); SystemField(29,13,1,1,IntToStr(CommDef.Device));
    OutTextXY(35,13,14,1,'1=UART, 2=Fossil, 3=DigiBoard');
  OutTextXY(12,14,11,1,'   Comm Port # :'); SystemField(29,14,1,1,IntToStr(CommDef.Port));
    OutTextXY(35,14,14,1,'Supports COM1 Through COM8');
  OutTextXY(12,15,11,1,' Comm Port IRQ :'); SystemField(29,15,1,2,IntToStr(CommDef.IRQ));
    OutTextXY(35,15,14,1,'Set To 0 For Standard IRQ');
  OutTextXY(12,16,11,1,'  Port Address :'); SystemField(29,16,5,4,CommDef.PortAddr);
    OutTextXY(35,16,14,1,'Set To 0 For Standard Address');
  OutTextXY(12,17,11,1,'    Port Speed :'); SystemField(29,17,1,6,IntToStr(CommDef.Baud));
  OutTextXY(12,18,11,1,'  Input Buffer :'); SystemField(29,18,1,4,IntToStr(CommDef.In_Buffer));
    OutTextXY(35,18,14,1,'Buffer Size In Bytes');
  OutTextXY(12,19,11,1,' Output Buffer :'); SystemField(29,19,1,4,IntToStr(CommDef.Out_Buffer));
    OutTextXY(35,19,14,1,'Buffer Size In Bytes');
  OutTextXY(12,20,11,1,' H/W Flow Ctrl :'); SystemField(29,20,5,1,BoolToStr(CommDef.HwFlow));
    OutTextXY(35,20,14,1,'[Y/N]');
  SystemButton(62,21,24,1,FALSE,TRUE,'Okay');
  Show_Mem; ShowMouse; ShowCursor;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  HideCursor;
  WITH Modem DO BEGIN
    Init1   := AllCaps(StripBoth(Fields[1].Text,' '));
    Init2   := AllCaps(StripBoth(Fields[2].Text,' '));
    Init3   := AllCaps(StripBoth(Fields[3].Text,' '));
    Answer  := AllCaps(StripBoth(Fields[4].Text,' '));
    OnHook  := AllCaps(StripBoth(Fields[5].Text,' '));
    OffHook := AllCaps(StripBoth(Fields[6].Text,' '));
    Dial    := AllCaps(StripBoth(Fields[7].Text,' '));
  END;
  RESET(ModemDat);
  WRITE(ModemDat,Modem);
  CLOSE(ModemDat);
  WITH CommDef DO BEGIN
    Command_Delay := StrToInt(StripBoth(Fields[8].Text,' '));
    Device        := StrToInt(StripBoth(Fields[9].Text,' '));
    IF (Device < 1) OR (Device > 3) THEN Device := 1;
    Port          := StrToInt(StripBoth(Fields[10].Text,' '));
    IF (Port < 1) OR (Port > 8) THEN Port := 1;
    IRQ           := StrToInt(StripBoth(Fields[11].Text,' '));
    PortAddr      := StripBoth(Fields[12].Text,' ');
    PortAddr      := StripBoth(PortAddr,'$');
    Baud          := StrToInt(StripBoth(Fields[13].Text,' '));
    IF (Baud <> 300) AND
       (Baud <> 600) AND
       (Baud <> 1200) AND
       (Baud <> 2400) AND
       (Baud <> 4800) AND
       (Baud <> 9600) AND
       (Baud <> 19200) AND
       (Baud <> 38400) AND
       (Baud <> 57600) AND
       (Baud <> 115200) THEN Baud := 38400;
    In_Buffer  := StrToInt(StripBoth(Fields[14].Text,' '));
    Out_Buffer := StrToInt(StripBoth(Fields[15].Text,' '));
    HwFlow     := StrToBool(Fields[16].Text);
  END;
  RESET(PortDat);
  WRITE(PortDat,CommDef);
  CLOSE(PortDat);
  KillWindow;
END;

PROCEDURE DoMiscSettings;
VAR
  ButNum  : BYTE;
  Done    : BOOLEAN;
  MiscDat : FILE OF Misc_Information;
BEGIN
  ASSIGN(MiscDat,'MAX_MISC.CFG');
  IF NOT FExist('MAX_MISC.CFG') THEN BEGIN
    WITH Misc DO BEGIN
      DefaultArc := 0;
      GETDIR(0,UpPath);
      GETDIR(0,DownPath);
      UpPath := UpPath + '\UPS';
      MakeDir(UpPath);
      DownPath := DownPath + '\DOWNS';
      MakeDir(DownPath);
      UpPath     := FixPath(UpPath);
      DownPath   := FixPath(DownPath);
      ArcPath    := FixPath(ArcPath);
      ArcBAT     := HomeDir + '\MYARC.BAT';
      UnArcBAT   := HomeDir + '\MYUNARC.BAT';
      UpProto    := HomeDir + '\UPLOAD.BAT';
      DownProto  := HomeDir + '\DOWNLOAD.BAT';
      Retries    := 10;
      RetryDelay := 15;
      EditorPKG  := 'DEFAULT';
    END;
    REWRITE(MiscDat);
    WRITE(MiscDat,Misc);
    CLOSE(MiscDat);
  END;
  RESET(MiscDat);
  READ(MiscDat,Misc);
  CLOSE(MiscDat);
  Done := FALSE;
  NewWin;
  DrawWindow(4,8,76,17,'File/Path/Misc Settings');
  Show_Mem;
  OutTextXY(6,10,11,1,'      Upload Path :'); SystemField(26,10,0,40,Misc.UpPath);
  OutTextXY(6,11,11,1,'    Download Path :'); SystemField(26,11,0,40,Misc.DownPath);
  OutTextXY(6,12,11,1,'Custom Send Proto :'); SystemField(26,12,0,40,Misc.UpProto);
  OutTextXY(6,13,11,1,'Custom Recv Proto :'); SystemField(26,13,0,40,Misc.DownProto);
  OutTextXY(6,14,11,1,'Busy Call Retries :'); SystemField(26,14,1,2,IntToStr(Misc.Retries));
  OutTextXY(6,15,11,1,' Call Retry Delay :'); SystemField(26,15,1,2,IntToStr(Misc.RetryDelay));
  OutTextXY(30,15,14,1,'In Seconds');
  OutTextXY(6,16,11,1,'  Viewer PKG File :'); SystemField(26,16,5,8,Misc.EditorPKG);
  SystemButton(67,15,24,1,FALSE,TRUE,'Okay');
  Show_Mem; ShowMouse; ShowCursor;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  HideCursor;
  WITH Misc DO BEGIN
    UpPath     := FixPath(StripBoth(Fields[1].Text,' '));
    IF (NOT DExist(NoPath(UpPath))) OR (UpPath = '\') THEN UpPath := FixPath(HomeDir);
    DownPath   := FixPath(StripBoth(Fields[2].Text,' '));
    IF (NOT DExist(NoPath(DownPath))) OR (DownPath = '\') THEN DownPath := FixPath(HomeDir);
    UpProto    := AllCaps(StripBoth(Fields[3].Text,' '));
    DownProto  := AllCaps(StripBoth(Fields[4].Text,' '));
    Retries    := StrToInt(StripBoth(Fields[5].Text,' '));
    RetryDelay := StrToInt(StripBoth(Fields[6].Text,' '));
    EditorPKG  := StripBoth(Fields[7].Text,' ');
    IF EditorPKG = '' THEN EditorPKG := 'DEFAULT';
  END;
  RESET(MiscDat);
  WRITE(MiscDat,Misc);
  CLOSE(MiscDat);
  KillWindow;
END;

PROCEDURE DoSoundCard;
VAR
  ButNum : BYTE;
  FSB    : FILE OF SB_Information;
BEGIN
  ASSIGN(FSB,'MAXSOUND.CFG');
  IF NOT FExist('MAXSOUND.CFG') THEN BEGIN
    REWRITE(FSB);
    WITH SB DO BEGIN
      IRQ     := '5';
      DMA     := '1';
      Address := '220';
    END;
    WRITE(FSB,SB);
    CLOSE(FSB);
  END;
  FErase('NOSOUND.FLG');
  NewWin;
  DrawWindow(9,9,71,15,'Sound Card Setup');
  OutTextXY(11,11,14,1,'Do You Have A SoundBlaster Compatible Sound Card Installed?');
  SystemButton(56,13,21,1,FALSE,TRUE,'Yes');
  SystemButton(64,13,49,1,FALSE,TRUE,'No ');
  Show_Mem; ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  KillWindow;
  IF ButNum = 2 THEN BEGIN
    CopyFile('MAXSOUND.CFG','NOSOUND.FLG');
    EXIT;
  END;
  RESET(FSB);
  READ(FSB,SB);
  NewWin;
  DrawWindow(23,9,58,15,'Sound Card Settings');
  OutTextXY(25,11,11,1,'Port Hex Address :'); SystemField(44,11,1,3,SB.Address);
  OutTextXY(25,12,11,1,'        Port IRQ :'); SystemField(44,12,1,2,SB.IRQ);
  OutTextXY(25,13,11,1,'     DMA Channel :'); SystemField(44,13,1,2,SB.DMA);
  SystemButton(50,13,24,1,FALSE,TRUE,'Okay');
  Show_Mem; ShowMouse; ShowCursor;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
  SEEK(FSB,0);
  WITH SB DO BEGIN
    Address := StripBoth(Fields[1].Text,' ');
    Address := StripBoth(Address,'$');
    IRQ     := StripBoth(Fields[2].Text,' ');
    DMA     := StripBoth(Fields[3].Text,' ');
    WRITE(FSB,SB);
  END;
  CLOSE(FSB);
  HideCursor;
  KillWindow;
END;

PROCEDURE DoVideoSetup;
CONST ChipSet : ARRAY[1..70] OF STRING[37] = ('Generic VESA Compatible',
                                              'Acer Labs 3100 Series',
                                              'Ahead V5000A',
                                              'Ahead V5000B',
                                              'Alliance ProMotion 3210/6410',
                                              'Alliance ProMotion 6422/AT24',
                                              'ARK Logic 1000/2000',
                                              'ATI 18800',
                                              'ATI 18800-1',
                                              'ATI 28800/38800',
                                              'ATI Mach32 (68800)',
                                              'ATI Mach64 CX/GX',
                                              'ATI Mach64 CT/ET/GT/VT',
                                              'Advance Logic 2101',
                                              'Advance Logic 2201',
                                              'Advance Logic 2228/2301',
                                              'C&T 82c450/453',
                                              'C&T 82c451/455/456/457',
                                              'C&T 82c452',
                                              'C&T 64000 Series',
                                              'C&T 65510/65520/65525/65530',
                                              'C&T 65535',
                                              'C&T 65540/65545',
                                              'C&T 65548',
                                              'C&T 65550 Series',
                                              'Cirrus Logic 5402',
                                              'Cirrus Logic 5420',
                                              'Cirrus Logic 5422/5424/5426/5428/5429',
                                              'Cirrus Logic 5430/5440 Series',
                                              'Cirrus Logic 6200 Series',
                                              'Cirrus Logic 6245',
                                              'Cirrus Logic 6400 Series',
                                              'Cirrus Logic 7540 Series',
                                              'Diamond Viper with Weitek P9000',
                                              'Genoa 6000 Series',
                                              'HMC 86304/86314',
                                              'Matrox MGA 64',
                                              'Matrox MGA 1064SG/2064W',
                                              'NCR 77C21/77C22',
                                              'NCR 77C22E',
                                              'NCR 77C32BLT',
                                              'Oak OTI-067',
                                              'Oak OTI-077',
                                              'Oak OTI-087',
                                              'Oak 64000 Series',
                                              'Paradise PVGA1a',
                                              'Paradise WD90C00/WD90C10',
                                              'Paradise WD90C11/WD90C30',
                                              'Paradise WD90C24/WD90C26',
                                              'Paradise WD90C31',
                                              'Paradise WD90C33',
                                              'Paradise WD9710',
                                              'Realtek 3100 Series',
                                              'S3 86C801/86C805',
                                              'S3 86C911/86C924',
                                              'S3 86C928',
                                              'S3 Vision/Trio/ViRGE Series',
                                              'Sierra 15064 (Falcon64)',
                                              'SiS 6200 Series',
                                              'Trident 8800',
                                              'Trident 8900/8900B/8900C/9000',
                                              'Trident 8900CL/8900D/9000C',
                                              'Trident 9200/9400/9600 Series',
                                              'Tseng ET3000',
                                              'Tseng ET4000AX',
                                              'Tseng ET4000/W32',
                                              'Tseng ET6000',
                                              'UMC 85C408/85C418',
                                              'Video 7',
                                              'Weitek 5186/5286/P9100');
VAR
  ButNum  : BYTE;
  Loop    : INTEGER;
  Chip    : INTEGER;
  OldMode : INTEGER;
  F       : TEXT;
  St      : STRING[2];
BEGIN
  FErase('MAXVIDEO.CFG');
  ShutDownText; HideMouse; HideCursor;
  OutTextXY(1,12,15,0,Center('One Moment Please While We Detect Your Video Card.',80));
  DELAY(3000);
  FG_InitPM;
  OldMode := FG_GetMode;
  FG_SetMode(19);
  Chip := FG_SvgaInit(0);
  VRAM := FG_Memory;
  FG_SetMode(OldMode);
  FG_Reset;
  FireUpText; HideCursor; HideMouse;
  MemFG := 15;
  MemBG := 1;
  TextBackground_BS(8);
  CLRSCR;
  OutTextXY(1,1,15,1,Center(ProgramName + ' Setup',80));
  OutTextXY(1,25,15,1,PadRight(' Running Under ' + OsStr,' ',80));
  Show_Mem;
  ShowMouse;
  NewWin;
  DrawWindow(10,3,70,22,'Select Video Chipset Support');
  OutTextXY(12,5,14,0,PadRight(' Type ##   Chipset Brand/Model/Series',' ',57));
  NewPickList(12,6,13,54);
  FOR Loop := 1 TO 70 DO AddToPickList(PadRight(IntToStr(Loop),' ',8)+'- '+ChipSet[Loop]);
  IF Chip IN [1..70] THEN ResetPickList(Chip) ELSE ResetPickList(1);
  SetupPickList;
  SystemButton(12,20,31,1,FALSE,TRUE,'Select');
  Show_Mem; ShowMouse;
  REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum > 2;
  VCARD := PickInfo.Current;
  ASSIGN(F,'MAXVIDEO.CFG');
  REWRITE(F);
  WRITELN(F,IntToStr(PickInfo.Current));
  WRITELN(F,'-----------------------------------------------------');
  WRITELN(F,'Chipset Code - Chipset Brand/Model/Series');
  WRITELN(F,'-----------------------------------------------------');
  FOR Loop := 1 TO 70 DO WRITELN(F,PadRight(IntToStr(Loop),' ',13) + '- ' + ChipSet[Loop]);
  CLOSE(F);
  KillWindow;
END;

PROCEDURE CleanUpWorkDir;
VAR
  WorkFile : STRING[12];
  DirInfo  : SEARCHREC;
BEGIN
  CHDIR(WorkDir);
  FINDFIRST('*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WorkFile := AllCaps(DirInfo.Name);
    FErase(WorkFile);
    FINDNEXT(DirInfo);
  END;
  CHDIR(HomeDir + '\RESOURCE');
END;

PROCEDURE ConvertPKGs;
VAR
  WorkFile : STRING[12];
  DirInfo  : SEARCHREC;
  ArcType  : BYTE;
FUNCTION LocateFile(FName : STRING) : STRING;
VAR
  F : STRING;
BEGIN
  IF NOT FExist(FName) THEN BEGIN
    F := FSearch(FName,GetEnv('PATH'));
    LocateFile := FExpand(F);
    EXIT;
  END ELSE LocateFile := FName;
END;
BEGIN
  ArcType := 0;
  ArcPath := LocateFile('PKUNZIP.EXE');
  IF POS('PKUNZIP.EXE',ArcPath) > 0 THEN ArcType := 1;
  IF ArcType = 0 THEN BEGIN
    ArcPath := LocateFile('LHA.EXE');
    IF POS('LHA.EXE',ArcPath) > 0 THEN ArcType := 2;
  END;
  IF ArcType = 0 THEN BEGIN
    ArcPath := LocateFile('ARJ.EXE');
    IF POS('ARJ.EXE',ArcPath) > 0 THEN ArcType := 3;
  END;
  IF ArcType = 0 THEN BEGIN
    ArcPath := LocateFile('RAR.EXE');
    IF POS('RAR.EXE',ArcPath) > 0 THEN ArcType := 4;
  END;
  IF ArcType = 0 THEN BEGIN
    ArcType := 1;
    ArcPath := FixPath(HomeDir);
  END ELSE ArcPath := GetFilePath(ArcPath);
  NewWin;
  DrawWindow(8,10,72,16,'Resource PKG Conversion');
  OutTextXY(10,12,11,1,'Path To Archivers:');
  SystemField(30,12,5,40,ArcPath);
  SystemButton(63,14,24,1,FALSE,TRUE,'Okay');
  Show_Mem; ShowMouse; ShowCursor;
  REPEAT UNTIL MouseHandler(TRUE) <> 0;
  HideCursor;
  ArcPath := StripBoth(FixPath(Fields[1].Text),' ');
  KillWindow;
  WorkDir := HomeDir + '\$$WORK$$';
  MakeDir(WorkDir);
  CHDIR(HomeDir + '\RESOURCE');
  FINDFIRST('*.*',Anyfile - Directory - VolumeID,DirInfo);
  WHILE DOSERROR = 0 DO BEGIN
    WorkFile := AllCaps(DirInfo.Name);
    ArcType  := GetArcType(WorkFile);
    IF ArcType IN [1,2,3,7] THEN BEGIN
      CopyFile(WorkFile,WorkDir + '\' + WorkFile);
      CHDIR(WorkDir);
      NewWin;
      DrawWindow(20,10,60,13,'Processing PKG Files');
      OutTextXY(22,12,15,1,'Extracting: ' + WorkFile);
      CASE ArcType OF
  {???} 0 :{DoCustomUnArc(WorkFile)};
  {Zip} 1 : Execute(ArcPath + 'PKUNZIP.EXE','-) -O ' + WorkFile + ' > NUL');
  {Arj} 2 : Execute(ArcPath + 'ARJ.EXE','E ' + WorkFile + ' > NUL');
  {Lzh} 3 : Execute(ArcPath + 'LHA.EXE','E ' + WorkFile + ' > NUL');
  {Zoo} 4 :{DoCustomUnArc(WorkFile)};
  {Arc} 5 :{DoCustomUnArc(WorkFile)};
  {Pak} 6 :{DoCustomUnArc(WorkFile)};
  {Rar} 7 : Execute(ArcPath + 'RAR.EXE','E -C- -O+ -Y ' + WorkFile + ' > NUL');
      END;
      FErase(WorkFile);
      KillWindow;
      Execute(HomeDir + '\MAXCOMP.EXE',WorkFile + ' C');
      HideCursor;
      CopyFile(WorkFile,HomeDir + '\RESOURCE\' + WorkFile);
      CleanUpWorkDir;
      CHDIR(HomeDir + '\RESOURCE');
    END ELSE BEGIN
      NewWin;
      DrawWindow(20,5,60,17,'PKG File Error!');
      OutTextXY(22,7,14,1, 'Cannot unpack the file: ' + WorkFile);
      OutTextXY(21,8,9,1,PadRight(#196,#196,39));
      OutTextXY(22,9,11,1, 'This archive is obviously stored in a');
      OutTextXY(22,10,11,1,'format unknown to this program...What');
      OutTextXY(22,11,11,1,'you should do in this case is convert');
      OutTextXY(22,12,11,1,'this archive to a ZIP, LZH, ARJ, or a');
      OutTextXY(22,13,11,1,'RAR archive and then run this program');
      OutTextXY(22,14,11,1,'again...');
      OutTextXY(21,15,9,1,PadRight(#196,#196,39));
      OutTextXY(28,16,15,1,'Press Any Key To Continue');
      WRITE(^G);
      READKEY;
      KillWindow;
    END;
    FINDNEXT(DirInfo);
  END;
  CleanUpWorkDir;
  RMDIR(WorkDir);
  CHDIR(HomeDir);
END;

BEGIN
  GETDIR(0,OldDir);
  ProgramName := 'MAXterm v2.11';
  KillIt      := TRUE;
  UpdatePKGs  := FALSE;
  VRAM        := 1024;
  VCARD       := 0;
  IF (POS('A:\',OldDir) > 0) OR (POS('B:\',OldDir) > 0) THEN KillIt := FALSE;
  SetUpScreen;
  UserNote;
  GetHomeDir;
  ExtractFiles;
  DoModemSetup;
  DoMiscSettings;
  DoSoundCard;
  DoVideoSetup;
  FErase('MODEM.LIB');
  IF UpdatePKGs THEN ConvertPKGs;
  CHDIR(OldDir);
  ReadTextFile(HomeDir + '\MAXTERM.DOC');
  ShutDownText; HideMouse;
  IF KillIt THEN BEGIN
    FErase('FILE_ID.DIZ');
    FErase('MXT.RES');
    FErase('SETUP.DOC');
    FErase('SETUP.EXE');
    FErase('MAXPHONE.DIR');
    FErase('MAXPHONE.ORG');
    FErase(NewPkg);
  END;
  CHDIR(HomeDir);
  FErase('UPDATE.FLG');
  DoRainbow(HomeDir + '\');
  FErase('CAM50.FNT');
  IF VRAM < 1024 THEN BEGIN
    CLRSCR;
    OutTextXY(1,1,12,0,'Keep in mind that your video card only has ' + IntToStr(VRAM) + 'K bytes of video RAM, which');
    OutTextXY(1,2,12,0,'means certain features are not going to work correctly. You would be much');
    OutTextXY(1,3,12,0,'better off buying a new video card with at least 1 meg of video RAM. This');
    OutTextXY(1,4,12,0,'isn''t just a suggestion so you can run MAX SVGA programs correctly, it''ll');
    OutTextXY(1,5,12,0,'improve the performance of Windows, OS/2, and any other graphics program!');
    OutTextXY(1,7,4,0, 'Press Any Key To Continue...');
    WRITE(^G);
    READKEY;
  END;
  IF VCARD = 1 THEN BEGIN
    CLRSCR;
    OutTextXY(1,1,13,0,'You have selected generic VESA video support, keep in mind that this is a');
    OutTextXY(1,2,13,0,'very slow method of video support. If this setup program selected VESA by');
    OutTextXY(1,3,13,0,'default, chances are that you own an obsolete video card. If VESA support');
    OutTextXY(1,4,13,0,'was manually selected, you should run the setup program again, and let it');
    OutTextXY(1,5,13,0,'detect your video card for you instead.');
    OutTextXY(1,7,5,0, 'Press Any Key To Continue...');
    WRITE(^G);
    READKEY;
  END;
  CLRSCR;
  OutTextXY(1,1,2,0, 'Be sure you read MAXTERM.DOC in it''s entirety, especially the Q&A section!');
  OutTextXY(1,3,10,0,'Now type MAXTERM and press <ENTER> for a real treat...');
  GOTOXY(1,5);
END.
