{$I DEFINES.INC}
PROGRAM SCRIPT;

USES MYCRT,TERMVARS,GUI_UNIT,GUI_ICON,GUI_UTIL,MOD_UNIT,_SCRIPT,FGPCX;

VAR
  FSB    : FILE OF SB_Information;
  Txt    : TEXT;
  Temp   : STRING;
  ButNum : BYTE;

PROCEDURE DoRemoteScreen(P : STRING);
VAR
  Cmd  : STRING[12];
  Go   : BOOLEAN;
  Loop : BYTE;
BEGIN
  Cmd := '';
  Go  := FALSE;
  P   := StripBoth(P,')');
  P   := StripBoth(P,#39);
  P   := StripBoth(P,#255);
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN Go := TRUE;
    IF (Go) AND (P[Loop] <> #39) THEN Cmd := Cmd + P[Loop];
  END;
  ShowRemoteScreen(Cmd);
  ScrStr := '';
END;

FUNCTION GuiReadKey : CHAR;
VAR
  ButNum : BYTE;
BEGIN
  REPEAT
    ButNum := MouseHandler(TRUE);
    IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) OR (NFields <> 0) THEN BEGIN
      IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) THEN BEGIN
        IF ButNum > 2 THEN MC := CHR(Buttons^[ButNum].Return) ELSE MC := #255;
      END ELSE BEGIN
        IF ButNum <> 0 THEN MC := CHR(Buttons^[ButNum].Return) ELSE MC := #255;
      END;
    END ELSE BEGIN
      IF ButNum <> 0 THEN MC := CHR(Buttons^[ButNum].Return);
    END;
  UNTIL MC <> #255;
  IF (ButNum <> 0) AND (Buttons^[ButNum].Sound <> #0) THEN BEGIN
    {Add a custom routine here to play sounds with matching button}
    {clicks or keypresses from the keyboard.                      }
    IF (ButNum <> 0) AND (Buttons^[ButNum].Sound <> #0) THEN PlayButtonSound(Buttons^[ButNum].Sound);
  END;
  GuiReadKey := MC;
END;

BEGIN
  SesPath        := FixPath(PARAMSTR(1));
  MsgInfPath     := SesPath;
  IconLib16      := SesPath + 'ICON_LIB.001';
  IconLib30      := SesPath + 'ICON_LIB.002';
  IconLib60      := SesPath + 'ICON_LIB.003';
  ProgramName    := 'MAXscript';
  ProgramVersion := 'v2.11';
  Temp           := StripBoth(AllCaps(PARAMSTR(2)),' ');
  DD.UseSB       := TRUE;
  ShowBanner     := FALSE;
  IF POS('.',Temp) = 0 THEN Temp := Temp + '.MAX';
  CLRSCR;
  OutTextXY(1,1,11,0,ProgramName + ' ' + ProgramVersion);
  OutTextXY(1,2,3,0,Copyright);
  HideCursor;
  GOTOXY(1,4);
  IF (NOT DExist(SesPath)) OR
     (NOT FExist(Temp)) OR
     (NOT FExist(IconLib16)) OR
     (NOT FExist(IconLib30)) OR
     (NOT FExist(IconLib60)) THEN BEGIN
    OutTextXY(1,5,10,0,'Command Syntax:');
    OutTextXY(1,6,2,0,PadRight(#196,#196,15));
    OutTextXY(1,7,11,0,PARAMSTR(0) + ' [Resource Path] [MAX Screen File To View]');
    OutTextXY(1,9,3,0,PARAMSTR(0) + ' C:\MAXTERM\SESSION\ C:\BBS\MAX\SCREEN.MAX');
    GOTOXY(1,15);
    WRITE(^G);
    ShowCursor;
    HALT;
  END;
  IF MEMAVAIL < 100000 THEN BEGIN
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('You only have ' + IntToStr(MEMAVAIL) + ' Bytes of free conventional memory');
    WRITELN('after this program loads. This program cannot run with');
    WRITELN('less than 100K of available conventional memory...');
    WRITELN;
    WRITE(^G);
    ShowCursor;
    HALT;
  END;
  ASSIGN(FSB,'MAXSOUND.CFG');
  IF NOT FExist('MAXSOUND.CFG') THEN BEGIN
    REWRITE(FSB);
    WITH SB DO BEGIN
      IRQ     := '2';
      DMA     := '1';
      Address := '220';
    END;
    WRITE(FSB,SB);
    CLOSE(FSB);
  END;
  RESET(FSB);
  READ(FSB,SB);
  CLOSE(FSB);
  IF NOT FireUpGui THEN BEGIN
    WRITELN('CRITICAL ERROR!!!');
    WRITELN('-----------------');
    WRITELN('This program could not detect your video card chipset, nor could');
    WRITELN('it detect an on-board VESA video BIOS...It is possible that your');
    WRITELN('video card is not capable of running this program, you will need');
    WRITELN('at least a 1 Meg VESA compatible video card first...Refer to the');
    WRITELN('file MAXTERM.DOC for more information...');
    WRITE(^G);
    ShowCursor;
    HALT;
  END;
  HideMouse;
  IF FExist(SesPath + 'BACKDROP.MAX') THEN BEGIN
    ShowRemoteScreen('BACKDROP.MAX');
    FrameHigh(540,419,630,450);
    PutIcon30(541,420,97,0);
    PutIcon30(571,420,98,0);
    PutIcon30(600,420,99,0);
  END;
  ASSIGN(Txt,Temp);
  RESET(Txt);
  WHILE NOT EOF(Txt) DO BEGIN
    READLN(Txt,ScrStr);
    ScrStr := StripBoth(ScrStr,' ');
    ScrStr := StripBoth(ScrStr,#2);
    IF (POS('SHOW_REMOTE_SCREEN(',AllCaps(ScrStr)) = 1) OR
       (POS(#255#126#251,ScrStr) = 1) THEN DoRemoteScreen(ScrStr);
    IF POS(#255#126,ScrStr) = 1 THEN CheckControlLine(ScrStr) ELSE
    IF POS(#255#125,ScrStr) = 1 THEN CheckColorCommand(ScrStr) ELSE
    IF ScrStr <> '' THEN CheckScriptLine(ScrStr);
    ScrStr := '';
  END;
  CLOSE(Txt);
  IF NOT TextEditor.Active THEN BEGIN
    ShowMouse;
    GuiReadKey;
   {IF (NOT TextReader.Active) AND (NOT PickInfo.Active) THEN BEGIN
      IF NButtons > 0 THEN REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0 ELSE READKEY;
    END ELSE BEGIN
      REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum > 2;
    END;}
  END;
  IF ModPlaying THEN ModShutDown;
  ShutDownGui;
  CLRSCR;
  OutTextXY(1,1,11,0,ProgramName + ' ' + ProgramVersion);
  OutTextXY(1,2,3,0,Copyright);
  HideCursor;
  GOTOXY(1,4);
  ShowCursor;
END.
