{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT SCR100;

INTERFACE

TYPE Max_Data = RECORD               {The MAX data record for conversions   }
     Text     : STRING;              {Text string for the current record    }
     Code     : BYTE;                {MAXcontrol/MAXcolor command code      }
     VType    : BYTE;                {126-MAXcontrol, 125-MAXcolor          }
     V        : ARRAY[1..10] OF INTEGER;{Array of command variables         }
     END;

VAR
  _Max        : Max_Data;      {Record variable for the Max_Data record     }
  ScrStr      : STRING;
  LastFill    : BYTE;

PROCEDURE CheckControlLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXscript commands.}
PROCEDURE CheckScriptLine(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcontrol commands.}
PROCEDURE CheckColorCommand(Command : STRING);
{^ This procedure is used to check a text string to see if it matches one
   of the predefined MAXcolor commands.}

IMPLEMENTATION

USES GUI_UTIL;

PROCEDURE Do_ADDTO_PICKLIST(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  WITH _Max DO BEGIN
    Text  := P;
    Code  := 149;
    VType := 126;
  END;
END;

PROCEDURE Do_ANIMATE_ICON(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 255;
  _Max.V[7] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 255 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF (_Max.V[6] > 3) OR (_Max.V[6] < 1) THEN _Max.V[6] := 1;
            Temp := '';
          END;
      7 : IF _Max.V[7] = 255 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            IF _Max.V[7] > 99 THEN _Max.V[7] := 99;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    Code  := 173;
    VType := 126;
    CASE V[6] OF
      1 : BEGIN
            V[9]  := 15;
            V[10] := 15;
          END;
      2 : BEGIN
            V[9]  := 29;
            V[10] := 29;
          END;
      3 : BEGIN
            V[9]  := 59;
            V[10] := 59;
          END;
    END;
  END;
END;

PROCEDURE Do_SQUARE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp   := '';
  PCount := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : Code := 159;
      2 : Code := 144;
      3 : Code := 145;
      4 : Code := 162;
      5 : Code := 147;
      6 : Code := 146;
      7 : Code := 132;
      8 : BEGIN
            Code := 252;
            IF V[3] > 77 THEN V[3] := 77;
            IF V[4] > 25 THEN V[4] := 25;
          END;
      9 : Code := 171;
      10: Code := 174;
      11: BEGIN
            Code := 186;
            IF V[3] > 79 THEN V[3] := 79;
            IF V[4] > 25 THEN V[4] := 25;
          END;
    END;
    VType := 126;
  END;
END;

PROCEDURE Do_CHANGE_FIELD(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  WITH _Max DO BEGIN
    Code  := 152;
    VType := 126;
    V[1]  := StrToInt(P);
  END;
END;

PROCEDURE Do_CLEAR_SCREEN(P : STRING);
BEGIN
  P := StripBoth(P,#39);
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 161;
    VType := 126;
    V[1]  := StrToInt(P);
  END;
END;

PROCEDURE Do_DRAW_BUTTON(P : STRING);
VAR
  Loop    : BYTE;
  PCount  : BYTE;
  UseIcon : BOOLEAN;
  DoAll   : BOOLEAN;
  Temp    : STRING;
  Scrap   : CHAR;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  _Max.V[5] := 0;
  _Max.V[6] := 1000;
  UseIcon   := FALSE;
  DoAll     := FALSE;
  Scrap     := '!';
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF Scrap = '!' THEN BEGIN
            IF Temp = '1' THEN BEGIN
              UseIcon := TRUE;
              _Max.V[5] := 1;
            END;
            Scrap := '.';
            Temp  := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            IF _Max.V[6] > 99 THEN _Max.V[6] := 99;
            Temp := ''
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO BEGIN
    Code  := 130;
    VType := 126;
  END;
END;

PROCEDURE Do_DRAW_CIRCLE(P : STRING);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    Code  := 158;
    VType := 126;
  END;
END;

PROCEDURE Do_ELLIPSE(P : STRING ; WhichOne : BYTE);
VAR
  PCount : BYTE;
  Loop   : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 1000;
  _Max.V[6] := 1000;
  _Max.V[7] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 1000 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
      6 : IF _Max.V[6] = 1000 THEN BEGIN
            _Max.V[6] := StrToInt(Temp);
            Temp := '';
          END;
      7 : IF _Max.V[7] = 1000 THEN BEGIN
            _Max.V[7] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : Code := 166;
      2 : Code := 172;
      3 : Code := 175;
      4 : Code := 178;
      5 : Code := 179;
    END;
    VType := 126;
    IF WhichOne = 5 THEN CASE V[7] OF
      1 : BEGIN
            V[8] := 15;
            V[9] := 15;
          END;
      2 : BEGIN
            V[8] := 29;
            V[9] := 29;
          END;
      3 : BEGIN
            V[8] := 59;
            V[9] := 59;
          END;
    END;
  END;
END;

PROCEDURE Do_DRAW_WINDOW(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO BEGIN
    Code  := 128;
    VType := 126;
  END;
END;

PROCEDURE Do_END_SCREEN;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 254;
    VType := 126;
  END;
END;

PROCEDURE Do_ENTRY_FIELD(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 255;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 255 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO BEGIN
    Code  := 131;
    VType := 126;
  END;
END;

PROCEDURE Do_FIELD_TEXT(P : STRING ; WhichOne : BYTE);
VAR
  F      : INTEGER;
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
  Txt    : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            F := _Max.V[1];
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  WITH _Max DO BEGIN
    VType := 126;
    CASE WhichOne OF
      1 : Code := 248;
      2 : Code := 183;
    END;
  END;
END;

PROCEDURE Do_GET_EDITOR_TEXT;
VAR
  Loop  : BYTE;
  TFile : TEXT;
  TStr  : String[80];
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 249;
    VType := 126;
  END;
END;

PROCEDURE Do_GET_FIELD_DATA;
VAR
  Loop : BYTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 250;
    VType := 126;
  END;
END;

PROCEDURE Do_GET_PICK_INFO;
VAR
  Loop : BYTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 247;
    VType := 126;
  END;
END;

PROCEDURE Do_LOAD_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := GetFileName(StripBoth(P,#39));
  WITH _Max DO BEGIN
    Text  := P;
    Code  := 167;
    VType := 126;
  END;
END;

PROCEDURE Do_MOUSE_MASK(P : STRING);
VAR
  M : WORD;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  M := StrToInt(P);
  IF M > 18 THEN M := 65535;
  WITH _Max DO BEGIN
    Code  := 141;
    VType := 126;
    V[1]  := M;
  END;
END;

PROCEDURE Do_NEW_PICKLIST(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 30 THEN _Max.V[3] := 30;
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            IF _Max.V[4] > 80 THEN _Max.V[4] := 80;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    Code  := 168;
    VType := 126;
  END;
END;

PROCEDURE Do_NEW_TEXT_EDITOR(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  WITH _Max DO BEGIN
    Code  := 154;
    VType := 126;
    V[1]  := StrToInt(P);
  END;
END;

PROCEDURE Do_NEW_TEXT_READER(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  WITH _Max DO BEGIN
    Code  := 156;
    VType := 126;
    V[1]  := StrToInt(P);
  END;
END;

PROCEDURE Do_PLAY_SOUND(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := AllCaps(GetFileName(StripBoth(P,#39)));
  WITH _Max DO BEGIN
    Text  := P;
    Code  := 163;
    VType := 126;
  END;
END;

PROCEDURE Do_PUT_IMAGE(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := GetFileName(StripBoth(Temp,#39));
  WITH _Max DO BEGIN
    Code  := 164;
    VType := 126;
  END;
END;

PROCEDURE Do_PUT_ICON(P : STRING ; IconSize : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            IF _Max.V[3] > 99 THEN _Max.V[3] := 99;
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    CASE IconSize OF
      1 : BEGIN
            Code := 138;
            V[4] := 15;
            V[5] := 15;
          END;
      2 : BEGIN
            Code := 137;
            V[4] := 29;
            V[5] := 29;
          END;
      3 : BEGIN
            Code := 136;
            V[4] := 59;
            V[5] := 59;
          END;
    END;
    VType := 126;
  END;
END;

PROCEDURE Do_TRIANGLE(P : STRING ; WhichOne : BYTE);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  WITH _Max DO BEGIN
    CASE WhichOne OF
      1 : BEGIN
            Code := 170;
            V[4] := 14;
            V[5] := 14;
          END;
      2 : Code := 177;
      3 : Code := 165;
    END;
    VType := 126;
  END;
END;

PROCEDURE Do_RESET_PICKLIST(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  P := StripBoth(P,#39);
  WITH _Max DO BEGIN
    Code  := 151;
    VType := 126;
    V[1]  := StrToInt(P);
  END;
END;

PROCEDURE Do_SET_FILL_STYLE(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF (P[Loop] = #44) OR (Loop = LENGTH(P)) THEN INC(PCount);
    IF P[Loop] <> #44 THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  IF _Max.V[1] > 11 THEN _Max.V[1] := 1;
  IF _Max.V[2] > 255 THEN _Max.V[2] := 0;
  WITH _Max DO BEGIN
    Code  := 160;
    VType := 126;
  END;
  LastFill := _Max.V[2];
END;

PROCEDURE Do_STANDARD_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 255 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 4 THEN _Max.V[4] := 3;
  WITH _Max DO BEGIN
    Code  := 142;
    VType := 126;
  END;
END;

PROCEDURE Do_SHADOW_TEXT(P : STRING);
VAR
  Loop   : BYTE;
  PCount : BYTE;
  DoAll  : BOOLEAN;
  Temp   : STRING;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  Temp      := '';
  PCount    := 0;
  DoAll     := FALSE;
  _Max.V[1] := 1000;
  _Max.V[2] := 1000;
  _Max.V[3] := 1000;
  _Max.V[4] := 1000;
  _Max.V[5] := 255;
  FOR Loop := 1 TO LENGTH(P) DO BEGIN
    IF P[Loop] = #39 THEN DoAll := TRUE;
    IF (NOT DoAll) AND (P[Loop] = #44) THEN INC(PCount);
    IF (NOT DoAll) AND (P[Loop] <> #39) AND (P[Loop] <> #44) THEN Temp := Temp + P[Loop];
    IF DoAll THEN Temp := Temp + P[Loop];
    CASE PCount OF
      1 : IF _Max.V[1] = 1000 THEN BEGIN
            _Max.V[1] := StrToInt(Temp);
            Temp := '';
          END;
      2 : IF _Max.V[2] = 1000 THEN BEGIN
            _Max.V[2] := StrToInt(Temp);
            Temp := '';
          END;
      3 : IF _Max.V[3] = 1000 THEN BEGIN
            _Max.V[3] := StrToInt(Temp);
            Temp := '';
          END;
      4 : IF _Max.V[4] = 1000 THEN BEGIN
            _Max.V[4] := StrToInt(Temp);
            Temp := '';
          END;
      5 : IF _Max.V[5] = 255 THEN BEGIN
            _Max.V[5] := StrToInt(Temp);
            Temp := '';
          END;
    END;
  END;
  _Max.Text := StripBoth(Temp,#39);
  IF _Max.V[3] > 255 THEN _Max.V[3] := 0;
  IF _Max.V[4] > 255 THEN _Max.V[4] := 0;
  IF _Max.V[5] > 4 THEN _Max.V[5] := 3;
  WITH _Max DO BEGIN
    Code  := 143;
    VType := 126;
  END;
END;

PROCEDURE Do_RESET_REMOTE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 169;
    VType := 126;
  END;
END;

PROCEDURE Do_SIREN;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 184;
    VType := 126;
  END;
END;

PROCEDURE Do_MAXECUTE(TheFile : STRING);
BEGIN
  WITH _Max DO BEGIN
    Text  := StripBoth(TheFile,#39);
    Code  := 185;
    VType := 126;
  END;
END;

PROCEDURE Do_EDITOR_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  _Max.Text := GetFileName(StripBoth(P,#39));
  WITH _Max DO BEGIN
    Code  := 176;
    VType := 126;
  END;
END;

PROCEDURE Do_HIDE_MOUSE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 139;
    VType := 126;
  END;
END;

PROCEDURE Do_SHOW_MOUSE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 140;
    VType := 126;
  END;
END;

PROCEDURE Do_KILL_WINDOW;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 129;
    VType := 126;
  END;
END;

PROCEDURE Do_LARGE_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 135;
    VType := 126;
  END;
END;

PROCEDURE Do_MEDIUM_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 134;
    VType := 126;
  END;
END;

PROCEDURE Do_SMALL_ICON_LIB(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 133;
    VType := 126;
  END;
END;

PROCEDURE Do_LOAD_FONT(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 148;
    VType := 126;
  END;
END;

PROCEDURE Do_REDRAW_FIELD;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 153;
    VType := 126;
  END;
END;

PROCEDURE Do_RUN_TEXT_EDITOR;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 155;
    VType := 126;
  END;
END;

PROCEDURE Do_SETUP_PICKLIST;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 150;
    VType := 126;
  END;
END;

PROCEDURE Do_SHOW_TEXT_PAGE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 157;
    VType := 126;
  END;
END;

PROCEDURE Do_SHOW_REMOTE_SCREEN(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 251;
    VType := 126;
  END;
END;

PROCEDURE Do_START_SCREEN;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 253;
    VType := 126;
  END;
END;

PROCEDURE Do_START_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Text  := GetFileName(StripBoth(P,#39));
    Code  := 180;
    VType := 126;
  END;
END;

PROCEDURE Do_PUT_TEXT_FILE(P : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  DELETE(P,1,1);
  DELETE(P,LENGTH(P),1);
  WITH _Max DO BEGIN
    Text  := P;
    Code  := 181;
    VType := 126;
  END;
END;

PROCEDURE Do_END_TEXT_FILE;
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
  WITH _Max DO BEGIN
    Code  := 182;
    VType := 126;
  END;
END;

PROCEDURE CheckControlLine(Command : STRING);
VAR
  Code : CHAR;
BEGIN
  Code := Command[3];
  DELETE(Command,1,3);
  IF Command[LENGTH(Command)] = #255 THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    CASE Code OF
      #149 : Do_ADDTO_PICKLIST(Command);
      #173 : Do_ANIMATE_ICON(Command);
      #159 : Do_SQUARE(Command,1);
      #152 : Do_CHANGE_FIELD(Command);
      #161 : Do_CLEAR_SCREEN(Command);
      #171 : Do_SQUARE(Command,9);
      #130 : Do_DRAW_BUTTON(Command);
      #158 : Do_DRAW_CIRCLE(Command);
      #248 : Do_FIELD_TEXT(Command,1);
      #166 : Do_ELLIPSE(Command,1);
      #172 : Do_ELLIPSE(Command,2);
      #132 : Do_SQUARE(Command,7);
      #162 : Do_SQUARE(Command,4);
      #128 : Do_DRAW_WINDOW(Command);
      #176 : Do_EDITOR_FILE(Command);
      #178 : Do_ELLIPSE(Command,4);
      #253 : Do_START_SCREEN;
      #254 : Do_END_SCREEN;
      #131 : Do_ENTRY_FIELD(Command);
      #165 : Do_TRIANGLE(Command,3);
      #175 : Do_ELLIPSE(Command,3);
      #144 : Do_SQUARE(Command,2);
      #145 : Do_SQUARE(Command,3);
      #249 : Do_GET_EDITOR_TEXT;
      #250 : Do_GET_FIELD_DATA;
      #247 : Do_GET_PICK_INFO;
      #139 : Do_HIDE_MOUSE;
      #129 : Do_KILL_WINDOW;
      #135 : Do_LARGE_ICON_LIB(Command);
      #148 : Do_LOAD_FONT(Command);
      #167 : Do_LOAD_TEXT_FILE(Command);
      #147 : Do_SQUARE(Command,5);
      #134 : Do_MEDIUM_ICON_LIB(Command);
      #141 : Do_MOUSE_MASK(Command);
      #168 : Do_NEW_PICKLIST(Command);
      #154 : Do_NEW_TEXT_EDITOR(Command);
      #156 : Do_NEW_TEXT_READER(Command);
      #163 : Do_PLAY_SOUND(Command);
      #164 : Do_PUT_IMAGE(Command);
      #136 : Do_PUT_ICON(Command,3);
      #137 : Do_PUT_ICON(Command,2);
      #138 : Do_PUT_ICON(Command,1);
      #170 : Do_TRIANGLE(Command,1);
      #177 : Do_TRIANGLE(Command,2);
      #146 : Do_SQUARE(Command,6);
      #153 : Do_REDRAW_FIELD;
      #151 : Do_RESET_PICKLIST(Command);
      #169 : Do_RESET_REMOTE;
      #155 : Do_RUN_TEXT_EDITOR;
      #160 : Do_SET_FILL_STYLE(Command);
      #150 : Do_SETUP_PICKLIST;
      #140 : Do_SHOW_MOUSE;
      #157 : Do_SHOW_TEXT_PAGE;
      #133 : Do_SMALL_ICON_LIB(Command);
      #142 : Do_STANDARD_TEXT(Command);
      #143 : Do_SHADOW_TEXT(Command);
      #252 : Do_SQUARE(Command,8);
      #186 : Do_SQUARE(Command,11);
      #251 : Do_SHOW_REMOTE_SCREEN(Command);
      #174 : Do_SQUARE(Command,10);
      #179 : Do_ELLIPSE(Command,5);
      #180 : Do_START_TEXT_FILE(Command);
      #181 : Do_PUT_TEXT_FILE(Command);
      #182 : Do_END_TEXT_FILE;
      #183 : Do_FIELD_TEXT(Command,2);
      #184 : Do_SIREN;
      #185 : Do_MAXECUTE(Command);
    END;
  END;
END;

PROCEDURE CheckScriptLine(Command : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
  Stop : BYTE;
BEGIN
  Temp := '';
  FOR Loop := 1 TO LENGTH(Command) DO BEGIN
    Stop := Loop;
    IF Command[Loop] <> '(' THEN Temp := Temp + UPCASE(Command[Loop]);
    IF Command[Loop] = '(' THEN Break;
  END;
  DELETE(Command,1,Stop);
  IF Command[LENGTH(Command)] = ')' THEN BEGIN
    DELETE(Command,LENGTH(Command),1);
    IF Temp = 'ADDTO_PICKLIST' THEN Do_ADDTO_PICKLIST(Command);
    IF Temp = 'ANIMATE_ICON' THEN Do_ANIMATE_ICON(Command);
    IF Temp = 'BAR' THEN Do_SQUARE(Command,1);
    IF Temp = 'BUTTON_EXTENSION' THEN Do_FIELD_TEXT(Command,2);
    IF Temp = 'CHANGE_FIELD' THEN Do_CHANGE_FIELD(Command);
    IF Temp = 'CLEAR_SCREEN' THEN Do_CLEAR_SCREEN(Command);
    IF Temp = 'CLICK_ZONE' THEN Do_SQUARE(Command,9);
    IF Temp = 'DRAW_BUTTON' THEN Do_DRAW_BUTTON(Command);
    IF Temp = 'DRAW_CIRCLE' THEN Do_DRAW_CIRCLE(Command);
    IF Temp = 'DRAW_ELLIPSE' THEN Do_ELLIPSE(Command,1);
    IF Temp = 'DRAW_BEZIER' THEN Do_ELLIPSE(Command,2);
    IF Temp = 'DRAW_LINE' THEN Do_SQUARE(Command,7);
    IF Temp = 'DRAW_RECTANGLE' THEN Do_SQUARE(Command,4);
    IF Temp = 'DRAW_TRIANGLE' THEN Do_ELLIPSE(Command,4);
    IF Temp = 'DRAW_WINDOW' THEN Do_DRAW_WINDOW(Command);
    IF Temp = 'EDITOR_FILE' THEN Do_EDITOR_FILE(Command);
    IF Temp = 'END_SCREEN' THEN Do_END_SCREEN;
    IF Temp = 'ENTRY_FIELD' THEN Do_ENTRY_FIELD(Command);
    IF Temp = 'FIELD_TEXT' THEN Do_FIELD_TEXT(Command,1);
    IF Temp = 'FLIP_ICON' THEN Do_ELLIPSE(Command,5);
    IF Temp = 'FLOOD_FILL' THEN Do_TRIANGLE(Command,3);
    IF Temp = 'FRAME_HIGH' THEN Do_SQUARE(Command,2);
    IF Temp = 'FRAME_LOW' THEN Do_SQUARE(Command,3);
    IF Temp = 'GET_EDITOR_TEXT' THEN Do_GET_EDITOR_TEXT;
    IF Temp = 'GET_FIELD_DATA' THEN Do_GET_FIELD_DATA;
    IF Temp = 'GET_PICK_INFO' THEN Do_GET_PICK_INFO;
    IF Temp = 'HIDE_MOUSE' THEN Do_HIDE_MOUSE;
    IF Temp = 'KILL_WINDOW' THEN Do_KILL_WINDOW;
    IF Temp = 'LARGE_ICON_LIB' THEN Do_LARGE_ICON_LIB(Command);
    IF Temp = 'LOAD_FONT' THEN Do_LOAD_FONT(Command);
    IF Temp = 'LOAD_TEXT_FILE' THEN Do_LOAD_TEXT_FILE(Command);
    IF Temp = 'LOWERED_BOX' THEN Do_SQUARE(Command,5);
    IF Temp = 'MAXECUTE' THEN Do_MAXECUTE(Command);
    IF Temp = 'MEDIUM_ICON_LIB' THEN Do_MEDIUM_ICON_LIB(Command);
    IF Temp = 'MOUSE_MASK' THEN Do_MOUSE_MASK(Command);
    IF Temp = 'NEW_PICKLIST' THEN Do_NEW_PICKLIST(Command);
    IF Temp = 'NEW_TEXT_EDITOR' THEN Do_NEW_TEXT_EDITOR(Command);
    IF Temp = 'NEW_TEXT_READER' THEN Do_NEW_TEXT_READER(Command);
    IF Temp = 'PIE_SLICE' THEN Do_ELLIPSE(Command,3);
    IF Temp = 'PLAY_SOUND' THEN Do_PLAY_SOUND(Command);
    IF Temp = 'PUT_IMAGE' THEN Do_PUT_IMAGE(Command);
    IF Temp = 'PUT_LARGE_ICON' THEN Do_PUT_ICON(Command,3);
    IF Temp = 'PUT_MEDIUM_ICON' THEN Do_PUT_ICON(Command,2);
    IF Temp = 'PUT_PIXEL' THEN Do_TRIANGLE(Command,2);
    IF Temp = 'PUT_SMALL_ICON' THEN Do_PUT_ICON(Command,1);
    IF Temp = 'RADIO_BUTTON' THEN Do_TRIANGLE(Command,1);
    IF Temp = 'RAISED_BOX' THEN Do_SQUARE(Command,6);
    IF Temp = 'REDRAW_FIELD' THEN Do_REDRAW_FIELD;
    IF Temp = 'RESET_PICKLIST' THEN Do_RESET_PICKLIST(Command);
    IF Temp = 'RESET_REMOTE' THEN Do_RESET_REMOTE;
    IF Temp = 'RUN_TEXT_EDITOR' THEN Do_RUN_TEXT_EDITOR;
    IF Temp = 'SET_FILL_STYLE' THEN Do_SET_FILL_STYLE(Command);
    IF Temp = 'SETUP_PICKLIST' THEN Do_SETUP_PICKLIST;
    IF Temp = 'SHOW_MOUSE' THEN Do_SHOW_MOUSE;
    IF Temp = 'SHOW_TEXT_PAGE' THEN Do_SHOW_TEXT_PAGE;
    IF Temp = 'SMALL_ICON_LIB' THEN Do_SMALL_ICON_LIB(Command);
    IF Temp = 'STANDARD_TEXT' THEN Do_STANDARD_TEXT(Command);
    IF Temp = 'SHADOW_TEXT' THEN Do_SHADOW_TEXT(Command);
    IF Temp = 'SHOW_REMOTE_SCREEN' THEN Do_SHOW_REMOTE_SCREEN(Command);
    IF Temp = 'SIREN' THEN Do_SIREN;
    IF Temp = 'START_SCREEN' THEN Do_START_SCREEN;
    IF Temp = 'START_TEXT_FILE' THEN Do_START_TEXT_FILE(Command);
    IF Temp = 'PUT_TEXT_FILE' THEN Do_PUT_TEXT_FILE(Command);
    IF Temp = 'END_TEXT_FILE' THEN Do_END_TEXT_FILE;
    IF Temp = 'TEXT_VIEW_WINDOW' THEN Do_SQUARE(Command,8);
    IF Temp = 'TEXT_VIEW_PORT' THEN Do_SQUARE(Command,11);
    IF Temp = 'USER_BUTTON' THEN Do_SQUARE(Command,10);
  END;
END;

PROCEDURE CheckColorCommand(Command : STRING);
BEGIN
  FILLCHAR(_Max,SIZEOF(_Max),0);
END;

BEGIN
  ScrStr     := '';
END.
