{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT RAINBOW;

INTERFACE

PROCEDURE DoRainbow(SesPath : STRING);

IMPLEMENTATION

USES FGmain, FGmisc, FGsvga, Gui_Unit;

CONST
  colors : ARRAY [1..24 * 3] OF BYTE = (
    45,45,63, 49,45,63, 54,45,63, 58,45,63, 63,45,63, 63,45,58,
    63,45,54, 63,45,49, 63,45,45, 63,49,45, 63,54,45, 63,58,45,
    63,63,45, 58,63,45, 54,63,45, 49,63,45, 45,63,45, 45,63,49,
    45,63,54, 45,63,58, 45,63,63, 45,58,63, 45,54,63, 45,49,63);

VAR
  RGBvalues : ARRAY [0..2 * 24 * 3 - 1] OF BYTE; {two sets of 24 RGB triplets }
  color, start, xlen, ylen : INTEGER;
  key, aux : BYTE;

PROCEDURE DoRainbow(SesPath : STRING);
BEGIN
  fg_initpm;
  fg_setmode(19);
  fg_svgainit(0);
 {make sure 640x480 256-color mode is available}
  IF (fg_testmode(25,1) <> 1) THEN BEGIN
    fg_setmode(3);
    fg_reset;
    WRITELN('Cannot set 640x480x256 SVGA mode...');
    WRITELN('This program may not run correctly on your system...');
    HALT;
  END;
  fg_setmode(25);
  LoadGemFonts;
  LoadUserFont(SesPath + 'CAM50.FNT');
 {set up two identical sets of the 24 colors in the RGBvalues array }
  MOVE(colors,RGBvalues,24 * 3);
  MOVE(colors,RGBvalues[24 * 3],24 * 3);
 {define the initial values of the 24 colors used in the rainbow }
  fg_setdacs(16,24,RGBvalues);
 {construct a crude image of a rainbow }
  fg_setcolor(0);
  fg_fillpage;

  OutText_XY(180,40,10,4,'MAXterm');
  OutText_XY(15,100,10,4,'Installation Complete!');

  OutText_XY(38,340,14,2,'You have just successfully installed the MAXterm program, and you are now ready to enter the');
  OutText_XY(40,355,14,2,'world of a more sophisticated graphical user interface (GUI) for BBS software! The real beauty');
  OutText_XY(40,370,14,2,'of MAXterm is that it sports all the features normally found in proprietary graphical terminals,');
  OutText_XY(40,385,14,2,'except MAXterm works with any BBS or BBS Door, and no special operating system is required!!');

  OutText_XY(150,410,10,2,'Help us spread the word about the MAX Graphics interface!');
  OutText_XY(157,425,10,2,'The smarter choice for online graphics and digital sound!');

  fg_setclip(0,639,0,300);
  fg_move(320,300);
  xlen := 240;
  ylen := 120;
  FOR color := 16 TO 39 DO BEGIN
    fg_setcolor(color);
    fg_ellipsef(xlen,ylen);
    DEC(xlen,4);
    DEC(ylen,3);
  END;
  fg_setcolor(0);
  fg_ellipsef(xlen,ylen);
  fg_setclip(0,639,0,479);
  start := 0;
  REPEAT
    start := (start + 3) MOD 72;
    fg_setdacs(16,24,RGBvalues[start]);
    fg_waitfor(1);
    fg_intkey(key,aux);
  UNTIL (key <> 0);
  fg_setmode(3);
  fg_reset;
END;

END.
