{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
Unit PORTUNIT;

INTERFACE

FUNCTION  InitComport : BOOLEAN;
PROCEDURE DeInitComport;
FUNCTION  Carrier : BOOLEAN;
FUNCTION  DataAvailable : BOOLEAN;
PROCEDURE SendStr(S : STRING);
PROCEDURE SendChar(C : CHAR);
PROCEDURE ModemCommand(Cmd : STRING);
FUNCTION  ReadChar : CHAR;
PROCEDURE PurgeInput;
PROCEDURE PurgeOutput;
PROCEDURE ClearModem;
PROCEDURE HangUp;
PROCEDURE BlockWritePort(VAR Block; BlockLen : WORD; VAR BytesWritten : WORD);
PROCEDURE BlockReadPort(VAR Block; ExpectedLen : WORD; VAR ReceivedLen : WORD);
FUNCTION  GotAck : BOOLEAN;

IMPLEMENTATION

USES Dos,Gui_Util,ApVars,ApMisc,ApTimer,ApPort,
     ApUart,ApCom,ApAbsPcl,ApFossil,ApDigi14;

FUNCTION InitComport : BOOLEAN;
VAR
  BaseAddr : WORD;
  NewAddr  : WORD;
  TVector  : ARRAY[0..15] OF BYTE;
BEGIN
  CASE CommDef.Device OF
    1 : ActivateApUart;
    2 : BEGIN
          IF CommDef.Baud > 38400 THEN UseExtBaudCodes := TRUE;
          DriverIsBnu := CommDef.UsingBNU;
          ActivateApFossil;
          DefFossilOptions := DefFossilOptions OR ptBufferGetChar;
        END;
    3 : BEGIN
          ActivateApDigi14;
          DefDigi14Options := DefDigi14Options OR ptBufferGetChar;
        END;
  END;
  IF CommDef.Device = 1 THEN BEGIN
    TVector[0]  := 0;   TVector[1]  := $9;  TVector[2]  := $A;  TVector[3]  := $B;
    TVector[4]  := $C;  TVector[5]  := $D;  TVector[6]  := $E;  TVector[7]  := $F;
    TVector[8]  := $70; TVector[9]  := $71; TVector[10] := $72; TVector[11] := $73;
    TVector[12] := $74; TVector[13] := $75; TVector[14] := $76; TVector[15] := $77;
    NewAddr := StrToInt('$'+CommDef.PortAddr);
    CASE CommDef.Port OF
      1 : SetUart(COM1,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      2 : SetUart(COM2,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      3 : SetUart(COM3,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      4 : SetUart(COM4,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      5 : SetUart(COM5,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      6 : SetUart(COM6,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      7 : SetUart(COM7,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
      8 : SetUart(COM8,NewAddr,CommDef.IRQ,TVector[CommDef.IRQ]);
    END;
  END;
  CASE CommDef.Port OF
    1 : InitPort(BBSport,COM1,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    2 : InitPort(BBSport,COM2,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    3 : InitPort(BBSport,COM3,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    4 : InitPort(BBSport,COM4,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    5 : InitPort(BBSport,COM5,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    6 : InitPort(BBSport,COM6,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    7 : InitPort(BBSport,COM7,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
    8 : InitPort(BBSport,COM8,CommDef.Baud,NoParity,8,1,CommDef.In_Buffer,CommDef.Out_Buffer,DefPortOptions);
  END;
  IF AsyncStatus = ecOk THEN BEGIN
    PtOptionsOff(BBSPort,PtRestoreOnClose OR PtDropModemOnClose);
    BaseAddr := GetBaseAddr(BBSPort);
    IF ClassifyUart(BaseAddr,TRUE) = U16550A THEN SetFifoBuffering(BaseAddr,TRUE,14);
    IF CommDef.HwFlow THEN
      HwFlowEnable(BBSPort,TRUNC(CommDef.In_Buffer * 0.9),TRUNC(CommDef.In_Buffer * 0.1),HfUseRTS OR HfRequireCTS)
    ELSE
      SwFlowEnable(BBSPort,Trunc(CommDef.In_Buffer * 0.75),Trunc(CommDef.In_Buffer * 0.25));
   {SetDTR(BBSPort,True);
    SetRTS(BBSPort,True);}
    InitComport := TRUE;
  END ELSE InitComport := FALSE;
END;

PROCEDURE DeInitComport;
BEGIN
  DrainOutBuffer(BBSport,Secs2Tics(60));
  DonePort(BBSPort);
END;

FUNCTION Carrier : BOOLEAN;
BEGIN
  IF NOT CheckDCD(BBSport) THEN Carrier := FALSE ELSE Carrier := TRUE;
END;

FUNCTION DataAvailable : BOOLEAN;
BEGIN
  IF CharReady(BBSport) THEN DataAvailable := TRUE ELSE DataAvailable := FALSE;
END;

PROCEDURE SendStr(S : STRING);
BEGIN
 {PutStringTimeOut(BBSport,S,CommDef.Comm_Delay);}
  PutString(BBSport,S);
END;

PROCEDURE SendChar(C : CHAR);
BEGIN
  PutChar(BBSport,C);
END;

PROCEDURE ModemCommand(Cmd : STRING);
VAR
  S : STRING;
  A : BYTE;
BEGIN
  ClearModem;
  ModemResult := '';
  S           := '';
  A           := 0;
  SendStr(Cmd + #13);
  REPEAT
    INC(A);
    DELAY(CommDef.Command_Delay * 4);
  UNTIL (CharReady(BBSport)) OR (A = 5);
  IF CharReady(BBSport) THEN BEGIN
    REPEAT S := S + ReadChar UNTIL NOT CharReady(BBSport);
    DELETE(S,1,LENGTH(Cmd));
    FOR A := 1 TO LENGTH(S) DO BEGIN
      IF (S[A] <> #10) AND (S[A] <> #13) THEN ModemResult := ModemResult + S[A];
    END;
  END;
END;

FUNCTION ReadChar : CHAR;
VAR
  C : CHAR;
BEGIN
  C := #0;
  GetChar(BBSport,C);
  ReadChar := C;
END;

PROCEDURE PurgeInput;
BEGIN
  FlushInBuffer(BBSport);
END;

PROCEDURE PurgeOutput;
BEGIN
  FlushOutBuffer(BBSport);
END;

PROCEDURE ClearModem;
BEGIN
  FlushInBuffer(BBSport);
  FlushOutBuffer(BBSport);
  ModemResult := '';
END;

PROCEDURE HangUp;
VAR
  Count : BYTE;
BEGIN
  ClearModem;
  SetDTR(BBSPort,FALSE);
  DELAY(1000);
  SetDTR(BBSPort,TRUE);
  IF CheckDCD(BBSport) THEN BEGIN
    ClearModem;
    DELAY(1000);
    ModemResult := 'ERROR';
    SendChar('+'); SendChar('+'); SendChar('+');
    REPEAT
      INC(Count);
      DELAY(CommDef.Command_Delay * 2);
    UNTIL (CharReady(BBSport)) OR (Count = 5);
    IF CharReady(BBSport) THEN BEGIN
      ModemResult := '';
      REPEAT ModemResult := ModemResult + ReadChar UNTIL NOT CharReady(BBSport);
      ModemCommand(Modem.OnHook);
      DELAY(CommDef.Command_Delay * 2);
      ModemResult := 'NO CARRIER';
    END;
  END;
END;

PROCEDURE BlockWritePort(VAR Block; BlockLen : WORD; VAR BytesWritten : WORD);
TYPE CharArray = ARRAY[0..MaxInt] OF CHAR;
VAR
  X : WORD;
BEGIN
  BytesWritten := 0;
  X            := 0;
  IF (BlockLen = 0) OR (NOT CheckDCD(BBSport)) THEN EXIT;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    PutChar(BBSport,CharArray(Block)[X]);
    INC(X);
  UNTIL (X = BlockLen) OR (TimerExpired(AckTimer));
  BytesWritten := X;
END;

PROCEDURE BlockReadPort(VAR Block; ExpectedLen : WORD; VAR ReceivedLen : WORD);
TYPE CharArray = ARRAY[0..MaxInt] OF CHAR;
VAR
  Finished : BOOLEAN;
  Cnt      : WORD;
  Ch       : CHAR;
BEGIN
  ReceivedLen := 0;
  Cnt         := 0;
  Finished    := FALSE;
  IF (ExpectedLen = 0) OR (NOT CheckDCD(BBSport)) THEN EXIT;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    IF NOT CharReady(BBSport) THEN TimeSlice ELSE BEGIN
      GetChar(BBSport,Ch);
      CharArray(Block)[Cnt] := Ch;
      INC(Cnt);
      IF (ExpectedLen <> 0) AND (Cnt >= ExpectedLen) THEN Finished := TRUE;
    END;
  UNTIL (Finished) OR (TimerExpired(AckTimer));
  ReceivedLen := Cnt;
END;

FUNCTION GotAck : BOOLEAN;
VAR
  Ch : CHAR;
BEGIN
  Ch     := #0;
  GotAck := FALSE;
  NewTimer(AckTimer,ProtoDelay);
  REPEAT
    IF CharReady(BBSport) THEN GetChar(BBSport,Ch) ELSE BEGIN
      TimeSlice;
      IF NOT CheckDCD(BBSport) THEN EXIT;
    END;
  UNTIL (Ch IN [#6,#21,#24]) OR (TimerExpired(AckTimer));
  IF Ch = #6 THEN GotAck := TRUE ELSE
  IF Ch = #24 THEN BEGIN
    Cancelled := TRUE;
    WeAbort   := TRUE;
  END;
END;

END.
