{***********************************************************************
                        Example to interface the
                   PKWARE Data Compression Library (TM)
                                  with
                              Turbo Pascal
           Copyright 1990-91, By PKWARE Inc.  All Rights Reserved.
 ***********************************************************************}

UNIT PK_COMP;
{$I-,S+}
{$M 8192,0,655360}
{$L IMPLODE.OBJ}

INTERFACE

CONST
  Compress   = 1;
  Decompress = 0;

FUNCTION PK_File(InFile,OutFile : STRING ; TheMode : BYTE) : BOOLEAN;

IMPLEMENTATION

USES DOS;

CONST
  CMP_BINARY = 0;
  CMP_ASCII  = 1;

TYPE
  BuffType = PACKED ARRAY [1..35256] OF CHAR;
  IntFunc  = FUNCTION(VAR Buff : BuffType; VAR bSize : WORD) : WORD;

VAR
  DictionarySize  : WORD;
  CompressionType : WORD;
  FromFile        : FILE;
  ToFile          : FILE;
  Buffer          : Bufftype;
  Result          : INTEGER;
  Exploding       : INTEGER;
  OrigFile        : SEARCHREC;

FUNCTION Implode(READ : IntFunc;
                 WRITE : IntFunc;
                 VAR Buf : BuffType;
                 VAR Ctype : WORD;
                 VAR bSize : WORD) : INTEGER; Far; EXTERNAL;

FUNCTION Explode(READ : IntFunc;
                 WRITE : IntFunc;
                 VAR Buf : BuffType) : INTEGER; Far; EXTERNAL;

FUNCTION ReadData(VAR Buffer : BuffType; VAR BufferSize : WORD) : WORD; far;
VAR BytesRead : WORD;
BEGIN
   BLOCKREAD(FromFile, Buffer, BufferSize, BytesRead);
   ReadData := BytesRead;
END;

FUNCTION WriteData(VAR Buffer : BuffType; VAR BytesRead : WORD) : WORD; far;
VAR byteswritten : WORD;
BEGIN
  BLOCKWRITE(ToFile, Buffer, BytesRead, BytesWritten);
  WriteData := BytesWritten;
END;

FUNCTION PK_File(InFile,OutFile : STRING ; TheMode : BYTE) : BOOLEAN;
BEGIN
  PK_File := TRUE;
  IF TheMode = Compress THEN BEGIN
    ASSIGN(FromFile,InFile); { Open input file        }
    RESET(FromFile,1);
    ASSIGN(ToFile,OutFile);  { Create output file     }
    REWRITE(ToFile,1);
    DictionarySize  := 4096;
    CompressionType := CMP_BINARY;
    Result          := Implode(ReadData,WriteData,Buffer,CompressionType,DictionarySize);
    CLOSE(FromFile);
    CLOSE(ToFile);
    IF Result <> 0 THEN PK_File := FALSE;
  END ELSE BEGIN
    ASSIGN(FromFile,InFile); { Open input file        }
    RESET(FromFile,1);
    ASSIGN(ToFile,OutFile);  { Create output file     }
    REWRITE(ToFile,1);
    Result := Explode(ReadData, WriteData, Buffer);
    CLOSE(FromFile);
    CLOSE(ToFile);
    IF Result <> 0 THEN PK_File := FALSE;
  END;
END;

END.
