{$I DEFINES.INC}
UNIT MXMODEM2;

INTERFACE

PROCEDURE SendMaxModem;
PROCEDURE ReceiveMaxModem;

IMPLEMENTATION

USES MYCRT,GUI_UNIT,GUI_UTIL,FGMAIN,CRCUNIT,PORTUNIT,APVARS,APTIMER;

VAR
  OldBack  : BYTE;
  LastStat : STRING[40];

{}
PROCEDURE ClearProgress;
BEGIN
  PickText(7,466,1,'');
END;
{}
PROCEDURE UpdateStatus(S : STRING);
BEGIN
  IF S = LastStat THEN EXIT;
  FG_SetColor(C.BoxBack);
  FG_Rect(7,246,446,459);
  ShadowText(10,449,14,0,1,S);
  LastStat := S;
END;
{}
PROCEDURE ClearStats;
BEGIN
  FG_SetColor(C.BoxBack);
  FG_Rect(253,632,446,473);
  ShadowText(256,450,15,0,1,Header.FileName);
  ShadowText(256,462,15,0,1,PadLeft(IntToStr(Header.FileSize),'0',8) + ' Bytes');
  ShadowText(356,450,15,0,1,'CRC-' + Header.FileCRC);
  ShadowText(356,462,15,0,1,PadLeft(IntToStr(TotalSent),'0',8) + ' Sent');
  ShadowText(450,450,15,0,1,IntToStr(TotalErrors) + ' Total Errors');
  ShadowText(450,462,15,0,1,IntToStr(FileErrors) + ' File Errors');
  ShadowText(556,450,15,0,1,PadLeft(IntToStr(FilesInQueue),'0',3) + ' In Queue');
  ShadowText(556,462,15,0,1,'Queue #' + PadLeft(IntToStr(CurrentFileNum),'0',3));
END;
{}
PROCEDURE WindowStatus(Starting : BOOLEAN);
CONST
  Progress : STRING[30] = '';
VAR
  Work     : WORD;
  Temp     : STRING;
BEGIN
  IF Starting THEN BEGIN
    OldBack   := C.BoxBack;
    C.BoxBack := C.Win1Back;
    HideMouse;
    Draw_Window(0,439,639,479,3,''); FG_SetColor(C.BoxBack); FG_Rect(502,637,462,477);
    FrameLow(6,445,247,460);
    FrameLow(6,465,247,474);
    FrameLow(252,445,633,474);
    ClearProgress;
    ClearStats;
  END ELSE BEGIN
    FG_SetColor(C.BoxBack);
    FG_Rect(356,448,462,472);
    IF Doing_Receive THEN ShadowText(356,462,15,0,1,PadLeft(IntToStr(TotalSent),'0',8) + ' Rcvd')
                     ELSE ShadowText(356,462,15,0,1,PadLeft(IntToStr(TotalSent),'0',8) + ' Sent');
    FG_SetColor(C.BoxBack);
    FG_Rect(450,554,450,460);
    ShadowText(450,450,15,0,1,IntToStr(TotalErrors) + ' Total Errors');
    FG_SetColor(C.BoxBack);
    FG_Rect(450,554,462,472);
    ShadowText(450,462,15,0,1,IntToStr(FileErrors) + ' File Errors');
   {Progress Bar}
    IF Header.FileSize > 0 THEN BEGIN
      Work := TRUNC((TotalSent / Header.FileSize) * 30);
      IF (Work > 0) AND (Work < 31) THEN BEGIN
        MOVE(Progress[1],Temp[1],Work);
        Temp[0] := CHR(Work);
        PickText(7,466,9,Temp);
      END ELSE ClearProgress;
    END;
  END;
END;
{}
FUNCTION SendFile(FName : STRING) : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  Crc       : LONGINT;
  Loop      : WORD;
  BytesRead : WORD;
  BytesSent : WORD;
  BlockErr  : BYTE;
LABEL         DoItAgain;
FUNCTION SendFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Sending File Header');
  SendFileHeader := FALSE;
  BlockWritePort(Header,26,BytesSent);
  IF GotAck THEN SendFileHeader := TRUE;
END;
BEGIN
  SendFile   := FALSE;
  TotalSent  := 0;
  FileErrors := 0;
  IF NOT FExist(FName) THEN EXIT;
  FILLCHAR(Header,26,0);
  WITH Header DO BEGIN
    FileName := GetFileName(FName);
    FileSize := FSize(FName);
    FileCrc  := AllCaps(FileToCRC(FName));
  END;
  ClearStats;
  IF NOT SendFileHeader THEN EXIT;
  WindowStatus(FALSE);
  UpdateStatus('Sending File Data');
  ASSIGN(F,FName);
  RESET(F,1);
  REPEAT
    FILLCHAR(Buffer,SIZEOF(Buffer),0);
    BLOCKREAD(F,Buffer,SIZEOF(Buffer),BytesRead);
    BlockErr := 0;
    Crc      := $FFFFFFFF;
    FOR Loop := 1 TO BytesRead DO Crc := Crc_32_Tab[BYTE(Crc XOR LONGINT(Buffer[Loop]))] XOR ((Crc SHR 8) AND $00FFFFFF);
    DoItAgain :
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        Weabort := TRUE;
        EXIT;
      END;
    END;
    BlockWritePort(BytesRead,2,BytesSent);      {Block Size}
    BlockWritePort(Crc,4,BytesSent);            {Block Crc}
    BlockWritePort(Buffer,BytesRead,BytesSent); {Block Data}
    IF NOT (GotAck) THEN BEGIN
      IF Cancelled THEN BEGIN
        AbortedProtocol := TRUE;
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        CLOSE(F);
        EXIT;
      END;
      UpdateStatus('Receiver Not Responding');
      Delay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        EXIT;
      END;
      GOTO DoItAgain;
    END ELSE BEGIN
      UpdateStatus('Sending File Data');
      INC(TotalSent,BytesRead);
    END;
    WindowStatus(FALSE);
  UNTIL EOF(F);
  CLOSE(F);
  UpdateStatus('File Transmit Complete');
  Delay(ProtoDelay);
  SendFile := TRUE;
END;
{}
FUNCTION ReceiveFile : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  GotBytes  : LONGINT;
  Crc       : LONGINT;
  Crc2      : LONGINT;
  BytesSent : WORD;
  Expected  : WORD;
  Loop      : WORD;
  BlockErr  : BYTE;
LABEL         Abort;
FUNCTION GetFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Getting File Header');
  BlockReadPort(Header,26,BytesSent);
  SendChar(#6);
  GetFileHeader := TRUE;
END;
BEGIN
  ReceiveFile := FALSE;
  FileErrors  := 0;
  TotalSent   := 0;
  GotBytes    := 0;
  FILLCHAR(Header,SIZEOF(Header),0);
  IF NOT GetFileHeader THEN EXIT;
  ClearStats;
  WindowStatus(FALSE);
  UpdateStatus('Receiving File Data');
  ASSIGN(F,WorkPath + Header.FileName);
  REWRITE(F,1);
  REPEAT
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        ERASE(F);
        WeAbort := TRUE;
        EXIT;
      END;
    END;
    BlockErr := 0;
    BlockReadPort(Expected,2,BytesSent);      {Block Size}
    BlockReadPort(Crc,4,BytesSent);           {Block Crc}
    BlockReadPort(Buffer,Expected,BytesSent); {Block Data}
    IF Expected = BytesSent THEN BEGIN
      Crc2 := $FFFFFFFF;
      FOR Loop := 1 TO Expected DO Crc2 := Crc_32_Tab[BYTE(Crc2 XOR LONGINT(Buffer[Loop]))] XOR ((Crc2 SHR 8) AND $00FFFFFF);
      IF Crc2 = Crc THEN BEGIN
        UpdateStatus('Receiving File Data');
        SendChar(#6);
        INC(GotBytes,Expected);
        INC(TotalSent,Expected);
        BLOCKWRITE(F,Buffer,Expected);
      END ELSE BEGIN
        UpdateStatus('Block CRC Error Detected');
        PurgeInput;
        SendChar(#21);
        Delay(RetryDelay);
        INC(TotalErrors);
        INC(FileErrors);
        INC(BlockErr);
        IF BlockErr = 8 THEN BEGIN
          UpdateStatus('Aborting - Too Many Errors');
          Delay(ProtoDelay);
          ClearModem;
          Delay(ProtoDelay);
          FOR Loop := 1 TO 5 DO SendChar(#24);
          CLOSE(F);
          ERASE(F);
          EXIT;
        END;
      END;
    END ELSE BEGIN
      UpdateStatus('Block Size Error Detected');
      PurgeInput;
      SendChar(#21);
      Delay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        ERASE(F);
        EXIT;
      END;
    END;
    TimeSlice;
    WindowStatus(FALSE);
  UNTIL (GotBytes >= Header.FileSize);
  CLOSE(F);
  IF AllCaps(FileToCRC(WorkPath + Header.FileName)) <> Header.FileCrc THEN BEGIN
    UpdateStatus('File CRC Check Failed');
    FOR Loop := 1 TO 5 DO SendChar(#24);
    ERASE(F);
    EXIT;
  END;
  UpdateStatus('File Receive Complete');
  Delay(ProtoDelay);
  ReceiveFile := TRUE;
END;
{}
PROCEDURE SendMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  IF FilesInQueue = 0 THEN EXIT;
  Cancelled := FALSE;
  LastStat  := '';
  WindowStatus(TRUE);
 {NOTE: MAXterm looks for a 'rm<CR>' to auto start the MaxModem download,
        MAXterm kicks back a few <CR>s when it's ready to receive files...}
  SendChar(#1); SendChar('r'); SendChar('m'); SendChar(#13);
  NewTimer(AckTimer,ProtoDelay);
  REPEAT TimeSlice UNTIL (DataAvailable) OR (TimerExpired(AckTimer));
  IF DataAvailable THEN WHILE DataAvailable DO BEGIN
    Delay(10);
    Ch := ReadChar;
  END ELSE BEGIN
    UpdateStatus('Receiver Not Responding');
    Delay(ProtoDelay);
    ClearModem;
    Delay(ProtoDelay);
    FOR Count := 1 TO 5 DO SendChar(#24);
    Kill_Window;
    C.BoxBack := OldBack;
    EXIT;
  END;
  UpdateStatus('Initializing Protocol');
  BlockWritePort(FilesInQueue,2,BytesSent);
  IF NOT GotAck THEN BEGIN
    Kill_Window;
    C.BoxBack := OldBack;
    EXIT;
  END;
  Count := 1;
  REPEAT
    CurrentFileNum := Count;
    IF NOT SendFile(FileQueue[Count]) THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  CurrentFileNum := 0;
  TotalSent      := 0;
  ClearProgress;
  UpdateStatus('All Done');
  ClearStats;
  Delay(1000);
  Kill_Window;
  C.BoxBack := OldBack;
END;
{}
PROCEDURE ReceiveMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  Cancelled := FALSE;
  LastStat  := '';
  WindowStatus(TRUE);
 {Send a few carriage returns to the sender as a receiver ready signal}
  SendChar(#13); SendChar(#13); SendChar(#13);
  Delay(ProtoDelay);
  UpdateStatus('Initializing Protocol');
  BlockReadPort(FilesInQueue,2,BytesSent);
  SendChar(#6);
  IF (FilesInQueue < 1) OR (FilesInQueue > 800) THEN BEGIN
    Kill_Window;
    C.BoxBack := OldBack;
    EXIT;
  END;
  Count := 1;
  REPEAT
    CurrentFileNum := Count;
    IF NOT ReceiveFile THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  CurrentFileNum := 0;
  TotalSent      := 0;
  ClearProgress;
  UpdateStatus('All Done');
  ClearStats;
  Delay(1000);
  Kill_Window;
  C.BoxBack := OldBack;
END;
{}

BEGIN
  Doing_Receive := FALSE;
  Cancelled     := FALSE;
  FilesInQueue  := 0;
  TotalErrors   := 0;
  FileErrors    := 0;
  WorkPath      := '';
END.
