{$I DEFINES.INC}
UNIT MXMODEM1;

INTERFACE

PROCEDURE SendMaxModem;
PROCEDURE ReceiveMaxModem;

IMPLEMENTATION

USES MYCRT,TEXTUNIT,GUI_UTIL,CRCUNIT,PORTUNIT,APVARS,APTIMER;

{}
PROCEDURE ClearProgress;
BEGIN
  OutTextXY(27,15,1,0,'');
END;
{}
PROCEDURE UpdateStatus(Msg : STRING);
BEGIN
  OutTextXY(31,13,14,1,PadRight(Msg,' ',34));
END;
{}
PROCEDURE WindowStatus(Starting : BOOLEAN);
CONST
  Progress : STRING[30] = '';
VAR
  Work     : WORD;
  Temp     : STRING;
BEGIN
  IF Starting THEN BEGIN
    IF Doing_Receive THEN DrawWindow(18,7,65,17,'Receiving File(s)')
                     ELSE DrawWindow(18,7,65,17,'Sending File(s)');
    InvertedBox(25,14,58,16);
    ClearProgress;
    OutTextXY(20,9,11,1, 'File Name:                  In Queue:');
    OutTextXY(20,10,11,1,'File Size:                  Queue ##:');
    OutTextXY(20,11,11,1,' File CRC:                  File Err:');
    IF Doing_Receive THEN OutTextXY(20,12,11,1,'     Rcvd:                 Total Err:')
                     ELSE OutTextXY(20,12,11,1,'     Sent:                 Total Err:');

    OutTextXY(20,13,11,1,'   Status:');
  END ELSE BEGIN
   {Column #1 Data}
    OutTextXY(31,9,15,1,PadRight(AllCaps(Header.FileName),' ',12));
    OutTextXY(31,10,15,1,PadRight(IntToStr(Header.FileSize),' ',9));
    OutTextXY(31,11,15,1,PadRight(Header.FileCRC,' ',8));
    OutTextXY(31,12,15,1,PadRight(IntToStr(TotalSent),' ',7));
   {Column #2 Data}
    OutTextXY(58,9,15,1, IntToStr(FilesInQueue));
    OutTextXY(58,10,15,1,IntToStr(CurrentFileNum));
    OutTextXY(58,11,15,1,PadRight(IntToStr(FileErrors),' ',7));
    OutTextXY(58,12,15,1,PadRight(IntToStr(TotalErrors),' ',7));
    IF Header.FileSize > 0 THEN BEGIN
      Work := TRUNC((TotalSent / Header.FileSize) * 30);
      IF (Work > 0) AND (Work < 31) THEN BEGIN
        MOVE(Progress[1],Temp[1],Work);
        Temp[0] := CHR(Work);
        OutTextXY(27,15,9,0,Temp);
      END ELSE ClearProgress;
    END;
  END;
END;
{}
FUNCTION SendFile(FName : STRING) : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  Crc       : LONGINT;
  Loop      : WORD;
  BytesRead : WORD;
  BytesSent : WORD;
  BlockErr  : BYTE;
LABEL         DoItAgain;
FUNCTION SendFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Sending File Header');
  SendFileHeader := FALSE;
  BlockWritePort(Header,26,BytesSent);
  IF GotAck THEN SendFileHeader := TRUE;
END;
BEGIN
  SendFile   := FALSE;
  TotalSent  := 0;
  FileErrors := 0;
  IF NOT FExist(FName) THEN EXIT;
  FILLCHAR(Header,26,0);
  WITH Header DO BEGIN
    FileName := GetFileName(FName);
    FileSize := FSize(FName);
    FileCrc  := AllCaps(FileToCRC(FName));
  END;
  IF NOT SendFileHeader THEN EXIT;
  WindowStatus(FALSE);
  UpdateStatus('Sending File Data');
  ASSIGN(F,FName);
  RESET(F,1);
  REPEAT
    FILLCHAR(Buffer,SIZEOF(Buffer),0);
    BLOCKREAD(F,Buffer,SIZEOF(Buffer),BytesRead);
    BlockErr := 0;
    Crc      := $FFFFFFFF;
    FOR Loop := 1 TO BytesRead DO Crc := Crc_32_Tab[BYTE(Crc XOR LONGINT(Buffer[Loop]))] XOR ((Crc SHR 8) AND $00FFFFFF);
   {$IFDEF DebugOn}
    OutTextXY(1,1,14,0,'Block Size: ' + PadRight(IntToStr(BytesRead),' ',4));
    OutTextXY(1,2,14,0,' Block CRC: ' + AllCaps(CrcString(Crc)));
   {$ENDIF}
    DoItAgain :
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        Weabort := TRUE;
        EXIT;
      END;
    END;
    BlockWritePort(BytesRead,2,BytesSent);      {Block Size}
    BlockWritePort(Crc,4,BytesSent);            {Block Crc}
    BlockWritePort(Buffer,BytesRead,BytesSent); {Block Data}
    IF NOT (GotAck) THEN BEGIN
      IF Cancelled THEN BEGIN
        AbortedProtocol := TRUE;
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        CLOSE(F);
        EXIT;
      END;
      UpdateStatus('Receiver Not Responding');
      Delay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        EXIT;
      END;
      GOTO DoItAgain;
    END ELSE BEGIN
      UpdateStatus('Sending File Data');
      INC(TotalSent,BytesRead);
    END;
    WindowStatus(FALSE);
  UNTIL EOF(F);
  CLOSE(F);
  UpdateStatus('File Transmit Complete');
  Delay(ProtoDelay);
  SendFile := TRUE;
END;
{}
FUNCTION ReceiveFile : BOOLEAN;
VAR
  F         : FILE;
  Ch        : CHAR;
  GotBytes  : LONGINT;
  Crc       : LONGINT;
  Crc2      : LONGINT;
  BytesSent : WORD;
  Expected  : WORD;
  Loop      : WORD;
  BlockErr  : BYTE;
LABEL         Abort;
FUNCTION GetFileHeader : BOOLEAN;
BEGIN
  UpdateStatus('Getting File Header');
  BlockReadPort(Header,26,BytesSent);
  SendChar(#6);
  GetFileHeader := TRUE;
END;
BEGIN
  ReceiveFile := FALSE;
  FileErrors  := 0;
  TotalSent   := 0;
  GotBytes    := 0;
  FILLCHAR(Header,SIZEOF(Header),0);
  IF NOT GetFileHeader THEN EXIT;
  WindowStatus(FALSE);
  UpdateStatus('Receiving File Data');
  ASSIGN(F,WorkPath + Header.FileName);
  REWRITE(F,1);
  REPEAT
    IF KEYPRESSED THEN BEGIN
      Ch := READKEY;
      IF Ch = #0 THEN Ch := READKEY;
      IF Ch IN [#24,#27] THEN BEGIN
        UpdateStatus('Protocol Aborted');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        ERASE(F);
        WeAbort := TRUE;
        EXIT;
      END;
    END;
    BlockErr := 0;
    BlockReadPort(Expected,2,BytesSent);      {Block Size}
    BlockReadPort(Crc,4,BytesSent);           {Block Crc}
    BlockReadPort(Buffer,Expected,BytesSent); {Block Data}
   {$IFDEF DebugOn}
    OutTextXY(1,1,14,0,'Block Size: ' + PadRight(IntToStr(Expected),' ',4));
    OutTextXY(1,2,14,0,' Block CRC: ' + AllCaps(CrcString(Crc)));
   {$ENDIF}
    IF Expected = BytesSent THEN BEGIN
      Crc2 := $FFFFFFFF;
      FOR Loop := 1 TO Expected DO Crc2 := Crc_32_Tab[BYTE(Crc2 XOR LONGINT(Buffer[Loop]))] XOR ((Crc2 SHR 8) AND $00FFFFFF);
      IF Crc2 = Crc THEN BEGIN
        UpdateStatus('Receiving File Data');
        SendChar(#6);
        INC(GotBytes,Expected);
        INC(TotalSent,Expected);
        BLOCKWRITE(F,Buffer,Expected);
      END ELSE BEGIN
        UpdateStatus('Block CRC Error Detected');
        PurgeInput;
        SendChar(#21);
        Delay(RetryDelay);
        INC(TotalErrors);
        INC(FileErrors);
        INC(BlockErr);
        IF BlockErr = 8 THEN BEGIN
          UpdateStatus('Aborting - Too Many Errors');
          Delay(ProtoDelay);
          ClearModem;
          Delay(ProtoDelay);
          FOR Loop := 1 TO 5 DO SendChar(#24);
          CLOSE(F);
          ERASE(F);
          EXIT;
        END;
      END;
    END ELSE BEGIN
      UpdateStatus('Block Size Error Detected');
      PurgeInput;
      SendChar(#21);
      Delay(RetryDelay);
      INC(TotalErrors);
      INC(FileErrors);
      INC(BlockErr);
      IF BlockErr = 8 THEN BEGIN
        UpdateStatus('Aborting - Too Many Errors');
        Delay(ProtoDelay);
        ClearModem;
        Delay(ProtoDelay);
        FOR Loop := 1 TO 5 DO SendChar(#24);
        CLOSE(F);
        ERASE(F);
        EXIT;
      END;
    END;
    TimeSlice;
    WindowStatus(FALSE);
  UNTIL (GotBytes >= Header.FileSize);
  CLOSE(F);
  IF AllCaps(FileToCRC(WorkPath + Header.FileName)) <> Header.FileCrc THEN BEGIN
    UpdateStatus('File CRC Check Failed');
    FOR Loop := 1 TO 5 DO SendChar(#24);
    ERASE(F);
    EXIT;
  END;
  UpdateStatus('File Receive Complete');
  Delay(ProtoDelay);
  ReceiveFile := TRUE;
END;
{}
PROCEDURE SendMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  IF FilesInQueue = 0 THEN EXIT;
  Cancelled := FALSE;
  HideCursor;
  WindowStatus(TRUE);
 {NOTE: MAXterm looks for a 'rm<CR>' to auto start the MaxModem download,
        MAXterm kicks back a few <CR>s when it's ready to receive files...}
  SendChar(#1); SendChar('r'); SendChar('m'); SendChar(#13);
  NewTimer(AckTimer,ProtoDelay);
  REPEAT TimeSlice UNTIL (DataAvailable) OR (TimerExpired(AckTimer));
  IF DataAvailable THEN WHILE DataAvailable DO BEGIN
    Delay(10);
    Ch := ReadChar;
  END ELSE BEGIN
    UpdateStatus('Receiver Not Responding');
    Delay(ProtoDelay);
    ClearModem;
    Delay(ProtoDelay);
    FOR Count := 1 TO 5 DO SendChar(#24);
    KillWindow;
    ShowCursor;
    EXIT;
  END;
  UpdateStatus('Initializing Protocol');
  BlockWritePort(FilesInQueue,2,BytesSent);
  IF NOT GotAck THEN BEGIN
    KillWindow;
    ShowCursor;
    EXIT;
  END;
  Count := 1;
  REPEAT
    CurrentFileNum := Count;
    IF NOT SendFile(FileQueue[Count]) THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  CurrentFileNum := 0;
  TotalSent      := 0;
  ClearProgress;
  UpdateStatus('All Done');
  WindowStatus(False);
  Delay(1000);
  KillWindow;
  ShowCursor;
END;
{}
PROCEDURE ReceiveMaxModem;
VAR
  Ch        : CHAR;
  BytesSent : WORD;
  Count     : WORD;
BEGIN
  Cancelled := FALSE;
  HideCursor;
  WindowStatus(TRUE);
 {Send a few carriage returns to the sender as a receiver ready signal}
  SendChar(#13); SendChar(#13); SendChar(#13);
  Delay(ProtoDelay);
  UpdateStatus('Initializing Protocol');
  BlockReadPort(FilesInQueue,2,BytesSent);
  SendChar(#6);
  IF (FilesInQueue < 1) OR (FilesInQueue > 800) THEN BEGIN
    KillWindow;
    ShowCursor;
    EXIT;
  END;
  Count := 1;
  REPEAT
    CurrentFileNum := Count;
    IF NOT ReceiveFile THEN Count := 800;
    INC(Count);
  UNTIL Count > FilesInQueue;
  FILLCHAR(Header,SIZEOF(Header),0);
  CurrentFileNum := 0;
  TotalSent      := 0;
  ClearProgress;
  UpdateStatus('All Done');
  WindowStatus(False);
  Delay(1000);
  KillWindow;
  ShowCursor;
END;
{}

BEGIN
  Doing_Receive := FALSE;
  Cancelled     := FALSE;
  FilesInQueue  := 0;
  TotalErrors   := 0;
  FileErrors    := 0;
  WorkPath      := '';
END.
