{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
{.$M 16384,0,655360}
UNIT MOD_UNIT;

INTERFACE

VAR
  ModPlaying : BOOLEAN;

PROCEDURE InitModUnit(P,I : STRING);
PROCEDURE PlayMOD(FName : STRING);
PROCEDURE ModShutDown;

IMPLEMENTATION

USES {CRT,} DOS, MODMIXER, GUI_UTIL, APTIMER;

{ Program by Borek (Marcin Borkowski), Warsaw, Poland.
  You can find me in a Top Secret BBS, +48 2 6788783
  Fido 2:480/25, Pascal Net 115:4804/104

  This program needs fast machine, as it is written in
  plain vanilla Pascal. If you are looking for proffesional
  quality implementation of MOD player, keep trying
  (I'm sure you'll have to paid for that). If you are looking
  for a source to understand and start work by yourself -
  you've got what you are looking for! You may freely copy
  and use this source, as long as it is unchanged and states my
  name in the begining. If you find more profitable use of this
  code, feel free to share your profits with me! At least - let
  me know you were able to use it for your own purposes.

  This program should be accompanied by the MIXER unit source.

  Attention - this implementation of playing MOD's is BAD
  and will probably not work on some MOD's with changed
  order of playing patterns, also MOD's based on effects
  will not be played properly. Effects (and many other things -
  as sample volumes, finetuning) aren't implemented, and in
  fact that's only a sketch. Program is probably bugged, but
  for sure it plays 40% MOD's from my BBS in an acceptable way.

  Parts of code ripped from PCPGE, various sources from
  Ethan Brodsky and probably from SWAG. I can't remember
  source of every byte, but for sure 95% of code is mine.

  When this code was posted for the first time, I've got some
  stupid questions, here are stupid answers:
  1. Borland Pascal 7.0
  2. Sound Blaster 2.0
  3. Yes, I'm nearly bald. }

CONST
  TIMERINTR     = 8;
  PIT_FREQ      = $1234DD;

TYPE SampleData = ARRAY[0..65533] OF BYTE;
     Pattern    = ARRAY[0..63,0..15] OF BYTE;
     PatPtr     = ^Pattern;

TYPE SData      = RECORD
     SName      : STRING[22];
     Length     : WORD;
     Finet      : BYTE;
     Volume     : BYTE;
     RepSt      : WORD;
     RepEnd     : WORD;
     END;

TYPE SArray     = ARRAY[1..31] OF SData;

VAR
  BIOSTimerHandler    : PROCEDURE;
  Clock_Ticks,Counter : LONGINT;
  Ticks,Speed         : WORD;
  DivPlayed           : WORD;
  PatPlayed           : WORD;
  Patterns            : ARRAY[0..255] OF PatPtr;
  PatternOrder        : ARRAY[0..127] OF BYTE;
  FMod                : FILE;
  ModFile             : STRING[80];
  Hdr                 : ARRAY[1..1084] OF BYTE;
  NofSamples          : WORD;
  NofPatterns         : WORD;
  PlayEnd             : BOOLEAN;
  TimerSet            : BOOLEAN;
  SPtrOn              : BOOLEAN;
  Samples             : ^SArray;
  P                   : POINTER;

FUNCTION AmiWord(W : WORD) : WORD; Assembler;
{Data in MOD files are usually in Amiga 68000 format.}
Asm
  mov ax,w
  xchg ah,al
END;

PROCEDURE NextDivision;
VAR
{ Sometimes data have to be treated as bytes,
  sometimes as words. Let's use some tricks! }
  Divis        : ARRAY[0..15] OF BYTE;
  Diwis        : ARRAY[0..7] OF WORD ABSOLUTE Divis;
  Smp,Tmp,Freq : WORD;
  Eff,Arg      : BYTE;
  I            : INTEGER;
BEGIN
  IF DivPlayed = 64 THEN BEGIN
    DivPlayed := 0;
    INC(PatPlayed);
  END;
  IF PatPlayed >= Hdr[951] THEN BEGIN
    ModShutDown;
    EXIT;
  END;
  MOVE(Patterns[PatternOrder[PatPlayed]]^[DivPlayed,0],Divis,16);
  FOR I := 0 TO 3 DO BEGIN
    Smp := (Divis[4 * I + 0] AND $F0) + Divis[4 * I + 2] SHR 4; {sample number}
    Tmp := (AmiWord(Diwis[2 * I]) AND $0FFF);                   {sample period}
    IF Tmp <> 0 THEN Freq := 3546895 DIV Tmp;
    IF Smp <> 0 THEN StartChannel(I + 1,Smp,64,Freq) ELSE
    IF Tmp <> 0 THEN SetChannelFrequency(I + 1,Freq);
    Eff := Divis[4 * I + 2] AND $0F; {effect number}
    Arg := Divis[4 * I + 3];         {effect argument}
    CASE Eff OF
      $0C : BEGIN
              SetChannelVolume(I + 1,Arg);
             {WRITE('volume change       ');}
            END;
      $0F : IF Arg <> 0 THEN BEGIN
              Speed := Arg;
             {WRITE('speed change        ');}
            END;
      $0B : BEGIN
              DivPlayed := 63;
              PatPlayed := Arg - 1;
             {WRITE('pattern break       ');}
            END;
      $0D : BEGIN
              INC(PatPlayed);
              DivPlayed := 10 * (Arg SHR 4) + Arg AND $0F - 1;
             {WRITE('pattern jump        ');}
            END;
      ELSE IF Eff <> 0 THEN {WRITE('unimplemented effect')};
    END;
  END;
  INC(DivPlayed);
END;

PROCEDURE Play;
INTERRUPT;
BEGIN
  INC(Ticks);
  IF Ticks = Speed THEN BEGIN
    Ticks := 0;
    NextDivision;
  END;
  Clock_Ticks := Clock_Ticks + Counter;
  IF Clock_Ticks >= $10000 THEN BEGIN
    Clock_Ticks := Clock_Ticks - $10000;
    Asm PushF END;
    BIOSTimerHandler;
  END ELSE Port[$20] := $20;
END;

PROCEDURE CleanUpTimer;
BEGIN
  Port[$43] := $34;
  Port[$40] := 0;
  Port[$40] := 0;
  SETINTVEC(TIMERINTR,@BIOSTimerHandler);
END;

PROCEDURE SetTimer(TimerHandler : POINTER; Frequency : WORD);
BEGIN
  Clock_Ticks := 0;
  Counter := $1234DD DIV Frequency;
  GETINTVEC(TIMERINTR,@BIOSTimerHandler);
  SETINTVEC(TIMERINTR,TimerHandler);
  Port[$43] := $34;
  Port[$40] := Counter MOD 256;
  Port[$40] := Counter DIV 256;
  TimerSet  := TRUE
END;

PROCEDURE ModShutDown;
VAR
  I : INTEGER;
BEGIN
  IF PlayEnd THEN Exit;
  IF TimerSet THEN CleanUpTimer;
  FOR I := 0 TO NofPatterns - 1 DO DISPOSE(Patterns[I]);
  DISPOSE(Samples);
  RELEASE(P);
  MixerExit;
 {IF SvgaMode THEN Show_Mem;}
  PlayEnd    := TRUE;
  ModPlaying := FALSE;
END;

PROCEDURE Error;
BEGIN
  IF SPtrOn THEN DISPOSE(Samples);
  CLOSE(Fmod);
END;

PROCEDURE OpenMod;
VAR
  S : STRING;
BEGIN
  ASSIGN(Fmod,ModFile);
  RESET(Fmod,1);
  BLOCKREAD(Fmod,hdr,1084);
  MOVE(Hdr[1081],S[1],4);
  S[0] := #4;
  IF NOT((S = 'M.K.') OR (S = 'M!K!') OR (S = 'FLT4') OR (S = '4CHN')) THEN Error;
  NofSamples := 31;
  MOVE(Hdr[1],S[1],20);
  S[0] := #1;
  WHILE S[ORD(S[0])] <> #0 DO INC(S[0]);
END;

PROCEDURE GetSamples;
VAR
 {P               : POINTER;}
  S               : STRING;
  W               : WORD;
  I               : INTEGER;
  TotalSampLength : LONGINT;
BEGIN
  NEW(Samples);
  SPtrOn          := TRUE;
  TotalSampLength := 0;
  FOR I := 1 TO NofSamples DO WITH Samples^[I] DO BEGIN
    MOVE(hdr[21 + (I - 1) * 30],SName[1],21);
    SName[0] := #1;
    WHILE SName[ORD(SName[0])] <> #0 DO INC(SName[0]);
    MOVE(Hdr[43 + 30 * (I - 1)],W,2);
    LENGTH := AmiWord(W) SHL 1;
    INC(TotalSampLength,Length);
    Volume := Hdr[46 + 30 * (I - 1)];
    MOVE(Hdr[47 + 30 * (I - 1)],W,2);
    RepSt := AmiWord(W) SHL 1;
    MOVE(Hdr[49 + 30 * (I - 1)],W,2);
    RepEnd := RepSt + AmiWord(W) SHL 1;
  END;
  NofPatterns := (FILESIZE(Fmod) - 1084 - TotalSampLength) DIV 1024;
  SEEK(Fmod,FILESIZE(Fmod) - TotalSampLength);
  FOR I := 1 TO NofSamples DO WITH Samples^[I] DO IF LENGTH > 2 THEN BEGIN
    GETMEM(P,Length);
    BLOCKREAD(Fmod,W,2);
    BLOCKREAD(Fmod,P^,LENGTH - 2);
   {Convert sample to appropriate format.}
    FOR W := 0 TO Length - 3 DO INC(SampleData(P^)[W],128);
    AddVoice(I,Length - 2,RepSt,RepEnd - 2,P);
  END;
  IF IORESULT <> 0 THEN Error;
END;

PROCEDURE GetPatterns;
VAR
  I : INTEGER;
BEGIN
  SEEK(Fmod,1084);
  FOR I := 0 TO NofPatterns - 1 DO BEGIN
    NEW(Patterns[I]);
    BLOCKREAD(Fmod,Patterns[I]^,1024)
  END;
  SEEK(Fmod,952);
  BLOCKREAD(Fmod,PatternOrder,128);
  CLOSE(Fmod);
END;

PROCEDURE StartPlay;
BEGIN
  Speed     := 6;
  DivPlayed := 0;
  PatPlayed := 0;
  SetTimer(@Play,50);
  Playend    := FALSE;
  ModPlaying := TRUE;
END;

PROCEDURE InitModUnit(P,I : STRING);
BEGIN
  SBIO  := HexToInt('$'+P);
  SBIRQ := StrToInt(I);
END;

PROCEDURE WaitForRetrace;
BEGIN
  WHILE ((Port[$3DA] AND 8) > 0) DO;
  WHILE ((Port[$3DA] AND 8) = 0) DO;
{ REPEAT UNTIL Port[$3DA] AND 8 = 8;{Wait For Vertical retrace              }
{ REPEAT UNTIL Port[$3DA] AND 8 = 0;{Wait For the end of Vertical retrace   }
{ REPEAT UNTIL Port[$3DA] AND 1 = 1;{Wait For Horizontal retrace            }
{ REPEAT UNTIL Port[$3DA] AND 1 = 0;{Wait For the end of Horizontal retrace }
END;

PROCEDURE PlayMOD(FName : STRING);
BEGIN
  IF NOT FExist(FName) THEN EXIT;
  InitPlayLoop;
  DELAY(400);
  ModFile  := FName;
  TimerSet := FALSE;
  SPtrOn   := FALSE;
  PlayEnd  := TRUE;
  OpenMod;
  GetSamples;
  GetPatterns;
  WaitForRetrace;
  StartPlay;
 {IF SvgaMode THEN Show_Mem;}
END;

BEGIN
  ModPlaying := FALSE;
END.
