{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
{.$M 16384,0,655360}
UNIT MODMIXER;

{ Program by Borek (Marcin Borkowski), Warsaw, Poland.
  You can find me in a Top Secret BBS, +48 2 6788783
  Fido 2:480/25, Pascal Net 115:4804/104

  If you can't recognize - it is Sound Blaster version.

  You may freely copy and use this source, as long it is
  unchanged and states my name in the begining. If you find
  more profitable use of this code, fell free to share your
  profits with me! At least - let me know you were able to
  use it for your own purposes.

  This unit should be accompanied by the MODPLAY source.

  This version of mixing (even at 44 kHz) works OK on my
  UMC 40 MHz machine (that's a little bit less than 486 50 MHz).
  If you want to make it work on 386DX 33MHz, you must 'unroll'
  the main loop and put used there data into 'hardcoded' variables.
  Such a version works on my old 386 and on several other
  computers of the same class, even with QEMM.

  If you stop this program by ctrl break, you may not be able to
  restart it without resetting your computer - and that's not the
  only one bug I know in the code.

  Parts of code ripped from PCPGE, various sources from
  Ethan Brodsky and probably from SWAG. I can't remember
  source of every byte, but for sure 95% of code is mine.}

INTERFACE

CONST { SB data - change it for your card settings. }
  SBIO  : WORD = $220; {2;} { 2x0 }
  SBIRQ : WORD = 2;

PROCEDURE InitPlayLoop;
PROCEDURE MixerExit;

PROCEDURE AddVoice(Voice,_SampleSize,_LoopStart,_LoopEnd : WORD; Sample : POINTER);
PROCEDURE StartChannel(Channel,Voice,Volume,Frequency : WORD);
PROCEDURE StopChannel(Channel : WORD);
PROCEDURE SetChannelFrequency(Channel,Frequency : WORD);
PROCEDURE SetChannelVolume(Channel,Volume : WORD);

IMPLEMENTATION

USES {CRT,} DOS, APTIMER;

CONST
{ Mixer data }
  Max_Num_Voices   = 32;    { number of voices }
  Max_Num_Channels = 4;     { number of channels }
  PlayFreq         = 22222; { samples played at, at 11111 sound is very bad. }
  PlayBufSize      = 512;   { Size of play buffer}

TYPE
  SampleData = ARRAY[0..65533] OF BYTE;
  _Channel   = RECORD
               NVoice,
               Position,
               Increment,
               SubPosition,
               Vol          : WORD;
               InLoop,
               Active       : BOOLEAN
               END;

VAR
{ Pointers to samples. }
  voicesdata : ARRAY[1..max_num_voices] OF ^sampledata;
{ Sizes of voices }
  voicessize : ARRAY[1..max_num_voices] OF WORD;
{ Those two defines begining and end of loop in sample }
  voicesloopstart : ARRAY[1..max_num_voices] OF WORD;
  voicesloopend : ARRAY[1..max_num_voices] OF WORD;
{ Voice ready to use? }
  voicesdefined : ARRAY[1..max_num_voices] OF BOOLEAN;
{ Which voice played in this channel? }
  channelsnvoice : ARRAY[1..max_num_channels] OF WORD;
{ Which position in sample? }
  channelsposition : ARRAY[1..max_num_channels] OF WORD;
{ How to increment subposition? }
  channelsincrement : ARRAY[1..max_num_channels] OF WORD;
{ Which subposistion in position - it allows to change frequencies,
  as one byte of sample can be played several times. It gives not a
  perfect sound, but it works. To improove sound quality, one should
  use interpolation (and assembler :-) }
  channelssubposition : ARRAY[1..max_num_channels] OF WORD;
{ Volume of channel }
  channelsvol : ARRAY[1..max_num_channels] OF WORD;
{ Is sample in this channel loop? }
  channelsinloop : ARRAY[1..max_num_channels] OF BOOLEAN;
{ Channel being played? }
  channelsactive : ARRAY[1..max_num_channels] OF BOOLEAN;

{ SB addresses }
  DSP_RESET        : WORD;
  DSP_READ_DATA    : WORD;
  DSP_WRITE_DATA   : WORD;
  DSP_WRITE_STATUS : WORD;
  DSP_DATA_AVAIL   : WORD;
  TimeConst        : BYTE;
  PlayBuf          : POINTER;
  OldInt{,OldExit} : POINTER;
  FirstBuff        : BOOLEAN;

FUNCTION Carry : BOOLEAN;
INLINE($B0 / $01 / { mov al,01 }
       $72 / $02 / { jc @carryset }
       $30 / $C0); { xor al,al }
                   { @carryset: }

FUNCTION ResetDSP(Base : WORD) : BOOLEAN;
BEGIN
 {Base := Base * $10;}
 {Base := HexToInt('$'+IntToStr(SBIO));}
  Base             := Base DIV $11;
  DSP_RESET        := Base + $206;
  DSP_READ_DATA    := Base + $20A;
  DSP_WRITE_DATA   := Base + $20C;
  DSP_WRITE_STATUS := Base + $20C;
  DSP_DATA_AVAIL   := Base + $20E;
  Port[DSP_RESET]  := 1;
  DELAY(4);
  Port[DSP_RESET] := 0;
  DELAY(1);
  IF (Port[DSP_DATA_AVAIL] AND $80 = $80) AND (Port[DSP_READ_DATA] = $AA)
  THEN ResetDSP := TRUE ELSE ResetDSP := FALSE;
END;

PROCEDURE WriteDSP(Value : BYTE);
BEGIN
  WHILE Port[DSP_WRITE_STATUS] AND $80 <> 0 DO;
  Port[DSP_WRITE_DATA] := Value;
END;

FUNCTION ReadDSP : BYTE;
BEGIN
  WHILE Port[DSP_DATA_AVAIL] AND $80 = 0 DO;
  ReadDSP := Port[DSP_READ_DATA];
END;

FUNCTION SpeakerOn : BYTE;
BEGIN
  WriteDSP($D1);
END;

FUNCTION SpeakerOff : BYTE;
BEGIN
  WriteDSP($D3);
END;

PROCEDURE Playback;
VAR
  Page,Offset,Size : WORD;
BEGIN
{ SB and DMA are working in autoinit modes - but DMA buffer is
  twice as long as SB buffer. Each time SB buffer is finished an
  IRQ is generated - a signal that next part of samples should be
  mixed. Play buffer has two parts - when one is played, second
  is being filled. Simple, uh? This version of procedure was checked
  on AWE 32, on SB 16 and on several clones of SB, but for sure
  it'll not work on some cards - especially on older versions
  that are not supporting autoinit mode. }
  FirstBuff := TRUE;
  Size      := PlayBufSize - 1;
  Offset    := SEG(PlayBuf^) SHL 4 + OFS(PlayBuf^);
  Page      := (SEG(PlayBuf^) + OFS(PlayBuf^) SHR 4) SHR 12;
{ DMA programming }
  Port[$0A] := 5;
  Port[$0C] := 0;
  Port[$0B] := $59; { DMA autoinit }
  Port[$02] := LO(Offset);
  Port[$02] := HI(Offset);
  Port[$83] := Page;
  Port[$03] := LO(Size);
  Port[$03] := HI(Size);
  Port[$0A] := 1;
{ SB programming }
  WriteDSP($40);
  WriteDSP(TimeConst);
  WriteDSP($48); { 8-bit sample type with autoinit}
  WriteDSP(LO(PlayBufSize SHR 1 - 1));
  WriteDSP(HI(PlayBufSize SHR 1 - 1));
  WriteDSP($1C) {???? I don't know why, but it is necessary }
END;

PROCEDURE Mix;
{ Main procedure - mixes samples with appropriate frequencies and
  puts mixed signal into play buffer. If it's too slow for your
  computer, don't blame me - but translate procedure into assembler
  (or buy something faster :-) }
VAR
  I,J        : INTEGER;
  NVoice,Sw  : WORD;
  PomBuf     : ^SampleData;
BEGIN
 {Pointer to play buffer - is it first, or second part? }
  IF FirstBuff THEN PomBuf := @SampleData(PlayBuf^)[PlayBufSize DIV 2] ELSE PomBuf := PlayBuf;
  FOR I := 0 TO PlayBufSize DIV 2 - 1 DO BEGIN
    Sw := 0;
    FOR J := 1 TO Max_Num_Channels DO IF ChannelsActive[J] THEN BEGIN
      NVoice := ChannelsNVoice[J];
     {That's mixing - without interpolation. }
      INC(Sw,VoicesData[NVoice]^[ChannelsPosition[J]] * ChannelsVol[J]);
     {Here is the most important thing - next two lines (excluding
      remarks :) are responsible for output frequency of sample.  }
      INC(ChannelsSubposition[J],ChannelsIncrement[J]);
     {That's a nasty trick - but it works. You can do it other ways,
      in Pascal, Assembler and so on. }
      IF Carry THEN BEGIN
        INC(ChannelsPosition[J]);
       {Now work with looped samples. }
        IF ChannelsInLoop[J] THEN
        IF ChannelsPosition[J] > VoicesLoopEnd[NVoice] THEN
        ChannelsPosition[J] := VoicesLoopStart[NVoice];
       {Maybe we should stop playing this sample? Or put it in a loop mode? }
        IF ChannelsPosition[J] > VoicesSize[NVoice] THEN
        IF VoicesLoopStart[NVoice] <> 0 THEN BEGIN
          ChannelsPosition[J] := VoicesLoopStart[NVoice];
          ChannelsInLoop[J] := TRUE;
        END ELSE ChannelsActive[J] := FALSE;
      END;
    END;
    PomBuf^[I] := LO(Sw SHR 6);
  END;
END;

PROCEDURE IntHandler;
INTERRUPT;
VAR
  W : WORD;
BEGIN
  W         := Port[DSP_DATA_AVAIL];
  Port[$20] := $20;
  FirstBuff := NOT FirstBuff;
  Mix;
END;

PROCEDURE EnableIRQ(N : BYTE);
BEGIN
  Port[$21] := Port[$21] AND NOT (1 SHL N)
END;

PROCEDURE DisableIRQ(N : BYTE);
BEGIN
  Port[$21] := Port[$21] OR (1 SHL N)
END;

PROCEDURE AllocMem(VAR P : POINTER);
VAR
  Adr : LONGINT;
BEGIN
 {Allocates memory not crossing page boundary ($X0000) }
  REPEAT
    GETMEM(P,PlayBufSize);
    Adr := LONGINT(SEG(P^)) SHL 4 + OFS(P^);
  UNTIL (Adr AND $FFFF) < $FFFF - PlayBufSize;
END;

PROCEDURE MixerExit;
BEGIN
 {ExitProc := OldExit;}
  WriteDSP($D0); { ??? }
  SpeakerOff;
  DisableIRQ(SBIRQ);
  SETINTVEC(8 + SBIRQ,OldInt);
  RELEASE(PlayBuf);
  ResetDSP(SBIO);
END;

PROCEDURE InitPlayLoop;
BEGIN
  IF NOT ResetDSP(SBIO) THEN EXIT;
  AllocMem(PlayBuf);
  GETINTVEC(8 + SBIRQ,OldInt);
  SETINTVEC(8 + SBIRQ,@IntHandler);
  EnableIRQ(SBIRQ);
  SpeakerOn;
  TimeConst := 256 - 1000000 DIV PlayFreq;
  FILLCHAR(PlayBuf^,PlayBufSize,#0);
  PlayBack;
 {OldExit  := ExitProc;
  ExitProc := @MixerExit;}
END;

PROCEDURE AddVoice(Voice,_SampleSize,_LoopStart,_LoopEnd : WORD; Sample : POINTER);
BEGIN
  VoicesData[Voice]      := Sample;
  VoicesSize[Voice]      := _SampleSize;
  VoicesLoopStart[Voice] := _LoopStart;
  VoicesLoopEnd[Voice]   := _LoopEnd;
  VoicesDefined[Voice]   := TRUE;
END;

PROCEDURE StartChannel(Channel,Voice,Volume,Frequency : WORD);
BEGIN
  Asm Cli END;
  IF NOT ChannelsActive[Channel] THEN ChannelsActive[Channel] := TRUE;
  ChannelsInLoop[Channel] := FALSE;
  ChannelsNVoice[Channel] := Voice;
  ChannelsIncrement[Channel] := (LONGINT(Frequency) SHL 16 - 1) DIV PlayFreq;
  IF (Volume >= 0) AND (Volume <= 16) THEN ChannelsVol[channel] := Volume
                                      ELSE ChannelsVol[channel] := 16;
  ChannelsSubposition[Channel] := 0;
  ChannelsPosition[Channel]    := 0;
  Asm Sti END;
END;

PROCEDURE StopChannel(Channel : WORD);
BEGIN
  ChannelsActive[Channel] := FALSE;
  ChannelsInLoop[Channel] := FALSE
END;

PROCEDURE SetChannelFrequency(Channel,Frequency : WORD);
BEGIN
  Asm Cli END;
  ChannelsIncrement[Channel] := (LONGINT(Frequency) SHL 16 - 1) DIV PlayFreq;
  Asm Sti END;
END;

PROCEDURE SetChannelVolume(Channel,Volume : WORD);
BEGIN
  Asm Cli END;
  IF (Volume >= 0) AND (Volume <= 16) THEN ChannelsVol[Channel] := Volume;
  Asm Sti END;
END;

BEGIN
  FILLCHAR(VoicesData,SIZEOF(VoicesData),#0);
  FILLCHAR(VoicesSize,SIZEOF(VoicesSize),#0);
  FILLCHAR(VoicesLoopStart,SIZEOF(VoicesLoopStart),#0);
  FILLCHAR(VoicesLoopEnd,SIZEOF(VoicesLoopEnd),#0);
  FILLCHAR(VoicesDefined,SIZEOF(VoicesDefined),#0);
  FILLCHAR(ChannelsNVoice,SIZEOF(ChannelsNVoice),#0);
  FILLCHAR(ChannelsPosition,SIZEOF(ChannelsPosition),#0);
  FILLCHAR(ChannelsIncrement,SIZEOF(ChannelsIncrement),#0);
  FILLCHAR(ChannelsSubposition,SIZEOF(ChannelsSubposition),#0);
  FILLCHAR(ChannelsVol,SIZEOF(ChannelsVol),#0);
  FILLCHAR(ChannelsInLoop,SIZEOF(ChannelsInLoop),#0);
  FILLCHAR(ChannelsActive,SIZEOF(ChannelsActive),#0);
 {InitPlayLoop;}
END.
