{       SBDSP is Copyright 1994 by Ethan Brodsky.  All rights reserved.      }
{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT MEM;

INTERFACE

FUNCTION GetBuffer(VAR Buffer : POINTER; BufferLength : LONGINT) : BOOLEAN;
PROCEDURE FreeBuffer(Buffer : POINTER; BufferLength : LONGINT);
FUNCTION GetAbsoluteAddress(P : POINTER) : LONGINT;

IMPLEMENTATION

FUNCTION GetBuffer(VAR Buffer : POINTER; BufferLength : LONGINT) : BOOLEAN;
VAR
  Dummy : POINTER;
BEGIN
  IF MAXAVAIL < BufferLength THEN BEGIN
    GetBuffer := FALSE;
    Buffer    := NIL;
    EXIT;
  END;
  GetBuffer := TRUE;
  IF BufferLength < $FFFF THEN GETMEM(Buffer,BufferLength) ELSE BEGIN
    GETMEM(Buffer,$FFFF);
    BufferLength := BufferLength - $FFFF;
    WHILE BufferLength > $FFFF DO BEGIN
      GETMEM(Dummy, $FFFF);
      BufferLength := BufferLength - $FFFF;
    END;
    GETMEM(Dummy,BufferLength);
  END;
END;

PROCEDURE FreeBuffer(Buffer : POINTER; BufferLength : LONGINT);
VAR
  Dummy      : POINTER;
  LeftToFree : LONGINT;
BEGIN
  IF BufferLength < $FFFF THEN FREEMEM(Buffer, BufferLength) ELSE BEGIN
    Dummy      := Buffer;
    LeftToFree := BufferLength;
    FREEMEM(Buffer,$FFFF);
    LeftToFree := LeftToFree - $FFFF;
    Dummy := PTR(SEG(Dummy^) + $1000, OFS(Dummy^));
    WHILE LeftToFree > $FFFF DO BEGIN
      FREEMEM(Dummy,$FFFF);
      LeftToFree := LeftToFree - $FFFF;
      Dummy := PTR(SEG(Dummy^) + $1000, OFS(Dummy^));
    END;
    FREEMEM(Dummy, LeftToFree);
  END;
END;

FUNCTION GetAbsoluteAddress(P : POINTER) : LONGINT;
BEGIN
  GetAbsoluteAddress := LONGINT(SEG(P^)) * 16 + LONGINT(OFS(P^));
END;

END.
