{$I DEFINES.INC}
PROGRAM MAXSOUND;

USES MYCRT, GUI_UTIL, WAV_UNIT, VOC_UNIT, MOD_UNIT;

TYPE SB_Information    = RECORD
     IRQ               : STRING[2];  {Sound card port IRQ.                   }
     DMA               : STRING[2];  {Sound card DMA channel.                }
     Address           : STRING[3];  {Sound card port address with no "$".   }
     END;

CONST
  BlankScreen : BOOLEAN = FALSE;

VAR
  SB          : SB_Information;
  ProgramDesc : STRING[45];
  FName       : STRING;

PROCEDURE IceText(X,Y : BYTE ; S : STRING);
VAR
  TLength : BYTE;
  Loop    : BYTE;
BEGIN
  TLength  := LENGTH(S);
  FOR Loop := 1 TO TLength DO BEGIN
    IF (ORD(S[Loop]) >= 65) AND (ORD(S[Loop]) <= 90) THEN OutTextXY(X + (Loop - 1),Y,15,0,S[Loop]) ELSE
    IF (ORD(S[Loop]) >= 97) AND (ORD(S[Loop]) <= 122) THEN OutTextXY(X + (Loop - 1),Y,11,0,S[Loop]) ELSE
    IF (ORD(S[Loop]) > 127) OR (ORD(S[Loop]) < 32) THEN OutTextXY(X + (Loop - 1),Y,1,0,S[Loop]) ELSE
    OutTextXY(X + (Loop - 1),Y,9,0,S[Loop]);
  END;
END;

PROCEDURE SetUpScreen;
BEGIN
  CLRSCR;
  HideCursor;
  IceText(1,1,PadRight(#196,#196,79));
  IceText(1,2,ProgramName);
  IceText(1,3,ProgramDesc);
  IceText(1,4,'Copyright 1995-Current  Larry L. Athey  BBS Utiliteez Software');
  IceText(1,5,PadRight(#196,#196,79));
END;

PROCEDURE CommandHelp;
BEGIN
  SetUpScreen;
  IceText(1,7,'Example: MAXSOUND.EXE FILENAME.VOC [SoundBlaster Port Parameters]');
  IceText(1,9,'SoundBlaster Port Parameters:');
  IceText(1,10,PadRight(#196,#196,29));
  IceText(1,11,'/P### - SoundBlaster Port Address');
  IceText(1,12,'/I#   - SoundBlaster Port IRQ');
  IceText(1,13,'/D#   - SoundBlaster DMA Channel');
  IceText(1,24,'Press Almost Any Key To Continue...');
  READKEY;
  SetUpScreen;
  IceText(1,7,'Dude....Like....Whoops....Command Line Error....Try Again....');
  ShowCursor;
  GOTOXY(1,9);
  HALT;
END;

PROCEDURE DoCommandLine;
VAR
  TempParam : STRING;
  Loop      : BYTE;
  F         : FILE OF SB_Information;
BEGIN
  IF PARAMCOUNT = 0 THEN CommandHelp;
  FILLCHAR(SB,SIZEOF(SB),0);
  FOR Loop := 1 TO PARAMCOUNT DO BEGIN
    TempParam := AllCaps(PARAMSTR(Loop));
    IF (TempParam[1] = '/') OR (TempParam[1] = '-') THEN BEGIN
      CASE TempParam[2] OF
        'P' : BEGIN
                SB.Address := AllCaps(COPY(TempParam,3,255));
                SB.Address := StripBoth(SB.Address,'$');
              END;
        'I' : BEGIN
                SB.IRQ     := AllCaps(COPY(TempParam,3,255));
              END;
        'D' : BEGIN
                SB.DMA     := AllCaps(COPY(TempParam,3,255));
              END;
        'B' : BlankScreen  := TRUE;
        '?' : CommandHelp;
        'H' : CommandHelp;
       {ELSE BEGIN
          CommandHelp;
        END;}
      END;
    END ELSE BEGIN
      IF FExist(PARAMSTR(1)) THEN BEGIN
        FName := AllCaps(PARAMSTR(1));
      END ELSE CommandHelp;
    END;
  END;
  IF (SB.Address = '') OR (SB.IRQ = '') OR (SB.DMA = '') THEN BEGIN
    IF FExist(GetFilePath(PARAMSTR(0)) +  'MAXSOUND.CFG') THEN BEGIN
      ASSIGN(F,GetFilePath(PARAMSTR(0)) + 'MAXSOUND.CFG');
      RESET(F);
      READ(F,SB);
      CLOSE(F);
    END ELSE CommandHelp;
  END;
END;

PROCEDURE DoVOC;
BEGIN
  IF NOT BlankScreen THEN BEGIN
    SetUpScreen;
    IceText(1,7,'VOC File Name: ' + FName);
  END;
  InitVocUnit(SB.Address,SB.IRQ,SB.DMA);
  PlayVOC(FName);
  IF NOT BlankScreen THEN BEGIN
    ShowCursor;
    GOTOXY(1,8);
  END;
END;

PROCEDURE DoWAV;
BEGIN
  IF NOT BlankScreen THEN BEGIN
    SetUpScreen;
    IceText(1,7,'WAV File Name: ' + FName);
  END;
  InitWavUnit(SB.Address,SB.IRQ,SB.DMA,'');
  PlayWAV(FName);
  IF NOT BlankScreen THEN BEGIN
    ShowCursor;
    GOTOXY(1,8);
  END;
END;

PROCEDURE DoMOD;
VAR
  Starting,Ending,Diff : LONGINT;
BEGIN
  IF NOT BlankScreen THEN BEGIN
    SetUpScreen;
    Starting := MEMAVAIL;
    IceText(1,7,'  MOD File Name: ' + FName);
    IceText(1,8,'Starting Memory: ' + IntToStr(Starting));
  END;
  InitModUnit(SB.Address,SB.IRQ);
  PlayMOD(FName);
  IF NOT BlankScreen THEN BEGIN
    Ending := MEMAVAIL;
    Diff   := Starting - Ending;
    IceText(1,9, '  Ending Memory: ' + IntToStr(Ending));
    IceText(1,10,'     Difference: ' + IntToStr(Diff));
    IceText(1,12,'Press any key to stop playing...');
  END;
  REPEAT UNTIL (KEYPRESSED) OR (NOT ModPlaying);
  ClearKeyBuffer;
  IF ModPlaying THEN ModShutDown;
  IF NOT BlankScreen THEN BEGIN
    ShowCursor;
    GOTOXY(1,13);
  END;
END;

BEGIN
  ProgramName := 'MAXSOUND.EXE v2.11';
  ProgramDesc := 'MAX Graphics VOC/WAV/MOD Sound File Player';
  DoCommandLine;
  IF POS('.VOC',FName) > 0 THEN DoVOC ELSE
  IF POS('.WAV',FName) > 0 THEN DoWAV ELSE
  IF POS('.MOD',FName) > 0 THEN DoMOD;
END.
