{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
{.$I APDEFINE.INC}
{.$M 16384,0,655360}
UNIT MAXCOMPT; {Text Mode Version}

INTERFACE

TYPE V_Buffer    = ARRAY[1..4000] OF BYTE;

VAR
  FMask : STRING[12];

PROCEDURE MakeArchive(FN : STRING);
PROCEDURE ExtractArchive(FN : STRING);
PROCEDURE BlindMake(FN : STRING);
PROCEDURE BlindExtract(FN : STRING);

IMPLEMENTATION

USES DOS,GUI_UTIL,ApMisc,ApArchiv,ApZip;

CONST
  DVseg      : WORD    = $B800;
  DVofs      : WORD    = $0000;

VAR
  VBuff    : ^V_Buffer;

{$L STRING2}
FUNCTION Replicate(Ch : CHAR; Count : WORD) : STRING; EXTERNAL;

PROCEDURE DVWrite(X,Y : WORD ; Attr : BYTE; S : STRING); Assembler;
Asm
  push ds
  mov bx,[y]
  DEC bx
  SHL bx,1
  mov ax,bx
{$ifopt G+}
  SHL bx,2
{$else}
  SHL bx,1
  SHL bx,1
{$endif}
  add ax,bx
  add ax,[DVseg]
  mov es,ax
  mov di,[x]
  DEC di
  SHL di,1
  add di,[DVofs]
  lds si,s
  mov cl,BYTE PTR [si]
  INC si
  mov ah,attr
@1 :
  mov al,BYTE PTR [si]
  mov WORD PTR es : [di],ax
  INC si
  add di,2
  DEC cl
  jnz @1
  pop ds
END;

PROCEDURE OutTextXY(X,Y,F,B : BYTE; S : STRING);
BEGIN
  DVWrite(X,Y,(B * 16) + F,S);
END;

PROCEDURE SaveScreen;
BEGIN
  IF VBuff <> NIL THEN EXIT;
  NEW(VBuff);
  MOVE(Mem[$B800 : 0000],VBuff^,4000);
END;

PROCEDURE RestoreScreen;
BEGIN
  IF VBuff = NIL THEN EXIT;
  MOVE(VBuff^,Mem[$B800 : 0000],4000);
  DISPOSE(VBuff);
  VBuff := NIL;
END;

PROCEDURE Shadow(x1,y1,x2,y2 : WORD);
VAR
  xshad   : WORD;
  yshad   : WORD;
  x       : WORD;
  y       : WORD;
  Loop    : WORD;
BEGIN
  x := ((y2 * 160) + (x1 * 2)) + 1;
  FOR Loop := x1 TO x2 DO BEGIN
    Mem[SegB800 : x] := 8;
    INC(x,2);
  END;
  y := ((y1 * 160) + ((x2) * 2)) + 1;
  FOR Loop := y1 TO y2 DO BEGIN
    Mem[SegB800 : y] := 8;
    INC(y,160);
  END;
END;

PROCEDURE DrawWindow(x1,y1,x2,y2 : BYTE; Title : STRING);
VAR
  Temp : STRING;
  Loop : BYTE;
BEGIN
  SaveScreen;
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(Title[1],Temp[2],LENGTH(Title));
  Temp[0] := CHR(x2 - x1 + 1);
  OutTextXY(x1,y1,15,3,Temp);
  Shadow(x1,y1,x2,y2);
  Temp := '' + Replicate('',x2 - x1 - 1);
  OutTextXY(x1,y1 + 1,9,1,Temp);
  OutTextXY(x2,y1 + 1,0,1,'');
  FOR Loop := y1 + 2 TO y2 - 1 DO BEGIN
    OutTextXY(x1,Loop,9,1,'' + Replicate(' ',x2 - x1 - 1));
    OutTextXY(x2,Loop,0,1,'');
  END;
  Temp := Replicate('',x2 - x1 - 1) + '';
  OutTextXY(x1,y2,9,1,'');
  OutTextXY(x1 + 1,y2,0,1,Temp);
END;

PROCEDURE KillWindow;
BEGIN
  RestoreScreen;
END;

PROCEDURE PutWindow(Stat : BYTE);
BEGIN
  IF Stat = 1 THEN DrawWindow(20,10,60,13,'Creating Archive')
              ELSE DrawWindow(20,10,60,13,'Extracting Archive');
END;

PROCEDURE MyMakeMethod(Method : BYTE ; FName : PathStr);
BEGIN
  OutTextXY(22,12,15,1,'Adding To Archive: ' + PadRight(GetFileName(FName),' ',12));
END;

PROCEDURE MyExtractMethod(Method : BYTE ; FName : PathStr);
BEGIN
  OutTextXY(22,12,15,1,'Extracting File: ' + PadRight(GetFileName(FName),' ',12));
END;

PROCEDURE MakeArchive(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  PutWindow(1);
  FErase(FN);
 {Initialize the file mask list and add masks}
  InitFileMaskList(FML);
  IF NOT AppendFileMask(FMask,FML) THEN BEGIN
   {WRITELN('Insufficient memory bub...');}
    KillWindow;
    EXIT;
  END;

 {Create a new ZIP file}
  CreateZipFile(FN);
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed to create archive, error: ', ArchiveStatus);}
    KillWindow;
    EXIT;
  END;

 {Set options}
  SetShowMethodProcZip(MyMakeMethod{DefShowMethodProcZip});
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}

 {Set compressing-only options}
 {SetOkToCompressFuncZip(DefOkToCompressFuncZip);}
 {SetCompressSuccessFuncZip(DefCompressSuccessFuncZip);}

 {Add the files the archive}
  CompressFileMaskListZip(FML);

 {Report errors}
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed due to error ',ArchiveStatus MOD 10000);}
  END;

 {Clean up}
  DoneFileMaskList(FML);
  DoneZipFile;
  KillWindow;
END;

PROCEDURE ExtractArchive(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  IF NOT FExist(FN) THEN BEGIN
   {WRITELN('Syntax: ZIPEXT ArchiveName');}
    EXIT;
  END;
  PutWindow(0);

 {create an empty file mask list}
  InitFileMaskList(FML);

 {open the ZIP file}
  InitZipFile(FN);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ', StatusStr(ArchiveStatus));}
    KillWindow;
    EXIT;
  END;

 {enable user hooks}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}
  SetShowMethodProcZip(MyExtractMethod{DefShowMethodProcZip});
 {SetExtractSuccessFuncZip(DefExtractSuccessFuncZip);}
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}

 {extract all files in archive}
  ExtractFileMaskListZip(FML);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ', StatusStr(ArchiveStatus));}
    KillWindow;
    EXIT;
  END;

 {close the ZIP file}
  DoneZipFile;

 {dispose of data structures}
  DoneFileMaskList(FML);
  KillWindow;
END;

PROCEDURE DummyMethod(Method : BYTE ; FName : PathStr);
BEGIN
END;

PROCEDURE BlindMake(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  FErase(FN);
 {Initialize the file mask list and add masks}
  InitFileMaskList(FML);
  IF NOT AppendFileMask(FMask,FML) THEN BEGIN
   {WRITELN('Insufficient memory bub...');}
    EXIT;
  END;

 {Create a new ZIP file}
  CreateZipFile(FN);
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed to create archive, error: ', ArchiveStatus);}
    EXIT;
  END;

 {Set options}
  SetShowMethodProcZip(DummyMethod{DefShowMethodProcZip});
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}

 {Set compressing-only options}
 {SetOkToCompressFuncZip(DefOkToCompressFuncZip);}
 {SetCompressSuccessFuncZip(DefCompressSuccessFuncZip);}

 {Add the files the archive}
  CompressFileMaskListZip(FML);

 {Report errors}
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed due to error ',ArchiveStatus MOD 10000);}
  END;

 {Clean up}
  DoneFileMaskList(FML);
  DoneZipFile;
END;

PROCEDURE BlindExtract(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  IF NOT FExist(FN) THEN BEGIN
   {WRITELN('Syntax: ZIPEXT ArchiveName');}
    EXIT;
  END;

 {create an empty file mask list}
  InitFileMaskList(FML);

 {open the ZIP file}
  InitZipFile(FN);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ',StatusStr(ArchiveStatus));}
    EXIT;
  END;

 {enable user hooks}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}
  SetShowMethodProcZip(DummyMethod{DefShowMethodProcZip});
 {SetExtractSuccessFuncZip(DefExtractSuccessFuncZip);}
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}

 {extract all files in archive}
  ExtractFileMaskListZip(FML);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ', StatusStr(ArchiveStatus));}
    EXIT;
  END;

 {close the ZIP file}
  DoneZipFile;

 {dispose of data structures}
  DoneFileMaskList(FML);
END;

BEGIN
  FMask := '*.*';
END.
