{$I DEFINES.INC}
{.$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
{.$I APDEFINE.INC}
{.$M 16384,0,655360}
UNIT MAXCOMPG; {SVGA Version}

INTERFACE

VAR
  FMask : STRING[12];

PROCEDURE MakeArchive(FN : STRING);
PROCEDURE ExtractArchive(FN : STRING);
PROCEDURE BlindMake(FN : STRING);
PROCEDURE BlindExtract(FN : STRING);

IMPLEMENTATION

USES DOS,GUI_UNIT,GUI_UTIL,FGMAIN,ApMisc,ApArchiv,ApZip;

VAR HomeDir : STRING[80];

PROCEDURE PutWindow(Stat : BYTE);
BEGIN
  GETDIR(0,HomeDir);
  MakeDir(HomeDir + '\$$SAVE$$');
  CHDIR(HomeDir + '\$$SAVE$$');
  HideMouse;
  IF Stat = 1 THEN Draw_Window(195,186,450,238,5,'Creating Archive:')
              ELSE Draw_Window(195,186,450,238,5,'Extracting Archive:');
  CHDIR(HomeDir);
  Show_Mem;
END;

PROCEDURE EraseWindow;
BEGIN
  CHDIR(HomeDir + '\$$SAVE$$');
  Kill_Window;
  CHDIR(HomeDir);
  RMDIR(HomeDir + '\$$SAVE$$');
END;

PROCEDURE MyMakeMethod(Method : BYTE ; FName : PathStr);
BEGIN
  FG_SetColor(C.Win1Back);
  FG_Rect(200,445,216,230);
  OutText_XY(204,216,1,2,'Adding To Archive: {0}' + GetFileName(FName));
END;

PROCEDURE MyExtractMethod(Method : BYTE ; FName : PathStr);
BEGIN
  FG_SetColor(C.Win1Back);
  FG_Rect(200,445,216,230);
  OutText_XY(204,216,1,2,'Extracting File: {0}' + GetFileName(FName));
END;

PROCEDURE MakeArchive(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  PutWindow(1);
  FErase(FN);
 {Initialize the file mask list and add masks}
  InitFileMaskList(FML);
  IF NOT AppendFileMask(FMask,FML) THEN BEGIN
   {OutText_XY(10,30,15,0,'Insufficient memory bub!');
    OutText_XY(10,50,15,0,'Press Any Key To Continue...');
    WRITE(^G);
    FG_WaitKey;}
    EraseWindow;
    EXIT;
  END;

 {Create a new ZIP file}
  CreateZipFile(FN);
  IF ArchiveStatus <> ecOk THEN BEGIN
   {OutText_XY(10,30,15,3,'Failed to create archive, error: ' + IntToStr(ArchiveStatus));
    OutText_XY(10,50,15,0,'Press Any Key To Continue...');
    WRITE(^G);
    FG_WaitKey;}
    EraseWindow;
    EXIT;
  END;

 {Set options}
  SetShowMethodProcZip(MyMakeMethod{DefShowMethodProcZip});
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}

 {Set compressing-only options}
 {SetOkToCompressFuncZip(DefOkToCompressFuncZip);}
 {SetCompressSuccessFuncZip(DefCompressSuccessFuncZip);}

 {Add the files the archive}
  CompressFileMaskListZip(FML);

 {Report errors}
  IF ArchiveStatus <> ecOk THEN BEGIN
   {OutText_XY(10,30,15,0,'Failed due to error ' + IntToStr(ArchiveStatus MOD 10000));
    OutText_XY(10,50,15,0,'Press Any Key To Continue...');
    WRITE(^G);
    FG_WaitKey;}
  END;

 {Clean up}
  DoneFileMaskList(FML);
  DoneZipFile;
  EraseWindow;
END;

PROCEDURE ExtractArchive(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  IF NOT FExist(FN) THEN EXIT;
  PutWindow(0);

 {create an empty file mask list}
  InitFileMaskList(FML);

 {open the ZIP file}
  InitZipFile(FN);
  IF ArchiveStatus <> 0 THEN BEGIN
   {OutText_XY(10,30,15,0,'Error: ' + StatusStr(ArchiveStatus));
    OutText_XY(10,50,15,0,'Press Any Key To Continue...');
    WRITE(^G);
    FG_WaitKey;}
    EraseWindow;
    EXIT;
  END;

 {enable user hooks}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}
  SetShowMethodProcZip(MyExtractMethod{DefShowMethodProcZip});
 {SetExtractSuccessFuncZip(DefExtractSuccessFuncZip);}
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}

 {extract all files in archive}
  ExtractFileMaskListZip(FML);
  IF ArchiveStatus <> 0 THEN BEGIN
   {OutText_XY(10,30,15,0,'Error: ' + StatusStr(ArchiveStatus));
    OutText_XY(10,50,15,0,'Press Any Key To Continue...');
    WRITE(^G);
    FG_WaitKey;}
    EraseWindow;
    EXIT;
  END;

 {close the ZIP file}
  DoneZipFile;

 {dispose of data structures}
  DoneFileMaskList(FML);
  EraseWindow;
END;

PROCEDURE DummyMethod(Method : BYTE ; FName : PathStr);
BEGIN
END;

PROCEDURE BlindMake(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  FErase(FN);
 {Initialize the file mask list and add masks}
  InitFileMaskList(FML);
  IF NOT AppendFileMask(FMask,FML) THEN BEGIN
   {WRITELN('Insufficient memory bub...');}
    EXIT;
  END;

 {Create a new ZIP file}
  CreateZipFile(FN);
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed to create archive, error: ', ArchiveStatus);}
    EXIT;
  END;

 {Set options}
  SetShowMethodProcZip(DummyMethod{DefShowMethodProcZip});
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}

 {Set compressing-only options}
 {SetOkToCompressFuncZip(DefOkToCompressFuncZip);}
 {SetCompressSuccessFuncZip(DefCompressSuccessFuncZip);}

 {Add the files the archive}
  CompressFileMaskListZip(FML);

 {Report errors}
  IF ArchiveStatus <> ecOk THEN BEGIN
   {WRITELN('Failed due to error ',ArchiveStatus MOD 10000);}
  END;

 {Clean up}
  DoneFileMaskList(FML);
  DoneZipFile;
END;

PROCEDURE BlindExtract(FN : STRING);
VAR
  FML : FileMaskList;
BEGIN
  IF NOT FExist(FN) THEN BEGIN
   {WRITELN('Syntax: ZIPEXT ArchiveName');}
    EXIT;
  END;

 {create an empty file mask list}
  InitFileMaskList(FML);

 {open the ZIP file}
  InitZipFile(FN);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ',StatusStr(ArchiveStatus));}
    EXIT;
  END;

 {enable user hooks}
 {SetShowCommentsProcZip(DefShowCommentsProcZip);}
  SetShowMethodProcZip(DummyMethod{DefShowMethodProcZip});
 {SetExtractSuccessFuncZip(DefExtractSuccessFuncZip);}
 {SetShowProgressFuncZip(DefShowProgressFuncZip);}

 {extract all files in archive}
  ExtractFileMaskListZip(FML);
  IF ArchiveStatus <> 0 THEN BEGIN
   {WRITELN('Error: ', StatusStr(ArchiveStatus));}
    EXIT;
  END;

 {close the ZIP file}
  DoneZipFile;

 {dispose of data structures}
  DoneFileMaskList(FML);
END;

BEGIN
  FMask := '*.*';
END.
