{$I DEFINES.INC}
PROGRAM MAXCOMP;

USES MYCRT, MAXCOMPT, GUI_UTIL;

CONST
  BlankScreen : BOOLEAN = FALSE;

VAR
  ArcName     : STRING;
  TheMode     : STRING[1];
  BStr        : STRING[1];

PROCEDURE IceText(X,Y : BYTE ; S : STRING);
VAR
  TLength : BYTE;
  Loop    : BYTE;
BEGIN
  TLength  := LENGTH(S);
  FOR Loop := 1 TO TLength DO BEGIN
    IF (ORD(S[Loop]) >= 65) AND (ORD(S[Loop]) <= 90) THEN OutTextXY(X + (Loop - 1),Y,15,0,S[Loop]) ELSE
    IF (ORD(S[Loop]) >= 97) AND (ORD(S[Loop]) <= 122) THEN OutTextXY(X + (Loop - 1),Y,11,0,S[Loop]) ELSE
    IF (ORD(S[Loop]) > 127) OR (ORD(S[Loop]) < 32) THEN OutTextXY(X + (Loop - 1),Y,1,0,S[Loop]) ELSE
    OutTextXY(X + (Loop - 1),Y,9,0,S[Loop]);
  END;
END;

PROCEDURE SetUpScreen;
BEGIN
  CLRSCR;
  HideCursor;
  IceText(1,1,PadRight(#196,#196,79));
  IceText(1,2,ProgramName);
  IceText(1,3,'MAX Graphics Resource File Packager/Compressor');
  IceText(1,4,'Copyright 1995-Current  Larry L. Athey  BBS Utiliteez Software');
  IceText(1,5,PadRight(#196,#196,79));
END;

PROCEDURE CommandHelp;
BEGIN
  SetUpScreen;
  IceText(1,7,'  Compress Example: MAXCOMP.EXE FILENAME.PKG Compress');
  IceText(1,9,'Decompress Example: MAXCOMP.EXE FILENAME.PKG Decompress');
  IceText(1,24,'Press Almost Any Key To Continue...');
  READKEY;
  SetUpScreen;
  IceText(1,7,'Dude....Like....Whoops....Command Line Error....Try Again....');
  ShowCursor;
  GOTOXY(1,9);
  HALT;
END;

BEGIN
  ProgramName := 'MAXCOMP.EXE v2.11';
  IF PARAMCOUNT < 2 THEN CommandHelp;
  ArcName := AllCaps(PARAMSTR(1));
  TheMode := AllCaps(PARAMSTR(2));
  BStr    := AllCaps(PARAMSTR(3));
  IF POS('.',ArcName) = 0 THEN ArcName := ArcName + '.PKG';
  IF (TheMode <> 'C') AND (TheMode <> 'D') THEN CommandHelp;
  IF (TheMode = 'D') AND (NOT FExist(ArcName)) THEN CommandHelp;
  IF BStr = 'B' THEN BlankScreen := TRUE;
  IF NOT BlankScreen THEN BEGIN
    HideCursor;
    IF TheMode = 'C' THEN MakeArchive(ArcName) ELSE ExtractArchive(ArcName);
    ShowCursor;
  END ELSE BEGIN
    IF TheMode = 'C' THEN BlindMake(ArcName) ELSE BlindExtract(ArcName);
  END;
END.
