{$I DEFINES.INC}
UNIT GUI_UTIL; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).
  }

INTERFACE

{.$DEFINE Opro}

{$IFDEF Opro}
  USES OPEXEC, DOS;
{$ELSE}
  USES EXEC, DOS;
{$ENDIF}

CONST      {Operating system detection constants.                            }
 _DOS = 0; {DOS                                                              }
  OS2 = 1; {OS/2                                                             }
  WIN = 2; {Windows                                                          }
  DV  = 3; {DesqView                                                         }

VAR
  OS              : BYTE;       {The current operating system detected.      }
  ProgramVersion  : STRING[10]; {The version of your program.                }
  ProgramName     : STRING[40]; {The name of your program.                   }

FUNCTION AllCaps(S : STRING) : STRING;
FUNCTION Lower(S : STRING) : STRING;
FUNCTION BooleanToStr(B : BOOLEAN) : STRING;
FUNCTION BoolToStr(B : BOOLEAN) : STRING;
FUNCTION StrToBool(S : STRING) : BOOLEAN;
FUNCTION IntToStr(N : LONGINT) : STRING;
FUNCTION StrToInt(S : STRING) : LONGINT;
FUNCTION HexToInt(HexStr : STRING) : LONGINT;
FUNCTION StripLead(St : STRING; Ch : CHAR) : STRING;
FUNCTION StripTrail(St : STRING; Ch : CHAR) : STRING;
FUNCTION StripBoth(St : STRING; Ch : CHAR) : STRING;
FUNCTION Center(St : STRING; MaxPlace : BYTE) : STRING;
FUNCTION PadRight(S : STRING; Ch : CHAR; Len : BYTE) : STRING;
FUNCTION PadLeft(S : STRING; Ch : CHAR; Len : BYTE) : STRING;
FUNCTION FSize(Fn : PathStr) : LONGINT;
FUNCTION FExist(Fn : PathStr) : BOOLEAN;
FUNCTION FErase(Fn : PathStr) : BOOLEAN;
FUNCTION DExist(Fn : PathStr) : BOOLEAN;
FUNCTION CopyFile(SourceFile,TargetFile : STRING) : BYTE;
FUNCTION GetFileName(InString : STRING) : STRING;
FUNCTION GetFilePath(InString : STRING) : STRING;
FUNCTION FixPath(Txt : STRING) : STRING;
FUNCTION NoPath(Txt : STRING) : STRING;
FUNCTION OSstr : STRING;

PROCEDURE MakeDir(DirName : STRING);
PROCEDURE TimeSlice;
PROCEDURE DetectOS;
PROCEDURE ClearKeyBuffer;
PROCEDURE Execute(FName,Params : STRING);
PROCEDURE DropToDOS;

IMPLEMENTATION

{}
FUNCTION AllCaps(S : STRING) : STRING;
VAR
  SLen : BYTE ABSOLUTE S;
  X    : INTEGER;
BEGIN
  FOR X := 1 TO SLen DO S[X] := UPCASE(S[X]);
  AllCaps := S;
END;
{}
FUNCTION Lower(S : STRING) : STRING;
VAR
  SLen : BYTE ABSOLUTE S;
  I    : INTEGER;
FUNCTION LoCase(Ch : CHAR) : CHAR;
BEGIN
  IF (Ch IN ['A'..'Z']) THEN LoCase := CHR(ORD(Ch) + 32) ELSE LoCase := Ch;
END;
BEGIN
  FOR I := 1 TO SLen DO S[I] := LoCase(S[I]);
  Lower := S;
END;
{}
FUNCTION BooleanToStr(B : BOOLEAN) : STRING;
BEGIN
  IF B THEN BooleanToStr := 'True' ELSE BooleanToStr := 'False';
END;
{}
FUNCTION BoolToStr(B : BOOLEAN) : STRING;
BEGIN
  IF B THEN BoolToStr := 'Y' ELSE BoolToStr := 'N';
END;
{}
FUNCTION StrToBool(S : STRING) : BOOLEAN;
BEGIN
  S := StripBoth(S,' ');
  S := AllCaps(S);
  IF POS('Y',S) = 1 THEN StrToBool := TRUE ELSE StrToBool := FALSE;
END;
{}
FUNCTION IntToStr(N : LONGINT) : STRING;
VAR
  St : STRING;
BEGIN
  STR(N,St);
  IntToStr := St;
END;
{}
FUNCTION StrToInt(S : STRING) : LONGINT;
VAR
  L : LONGINT;
  U : INTEGER;
BEGIN
  VAL(S,L,U);
  StrToInt := L;
END;
{}
FUNCTION HexToInt(HexStr : STRING) : LONGINT;
VAR
  I,HexNibble : WORD;
  Temp        : LONGINT;
  Code        : INTEGER;
BEGIN
  Temp   := 0;
  HexStr := AllCaps(HexStr);
  FOR I := LENGTH(HexStr) DOWNTO 1 DO IF NOT (HexStr[I] IN ['0'..'9','A'..'F']) THEN DELETE(HexStr,I,1);
  FOR I := LENGTH(HexStr) DOWNTO 1 DO BEGIN
    IF HexStr[I] IN ['0'..'9'] THEN HexNibble := BYTE(HexStr[I]) - BYTE('0')
                               ELSE HexNibble := BYTE(HexStr[I]) - BYTE('A') + 10;
    INC(Temp,LONGINT(HexNibble) * (1 SHL (4 * (LONGINT(LENGTH(HexStr)) - I))));
  END;
  HexToInt := Temp;
END;
{}
FUNCTION StripLead(St : STRING; Ch : CHAR) : STRING;
VAR
  TempStr : STRING;
BEGIN
  TempStr := St;
  WHILE ((TempStr[1] = Ch) AND (LENGTH(TempStr) > 0)) DO TempStr := COPY(TempStr,2,LENGTH(TempStr));
  StripLead := TempStr;
END;
{}
FUNCTION StripTrail(St : STRING; Ch : CHAR) : STRING;
VAR
  TempStr : STRING;
  I       : INTEGER;
BEGIN
  TempStr := St;
  I := LENGTH(St);
  WHILE ((I > 0) AND (St[I] = Ch)) DO I := I - 1;
  TempStr[0] := CHR(I);
  StripTrail := TempStr;
END;
{}
FUNCTION StripBoth(St : STRING; Ch : CHAR) : STRING;
BEGIN
  StripBoth := StripTrail(StripLead(St,Ch),Ch);
END;
{}
FUNCTION Center(St : STRING; MaxPlace : BYTE) : STRING;
CONST
  JustChar : CHAR = ' ';
VAR
  Temp : STRING;
  Num  : BYTE;

FUNCTION Dup(Ch : CHAR; Times : BYTE) : STRING;
VAR
  Temp : STRING;
BEGIN
  FILLCHAR(Temp[1],Times,Ch);
  Temp[0] := CHAR(Times);
  Dup := Temp;
END;

BEGIN
  Num    := (MaxPlace DIV 2) - (LENGTH(St) DIV 2);
  Temp   := Dup(JustChar,Num);
  Temp   := Temp + St;
  Temp   := Temp + Dup(JustChar,MaxPlace - Num - LENGTH(St));
  Center := Temp;
END;
{}
FUNCTION PadRight(S : STRING; Ch : CHAR; Len : BYTE) : STRING;
BEGIN
  WHILE LENGTH(S) < Len DO S := S + Ch;
  PadRight := S;
END;
{}
FUNCTION PadLeft(S : STRING; Ch : CHAR; Len : BYTE) : STRING;
BEGIN
  WHILE LENGTH(S) < Len DO S := Ch + S;
  PadLeft := S;
END;
{}
FUNCTION FSize(Fn : PathStr) : LONGINT;
VAR
  F : FILE;
BEGIN
  ASSIGN(F,Fn);
  RESET(F,1);
  IF IORESULT = 0 THEN BEGIN
    FSize := FILESIZE(F);
    CLOSE(F);
  END;
END;
{}
FUNCTION FExist(Fn : PathStr) : BOOLEAN;
VAR
  DirInfo : SEARCHREC;
BEGIN
  FINDFIRST(Fn,Anyfile - Directory - VolumeID,DirInfo);
  FExist := DOSERROR = 0;
END;
{}
FUNCTION FErase(Fn : PathStr) : BOOLEAN;
VAR
  F : FILE;
BEGIN
  ASSIGN(F,Fn);
  ERASE(F);
  FErase := IORESULT = 0;
END;
{}
FUNCTION DExist(Fn : PathStr) : BOOLEAN;
VAR
  OrgDir : PathStr;
BEGIN
  GETDIR(0,OrgDir);
  Fn := NoPath(FExpand(Fn));
  CHDIR(Fn);
  DExist := IORESULT = 0;
  CHDIR(OrgDir);
END;
{}
FUNCTION CopyFile(SourceFile,TargetFile : STRING) : BYTE;
{ Return Codes:  0 Successful
                 1 Source and target the same
                 2 Cannot open source
                 3 Unable to create target
                 4 Error during copy }
TYPE File_Buffer = ARRAY[0..32766] OF BYTE;
VAR
  Source,
  Target  : FILE;
  BRead,
  BWrite  : WORD;
  FileBuf : ^File_Buffer;
 {FileBuf : ARRAY[1..2048] OF CHAR;}
BEGIN
  SourceFile := StripBoth(SourceFile,' ');
  TargetFile := StripBoth(TargetFile,' ');
  IF SourceFile = TargetFile THEN BEGIN
    CopyFile := 1;
    EXIT;
  END;
  ASSIGN(Source,SourceFile);
  RESET(Source,1);
  IF IORESULT <> 0 THEN BEGIN
    CopyFile := 2;
    EXIT;
  END;
  ASSIGN(Target,TargetFile);
  REWRITE(Target,1);
  IF IORESULT <> 0 THEN BEGIN
    CopyFile := 3;
    EXIT;
  END;
  NEW(FileBuf);
  REPEAT
    FILLCHAR(FileBuf^,SIZEOF(FileBuf^),0);
    BLOCKREAD(Source,FileBuf^,SIZEOF(FileBuf^),BRead);
    BLOCKWRITE(Target,FileBuf^,BRead,BWrite);
  UNTIL (BRead = 0) OR (BRead <> BWrite);
  DISPOSE(FileBuf);
  CLOSE(Source);
  CLOSE(Target);
  IF BRead <> BWrite THEN CopyFile := 4 ELSE CopyFile := 0;
END;
{}
FUNCTION GetFileName(InString : STRING) : STRING;
VAR
  Work : BYTE;
BEGIN
  InString := StripBoth(InString,' ');
  REPEAT
    Work := POS('\',InString);
    IF Work <> 0 THEN DELETE(InString,1,Work);
  UNTIL Work = 0;
  GetFileName := InString;
END;
{}
FUNCTION GetFilePath(InString : STRING) : STRING;
VAR
  Loop : BYTE;
BEGIN
  InString := StripBoth(InString,' ');
  IF InString[LENGTH(InString)] = '\' THEN BEGIN
    GetFilePath := InString;
    EXIT;
  END;
  Loop := LENGTH(InString);
  REPEAT DEC(Loop) UNTIL ((Loop = 0) OR (InString[Loop] = '\'));
  IF Loop <> 0 THEN DELETE(InString,Loop + 1,LENGTH(InString) - Loop) ELSE InString := '';
  GetFilePath := InString;
END;
{}
FUNCTION FixPath(Txt : STRING) : STRING;
VAR
  Loop,EndCh : BYTE;
BEGIN
  Txt := StripBoth(Txt,' ');
  EndCh := LENGTH(Txt);
  FOR Loop := 1 TO LENGTH(Txt) DO Txt[Loop] := UPCASE(Txt[Loop]);
  IF Txt[EndCh] <> '\' THEN Txt := Txt + '\';
  FixPath := Txt;
END;
{}
FUNCTION NoPath(Txt : STRING) : STRING;
VAR
  Work : BYTE;
BEGIN
  Txt := StripBoth(Txt,' ');
  Txt := StripTrail(Txt,'\');
  NoPath := Txt;
END;
{}
FUNCTION OSstr : STRING;
BEGIN
  CASE OS OF
    _DOS : OsStr := 'DOS';
    DV   : OsStr := 'DesqView';  {Good luck getting DV and SVGA to work!}
    WIN  : OsStr := 'MS Windows';
    OS2  : OsStr := 'IBM OS/2';
  END;
END;
{}
PROCEDURE MakeDir(DirName : STRING);
BEGIN
  DirName := NoPath(AllCaps(DirName));
  IF NOT DExist(DirName) THEN MKDIR(DirName);
END;
{}
PROCEDURE DetectOS; Assembler;
Asm
  MOV OS, _DOS  { Default DOS }
  MOV AH, 30H   { AH = 30h }
  INT 21H       { DOS version }
  CMP AL, 14H
  JAE @IBMOS2   { Jump if >= to 20 }

  MOV AX,2B01H
  MOV CX,4445H
  MOV DX,5351H
  INT 21H       { Desqview Installed? }
  CMP AL, 255
  JNE @DesqView { Jump if AL <> 255 }

  MOV AX,160AH
  INT 2FH       { WinDoze Installed?}
  CMP AX, 0H
  JE  @Windows  { If = Jump to WinDoze }

  JMP @FINISH   { Nothing found, jump to the end }

@IBMOS2 :
  MOV OS, Os2   { Set OS Value }
  JMP @FINISH

@DesqView :
  MOV OS, Dv    { Set OS Value }
  JMP @FINISH

@Windows :
  MOV OS, Win   { Set OS Value }
  JMP @FINISH

@FINISH :
END;
{}
PROCEDURE TimeSlice; Assembler;
Asm
  CMP OS,_DOS   { Compare to DOS }
  JE @__DOS     { Jump if = }
  CMP OS,DV     { Compare to DesqView }
  JE @DESQVIEW  { Jump if = }
  CMP OS, WIN   { Compare to WinDoze }
  JE @WIN       { Jump if = }
  CMP OS, OS2   { Compare to OS/2 }
  JE @OS2       { Jump if = }
  JMP @NONE     { None found, Jump to End, Crapsky! }

@__DOS :
  INT  28H       { Call Interupt 28H }
  JMP  @NONE     { Jump to the end }

@DESQVIEW :
  MOV  AX,1000H
  INT  15H       { Call Interupt 15H for DesqView TimeSlice }
  JMP  @NONE     { Jump to the end }

@WIN :
  MOV  AX,1680H
  INT  2FH       { Call Interupt 2FH for WinDoze TimeSlice }
  JMP  @NONE

@OS2 :
  PUSH DX
  XOR  DX,DX
  MOV  AX,33H
  STI
  HLT           { Use CPU halt instruction for OS/2 TimeSlice }
  DB   035H,0CAH
  POP  DX
  JMP  @NONE

@NONE :         { Why the hell would we be here anyway? }
END;
{}
PROCEDURE ClearKeyBuffer;
BEGIN
  MemW[$0000 : $041C] := MemW[$0000 : $041A];
END;
{}
FUNCTION LocateFile(FName : STRING) : STRING;
VAR
  F : STRING;
BEGIN
  IF NOT FExist(FName) THEN BEGIN
    F := FSearch(FName,GetEnv('PATH'));
    LocateFile := FExpand(F);
    EXIT;
  END ELSE LocateFile := FName;
END;
{}
PROCEDURE Execute(FName,Params : STRING);
VAR
  ThisDir : STRING;
BEGIN
  GETDIR(0,ThisDir);
  FName := LocateFile(FName);
 {$IFDEF Opro}
  ExecDosSwap(FName + ' ' + Params,TRUE,NIL,'$$GUI$$.SWP');
 {$ELSE}
 {Do_Exec(GetEnv('COMSPEC'),' /C ' + FName,Use_All,$ffff,TRUE);}
  Do_Exec(FName,Params,USE_ALL,$FFFF,TRUE);
 {$ENDIF}
  CHDIR(ThisDir);
END;
{}
PROCEDURE DropToDOS;
VAR
  ThisDir : STRING;
BEGIN
  GETDIR(0,ThisDir);
 {$IFDEF Opro}
  ExecDosSwap('',TRUE,NIL,'$$GUI$$.SWP');
 {$ELSE}
  PutEnv('PROMPT=Type: EXIT and press <ENTER> to return to '+ProgramName+' '+ProgramVersion+'!$_$p$g');
 {Do_Exec(GetEnv('COMSPEC'),' /C ' + GetEnv('COMSPEC'),Use_All,$ffff,TRUE);}
  Do_Exec(GetEnv('COMSPEC'),'',Use_All,$ffff,TRUE);
 {$ENDIF}
  CHDIR(ThisDir);
END;
{}
BEGIN
 {$IFDEF Opro}
  UseXmsIfAvailable := TRUE;
  SetSwapMsgOn(FALSE);
 {$ENDIF}
END.
