{$I DEFINES.INC}
UNIT GUI_UNIT; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).


  NOTE: This unit is dependent on the FastGraph or FastGraph/Light graphics
        library...This unit can be converted to use Borland's slow-poke BGI
        graphics interface, but will require a lot of modifications. If you
        are not familiar with the procedure and function names in FastGraph
        or FastGraph/Light...Well...I hope you're real ambitious... :)

  ALSO: Yes, this unit does everything in real mode. I've seen too many odd
        things happen in my own and other's protected mode programs, I just
        don't trust it...If you want to convert this unit to use DPMI mode,
        have at it...Real mode works just fine for me and my needs...  :)

  PLUS: Yes, you're right again...This sucker isn't object oriented either.
        I guess this whole mess just makes me either the crappiest, or just
        the damn laziest programmer in the world. Hey, it's free, it works,
        and it get the job done for me, that's all I care about...  :)

}

INTERFACE

{}
TYPE GUI_Color_Scheme = RECORD  {Record for the SVGA color scheme.           }
     Win1Back,                  {Window type 1 background.                   }
     Win4Back,                  {Window type 4 background.                   }
     Win1High,                  {Window type 1 highlight.                    }
     Win4High,                  {Window type 4 highlight.                    }
     Win1Low,                   {Window type 1 lowlight.                     }
     Win4Low,                   {Window type 4 lowlight.                     }
     Win1Frame1,                {Window type 1 frame high.                   }
     Win1Frame2,                {Window type 1 frame low.                    }
     Win4Frame,                 {Window type 4 frame.                        }
     ActiveHdr,                 {Color for active window headers.            }
     InactiveHdr,               {Color for inactive window headers.          }
     HdrTitle,                  {Window header title color.                  }
     ButtonFrame,               {Button frame color.                         }
     ButtonFace,                {Button background.                          }
     ButtonHigh,                {Button highlight.                           }
     ButtonLow,                 {Button lowlight.                            }
     ButtonHot,                 {Button hotkey color.                        }
     ButtonText,                {Button title color.                         }
     FrameLow,                  {Frame lowlight.                             }
     FrameHigh,                 {Frame highlight.                            }
     BoxBack,                   {Raised/Lowered box background.              }
     BoxHigh,                   {Raised/Lowered box highlight.               }
     BoxLow,                    {Raised/Lowered box lowlight.                }
     FieldTextHigh,             {Active entry field text color.              }
     FieldTextLow,              {Inactive entry field text color.            }
     FieldBack,                 {Entry field background.                     }
     QuoteColor,                {Color for BBS message quotes.               }
     MsgColor,                  {Color for BBS message text.                 }
     TearColor,                 {Color for BBS message tear lines.           }
     FlagColor,                 {Color for BBS message flags.                }
     MsgIDcolor,                {Color for BBS message ID info.              }
     TextBack,                  {Background color for reader/editor/picklist.}
     PickHighBack,              {Picklist item highlight background color.   }
     PickHighFore,              {Picklist item highlight foreground color.   }
     ScreenColor  : BYTE;       {Screen background color.                    }
     END;
{}
TYPE WindowRecord = RECORD      {Record for window settings.                 }
     X1,Y1,X2,Y2  : INTEGER;    {Window coordinates.                         }
     WType        : BYTE;       {Window type.                                }
     Title        : STRING;     {Window title.                               }
     END;
{}
TYPE ButtonRecord = RECORD      {Record for button settings.                 }
     ButtonType   : BYTE;       {Type of button for the current record.      }
     X,Y,Width    : INTEGER;    {Button X/Y coordinates and width.           }
     Height       : INTEGER;    {Button height in pixels                     }
     Title        : STRING[30]; {Button title.                               }
     ButStr       : STRING[20]; {Button hotkey extension string.             }
     Sound        : STRING[12]; {Button sound attachment file name.          }
     Return       : BYTE;       {Return code (ie: Ordinal Character Value).  }
     Holdable     : BOOLEAN;    {Is the button holdable?                     }
     HasIcon      : BOOLEAN;    {Is there an icon on the button?             }
     FieldOn      : BOOLEAN;    {If mouse field, is the field visible?       }
     Icon         : BYTE;       {Main icon record location.                  }
     Flip         : BYTE;       {Secondary icon record location.             }
     IX,IY        : INTEGER;    {Icon X/Y coordinates.                       }
     END;
{}
TYPE Button_Array = ARRAY[1..128] OF ButtonRecord;{Array of buttons.         }
{}
TYPE FieldRecord  = RECORD      {Record for entry field settings.            }
     X,Y          : INTEGER;    {Field X/Y coordinates.                      }
     Text         : STRING;     {Entry field text.                           }
     EType        : BYTE;       {Entry field type.                           }
     ELength      : BYTE;       {Character width of entry field.             }
     CursorPos    : BYTE;       {Entry field cursor position.                }
     Active       : BOOLEAN;    {Is this the currently selected field?       }
     Width        : INTEGER;    {Entry field pixel width.                    }
     Size         : BYTE;       {Entry field font size (0 or 1).             }
     END;
{}
TYPE Field_Array  = ARRAY[1..128] OF FieldRecord;{Array of entry fields.     }
{}
TYPE Pick_List    = ARRAY[1..800] OF STRING[77];
{^ This is the array in memory that holds the text for picklist items.       }
{}
TYPE Pick_Info    = RECORD      {Record for the picklist settings.           }
     Active       : BOOLEAN;    {Has the picklist been activated?            }
     Running      : BOOLEAN;    {Is the picklist running?                    }
     X,Y          : INTEGER;    {Picklist X/Y coordinates.                   }
     Top          : INTEGER;    {Default selected item at the top of the list}
     NumItems     : INTEGER;    {Total number of items in the picklist.      }
     ItemsOnScrn  : INTEGER;    {Number of items displayed on the screen.    }
     Current      : INTEGER;    {The currently selected picklist item.       }
     MaxChars     : BYTE;       {Character width of the picklist.            }
     Locator      : INTEGER;    {PickList locator position.                  }
     Item         : ARRAY[1..30] OF WORD;{Item index in the picklist window. }
     Width        : INTEGER;    {The right most location of the picklist.    }
     Bottom       : INTEGER;    {The bottom most location of the picklist.   }
     END;
{}
TYPE PalScroller  = RECORD      {Record for the color palette scroller.      }
     Active       : BOOLEAN;    {Has the palette scroller been activated?    }
     X,Y          : INTEGER;    {X/Y coordinates of the palette scroller.    }
     Top          : BYTE;       {Color value of the top scroller element.    }
     Current      : BYTE;       {The currently selected palette color.       }
     Item         : ARRAY[1..16] OF WORD;{Item index in the palette scroller.}
     Width        : INTEGER;    {The right most location of the scroller.    }
     Bottom       : INTEGER;    {The bottom most location of the scroller.   }
     END;
{}
TYPE Text_Buffer  = ARRAY[1..800] OF STRING[79];
{^ This is the text buffer for the text editor and text reader.              }
{}
TYPE Text_Reader  = RECORD      {The record for the text reader settings.    }
     X,Y          : INTEGER;    {Text reader X/Y coordinates.                }
     Row          : INTEGER;    {Current text line Y coordinate.             }
     Col          : INTEGER;    {Current text line X coordinate.             }
     Lines        : INTEGER;    {How many lines of text in the buffer.       }
     Last         : INTEGER;    {The last text line written to the screen.   }
     Active       : BOOLEAN;    {Has the text reader been activated?         }
     Running      : BOOLEAN;    {Is the text reader running?                 }
     END;
{}
TYPE Text_Editor  = RECORD      {Record for the text editor settings.        }
     Row          : INTEGER;    {Text editor row location.                   }
     Active       : BOOLEAN;    {Has the text editor been activated?         }
     Running      : BOOLEAN;    {Is the text editor running?                 }
     Done         : BOOLEAN;    {Has the user pressed ^Q or ^Z ?             }
     END;
{}
TYPE Icon_Flips   = RECORD      {Record for the flipping icons.              }
     X,Y          : INTEGER;    {Icon X,Y coordinate.                        }
     Icon         : Array[1..4] OF BYTE;{Icon library record positions.      }
     Size         : BYTE;       {Icon size: 1=16, 2=30, 3=60 pixels.         }
     END;
{}
TYPE Flip_Array   = ARRAY[1..128] OF Icon_Flips;{Array of flipping icons.    }
{}
TYPE Text_Port    = RECORD      {Record for the text view port coordinates.  }
     StartX       : INTEGER;    {Text view port upper left X coordinate.     }
     StartY       : INTEGER;    {Text view port upper left Y coordinate.     }
     ColLimit     : BYTE;       {Text view port columns.                     }
     RowLimit     : BYTE;       {Text view port rows.                        }
     Active       : BOOLEAN;    {Is the text view port active?               }
     END;
{}
CONST MaxPal : ARRAY[0..767] OF BYTE = (0,0,0,0,0,42,0,42,0,0,42,42,42,0,0,42,
               0,42,42,21,0,42,42,42,21,21,21,21,21,63,21,63,21,21,63,63,63,
               21,21,63,21,63,63,63,21,63,63,63,15,3,12,18,6,15,21,9,18,24,12,
               21,28,16,25,32,20,29,36,24,33,40,28,37,44,32,41,48,36,45,52,40,
               49,56,44,53,58,46,55,60,48,57,62,50,59,63,54,60,0,0,18,0,0,23,
               0,0,28,0,0,33,0,0,38,0,0,43,0,0,48,0,0,53,0,0,58,0,0,63,0,8,63,
               0,15,63,0,20,63,0,25,63,0,30,63,0,35,63,0,40,63,0,45,63,0,50,
               63,0,55,63,0,60,63,0,63,63,7,10,31,12,15,41,17,20,41,22,25,46,
               27,30,51,32,35,56,37,40,61,41,48,63,15,0,30,20,0,35,25,0,40,30,
               0,45,35,0,50,45,0,60,50,0,63,55,25,63,58,31,63,63,35,63,63,40,
               63,63,45,63,63,50,63,63,55,63,63,60,63,0,18,0,5,22,0,10,27,5,
               15,32,10,20,37,15,25,42,20,30,47,25,35,52,30,40,57,35,45,62,40,
               0,20,0,0,25,0,0,30,0,0,35,0,0,40,0,0,45,0,0,50,0,0,55,0,0,60,0,
               0,63,5,0,63,26,0,63,34,18,63,43,40,63,48,52,63,54,58,63,55,20,
               0,0,25,0,0,30,0,0,34,0,0,38,0,0,42,0,0,46,0,0,50,0,0,54,0,0,58,
               0,0,62,0,0,63,22,22,63,32,32,63,35,35,63,43,43,63,45,45,63,52,
               52,63,57,57,20,9,0,25,14,5,30,19,10,35,24,15,40,29,20,45,34,25,
               50,39,30,55,44,35,60,49,40,63,52,43,63,55,48,63,57,50,29,12,0,
               37,16,0,41,18,0,48,18,0,53,18,0,56,21,3,59,24,6,63,28,10,63,32,
               0,63,38,10,63,43,10,63,49,18,63,52,0,63,54,0,63,56,0,63,58,0,
               63,60,0,63,63,0,63,63,10,63,63,20,63,63,30,63,63,40,63,63,50,0,
               15,15,0,20,20,0,25,25,0,30,30,0,35,35,0,40,40,0,45,45,0,50,50,
               0,55,55,0,60,60,30,63,63,41,63,63,50,63,63,52,63,63,40,0,25,43,
               0,27,46,1,29,53,2,34,59,8,36,63,12,40,63,20,41,63,25,44,62,31,
               47,63,35,49,62,44,56,63,49,60,63,10,10,63,15,15,63,20,20,63,25,
               25,63,30,30,63,35,35,63,40,40,63,45,45,63,50,50,63,55,55,20,20,
               0,25,25,0,30,30,0,35,35,5,40,40,10,45,45,15,50,50,20,55,55,25,
               60,60,30,63,63,40,63,63,50,63,63,58,0,10,0,0,17,0,10,20,10,15,
               25,15,20,30,20,25,35,25,30,40,30,35,45,35,40,50,40,45,55,45,50,
               60,50,55,63,55,25,15,0,30,20,5,35,25,10,40,30,15,45,35,20,50,
               40,25,55,45,30,60,50,35,63,55,40,63,60,45,2,2,2,5,5,5,8,8,8,10,
               10,10,12,12,12,14,14,14,16,16,16,18,18,18,20,20,20,22,22,22,24,
               24,24,26,26,26,28,28,28,30,30,30,32,32,32,34,34,34,36,36,36,38,
               38,38,40,40,40,42,42,42,44,44,44,46,46,46,48,48,48,50,50,50,52,
               52,52,54,54,54,56,56,56,58,58,58,61,61,61,63,63,63);

CONST
  BBSmessages     : BOOLEAN = FALSE;{Translate BBS message text lines?       }
  FPtr            : POINTER = NIL;  {Pointer to the external GEM font file.  }
  GPtr            : POINTER = NIL;  {Pointer to the GEM System font.         }
  BPtr            : POINTER = NIL;  {Pointer to the 5x8 Bitmapped Font.      }

VAR
  SysClk          : ^WORD; {Real mem $40:$6C} {BIOS system clock counter.    }
  C               : GUI_Color_Scheme;{The color scheme record variable.      }
  WRec            : WindowRecord;{The window record variable.                }
  Buttons         : ^Button_Array;{The button pointer variable.              }
  Fields          : ^Field_Array;{The entry field pointer variable.          }
  IconFlip        : ^Flip_Array; {The icon flip pointer variable.            }
  PickList        : ^Pick_List;  {The picklist text pointer variable.        }
  TBuff           : ^Text_Buffer;{The text buffer pointer variable.          }
  TvPort          : Text_Port;   {The text view port record variable.        }
  PickInfo        : Pick_Info;   {The picklist record variable.              }
  Scroller        : PalScroller; {The scroller record variable.              }
  TextReader      : Text_Reader; {The text reader record variable.           }
  TextEditor      : Text_Editor; {The text editor record variable.           }
  WinTag          : CHAR;        {Identifier tag for screen save files.      }
  MC              : CHAR;        {Character returned by mouse handler.       }
  ShowBanner      : BOOLEAN;     {Show the info banner upon startup? [Y/N]   }
  AltKey          : BOOLEAN;     {Was the last MC keypress an ALT key? [Y/N] }
  SVGAmode        : BOOLEAN;     {Are we in SVGA mode? [Y/N]                 }
  ConvertIt       : BOOLEAN;     {Convert color codes? [Y/N]                 }
  Mouse_On        : BOOLEAN;     {Is the mouse cursor turned on? [Y/N]       }
  MouseInstalled  : BOOLEAN;     {Is the mouse driver installed? [Y/N]       }
  AllowDragging   : BOOLEAN;     {Allow window dragging? [Y/N]               }
  DragActive      : BOOLEAN;     {Is window dragging currently active? [Y/N] }
  ExplodeOn       : BOOLEAN;     {Are exploding windows activated? [Y/N]     }
  ShowIcons       : BOOLEAN;     {Show the lower right corner MAX icons?[Y/N]}
  LastPressed     : BYTE;        {The number of the last button pressed.     }
  NFlips          : BYTE;        {The total number of flipping icons.        }
  NFields         : BYTE;        {The total number of fields in a window.    }
  NButtons        : BYTE;        {The total number of buttons in a window.   }
  FieldNum        : BYTE;        {The currently selected field number.       }
  WindowNumber    : BYTE;        {The currently active window number.        }
  SvgaID          : INTEGER;     {The SVGA Chipset ID Number.                }
  Old_Mode        : INTEGER;     {Original screen mode before FireUpGui.     }
  OldX            : INTEGER;     {Last X coordinate of the mouse for dragging}
  OldY            : INTEGER;     {Last Y coordinate of the mouse for dragging}
  OrgX            : INTEGER;     {Original X1 coordinate of a window.        }
  OrgY            : INTEGER;     {Original Y1 coordinate of a window.        }
  BackDropImage   : STRING[80];  {640x480 PCX image to use as a backdrop.    }
  IconLib16       : STRING[80];  {File name of the 16x16 icon library file.  }
  IconLib30       : STRING[80];  {File name of the 30x30 icon library file.  }
  IconLib60       : STRING[80];  {File name of the 60x60 icon library file.  }
  DefMouseMask    : STRING[80];  {File name of the default 256C mouse mask.  }
  EditorFile      : STRING[80];  {Default file name for text editor saving.  }
  MsgInfPath      : STRING[80];  {Path to MSGINF file for editing messages.  }

{Start Up And Shutdown}
PROCEDURE WaitForRetrace;
PROCEDURE StartOffScreenDraw;
PROCEDURE EndOffScreenDraw;
PROCEDURE LoadGemFonts;
PROCEDURE InitPalette;
FUNCTION  FireUpGui : BOOLEAN;
PROCEDURE ShutDownGui;
{Basic Drawing Elements}
PROCEDURE Draw_Line(X1,Y1,X2,Y2,FG : WORD);
PROCEDURE Draw_Bezier(px1,py1,px2,py2,px3,py3,px4,py4,Count,Color : INTEGER ; XORed : BOOLEAN);
PROCEDURE Draw_Mesh(X1,Y1,X2,Y2,FG : WORD);
{Text Output}
FUNCTION  TextWidth(FontSize : BYTE ; InStr : STRING) : WORD;
FUNCTION  TextHeight(FontSize : BYTE ; InStr : STRING) : WORD;
PROCEDURE LoadUserFont(FFile : STRING);
PROCEDURE CvtTokens(InStr : STRING ; Font : BYTE);
PROCEDURE OutText_XY(X,Y,FG,Font : WORD ; Txt : STRING);
PROCEDURE ShadowText(X,Y,FG,SH,Font : WORD ; Txt : STRING);
{3D Box/Rectangle Drawing}
PROCEDURE RaisedBox(X1,Y1,X2,Y2 : WORD);
PROCEDURE LoweredBox(X1,Y1,X2,Y2 : WORD);
PROCEDURE FrameHigh(X1,Y1,X2,Y2 : WORD);
PROCEDURE FrameLow(X1,Y1,X2,Y2 : WORD);
{Window Drawing/Undrawing}
PROCEDURE Kill_Window;
PROCEDURE ExplodeBox(X1,Y1,X2,Y2 : INTEGER);
PROCEDURE Draw_Window(X1,Y1,X2,Y2,WType : WORD ; Title : STRING);
{Entry Field Related}
PROCEDURE Entry_Field(X,Y,EType,ELength,ESize : WORD ; Stuff : STRING);
PROCEDURE RedrawField;
PROCEDURE ChangeField(Number : WORD);
{Button Related}
PROCEDURE Draw_Button(X,Y,Width : WORD ; Return : BYTE ; HasIcon : BOOLEAN ; Icon : BYTE ; Title : STRING);
PROCEDURE Radio_Button(X,Y : WORD ; Return : BYTE);
PROCEDURE Click_Zone(X,Y,Width,Height : WORD ; Return : BYTE);
PROCEDURE User_Button(X,Y,Width,Height : WORD ; Return : BYTE);
PROCEDURE Mouse_Field(X,Y,Width,Height : WORD ; Return : BYTE);
PROCEDURE Ani_Button(X,Y : WORD ; Icon1,Icon2,Size,BType,Return : BYTE);
{Scrolling Picklist Related}
PROCEDURE New_PickList(X,Y,OnScreen,MaxChars : WORD);
PROCEDURE AddTo_PickList(InString : STRING);
PROCEDURE PickText(X,Y : INTEGER ; Color : BYTE ; St : STRING);
PROCEDURE SetUp_PickList;
PROCEDURE Reset_PickList(Item : WORD);
{Color Palette Related}
PROCEDURE Palette_Scroller(X,Y : WORD);
PROCEDURE SetUp_Scroller;
{Text Editor/Reader Related}
PROCEDURE FillTextBuffer(F : STRING);
PROCEDURE New_TextReader(Y : WORD);
PROCEDURE ShowTextPage;
PROCEDURE New_TextEditor(Row : WORD);
PROCEDURE RunTextEditor;
{Miscellaneous Stuff}
FUNCTION  MouseHandler(DoKeys : BOOLEAN) : BYTE;
PROCEDURE ResetGraphics;
PROCEDURE Show_Mem;
PROCEDURE ShowMouse;
PROCEDURE HideMouse;
PROCEDURE Text_View_Port(X1,Y1,X2,Y2 : INTEGER);
PROCEDURE AnsiFullScreen;
PROCEDURE ShutDownSvga;
PROCEDURE RestartSvga;
{}

IMPLEMENTATION

USES MYCRT, DOS, FGMAIN, FGMISC, FGBITMAP, FGSVGA, FGPCX,
     GUI_ANSI, GUI_UTIL, GUI_FONT, GUI_ICON, GUI_MOUS, APTIMER;

CONST
  TopScreen     = 1;
  WWrap         = 79;
  ScrLines      : WORD = 17;
  ScrSize       : WORD = 23;
  ScrollSiz     : WORD = 13;
  Insert_Mode   : BOOLEAN = TRUE;
  Max_Msg_Lines : WORD = 800;

VAR
  Key           : CHAR;
  Par           : STRING;
  LineNum       : WORD;
  LineCnt       : WORD;
  xx,yy         : WORD;
  TopLine       : INTEGER;
  CLine         : INTEGER;
  CCol          : INTEGER;
  PhyLine       : ARRAY[1..17] OF STRING[81];
  PLeft         : INTEGER;
  FlipCounter   : BYTE;
  IconCounter   : BYTE;

{}
PROCEDURE WaitForRetrace;
BEGIN
  WHILE ((Port[$3DA] AND 8) > 0) DO;
  WHILE ((Port[$3DA] AND 8) = 0) DO;
{ REPEAT UNTIL Port[$3DA] AND 8 = 8;{Wait For Vertical retrace              }
{ REPEAT UNTIL Port[$3DA] AND 8 = 0;{Wait For the end of Vertical retrace   }
{ REPEAT UNTIL Port[$3DA] AND 1 = 1;{Wait For Horizontal retrace            }
{ REPEAT UNTIL Port[$3DA] AND 1 = 0;{Wait For the end of Horizontal retrace }
END;
{}
PROCEDURE SliceMouse;
CONST
  OldClk : WORD = 0;
BEGIN
  IF SysClk^ AND $FFFC = OldClk THEN EXIT;
  OldClk := SysClk^ AND $FFFC;
  TimeSlice;
END;
{}
PROCEDURE StartOffScreenDraw;
BEGIN
  FG_Allocate(1);
  FG_CopyPage(0,1);
  FG_SetPage(1);
END;
{}
PROCEDURE EndOffScreenDraw;
BEGIN
  FG_CopyPage(1,0);
  FG_SetPage(0);
  FG_FreePage(1);
END;
{}
PROCEDURE Bit5x8FontProc; EXTERNAL;
{$L BIT5X8.OBJ}

PROCEDURE SystemFontProc; EXTERNAL;
{$L SYSTEM.OBJ}

PROCEDURE LoadGemFonts;
VAR
  Lead  : WORD;
  ECode : WORD;
BEGIN
  IF BPtr = NIL THEN BPtr := RegisterGEMfont(@Bit5x8FontProc,Lead,ECode);
  IF GPtr = NIL THEN GPtr := RegisterGEMfont(@SystemFontProc,Lead,ECode);
END;
{}
PROCEDURE InitPalette;
BEGIN
  WaitForRetrace;
  FG_SetDacs(0,256,MaxPal);
END;
{}
FUNCTION FireUpGui : BOOLEAN;
VAR
  F     : TEXT;
  St    : STRING[2];
PROCEDURE FadeIn;
TYPE RGB = RECORD
     R,G,B : BYTE;
     END;
VAR
  I, J   : INTEGER;
  Status : INTEGER;
  Target : INTEGER;
  Dacs1,
  Dacs2  : ARRAY [0..255] OF RGB;
BEGIN
  MOVE(MaxPal,Dacs1,768);
  FOR I := 0 TO 255 DO BEGIN
    Dacs2[I].R := 0;
    Dacs2[I].G := 0;
    Dacs2[I].B := 0;
  END;
  WaitForRetrace;
  FG_SetDacs(0,256,Dacs2);
  IF FExist(BackDropImage) THEN FG_ShowPcx(BackDropImage+#0,1) ELSE BEGIN
    FG_SetColor(C.ScreenColor);
    FG_ClpRect(0,639,0,479);
  END;
  FG_SetColor(0); FG_Box(0,639,0,479);
  RaisedBox(0,0,639,20);
  RaisedBox(0,459,639,479);
  OutText_XY(7,462,1,2,'Running Under ' + OSstr);
  Show_Mem;
  IF ShowIcons THEN BEGIN
    FrameHigh(540,419,630,450);
    PutIcon30(541,420,97,0);
    PutIcon30(571,420,98,0);
    PutIcon30(600,420,99,0);
  END;
  FOR J := 0 TO 63 DO BEGIN
    Target := 64 - J;
    FOR I := 0 TO 255 DO BEGIN
      IF (Dacs1[I].R > Target) AND (Dacs2[I].R < Dacs1[I].R) THEN INC(Dacs2[I].R);
      IF (Dacs1[I].G > Target) AND (Dacs2[I].G < Dacs1[I].G) THEN INC(Dacs2[I].G);
      IF (Dacs1[I].B > Target) AND (Dacs2[I].B < Dacs1[I].B) THEN INC(Dacs2[I].B);
    END;
    Delay(8);
    FG_Setdacs(0,256,Dacs2);
  END;
  InitPalette;
  Draw_Window(0,0,639,479,2,'');
END;
BEGIN
  FireUpGui := FALSE;
  FileMode  := 66;
  FG_InitPM;
  Old_Mode := FG_GetMode;
  FG_SetMode(19);
  IF FExist('MAXVIDEO.CFG') THEN BEGIN
    ASSIGN(F,'MAXVIDEO.CFG');
    RESET(F);
    READLN(F,St);
    CLOSE(F);
    SvgaID := StrToInt(St);
    FG_SvgaInit(SvgaID);
  END ELSE SvgaID := FG_SvgaInit(0);
  IF FG_TestMode(25,1) = 1 THEN BEGIN
    FireUpGui := TRUE;
    FG_SetMode(25);
  END ELSE BEGIN
    FG_SetMode(Old_Mode);
    FG_Reset;
    CLRSCR;
    EXIT;
  END;
  LoadGemFonts;
  FadeIn;
  IF ShowBanner THEN BEGIN
    StartOffScreenDraw;
    Draw_Window(150,175,490,273,5,ProgramName+' '+ProgramVersion);
    OutText_XY(159,206,1,2,'SVGA Chipset'); OutText_XY(250,206,1,2,': {0}'+FG_Chipset);
    OutText_XY(159,221,1,2,'VRAM In Use');  OutText_XY(250,221,1,2,': {0}'+IntToStr(FG_Memory)+'K Bytes');
    OutText_XY(159,236,1,2,'Program O/S');  OutText_XY(250,236,1,2,': {0}'+OsStr);
    Draw_Button(421,244,60,24,TRUE,4,'Okay');
    OutText_XY(159,251,1,2,'Free Memory');  OutText_XY(250,251,1,2,': {0}'+IntToStr(MemAvail)+' Bytes');
    EndOffScreenDraw;
  END;
  IF FG_MouseIni > 0 THEN BEGIN
    MouseInstalled := TRUE;
    FG_MouseLim(0,FG_GetMaxX,0,FG_GetMaxY);
    FG_MouseSpd(10,10);
    IF DefMouseMask <> '' THEN MouseMask256(DefMouseMask);
    ShowMouse;
  END;
  SVGAmode := TRUE;
  IF ShowBanner THEN BEGIN
    REPEAT UNTIL MouseHandler(TRUE) <> 0;
    Kill_Window;
  END;
END;
{}
PROCEDURE ShutDownGui;
PROCEDURE FadeOut;
TYPE RGB = RECORD
     R,G,B : BYTE;
     END;
VAR
  I, J   : INTEGER;
  Dacs1,
  Dacs2  : ARRAY [0..255] OF RGB;
BEGIN
  FG_GetDacs(0,256,Dacs1);
  FG_GetDacs(0,256,Dacs2);
  FOR J := 0 TO 63 DO BEGIN
    FOR I := 0 TO 255 DO BEGIN
      IF (Dacs2[I].R > 0) THEN DEC(Dacs2[I].R);
      IF (Dacs2[I].G > 0) THEN DEC(Dacs2[I].G);
      IF (Dacs2[I].B > 0) THEN DEC(Dacs2[I].B);
    END;
    Delay(8);
    FG_SetDacs(0,256,Dacs2);
  END;
END;
BEGIN
  IF WindowNumber > 1 THEN REPEAT Kill_Window UNTIL WindowNumber = 1;
  HideMouse;
  UnloadGemFont(FPtr);
  FadeOut;
  FG_MouseFin;
  FG_SetMode(Old_Mode);
  FG_Reset;
  SVGAmode := FALSE;
  CLRSCR;
END;
{}
PROCEDURE Draw_Line(X1,Y1,X2,Y2,FG : WORD);
BEGIN
  FG_Move(X1,Y1);
  FG_SetColor(FG);
  FG_Draw(X2,Y2);
END;
{}
PROCEDURE Draw_Bezier(px1,py1,px2,py2,px3,py3,px4,py4,Count,Color : INTEGER ; XORed : BOOLEAN);
VAR
  Resolution,T : REAL;
  Xc,Yc        : INTEGER;
FUNCTION Pow(X : REAL; Y : WORD) : REAL;
VAR
  Nt     : WORD;
  Result : REAL;
BEGIN
  Result := 1;
  FOR Nt := 1 TO Y DO Result := Result * X;
  Pow    := Result;
END;
PROCEDURE Bezier(T : REAL; VAR X,Y : INTEGER);
BEGIN
  X := ROUND(Pow(1 - T,3) * px1 + 3 * T * Pow(1 - T,2) * px2 +
                 3 * T * T * (1 - T) * px3 + Pow(T,3) * px4);
  Y := ROUND(Pow(1 - T,3) * py1 + 3 * t * Pow(1 - T,2) * py2 +
                 3 * T * T * (1 - t) * py3 + Pow(T,3) * py4);
END;
BEGIN
  IF Count = 0 THEN EXIT;
  FG_SetColor(Color);
  Resolution := 1 / Count;
  FG_Move(px1,py1);
  T := 0;
  WHILE T < 1 DO BEGIN
    Bezier(T,Xc,Yc);
    IF XORed THEN FG_DrawX(Xc,Yc) ELSE FG_Draw(Xc,Yc);
    T := T + Resolution;
  END;
  IF XORed THEN FG_DrawX(px4,py4) ELSE FG_Draw(px4,py4);
END;
{}
PROCEDURE Draw_Mesh(X1,Y1,X2,Y2,FG : WORD);
VAR
  BArray   : ARRAY[1..640] OF BYTE;
  Loop,X,B : WORD;
BEGIN
  IF FG = 0 THEN FG := 226;
  FOR Loop := Y1 TO Y2 DO BEGIN
    FILLCHAR(BArray,SIZEOF(BArray),0);
    B := 0;
    IF ODD(Loop) THEN BEGIN
      FOR X := X1 TO X2 DO BEGIN
        INC(B);
        IF ODD(X) THEN BArray[B] := FG;
      END;
    END ELSE BEGIN
      FOR X := X1 TO X2 DO BEGIN
        INC(B);
        IF NOT ODD(X) THEN BArray[B] := FG;
      END;
    END;
    FG_Move(X1,Loop);
    FG_DrwImage(BArray,(X2-X1)+1,1);
  END;
END;
{}
PROCEDURE LoadUserFont(FFile : STRING);
VAR
  Leading   : WORD;
  ErrorCode : WORD;
BEGIN
  UnloadGemFont(FPtr);
  IF FExist(FFile) THEN FPtr := LoadGemFont(FFile,Leading,ErrorCode);
  Show_Mem;
END;
{}
FUNCTION TextWidth(FontSize : BYTE ; InStr : STRING) : WORD;
BEGIN
  CASE FontSize OF
    1 : TextWidth := GemTextWidth(BPtr,InStr);
    2 : TextWidth := GemTextWidth(GPtr,InStr);
    3 : TextWidth := LENGTH(InStr) * 8;
    4 : TextWidth := GemTextWidth(FPtr,InStr);
  END;
END;
{}
FUNCTION TextHeight(FontSize : BYTE ; InStr : STRING) : WORD;
BEGIN
  CASE FontSize OF
    1 : TextHeight := GemTextHeight(BPtr,InStr);
    2 : TextHeight := GemTextHeight(GPtr,InStr);
    3 : TextHeight := 16;
    4 : TextHeight := GemTextHeight(FPtr,InStr);
  END;
END;
{}
FUNCTION GoodColor(TempStr : STRING ; ChangeColor : BOOLEAN) : BOOLEAN;
VAR
  FG : BYTE;
BEGIN
  FG := 50;
  IF TempStr = '{0}'  THEN FG := 0;
  IF TempStr = '{1}'  THEN FG := 1;
  IF TempStr = '{2}'  THEN FG := 2;
  IF TempStr = '{3}'  THEN FG := 3;
  IF TempStr = '{4}'  THEN FG := 4;
  IF TempStr = '{5}'  THEN FG := 5;
  IF TempStr = '{6}'  THEN FG := 6;
  IF TempStr = '{7}'  THEN FG := 7;
  IF TempStr = '{8}'  THEN FG := 8;
  IF TempStr = '{9}'  THEN FG := 9;
  IF TempStr = '{10}' THEN FG := 10;
  IF TempStr = '{11}' THEN FG := 11;
  IF TempStr = '{12}' THEN FG := 12;
  IF TempStr = '{13}' THEN FG := 13;
  IF TempStr = '{14}' THEN FG := 14;
  IF TempStr = '{15}' THEN FG := 15;
  IF TempStr = '{16}' THEN FG := 0;
  IF TempStr = '{17}' THEN FG := 1;
  IF TempStr = '{18}' THEN FG := 2;
  IF TempStr = '{19}' THEN FG := 3;
  IF TempStr = '{20}' THEN FG := 4;
  IF TempStr = '{21}' THEN FG := 5;
  IF TempStr = '{22}' THEN FG := 6;
  IF TempStr = '{23}' THEN FG := 7;
  IF TempStr = '{24}' THEN FG := 8;
  IF TempStr = '{25}' THEN FG := 9;
  IF TempStr = '{26}' THEN FG := 10;
  IF TempStr = '{27}' THEN FG := 11;
  IF TempStr = '{28}' THEN FG := 12;
  IF TempStr = '{29}' THEN FG := 13;
  IF TempStr = '{30}' THEN FG := 14;
  IF TempStr = '{31}' THEN FG := 15;
  IF FG <> 50 THEN BEGIN
    IF ChangeColor THEN FG_SetColor(FG);
    GoodColor := TRUE;
  END ELSE GoodColor := FALSE;
END;
{}
FUNCTION StripTokens(InStr : STRING) : STRING;
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
  Hold : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  Hold := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF Cvt THEN Temp := Temp + InStr[Loop] ELSE Hold := Hold + InStr[Loop];
    IF ((Cvt) AND (InStr[Loop] = '}')) OR (Loop = LENGTH(InStr)) THEN BEGIN
      IF NOT GoodColor(Temp,FALSE) THEN Hold := Hold + Temp;
      Cvt  := FALSE;
      Temp := '';
    END;
  END;
  StripTokens := Hold;
END;
{}
PROCEDURE CvtTokens(InStr : STRING ; Font : BYTE);
VAR
  Loop : BYTE;
  Cvt  : BOOLEAN;
  Temp : STRING;
BEGIN
  Cvt  := FALSE;
  Temp := '';
  FOR Loop := 1 TO LENGTH(InStr) DO BEGIN
    IF InStr[Loop] = '{' THEN Cvt := TRUE;
    IF NOT Cvt THEN CASE Font OF
      1 : OutGemText(BPtr,InStr[Loop]);
      2 : OutGemText(GPtr,InStr[Loop]);
      3 : FG_PrintC(InStr[Loop],1);
      4 : IF FPtr <> NIL THEN OutGemText(FPtr,InStr[Loop]);
    END;
    IF Cvt THEN Temp := Temp + InStr[Loop];
    IF (Cvt) AND (InStr[Loop] = '}') THEN BEGIN
      IF NOT GoodColor(Temp,TRUE) THEN CASE Font OF
        1 : OutGemText(BPtr,Temp);
        2 : OutGemText(GPtr,Temp);
        3 : FG_PrintC(Temp,LENGTH(Temp));
        4 : IF FPtr <> NIL THEN OutGemText(FPtr,Temp);
      END;
      Cvt  := FALSE;
      Temp := '';
    END;
  END;
END;
{}
PROCEDURE OutText_XY(X,Y,FG,Font : WORD ; Txt : STRING);
BEGIN
  FG_SetColor(FG);
  IF Font = 3 THEN FG_Move(X,Y + 15) ELSE FG_Move(X,Y);
  IF ConvertIt THEN CvtTokens(Txt,Font) ELSE CASE Font OF
    1 : OutGemText(BPtr,Txt);
    2 : OutGemText(GPtr,Txt);
    3 : FG_PrintC(Txt,LENGTH(Txt));
    4 : IF FPtr <> NIL THEN OutGemText(FPtr,Txt);
  END;
END;
{}
PROCEDURE ShadowText(X,Y,FG,SH,Font : WORD ; Txt : STRING);
BEGIN
  FG_SetColor(SH);
  IF ConvertIt THEN BEGIN
    IF Font = 3 THEN FG_Move(X + 1,Y + 16);
    CASE Font OF
      1 : OutGemTextXY(BPtr,X + 1,Y + 1,StripTokens(Txt));
      2 : OutGemTextXY(GPtr,X + 1,Y + 1,StripTokens(Txt));
      3 : FG_PrintC(StripTokens(Txt),LENGTH(StripTokens(Txt)));
      4 : IF FPtr <> NIL THEN OutGemTextXY(FPtr,X + 1,Y + 1,StripTokens(Txt));
    END;
  END ELSE CASE Font OF
    1 : OutGemTextXY(BPtr,X + 1,Y + 1,Txt);
    2 : OutGemTextXY(GPtr,X + 1,Y + 1,Txt);
    3 : BEGIN
          FG_Move(X + 1, Y + 16);
          FG_PrintC(Txt,LENGTH(Txt));
        END;
    4 : IF FPtr <> NIL THEN OutGemTextXY(FPtr,X + 1,Y + 1,Txt);
  END;
  FG_SetColor(FG);
  IF Font = 3 THEN FG_Move(X,Y + 15) ELSE FG_Move(X,Y);
  IF ConvertIt THEN CvtTokens(Txt,Font) ELSE CASE Font OF
    1 : OutGemText(BPtr,Txt);
    2 : OutGemText(GPtr,Txt);
    3 : FG_PrintC(Txt,LENGTH(Txt));
    4 : IF FPtr <> NIL THEN OutGemText(FPtr,Txt);
  END;
END;
{}
PROCEDURE RaisedBox(X1,Y1,X2,Y2 : WORD);
BEGIN
  FG_SetColor(C.BoxBack); FG_ClpRect(X1,X2,Y1,Y2);
  FG_SetColor(C.ButtonFrame); FG_Box(X1,X2,Y1,Y2);
  Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.BoxHigh);
  Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.BoxHigh);
  Draw_Line(X2 - 1,Y1 + 2,X2 - 1,Y2 - 1,C.BoxLow);
  Draw_Line(X2 - 1,Y2 - 1,X1 + 2,Y2 - 1,C.BoxLow);
END;
{}
PROCEDURE LoweredBox(X1,Y1,X2,Y2 : WORD);
BEGIN
  FG_SetColor(C.BoxBack); FG_ClpRect(X1,X2,Y1,Y2);
  FG_SetColor(C.ButtonFrame); FG_Box(X1,X2,Y1,Y2);
  Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.BoxLow);
  Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.BoxLow);
  Draw_Line(X2 - 1,Y1 + 2,X2 - 1,Y2 - 1,C.BoxHigh);
  Draw_Line(X2 - 1,Y2 - 1,X1 + 2,Y2 - 1,C.BoxHigh);
END;
{}
PROCEDURE FrameHigh(X1,Y1,X2,Y2 : WORD);
BEGIN
  Draw_Line(X2,Y1,X2,Y2,C.FrameLow);
  Draw_Line(X2,Y2,X1,Y2,C.FrameLow);
  Draw_Line(X1,Y2,X1,Y1,C.FrameHigh);
  Draw_Line(X1,Y1,X2,Y1,C.FrameHigh);
END;
{}
PROCEDURE FrameLow(X1,Y1,X2,Y2 : WORD);
BEGIN
  Draw_Line(X2,Y1,X2,Y2,C.FrameHigh);
  Draw_Line(X2,Y2,X1,Y2,C.FrameHigh);
  Draw_Line(X1,Y2,X1,Y1,C.FrameLow);
  Draw_Line(X1,Y1,X2,Y1,C.FrameLow);
END;
{}
PROCEDURE WindowHeader(Title : STRING ; Active : BOOLEAN);
BEGIN
  IF (WRec.WType = 2) OR (WRec.WType = 3) THEN EXIT;
  IF Active THEN BEGIN
    IF (WRec.WType = 4) OR (WRec.WType = 5) THEN BEGIN
      FG_SetColor(C.ActiveHdr); FG_ClpRect(WRec.X1 + 5,WRec.X2 - 5,WRec.Y1 + 5,WRec.Y1 + 23);
      OutText_XY(Wrec.X1 + 9,WRec.Y1 + 7,C.HdrTitle,2,Title);
    END ELSE BEGIN
      FG_SetColor(C.ActiveHdr); FG_ClpRect(WRec.X1 + 4,WRec.X2 - 4,WRec.Y1 + 4,WRec.Y1 + 22);
      Draw_Line(WRec.X1 + 4,WRec.Y1 + 23,WRec.X2 - 4,WRec.Y1 + 23,C.FrameHigh);
      OutText_XY(Wrec.X1 + 9,WRec.Y1 + 6,C.HdrTitle,2,Title);
    END;
  END ELSE BEGIN
    IF (WRec.WType = 4) OR (WRec.WType = 5) THEN BEGIN
      FG_SetColor(C.InactiveHdr); FG_ClpRect(WRec.X1 + 5,WRec.X2 - 5,WRec.Y1 + 5,WRec.Y1 + 23);
      OutText_XY(WRec.X1 + 9,WRec.Y1 + 7,7,2,Title);
    END ELSE BEGIN
      FG_SetColor(C.InactiveHdr); FG_ClpRect(WRec.X1 + 4,WRec.X2 - 4,WRec.Y1 + 4,WRec.Y1 + 22);
      Draw_Line(WRec.X1 + 4,WRec.Y1 + 23,WRec.X2 - 4,WRec.Y1 + 23,C.TextBack);
      OutText_XY(WRec.X1 + 9,WRec.Y1 + 6,7,2,Title);
    END;
  END;
END;
{}
PROCEDURE SaveLastWindow;
VAR
  FFile : FILE;
BEGIN
  WindowHeader(WRec.Title,FALSE);
  ASSIGN(FFile,WinTag+'SAV'+WinTag+'.'+IntToStr(WindowNumber));
  REWRITE(FFile,1);
  BLOCKWRITE(FFile,PickInfo,SIZEOF(PickInfo));
  BLOCKWRITE(FFile,WRec,SIZEOF(WRec));
  BLOCKWRITE(FFile,TextReader,SIZEOF(TextReader));
  BLOCKWRITE(FFile,TextEditor,SIZEOF(TextEditor));
  BLOCKWRITE(FFile,TvPort,SIZEOF(TvPort));
  BLOCKWRITE(FFile,Scroller,SIZEOF(Scroller));
  BLOCKWRITE(FFile,FieldNum,SIZEOF(FieldNum));
  BLOCKWRITE(FFile,NFields,SIZEOF(NFields));
  BLOCKWRITE(FFile,NButtons,SIZEOF(NButtons));
  BLOCKWRITE(FFile,NFlips,SIZEOF(NFlips));
  BLOCKWRITE(FFile,AllowDragging,SIZEOF(AllowDragging));
  BLOCKWRITE(FFile,Where_X,SIZEOF(Where_X));
  BLOCKWRITE(FFile,Where_Y,SIZEOF(Where_X));
  BLOCKWRITE(FFile,ANSI_FG,SIZEOF(ANSI_FG));
  BLOCKWRITE(FFile,ANSI_BG,SIZEOF(ANSI_BG));
  BLOCKWRITE(FFile,CursorOn,SIZEOF(CursorOn));
  BLOCKWRITE(FFile,HandleMouse,SIZEOF(HandleMouse));
  IF NButtons > 0 THEN BLOCKWRITE(FFile,Buttons^,SIZEOF(Buttons^));
  IF NFields > 0 THEN BLOCKWRITE(FFile,Fields^,SIZEOF(Fields^));
  IF NFlips > 0 THEN BLOCKWRITE(FFile,IconFlip^,SIZEOF(IconFlip^));
  IF PickInfo.Active THEN BLOCKWRITE(FFile,PickList^,SIZEOF(PickList^));
  IF TextReader.Active THEN BLOCKWRITE(FFile,TBuff^,SIZEOF(TBuff^));
  IF TextEditor.Active THEN BLOCKWRITE(FFile,TBuff^,SIZEOF(TBuff^));
  IF TvPort.Active THEN BEGIN
    BLOCKWRITE(FFile,ChArray^,SIZEOF(ChArray^));
    BLOCKWRITE(FFile,FgArray^,SIZEOF(FgArray^));
    BLOCKWRITE(FFile,BgArray^,SIZEOF(BgArray^));
  END;
  CLOSE(FFile);
  IF NButtons > 0 THEN DISPOSE(Buttons);
  IF NFields > 0 THEN DISPOSE(Fields);
  IF NFlips > 0 THEN DISPOSE(IconFlip);
  IF PickInfo.Active THEN DISPOSE(PickList);
  IF TextReader.Active THEN DISPOSE(TBuff);
  IF TextEditor.Active THEN DISPOSE(TBuff);
  IF TvPort.Active THEN BEGIN
    DISPOSE(ChArray);
    DISPOSE(FgArray);
    DISPOSE(BgArray);
  END;
  NFlips        := 0;
  NButtons      := 0;
  NFields       := 0;
  FieldNum      := 0;
  LastPressed   := 0;
  IconCounter   := 1;
  AllowDragging := TRUE;
  FILLCHAR(WRec,SIZEOF(WRec),0);
  FILLCHAR(PickInfo,SIZEOF(PickInfo),0);
  FILLCHAR(TextReader,SIZEOF(TextReader),0);
  FILLCHAR(TextEditor,SIZEOF(TextEditor),0);
  FILLCHAR(TvPort,SIZEOF(TvPort),0);
  FILLCHAR(Scroller,SIZEOF(Scroller),0);
END;
{}
PROCEDURE LoadLastWindow;
VAR
  FFile : FILE;
BEGIN
  ASSIGN(FFile,WinTag+'SAV'+WinTag+'.'+IntToStr(WindowNumber));
  RESET(FFile,1);
  BLOCKREAD(FFile,PickInfo,SIZEOF(PickInfo));
  BLOCKREAD(FFile,WRec,SIZEOF(WRec));
  BLOCKREAD(FFile,TextReader,SIZEOF(TextReader));
  BLOCKREAD(FFile,TextEditor,SIZEOF(TextEditor));
  BLOCKREAD(FFile,TvPort,SIZEOF(TvPort));
  BLOCKREAD(FFile,Scroller,SIZEOF(Scroller));
  BLOCKREAD(FFile,FieldNum,SIZEOF(FieldNum));
  BLOCKREAD(FFile,NFields,SIZEOF(NFields));
  BLOCKREAD(FFile,NButtons,SIZEOF(NButtons));
  BLOCKREAD(FFile,NFlips,SIZEOF(NFlips));
  BLOCKREAD(FFile,AllowDragging,SIZEOF(AllowDragging));
  BLOCKREAD(FFile,Where_X,SIZEOF(Where_X));
  BLOCKREAD(FFile,Where_Y,SIZEOF(Where_X));
  BLOCKREAD(FFile,ANSI_FG,SIZEOF(ANSI_FG));
  BLOCKREAD(FFile,ANSI_BG,SIZEOF(ANSI_BG));
  BLOCKREAD(FFile,CursorOn,SIZEOF(CursorOn));
  BLOCKREAD(FFile,HandleMouse,SIZEOF(HandleMouse));
  IF NButtons > 0 THEN BEGIN
    NEW(Buttons);
    BLOCKREAD(FFile,Buttons^,SIZEOF(Buttons^));
  END;
  IF NFields > 0 THEN BEGIN
    NEW(Fields);
    BLOCKREAD(FFile,Fields^,SIZEOF(Fields^));
  END;
  IF NFlips > 0 THEN BEGIN
    NEW(IconFlip);
    BLOCKREAD(FFile,IconFlip^,SIZEOF(IconFlip^));
  END;
  IF PickInfo.Active THEN BEGIN
    NEW(PickList);
    BLOCKREAD(FFile,PickList^,SIZEOF(PickList^));
  END;
  IF TextReader.Active THEN BEGIN
    NEW(TBuff);
    BLOCKREAD(FFile,TBuff^,SIZEOF(TBuff^));
  END;
  IF TextEditor.Active THEN BEGIN
    NEW(TBuff);
    BLOCKREAD(FFile,TBuff^,SIZEOF(TBuff^));
  END;
  IF TvPort.Active THEN BEGIN
    NEW(ChArray);
    BLOCKREAD(FFile,ChArray^,SIZEOF(ChArray^));
    NEW(FgArray);
    BLOCKREAD(FFile,FgArray^,SIZEOF(FgArray^));
    NEW(BgArray);
    BLOCKREAD(FFile,BgArray^,SIZEOF(BgArray^));
  END;
  CLOSE(FFile);
  ERASE(FFile);
 {FieldNum    := 0;}
  LastPressed := 0;
  WindowHeader(WRec.Title,TRUE);
END;
{}
PROCEDURE Save_SVGA_Screen;
BEGIN
  FG_MakePcx(0,639,0,479,WinTag+'SCR'+IntToStr(WindowNumber)+WinTag+'.'+IntToStr(WindowNumber)+#0);
END;
{}
PROCEDURE Restore_SVGA_Screen;
BEGIN
  FG_ShowPcx(WinTag+'SCR'+IntToStr(WindowNumber)+WinTag+'.'+IntToStr(WindowNumber)+#0,0);
  FErase(WinTag+'SCR'+IntToStr(WindowNumber)+WinTag+'.'+IntToStr(WindowNumber));
END;
{}
PROCEDURE Kill_Window;
VAR
  Loop : BYTE;
BEGIN
  IF WindowNumber = 1 THEN EXIT;
  HideMouse;
  IF NButtons > 0 THEN FOR Loop := 1 TO NButtons DO BEGIN
    IF Buttons^[Loop].FieldOn THEN BEGIN
      FG_Restore(Buttons^[Loop].X,Buttons^[Loop].X + Buttons^[Loop].Width,
                 Buttons^[Loop].Y,Buttons^[Loop].Y + Buttons^[Loop].Height);
      Buttons^[Loop].FieldOn := FALSE;
    END;
  END;
  IF PickInfo.Active THEN DISPOSE(PickList);
  IF TextReader.Active THEN DISPOSE(TBuff);
  IF TextEditor.Active THEN DISPOSE(TBuff);
  IF NFlips > 0 THEN DISPOSE(IconFlip);
  IF NFields > 0 THEN DISPOSE(Fields);
  IF NButtons > 0 THEN DISPOSE(Buttons);
  IF TvPort.Active THEN BEGIN
    DISPOSE(ChArray);
    DISPOSE(FgArray);
    DISPOSE(BgArray);
  END;
  DEC(WindowNumber);
  Restore_SVGA_Screen;
  LoadLastWindow;
  ShowMouse;
END;
{}
PROCEDURE ExplodeBox(X1,Y1,X2,Y2 : INTEGER);
VAR
  XX1,YY1,XX2,YY2 : INTEGER;
  Finished        : BOOLEAN;
BEGIN
  Finished := FALSE;
  FG_SetColor(255);
  FG_BoxDepth(3,3);
  XX1 := X1 + (X2-X1) DIV 2;
  XX2 := XX1;
  YY1 := Y1 + (Y2-Y1) DIV 2;
  YY2 := YY1;
  REPEAT
    FG_BoxX(XX1,XX2,YY1,YY2);
    Delay(10);
    FG_BoxX(XX1,XX2,YY1,YY2);
    DEC(XX1,6); IF XX1 < X1 THEN XX1 := X1;
    INC(XX2,6); IF XX2 > X2 THEN XX2 := X2;
    DEC(YY1,6); IF YY1 < Y1 THEN YY1 := Y1;
    INC(YY2,6); IF YY2 > Y2 THEN YY2 := Y2;
    IF (XX1 = X1) AND (XX2 = X2) AND (YY1 = Y1) AND (YY2 = Y2) THEN Finished := TRUE;
  UNTIL Finished;
  FG_BoxDepth(1,1);
END;
{}
PROCEDURE Draw_Window(X1,Y1,X2,Y2,WType : WORD ; Title : STRING);
VAR
  Loop : BYTE;
BEGIN
  IF WType > 5 THEN WType := 1;
  IF NButtons >= 1 THEN FOR Loop := 1 TO NButtons DO BEGIN
    IF Buttons^[Loop].FieldOn THEN BEGIN
      HideMouse;
      FG_Restore(Buttons^[Loop].X,Buttons^[Loop].X + Buttons^[Loop].Width,
                 Buttons^[Loop].Y,Buttons^[Loop].Y + Buttons^[Loop].Height);
      Buttons^[Loop].FieldOn := FALSE;
      ShowMouse;
    END;
  END;
  IF WindowNumber <> 0 THEN BEGIN
    SaveLastWindow;
    Save_SVGA_Screen;
  END;
  INC(WindowNumber);
  WRec.Title := Title;
  WRec.X1    := X1;
  WRec.Y1    := Y1;
  WRec.X2    := X2;
  WRec.Y2    := Y2;
  WRec.WType := WType;
  IF (WType <> 2) AND (ExplodeOn) THEN ExplodeBox(X1,Y1,X2,Y2);
  IF WType = 1 THEN BEGIN
    FG_SetColor(C.Win1Back); FG_ClpRect(X1,X2,Y1,Y2);
    FG_SetColor(C.Win1High); FG_Box(X1,X2,Y1,Y2);
    FG_SetColor(C.Win1Low);  FG_Box(X1 + 3,X2 - 3,Y1 + 3,Y2 - 3);
    Draw_Line(X1 + 1,Y2,X2,Y2,C.Win1Frame2);
    Draw_Line(X2,Y1 + 1,X2,Y2,C.Win1Frame2);
    FG_SetColor(C.ActiveHdr); FG_ClpRect(X1 + 4,X2 - 4,Y1 + 4,Y1 + 22);
    Draw_Line(X1 + 4,Y1 + 23,X2 - 4,Y1 + 23,C.Win1Frame1);
    OutText_XY(X1 + 9,Y1 + 6,C.HdrTitle,2,Title);
    Draw_Line(X1 + 4,Y2 - 3,X2 - 3,Y2 - 3,C.Win1High);
    Draw_Line(X2 - 3,Y1 + 4,X2 - 3,Y2 - 3,C.Win1High);
    FG_SetColor(0); FG_ClpRect(X1 + 5,X2 + 2,Y2 + 1,Y2 + 2); FG_ClpRect(X2 + 1,X2 + 2,Y1 + 5,Y2);
  END;
  IF WType = 3 THEN RaisedBox(X1,Y1,X2,Y2);
  IF WType = 4 THEN BEGIN
    FG_SetColor(C.Win4Frame); FG_Box(X1,X2,Y1,Y2);
    FG_SetColor(C.Win4Low);   FG_Box(X1 + 1,X2 - 1,Y1 + 1,Y2 - 1);
    Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.Win4High);
    Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.Win4High);
    Draw_Mesh(X1+2,Y1+2,X2-2,Y2-2,C.Win4Back);
    FG_SetColor(C.ActiveHdr); FG_ClpRect(X1 + 5,X2 - 5,Y1 + 5,Y1 + 23);
    FG_SetColor(C.Win4Back);  FG_Box(X1 + 4,X2 - 4,Y1 + 4,Y1 + 24);
    Draw_Line(X1 + 4,Y1 + 24,X2 - 4,Y1 + 24,C.Win4High);
    Draw_Line(X2 - 4,Y1 + 24,X2 - 4,Y1 + 5,C.Win4High);
    OutText_XY(X1 + 9,Y1 + 7,C.HdrTitle,2,Title);
    FG_SetColor(0); FG_ClpRect(X1 + 5,X2 + 2,Y2 + 1,Y2 + 2); FG_ClpRect(X2 + 1,X2 + 2,Y1 + 5,Y2);
  END;
  IF WType = 5 THEN BEGIN
    FG_SetColor(C.Win1Back);   FG_ClpRect(X1,X2,Y1,Y2);
    FG_SetColor(C.Win1Low);    FG_Box(X1,X2,Y1,Y2);
    FG_SetColor(C.Win1Frame2); FG_Box(X1 + 1,X2 - 1,Y1 + 1,Y2 - 1);
    Draw_Line(X1 + 1,Y2 - 1,X1 + 1,Y1 + 1,C.Win1High);
    Draw_Line(X1 + 1,Y1 + 1,X2 - 1,Y1 + 1,C.Win1High);
    FG_SetColor(C.ActiveHdr); FG_ClpRect(X1 + 5,X2 - 5,Y1 + 5,Y1 + 23);
    FG_SetColor(C.Win1Low);   FG_Box(X1 + 4,X2 - 4,Y1 + 4,Y1 + 24);
    Draw_Line(X1 + 4,Y1 + 24,X2 - 4,Y1 + 24,C.Win1High);
    Draw_Line(X2 - 4,Y1 + 24,X2 - 4,Y1 + 5,C.Win1High);
    OutText_XY(X1 + 9,Y1 + 7,C.HdrTitle,2,Title);
    FG_SetColor(0); FG_ClpRect(X1 + 5,X2 + 2,Y2 + 1,Y2 + 2); FG_ClpRect(X2 + 1,X2 + 2,Y1 + 5,Y2);
  END;
  Show_Mem;
END;
{}
PROCEDURE Entry_Field(X,Y,EType,ELength,ESize : WORD ; Stuff : STRING);
VAR
  St : STRING;
  X2 : WORD;
BEGIN
  IF NFields = 0 THEN BEGIN
    NEW(Fields);
    FILLCHAR(Fields^,SIZEOF(Fields^),0);
    Show_Mem;
  END;
  IF NFields + 1 > 128 THEN EXIT;
  ConvertIt := FALSE;
  INC(NFields);
  IF ESize > 1 THEN ESize := 0;
  Fields^[NFields].Active := FALSE;
  IF NFields = 1 THEN BEGIN
    Fields^[NFields].Active := TRUE;
    FieldNum                := 1;
  END;
  Fields^[NFields].X         := X;
  Fields^[NFields].Y         := Y;
  Fields^[NFields].Text      := Stuff;
  Fields^[NFields].CursorPos := LENGTH(Stuff) + 1;
  Fields^[NFields].EType     := EType;
  Fields^[NFields].ELength   := ELength;
  Fields^[NFields].Size      := ESize;
  IF ESize = 0 THEN BEGIN
    FG_SetColor(C.FieldBack);
    X2 := ELength * 6;
    Fields^[NFields].Width := Fields^[NFields].X + X2;
    FG_ClpRect(X,X + X2 + 12,Y,Y + 20);
    FrameLow(X,Y,X + X2 + 12,Y + 20);
    IF FieldNum = NFields THEN FrameLow(X + 1,Y + 1,X + X2 + 11,Y + 19);
    St := COPY(Stuff,1,ELength);
    IF FieldNum = NFields THEN BEGIN
      OutText_XY(X + 6,Y + 7,C.FieldTextHigh,1,St);
      OutText_XY(X + 6 + TextWidth(1,St),Y + 9,C.FieldTextHigh,1,#95);
    END ELSE OutText_XY(X + 6,Y + 7,C.FieldTextLow,1,St);
  END ELSE BEGIN
    FG_SetColor(C.FieldBack);
    X2 := ELength * 8;
    Fields^[NFields].Width := Fields^[NFields].X + X2;
    FG_ClpRect(X,X + X2 + 16,Y,Y + 20);
    FrameLow(X,Y,X + X2 + 16,Y + 20);
    IF FieldNum = NFields THEN FrameLow(X + 1,Y + 1,X + X2 + 15,Y + 19);
    St := COPY(Stuff,1,ELength);
    IF FieldNum = NFields THEN BEGIN
      OutText_XY(X + 5,Y + 3,C.FieldTextHigh,3,St);
      OutText_XY(X + 5 + TextWidth(3,St),Y + 5,C.FieldTextHigh,3,#95);
    END ELSE OutText_XY(X + 5,Y + 3,C.FieldTextLow,3,St);
  END;
  ConvertIt := TRUE;
END;
{}
PROCEDURE RedrawField;
VAR
  St,
  Temp : STRING;
  X2,
  Ch,
  Loop : WORD;
BEGIN
  ConvertIt := FALSE;
  HideMouse;
  FG_SetColor(C.FieldBack);
  St   := '';
  Temp := '';
  REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields^[FieldNum].ELength;
  IF Fields^[FieldNum].EType = 4 THEN FOR Loop := 1 TO LENGTH(Fields^[FieldNum].Text) DO BEGIN
    IF Fields^[FieldNum].Size = 0 THEN Temp := Temp + '*' ELSE Temp := Temp + '';
  END;
  IF Fields^[FieldNum].Size = 0 THEN BEGIN
    X2 := 6;
    IF Fields^[FieldNum].EType = 4 THEN
    FOR Loop := 1 TO (Fields^[FieldNum].CursorPos - 1) DO INC(X2,TextWidth(1,Temp[Loop])) ELSE
    FOR Loop := 1 TO (Fields^[FieldNum].CursorPos - 1) DO INC(X2,TextWidth(1,Fields^[FieldNum].Text[Loop]));
    FG_ClpRect(Fields^[FieldNum].X + 5,Fields^[FieldNum].X + TextWidth(1,St) + 10,
               Fields^[FieldNum].Y + 3,Fields^[FieldNum].Y + 18);
    IF Fields^[FieldNum].EType <> 4 THEN
    OutText_XY(Fields^[FieldNum].X + 6,Fields^[FieldNum].Y + 7,C.FieldTextHigh,1,Fields^[FieldNum].Text) ELSE
    OutText_XY(Fields^[FieldNum].X + 6,Fields^[FieldNum].Y + 7,C.FieldTextHigh,1,Temp);
    OutText_XY(Fields^[FieldNum].X + X2,Fields^[FieldNum].Y + 9,C.FieldTextHigh,1,#95);
  END ELSE BEGIN
    X2 := 5;
    IF Fields^[FieldNum].EType = 4 THEN
    FOR Loop := 1 TO (Fields^[FieldNum].CursorPos - 1) DO INC(X2,TextWidth(3,Temp[Loop])) ELSE
    FOR Loop := 1 TO (Fields^[FieldNum].CursorPos - 1) DO INC(X2,TextWidth(3,Fields^[FieldNum].Text[Loop]));
    FG_ClpRect(Fields^[FieldNum].X + 4,Fields^[FieldNum].X + TextWidth(3,St) + 13,
               Fields^[FieldNum].Y + 3,Fields^[FieldNum].Y + 18);
    IF Fields^[FieldNum].EType <> 4 THEN
    OutText_XY(Fields^[FieldNum].X + 5,Fields^[FieldNum].Y + 3,C.FieldTextHigh,3,Fields^[FieldNum].Text) ELSE
    OutText_XY(Fields^[FieldNum].X + 5,Fields^[FieldNum].Y + 3,C.FieldTextHigh,3,Temp);
    OutText_XY(Fields^[FieldNum].X + X2,Fields^[FieldNum].Y + 5,C.FieldTextHigh,3,#95);
  END;
  ShowMouse;
  ConvertIt := TRUE;
END;
{}
PROCEDURE ChangeField(Number : WORD);
VAR
  St   : STRING;
  X2,
  Ch,
  Loop : WORD;
PROCEDURE DrawSmallField;
VAR
  X : WORD;
BEGIN
  FG_SetColor(C.FieldBack);
  FG_ClpRect(Fields^[FieldNum].X,Fields^[FieldNum].X + TextWidth(1,St) + 12,Fields^[FieldNum].Y,Fields^[FieldNum].Y + 20);
  FrameLow(Fields^[FieldNum].X,Fields^[FieldNum].Y,Fields^[FieldNum].X + TextWidth(1,St) + 12,Fields^[FieldNum].Y + 20);
  FrameLow(Fields^[FieldNum].X+1,Fields^[FieldNum].Y+1,Fields^[FieldNum].X+TextWidth(1,St)+11,Fields^[FieldNum].Y+19);
  IF Fields^[FieldNum].EType = 4 THEN BEGIN
    St := '';
    FOR X := 1 TO LENGTH(Fields^[FieldNum].Text) DO St := St + '*';
    OutText_XY(Fields^[FieldNum].X+6,Fields^[FieldNum].Y+7,C.FieldTextHigh,1,St);
  END ELSE OutText_XY(Fields^[FieldNum].X+6,Fields^[FieldNum].Y+7,C.FieldTextHigh,1,Fields^[FieldNum].Text);
  X2 := 6;
  FOR X := 1 TO (Fields^[FieldNum].CursorPos - 1) DO BEGIN
    IF Fields^[FieldNum].EType = 4 THEN Ch := TextWidth(1,St[X])
                                   ELSE Ch := TextWidth(1,Fields^[FieldNum].Text[X]);
    INC(X2,Ch);
  END;
  OutText_XY(Fields^[FieldNum].X+X2,Fields^[FieldNum].Y+9,C.FieldTextHigh,1,#95);
END;
PROCEDURE DrawLargeField;
VAR
  X : WORD;
BEGIN
  FG_SetColor(C.FieldBack);
  FG_ClpRect(Fields^[FieldNum].X,Fields^[FieldNum].X + TextWidth(3,St) + 16,Fields^[FieldNum].Y,Fields^[FieldNum].Y + 20);
  FrameLow(Fields^[FieldNum].X,Fields^[FieldNum].Y,Fields^[FieldNum].X + TextWidth(3,St) + 16,Fields^[FieldNum].Y + 20);
  FrameLow(Fields^[FieldNum].X+1,Fields^[FieldNum].Y+1,Fields^[FieldNum].X+TextWidth(3,St)+15,Fields^[FieldNum].Y+19);
  IF Fields^[FieldNum].EType = 4 THEN BEGIN
    St := '';
    FOR X := 1 TO LENGTH(Fields^[FieldNum].Text) DO St := St + '';
    OutText_XY(Fields^[FieldNum].X+5,Fields^[FieldNum].Y+3,C.FieldTextHigh,3,St);
  END ELSE OutText_XY(Fields^[FieldNum].X+5,Fields^[FieldNum].Y+3,C.FieldTextHigh,3,Fields^[FieldNum].Text);
  X2 := 5;
  FOR X := 1 TO (Fields^[FieldNum].CursorPos - 1) DO BEGIN
    IF Fields^[FieldNum].EType = 4 THEN Ch := TextWidth(3,St[X])
                                   ELSE Ch := TextWidth(3,Fields^[FieldNum].Text[X]);
    INC(X2,Ch);
  END;
  OutText_XY(Fields^[FieldNum].X+X2,Fields^[FieldNum].Y+5,C.FieldTextHigh,3,#95);
END;
BEGIN
  IF NFields <= 1 THEN EXIT;
  ConvertIt := FALSE;
  HideMouse;
  Fields^[FieldNum].Active := FALSE;
  St := '';
  REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields^[FieldNum].ELength;
  IF Fields^[FieldNum].Size = 0 THEN BEGIN
    FG_SetColor(C.FieldBack);
    FG_ClpRect(Fields^[FieldNum].X,Fields^[FieldNum].X + TextWidth(1,St) + 12,Fields^[FieldNum].Y,Fields^[FieldNum].Y + 20);
    FrameLow(Fields^[FieldNum].X,Fields^[FieldNum].Y,Fields^[FieldNum].X + TextWidth(1,St) + 12,Fields^[FieldNum].Y + 20);
    IF Fields^[FieldNum].EType = 4 THEN BEGIN
      St := '';
      FOR Loop := 1 TO LENGTH(Fields^[FieldNum].Text) DO St := St + '*';
      OutText_XY(Fields^[FieldNum].X+6,Fields^[FieldNum].Y+7,C.FieldTextLow,1,St);
    END ELSE OutText_XY(Fields^[FieldNum].X+6,Fields^[FieldNum].Y+7,C.FieldTextLow,1,Fields^[FieldNum].Text);
    FieldNum := Number;
    Fields^[FieldNum].Active := TRUE;
    St := '';
    REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields^[FieldNum].ELength;
    IF Fields^[FieldNum].Size = 0 THEN DrawSmallField ELSE DrawLargeField;
  END ELSE BEGIN
    FG_SetColor(C.FieldBack);
    FG_ClpRect(Fields^[FieldNum].X,Fields^[FieldNum].X + TextWidth(3,St) + 16,Fields^[FieldNum].Y,Fields^[FieldNum].Y + 20);
    FrameLow(Fields^[FieldNum].X,Fields^[FieldNum].Y,Fields^[FieldNum].X + TextWidth(3,St) + 16,Fields^[FieldNum].Y + 20);
    IF Fields^[FieldNum].EType = 4 THEN BEGIN
      St := '';
      FOR Loop := 1 TO LENGTH(Fields^[FieldNum].Text) DO St := St + '';
      OutText_XY(Fields^[FieldNum].X+5,Fields^[FieldNum].Y+3,C.FieldTextLow,3,St);
    END ELSE OutText_XY(Fields^[FieldNum].X+5,Fields^[FieldNum].Y+3,C.FieldTextLow,3,Fields^[FieldNum].Text);
    FieldNum := Number;
    Fields^[FieldNum].Active := TRUE;
    St := '';
    REPEAT St := St + ' ' UNTIL LENGTH(St) = Fields^[FieldNum].ELength;
    IF Fields^[FieldNum].Size = 1 THEN DrawLargeField ELSE DrawSmallField;
  END;
  ShowMouse;
  ConvertIt := TRUE;
END;
{}
PROCEDURE Draw_Button(X,Y,Width : WORD ; Return : BYTE ; HasIcon : BOOLEAN ; Icon : BYTE ; Title : STRING);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  Buttons^[NButtons].ButtonType := 1;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Width      := Width;
  Buttons^[NButtons].Height     := 20;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Title      := Title;
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  Buttons^[NButtons].HasIcon    := HasIcon;
  Buttons^[NButtons].Icon       := Icon;
  Buttons^[NButtons].Flip       := 0;
  Buttons^[NButtons].IX         := (X + Width) - 18;
  Buttons^[NButtons].IY         := Y + 2;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
  FG_SetColor(C.ButtonFace); FG_ClpRect(X,X + Width,Y,Y + 20);
  FG_SetColor(C.ButtonFrame); FG_Box(X,X + Width,Y,Y + 20);
  Draw_Line(X + 1,Y + 19,X + 1,Y + 1,C.ButtonHigh);
  Draw_Line(X + 1,Y + 1,X + 1 + (Width - 2),Y + 1,C.ButtonHigh);
  Draw_Line(X + (Width - 1),Y + 2,X + (Width - 1),Y + 19,C.ButtonLow);
  Draw_Line(X + (Width - 1),Y + 19,X + 2,Y + 19,C.ButtonLow);
  OutText_XY(X + 6,Y + 3,C.ButtonText,2,Title);
  OutText_XY(X + 6,Y + 3,C.ButtonHot,2,COPY(Title,1,1));
  IF HasIcon THEN PutIcon16(Buttons^[NButtons].IX,Buttons^[NButtons].IY,Icon,0);
END;
{}
PROCEDURE Radio_Button(X,Y : WORD ; Return : BYTE);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  Buttons^[NButtons].ButtonType := 2;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Width      := 14;
  Buttons^[NButtons].Height     := 14;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Title      := '';
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  Buttons^[NButtons].HasIcon    := FALSE;
  Buttons^[NButtons].Icon       := 0;
  Buttons^[NButtons].Flip       := 0;
  Buttons^[NButtons].IX         := 0;
  Buttons^[NButtons].IY         := 0;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
  PutIcon16(X,Y,98,0);
END;
{}
PROCEDURE Click_Zone(X,Y,Width,Height : WORD ; Return : BYTE);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  Buttons^[NButtons].ButtonType := 3;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Width      := Width-1;
  Buttons^[NButtons].Height     := Height-1;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Title      := '';
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  Buttons^[NButtons].HasIcon    := FALSE;
  Buttons^[NButtons].Icon       := 0;
  Buttons^[NButtons].Flip       := 0;
  Buttons^[NButtons].IX         := 0;
  Buttons^[NButtons].IY         := 0;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
  FG_SetColor(C.ButtonFrame);
  FG_Box(X,X+(Width-1),Y,Y+(Height-1));
  FrameHigh(X+1,Y+1,X+(Width-2),Y+(Height-2));
END;
{}
PROCEDURE User_Button(X,Y,Width,Height : WORD ; Return : BYTE);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  Buttons^[NButtons].ButtonType := 4;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Width      := Width-1;
  Buttons^[NButtons].Height     := Height-1;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Title      := '';
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  Buttons^[NButtons].HasIcon    := FALSE;
  Buttons^[NButtons].Icon       := 0;
  Buttons^[NButtons].Flip       := 0;
  Buttons^[NButtons].IX         := 0;
  Buttons^[NButtons].IY         := 0;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
  FG_SetColor(C.ButtonFace);
  FG_ClpRect(X,X+(Width-1),Y,Y+(Height-1));
  FG_SetColor(C.ButtonFrame);
  FG_Box(X,X+(Width-1),Y,Y+(Height-1));
  FrameHigh(X+1,Y+1,X+(Width-2),Y+(Height-2));
END;
{}
PROCEDURE Mouse_Field(X,Y,Width,Height : WORD ; Return : BYTE);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  Buttons^[NButtons].ButtonType := 5;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Width      := Width-1;
  Buttons^[NButtons].Height     := Height-1;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Title      := '';
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  Buttons^[NButtons].HasIcon    := FALSE;
  Buttons^[NButtons].Icon       := 0;
  Buttons^[NButtons].Flip       := 0;
  Buttons^[NButtons].IX         := 0;
  Buttons^[NButtons].IY         := 0;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
END;
{}
PROCEDURE Ani_Button(X,Y : WORD ; Icon1,Icon2,Size,BType,Return : BYTE);
BEGIN
  IF NButtons = 0 THEN BEGIN
    NEW(Buttons);
    FILLCHAR(Buttons^,SIZEOF(Buttons^),0);
    Show_Mem;
  END;
  IF NButtons + 1 > 128 THEN EXIT;
  LastPressed := 0;
  INC(NButtons);
  CASE Size OF
    1 : BEGIN
          Buttons^[NButtons].Height := 19;
          Buttons^[NButtons].Width  := 19;
          Buttons^[NButtons].Title  := '1';
        END;
    2 : BEGIN
          Buttons^[NButtons].Height := 33;
          Buttons^[NButtons].Width  := 33;
          Buttons^[NButtons].Title  := '2';
        END;
    3 : BEGIN
          Buttons^[NButtons].Height := 63;
          Buttons^[NButtons].Width  := 63;
          Buttons^[NButtons].Title  := '3';
        END;
  END;
  Buttons^[NButtons].ButtonType := 6;
  Buttons^[NButtons].X          := X;
  Buttons^[NButtons].Y          := Y;
  Buttons^[NButtons].Return     := Return;
  Buttons^[NButtons].Holdable   := TRUE;
  Buttons^[NButtons].FieldOn    := FALSE;
  IF BType = 0 THEN Buttons^[NButtons].HasIcon := FALSE ELSE Buttons^[NButtons].HasIcon := TRUE;
  Buttons^[NButtons].Icon       := Icon1;
  Buttons^[NButtons].Flip       := Icon2;
  Buttons^[NButtons].IX         := Buttons^[NButtons].X + 2;
  Buttons^[NButtons].IY         := Buttons^[NButtons].Y + 2;
  Buttons^[NButtons].ButStr     := #0;
  Buttons^[NButtons].Sound      := #0;
  IF Buttons^[NButtons].HasIcon THEN BEGIN
    FG_SetColor(C.ButtonFace);
    FG_ClpRect(X,X+(Buttons^[NButtons].Width),Y,Y+(Buttons^[NButtons].Height));
    FG_SetColor(C.ButtonFrame);
    FG_Box(X,X+(Buttons^[NButtons].Width),Y,Y+(Buttons^[NButtons].Height));
    FrameHigh(X+1,Y+1,X+(Buttons^[NButtons].Width-1),Y+(Buttons^[NButtons].Height-1));
  END ELSE BEGIN
    FG_SetColor(C.ButtonFrame);
    FG_Box(X,X+(Buttons^[NButtons].Width),Y,Y+(Buttons^[NButtons].Height));
    FrameHigh(X+1,Y+1,X+(Buttons^[NButtons].Width-1),Y+(Buttons^[NButtons].Height-1));
  END;
  CASE Buttons^[NButtons].Title[1] OF
    '1' : PutIcon16(Buttons^[NButtons].IX,Buttons^[NButtons].IY,Buttons^[NButtons].Icon,0);
    '2' : PutIcon30(Buttons^[NButtons].IX,Buttons^[NButtons].IY,Buttons^[NButtons].Icon,0);
    '3' : PutIcon60(Buttons^[NButtons].IX,Buttons^[NButtons].IY,Buttons^[NButtons].Icon,0);
  END;
END;
{}
PROCEDURE PressButton(Num : BYTE);
BEGIN
  HideMouse;
  IF Buttons^[Num].ButtonType = 1 THEN BEGIN
    FG_SetColor(C.ButtonFace);
    FG_ClpRect(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,Buttons^[Num].Y,Buttons^[Num].Y + 20);
    FG_SetColor(C.ButtonFrame);
    FG_Box(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,Buttons^[Num].Y,Buttons^[Num].Y + 20);
    Draw_Line(Buttons^[Num].X + 1,Buttons^[Num].Y + 19,Buttons^[Num].X + 1,Buttons^[Num].Y + 1,C.ButtonLow);
    Draw_Line(Buttons^[Num].X + 1,Buttons^[Num].Y + 1,
              Buttons^[Num].X + 1 + (Buttons^[Num].Width - 2),Buttons^[Num].Y + 1,C.ButtonLow);
    Draw_Line(Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 2,
              Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 19,C.ButtonHigh);
    Draw_Line(Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 19,
              Buttons^[Num].X + 2,Buttons^[Num].Y + 19,C.ButtonHigh);
    OutText_XY(Buttons^[Num].X + 7,Buttons^[Num].Y + 4,C.ButtonText,2,Buttons^[Num].Title);
    OutText_XY(Buttons^[Num].X + 7,Buttons^[Num].Y + 4,C.ButtonHot,2,COPY(Buttons^[Num].Title,1,1));
    IF Buttons^[Num].HasIcon THEN PutIcon16(Buttons^[Num].IX + 1,Buttons^[Num].IY + 1,Buttons^[Num].Icon,0);
  END;
  IF Buttons^[Num].ButtonType = 2 THEN PutIcon16(Buttons^[Num].X,Buttons^[Num].Y,99,0);
  IF (Buttons^[Num].ButtonType > 2) AND (Buttons^[Num].ButtonType < 5) THEN
    FrameLow(Buttons^[Num].X + 1,
             Buttons^[Num].Y + 1,
             Buttons^[Num].X + Buttons^[Num].Width - 1,
             Buttons^[Num].Y + Buttons^[Num].Height - 1);
  IF (Buttons^[Num].ButtonType = 5) THEN BEGIN
    IF Buttons^[Num].FieldOn THEN FrameLow(Buttons^[Num].X,Buttons^[Num].Y,
                                           Buttons^[Num].X + Buttons^[Num].Width,
                                           Buttons^[Num].Y + Buttons^[Num].Height)
    ELSE BEGIN
      FG_SetHPage(1);
      FG_Save(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,
              Buttons^[Num].Y,Buttons^[Num].Y + Buttons^[Num].Height);
      FrameLow(Buttons^[Num].X,Buttons^[Num].Y,
               Buttons^[Num].X + Buttons^[Num].Width,
               Buttons^[Num].Y + Buttons^[Num].Height);
      Buttons^[Num].FieldOn := TRUE;
    END;
  END;
  IF Buttons^[Num].ButtonType = 6 THEN BEGIN
    IF Buttons^[Num].HasIcon THEN BEGIN
      FrameLow(Buttons^[Num].X+1,Buttons^[Num].Y+1,
               Buttons^[Num].X+(Buttons^[Num].Width-1),Buttons^[Num].Y+(Buttons^[Num].Height-1));
      FG_SetColor(C.ButtonFace);
      FG_ClpRect(Buttons^[Num].X+2,Buttons^[Num].X+(Buttons^[Num].Width-2),
                 Buttons^[Num].Y+2,Buttons^[Num].Y+(Buttons^[Num].Height-2));
    END ELSE FrameLow(Buttons^[Num].X+1,Buttons^[Num].Y+1,
                      Buttons^[Num].X+(Buttons^[Num].Width-1),Buttons^[Num].Y+(Buttons^[Num].Height-1));
    CASE Buttons^[Num].Title[1] OF
      '1' : PutIcon16(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Flip,0);
      '2' : PutIcon30(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Flip,0);
      '3' : PutIcon60(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Flip,0);
    END;
  END;
  ShowMouse;
END;
{}
PROCEDURE ReleaseButton(Num : BYTE);
BEGIN
  HideMouse;
  IF Buttons^[Num].ButtonType = 1 THEN BEGIN
  FG_SetColor(C.ButtonFace);
  FG_ClpRect(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,Buttons^[Num].Y,Buttons^[Num].Y + 20);
  FG_SetColor(C.ButtonFrame);
  FG_Box(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,Buttons^[Num].Y,Buttons^[Num].Y + 20);
  Draw_Line(Buttons^[Num].X + 1,Buttons^[Num].Y + 19,
            Buttons^[Num].X + 1,Buttons^[Num].Y + 1,C.ButtonHigh);
  Draw_Line(Buttons^[Num].X + 1,Buttons^[Num].Y + 1,
            Buttons^[Num].X + 1 + (Buttons^[Num].Width-2),Buttons^[Num].Y + 1,C.ButtonHigh);
  Draw_Line(Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 2,
            Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 19,C.ButtonLow);
  Draw_Line(Buttons^[Num].X + (Buttons^[Num].Width - 1),Buttons^[Num].Y + 19,
            Buttons^[Num].X + 2,Buttons^[Num].Y + 19,C.ButtonLow);
  OutText_XY(Buttons^[Num].X + 6,Buttons^[Num].Y + 3,C.ButtonText,2,Buttons^[Num].Title);
  OutText_XY(Buttons^[Num].X + 6,Buttons^[Num].Y + 3,C.ButtonHot,2,COPY(Buttons^[Num].Title,1,1));
  IF Buttons^[Num].HasIcon THEN PutIcon16(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Icon,0);
  END;
  IF Buttons^[Num].ButtonType = 2 THEN PutIcon16(Buttons^[Num].X,Buttons^[Num].Y,98,0);
  IF (Buttons^[Num].ButtonType > 2) AND (Buttons^[Num].ButtonType < 5) THEN
    FrameHigh(Buttons^[Num].X + 1,
              Buttons^[Num].Y + 1,
              Buttons^[Num].X + Buttons^[Num].Width - 1,
              Buttons^[Num].Y + Buttons^[Num].Height - 1);
  IF (Buttons^[Num].ButtonType = 5) AND (Buttons^[Num].FieldOn) THEN BEGIN
    FrameHigh(Buttons^[Num].X,Buttons^[Num].Y,
              Buttons^[Num].X + Buttons^[Num].Width,
              Buttons^[Num].Y + Buttons^[Num].Height);
    Delay(10);
    FG_Restore(Buttons^[Num].X,Buttons^[Num].X + Buttons^[Num].Width,
               Buttons^[Num].Y,Buttons^[Num].Y + Buttons^[Num].Height);
    Buttons^[LastPressed].FieldOn := FALSE;
  END;
  IF Buttons^[Num].ButtonType = 6 THEN BEGIN
    IF Buttons^[Num].HasIcon THEN BEGIN
      FrameHigh(Buttons^[Num].X+1,Buttons^[Num].Y+1,
                Buttons^[Num].X+(Buttons^[Num].Width-1),Buttons^[Num].Y+(Buttons^[Num].Height-1));
      FG_SetColor(C.ButtonFace);
      FG_ClpRect(Buttons^[Num].X+2,Buttons^[Num].X+(Buttons^[Num].Width-2),
                 Buttons^[Num].Y+2,Buttons^[Num].Y+(Buttons^[Num].Height-2));
    END ELSE FrameHigh(Buttons^[Num].X+1,Buttons^[Num].Y+1,
                       Buttons^[Num].X+(Buttons^[Num].Width-1),Buttons^[Num].Y+(Buttons^[Num].Height-1));
    CASE Buttons^[Num].Title[1] OF
      '1' : PutIcon16(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Icon,0);
      '2' : PutIcon30(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Icon,0);
      '3' : PutIcon60(Buttons^[Num].IX,Buttons^[Num].IY,Buttons^[Num].Icon,0);
    END;
  END;
  ShowMouse;
END;
{}
PROCEDURE ProcessButton(xx,yy : WORD);
VAR
  Loop  : WORD;
BEGIN
  {SWITCH ENTRY FIELDS WITH THE MOUSE}
  IF NFields >= 1 THEN FOR Loop := 1 TO NFields DO BEGIN
    IF (xx >= Fields^[Loop].X) AND
       (xx <= Fields^[Loop].Width+12) AND
       (yy >= Fields^[Loop].Y) AND
       (yy <= Fields^[Loop].Y + 20) THEN BEGIN
      IF Loop <> FieldNum THEN BEGIN
        HideMouse;
        ChangeField(Loop);
        ShowMouse;
        EXIT;
      END;
    END;
  END;
  {IF THE USER IS ON THE BUTTON, THEN PUSH THE BUTTON IMAGE DOWN}
  IF (LastPressed = 0) AND (NButtons <> 0) THEN FOR Loop := 1 TO NButtons DO BEGIN
    IF (xx >= Buttons^[Loop].X) AND (xx <= Buttons^[Loop].X + Buttons^[Loop].Width) THEN BEGIN
      IF (yy >= Buttons^[Loop].Y) AND (yy <= Buttons^[Loop].Y + Buttons^[Loop].Height) THEN BEGIN
        LastPressed := Loop;
        PressButton(LastPressed);
        EXIT;
      END;
    END;
  END ELSE IF (LastPressed <> 0) THEN BEGIN
  {IF THE USER MOVED OFF OF THE BUTTON, THEN POP THE BUTTON IMAGE BACK UP}
    IF (xx < Buttons^[LastPressed].X) OR
       (xx > Buttons^[LastPressed].X + Buttons^[LastPressed].Width) OR
       (yy < Buttons^[LastPressed].Y) OR
       (yy > Buttons^[LastPressed].Y + Buttons^[LastPressed].Height) THEN BEGIN
       ReleaseButton(LastPressed);
       LastPressed := 0;
    END;
  END;
END;
{}
Procedure DrawPickListLocator;
CONST LocArray : ARRAY[0..39] OF BYTE = (0,0,0,1,1,
                                         0,0,1,1,1,
                                         0,1,1,1,1,
                                         1,1,1,1,1,
                                         1,1,1,1,1,
                                         0,1,1,1,1,
                                         0,0,1,1,1,
                                         0,0,0,1,1);
VAR
  Work      : WORD;
  Percent   : REAL;
  Pixels    : WORD;
  YRelative : WORD;
  Y         : WORD;
BEGIN
  FOR Work := 0 TO 39 DO IF LocArray[Work] = 1 THEN LocArray[Work] := C.ButtonLow;
  Y := PickInfo.Y + 21;
  IF PickInfo.NumItems > PickInfo.ItemsOnScrn THEN BEGIN
    Work      := (PickInfo.NumItems - PickInfo.ItemsOnScrn);
    Percent   := (PickInfo.Top - 1) / Work;
    Pixels    := (PickInfo.ItemsOnScrn - 2);
    YRelative := Round(Pixels * Percent);
   {IF YRelative = 0 THEN YRelative := 1;}
    PickInfo.Locator := YRelative;
  END ELSE PickInfo.Locator := 0{1};
  IF PickInfo.Locator <> 0 THEN PickInfo.Locator := PickInfo.Locator * 10;
 {Locator Travel Bar}
  FG_SetColor(C.ButtonFace);
  FG_ClpRect(PickInfo.Width + 2,PickInfo.Width + 7,PickInfo.Y + 21,PickInfo.Bottom - 22);
 {PickList Locator}
  FG_Move(PickInfo.Width + 2,Y + (PickInfo.Locator + 7));
  FG_DrwImage(LocArray,5,8);
END;
{}
PROCEDURE New_PickList(X,Y,OnScreen,MaxChars : WORD);
VAR
  Loop  : WORD;
  X2,Y2 : WORD;
BEGIN
  IF MaxChars > 77 THEN MaxChars := 77;
  IF OnScreen > 30 THEN OnScreen := 30;
  NEW(PickList);
  PickInfo.Active      := TRUE;
  PickInfo.Running     := FALSE;
  PickInfo.X           := X;
  PickInfo.Y           := Y;
  PickInfo.Top         := 1;
  PickInfo.NumItems    := 0;
  PickInfo.ItemsOnScrn := OnScreen;
  PickInfo.Current     := 1;
  PickInfo.MaxChars    := MaxChars;
  PickInfo.Locator     := (PickInfo.Y + 21);
 {PickList Play area}
  FG_SetColor(C.TextBack);
  Y2 := Y;
  X2 := X + (MaxChars * 8) + 11;
  PickInfo.Width := X2;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
    PickInfo.Item[Loop] := Y2;
    FG_ClpRect(X,X + (MaxChars * 8) + 10,Y2,Y2 + 12);
    INC(Y2,13);
  END;
  PickInfo.Bottom := Y2;
 {Locator Travel Bar}
  Y2 := Y;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO INC(Y2,13);
  RaisedBox(X2,Y - 1,X2 + 9,Y2);
 {Scroll Bar Buttons}
  Draw_Button(X2,Y - 1,9,72,FALSE,0,'');
  Draw_Button(X2,Y2 - 20,9,80,FALSE,0,'');
  FG_SetColor(0);
  FG_Box(X - 1,X2,Y - 1,Y2);
  DrawPickListLocator;
  Show_Mem;
END;
{}
PROCEDURE AddTo_PickList(InString : STRING);
VAR
  Temp : STRING;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),#32);
  MOVE(InString[1],Temp[1],LENGTH(InString));
  Temp[0] := CHR(PickInfo.MaxChars);
  IF PickInfo.NumItems < 800 THEN BEGIN
    INC(PickInfo.NumItems);
    PickList^[PickInfo.NumItems] := Temp;
  END;
END;
{}
PROCEDURE PickText(X,Y : INTEGER ; Color : BYTE ; St : STRING);
BEGIN
  FG_FontSize(8);
  FG_SetColor(Color);
  FG_Move(X,Y + 7);
  FG_PrintC(St,LENGTH(St));
  FG_FontSize(16);
END;
{}
PROCEDURE SetUp_PickList;
VAR
  Loop : WORD;
  Y    : WORD;
  Cnt  : WORD;
  X2   : WORD;
BEGIN
  PickInfo.Running := TRUE;
  X2               := (PickInfo.MaxChars * 8) + 10;
  Cnt              := PickInfo.Top;
  Y                := PickInfo.Y;
  FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
    IF Cnt <= PickInfo.NumItems THEN BEGIN
      IF Cnt  = PickInfo.Current THEN BEGIN
        FG_SetColor(C.PickHighBack); FG_ClpRect(PickInfo.X,PickInfo.X + X2,Y,Y + 12);
        PickText(PickInfo.X + 6,Y + 3,C.PickHighFore,PickList^[Cnt]);
      END ELSE BEGIN
        FG_SetColor(C.TextBack); FG_ClpRect(PickInfo.X,PickInfo.X + X2,Y,Y + 12);
        PickText(PickInfo.X + 6,Y + 3,C.MsgColor,PickList^[Cnt]);
      END;
    END ELSE;
    INC(Y,13);
    INC(Cnt);
  END;
END;
{}
PROCEDURE Reset_PickList(Item : WORD);
BEGIN
  PickInfo.Current := Item;
  PickInfo.Top     := Item;
  IF PickInfo.Top > (PickInfo.NumItems - PickInfo.ItemsOnScrn) THEN DEC(PickInfo.Top,(PickInfo.ItemsOnScrn - 1));
  IF (PickInfo.Top < 1) OR (PickInfo.Top > 800) THEN PickInfo.Top := 1;
  DrawPickListLocator;
END;
{}
PROCEDURE ScrollPickPgUp;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF (PickInfo.Top > 1) THEN BEGIN
    Temp := PickInfo.Top - PickInfo.ItemsOnScrn;
    IF Temp < 1 THEN Temp := 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top ELSE
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
    THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END ELSE IF (PickInfo.Current <> 1) THEN BEGIN
    PickInfo.Top := 1;
    PickInfo.Current := 1;
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickPgDown;
VAR
  Temp : INTEGER;
BEGIN
  IF PickInfo.NumItems < PickInfo.ItemsOnScrn THEN EXIT;
  IF ((PickInfo.Top + PickInfo.ItemsOnScrn - 1 ) < PickInfo.NumItems) THEN BEGIN
    Temp := PickInfo.Top + PickInfo.ItemsOnScrn;
    IF (Temp > (PickInfo.NumItems - PickInfo.ItemsOnScrn + 1)) THEN Temp := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Top := Temp;
    IF (PickInfo.Current < PickInfo.Top) THEN PickInfo.Current := PickInfo.Top ELSE
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1)
    THEN PickInfo.Current := PickInfo.Top + PickInfo.ItemsOnScrn - 1;
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END ELSE IF (PickInfo.Current <> PickInfo.NumItems) THEN BEGIN
    PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
    PickInfo.Current := PickInfo.NumItems;
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickUp;
BEGIN
  IF PickInfo.Current > 1 THEN BEGIN
    DEC(PickInfo.Current);
    IF (PickInfo.Top > PickInfo.Current) THEN DEC(PickInfo.Top);
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE ScrollPickDown;
BEGIN
  IF PickInfo.Current < PickInfo.NumItems THEN BEGIN
    INC(PickInfo.Current);
    IF (PickInfo.Current > PickInfo.Top + PickInfo.ItemsOnScrn - 1) THEN INC(PickInfo.Top);
    HideMouse;
    DrawPickListLocator;
    SetUp_PickList;
    ShowMouse;
  END;
END;
{}
PROCEDURE SetUp_Scroller;
VAR
  C,Loop : BYTE;
  R      : INTEGER;
BEGIN
  R := Scroller.Y + 1;
  C := Scroller.Top;
  HideMouse;
  FOR Loop := 1 TO 16 DO BEGIN
    FG_SetColor(C);
    FG_ClpRect(Scroller.X+1,Scroller.X+9,R,R+8);
    IF C = Scroller.Current THEN BEGIN
      FG_SetColor(0);
      FG_Rect(Scroller.X+3,Scroller.X+7,R+2,R+6);
      Draw_Mesh(Scroller.X+3,R+2,Scroller.X+7,R+6,255);
    END;
    INC(C);
    INC(R,10);
  END;
  TimeSlice;
  ShowMouse;
END;
{}
PROCEDURE Palette_Scroller(X,Y : WORD);
VAR
  Loop : BYTE;
BEGIN
  Scroller.Active  := TRUE;
  Scroller.X       := X;
  Scroller.Y       := Y+10;
  Scroller.Top     := 0;
  Scroller.Current := 0;
  Scroller.Width   := X+10;
  User_Button(X,Y,11,11,72);
  FG_SetColor(0);
  INC(Y,10);
  FOR Loop := 1 TO 16 DO BEGIN
    FG_Box(X,X+10,Y,Y+10);
    Scroller.Item[Loop] := Y;
    INC(Y,10);
  END;
  Scroller.Bottom := Y;
  User_Button(X,Y,11,11,80);
  SetUp_Scroller;
END;
{}
PROCEDURE FillTextBuffer(F : STRING);
VAR
  Count : INTEGER;
  Txt   : TEXT;
  Limit : WORD;
BEGIN
  IF (NOT FExist(F)) OR (TBuff = NIL) THEN EXIT;
  Count := 0;
  ASSIGN(Txt,F);
  RESET(Txt);
  WHILE (NOT EOF(Txt)) AND (Count <= 799) DO BEGIN
    INC(Count);
    READLN(Txt,TBuff^[Count]);
  END;
  IF TextReader.Active THEN TextReader.Lines := Count;
  CLOSE(Txt);
END;
{}
PROCEDURE New_TextReader(Y : WORD);
BEGIN
  AllowDragging := FALSE;
  NEW(TBuff);
  FILLCHAR(TBuff^,SIZEOF(TBuff^),0);
  TextReader.Active  := TRUE;
  TextReader.Running := FALSE;
  TextReader.Lines   := 0;
  TextReader.X       := 0;
  TextReader.Y       := Y;
  TextReader.Row     := Y + 3;
  TextReader.Col     := 5;
  TextReader.Last    := 1;
  {Text Reader Field & Frame}
  FG_SetColor(C.TextBack); FG_ClpRect(0,639,Y,Y + 381);
  FG_SetColor(0); FG_Box(0,639,Y,Y + 381);
  Draw_Button(575,Y + 387,20,72,TRUE,31,'');
  Draw_Button(606,Y + 387,20,80,TRUE,32,'');
  Show_Mem;
END;
{}
PROCEDURE ShowTextPage;
VAR
  Loop  : INTEGER;
  Mem   : INTEGER;
  Cnt   : INTEGER;
  Row   : INTEGER;
  Flags : BOOLEAN;
  Color : BYTE;
BEGIN
  Cnt                := 0;
  Mem                := TextReader.Last;
  TextReader.Running := TRUE;
  TextReader.Row     := TextReader.Y + 3;
  FOR Loop := Mem TO TextReader.Lines DO BEGIN
    INC(Cnt);
    Color := C.MsgColor;
    Flags := FALSE;
    IF BBSmessages THEN BEGIN
      IF POS(#16,TBuff^[Loop]) = 1 THEN Flags := TRUE ELSE
      IF (POS(#1,TBuff^[Loop]) < 6) AND (POS(#1,TBuff^[Loop]) > 0) THEN Color := C.MsgIDcolor ELSE
      IF (POS('@',TBuff^[Loop]) < 6) AND (POS('@',TBuff^[Loop]) > 0) THEN Color := C.MsgIDcolor ELSE
      IF (POS('>',TBuff^[Loop]) < 6) AND (POS('>',TBuff^[Loop]) > 0) THEN Color := C.QuoteColor ELSE
      IF (POS('--- ',TBuff^[Loop]) = 1) OR (POS(' * Origin:',TBuff^[Loop]) = 1) THEN Color := C.TearColor ELSE
      IF POS('... ',TBuff^[Loop]) = 1 THEN Color := C.QuoteColor ELSE
    END;
    FG_SetColor(C.TextBack); FG_ClpRect(TextReader.Col,638,TextReader.Row,TextReader.Row + 15);
    IF NOT Flags THEN OutText_XY(TextReader.Col,TextReader.Row,Color,3,TBuff^[Loop])
                 ELSE OutText_XY(TextReader.Col,TextReader.Row,C.FlagColor,3,TBuff^[Loop]);
    TextReader.Last := Loop;
    IF (Cnt = 25) AND (TextReader.Last < TextReader.Lines) THEN BEGIN
      INC(TextReader.Last);
      EXIT;
    END;
    IF TextReader.Last < TextReader.Lines THEN INC(TextReader.Row,15);
    IF Loop = TextReader.Lines THEN BEGIN
      Row := TextReader.Row + 15;
      FOR Loop := Cnt TO 24 DO BEGIN
        IF Row >= (TextReader.Y + 381) THEN EXIT;
        FG_SetColor(C.TextBack); FG_ClpRect(TextReader.Col,638,Row,Row + 15);
        INC(Row,15);
      END;
      EXIT;
    END;
  END;
END;
{}
PROCEDURE New_TextEditor(Row : WORD);
BEGIN
  AllowDragging := FALSE;
  NEW(TBuff);
  FILLCHAR(TBuff^,SIZEOF(TBuff^),0);
  TextEditor.Row     := Row + 60;
  TextEditor.Active  := TRUE;
  TextEditor.Running := FALSE;
  TextEditor.Done    := FALSE;
 {StartOffScreenDraw;}
  FG_SetColor(C.Win1Back); FG_ClpRect(0,639,Row,TextEditor.Row+325);
  FG_SetColor(0); FG_Box(0,639,Row,TextEditor.Row+325);
  FrameHigh(1,Row+1,638,TextEditor.Row-1); FrameLow(5,Row+5,634,Row+55);
  FG_SetColor(C.TextBack); FG_ClpRect(0,639,TextEditor.Row,TextEditor.Row + 305);
  FG_SetColor(0); FG_Box(0,639,TextEditor.Row,TextEditor.Row + 305);
  FrameHigh(1,TextEditor.Row+306,638,TextEditor.Row+324);
  ShadowText(6,TextEditor.Row+308,14,0,2,'Press {15}CTRL-K{14} For Editor Help');
  ShadowText(575,TextEditor.Row+308,14,0,2,'Insert={15}ON');
 {EndOffScreenDraw;}
  Show_Mem;
END;
{}
PROCEDURE RunTextEditor; {This is just a text mode editor converted to SVGA.}

PROCEDURE PlaceCursor;
BEGIN
  xx := FG_GetXPos;
  yy := FG_GetYPos;
  OutText_XY(xx,yy-12,15,3,'_');
  FG_Move(xx,yy);
END;

PROCEDURE EraseCursor;
BEGIN
  OutText_XY(xx,yy-12,C.TextBack,3,'_');
  FG_Move(xx,yy);
END;

PROCEDURE sWrite(St : STRING);
VAR
  Len : WORD;
BEGIN
  Len := LENGTH(St) * 8 - 1;
  FG_SetColor(C.TextBack);
  FG_ClpRect((Where_X*8)-5,((Where_X*8)+Len)-5,(Where_Y*16)+TextEditor.Row,(Where_Y*16)+TextEditor.Row+15);
  FG_SetColor(C.MsgColor);
  FG_PrintC(St,LENGTH(St));
  INC(Where_X,LENGTH(St));
END;

PROCEDURE sGotoXY(X,Y : WORD);
BEGIN
  Where_X := X;
  Where_Y := Y;
  FG_Move((X*8)-5,(Y*16)+TextEditor.Row+15);
END;

PROCEDURE sClrEol;
BEGIN
  FG_SetColor(C.TextBack);
  FG_ClpRect((Where_X*8)-5,638,(Where_Y*16)+TextEditor.Row,(Where_Y*16)+15+TextEditor.Row);
END;

PROCEDURE sClrScr;
BEGIN
  FG_SetColor(C.TextBack); FG_ClpRect(1,638,TextEditor.Row+1,TextEditor.Row + 304);
  FG_SetColor(0); FG_Box(0,639,TextEditor.Row,TextEditor.Row + 305);
  Where_X := 1;
  Where_Y := 1;
  sGotoXY(Where_X,Where_Y);
END;

PROCEDURE Display_Header;
VAR
  MsgInf   : TEXT;
  FromName : STRING[70];
  ToName   : STRING[70];
  Subject  : STRING[70];
BEGIN
  IF FExist(FixPath(MsgInfPath) + 'MSGINF') THEN BEGIN
    FromName := '';
    ToName   := '';
    Subject  := '';
    ASSIGN(MsgInf,FixPath(MsgInfPath) + 'MSGINF');
    RESET(MsgInf);
    READLN(MsgInf,FromName);
    READLN(MsgInf,ToName);
    READLN(MsgInf,Subject);
    CLOSE(MsgInf);
    ShadowText(10,TextEditor.Row-53,14,0,2,'From: {15}' + FromName);
    ShadowText(26,TextEditor.Row-38,14,0,2,'To: {15}' + ToName);
    ShadowText(14,TextEditor.Row-23,14,0,2,'Subj: {15}' + Subject);
  END ELSE ShadowText(10,TextEditor.Row-38,14,0,2,'Editing Text File: {15}' + AllCaps(EditorFile));
END;

PROCEDURE Insert_Line(Contents : STRING);
VAR
  I : INTEGER;
BEGIN
  FOR I := Max_Msg_Lines DOWNTO CLine + 1 DO TBuff^[I] := TBuff^[I - 1];
  TBuff^[CLine] := Contents;
  IF CLine < LineCnt THEN INC(LineCnt);
  IF CLine > LineCnt THEN LineCnt := CLine;
END;

PROCEDURE Delete_Line;
VAR
  I : INTEGER;
BEGIN
  FOR I := CLine TO Max_Msg_Lines DO TBuff^[I] := TBuff^[I + 1];
  TBuff^[Max_Msg_Lines] := '';
  IF (CLine <= LineCnt) AND (LineCnt > 1) THEN DEC(LineCnt);
END;

PROCEDURE Remove_Trailing;
BEGIN
  WHILE TBuff^[CLine][LENGTH(TBuff^[CLine])] = ' ' DO DELETE(TBuff^[CLine],LENGTH(TBuff^[CLine]),1);
END;

PROCEDURE Append_Space;
BEGIN
  TBuff^[CLine] := TBuff^[CLine] + ' ';
END;

FUNCTION Curlength : INTEGER;
BEGIN
  CurLength := LENGTH(TBuff^[CLine]);
END;

PROCEDURE Count_Lines;
BEGIN
  LineCnt := Max_Msg_Lines;
  WHILE (LineCnt > 1) AND (LENGTH(TBuff^[LineCnt]) = 0) DO DEC(LineCnt);
END;

FUNCTION Line_Boundry : BOOLEAN;
BEGIN
  Line_Boundry := (CCol = 1) OR (CCol > CurLength);
END;

FUNCTION CurChar : CHAR;
BEGIN
  IF CCol <= CurLength THEN CurChar := TBuff^[CLine][CCol] ELSE CurChar := ' ';
END;

FUNCTION Delimiter : BOOLEAN;
BEGIN
  CASE CurChar OF
    '0'..'9','a'..'z','A'..'Z','_' : Delimiter := FALSE;
    ELSE Delimiter := TRUE;
  END;
END;

FUNCTION LastChar : CHAR;
BEGIN
  IF CurLength = 0 THEN LastChar := ' ' ELSE LastChar := TBuff^[CLine][CurLength];
END;

PROCEDURE Reposition;
VAR
  Eol : INTEGER;
BEGIN
  Eol := CurLength + 1;
  IF CCol > Eol THEN CCol := Eol;
  Count_Lines;
  sGotoXY(CCol,CLine - TopLine + TopScreen);
END;

PROCEDURE Set_PhyLine;
BEGIN
  PhyLine[CLine - TopLine + 1] := TBuff^[CLine];
END;

PROCEDURE Update_Eol;
BEGIN
  Remove_Trailing;
  Reposition;
  sClrEol;
  Set_PhyLine;
END;

PROCEDURE Refresh_Screen;
VAR
  PLine  : INTEGER;
  PCol   : INTEGER;
  PhLine : INTEGER;
BEGIN
  IF (CLine >= Max_Msg_Lines) THEN CLine := Max_Msg_Lines;
  PLine := CLine;
  CLine := TopLine;
  PCol  := CCol;
  CCol  := 1;
  FOR CLine := TopLine TO TopLine + ScrLines - 1 DO BEGIN
    PhLine := CLine - TopLine + 1;
    IF CLine > Max_Msg_Lines THEN BEGIN
      Reposition;
      sWrite('-- Message Limit --');
      PhyLine[PhLine] := '-- Message Limit --';
      sClrEol;
    END ELSE BEGIN
      IF TBuff^[CLine] <> PhyLine[PhLine] THEN BEGIN
        Reposition;
        IF CurLength > 0 THEN sWrite(TBuff^[CLine]);
        IF CurLength < LENGTH(PhyLine[PhLine]) THEN sClrEol;
        Set_PhyLine;
      END;
    END;
  END;
  CCol  := PCol;
  CLine := PLine;
  Reposition;
END;

PROCEDURE Scroll_Screen(Lines : INTEGER);
BEGIN
  INC(Topline,Lines);
  IF (CLine < TopLine) OR (CLine >= TopLine + ScrLines) THEN TopLine := CLine - ScrLines DIV 2;
  IF TopLine < 1 THEN TopLine := 1 ELSE
  IF TopLine >= Max_Msg_Lines THEN DEC(Topline,ScrollSiz DIV 2);
  Refresh_Screen;
END;

PROCEDURE Cursor_Up;
BEGIN
  IF CLine > 1 THEN DEC(CLine);
  IF CLine < TopLine THEN Scroll_Screen( - ScrollSiz) ELSE Reposition;
END;

PROCEDURE Cursor_Down;
BEGIN
  INC(CLine);
  IF (CLine >= Max_Msg_Lines) THEN CLine := Max_Msg_Lines;
  IF (CLine - TopLine >= ScrLines) THEN Scroll_Screen(ScrollSiz) ELSE Reposition;
END;

PROCEDURE Cursor_EndLine;
BEGIN
  CCol := 79;
  Reposition;
END;

PROCEDURE Cursor_BegLine;
BEGIN
  CCol := 1;
  Reposition;
END;

PROCEDURE Cursor_Left;
BEGIN
  IF CCol = 1 THEN BEGIN
    Cursor_Up;
    Cursor_Endline;
  END ELSE BEGIN
    DEC(CCol);
    sGotoXY(Where_X - 1,Where_Y);
  END;
END;

PROCEDURE Cursor_Right;
BEGIN
  IF CCol > CurLength THEN BEGIN
    CCol := 1;
    Cursor_Down;
  END ELSE BEGIN
    sWrite(CurChar);
    INC(CCol);
  END;
END;

PROCEDURE Cursor_WordRight;
BEGIN
  IF Delimiter THEN BEGIN
    REPEAT
      Cursor_Right;
      IF Line_Boundry THEN EXIT;
    UNTIL NOT Delimiter;
  END ELSE BEGIN
    REPEAT
      Cursor_Right;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_WordRight;
  END;
END;

PROCEDURE Cursor_WordLeft;
BEGIN
  IF Delimiter THEN BEGIN
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL NOT Delimiter;
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_Right;
  END ELSE BEGIN
    REPEAT
      Cursor_Left;
      IF Line_Boundry THEN EXIT;
    UNTIL Delimiter;
    Cursor_Wordleft;
  END;
END;

PROCEDURE Join_Lines;
BEGIN
  IF (CurLength + LENGTH(TBuff^[CLine + 1])) >= 79 THEN EXIT;
  IF (LastChar <> ' ') THEN Append_Space;
  TBuff^[CLine] := TBuff^[CLine] + TBuff^[CLine + 1];
  INC(CLine);
  Delete_Line;
  DEC(CLine);
  Refresh_Screen;
END;

PROCEDURE Split_Line;
VAR
  PCol : INTEGER;
BEGIN
  PCol := CCol;
  Remove_Trailing;
  Par := COPY(TBuff^[CLine],CCol,79);
  TBuff^[CLine][0] := CHR(CCol - 1);
  Update_Eol;
  CCol := 1;
  INC(CLine);
  Insert_Line(Par);
  IF CLine - TopLine > ScrLines - 2 THEN Scroll_Screen(ScrollSiz) ELSE Refresh_Screen;
  DEC(CLine);
  CCol := PCol;
END;

PROCEDURE Cursor_NewLine;
BEGIN
  IF Insert_Mode THEN Split_Line;
  CCol := 1;
  Cursor_Down;
END;

PROCEDURE Reformat_Paragraph;
BEGIN
  Remove_Trailing;
  CCol := CurLength;
  WHILE CurChar <> ' ' DO BEGIN
    REPEAT
      INC(CLine);
      Remove_Trailing;
      CCol := 1;
      WHILE CurChar <> ' ' DO INC(CCol);
      DEC(CLine);
      IF (CCol > 1) AND (CCol + CurLength < WWrap) THEN BEGIN
        IF CurLength > 0 THEN BEGIN
          CASE LastChar OF
            '.','?','!' : Append_Space;
          END;
          Append_Space;
        END;
        TBuff^[CLine] := TBuff^[CLine] + COPY(TBuff^[CLine + 1],1,CCol - 1);
        INC(CLine);
        WHILE (CurChar = ' ') AND (CCol <= CurLength) DO INC(CCol);
        DELETE(TBuff^[CLine],1,CCol - 1);
        IF CurLength = 0 THEN Delete_Line;
        DEC(CLine);
      END ELSE CCol := 0;
    UNTIL CCol = 0;
    INC(CLine);
    CCol := 1;
    Remove_Trailing;
  END;
END;

PROCEDURE Visual_Reformat;
VAR
  PLine : INTEGER;
BEGIN
  PLine := CLine;
  Reformat_Paragraph;
  WHILE (CurLength = 0) AND (CLine <= LineCnt) DO INC(CLine);
  WHILE CLine - TopLine > ScrLines - 2 DO BEGIN
    INC(TopLine,ScrollSiz);
    PLine := TopLine;
  END;
  Refresh_Screen;
END;

PROCEDURE Word_Wrap;
VAR
  PCol  : INTEGER;
  PLine : INTEGER;
BEGIN
  PCol  := CCol;
  PLine := CLine;
  CCol  := CurLength;
  IF CurChar = ' ' THEN BEGIN
    Cursor_NewLine;
    EXIT;
  END;
  WHILE (CCol > 0) AND (CurChar <> ' ') DO DEC(CCol);
  IF CCol = 0 THEN BEGIN
    CCol := 1;
    Cursor_Down;
    EXIT;
  END;
  Par := COPY(TBuff^[CLine],CCol + 1,79);
  TBuff^[CLine][0] := CHR(CCol);
  Update_Eol;
  INC(CLine);
  Insert_Line(Par);
  Reformat_Paragraph;
  CLine := PLine;
  IF PCol > CurLength THEN BEGIN
    CCol := PCol - CurLength - 1;
    Cursor_Down;
  END ELSE CCol := PCol;
  IF (CLine - TopLine >= ScrLines) THEN Scroll_Screen(ScrollSiz)
                                   ELSE Refresh_Screen;
END;

PROCEDURE Insert_Char(Ch : CHAR);
BEGIN
  IF CCol < CurLength THEN Remove_Trailing;
  IF (Insert_Mode AND (CurLength = WWrap)) OR (CCol > WWrap) THEN BEGIN
    IF (CCol <= WWrap) THEN
      Word_Wrap
    ELSE IF Ch = ' ' THEN BEGIN
      Cursor_NewLine;
      EXIT;
    END ELSE Word_Wrap;
  END;
  Count_Lines;
  IF Insert_Mode AND (CCol <= CurLength) THEN BEGIN
    INSERT(Ch,TBuff^[cline],ccol);
    sWrite(COPY(TBuff^[CLine],CCol,79));
    INC(CCol);
    Reposition;
  END ELSE BEGIN
    WHILE CurLength < CCol DO Append_Space;
    TBuff^[CLine][CCol] := Ch;
    Cursor_Right;
  END;
  Set_Phyline;
END;

PROCEDURE Delete_Char;
BEGIN
  IF CCol > CurLength THEN Join_Lines ELSE
  IF CCol <= CurLength THEN BEGIN
    DELETE(TBuff^[CLine],CCol,1);
    sWrite(COPY(TBuff^[CLine],CCol,79));
    sWrite(' ');
    Reposition;
    Set_Phyline;
  END;
END;

PROCEDURE Delete_WordRight;
BEGIN
  IF CurChar = ' ' THEN REPEAT
    Delete_Char;
  UNTIL (CurChar <> ' ') OR (CCol > CurLength) ELSE REPEAT
    Delete_Char;
  UNTIL Delimiter;
END;

PROCEDURE Cursor_Tab;
BEGIN
  REPEAT Insert_Char(' ') UNTIL (CCol MOD 8) = 0;
END;

PROCEDURE Page_Down;
BEGIN
  IF Topline + ScrLines < Max_Msg_Lines THEN BEGIN
    INC(CLine,ScrollSiz);
    Scroll_Screen(ScrollSiz);
  END;
END;

PROCEDURE Page_Up;
BEGIN
  IF TopLine > 1 THEN BEGIN
    DEC(CLine,ScrollSiz);
    IF CLine < 1 THEN Cline := 1;
    Scroll_Screen( - ScrollSiz);
  END;
END;

PROCEDURE Visual_Insert_Line;
BEGIN
  Insert_Line('');
  IF CLine - TopLine > ScrLines - 2 THEN Scroll_Screen(ScrollSiz)
                                    ELSE Refresh_Screen;
END;

PROCEDURE Visual_Delete_Line;
BEGIN
  Delete_Line;
  Refresh_Screen;
END;

PROCEDURE Display_Insert_Status;
BEGIN
  FG_SetColor(C.Win1Back);
  FG_ClpRect(575,636,TextEditor.Row+308,TextEditor.Row+322);
  IF Insert_Mode THEN ShadowText(575,TextEditor.Row+308,14,0,2,'Insert={15}ON')
                 ELSE ShadowText(575,TextEditor.Row+308,14,0,2,'Insert={15}OFF');
END;

PROCEDURE Prepare_Screen;
VAR
  I : INTEGER;
BEGIN
  sClrScr;
  Linenum := 1;
  FOR I := 1 TO Scrlines DO PhyLine[I] := '';
  PLeft := - 1;
  Display_Header;
  Scroll_Screen(0);
END;

PROCEDURE ReDisplay;
BEGIN
  TopLine := CLine - ScrLines DIV 2;
  Prepare_Screen;
END;

PROCEDURE DoHelp;
BEGIN
  xx := FG_GetXPos;
  yy := FG_GetYPos;
  Draw_Window(15,136,616,336,5,'Editor Help');
  FrameLow(25,170,275,265);
  ShadowText(30,174,11,0,2,'Cursor Movement:');
  FrameLow(25,170,141,194);
  ShadowText(31,200,14,0,2,'CTRL-S: {15}Cursor Left');
  ShadowText(30,215,14,0,2,'CTRL-A: {15}Word Left');
  ShadowText(31,230,14,0,2,'CTRL-E: {15}Cursor Up');
  ShadowText(34,245,14,0,2,'CTRL-I: {15}Tab');
  ShadowText(150,200,14,0,2,'CTRL-D: {15}Cursor Right');
  ShadowText(151,215,14,0,2,'CTRL-F: {15}Word Right');
  ShadowText(150,230,14,0,2,'CTRL-X: {15}Cursor Down');
  ShadowText(150,245,14,0,2,'CTRL-P: {15}End');
  FrameLow(25,275,275,325);
  ShadowText(30,279,11,0,2,'Page Scrolling:');
  FrameLow(25,275,141,299);
  ShadowText(30,305,14,0,2,'CTRL-R: {15}Page Up');
  ShadowText(150,305,14,0,2,'CTRL-C: {15}Page Down');
  FrameLow(285,170,415,265);
  ShadowText(290,174,11,0,2,'Deletion:');
  FrameLow(285,170,343,194);
  ShadowText(290,200,14,0,2,'CTRL-G: {15}Delete');
  ShadowText(290,215,14,0,2,'CTRL-J: {15}Join Lines');
  ShadowText(290,230,14,0,2,'CTRL-T: {15}Delete Word');
  ShadowText(290,245,14,0,2,'CTRL-Y: {15}Delete Line');
  FrameLow(285,275,415,325);
  ShadowText(290,279,11,0,2,'Import:');
  FrameLow(285,275,343,299);
  ShadowText(290,305,14,0,2,'CTRL-U: {15}Import File');
  FrameLow(425,170,605,265);
  ShadowText(430,175,11,0,2,'Miscellaneous:');
  FrameLow(425,170,517,194);
  ShadowText(430,200,14,0,2,'CTRL-B: {15}Reformat Paragraph');
  ShadowText(430,215,14,0,2,'CTRL-V: {15}Toggle Insert');
  ShadowText(430,230,14,0,2,'CRTL-Q: {15}Abort Editing');
  ShadowText(430,245,14,0,2,'CTRL-Z: {15}Save and Exit');
  FrameLow(425,275,605,325);
  ShadowText(439,292,0,250,2,'Press Any Key To Continue');
  REPEAT SliceMouse UNTIL KEYPRESSED;
  Kill_Window;
  HideMouse;
  FG_Move(xx,yy);
END;

FUNCTION Visual_Edit : BOOLEAN;
VAR
  Key    : CHAR;
  I      : INTEGER;
  St     : STRING[79];
  F      : TEXT;
  ButNum : BYTE;
BEGIN
  LineCnt := 1;
  CLine   := LineCnt;
  CCol    := 1;
  TopLine := 1;
  WHILE (CLine - TopLine) > (ScrollSiz + 3) DO INC(TopLine,ScrollSiz);
  Prepare_Screen;
  REPEAT
    PlaceCursor;
    REPEAT SliceMouse UNTIL KEYPRESSED;
    Key := READKEY;
    EraseCursor;
    IF Key = #0 THEN BEGIN
      Key := READKEY;
      CASE Key OF
        #71 : Key := ^L; {Home}
        #72 : Key := ^E; {UpArrow}
        #73 : Key := ^R; {PgUp}
        #75 : Key := ^S; {LeftArrow}
        #77 : Key := ^D; {RightArrow}
        #79 : Key := ^P; {End}
        #80 : Key := ^X; {DownArrow}
        #81 : Key := ^C; {PgDn}
        #82 : Key := ^V; {Ins}
        #83 : Key := ^G; {Del}
        #115: Key := ^A; {Ctrl-Left}
        #116: Key := ^F; {Ctlr-Right}
        #132: BEGIN      {Ctrl-PgUp}
                CLine := 1;
                Scroll_Screen(0);
                Key := #0;
              END;
        #118: BEGIN      {Ctrl-PgDn}
                CLine := LineCnt;
                Scroll_Screen(0);
                Key := #0;
              END;
        ELSE Key := #0;
      END;
    END;
    CASE Key OF
      ^A : Cursor_WordLeft;
      ^B : Visual_Reformat;
      ^C : Page_Down;
      ^D : Cursor_Right;
      ^E : Cursor_Up;
      ^F : Cursor_WordRight;
      ^G : Delete_Char;
      ^I : Cursor_Tab;
      ^J : Join_Lines;
      ^K : DoHelp;
      ^L : Cursor_BegLine;
      ^M : Cursor_NewLine;
      ^N : BEGIN
             Split_Line;
             Reposition;
           END;
      ^O : Redisplay;
      ^P : Cursor_EndLine;
      ^R : Page_Up;
      ^S : Cursor_Left;
      ^T : Delete_WordRight;
      ^V : BEGIN
             Insert_Mode := NOT Insert_Mode;
             Display_Insert_Status;
             Reposition;
           END;
      ^X : Cursor_Down;
      ^Y : Visual_Delete_Line;
      #$7f,
      ^H : BEGIN
             Cursor_Left;
             IF Insert_Mode THEN Delete_Char;
           END;
      ^U : BEGIN {Import text}
             Draw_Window(93,212,550,277,5,'Full Path And File Name To Import');
             Entry_Field(104,246,5,60,0,'');
             Draw_Button(484,246,55,24,TRUE,4,'Okay');
             ShowMouse;
             REPEAT ButNum := MouseHandler(TRUE) UNTIL ButNum <> 0;
             St := StripBoth(Fields^[1].Text,' ');
             Kill_Window;
             HideMouse;
             IF (St <> '') AND (FExist(St)) THEN BEGIN
               ASSIGN(F,St);
               RESET(F);
               WHILE (NOT EOF(F)) AND (LineCnt < 400) DO BEGIN
                 INC(LineCnt);
                 READLN(F,St);
                 TBuff^[LineCnt] := St;
               END;
               CLOSE(F);
               Scroll_Screen(0);
             END;
             FG_Move(xx,yy);
           END;
      #27: ;
      #32..#255 : Insert_Char(Key);
    END;
    ClearKeyBuffer;
  UNTIL (Key = ^Q) OR (Key = ^Z);
  IF Key = ^Q THEN Visual_Edit := FALSE ELSE Visual_Edit := TRUE;
  ConvertIt       := TRUE;
  TextEditor.Done := TRUE;
END;

VAR
  F : TEXT;
  N : WORD;
BEGIN
  TextEditor.Running := TRUE;
  IF NOT Visual_Edit THEN EXIT;
  Count_Lines;
  IF LineCnt <> 0 THEN BEGIN
    ASSIGN(F,EditorFile);
    REWRITE(F);
    FOR N := 1 TO LineCnt DO WRITELN(F,TBuff^[N]);
    CLOSE(F);
  END;
END;
{}
FUNCTION _Mid(InString : STRING ; Starting,Ending : BYTE) : STRING;
VAR
  NumberOfChars : BYTE;
BEGIN
  IF Ending >= Starting THEN BEGIN
    NumberOfChars := Ending - Starting + 1;
   _Mid := COPY(InString,Starting,NumberOfChars);
  END ELSE _Mid := '';
END;
{}
PROCEDURE StartWindowDrag;
BEGIN
  DragActive := TRUE;
  HideMouse;
  FG_MakePcx(WRec.X1,WRec.X2,WRec.Y1,WRec.Y2,WinTag+'DRAG'+WinTag+'.IMG'#0);
  OrgX := WRec.X1;
  OrgY := WRec.Y1;
  OldX := WRec.X1;
  OldY := WRec.Y1;
  FG_MouseMov(OldX,OldY);
  FG_SetColor(255);
  FG_BoxDepth(3,3);
  FG_BoxX(OldX,OldX+(WRec.X2-WRec.X1),OldY,OldY+(WRec.Y2-WRec.Y1));
END;
{}
PROCEDURE UpdateWindowDrag(xx,yy : INTEGER);
BEGIN
  IF (xx <> OldX) OR (yy <> OldY) THEN BEGIN
    FG_SetColor(255);
    FG_BoxX(OldX,OldX+(WRec.X2-WRec.X1),OldY,OldY+(WRec.Y2-WRec.Y1));
    IF (xx+(WRec.X2-WRec.X1) > 639) OR (yy+(WRec.Y2-WRec.Y1) > 479) THEN FG_MouseMov(OldX,OldY) ELSE BEGIN
      OldX := xx;
      OldY := yy;
    END;
    FG_BoxX(OldX,OldX+(WRec.X2-WRec.X1),OldY,OldY+(WRec.Y2-WRec.Y1));
  END;
END;
{}
PROCEDURE EndWindowDrag(xx,yy : INTEGER);
VAR
  Loop : BYTE;
BEGIN
  DragActive := FALSE;
  FG_SetColor(255);
  FG_BoxX(OldX,OldX+(WRec.X2-WRec.X1),OldY,OldY+(WRec.Y2-WRec.Y1));
  FG_ShowPcx(WinTag+'SCR'+IntToStr(WindowNumber-1)+WinTag+'.'+IntToStr(WindowNumber-1)+#0,0);
  FG_Move(xx,yy);
  FG_ShowPcx(WinTag+'DRAG'+WinTag+'.IMG'#0,2);
  FErase(WinTag+'DRAG'+WinTag+'.IMG');
  IF xx > OrgX THEN BEGIN
    INC(WRec.X1,(xx-OrgX));
    INC(WRec.X2,(xx-OrgX));
    INC(TvPort.StartX,(xx-OrgX));
    INC(Scroller.X,(xx-OrgX));
    INC(Scroller.Width,(xx-OrgX));
    INC(PickInfo.X,(xx-OrgX));
    INC(PickInfo.Width,(xx-OrgX));
  END ELSE BEGIN
    DEC(WRec.X1,(OrgX-xx));
    DEC(WRec.X2,(OrgX-xx));
    DEC(TvPort.StartX,(OrgX-xx));
    DEC(Scroller.X,(OrgX-xx));
    DEC(Scroller.Width,(OrgX-xx));
    DEC(PickInfo.X,(OrgX-xx));
    DEC(PickInfo.Width,(OrgX-xx));
  END;
  IF yy > OrgY THEN BEGIN
    INC(WRec.Y1,(yy-OrgY));
    INC(WRec.Y2,(yy-OrgY));
    INC(TvPort.StartY,(yy-OrgY));
    INC(Scroller.Y,(yy-OrgY));
    INC(Scroller.Bottom,(yy-OrgY));
    FOR Loop := 1 TO 16 DO INC(Scroller.Item[Loop],(yy-OrgY));
    INC(PickInfo.Y,(yy-OrgY));
    INC(PickInfo.Bottom,(yy-OrgY));
    FOR Loop := 1 TO PickInfo.ItemsOnScrn DO INC(PickInfo.Item[Loop],(yy-OrgY));
  END ELSE BEGIN
    DEC(WRec.Y1,(OrgY-yy));
    DEC(WRec.Y2,(OrgY-yy));
    DEC(TvPort.StartY,(OrgY-yy));
    DEC(Scroller.Y,(OrgY-yy));
    DEC(Scroller.Bottom,(OrgY-yy));
    FOR Loop := 1 TO 16 DO DEC(Scroller.Item[Loop],(OrgY-yy));
    DEC(PickInfo.Y,(OrgY-yy));
    DEC(PickInfo.Bottom,(OrgY-yy));
    FOR Loop := 1 TO PickInfo.ItemsOnScrn DO DEC(PickInfo.Item[Loop],(OrgY-yy));
  END;
  IF NButtons >= 1 THEN FOR Loop := 1 TO NButtons DO BEGIN
    IF xx > OrgX THEN BEGIN
      INC(Buttons^[Loop].X,(xx-OrgX));
      INC(Buttons^[Loop].IX,(xx-OrgX));
    END ELSE BEGIN
      DEC(Buttons^[Loop].X,(OrgX-xx));
      DEC(Buttons^[Loop].IX,(OrgX-xx));
    END;
    IF yy > OrgY THEN BEGIN
      INC(Buttons^[Loop].Y,(yy-OrgY));
      INC(Buttons^[Loop].IY,(yy-OrgY));
    END ELSE BEGIN
      DEC(Buttons^[Loop].Y,(OrgY-yy));
      DEC(Buttons^[Loop].IY,(OrgY-yy));
    END;
  END;
  IF NFields >= 1 THEN FOR Loop := 1 TO NFields DO BEGIN
    IF xx > OrgX THEN BEGIN
      INC(Fields^[Loop].X,(xx-OrgX));
      INC(Fields^[Loop].Width,(xx-OrgX));
    END ELSE BEGIN
      DEC(Fields^[Loop].X,(OrgX-xx));
      DEC(Fields^[Loop].Width,(OrgX-xx));
    END;
    IF yy > OrgY THEN INC(Fields^[Loop].Y,(yy-OrgY)) ELSE DEC(Fields^[Loop].Y,(OrgY-yy));
  END;
  IF NFlips >= 1 THEN FOR Loop := 1 TO NFlips DO BEGIN
    IF xx > OrgX THEN INC(IconFlip^[Loop].X,(xx-OrgX)) ELSE DEC(IconFlip^[Loop].X,(OrgX-xx));
    IF yy > OrgY THEN INC(IconFlip^[Loop].Y,(yy-OrgY)) ELSE DEC(IconFlip^[Loop].Y,(OrgY-yy));
  END;
  FG_SetColor(0);
  FG_ClpRect(WRec.X1 + 5,WRec.X2 + 2,WRec.Y2 + 1,WRec.Y2 + 2);
  FG_ClpRect(WRec.X2 + 1,WRec.X2 + 2,WRec.Y1 + 5,WRec.Y2);
  FG_BoxDepth(1,1);
  Show_Mem;
  ShowMouse;
END;
{}
FUNCTION MouseHandler(DoKeys : BOOLEAN) : BYTE;
VAR
  W         : BYTE;
  xx        : INTEGER;
  yy        : INTEGER;
  bb        : INTEGER;
  TheOne    : INTEGER;
  DidAPress : BOOLEAN;
  ThePress  : BYTE;
  Loop      : INTEGER;
PROCEDURE HandleKeys;
VAR
  ThePos : BYTE;
LABEL DnArrow;
BEGIN
  MC := READKEY;
  IF NFields = 0 THEN BEGIN
    IF ORD(MC) = 0 THEN BEGIN
      AltKey := TRUE;
      MC     := READKEY;
      ClearKeyBuffer;
      IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) THEN BEGIN
        CASE ORD(MC) OF
          72 : BEGIN {Up}
                 IF PickInfo.Active THEN ScrollPickUp;
                 IF TextReader.Active THEN BEGIN
                   DEC(TextReader.Last,26);
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top >= 1 THEN DEC(Scroller.Top);
                   SetUp_Scroller;
                 END;
               END;
          80 : BEGIN {Down}
                 IF Pickinfo.Active THEN ScrollPickDown;
                 IF (TextReader.Active) AND (TextReader.Last <= TextReader.Lines) THEN BEGIN
                   DEC(TextReader.Last,24);
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top <= 238 THEN INC(Scroller.Top);
                   SetUp_Scroller;
                 END;
               END;
          73 : BEGIN {PgUp}
                 IF PickInfo.Active THEN ScrollPickPgUp;
                 IF TextReader.Active THEN BEGIN
                   DEC(TextReader.Last,50);
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top >= 16 THEN DEC(Scroller.Top,16) ELSE Scroller.Top := 0;
                   SetUp_Scroller;
                 END;
               END;
          81 : BEGIN {PgDn}
                 IF PickInfo.Active THEN ScrollPickPgDown;
                 IF (TextReader.Active) AND (TextReader.Last < TextReader.Lines) THEN BEGIN
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   IF Scroller.Top <= 222 THEN INC(Scroller.Top,16) ELSE Scroller.Top := 239;
                   SetUp_Scroller;
                 END;
               END;
         132 : BEGIN {CTRL+PgUp}
                 IF PickInfo.Active THEN BEGIN
                   IF (PickInfo.Current <> 1) THEN BEGIN
                     PickInfo.Top := 1;
                     PickInfo.Current := 1;
                     HideMouse;
                     DrawPickListLocator;
                     SetUp_PickList;
                     ShowMouse;
                   END;
                 END;
                 IF TextReader.Active THEN BEGIN
                   TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   Scroller.Top := 0;
                   SetUp_Scroller;
                 END;
               END;
         118 : BEGIN {CTRL+PgDn}
                 IF PickInfo.Active THEN BEGIN
                   IF (PickInfo.NumItems > PickInfo.ItemsOnScrn) THEN BEGIN
                     IF (PickInfo.Top <> PickInfo.NumItems - PickInfo.ItemsOnScrn + 1) THEN BEGIN
                       PickInfo.Top := PickInfo.NumItems - PickInfo.ItemsOnScrn + 1;
                       PickInfo.Current := PickInfo.NumItems;
                       HideMouse;
                       DrawPickListLocator;
                       SetUp_PickList;
                       ShowMouse;
                     END;
                   END;
                 END;
                 IF TextReader.Active THEN BEGIN
                   TextReader.Last := TextReader.Lines - 24;
                   IF TextReader.Last < 1 THEN TextReader.Last := 1;
                   HideMouse;
                   ShowTextPage;
                   ShowMouse;
                 END;
                 IF Scroller.Active THEN BEGIN
                   Scroller.Top := 239;
                   SetUp_Scroller;
                 END;
               END;
          ELSE BEGIN
            DidAPress := TRUE;
            ThePress  := ORD(MC);
          END;
        END;
      END ELSE BEGIN
        DidAPress := TRUE;
        ThePress  := ORD(MC);
      END;
    END;
    EXIT;
  END;
  HideMouse;
  CASE ORD(MC) OF
    13 : BEGIN
           MC := #80;
           AltKey := TRUE;
           GOTO DnArrow;
         END;
     0 : BEGIN
           AltKey := TRUE;
           MC     := READKEY;
           ClearKeyBuffer;
           CASE ORD(MC) OF
            15,72 : BEGIN {SHIFT TAB & UpArrow}
                      IF FieldNum = 1 THEN ChangeField(NFields) ELSE ChangeField(FieldNum - 1);
                    END;
             80   : BEGIN {DownArrow}
                      DnArrow :
                      IF FieldNum = NFields THEN ChangeField(1) ELSE ChangeField(FieldNum + 1);
                    END;
             71   : BEGIN {HOME}
                      IF Fields^[FieldNum].CursorPos <> 1 THEN BEGIN
                        Fields^[FieldNum].CursorPos := 1;
                        RedrawField;
                      END;
                    END;
             79   : BEGIN {END}
                      IF Fields^[FieldNum].CursorPos <> LENGTH(Fields^[FieldNum].Text) + 1 THEN BEGIN
                        Fields^[FieldNum].CursorPos := LENGTH(Fields^[FieldNum].Text) + 1;
                        RedrawField;
                      END;
                    END;
             75   : BEGIN {Left}
                      IF (Fields^[FieldNum].CursorPos > 1) THEN BEGIN
                        DEC(Fields^[FieldNum].CursorPos);
                        RedrawField;
                      END;
                    END;
             77   : BEGIN {Right}
                      IF (Fields^[FieldNum].CursorPos < LENGTH(Fields^[FieldNum].Text) + 1) THEN BEGIN
                        INC(Fields^[FieldNum].CursorPos);
                        RedrawField;
                      END;
                    END;
             83   : BEGIN {DELETE}
                      ThePos := Fields^[FieldNum].CursorPos;
                      IF (ThePos <= LENGTH(Fields^[FieldNum].Text)) THEN BEGIN
                        Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) +
                        _Mid(Fields^[FieldNum].Text,ThePos + 1,LENGTH(Fields^[FieldNum].Text));
                        RedrawField;
                      END;
                    END;
                    ELSE BEGIN
                      DidAPress := TRUE;
                      ThePress  := ORD(MC);
                      AltKey    := TRUE;
                    END;
           END;
         END;
     8 : BEGIN {BACKSPACE}
           ThePos := Fields^[FieldNum].CursorPos;
           IF ThePos > 1 THEN BEGIN
             Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 2) +
             _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
             DEC(Fields^[FieldNum].CursorPos);
             RedrawField;
           END;
           MC := #255;
         END;
     9 : BEGIN {TAB}
           IF FieldNum = NFields THEN ChangeField(1) ELSE ChangeField(FieldNum + 1);
           MC := #255;
         END;
   127 : BEGIN {Ctrl-Backspace}
           Fields^[FieldNum].Text := '';
           Fields^[FieldNum].CursorPos := 1;
           RedrawField;
           MC := #255;
         END;
         ELSE BEGIN
           IF (ORD(MC) > 31) AND (ORD(MC) < 128) THEN BEGIN
             IF (LENGTH(Fields^[FieldNum].Text) < Fields^[FieldNum].ELength) THEN BEGIN
               CASE Fields^[FieldNum].EType OF
                 4,  {4-Secret Input}
                 0 : {0-Plain String}
                     BEGIN
                       ThePos := Fields^[FieldNum].CursorPos;
                       Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
                       INC(Fields^[FieldNum].CursorPos);
                     END;
                 1 : BEGIN {1-Plain Numeric}
                       IF ((ORD(MC) > 47) AND (ORD(MC) < 58)) THEN BEGIN
                         ThePos := Fields^[FieldNum].CursorPos;
                         Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) + MC +
                        _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
                         INC(Fields^[FieldNum].CursorPos);
                       END;
                     END;
                 2 : BEGIN {2-Proper String}
                       ThePos := Fields^[FieldNum].CursorPos;
                       IF ThePos = 1 THEN MC := UPCASE(MC) ELSE BEGIN
                         IF (ThePos <> 2) THEN BEGIN
                           IF Fields^[FieldNum].Text[ThePos - 1] = ' ' THEN MC := UPCASE(MC);
                         END;
                       END;
                       Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
                       INC(Fields^[FieldNum].CursorPos);
                     END;
                 3 : BEGIN {3-Date/Phone}
                       IF (((ORD(MC) > 47) AND (ORD(MC) < 58)) OR (MC = '-') OR (MC = '/')
                          OR (MC = '#') OR (MC = '.') OR (MC = '(') OR (MC = ')')) THEN BEGIN
                         ThePos := Fields^[FieldNum].CursorPos;
                         Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) + MC +
                        _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
                         INC(Fields^[FieldNum].CursorPos);
                       END;
                     END;
                 5 : BEGIN {5-Upper Case}
                       MC := UPCASE(MC);
                       ThePos := Fields^[FieldNum].CursorPos;
                       Fields^[FieldNum].Text := _Mid(Fields^[FieldNum].Text,1,ThePos - 1) + MC +
                      _Mid(Fields^[FieldNum].Text,ThePos,LENGTH(Fields^[FieldNum].Text));
                       INC(Fields^[FieldNum].CursorPos);
                     END;
               END;
               RedrawField;
             END;
             MC := #255;
           END ELSE BEGIN
             DidAPress := TRUE;
             ThePress  := ORD(MC);
           END;
         END;
  END;
  ShowMouse;
END;
{}
PROCEDURE DoAnimations;
CONST
  OldClk : WORD = 0;
  Hidden : BOOLEAN = FALSE;
VAR
  Loop   : BYTE;
  WH     : BYTE;
BEGIN
  IF SysClk^ AND $0001 = OldClk THEN EXIT;
  OldClk := SysClk^ AND $0001;
  Hidden := FALSE;
  FOR Loop := 1 TO NFlips DO BEGIN
    CASE IconFlip^[Loop].Size OF
      1 : WH := 15;
      2 : WH := 29;
      3 : WH := 59;
    END;
    IF MousePointIn(xx,yy,IconFlip^[Loop].X,IconFlip^[Loop].Y,IconFlip^[Loop].X + WH,IconFlip^[Loop].Y + WH) THEN BEGIN
      Hidden := TRUE;
      HideMouse;
    END;
  END;
  INC(IconCounter);
  IF IconCounter > NFlips THEN BEGIN
    IconCounter := 1;
    INC(FlipCounter);
    IF FlipCounter > 4 THEN FlipCounter := 1;
  END;
  CASE IconFlip^[IconCounter].Size OF
    1 : PutIcon16(IconFlip^[IconCounter].X,IconFlip^[IconCounter].Y,IconFlip^[IconCounter].Icon[FlipCounter],0);
    2 : PutIcon30(IconFlip^[IconCounter].X,IconFlip^[IconCounter].Y,IconFlip^[IconCounter].Icon[FlipCounter],0);
    3 : PutIcon60(IconFlip^[IconCounter].X,IconFlip^[IconCounter].Y,IconFlip^[IconCounter].Icon[FlipCounter],0);
  END;
  IF Hidden THEN ShowMouse;
END;
{}
BEGIN
  SliceMouse;
  MouseHandler := 0;
  DidAPress    := FALSE;
  AltKey       := FALSE;
  MC           := #255;
  IF (NFlips > 0) AND (NOT DragActive) THEN DoAnimations;
  IF (KEYPRESSED) AND (DoKeys) AND (NOT DragActive) THEN HandleKeys;
  IF DidAPress THEN BEGIN
    IF (NButtons <> 0) THEN FOR Loop := 1 TO NButtons DO BEGIN
      IF Buttons^[Loop].Return = ThePress THEN BEGIN
        LastPressed  := Loop;
        MouseHandler := Loop;
        EXIT;
      END;
    END;
  END;
  W := 0;
  FG_MousePos(xx,yy,bb);
  IF (ClockOn) AND (Mouse_On) AND (NOT DragActive) THEN SpinMouse;
  IF (bb = 0) AND (DragActive) THEN EndWindowDrag(xx,yy);
  IF (bb = 1) AND (DragActive) THEN UpdateWindowDrag(xx,yy);
  IF (bb = 1) AND (AllowDragging) AND (NOT DragActive) AND (WRec.WType IN [1,4,5]) THEN BEGIN
    IF (xx >= (WRec.X1 + 5)) AND
       (xx <= (WRec.X2 - 5)) AND
       (yy >= (WRec.Y1 + 5)) AND
       (yy <= (WRec.Y1 + 23)) THEN StartWindowDrag;
  END;
  IF (NButtons >= 1) AND (NOT DragActive) THEN FOR Loop := 1 TO NButtons DO BEGIN
    IF (Buttons^[Loop].ButtonType = 5) AND (NOT Buttons^[Loop].FieldOn) THEN BEGIN
      IF (xx >= Buttons^[Loop].X) AND (xx <= Buttons^[Loop].X + Buttons^[Loop].Width) THEN BEGIN
        IF (yy >= Buttons^[Loop].Y) AND (yy <= Buttons^[Loop].Y + Buttons^[Loop].Height) THEN BEGIN
          HideMouse;
          FG_SetHPage(1);
          FG_Save(Buttons^[Loop].X,Buttons^[Loop].X + Buttons^[Loop].Width,
                  Buttons^[Loop].Y,Buttons^[Loop].Y + Buttons^[Loop].Height);
          IF bb = 0 THEN FrameHigh(Buttons^[Loop].X,Buttons^[Loop].Y,
                                   Buttons^[Loop].X + Buttons^[Loop].Width,
                                   Buttons^[Loop].Y + Buttons^[Loop].Height);
          Buttons^[Loop].FieldOn := TRUE;
          ShowMouse;
        END;
      END;
    END;
    IF (bb = 0) AND (Buttons^[Loop].ButtonType = 5) AND (Buttons^[Loop].FieldOn) THEN BEGIN
      IF (xx < Buttons^[Loop].X) OR (xx > Buttons^[Loop].X + Buttons^[Loop].Width) OR
         (yy < Buttons^[Loop].Y) OR (yy > Buttons^[Loop].Y + Buttons^[Loop].Height) THEN BEGIN
        HideMouse;
        FG_Restore(Buttons^[Loop].X,Buttons^[Loop].X + Buttons^[Loop].Width,
                   Buttons^[Loop].Y,Buttons^[Loop].Y + Buttons^[Loop].Height);
        Buttons^[Loop].FieldOn := FALSE;
        ShowMouse;
      END;
    END;
  END;
  IF (bb = 1) AND (NOT DragActive) THEN BEGIN
    IF (LastPressed <> 0) AND (Buttons^[LastPressed].Holdable) THEN BEGIN
      IF (xx < Buttons^[LastPressed].X) OR
         (xx > Buttons^[LastPressed].X + Buttons^[LastPressed].Width) OR
         (yy < Buttons^[LastPressed].y) OR
         (yy > Buttons^[LastPressed].Y + Buttons^[LastPressed].Height) THEN BEGIN
         ReleaseButton(LastPressed);
         LastPressed := 0;
      END ELSE BEGIN
        IF (PickInfo.Active) OR (TextReader.Active) OR (Scroller.Active) THEN BEGIN
          IF (xx < Buttons^[1].X) OR
             (xx > Buttons^[1].X + Buttons^[1].Width) OR
             (yy < Buttons^[1].Y) OR
             (yy > Buttons^[1].Y + Buttons^[1].Height) THEN BEGIN
             IF (LastPressed < 3) AND (LastPressed > 1) THEN BEGIN
               IF PickInfo.Active THEN ScrollPickDown;
               IF (TextReader.Active) AND (TextReader.Last <= TextReader.Lines) THEN BEGIN
                 DEC(TextReader.Last,24);
                 HideMouse;
                 ShowTextPage;
                 ShowMouse;
               END;
               IF Scroller.Active THEN BEGIN
                 IF Scroller.Top <= 238 THEN INC(Scroller.Top);
                 SetUp_Scroller;
               END;
               W := LastPressed;
             END;
          END ELSE IF (xx < Buttons^[2].X) OR
             (xx > Buttons^[2].X + Buttons^[2].Width) OR
             (yy < Buttons^[2].Y) OR
             (yy > Buttons^[2].Y + Buttons^[2].Height) THEN BEGIN
             IF LastPressed < 2 THEN BEGIN
               IF PickInfo.Active THEN ScrollPickUp;
               IF TextReader.Active THEN BEGIN
                 DEC(TextReader.Last,26);
                 IF TextReader.Last < 1 THEN TextReader.Last := 1;
                 HideMouse;
                 ShowTextPage;
                 ShowMouse;
               END;
               IF Scroller.Active THEN BEGIN
                 IF Scroller.Top >= 1 THEN DEC(Scroller.Top);
                 SetUp_Scroller;
               END;
               W := LastPressed;
             END;
          END;
        END;
      END;
    END ELSE BEGIN
      ProcessButton(xx,yy);
      IF PickInfo.Active THEN BEGIN
        IF (xx >= PickInfo.X) AND
          (xx <= PickInfo.Width) AND
          (yy >= PickInfo.Y) AND
          (yy <= PickInfo.Bottom) THEN BEGIN
          FOR Loop := 1 TO PickInfo.ItemsOnScrn DO BEGIN
            IF (yy >= PickInfo.Item[Loop]) AND (yy <= PickInfo.Item[Loop] + 12)
            THEN TheOne := PickInfo.Top + (Loop - 1);
          END;
          IF TheOne <> PickInfo.Current THEN BEGIN
            IF (TheOne >= PickInfo.Top) AND
              (TheOne <= (PickInfo.Top + PickInfo.ItemsOnScrn - 1)) THEN BEGIN
              IF TheOne <= PickInfo.NumItems THEN BEGIN
                PickInfo.Current := TheOne;
                HideMouse;
                SetUp_PickList;
                ShowMouse;
              END;
            END;
          END;
        END;
      END;
      IF Scroller.Active THEN BEGIN
        IF (xx >= Scroller.X) AND
          (xx <= Scroller.Width) AND
          (yy >= Scroller.Y) AND
          (yy <= Scroller.Bottom) THEN BEGIN
          FOR Loop := 1 TO 16 DO BEGIN
            IF (yy >= Scroller.Item[Loop]) AND (yy <= Scroller.Item[Loop] + 9) THEN BEGIN
              IF Scroller.Current <> (Scroller.Top + (Loop - 1)) THEN BEGIN
                Scroller.Current := Scroller.Top + (Loop - 1);
                SetUp_Scroller;
              END;
            END;
          END;
        END;
      END;
    END;
  END ELSE BEGIN
    IF (LastPressed <> 0) AND (NOT DragActive) THEN BEGIN
      ReleaseButton(LastPressed);
      IF (xx < Buttons^[LastPressed].X) OR
         (xx > Buttons^[LastPressed].X + Buttons^[LastPressed].Width) OR
         (yy < Buttons^[LastPressed].Y) OR
         (yy > Buttons^[LastPressed].Y + Buttons^[LastPressed].Height) THEN W := 0 ELSE W := LastPressed;
      LastPressed := 0;
    END;
  END;
  MouseHandler := W;
END;
{}
PROCEDURE ResetGraphics;
BEGIN
  WITH C DO BEGIN
    Win1Back        := 243;
    Win4Back        := 233;
    Win1High        := 249;
    Win4High        := 244;
    Win1Low         := 233;
    Win4Low         := 234;
    Win1Frame1      := 247;
    Win1Frame2      := 237;
    Win4Frame       := 0;
    ActiveHdr       := 57;
    InactiveHdr     := 235;
    HdrTitle        := 15;
    ButtonFrame     := 0;
    ButtonFace      := 246;
    ButtonHigh      := 251;
    ButtonLow       := 238;
    ButtonHot       := 4;
    ButtonText      := 0;
    FrameHigh       := 249;
    FrameLow        := 237;
    BoxBack         := 246;
    BoxHigh         := 251;
    BoxLow          := 238;
    FieldTextHigh   := 254;
    FieldTextLow    := 240;
    FieldBack       := 0;
    QuoteColor      := 5;
    MsgColor        := 0;
    TearColor       := 1;
    FlagColor       := 4;
    MsgIDcolor      := 9;
    TextBack        := 247;
    PickHighFore    := 15;
    PickHighBack    := 1;
    ScreenColor     := 33;
  END;
  MouseMask(MouseStandard);
  UnloadGemFont(FPtr);
  EditorFile        := 'TEXTFILE.TXT';
  IconLib16         := 'ICON_LIB.001';
  IconLib30         := 'ICON_LIB.002';
  IconLib60         := 'ICON_LIB.003';
  BBSmessages       := TRUE;
END;
{}
PROCEDURE Show_Mem;
BEGIN
  FG_SetColor(C.BoxBack); FG_ClpRect(502,637,462,477);
  OutText_XY(504,462,1,2,'Free Memory: {0}' + IntToStr(MEMAVAIL));
END;
{}
PROCEDURE ShowMouse;
BEGIN
  IF NOT MouseInstalled THEN EXIT;
  Mouse_On := TRUE;
  FG_MouseVis(1);
END;
{}
PROCEDURE HideMouse;
VAR
  xx,yy,bb : INTEGER;
BEGIN
  IF NOT MouseInstalled THEN EXIT;
  Mouse_On := FALSE;
  FG_MouseVis(0);
END;
{}
PROCEDURE Text_View_Port(X1,Y1,X2,Y2 : INTEGER);
BEGIN
  IF TvPort.Active THEN EXIT;
  IF X2 > 80 THEN X2 := 80;
  IF Y2 > 25 THEN Y2 := 25;
  NEW(ChArray);
  NEW(FgArray);
  NEW(BgArray);
  Show_Mem;
  TvPort.Active   := TRUE;
  ResetANSI;
  TvPort.StartX   := X1;
  TvPort.StartY   := Y1;
  TvPort.ColLimit := X2;
  TvPort.RowLimit := Y2;
  IF X2 < 80 THEN FrameLow(X1-1,Y1-1,X1 + (X2 * 8) + 1,Y1 + (Y2 * 16) + 1);
  Clr_Scr;
END;
{}
PROCEDURE AnsiFullScreen;
BEGIN
  FG_SetColor(0);
  FG_ClpRect(0,639,21,421);
  Text_View_Port(1,21,80,25);
  RaisedBox(0,421,639,441);
  ShadowText(287,423,15,0,2,'ANSI Emulation');
END;
{}
PROCEDURE ShutDownSvga;
BEGIN
  HideMouse;
  Draw_Window(0,0,639,439,2,'');
  FG_MouseFin;
  UnloadGemFont(FPtr);
  FG_SetMode(Old_Mode);
  FG_Reset;
  SvgaMode := FALSE;
END;
{}
PROCEDURE RestartSvga;
BEGIN
  MouseInstalled := FALSE;
  FG_InitPM;
  FG_SvgaInit(SvgaID);
  FG_SetMode(19);
  FG_SetMode(25);
  InitPalette;
  IF FG_MouseIni > 0 THEN BEGIN
    MouseInstalled := TRUE;
    FG_MouseSpd(10,10);
    IF DefMouseMask <> '' THEN MouseMask256(DefMouseMask);
    ShowMouse;
  END;
  Kill_Window;
  SvgaMode := TRUE;
END;
{}

BEGIN
  SysClk         := PTR(Seg0040,$6C); {Location of BIOS system clock counter}
  FlipCounter    := 1;
  ConvertIt      := TRUE;
  MouseInstalled := FALSE;
  Mouse_On       := FALSE;
  ShowBanner     := TRUE;
  AllowDragging  := TRUE;
  ExplodeOn      := FALSE;
  DragActive     := FALSE;
  ShowIcons      := TRUE;
  WinTag         := '!';
  BackDropImage  := 'GUI_UNIT.OBJ';
  DefMouseMask   := '';
  DetectOS;
  ResetGraphics;
END.
