{$I DEFINES.INC}
UNIT GUI_MOUS; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).
  }

INTERFACE

CONST
  MouseStandard     = 0; {Mouse mask definitions}
  MouseUpArrow      = 1;
  MouseDownArrow    = 2;
  MouseLeftArrow    = 3;
  MouseRightArrow   = 4;
  MouseCheckMark    = 5;
  MouseUpHand       = 6;
  MouseDownHand     = 7;
  MouseLeftHand     = 8;
  MouseRightHand    = 9;
  MouseStopHand     = 10;
  MouseHourGlass    = 11;
  MouseDiagCross    = 12;
  MouseRectCross    = 13;
  MouseRectBox      = 14;
  MouseTargetCross  = 15;
  MouseTargetCircle = 16;
  MouseTargetBox    = 17;
  MouseQuestionMark = 18;
  MouseClockCursor  = 19;

VAR
  ClockOn    : BOOLEAN;
  ClockCount : BYTE;

{}
FUNCTION  MousePointIn(Mx,My,x1,y1,x2,y2 : INTEGER) : BOOLEAN;
PROCEDURE SpinMouse;
PROCEDURE MouseMask256(Lib : STRING);
PROCEDURE MouseMask(Mask : BYTE);
{}

IMPLEMENTATION

USES FGMISC, GUI_UNIT, GUI_UTIL;

FUNCTION MousePointIn(Mx,My,x1,y1,x2,y2 : INTEGER) : BOOLEAN;
BEGIN
  IF (Mx >= x1) AND
     (Mx <= x2) AND
     (My >= y1) AND
     (My <= y2) THEN MousePointIn := TRUE
                ELSE MousePointIn := FALSE;
END;

PROCEDURE SpinMouse;
CONST
  OldClk : WORD = 0;
BEGIN
  IF SysClk^ AND $FFFC = OldClk THEN EXIT;
  OldClk := SysClk^ AND $FFFC;
  IF ClockOn THEN BEGIN
    INC(ClockCount);
    IF ClockCount > 7 THEN ClockCount := 0;
    MouseMask(MouseClockCursor);
  END;
END;

PROCEDURE MouseMask256(Lib : STRING);
TYPE Icon16x16 = RECORD
     Matrix    : ARRAY[1..16,1..16] OF BYTE;
     END;

TYPE IconPoint = RECORD
     HotX      : SHORTINT;
     HotY      : SHORTINT;
     END;

VAR
  F     : FILE OF Icon16x16;
  FF    : FILE OF IconPoint;
  Icon1 : Icon16x16;
  Icon2 : Icon16x16;
  IP    : IconPoint;
  X2    : WORD;
  L1    : BYTE;
  L2    : BYTE;
  XX    : ARRAY[0..511] OF BYTE;
BEGIN
  ClockOn    := FALSE;
  ClockCount := 0;
  IF NOT FExist(Lib) THEN BEGIN
    ShadowText(10,30,15,0,1,Lib + ' Not Found!');
    MouseMask(MouseStandard);
    EXIT;
  END;
  ASSIGN(F,Lib);
  RESET(F);
  READ(F,Icon1);
  READ(F,Icon2);
  CLOSE(F);
  ASSIGN(FF,Lib);
  RESET(FF);
  SEEK(FF,FILESIZE(FF) - 1);
  READ(FF,IP);
  CLOSE(FF);
  FILLCHAR(XX,SIZEOF(XX),#0);
  X2 := 0;
  FOR L1 := 1 TO 16 DO BEGIN
    FOR L2 := 1 TO 16 DO BEGIN
      XX[X2] := Icon1.Matrix[L2,L1];
      INC(X2);
    END;
  END;
  FOR L1 := 1 TO 16 DO BEGIN
    FOR L2 := 1 TO 16 DO BEGIN
      IF Icon2.Matrix[L2,L1] = 0 THEN XX[X2] := 226 ELSE
      IF Icon2.Matrix[L2,L1] = 255 THEN XX[X2] := 0 ELSE
      XX[X2] := Icon2.Matrix[L2,L1];
      INC(X2);
    END;
  END;
  FG_Mouse256(XX,IP.HotX,IP.HotY);
END;

PROCEDURE MouseMask(Mask : BYTE);
CONST
  _Standard : ARRAY[0..31] OF WORD =
        ($9FFF,$8FFF,$87FF,$83FF,$81FF,$80FF,$807F,$803F, {Screen Mask}
         $801F,$800F,$80FF,$887F,$987F,$FC3F,$FC3F,$FE3F,
         $0000,$2000,$3000,$3800,$3C00,$3E00,$3F00,$3F80, {Cursor Mask}
         $3FC0,$3E00,$3600,$2300,$0300,$0180,$0180,$0000);
        {HotX: 1, HotY: 0}                                {Hot Spot}

  _UpArrow : ARRAY[0..31] OF WORD =
        ($F9FF,$F0FF,$E07F,$E07F,$C03F,$C03F,$801F,$801F,
         $000F,$000F,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF,
         $0000,$0600,$0F00,$0F00,$1F80,$1F80,$3FC0,$3FC0,
         $7FE0,$0600,$0600,$0600,$0600,$0600,$0600,$0000);
        {HotX: 5, HotY: 0}

  _DownArrow : ARRAY[0..31] OF WORD =
        ($F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$F0FF,$000F,$000F,
         $801F,$801F,$C03F,$C03F,$E07F,$E07F,$F0FF,$F9FF,
         $0000,$0600,$0600,$0600,$0600,$0600,$0600,$7FE0,
         $3FC0,$3FC0,$1F80,$1F80,$0F00,$0F00,$0600,$0000);
        {HotX: 5, HotY: 15}

  _LeftArrow : ARRAY[0..31] OF WORD =
        ($FE1F,$F01F,$0000,$0000,$0000,$F01F,$FE1F,$FFFF,
         $FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $0000,$00C0,$07C0,$7FFE,$07C0,$00C0,$0000,$0000,
         $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000);
        {HotX: 0, HotY: 3}

  _RightArrow : ARRAY[0..31] OF WORD =
        ($F87F,$F80F,$0000,$0000,$0000,$F80F,$F87F,$FFFF,
         $FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $0000,$0300,$03E0,$7FFE,$03E0,$0300,$0000,$0000,
         $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000);
        {HotX: 15, HotY: 3}

  _CheckMark : ARRAY[0..31] OF WORD =
        ($FFF8,$FFF0,$FFE1,$FFC3,$FF87,$FF0F,$0E1F,$043F,
         $807F,$E0FF,$F1FF,$FBFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $0000,$0006,$000C,$0018,$0030,$0060,$00C0,$7180,
         $1B00,$0E00,$0400,$0000,$0000,$0000,$0000,$0000);
        {HotX: 5, HotY: 11}

  _UpHand : ARRAY[0..31] OF WORD =
        ($E1FF,$E1FF,$E1FF,$E1FF,$E000,$E000,$E000,$0000,
         $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,
         $1E00,$1200,$1200,$1200,$13FF,$1249,$1249,$F249,
         $9001,$9001,$9001,$8001,$8001,$8001,$8001,$FFFF);
        {HotX: 5, HotY: 0}

  _DownHand : ARRAY[0..31] OF WORD =
        ($0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000,
         $0000,$E000,$E000,$E000,$E1FF,$E1FF,$E1FF,$E1FF,
         $FFFF,$8001,$8001,$8001,$8001,$9001,$9001,$9001,
         $F249,$1249,$1249,$13FF,$1200,$1200,$1200,$1E00);
        {HotX: 5, HotY: 15}

  _LeftHand : ARRAY[0..31] OF WORD =
        ($FFFF,$FF8F,$FF07,$FF03,$FF81,$8000,$0000,$0000,
         $0000,$8000,$F000,$F800,$F800,$FC00,$FC01,$FC03,
         $0000,$0000,$0070,$0048,$0024,$0032,$7FF2,$800A,
         $7FF6,$0412,$07F2,$0212,$03F2,$0116,$01FC,$0000);
        {HotX: 0, HotY: 7}

  _RightHand : ARRAY[0..31] OF WORD =
        ($FFFF,$F1FF,$E0FF,$C0FF,$81FF,$0001,$0000,$0000,
         $0000,$0001,$000F,$001F,$001F,$003F,$803F,$C03F,
         $0000,$0000,$0E00,$1200,$2400,$4C00,$4FFE,$5001,
         $6FFE,$4820,$4FE0,$4840,$4FC0,$6880,$3F80,$0000);
        {HotX: 15, HotY: 7}

  _StopHand : ARRAY[0..31] OF WORD =
        ($FE3F,$F80F,$F007,$F003,$F001,$F001,$0001,$0001,
         $0001,$0001,$8001,$C001,$C001,$E003,$F007,$F80F,
         $0000,$01C0,$0770,$0550,$055C,$0554,$0554,$7554,
         $5554,$4FFC,$2804,$1004,$180C,$0C18,$07F0,$0000);
        {HotX: 7, HotY: 8}

  _HourGlass : ARRAY[0..31] OF WORD =
        ($0000,$0000,$0000,$0000,$8001,$C003,$E007,$F00F,
         $E007,$C003,$8001,$0000,$0000,$0000,$0000,$FFFF,
         $0000,$7FFE,$6006,$300C,$1818,$0C30,$0660,$03C0,
         $0660,$0C30,$1998,$33CC,$67E6,$7FFE,$0000,$0000);
        {HotX: 7, HotY: 8}

  _DiagCross : ARRAY[0..31] OF WORD =
        ($07E0,$0180,$0000,$C003,$F00F,$C003,$0000,$0180,
         $07E0,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $0000,$700E,$1C38,$0660,$03C0,$0660,$1C38,$700E,
         $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000);
        {HotX: 7, HotY: 4}

  _RectCross : ARRAY[0..31] OF WORD =
        ($FC3F,$FC3F,$FC3F,$0000,$0000,$0000,$FC3F,$FC3F,
         $FC3F,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,$FFFF,
         $0000,$0180,$0180,$0180,$7FFE,$0180,$0180,$0180,
         $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000);
        {HotX: 7, HotY: 4}

  _RectBox : ARRAY[0..31] OF WORD =
        ($FFFF,$FFFF,$0000,$0000,$0000,$1FF8,$1FF8,$1FF8,
         $1FF8,$1FF8,$1FF8,$1FF8,$0000,$0000,$0000,$FFFF,
         $0000,$0000,$0000,$7FFE,$4002,$4002,$4002,$4002,
         $4002,$4002,$4002,$4002,$4002,$7FFE,$0000,$0000);
        {HotX: 7, HotY: 8}

  _TargetCross : ARRAY[0..31] OF WORD =
        ($FFFF,$FFFF,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$06C1,
         $0101,$06C1,$FC7F,$FC7F,$FC7F,$FC7F,$FC7F,$FFFF,
         $0000,$0000,$0000,$0100,$0100,$0100,$0100,$0000,
         $783C,$0000,$0100,$0100,$0100,$0100,$0000,$0000);
        {HotX: 7, HotY: 8}

  _TargetCircle : ARRAY[0..31] OF WORD =
        ($FFFF,$FFFF,$F01F,$C007,$8003,$0441,$0C61,$06C1,
         $0101,$06C1,$0C61,$0441,$8003,$C007,$F01F,$FFFF,
         $0000,$0000,$0000,$07C0,$1930,$3118,$610C,$600C,
         $783C,$600C,$610C,$3118,$1930,$07C0,$0000,$0000);
        {HotX: 7, HotY: 8}

  _TargetBox : ARRAY[0..31] OF WORD =
        ($FFFF,$FFFF,$0001,$0001,$0001,$1C71,$1C71,$06C1,
         $0101,$06C1,$1C71,$1C71,$0001,$0001,$0001,$FFFF,
         $0000,$0000,$0000,$7FFC,$4104,$4104,$4104,$4004,
         $783C,$4004,$4104,$4104,$4104,$7FFC,$0000,$0000);
        {HotX: 7, HotY: 8}

  _QuestionMark : ARRAY[0..31] OF WORD =
        ($FFFF,$E00F,$C007,$8003,$0001,$0001,$0001,$0001,
         $0001,$0001,$0001,$0001,$0001,$8003,$C007,$E00F,
         $0000,$0000,$1FF0,$3FF8,$783C,$739C,$739C,$7F3C,
         $7E7C,$7E7C,$7FFC,$7E7C,$7E7C,$3FF8,$1FF0,$0000);
        {HotX: 7, HotY: 8}

{ClockCursor ARRAY[0..7]}
  _Clock0 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2008,$2008,$4004,$4004,$61FC,
         $4004,$4004,$2008,$2008,$1930,$07C0,$0000,$0000);

  _Clock1 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2008,$2008,$4004,$4004,$610C,
         $4084,$4044,$2028,$2018,$1930,$07C0,$0000,$0000);

  _Clock2 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2008,$2008,$4004,$4004,$610C,
         $4104,$4104,$2108,$2108,$1930,$07C0,$0000,$0000);

  _Clock3 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2008,$2008,$4004,$4004,$610C,
         $4204,$4404,$2808,$3008,$1930,$07C0,$0000,$0000);

  _Clock4 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2008,$2008,$4004,$4004,$7F0C,
         $4004,$4004,$2008,$2008,$1930,$07C0,$0000,$0000);

  _Clock5 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$3008,$2808,$4404,$4204,$610C,
         $4004,$4004,$2008,$2008,$1930,$07C0,$0000,$0000);

  _Clock6 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2108,$2108,$4104,$4104,$610C,
         $4004,$4004,$2008,$2008,$1930,$07C0,$0000,$0000);

  _Clock7 : ARRAY[0..31] OF WORD =
        ($F83F,$E00F,$C007,$8003,$8003,$0001,$0001,$0001,
         $0001,$0001,$8003,$8003,$C007,$E00F,$F83F,$FFFF,
         $0000,$07C0,$1930,$2018,$2028,$4044,$4084,$610C,
         $4004,$4004,$2008,$2008,$1930,$07C0,$0000,$0000);
         {HotX: 7, HotY: 8}
BEGIN
  IF Mask <> MouseClockCursor THEN BEGIN
    ClockOn    := FALSE;
    ClockCount := 0;
  END;
  CASE Mask OF
    MouseStandard     : FG_MousePtr(_Standard,1,0);
    MouseUpArrow      : FG_MousePtr(_UpArrow,5,0);
    MouseDownArrow    : FG_MousePtr(_DownArrow,5,15);
    MouseLeftArrow    : FG_MousePtr(_LeftArrow,0,3);
    MouseRightArrow   : FG_MousePtr(_RightArrow,15,3);
    MouseCheckMark    : FG_MousePtr(_CheckMark,5,11);
    MouseUpHand       : FG_MousePtr(_UpHand,5,0);
    MouseDownHand     : FG_MousePtr(_DownHand,5,15);
    MouseLeftHand     : FG_MousePtr(_LeftHand,0,7);
    MouseRightHand    : FG_MousePtr(_RightHand,15,7);
    MouseStopHand     : FG_MousePtr(_StopHand,7,8);
    MouseHourGlass    : FG_MousePtr(_HourGlass,7,8);
    MouseDiagCross    : FG_MousePtr(_DiagCross,7,4);
    MouseRectCross    : FG_MousePtr(_RectCross,7,4);
    MouseRectBox      : FG_MousePtr(_RectBox,7,8);
    MouseTargetCross  : FG_MousePtr(_TargetCross,7,8);
    MouseTargetCircle : FG_MousePtr(_TargetCircle,7,8);
    MouseTargetBox    : FG_MousePtr(_TargetBox,7,8);
    MouseQuestionMark : FG_MousePtr(_QuestionMark,7,8);
    MouseClockCursor  : BEGIN
                          ClockOn := TRUE;
                          IF ClockOn THEN CASE ClockCount OF
                            0 : FG_MousePtr(_Clock0,7,8);
                            1 : FG_MousePtr(_Clock1,7,8);
                            2 : FG_MousePtr(_Clock2,7,8);
                            3 : FG_MousePtr(_Clock3,7,8);
                            4 : FG_MousePtr(_Clock4,7,8);
                            5 : FG_MousePtr(_Clock5,7,8);
                            6 : FG_MousePtr(_Clock6,7,8);
                            7 : FG_MousePtr(_Clock7,7,8);
                          END;
                        END;
  END;
END;

BEGIN
  ClockOn    := FALSE;
  ClockCount := 0;
END.
