{$I DEFINES.INC}
UNIT GUI_IMAG; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).
  }

INTERFACE

{}
PROCEDURE Play_FLI(Count,Dly : WORD ; Fli : STRING);
PROCEDURE PcxSize(VAR X,Y : WORD ; FName : STRING);
PROCEDURE BmpSize(VAR X,Y : WORD ; FName : STRING);
PROCEDURE MifSize(VAR X,Y : WORD ; FName : STRING);
PROCEDURE Put_Image(X1,Y1 : WORD ; ImageFile : STRING);
{}

IMPLEMENTATION

USES MYCRT, GUI_UNIT, GUI_UTIL, GUI_FONT, GUI_MOUS, APTIMER,
     FGPCX, {$IFNDEF FG4} FGBMP, {$ENDIF}
     FGFLIC, FGMISC, FGMAIN, FGBITMAP, FGSVGA;

TYPE Max_Palette = RECORD
     Red         : BYTE;
     Green       : BYTE;
     Blue        : BYTE;
     END;

VAR
  Pal            : ARRAY[0..767] OF BYTE;
  NewPal         : ARRAY[0..255] OF BYTE;

{}
PROCEDURE Play_FLI(Count,Dly : WORD ; Fli : STRING);
VAR
  Loop    : WORD;
  Frames  : INTEGER;
  Status  : INTEGER;
  Context : ARRAY [1..16] OF BYTE;
BEGIN
  Dly := Dly * 10;
  Status := FG_FlicOpen(Fli + #0,Context);
  FG_FlicDone(Context);
  IF Status = 0 THEN BEGIN
    Draw_Window(0,0,639,439,2,'');
    UnloadGemFont(FPtr);
    IF MouseInstalled THEN FG_MouseFin;
    FG_SetMode(19);
    IF Count = 0 THEN BEGIN
      REPEAT
        FG_FlicOpen(Fli + #0,Context);
        REPEAT
          Frames := FG_FlicPlay(Context,1,1);
          IF Dly <> 0 THEN Delay(Dly);
        UNTIL (Frames = 0);
        FG_FlicDone(Context);
      UNTIL KEYPRESSED;
    END ELSE BEGIN
      FOR Loop := 1 TO Count DO BEGIN
        FG_FlicOpen(Fli + #0,Context);
        REPEAT
          Frames := FG_FlicPlay(Context,1,1);
          IF Dly <> 0 THEN Delay(Dly);
        UNTIL (Frames = 0);
        FG_FlicDone(Context);
        IF KEYPRESSED THEN Loop := Count;
      END;
    END;
    ClearKeyBuffer;
    FG_SvgaInit(SvgaID);
    FG_SetMode(19);
    FG_SetMode(25);
    InitPalette;
    IF MouseInstalled THEN BEGIN
      FG_MouseIni;
      FG_MouseSpd(10,10);
      ShowMouse;
    END;
    Kill_Window;
  END;
  IF Status = (- 1) THEN OutText_XY(10,30,15,1,Fli + ' Not Found!') ELSE
  IF Status = (- 2) THEN OutText_XY(10,30,15,1,Fli + ' is not a valid FLI or FLC file!');
END;
{}
FUNCTION AdjustPalette256 : BOOLEAN;{This function courtesy of Sean Price.  }
VAR
  Color  : BYTE;
  Red    : BYTE;
  Green  : BYTE;
  Blue   : BYTE;
  A,E,
  Mavg,
  Pavg   : INTEGER;
  B,C,D  : BYTE;
  Exact  : BOOLEAN;
  ThePal : ARRAY[0..255] OF Max_Palette;
BEGIN
  AdjustPalette256 := FALSE;
  B                := 0;
  C                := 0;
  E                := 0;
  MOVE(MaxPal,ThePal,768);
  FOR A := 0 TO 767 DO BEGIN
    INC(B);
    CASE B OF
      1 : Red   := Pal[A];
      2 : Green := Pal[A];
      3 : BEGIN
            Blue  := Pal[A];
            Exact := FALSE;
            FOR D := 0 TO 255 DO BEGIN
              IF (ThePal[D].Red = Red) AND
                 (ThePal[D].Green = Green) AND
                 (ThePal[D].Blue = Blue) THEN BEGIN
                NewPal[C] := D;
                Exact := TRUE;
                INC(E);
                BREAK;
              END;
            END;
            IF NOT Exact THEN BEGIN
              Pavg := 999; {Prime the old average with an impossible value.}
              FOR D := 0 TO 255 DO BEGIN
                Mavg := ABS(ThePal[D].Red - Red) +
                        ABS(ThePal[D].Green - Green) +
                        ABS(ThePal[D].Blue - Blue); {Get pallette average.}
                IF (Mavg < Pavg) THEN BEGIN  {If closer than old average,}
                  Pavg := Mavg;              {then set old average to it.}
                  NewPal[C] := D;            {Set color index to new color.}
                END;
              END;
            END;
            B := 0;
            INC(C);
          END;
    END;
  END;
  IF E = 256 THEN AdjustPalette256 := TRUE;
END;
{}
PROCEDURE Show_PCX(X1,Y1 : INTEGER ; FName : STRING);
CONST
  BufMax    = 4096 - 1;
  RLEcode   = 192;
TYPE
  tLine     = ARRAY[0..0] OF BYTE;
  tBuf      = ARRAY[0..BufMax] OF BYTE;
  tEGApal   = ARRAY[0..15] OF ARRAY[1..3] OF BYTE;
  tFiller   = ARRAY[0..52] OF BYTE;

  PCXheader = RECORD
  Man       : BYTE;
  Ver       : BYTE;
  Encoding  : BYTE;
  Bpp       : BYTE;
  X1,Y1     : INTEGER;
  X2,Y2     : INTEGER;
  Xdpi      : INTEGER;
  Ydpi      : INTEGER;
  EGApal    : tEGApal;
  _Ignored_ : BYTE;
  Planes    : BYTE;
  Bpl       : INTEGER;
  PalType   : INTEGER;
  HScrMax   : INTEGER;
  VscrMax   : INTEGER;
  _Filler_  : tFiller;
  END;

VAR
  F         : FILE;
  R         : WORD;
  Buf       : ^tBuf;
  BufPos    : WORD;
  BufSize   : WORD;
  _Line     : ^tLine;
  Z         : INTEGER;
  LinePos   : INTEGER;
  LineSize  : INTEGER;
  CurLine   : INTEGER;
  Hdr       : PCXheader;
  ID,B      : BYTE;
  PcxArray  : ARRAY[0..1023] OF BYTE;
{}
FUNCTION DefaultHdrFunc : INTEGER;
BEGIN
  WITH Hdr DO IF (Man <> 10) OR
                 (Encoding <> 1) OR
                 (Bpp <> 8) OR
                 (Planes <> 1) THEN DefaultHdrFunc := 1
                               ELSE DefaultHdrFunc := 0;
END;
{}
FUNCTION NextByte : BYTE;
BEGIN
  IF BufPos < BufSize THEN BEGIN
    NextByte := Buf^[BufPos];
    INC(BufPos);
  END ELSE BEGIN
    BLOCKREAD(F,Buf^,SIZEOF(Buf^),R);
    BufSize  := R;
    BufPos   := 1;
    NextByte := Buf^[0];
  END;
END;
{}
BEGIN
  IF NOT FExist(FName) THEN BEGIN
    ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' Not Found!');
    EXIT;
  END;
  Buf   := NIL;
  _Line := NIL;
  FILLCHAR(Pal,768,0);
  ASSIGN(F,FName);
  RESET(F,1);
  BLOCKREAD(F,Hdr,128,R);
  IF DefaultHdrFunc <> 0 THEN BEGIN
    ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' is not a 256 color PCX!');
    CLOSE(F);
    EXIT;
  END;
  SEEK(F,FILESIZE(F) - 769);
  BLOCKREAD(F,ID,1,R);
  IF ID = 12 THEN BEGIN
    FILLCHAR(Pal,768,0);
    BLOCKREAD(F,Pal,768,R);
    FOR R := 0 TO 767 DO Pal[R] := Pal[R] SHR 2;
    IF AdjustPalette256 THEN BEGIN
      CLOSE(F);
      FG_Move(X1,Y1);
      FG_ShowPcx(FName+#0,2);
      EXIT;
    END;
  END;
  SEEK(F,128);
  LineSize := Hdr.X2 - Hdr.X1 + 1;
  LinePos  := 0;
  CurLine  := 0;
  GETMEM(_Line,LineSize);
  NEW(Buf);
  BufPos   := 0;
  BufSize  := 0;
  REPEAT
    B := NextByte;
    IF B < RLEcode THEN BEGIN
      _Line^[LinePos] := B;
      INC(LinePos);
    END ELSE BEGIN
      FILLCHAR(_Line^[LinePos],B - RLEcode,NextByte);
      INC(LinePos,B - RLEcode);
    END;
    IF LinePos >= LineSize THEN BEGIN
      FILLCHAR(PcxArray,SIZEOF(PcxArray),#0);
      FOR Z := 0 TO (LineSize - 1) DO PcxArray[Z] := NewPal[_Line^[Z]];
      IF (CurLine + Y1) <= 459 THEN FG_Move(X1,CurLine + Y1);
      FG_PutImage(PcxArray,LineSize,1);
      LinePos := 0;
      INC(CurLine);
    END;
  UNTIL CurLine > Hdr.Y2 - Hdr.Y1;
  IF Buf <> NIL THEN DISPOSE(Buf);
  IF _Line <> NIL THEN FREEMEM(_Line,LineSize);
  CLOSE(F);
END;
{}
PROCEDURE PcxSize(VAR X,Y : WORD ; FName : STRING);
TYPE
  tEGApal   = ARRAY[0..15] OF ARRAY[1..3] OF BYTE;
  tFiller   = ARRAY[0..52] OF BYTE;
  PCXheader = RECORD
  Man       : BYTE;
  Ver       : BYTE;
  Encoding  : BYTE;
  Bpp       : BYTE;
  X1,Y1     : INTEGER;
  X2,Y2     : INTEGER;
  Xdpi      : INTEGER;
  Ydpi      : INTEGER;
  EGApal    : tEGApal;
  _Ignored_ : BYTE;
  Planes    : BYTE;
  Bpl       : INTEGER;
  PalType   : INTEGER;
  HScrMax   : INTEGER;
  VscrMax   : INTEGER;
  _Filler_  : tFiller;
  END;
VAR
  F         : FILE;
  R         : WORD;
  Hdr       : PCXheader;
  TheImage  : STRING[80];
FUNCTION DefaultHdrFunc : INTEGER;
BEGIN
  WITH Hdr DO IF (Man <> 10) OR
                 (Encoding <> 1) OR
                 (Bpp <> 8) OR
                 (Planes <> 1) THEN DefaultHdrFunc := 1
                               ELSE DefaultHdrFunc := 0;
END;
BEGIN
  X := 0;
  Y := 0;
  IF NOT FExist(FName) THEN EXIT;
  ASSIGN(F,FName);
  RESET(F,1);
  BLOCKREAD(F,Hdr,128,R);
  CLOSE(F);
  IF DefaultHdrFunc <> 0 THEN BEGIN
    HideMouse;
    Draw_Window(231,186,415,252,5,'IMAGE FILE ERROR:');
    OutText_XY(240,215,4,2,'Sorry, Not A Valid PCX Image!');
    ShadowText(240,230,10,0,2,'Press Any Key To Continue...');
    WRITE(^G);
    READKEY;
    ShowMouse;
    Kill_Window;
    EXIT;
  END;
  X := Hdr.X2 - Hdr.X1 + 1;
  Y := Hdr.Y2 - Hdr.Y1 + 1;
  IF X >= 640 THEN X := 639;
  IF Y >= 440 THEN Y := 437;
END;
{}
PROCEDURE Show_BMP(X1,Y1 : INTEGER; FName : STRING);
VAR
  MaxX,MaxY,P,PP,X,Y,Z: INTEGER;
  F                   : FILE;
  Header              : RECORD
                        BM                  : ARRAY[0..1] OF CHAR;
                        GStand              : LONGINT;
                        Reserve             : LONGINT;
                        Offset              : LONGINT;
                        GBeeldInfo          : LONGINT;
                        END;
  BeeldInfo           : RECORD
                        HSize,VSize         : LONGINT;
                        Planes,BitsPerPixel : WORD;
                        Hor,Ver             : LONGINT;
                        MaxColors           : LONGINT;
                        END;
  BytesPerLine,OutPos : LONGINT;
  RGBI                : ARRAY[1..256] OF RECORD BB,GG,RR,II : BYTE; END;
  _Line               : ARRAY[1..1024] OF BYTE;
  BmpArray            : ARRAY[1..1024] OF BYTE;
BEGIN
  IF NOT FExist(FName) THEN BEGIN
    ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' Not Found!');
    EXIT;
  END;
  MaxX := FG_GetMaxX - 1;
  MaxY := FG_GetMaxY - 39;
  FILLCHAR(Pal,768,0);
  ASSIGN(F,FName);
  RESET(F,1);
  FILLCHAR(Header,SIZEOF(Header),0);
  BLOCKREAD(F,Header,SIZEOF(Header));
  FILLCHAR(BeeldInfo,SIZEOF(BeeldInfo),0);
  BLOCKREAD(F,BeeldInfo,Header.GBeeldInfo - 4);
  WITH BeeldInfo,Header DO BEGIN
    BytesPerLine := HSize * BitsPerPixel;
    IF (BytesPerLine AND 31) = 0 THEN BytesPerLine := BytesPerLine SHR 3
                                 ELSE BytesPerLine := SUCC(BytesPerLine SHR 5) SHL 2;
    IF MaxColors = 0 THEN MaxColors := 1 SHL BitsPerPixel ELSE IF MaxColors = 640 THEN MaxColors := 256;
    IF (BitsPerPixel <> 8) OR (MaxColors <> 256) THEN BEGIN
      CLOSE(F);
      ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' is not a 256 color BMP!');
      EXIT;
    END;
    BLOCKREAD(F,RGBI,4 * MaxColors);
    PP := 0;
    FOR P := 1 TO 256 DO WITH RGBI[P] DO BEGIN
      Pal[PP] := RR SHR 2; INC(PP);
      Pal[PP] := GG SHR 2; INC(PP);
      Pal[PP] := BB SHR 2; INC(PP);
    END;
{$IFDEF FG4}
    AdjustPalette256;
{$ELSE}
    IF AdjustPalette256 THEN BEGIN
      CLOSE(F);
      FG_Move(X1,Y1);
      FG_ShowBmp(FName+#0,2);
      EXIT;
    END;
{$ENDIF}
    WITH Header,BeeldInfo DO BEGIN
     {IF VSize <= MaxY THEN OutPos := Offset ELSE OutPos := ((Offset + BytesPerLine) * (VSize - MaxY));}
      OutPos := 1078;
      IF HSize < MaxX THEN MaxX := HSize;
      IF VSize < MaxY THEN MaxY := VSize;
      FOR Y := (Y1 + (MaxY - 1)) DOWNTO Y1 DO BEGIN
        SEEK(F,OutPos);
        BLOCKREAD(F,_Line,MaxX);
        FOR Z := 1 TO HSize DO BmpArray[Z] := NewPal[_Line[Z]];
        FG_Move(X1,Y);
        FG_PutImage(BmpArray,HSize,1);
        INC(OutPos,BytesPerLine);
      END;
    END;
    CLOSE(F);
  END;
END;
{}
PROCEDURE BmpSize(VAR X,Y : WORD ; FName : STRING);
VAR
  F                   : FILE;
  Header              : RECORD
                        BM                  : ARRAY[0..1] OF CHAR;
                        GStand              : LONGINT;
                        Reserve             : LONGINT;
                        Offset              : LONGINT;
                        GBeeldInfo          : LONGINT;
                        END;
  BeeldInfo           : RECORD
                        HSize,VSize         : LONGINT;
                        Planes,BitsPerPixel : WORD;
                        Hor,Ver             : LONGINT;
                        MaxColors           : LONGINT;
                        END;
  BytesPerLine,OutPos : LONGINT;
BEGIN
  X := 0;
  Y := 0;
  IF NOT FExist(FName) THEN EXIT;
  ASSIGN(F,FName);
  RESET(F,1);
  FILLCHAR(Header,SIZEOF(Header),0);
  BLOCKREAD(F,Header,SIZEOF(Header));
  FILLCHAR(BeeldInfo,SIZEOF(BeeldInfo),0);
  BLOCKREAD(F,BeeldInfo,Header.GBeeldInfo - 4);
  CLOSE(F);
  WITH BeeldInfo,Header DO BEGIN
    BytesPerLine := HSize * BitsPerPixel;
    IF (BytesPerLine AND 31) = 0 THEN BytesPerLine := BytesPerLine SHR 3
                                 ELSE BytesPerLine := SUCC(BytesPerLine SHR 5) SHL 2;
    IF MaxColors = 0 THEN MaxColors := 1 SHL BitsPerPixel ELSE IF MaxColors = 640 THEN MaxColors := 256;
    IF (BitsPerPixel <> 8) OR (MaxColors <> 256) THEN BEGIN
      HideMouse;
      Draw_Window(231,186,415,252,5,'IMAGE FILE ERROR:');
      OutText_XY(240,215,4,2,'Sorry, Not A Valid BMP Image!');
      ShadowText(240,230,10,0,2,'Press Any Key To Continue...');
      WRITE(^G);
      READKEY;
      ShowMouse;
      Kill_Window;
      EXIT;
    END;
    X := HSize;
    Y := VSize;
    IF X >= 640 THEN X := 639;
    IF Y >= 440 THEN Y := 437;
  END;
END;
{}
PROCEDURE Show_MIF(X1,Y1 : INTEGER; FName : STRING);
BEGIN
  IF NOT FExist(FName) THEN BEGIN
    ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' Not Found!');
    EXIT;
  END;
  IF NOT FExist('MIF.EXE') THEN EXIT;
  IF Mouse_On THEN MouseMask(MouseHourGlass);
  Execute('MIF.EXE',FName + ' ' + GetFilePath(FName) + '$$MAX$$.!!! DD');
  IF FExist(GetFilePath(FName) + '$$MAX$$.!!!') THEN
  Show_PCX(X1,Y1,GetFilePath(FName) + '$$MAX$$.!!!') ELSE
  ShadowText(X1 + 2,Y1 + 2,15,0,1,FName + ' is not a valid MIF!');
  FErase(GetFilePath(FName) + '$$MAX$$.!!!');
  IF Mouse_On THEN MouseMask(MouseStandard);
END;
{}
PROCEDURE MifSize(VAR X,Y : WORD ; FName : STRING);
BEGIN
  X := 0;
  Y := 0;
  IF (NOT FExist(FName)) OR (NOT FExist('MIF.EXE')) THEN EXIT;
  IF Mouse_On THEN MouseMask(MouseHourGlass);
  Execute('MIF.EXE',FName + ' ' + GetFilePath(FName) + '$$MAX$$.!!! DD');
  IF FExist(GetFilePath(FName) + '$$MAX$$.!!!') THEN
  PcxSize(X,Y,GetFilePath(FName) + '$$MAX$$.!!!') ELSE BEGIN
    HideMouse;
    Draw_Window(231,186,415,252,5,'IMAGE FILE ERROR:');
    OutText_XY(240,215,4,2,'Sorry, Not A Valid MIF Image!');
    ShadowText(240,230,10,0,2,'Press Any Key To Continue...');
    WRITE(^G);
    READKEY;
    ShowMouse;
    Kill_Window;
  END;
  FErase(GetFilePath(FName) + '$$MAX$$.!!!');
  IF Mouse_On THEN MouseMask(MouseStandard);
END;
{}
PROCEDURE Put_Image(X1,Y1 : WORD ; ImageFile : STRING);
BEGIN
  IF Y1 < 20 THEN Y1 := 20;
  ImageFile := AllCaps(ImageFile);
  IF POS('.PCX',ImageFile) > 0 THEN Show_PCX(X1,Y1,ImageFile);
  IF POS('.BMP',ImageFile) > 0 THEN Show_BMP(X1,Y1,ImageFile);
  IF POS('.MIF',ImageFile) > 0 THEN Show_MIF(X1,Y1,ImageFile);
END;
{}

END.
