{$I DEFINES.INC}
UNIT GUI_ICON; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).
  }

INTERFACE

{Icon Drawing/Effects}
PROCEDURE Flip_Icon(X,Y : WORD ; Icon1,Icon2,Icon3,Icon4,ISize : BYTE);
PROCEDURE AnimateIcon(XStart,YStart,XEnd,YEnd,Speed,IconSize,Icon : INTEGER);
PROCEDURE PutIcon16(X,Y,I,E : WORD);
PROCEDURE PutIcon30(X,Y,I,E : WORD);
PROCEDURE PutIcon60(X,Y,I,E : WORD);
{}

IMPLEMENTATION

USES GUI_UNIT, GUI_UTIL, FGMAIN, FGBITMAP, APTIMER;

TYPE IArray = ARRAY[0..3599] OF BYTE;

VAR
  XX : ^IArray;
  ZZ : ^IArray;

{}
PROCEDURE Flip_Icon(X,Y : WORD ; Icon1,Icon2,Icon3,Icon4,ISize : BYTE);
BEGIN
  IF NFlips = 0 THEN BEGIN
    NEW(IconFlip);
    FILLCHAR(IconFlip^,SIZEOF(IconFlip^),0);
    Show_Mem;
  END;
  IF NFlips + 1 > 128 THEN EXIT;
  IF ISize > 3 THEN ISize := 2;
  INC(NFlips);
  IconFlip^[NFlips].X       := X;
  IconFlip^[NFlips].Y       := Y;
  IconFlip^[NFlips].Icon[1] := Icon1;
  IconFlip^[NFlips].Icon[2] := Icon2;
  IconFlip^[NFlips].Icon[3] := Icon3;
  IconFlip^[NFlips].Icon[4] := Icon4;
  IconFlip^[NFlips].Size    := ISize;
  CASE ISize OF
    1 : PutIcon16(X,Y,Icon1,0);
    2 : PutIcon30(X,Y,Icon1,0);
    3 : PutIcon60(X,Y,Icon1,0);
  END;
END;
{}
PROCEDURE AnimateIcon(XStart,YStart,XEnd,YEnd,Speed,IconSize,Icon : INTEGER);
VAR
  ZA : ^IArray;
PROCEDURE PlotIt(X1,Y1,X2,Y2 : INTEGER);
VAR
  LgDelta,ShDelta,LgStep,ShStep,Cycle : INTEGER;
PROCEDURE Switch(VAR First, Second : INTEGER);
VAR
  Temp : INTEGER;
BEGIN
  Temp   := First;
  First  := Second;
  Second := Temp;
END;
PROCEDURE DoTheIcon;
BEGIN
  FILLCHAR(ZA^,SIZEOF(ZA^),0);
  CASE IconSize OF
    1 : BEGIN
          FG_Move(X1,Y1 + 15);
          FG_GetImage(ZA^,16,16);
          PutIcon16(X1,Y1,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed) ELSE WaitForRetrace;
          FG_PutImage(ZA^,16,16);
        END;
    2 : BEGIN
          FG_Move(X1,Y1 + 29);
          FG_GetImage(ZA^,30,30);
          PutIcon30(X1,Y1,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed) ELSE WaitForRetrace;
          FG_PutImage(ZA^,30,30);
        END;
    3 : BEGIN
          FG_Move(X1,Y1 + 59);
          FG_GetImage(ZA^,60,60);
          PutIcon60(X1,Y1,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed) ELSE WaitForRetrace;
          FG_PutImage(ZA^,60,60);
        END;
  END;
END;
BEGIN
  LgDelta := X2 - X1;
  ShDelta := Y2 - Y1;
  IF LgDelta < 0 THEN BEGIN
    LgDelta := - LgDelta;
    LgStep  := - 1;
  END ELSE LgStep := 1;
  IF ShDelta < 0 THEN BEGIN
    ShDelta := - ShDelta;
    ShStep  := - 1;
  END ELSE ShStep := 1;
  IF LgDelta > ShDelta THEN BEGIN
    Cycle := LgDelta SHR 1;
    WHILE X1 <> X2 DO BEGIN
      DoTheIcon;
      INC(X1,LgStep);
      INC(Cycle, ShDelta);
      IF Cycle > LgDelta THEN BEGIN
        INC(Y1,ShStep);
        DEC(Cycle,LgDelta);
      END;
    END;
  END ELSE BEGIN
    Cycle := ShDelta SHR 1;
    Switch(LgDelta, ShDelta);
    Switch(LgStep, ShStep);
    WHILE Y1 <> Y2 DO BEGIN
      DoTheIcon;
      INC(Y1,LgStep);
      INC(Cycle,ShDelta);
      IF Cycle > LgDelta THEN BEGIN
        INC(X1,ShStep);
        DEC(Cycle,LgDelta);
      END;
    END;
  END;
END;
BEGIN
  IF Speed = 0 THEN FG_WaitVR(0){ ELSE Speed := Speed * 10};
  NEW(ZA);
  FILLCHAR(ZA^,SIZEOF(ZA^),0);
  CASE IconSize OF
    1 : BEGIN
          FG_Move(XStart,YStart + 15);
          FG_GetImage(ZA^,16,16);
          PutIcon16(XStart,YStart,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed);
          WaitForRetrace;
          FG_PutImage(ZA^,16,16);
        END;
    2 : BEGIN
          FG_Move(XStart,YStart + 29);
          FG_GetImage(ZA^,30,30);
          PutIcon30(XStart,YStart,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed);
          WaitForRetrace;
          FG_PutImage(ZA^,30,30);
        END;
    3 : BEGIN
          FG_Move(XStart,YStart + 59);
          FG_GetImage(ZA^,60,60);
          PutIcon60(XStart,YStart,Icon,0);
          IF Speed <> 0 THEN DELAY(Speed);
          WaitForRetrace;
          FG_PutImage(ZA^,60,60);
        END;
  END;
  PlotIt(XStart,YStart,XEnd,YEnd);
  DISPOSE(ZA);
  CASE IconSize OF
    1 : PutIcon16(XEnd,YEnd,Icon,0);
    2 : PutIcon30(XEnd,YEnd,Icon,0);
    3 : PutIcon60(XEnd,YEnd,Icon,0);
  END;
  IF Speed = 0 THEN FG_WaitVR(1);
END;
{}
PROCEDURE GetArray(VAR Temp : ARRAY OF BYTE ; WhichOne,Size,Index : INTEGER);
VAR
  Loop : INTEGER;
BEGIN
  FILLCHAR(Temp,SIZEOF(Temp),0);
  FOR Loop := 0 TO (Size - 1) DO BEGIN
    IF WhichOne = 1 THEN Temp[Loop] := XX^[Loop + ((Index * Size) - (Size))]
                    ELSE Temp[Loop] := ZZ^[Loop + ((Index * Size) - (Size))];
  END;
END;
{}
PROCEDURE DripDown(X,Y,Size : INTEGER);
VAR
  PArray : ARRAY[0..59] OF BYTE;
  RArray : ARRAY[0..59] OF BYTE;
  Loop1  : INTEGER;
  Loop2  : INTEGER;
BEGIN
  FOR Loop1 := 1 TO Size DO BEGIN
    GetArray(PArray,1,Size,Loop1);
    GetArray(RArray,0,Size,Loop1);
    WaitForRetrace;
    FOR Loop2 := 0 TO (Size - Loop1) DO BEGIN
      FG_Move(X,Y + Loop2);
      FG_PutImage(RArray,Size,1);
      FG_DrwImage(PArray,Size,1);
      DELAY(6);
    END;
  END;
END;
{}
PROCEDURE DripUp(X,Y,Size : INTEGER);
VAR
  PArray : ARRAY[0..59] OF BYTE;
  RArray : ARRAY[0..59] OF BYTE;
  Loop1  : INTEGER;
  Loop2  : INTEGER;
BEGIN
  FOR Loop1 := Size DOWNTO 1 DO BEGIN
    GetArray(PArray,1,Size,Loop1);
    GetArray(RArray,0,Size,Loop1);
    WaitForRetrace;
    FOR Loop2 := (Y + (Size - 1)) DOWNTO ((Y + Size) - Loop1) DO BEGIN
      FG_Move(X,Loop2);
      FG_PutImage(RArray,Size,1);
      FG_DrwImage(PArray,Size,1);
      DELAY(6);
    END;
  END;
END;
{}
PROCEDURE HorizWeave(X,Y,Size : INTEGER);
VAR
  PArray : ARRAY[0..59] OF BYTE;
  RArray : ARRAY[0..59] OF BYTE;
  Loop1  : INTEGER;
  Loop2  : INTEGER;
  Left   : INTEGER;
  Right  : INTEGER;
BEGIN
  Left  := 0;
  Right := (Size - 1);
  FOR Loop1 := 1 TO Size DO BEGIN
    FOR Loop2 := 0 TO (Size - 1) DO BEGIN
      GetArray(PArray,1,Size,Size - Loop2);
      IF ODD(Loop2) THEN BEGIN
        IF PArray[Left] <> 0 THEN BEGIN
          FG_SetColor(PArray[Left]);
          FG_Point(X + Left,Y + Loop2);
        END;
      END ELSE BEGIN
        IF PArray[Right] <> 0 THEN BEGIN
          FG_SetColor(PArray[Right]);
          FG_Point(X + Right,Y + Loop2);
        END;
      END;
    END;
    DELAY(7);
    INC(Left);
    DEC(Right);
  END;
END;
{}
PROCEDURE VertWeave(X,Y,Size : INTEGER);
VAR
  PArray : ARRAY[0..59] OF BYTE;
  RArray : ARRAY[0..59] OF BYTE;
  Loop1  : INTEGER;
  Loop2  : INTEGER;
  Top    : INTEGER;
  Bottom : INTEGER;
BEGIN
  Top    := Size;
  Bottom := 1;
  FOR Loop1 := 1 TO Size DO BEGIN
    GetArray(PArray,1,Size,Top);
    FOR Loop2 := 0 TO (Size - 1) DO BEGIN
      IF (ODD(Loop2)) AND (PArray[Loop2] <> 0) THEN BEGIN
        FG_SetColor(PArray[Loop2]);
        FG_Point(X + Loop2,Y + (Loop1 - 1));
      END;
    END;
    GetArray(PArray,1,Size,Bottom);
    FOR Loop2 := 0 TO (Size - 1) DO BEGIN
      IF (NOT ODD(Loop2)) AND (PArray[Loop2] <> 0) THEN BEGIN
        FG_SetColor(PArray[Loop2]);
        FG_Point(X + Loop2,(Y + Size) - Loop1);
      END;
    END;
    DELAY(7);
    DEC(Top);
    INC(Bottom);
  END;
END;
{}
PROCEDURE PutIcon16(X,Y,I,E : WORD);
TYPE Icon16x16 = RECORD
     Matrix    : ARRAY[1..16,1..16] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I16   : Icon16x16;
  Dat16 : FILE OF Icon16x16;
PROCEDURE Icon16Error;
BEGIN
  FG_SetColor(15);
  FG_Box(X,X + 15,Y,Y + 15);
  OutText_XY(X + 5,Y + 5,14,1,'Icon Not Found');
END;
BEGIN
  IF NOT FExist(IconLib16) THEN BEGIN
    Icon16Error;
    EXIT;
  END;
  IF POS('.001',IconLib16) < 1 THEN BEGIN
    Icon16Error;
    EXIT;
  END;
  ASSIGN(Dat16,IconLib16);
  RESET(Dat16);
  IF I > (FILESIZE(Dat16) - 1) THEN BEGIN
    CLOSE(Dat16);
    Icon16Error;
    EXIT;
  END;
  NEW(XX);
  NEW(ZZ);
  SEEK(Dat16,I);
  READ(Dat16,I16);
  CLOSE(Dat16);
  FILLCHAR(XX^,SIZEOF(XX^),#0);
  X2 := 0;
  FOR L1 := 16 DOWNTO 1 DO BEGIN                        {This  routine was}
    FOR L2 := 1 TO 16 DO BEGIN                          {added in order to}
      IF I16.Matrix[L2,L1] = 0 THEN XX^[X2] := 226 ELSE {allow a person to}
      IF I16.Matrix[L2,L1] = 255 THEN XX^[X2] := 0 ELSE {display RoboBOARD}
      XX^[X2] := I16.Matrix[L2,L1];                     {and Squirtgun BBS}
      INC(X2);                                          {icons correctly..}
    END;
  END;
  FG_Move(X,Y + 15);
  IF E <> 0 THEN BEGIN
    FILLCHAR(ZZ^,SIZEOF(ZZ^),0);
    FG_GetImage(ZZ^,16,16);
  END;
  CASE E OF
    0 : FG_DrwImage(XX^,16,16);
    1 : DripDown(X,Y,16);
    2 : DripUp(X,Y,16);
    3 : HorizWeave(X,Y,16);
    4 : VertWeave(X,Y,16);
  END;
  DISPOSE(XX);
  DISPOSE(ZZ);
END;
{}
PROCEDURE PutIcon30(X,Y,I,E : WORD);
TYPE Icon30x30 = RECORD
     Matrix    : ARRAY[1..30,1..30] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I30   : Icon30x30;
  Dat30 : FILE OF Icon30x30;
PROCEDURE Icon30Error;
BEGIN
  FG_SetColor(15);
  FG_Box(X,X + 29,Y,Y + 29);
  OutText_XY(X + 5,Y + 5,14,1,'Icon Not Found');
END;
BEGIN
  IF NOT FExist(IconLib30) THEN BEGIN
    Icon30Error;
    EXIT;
  END;
  IF POS('.002',IconLib30) < 1 THEN BEGIN
    Icon30Error;
    EXIT;
  END;
  ASSIGN(Dat30,IconLib30);
  RESET(Dat30);
  IF I > (FILESIZE(Dat30) - 1) THEN BEGIN
    CLOSE(Dat30);
    Icon30Error;
    EXIT;
  END;
  NEW(XX);
  NEW(ZZ);
  SEEK(Dat30,I);
  READ(Dat30,I30);
  CLOSE(Dat30);
  FILLCHAR(XX^,SIZEOF(XX^),#0);
  X2 := 0;
  FOR L1 := 30 DOWNTO 1 DO BEGIN                        {This  routine was}
    FOR L2 := 1 TO 30 DO BEGIN                          {added in order to}
      IF I30.Matrix[L2,L1] = 0 THEN XX^[X2] := 226 ELSE {allow a person to}
      IF I30.Matrix[L2,L1] = 255 THEN XX^[X2] := 0 ELSE {display RoboBOARD}
      XX^[X2] := I30.Matrix[L2,L1];                     {and Squirtgun BBS}
      INC(X2);                                          {icons correctly..}
    END;
  END;
  FG_Move(X,Y + 29);
  IF E <> 0 THEN FG_GetImage(ZZ^,30,30);
  CASE E OF
    0 : FG_DrwImage(XX^,30,30);
    1 : DripDown(X,Y,30);
    2 : DripUp(X,Y,30);
    3 : HorizWeave(X,Y,30);
    4 : VertWeave(X,Y,30);
  END;
  DISPOSE(XX);
  DISPOSE(ZZ);
END;
{}
PROCEDURE PutIcon60(X,Y,I,E : WORD);
TYPE Icon60x60 = RECORD
     Matrix    : ARRAY[1..60,1..60] OF BYTE;
     END;
VAR
  L1,L2 : BYTE;
  X2    : WORD;
  I60   : Icon60x60;
  Dat60 : FILE OF Icon60x60;
PROCEDURE Icon60Error;
BEGIN
  FG_SetColor(15);
  FG_Box(X,X + 59,Y,Y + 59);
  OutText_XY(X + 5,Y + 5,14,1,'Icon Library Not Found');
END;
BEGIN
  IF NOT FExist(IconLib60) THEN BEGIN
    Icon60Error;
    EXIT;
  END;
  IF POS('.003',IconLib60) < 1 THEN BEGIN
    Icon60Error;
    EXIT;
  END;
  ASSIGN(Dat60,IconLib60);
  RESET(Dat60);
  IF I > (FILESIZE(Dat60) - 1) THEN BEGIN
    CLOSE(Dat60);
    Icon60Error;
    EXIT;
  END;
  NEW(XX);
  NEW(ZZ);
  SEEK(Dat60,I);
  READ(Dat60,I60);
  CLOSE(Dat60);
  FILLCHAR(XX^,SIZEOF(XX^),#0);
  X2 := 0;
  FOR L1 := 60 DOWNTO 1 DO BEGIN                        {This  routine was}
    FOR L2 := 1 TO 60 DO BEGIN                          {added in order to}
      IF I60.Matrix[L2,L1] = 0 THEN XX^[X2] := 226 ELSE {allow a person to}
      IF I60.Matrix[L2,L1] = 255 THEN XX^[X2] := 0 ELSE {display RoboBOARD}
      XX^[X2] := I60.Matrix[L2,L1];                     {and Squirtgun BBS}
      INC(X2);                                          {icons correctly..}
    END;
  END;
  FG_Move(X,Y + 59);
  IF E <> 0 THEN FG_GetImage(ZZ^,60,60);
  CASE E OF
    0 : FG_DrwImage(XX^,60,60);
    1 : DripDown(X,Y,60);
    2 : DripUp(X,Y,60);
    3 : HorizWeave(X,Y,60);
    4 : VertWeave(X,Y,60);
  END;
  DISPOSE(XX);
  DISPOSE(ZZ);
END;
{}

END.
