{$I DEFINES.INC}
UNIT GUI_FONT; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  Color Averaging procedures are courtesy of Sean Price (Rude Dog Software).

This unit provides facilities for using the GEM format bitmapped fonts in
programs that use the FastGraph graphics library. GEM fonts are used in a
lot of programs such as: NeoSoft products, MAX Graphics products, and any
program written using the GX-Text kit by Genus Microprogramming.

GEM fonts may be loaded from files during program execution or they may be
linked into the .EXE file. This requires converting the font to an .OBJ file
using BINOBJ and then creating a .TPU file following the same procedures for
BGI drivers and fonts in Borland's slowpoke BGI interface. Refer to the file
GUI_UNIT.PAS, PROCEDURE LoadGemFonts; for more details.

GEM fonts are manipulated by identifiers in the form of pointers.

The same color settings and text settings that control the use of BGI fonts
in Borland's slowpoke BGI also control the use of GEM fonts, with these few
differences:

A. The normal BGI text settings for font and size are ignored. GEM fonts are
   always drawn at their native size.

B. Two text directions in addition to the two available for BGI fonts can
   be specified in a call to GEMFONTU's SetTextDirection. They are:

   0 - Horizontal, normal left to right text output.

   1 - Vertical, normal bottom to top text output.

   2 - Vertical, from top to bottom, rotated 90 degrees clockwise. For this
       direction, left justification means that the top (beginning) of the
       text is at the current position, center justification means that half
       the text is above the current position and half below, and right
       justification means that the bottom (end) of the text is at the
       current position.

   3 - Vertical, from top to bottom, without rotation. The meaning of
       justification is the same as for 2. The "Vert" setting is interpreted
       as applying to the horizontal positioning of the characters relative
       to the X coordinate of the current position. TopText causes the left
       edges of the characters to be aligned at X. CenterText causes the
       characters to be centered at X. BottomText causes the right edges of
       the characters to be aligned at X.

       NOTE: Due to improper techniques used by some people in creating
             GEM fonts, some of the above modes may not work correctly.

}
INTERFACE

USES DOS;

TYPE
  TWordArray0                 = ARRAY[0..32766] OF WORD;
  PWordArray0                 = ^TWordArray0;

  TByteArray0                 = ARRAY[0..65534] OF BYTE;
  PByteArray0                 = ^TByteArray0;

  TExtendedGEMFontHeader      = RECORD
  CharacterOffsetTablePtr     : PWordArray0; { Extended portion begins here }
  FontDataPtr                 : PByteArray0;
  AllocatedBytes              : WORD;
  FontID                      : WORD;        { True font header begins here }
  PointSize                   : WORD;
  FontName                    : ARRAY[0..31] OF CHAR;
  LowASCII                    : WORD;
  HighASCII                   : WORD;
  Top                         : INTEGER;
  Ascent                      : INTEGER;
  Half                        : INTEGER;
  Descent                     : INTEGER;
  Bottom                      : INTEGER;
  WidestCharacterWidth        : WORD;
  WidestCellWidth             : WORD;
  LeftOffset                  : INTEGER;
  RightOffset                 : INTEGER;
  Thickness                   : WORD;
  UnderscoreThickness         : WORD;
  LightTextMask               : WORD;
  ItalicTextMask              : WORD;
  Flags                       : WORD;
  HorizontalOffsetTableOffset : LONGINT;
  CharacterOffsetTableOffset  : LONGINT;
  FontDataOffset              : LONGINT;
  SpanWidth                   : WORD;
  Height                      : WORD;
  NextFontOffset              : LONGINT
  END;

  PExtendedGEMFontHeader      = ^TExtendedGEMFontHeader;

PROCEDURE SetTextDirection(D : WORD);
{^Sets the direction of the text to be displayed. Refer to the description
  in the introductory comments in the above for more details.}

FUNCTION GEMTextHeight(GEMFontID : POINTER; TextString : STRING) : WORD;
{^If GEMFontID is a valid identifier of a GEM font, this function returns
  the character height of TextString in pixels when drawn in font GEMFontID.
  (The character height is identical with the cell height of the font.)
  Otherwise the function returns 0. (The function makes no use of TextString,
  since the cell height is an attribute of the font. TextString is included
  simply for symmetry with the TextWidth function.) }

FUNCTION GEMTextWidth(GEMFontID : POINTER; TextString : STRING) : WORD;
{^If GEMFontID is a valid identifier of a GEM font, this function returns
  the width of TextString in pixels when drawn in font GEMFontID. Otherwise
  it returns 0. }

FUNCTION LoadGEMFont(FontFileName : PathStr; VAR Leading, ErrorCode : WORD) : POINTER;
{^This function loads a GEM font from file FontFileName, sets Leading to the
  cell height of the font and ErrorCode to 0, and returns an identifier for
  the font. If, however, an error occurs during the attempt to load the font,
  the function returns NIL with ErrorCode set to one of these codes:

  1 - The file is too large for LoadGEMFont to process.
  2 - There isn't enough heap memory to store the font.
  3 - The file doesn't contain a GEM font.                                 }

PROCEDURE OutGEMText(GEMFontID : POINTER; TextString : STRING);
{^If GEMFontID is a valid identifier of a GEM font, TextString is drawn at
  the current position in that font. The text is clipped at the boundaries
  of the screen. The current position is updated only if the direction is
  horizontal and justification is left (if the direction is left to right)
  or right (if the direction is right to left). However, if GEMFontID isn't
  a valid identifier, no action is taken. }

PROCEDURE OutGEMTextXY(GEMFontID : POINTER; X, Y : INTEGER; TextString : STRING);
{^Like OutGEMText,except that the text is drawn at position (X,Y) rather than
  the current position. Also, the current position isn't updated under any
  circumstances. }

FUNCTION RegisterGEMFont(LinkedGEMFontPtr : POINTER; VAR Leading, ErrorCode : WORD) : POINTER;
{^LinkedGEMFontPtr is the address of the external name of a GEM font that was
  linked into the .EXE file from a unit. The function returns an identifier
  for the font, sets Leading to the cell height of the font, and sets
  ErrorCode to 0. However, if an error is detected, the function returns NIL
  with Leading set to 0 and ErrorCode set to one of these codes:

  1 - LinkedGEMFontPtr is NIL.
  2 - There isn't enough heap memory for the control information created
      by the function.
  3 - LinkedGEMFontPtr doesn't point to a GEM font.                        }

PROCEDURE UnloadGEMFont(VAR GEMFontID : POINTER);
{^The GEM font identified by GEMFontID is removed from memory and GEMFontID
  is set to NIL. }

{}

IMPLEMENTATION

USES FGMAIN;

TYPE TextSettingsType = RECORD { This is just here to babysit me because I }
     Font             : WORD;  { was an avid BGI user before FastGraph.... }
     Direction        : WORD;
     CharSize         : WORD;
     Horiz            : WORD;
     Vert             : WORD;
     END;

CONST
  ExtensionBytes = 10;  { Extra bytes needed for the font header extension. }
  LeftText       = 0;   { More BGI babysitting crap that I needed.          }
  CenterText     = 1;   { More BGI babysitting crap that I needed.          }
  RightText      = 2;   { More BGI babysitting crap that I needed.          }
  BottomText     = 0;   { More BGI babysitting crap that I needed.          }
  TopText        = 2;   { More BGI babysitting crap that I needed.          }
  HorizDir       = 0;   { More BGI babysitting crap that I needed.          }
  VertDir        = 1;   { More BGI babysitting crap that I needed.          }

VAR
  TextSettings   : TextSettingsType;

{}
PROCEDURE SetTextDirection(D : WORD);
BEGIN
  IF D > 3 THEN D := 0;
  WITH TextSettings DO BEGIN
    Font      := 0;
    Direction := D;
    CharSize  := 1;
    Horiz     := 0;
    Vert      := 2;
  END;
END;
{}
FUNCTION GEMTextHeight(GEMFontID : POINTER; TextString : STRING) : WORD;
VAR
  FontHeaderPtr : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
BEGIN
  IF GEMFontID <> NIL THEN GEMTextHeight := FontHeaderPtr^.Height ELSE GEMTextHeight := 0
END;
{}
FUNCTION GEMTextWidth(GEMFontID : POINTER; TextString : STRING) : WORD;
VAR
  FontHeaderPtr : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
  MinCode,
  MaxCode,
  Width         : WORD;
  COTPtr        : PWordArray0;
  StringPtr     : POINTER;
  SaveDS        : WORD;
BEGIN
  Width := 0;
  IF GEMFontID <> NIL THEN BEGIN
    WITH FontHeaderPtr^ DO BEGIN
      MinCode := LowASCII;
      MaxCode := HighASCII;
      COTPtr  := CharacterOffsetTablePtr;
    END;
    StringPtr := @TextString;
    ASM
      mov SaveDS,ds             { Save DS in SaveDS                          }
      lds si,StringPtr          { Set DS:SI to @TextString[0]                }
      mov cl,[si]               { Set CX to Length(TextString)               }
      XOR ch,ch                 {                                            }
      jcxz @3                   { If CX = 0, skip to @3                      }
      mov ah,BYTE PTR MaxCode   { Otherwise set AH to MaxCode, AL to MinCode }
      mov al,BYTE PTR MinCode   {                                            }
      les di,COTPtr             { Set ES:DI to point to the Character Offset }
                                { Table                                      }
      @1 : INC si               { For each character of TextString:          }
      mov bl,[si]               { Set BL to the character                    }
      cmp bl,al                 { If BL < Mincode or > MaxCode, do nothing   }
      jb @2                     {                                            }
      cmp bl,ah                 {                                            }
      ja @2                     {                                            }
      sub bl,al                 { Otherwise reset BX to (BL-MinCode)*2 to    }
      XOR bh,bh                 { index the Character Offset Table entry     }
      SHL bx,1                  { for the character                          }
      mov dx,es : [di + bx + 2] { Set DX to the entry for the next higher    }
      sub dx,es : [di + bx]     { character - the entry for this character   }
                                { = the width of this character              }
      add Width,dx              { Add DX to Width                            }
      @2 : loop @1              {                                            }
      @3 : mov ds,SaveDS        { Restore DS from SaveDS                     }
    END;
  END;
  GEMTextWidth := Width;
END;
{}
FUNCTION LoadGEMFont(FontFileName : PathStr; VAR Leading, ErrorCode : WORD) : POINTER;
VAR
  FontFile           : FILE;
  LongFileSize       : LONGINT;
  FontFileSize,
  AllocationSize     : WORD;
  FontPtr            : PByteArray0;
  FontHeaderPtr      : PExtendedGEMFontHeader ABSOLUTE FontPtr;
  IsGEMFont          : BOOLEAN;
  TrueFontHeaderSize : WORD;
BEGIN
  ASSIGN(FontFile,FontFileName);
  RESET(FontFile,1);
  LongFileSize := FILESIZE(FontFile);
  IF LongFileSize > 65518 { 65528-ExtensionBytes } THEN BEGIN
    ErrorCode := 1;
    LoadGEMFont := NIL;
  END ELSE BEGIN
    FontFileSize := LongFileSize;
    AllocationSize := ExtensionBytes + FontFileSize;
  END;
  IF AllocationSize > MAXAVAIL THEN BEGIN
    ErrorCode := 2;
    LoadGEMFont := NIL;
  END ELSE GETMEM(FontPtr,AllocationSize);
  BLOCKREAD(FontFile,FontPtr^[ExtensionBytes],FontFileSize);
  CLOSE(FontFile);
  IsGEMFont := TRUE;
  TrueFontHeaderSize := SIZEOF(TExtendedGEMFontHeader) - ExtensionBytes;
  WITH FontHeaderPtr^ DO BEGIN
    IF (LowASCII > 255) OR (HighASCII > 255) OR (LowASCII > HighASCII) THEN IsGEMFont := FALSE
    ELSE IF WidestCharacterWidth > WidestCellWidth THEN IsGEMFont := FALSE
    ELSE IF (HorizontalOffsetTableOffset <> 0) AND
            ((HorizontalOffsetTableOffset < (TrueFontHeaderSize - 4)) OR
            (HorizontalOffsetTableOffset > FontFileSize)) THEN IsGEMFont := FALSE
    ELSE IF (CharacterOffsetTableOffset < (TrueFontHeaderSize - 4)) OR
            (CharacterOffsetTableOffset > FontFileSize) THEN IsGEMFont := FALSE
    ELSE IF (FontDataOffset < CharacterOffsetTableOffset) OR
            (FontDataOffset > FontFileSize) THEN IsGEMFont := FALSE;
  END;
  IF NOT IsGEMFont THEN BEGIN
    FREEMEM(FontPtr,AllocationSize);
    ErrorCode := 3;
    Leading := 0;
    LoadGEMFont := NIL;
  END ELSE WITH FontHeaderPtr^ DO BEGIN
    AllocatedBytes := AllocationSize;
    CharacterOffsetTablePtr := @FontPtr^[CharacterOffsetTableOffset + ExtensionBytes];
    FontDataPtr := @FontPtr^[FontDataOffset + ExtensionBytes];
    Leading := Height;
    ErrorCode := 0;
    LoadGEMFont := FontPtr;
  END;
END;
{}
PROCEDURE DrawGEMText0(GEMFontID : POINTER; X, Y : INTEGER; VAR TextString : STRING);
VAR
  FontPtr            : PByteArray0 ABSOLUTE GEMFontID;
  FontHeaderPtr      : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
  CellHeight,
  CellHeightLess1,
  MinCode,
  MaxCode            : WORD;
  COTPtr             : PWordArray0;
  StrikePtr          : PByteArray0;
  RowInterval        : WORD;
  Width              : WORD;
  OriginalY,
  MaxX,
  MaxY               : INTEGER;
  Color,
  I                  : WORD;
  Ch                 : CHAR;
  Code,
  PatternOffset,
  PatternWidth,
  PatternWidthLess1,
  ByteIndex          : WORD;
  Mask               : BYTE;
  Col,
  RowIndex,
  Row                : INTEGER;
  RowByte            : BYTE;
BEGIN
  IF GEMFontID = NIL THEN EXIT;
  WITH FontHeaderPtr^ DO BEGIN
    CellHeight  := Height;
    MinCode     := LowASCII;
    MaxCode     := HighASCII;
    COTPtr      := CharacterOffsetTablePtr;
    StrikePtr   := FontDataPtr;
    RowInterval := SpanWidth;
  END;
  WITH TextSettings DO BEGIN
    IF Horiz <> LeftText THEN BEGIN
      Width := GEMTextWidth(GEMFontID,TextString);
      IF Horiz = CenterText THEN X := X - Width DIV 2
      ELSE IF Horiz = RightText THEN X := SUCC(X - Width);
    END;
    OriginalY := Y;
    CASE Vert OF
      BottomText : Y := SUCC(Y - CellHeight);
      CenterText : Y := Y - CellHeight DIV 2;
      TopText    : ;
    END
  END;
  MaxX  := FG_GetMaxX;
  MaxY  := FG_GetMaxY;
  Color := FG_GetColor;
  IF Y + PRED(CellHeight) > MaxY THEN CellHeight := SUCC(MaxY - Y);
  CellHeightLess1 := PRED(CellHeight);
  FOR I := 1 TO LENGTH(TextString) DO BEGIN
    Ch := TextString[I];
    Code := ORD(Ch);
    IF (Code < MinCode) OR (Code > MaxCode) THEN ELSE BEGIN
      Code := Code - MinCode;
      PatternOffset := COTPtr^[Code];
      PatternWidth := COTPtr^[SUCC(Code)] - PatternOffset;
      IF PatternWidth = 0 THEN ELSE BEGIN
        PatternWidthLess1 := PRED(PatternWidth);
        IF X + PatternWidthLess1 > MaxX THEN BEGIN
          PatternWidth := SUCC(MaxX - X);
          PatternWidthLess1 := PRED(PatternWidth);
        END;
        ByteIndex := PatternOffset DIV 8;
        Mask := $80 SHR (PatternOffset MOD 8);
        FOR Col := X TO X + PatternWidthLess1 DO BEGIN
          IF Col >= 0 THEN BEGIN
            RowIndex := ByteIndex;
            FOR Row := Y TO Y + CellHeightLess1 DO BEGIN
              RowByte := StrikePtr^[RowIndex];
              IF (RowByte AND Mask) = Mask THEN FG_Point(Col,Row);
              INC(RowIndex,RowInterval);
            END;
          END;
          IF Mask = $01 THEN BEGIN
            INC(ByteIndex);
            Mask := $80;
          END ELSE Mask := Mask SHR 1;
        END;
        INC(X,PatternWidth);
        IF X > MaxX THEN BREAK;
      END;
    END;
  END;
  IF X <= MaxX THEN FG_Move(X,OriginalY) ELSE FG_Move(MaxX,OriginalY);
END;
{}
PROCEDURE DrawGEMText1(GEMFontID : POINTER; X, Y : INTEGER; VAR TextString : STRING);
VAR
  FontPtr            : PByteArray0 ABSOLUTE GEMFontID;
  FontHeaderPtr      : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
  CellHeight,
  CellHeightLess1,
  MinCode,
  MaxCode            : WORD;
  COTPtr             : PWordArray0;
  StrikePtr          : PByteArray0;
  RowInterval        : WORD;
  Width              : WORD;
  MaxX,
  MaxY               : INTEGER;
  Color,
  I                  : WORD;
  Ch                 : CHAR;
  Code,
  PatternOffset,
  PatternWidth,
  PatternWidthLess1,
  ByteIndex          : WORD;
  Mask               : BYTE;
  Col,
  RowIndex,
  Row                : INTEGER;
  RowByte            : BYTE;
BEGIN
  WITH FontHeaderPtr^ DO BEGIN
    CellHeight  := Height;
    MinCode     := LowASCII;
    MaxCode     := HighASCII;
    COTPtr      := CharacterOffsetTablePtr;
    StrikePtr   := FontDataPtr;
    RowInterval := SpanWidth;
  END;
  WITH TextSettings DO BEGIN
    IF Horiz <> LeftText THEN BEGIN
      Width := GEMTextWidth(GEMFontID,TextString);
      IF Horiz = CenterText THEN Y := Y + Width DIV 2
      ELSE IF Horiz = RightText THEN Y := PRED(Y + Width);
    END;
    CASE Vert OF
      BottomText : X := SUCC(X - CellHeight);
      CenterText : X := X - CellHeight DIV 2;
      TopText    : ;
    END;
  END;
  MaxX  := FG_GetMaxX;
  MaxY  := FG_GetMaxY;
  Color := FG_GetColor;
  IF X + PRED(CellHeight) > MaxX THEN CellHeight := SUCC(MaxX - X);
  CellHeightLess1 := PRED(CellHeight);
  FOR I := 1 TO LENGTH(TextString) DO BEGIN
    Ch := TextString[I];
    Code := ORD(Ch);
    IF (Code < MinCode) OR (Code > MaxCode) THEN ELSE BEGIN
      Code := Code - MinCode;
      PatternOffset := COTPtr^[Code];
      PatternWidth  := COTPtr^[SUCC(Code)] - PatternOffset;
      IF PatternWidth = 0 THEN ELSE BEGIN
        PatternWidthLess1 := PRED(PatternWidth);
        IF Y - PatternWidthLess1 < 0 THEN BEGIN
          PatternWidth := SUCC(Y);
          PatternWidthLess1 := PRED(PatternWidth);
        END;
        ByteIndex := PatternOffset DIV 8;
        Mask := $80 SHR (PatternOffset MOD 8);
        FOR Col := Y DOWNTO Y - PatternWidthLess1 DO BEGIN
          IF Col <= MaxY THEN BEGIN
            RowIndex := ByteIndex;
            FOR Row := X TO X + CellHeightLess1 DO BEGIN
              RowByte := StrikePtr^[RowIndex];
              IF (RowByte AND Mask) = Mask THEN
              IF Row >= 0 THEN FG_Point(Row,Col);
              INC(RowIndex,RowInterval);
            END;
          END;
          IF Mask = $01 THEN BEGIN
            INC(ByteIndex);
            Mask := $80;
          END ELSE Mask := Mask SHR 1;
        END;
        DEC(Y,PatternWidth);
        IF Y < 0 THEN BREAK;
      END;
    END;
  END;
END;
{}
PROCEDURE DrawGEMText2(GEMFontID : POINTER; X, Y : INTEGER; VAR TextString : STRING);
VAR
  FontPtr            : PByteArray0 ABSOLUTE GEMFontID;
  FontHeaderPtr      : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
  CellHeight,
  CellHeightLess1,
  MinCode,
  MaxCode            : WORD;
  COTPtr             : PWordArray0;
  StrikePtr          : PByteArray0;
  RowInterval        : WORD;
  Width              : WORD;
  MaxX,
  MaxY               : INTEGER;
  Color,
  I                  : WORD;
  Ch                 : CHAR;
  Code,
  PatternOffset,
  PatternWidth,
  PatternWidthLess1,
  ByteIndex          : WORD;
  Mask               : BYTE;
  Col,
  RowIndex,
  Row                : INTEGER;
  RowByte            : BYTE;
BEGIN
  WITH FontHeaderPtr^ DO BEGIN
    CellHeight  := Height;
    MinCode     := LowASCII;
    MaxCode     := HighASCII;
    COTPtr      := CharacterOffsetTablePtr;
    StrikePtr   := FontDataPtr;
    RowInterval := SpanWidth;
  END;
  WITH TextSettings DO BEGIN
    IF Horiz <> LeftText THEN BEGIN
      Width := GEMTextWidth(GEMFontID,TextString);
      IF Horiz = CenterText THEN Y := Y - Width DIV 2
      ELSE IF Horiz = RightText THEN Y := SUCC(Y - Width);
    END;
    CASE Vert OF
      BottomText : X := PRED(X + CellHeight);
      CenterText : X := X + CellHeight DIV 2;
      TopText    : ;
    END;
  END;
  MaxX  := FG_GetMaxX;
  MaxY  := FG_GetMaxY;
  Color := FG_GetColor;
  IF SUCC(X) < CellHeight THEN CellHeight := SUCC(X);
  CellHeightLess1 := PRED(CellHeight);
  FOR I := 1 TO LENGTH(TextString) DO BEGIN
    Ch := TextString[I];
    Code := ORD(Ch);
    IF (Code < MinCode) OR (Code > MaxCode) THEN ELSE BEGIN
      Code := Code - MinCode;
      PatternOffset := COTPtr^[Code];
      PatternWidth  := COTPtr^[SUCC(Code)] - PatternOffset;
      IF PatternWidth = 0 THEN ELSE BEGIN
        PatternWidthLess1 := PRED(PatternWidth);
        IF Y + PatternWidthLess1 > MaxY THEN BEGIN
          PatternWidth := SUCC(MaxY - Y);
          PatternWidthLess1 := PRED(PatternWidth);
        END;
        ByteIndex := PatternOffset DIV 8;
        Mask := $80 SHR (PatternOffset MOD 8);
        FOR Col := Y TO Y + PatternWidthLess1 DO BEGIN
          IF Col >= 0 THEN BEGIN
            RowIndex := ByteIndex;
            FOR Row := X DOWNTO X - CellHeightLess1 DO BEGIN
              RowByte := StrikePtr^[RowIndex];
              IF (RowByte AND Mask) = Mask THEN
              IF Row <= MaxX THEN FG_Point(Row,Col);
              INC(RowIndex,RowInterval);
            END;
          END;
          IF Mask = $01 THEN BEGIN
            INC(ByteIndex);
            Mask := $80;
          END ELSE Mask := Mask SHR 1;
        END;
        INC(Y,PatternWidth);
        IF Y > MaxY THEN BREAK;
      END;
    END;
  END;
END;
{}
PROCEDURE DrawGEMText3(GEMFontID : POINTER; X, Y : INTEGER; VAR TextString : STRING);
VAR
  FontPtr            : PByteArray0 ABSOLUTE GEMFontID;
  FontHeaderPtr      : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
  CellHeight,
  CellHeightLess1,
  MinCode,
  MaxCode            : WORD;
  COTPtr             : PWordArray0;
  StrikePtr          : PByteArray0;
  RowInterval        : WORD;
  LeftAlign,
  CenterAlign,
  RightAlign         : BOOLEAN;
  Width              : WORD;
  MaxX,
  MaxY               : INTEGER;
  Color,
  I                  : WORD;
  Ch                 : CHAR;
  Code,
  PatternOffset,
  PatternWidth,
  PatternWidthLess1,
  ByteIndex          : WORD;
  Mask               : BYTE;
  Col,
  RowIndex,
  Row,
  CharX              : INTEGER;
  RowByte            : BYTE;
BEGIN
  WITH FontHeaderPtr^ DO BEGIN
    CellHeight  := Height;
    MinCode     := LowASCII;
    MaxCode     := HighASCII;
    COTPtr      := CharacterOffsetTablePtr;
    StrikePtr   := FontDataPtr;
    RowInterval := SpanWidth;
  END;
  WITH TextSettings DO BEGIN
    IF Horiz <> LeftText THEN BEGIN
      Width := GEMTextWidth(GEMFontID,TextString);
      IF Horiz = CenterText THEN Y := Y - Width DIV 2
      ELSE IF Horiz = RightText THEN Y := SUCC(Y - Width);
    END;
    LeftAlign   := FALSE;
    CenterAlign := FALSE;
    RightAlign  := FALSE;
    CASE Vert OF
      TopText    : LeftAlign   := TRUE;
      CenterText : CenterAlign := TRUE;
      BottomText : RightAlign  := TRUE;
    END;
  END;
  MaxX  := FG_GetMaxX;
  MaxY  := FG_GetMaxY;
  Color := FG_GetColor;
  CellHeightLess1 := PRED(CellHeight);
  FOR I := 1 TO LENGTH(TextString) DO BEGIN
    Ch := TextString[I];
    Code := ORD(Ch);
    IF (Code < MinCode) OR (Code > MaxCode) THEN ELSE BEGIN
      Code := Code - MinCode;
      PatternOffset := COTPtr^[Code];
      PatternWidth := COTPtr^[SUCC(Code)] - PatternOffset;
      IF PatternWidth = 0 THEN ELSE BEGIN
        PatternWidthLess1 := PRED(PatternWidth);
        IF LeftAlign THEN CharX := X
        ELSE IF CenterAlign THEN CharX := X - PatternWidth DIV 2
        ELSE CharX := X - PatternWidthLess1;
        IF X + PatternWidthLess1 > MaxX THEN BEGIN
          PatternWidth := SUCC(MaxX - CharX);
          PatternWidthLess1 := PRED(PatternWidth);
        END;
        ByteIndex := PatternOffset DIV 8;
        Mask := $80 SHR (PatternOffset MOD 8);
        FOR Col := CharX TO CharX + PatternWidthLess1 DO BEGIN
          IF Col >= 0 THEN BEGIN
            RowIndex := ByteIndex;
            FOR Row := Y TO Y + CellHeightLess1 DO BEGIN
              RowByte := StrikePtr^[RowIndex];
              IF (RowByte AND Mask) = Mask THEN
              IF (Row >= 0) AND (Row <= MaxY) THEN FG_Point(Col,Row);
              INC(RowIndex,RowInterval);
            END;
          END;
          IF Mask = $01 THEN BEGIN
            INC(ByteIndex);
            Mask := $80;
          END ELSE Mask := Mask SHR 1;
        END;
        INC(Y,CellHeight);
        IF Y > MaxY THEN BREAK;
      END;
    END;
  END;
END;
{}
PROCEDURE OutGEMText(GEMFontID : POINTER; TextString : STRING);
VAR
  X,Y : INTEGER;
BEGIN
  IF GEMFontID <> NIL THEN BEGIN
    X := FG_GetXPos;
    Y := FG_GetYPos;
    CASE TextSettings.Direction OF
      0 : DrawGEMText0(GEMFontID,X,Y,TextString);
      1 : DrawGEMText1(GEMFontID,X,Y,TextString);
      2 : DrawGEMText2(GEMFontID,X,Y,TextString);
      3 : DrawGEMText3(GEMFontID,X,Y,TextString);
    END;
  END;
END;
{}
PROCEDURE OutGEMTextXY(GEMFontID : POINTER; X, Y : INTEGER; TextString : STRING);
BEGIN
  IF GEMFontID <> NIL THEN BEGIN
    CASE TextSettings.Direction OF
      0 : DrawGEMText0(GEMFontID,X,Y,TextString);
      1 : DrawGEMText1(GEMFontID,X,Y,TextString);
      2 : DrawGEMText2(GEMFontID,X,Y,TextString);
      3 : DrawGEMText3(GEMFontID,X,Y,TextString);
    END;
  END;
END;
{}
FUNCTION IncPtr(P : POINTER; INC : LONGINT) : POINTER;
TYPE TPtrRec = RECORD
     Offset  : WORD;
     Segment : WORD;
     END;
VAR
  L : LONGINT;
BEGIN
  WITH TPtrRec(P) DO L := ((LONGINT(Segment) SHL 4) + LONGINT(Offset)) + INC;
  IncPtr := PTR(WORD(L SHR 4),WORD(L AND $0000000F));
END;
{}
FUNCTION RegisterGEMFont(LinkedGEMFontPtr : POINTER; VAR Leading, ErrorCode : WORD) : POINTER;
VAR
  ObjFontPtr         : PByteArray0 ABSOLUTE LinkedGEMFontPtr;
  ObjFontHeaderPtr,
  NewFontHeaderPtr   : PExtendedGEMFontHeader;
  IsGEMFont          : BOOLEAN;
  TrueFontHeaderSize : WORD;
BEGIN
  Leading := 0;
  RegisterGEMFont := NIL;
  IF LinkedGEMFontPtr = NIL THEN BEGIN
    ErrorCode := 1;
    EXIT
  END;
  ObjFontHeaderPtr   := IncPtr(LinkedGEMFontPtr, - ExtensionBytes);
  IsGEMFont          := TRUE;
  TrueFontHeaderSize := SIZEOF(TExtendedGEMFontHeader) - ExtensionBytes;
  WITH ObjFontHeaderPtr^ DO BEGIN
    IF (LowASCII > 255) OR (HighASCII > 255) OR (LowASCII > HighASCII) THEN IsGEMFont := FALSE
    ELSE IF WidestCharacterWidth > WidestCellWidth THEN IsGEMFont := FALSE
    ELSE IF (HorizontalOffsetTableOffset <> 0) AND
            (HorizontalOffsetTableOffset < (TrueFontHeaderSize - 4)) THEN IsGEMFont := FALSE
    ELSE IF (CharacterOffsetTableOffset < (TrueFontHeaderSize - 4)) THEN IsGEMFont := FALSE
    ELSE IF FontDataOffset < CharacterOffsetTableOffset
    THEN IsGEMFont := FALSE;
  END;
  IF NOT IsGEMFont THEN BEGIN
    ErrorCode := 3;
    EXIT;
  END;
  IF SIZEOF(TExtendedGEMFontHeader) > MAXAVAIL THEN BEGIN
    ErrorCode := 2;
    EXIT;
  END;
  GETMEM(NewFontHeaderPtr,SIZEOF(TExtendedGEMFontHeader));
  MOVE(LinkedGEMFontPtr^,NewFontHeaderPtr^.FontID,TrueFontHeaderSize);
  WITH NewFontHeaderPtr^ DO BEGIN
    CharacterOffsetTablePtr := @ObjFontPtr^[CharacterOffsetTableOffset];
    FontDataPtr := @ObjFontPtr^[FontDataOffset];
    AllocatedBytes := SIZEOF(TExtendedGEMFontHeader);
    Leading := Height;
  END;
  ErrorCode := 0;
  RegisterGEMFont := POINTER(NewFontHeaderPtr);
END;
{}
PROCEDURE UnloadGEMFont(VAR GEMFontID : POINTER);
VAR
  FontHeaderPtr : PExtendedGEMFontHeader ABSOLUTE GEMFontID;
BEGIN
  IF GEMFontID <> NIL THEN BEGIN
    FREEMEM(GEMFontID,FontHeaderPtr^.AllocatedBytes);
    GEMFontID := NIL;
  END
END;
{}
BEGIN
  SetTextDirection(0);
END.
