{$I DEFINES.INC}
UNIT GUI_FGL;{

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  BMP Color Averaging procedure is courtesy of Sean Price (Rude Dog Software).
}

INTERFACE

FUNCTION  GetFGL(FGL,WritePath,TheFile : STRING) : BOOLEAN;
FUNCTION  CreateFGL(FGL : STRING) : BOOLEAN;
PROCEDURE AddToFileBuffer(FName : STRING);
PROCEDURE EmptyFileBuffer;

IMPLEMENTATION

USES DOS,GUI_UTIL;

TYPE File_Buffer = ARRAY[1..800] OF STRING[80];
TYPE Data_Buffer = ARRAY[0..32766] OF BYTE;

TYPE FileHeader  = RECORD      {FileHeader = 21 Bytes}
     FName       : STRING[12];
     FSize       : LONGINT;
     Location    : LONGINT;
     END;

VAR
  FBuff          : ^File_Buffer;
  DBuff          : ^Data_Buffer;
  FilesInBuffer  : WORD;
  Header         : FileHeader;

FUNCTION GetFGL(FGL,WritePath,TheFile : STRING) : BOOLEAN;
VAR
  F1,F2  : FILE;
  Target : LONGINT;
  BRead  : INTEGER;
  BWrite : INTEGER;
  Count  : WORD;
  FTotal : WORD;
BEGIN
  GetFGL    := FALSE;
  TheFile   := AllCaps(StripBoth(TheFile,' '));
  WritePath := FixPath(WritePath);
  IF WritePath = '\' THEN WritePath := '';
  IF (NOT FExist(FGL + '.FGL')) OR (NOT DExist(WritePath)) OR (POS('.',FGL) > 0) OR (TheFile = '') THEN EXIT;
  ASSIGN(F1,FGL + '.FGL');
  RESET(F1,1);
  BLOCKREAD(F1,FTotal,2);
  IF (FTotal < 1) OR (FTotal > 800) THEN BEGIN
    CLOSE(F1);
    EXIT;
  END;
  Count  := 0;
  Target := 0;
  REPEAT
    INC(Count);
    BLOCKREAD(F1,Header,21);
    IF Header.FName = TheFile THEN BEGIN
      NEW(DBuff);
      ASSIGN(F2,WritePath + TheFile);
      REWRITE(F2,1);
      SEEK(F1,Header.Location);
      REPEAT
        FILLCHAR(DBuff^,SIZEOF(DBuff^),0);
        IF (Target + SIZEOF(DBuff^)) < Header.FSize THEN BEGIN
          BLOCKREAD(F1,DBuff^,SIZEOF(DBuff^),BRead);
          BLOCKWRITE(F2,DBuff^,BRead,BWrite);
          INC(Target,SIZEOF(DBuff^));
        END ELSE BEGIN
          BLOCKREAD(F1,DBuff^,(Header.FSize - Target),BRead);
          BLOCKWRITE(F2,DBuff^,BRead,BWrite);
          Target := Header.FSize;
        END;
      UNTIL (Target = Header.FSize) OR (BRead = 0) OR (BRead <> BWrite);
      CLOSE(F2);
      CLOSE(F1);
      DISPOSE(DBuff);
      IF BRead <> BWrite THEN ERASE(F2) ELSE GetFGL := TRUE;
      EXIT;
    END;
  UNTIL (Count = FTotal) OR (EOF(F1));
  CLOSE(F1);
END;

FUNCTION CreateFGL(FGL : STRING) : BOOLEAN;
VAR
  DirInfo : SEARCHREC;
  FHeader : FILE OF FileHeader;
  F1,F2   : FILE;
  Count   : WORD;
  BRead   : INTEGER;
  BWrite  : INTEGER;
  HSize   : LONGINT;
PROCEDURE UpdateHeader(TheFile : STRING ; Loc : LONGINT);
VAR
  Loop : WORD;
BEGIN
  ASSIGN(FHeader,'HEADER.TMP');
  RESET(FHeader);
  FOR Loop := 0 TO (FILESIZE(FHeader) - 1) DO BEGIN
    READ(FHeader,Header);
    IF Header.FName = TheFile THEN BEGIN
      Header.Location := Loc;
      SEEK(FHeader,Loop);
      WRITE(FHeader,Header);
      CLOSE(FHeader);
      EXIT;
    END;
  END;
  CLOSE(FHeader);
END;
BEGIN
  CreateFGL := FALSE;
  HSize     := 0;
  IF (FBuff = NIL) OR (FilesInBuffer = 0) OR (POS('.',FGL) > 0) THEN EXIT;
  ASSIGN(FHeader,'HEADER.TMP');
  REWRITE(FHeader);
  FOR Count := 1 TO FilesInBuffer DO BEGIN
    FINDFIRST(FBuff^[Count],Anyfile - Directory - VolumeID,DirInfo);
    IF DOSERROR <> 0 THEN BEGIN
      CLOSE(FHeader);
      ERASE(FHeader);
      EXIT;
    END;
    WITH Header DO BEGIN
      FILLCHAR(Header,SIZEOF(Header),0);
      FName := GetFileName(FBuff^[Count]);
      FSize := DirInfo.Size;
      INC(HSize,21);
    END;
    WRITE(FHeader,Header);
  END;
  CLOSE(FHeader);
  NEW(DBuff);
  ASSIGN(F1,'FGL.TMP');
  REWRITE(F1,1);
  FOR Count := 1 TO FilesInBuffer DO BEGIN
    WRITELN('Writing: ',PadRight(GetFileName(FBuff^[Count]),' ',12),' - File Position: ',2 + HSize + FILESIZE(F1));
    UpdateHeader(GetFileName(FBuff^[Count]),2 + HSize + FILESIZE(F1));
    ASSIGN(F2,FBuff^[Count]);
    RESET(F2,1);
    REPEAT
      FILLCHAR(DBuff^,SIZEOF(DBuff^),0);
      BLOCKREAD(F2,DBuff^,SIZEOF(DBuff^),BRead);
      BLOCKWRITE(F1,DBuff^,BRead,BWrite);
    UNTIL (BRead = 0) OR (BRead <> BWrite);
    CLOSE(F2);
    IF BRead <> BWrite THEN BEGIN
      CLOSE(F1);
      ERASE(F1);
      ERASE(FHeader);
      DISPOSE(DBuff);
      EXIT;
    END;
  END;
  CLOSE(F1);
  ASSIGN(F1,FGL + '.FGL');
  REWRITE(F1,1);
  BLOCKWRITE(F1,FilesInBuffer,2);
  ASSIGN(F2,'HEADER.TMP');
  RESET(F2,1);
  REPEAT
    FILLCHAR(DBuff^,SIZEOF(DBuff^),0);
    BLOCKREAD(F2,DBuff^,SIZEOF(DBuff^),BRead);
    BLOCKWRITE(F1,DBuff^,BRead,BWrite);
  UNTIL (BRead = 0) OR (BRead <> BWrite);
  CLOSE(F2);
  ERASE(F2);
  IF BRead <> BWrite THEN BEGIN
    CLOSE(F1);
    ERASE(F1);
    FErase('FGL.TMP');
    DISPOSE(DBuff);
    EXIT;
  END;
  ASSIGN(F2,'FGL.TMP');
  RESET(F2,1);
  REPEAT
    FILLCHAR(DBuff^,SIZEOF(DBuff^),0);
    BLOCKREAD(F2,DBuff^,SIZEOF(DBuff^),BRead);
    BLOCKWRITE(F1,DBuff^,BRead,BWrite);
  UNTIL (BRead = 0) OR (BRead <> BWrite);
  CLOSE(F2);
  ERASE(F2);
  IF BRead <> BWrite THEN BEGIN
    CLOSE(F1);
    ERASE(F1);
    DISPOSE(DBuff);
    EXIT;
  END;
  CLOSE(F1);
  DISPOSE(DBuff);
  CreateFGL := TRUE;
END;

PROCEDURE AddToFileBuffer(FName : STRING);
BEGIN
  IF FBuff = NIL THEN BEGIN
    NEW(FBuff);
    FILLCHAR(FBuff^,SIZEOF(FBuff^),0);
  END;
  INC(FilesInBuffer);
  FBuff^[FilesInBuffer] := AllCaps(StripBoth(FName,' '));
END;

PROCEDURE EmptyFileBuffer;
BEGIN
  DISPOSE(FBuff);
  FilesInBuffer := 0;
  FBuff         := NIL;
END;

BEGIN
  FBuff         := NIL;
  FilesInBuffer := 0;
END.
