{$I DEFINES.INC}
UNIT GUI_ANSI; {

              
            
               ͻ ͻ ͻ    ͻ ͻ
                    ˼ ͹ ͼ ͹     ͻ
                   ͼ          ͼ ͼ

  The MAX Graphics GUI kit is Copyright 1995-Current Larry L. Athey (LA-Soft).
  BMP Color Averaging procedure is courtesy of Sean Price (Rude Dog Software).
}

INTERFACE

PROCEDURE Display_ANSI(Ch : CHAR);
{^ Processes a character from an ANSI or ASCII text string.}
PROCEDURE Display_ANSIstr(S : STRING);
{^ Processes an entire ANSI or ASCII text string.}
PROCEDURE Goto_XY(X1,Y1 : BYTE);
{^ Equivalent to GotoXY in text mode.}
PROCEDURE Clr_Scr;
{^ Equivalent to ClrScr in text mode.}
PROCEDURE Clr_Eol;
{^ Equivalent to ClrEol in text mode.}
PROCEDURE PlaceCursor;
{^ Plots a bogus cursor on the screen (for visual reference only).}
PROCEDURE EraseCursor;
{^ Erases the bogus cursor.}
PROCEDURE ResetANSI;
{^ Resets all variables in this unit.}

TYPE Ch_Array = ARRAY[1..80,1..25] OF CHAR;
TYPE Fg_Array = ARRAY[1..80,1..25] OF BYTE;
TYPE Bg_Array = ARRAY[1..80,1..25] OF BYTE; {Arrays for scrolling the screen}

VAR
  Where_X     : BYTE;    {Equivalent to WhereY in text mode.                  }
  Where_Y     : BYTE;    {Equivalent to WhereX in text mode.                  }
  ANSI_FG     : INTEGER; {Stores current foreground color.                    }
  ANSI_BG     : INTEGER; {Stores current background color.                    }
  CursorOn    : BOOLEAN; {Is the simulated ANSI cursor on?                    }
  HandleMouse : BOOLEAN; {Turn the mouse cursor on/off automatically? [Y/N]   }
  ChArray     : ^Ch_Array;
  FgArray     : ^Fg_Array;
  BgArray     : ^Bg_Array;

IMPLEMENTATION

USES MYCRT, GUI_UNIT, FGMAIN, FGBITMAP, APTIMER;

VAR
  ANSI_St   : STRING ; {Stores ANSI escape sequence if receiving ANSI}
  ANSI_SCPL : INTEGER; {Stores the saved cursor position line}
  ANSI_SCPC : INTEGER; {   "     "     "     "     "   column}
  ANSI_C,
  ANSI_I,
  ANSI_B,
  ANSI_R    : BOOLEAN; {Stores current attribute options}
  P,X,Y     : INTEGER; {Miscellaneous private variables}

PROCEDURE Goto_XY(X1,Y1 : BYTE);
BEGIN
  Where_X := X1;
  Where_Y := Y1;
END;

PROCEDURE Clr_Scr;
BEGIN
  IF NOT TvPort.Active THEN EXIT;
  FILLCHAR(ChArray^,SIZEOF(ChArray^),0);
  FILLCHAR(FgArray^,SIZEOF(FgArray^),0);
  FILLCHAR(BgArray^,SIZEOF(BgArray^),0);
  Where_X := 1;
  Where_Y := 1;
  FG_SetColor(ANSI_BG);
  FG_ClpRect(TvPort.StartX,(TvPort.ColLimit*8)+TvPort.StartX,
             TvPort.StartY,(TvPort.RowLimit*16)+TvPort.StartY);
END;

PROCEDURE Clr_Eol;
VAR
  X : BYTE;
BEGIN
  IF NOT TvPort.Active THEN EXIT;
  FOR X := Where_X TO 80 DO BEGIN
    ChArray^[X,Where_Y] := ' ';
    FgArray^[X,Where_Y] := 0;
    BgArray^[X,Where_Y] := 0;
  END;
  FG_SetColor(ANSI_BG);
  FG_ClpRect(((Where_X*8)+TvPort.StartX)-8,((TvPort.ColLimit*8)+TvPort.StartX)-8,
             ((Where_Y*16)+TvPort.StartY)-15,((Where_Y*16)+(TvPort.StartY+14))-14);
END;

PROCEDURE ScrollScreen;
VAR
  SX,SY : BYTE;
BEGIN
  FOR SY := 1 TO (Where_Y-1) DO BEGIN
    FOR SX := 1 TO 80 DO BEGIN
      ChArray^[SX,SY] := ChArray^[SX,SY+1];
      FgArray^[SX,SY] := FgArray^[SX,SY+1];
      BgArray^[SX,SY] := BgArray^[SX,SY+1];
    END;
  END;
  Clr_Eol;
  FOR SY := 1 TO (Where_Y-1) DO BEGIN
    FOR SX := 1 TO TvPort.ColLimit DO BEGIN
      FG_SetColor(BgArray^[SX,SY]);
      FG_ClpRect(((SX*8)+TvPort.StartX)-8,((SX*8)+TvPort.StartX+7)-8,
                 ((SY*16)+TvPort.StartY)-15,((SY*16)+TvPort.StartY+14)-14);
      FG_Move(((SX*8)+TvPort.StartX)-8,((SY*16)+TvPort.StartY));
      FG_SetColor(FgArray^[SX,SY]);
      FG_PrintC(ChArray^[SX,SY],1);
    END;
  END;
END;

PROCEDURE _Write(Ch : CHAR);
BEGIN
  FG_SetColor(ANSI_BG);
  FG_ClpRect(((Where_X*8)+TvPort.StartX)-8,((Where_X*8)+TvPort.StartX+7)-8,
             ((Where_Y*16)+TvPort.StartY)-15,((Where_Y*16)+TvPort.StartY+14)-14);
  FG_Move(((Where_X*8)+TvPort.StartX)-8,((Where_Y*16)+(TvPort.StartY)));
  FG_SetColor(ANSI_FG);
  FG_PrintC(Ch,1);
  ChArray^[Where_X,Where_Y] := Ch;
  FgArray^[Where_X,Where_Y] := ANSI_FG;
  BgArray^[Where_X,Where_Y] := ANSI_BG;
  INC(Where_X);
  IF Where_X > TvPort.ColLimit THEN BEGIN
    Where_X := 1;
    IF Where_Y <= (TvPort.RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
  END;
END;

PROCEDURE Tabulate;
VAR
  X : INTEGER;
BEGIN
  X := Where_X;
  IF X < TvPort.ColLimit THEN REPEAT INC(X) UNTIL (X MOD 8) = 0;
  IF X = TvPort.ColLimit THEN X := 1;
  Goto_XY(X,Where_Y);
  IF X = 1 THEN IF Where_Y <= (TvPort.RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
END;

PROCEDURE BackSpace;
VAR
  X : INTEGER;
BEGIN
  IF Where_X > 1 THEN BEGIN
    Goto_XY(Where_X - 1,Where_Y);
    _Write(' ');
    Goto_XY(Where_X - 1,Where_Y);
  END ELSE IF Where_Y > 1 THEN BEGIN
    Goto_XY(TvPort.ColLimit,Where_Y - 1);
    _Write(' ');
    Goto_XY(TvPort.ColLimit,Where_Y - 1);
  END;
END;

PROCEDURE TTY(Ch : CHAR);
VAR
  X : INTEGER;
BEGIN
  IF ANSI_C THEN BEGIN
    IF ANSI_I THEN ANSI_FG := ANSI_FG OR 8;
    IF ANSI_B THEN BEGIN
      ANSI_BG := ANSI_BG + 8;
      IF ANSI_BG > 15 THEN DEC(ANSI_BG,15);
    END;
    IF ANSI_R THEN BEGIN
      X := ANSI_FG;
      ANSI_FG := ANSI_BG;
      ANSI_BG := X;
    END;
    ANSI_C := FALSE;
  END;
  CASE Ch OF
    ^G : BEGIN
           SOUND(2000);
           DELAY(100);
           NOSOUND;
         END;
    ^H : Backspace;
    ^I : Tabulate;
    ^J : BEGIN {#10}
          {Where_X := 1;
           IF Where_Y <= (RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;}
         END;
    ^K : BEGIN
           Goto_XY(1,1);
         END;
    ^L : Clr_Scr;
    ^M : BEGIN {#13}
           Where_X := 1;
           IF Where_Y <= (TvPort.RowLimit-1) THEN INC(Where_Y) ELSE ScrollScreen;
         END;
    ELSE _Write(Ch);
  END;
END;

PROCEDURE ANSIWrite(S : STRING);
VAR
  X : INTEGER;
BEGIN
  IF (POS('[255D',S) > 0) THEN EXIT;
  FOR X := 1 TO LENGTH(S) DO TTY(S[X]);
END;

FUNCTION Param(Ch : CHAR) : INTEGER;
VAR
  S    : STRING;
  X,XX : INTEGER;
  B    : BOOLEAN;
BEGIN
  B := FALSE;
  FOR X := 3 TO LENGTH(ANSI_St) DO IF ANSI_St[X] IN ['0'..'9'] THEN B := TRUE;
  IF NOT B THEN Param := - 1
  ELSE BEGIN
    S := '';
    X := 3;
    IF ANSI_St[3] = ';' THEN BEGIN
      Param := 0;
      DELETE(ANSI_St,3,1);
      EXIT;
    END;
    REPEAT
      S := S + ANSI_St[X];
      X := X + 1;
    UNTIL (NOT (ANSI_St[X] IN ['0'..'9'])) OR (LENGTH(S) > 2) OR (X > LENGTH(ANSI_St));
    IF LENGTH(S) > 2 THEN BEGIN
      ANSIWrite(ANSI_St + Ch);
      ANSI_St := '';
      Param := - 1;
      EXIT;
    END;
    DELETE(ANSI_St,3,LENGTH(S));
    IF ANSI_St[3] = ';' THEN DELETE(ANSI_St,3,1);
    VAL(S,X,XX);
    Param := X;
  END;
END;

PROCEDURE Display_ANSI(Ch : CHAR);
BEGIN
  IF NOT TvPort.Active THEN EXIT;
  IF HandleMouse THEN HideMouse;
  IF (Ch <> #27) AND (ANSI_St = '') THEN BEGIN
    TTY(Ch);
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF Ch = #27 THEN BEGIN
    IF ANSI_St <> '' THEN BEGIN
      ANSIWrite(ANSI_St + #27);
      ANSI_St := '';
    END ELSE ANSI_St := #27;
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF ANSI_St = #27 THEN BEGIN
    IF Ch = '[' THEN ANSI_St := #27 + '[' ELSE BEGIN
      ANSIWrite(ANSI_St + Ch);
      ANSI_St := '';
    END;
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF (Ch = '[') AND (ANSI_St <> '') THEN BEGIN
    ANSIWrite(ANSI_St + '[');
    ANSI_St := '';
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF NOT (Ch IN ['0'..'9',';','A'..'D','f','H','J','K','m','s','u']) THEN BEGIN
    ANSIWrite(ANSI_St + Ch);
    ANSI_St := '';
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF Ch IN ['A'..'D','f','H','J','K','m','s','u'] THEN BEGIN
    CASE Ch OF
    'A' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_Y - P < 1 THEN Goto_XY(Where_X,1) ELSE Goto_XY(Where_X,Where_Y - P);
          END;
    'B' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_Y + P > TvPort.RowLimit THEN Goto_XY(Where_X,TvPort.RowLimit) ELSE Goto_XY(Where_X,Where_Y + P);
          END;
    'C' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_X + P > TvPort.ColLimit THEN Goto_XY(TvPort.ColLimit,Where_Y) ELSE Goto_XY(Where_X + P,Where_Y);
          END;
    'D' : BEGIN
            P := Param(Ch);
            IF P = - 1 THEN P := 1;
            IF Where_X - P < 1 THEN Goto_XY(1,Where_Y) ELSE Goto_XY(Where_X - P,Where_Y);
          END;
    'H',
    'f' : BEGIN
            Y := Param(Ch);
            X := Param(Ch);
            IF Y < 1 THEN Y := 1;
            IF X < 1 THEN X := 1;
            IF (X > TvPort.ColLimit) OR (X < 1) OR (Y > TvPort.RowLimit) OR (Y < 1) THEN BEGIN
              ANSI_St := '';
              IF HandleMouse THEN ShowMouse;
              EXIT;
            END;
            Goto_XY(X,Y);
          END;
    'J' : BEGIN
            P := Param(Ch);
            IF P IN [0,1,2] THEN Clr_Scr;
          END;
    'K' : Clr_Eol;
    'm' : BEGIN
            IF ANSI_St = #27 + '[' THEN BEGIN
              ANSI_FG := 7;
              ANSI_BG := 0;
              ANSI_I  := FALSE;
              ANSI_B  := FALSE;
              ANSI_R  := FALSE;
            END;
            REPEAT
              P := Param(Ch);
              CASE P OF
               - 1 : ;
                 0 : BEGIN
                       ANSI_FG := 7;
                       ANSI_BG := 0;
                       ANSI_I  := FALSE;
                       ANSI_R  := FALSE;
                       ANSI_B  := FALSE;
                    END;
                1 : ANSI_I  := TRUE;
                5 : ANSI_B  := TRUE;
                7 : ANSI_R  := TRUE;
               30 : ANSI_FG := 0;
               31 : ANSI_FG := 4;
               32 : ANSI_FG := 2;
               33 : ANSI_FG := 6;
               34 : ANSI_FG := 1;
               35 : ANSI_FG := 5;
               36 : ANSI_FG := 3;
               37 : ANSI_FG := 7;
               40 : ANSI_BG := 0;
               41 : ANSI_BG := 4;
               42 : ANSI_BG := 2;
               43 : ANSI_BG := 6;
               44 : ANSI_BG := 1;
               45 : ANSI_BG := 5;
               46 : ANSI_BG := 3;
               47 : ANSI_BG := 7;
              END;
              IF ((P >= 30) AND (P <= 47)) OR (P = 1) OR (P = 5) OR (P = 7) THEN ANSI_C := TRUE;
            UNTIL P = - 1;
          END;
    's' : BEGIN
            ANSI_SCPL := Where_Y;
            ANSI_SCPC := Where_X;
          END;
    'u' : BEGIN
            IF ANSI_SCPL > - 1 THEN Goto_XY(ANSI_SCPC,ANSI_SCPL);
            ANSI_SCPL := - 1;
            ANSI_SCPC := - 1;
          END;
    END;
    ANSI_St := '';
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
  IF Ch IN ['0'..'9',';'] THEN ANSI_St := ANSI_St + Ch;
  IF LENGTH(ANSI_St) > 50 THEN BEGIN
    ANSIWrite(ANSI_St);
    ANSI_St := '';
    IF HandleMouse THEN ShowMouse;
    EXIT;
  END;
END;

PROCEDURE Display_ANSIstr(S : STRING);
VAR
  Loop : BYTE;
BEGIN
  IF NOT TvPort.Active THEN EXIT;
  FOR Loop := 1 TO LENGTH(S) DO Display_ANSI(S[Loop]);
END;

PROCEDURE PlaceCursor;
BEGIN
  IF Where_X < 80 THEN BEGIN
    IF HandleMouse THEN HideMouse;
    FG_Move(((Where_X*8)+TvPort.StartX)-8,((Where_Y*16)+TvPort.StartY));
    FG_SetColor(15);
    FG_PrintC('_',1);
    IF HandleMouse THEN ShowMouse;
  END;
END;

PROCEDURE EraseCursor;
BEGIN
  IF Where_X < 80 THEN BEGIN
    IF HandleMouse THEN HideMouse;
    FG_Move(((Where_X*8)+TvPort.StartX)-8,((Where_Y*16)+TvPort.StartY));
    FG_SetColor(ANSI_BG);
    FG_PrintC('_',1);
    IF HandleMouse THEN ShowMouse;
  END;
END;

PROCEDURE ResetANSI;
BEGIN
  IF TvPort.Active THEN BEGIN
    FILLCHAR(ChArray^,SIZEOF(ChArray^),0);
    FILLCHAR(FgArray^,SIZEOF(FgArray^),0);
    FILLCHAR(BgArray^,SIZEOF(BgArray^),0);
  END;
  HandleMouse     := FALSE;
  ANSI_St         := '';
  ANSI_SCPL       := - 1;
  ANSI_SCPC       := - 1;
  ANSI_FG         := 7;
  ANSI_BG         := 0;
  ANSI_C          := FALSE;
  ANSI_I          := FALSE;
  ANSI_B          := FALSE;
  ANSI_R          := FALSE;
  Where_X         := 1;
  Where_Y         := 1;
 {TvPort.StartX   := 1;
  TvPort.StartY   := 21;
  TvPort.ColLimit := 80;
  TvPort.RowLimit := 25;}
END;

BEGIN
  ResetANSI;
END.
