{$I DEFINES.INC}
UNIT ARCHUNIT;

INTERFACE

FUNCTION GetArcType(Fn : STRING) : BYTE;

IMPLEMENTATION

USES DOS;

CONST
  Unknown = 0;
  _Zip    = 1;
  _Arj    = 2;
  _Lzh    = 3;
  _Zoo    = 4;
  _Arc    = 5;
  _Pak    = 6;
  _Rar    = 7;

FUNCTION GetArcType(Fn : STRING) : BYTE;
VAR
  ArcFile : FILE;
  C       : ARRAY[1..5] OF CHAR;
  Attr    : WORD;
BEGIN
  GetArcType := Unknown;
  ASSIGN(ArcFile,Fn);
  GETFATTR(ArcFile,Attr);
  IF DOSERROR <> 0 THEN EXIT;
  SETFATTR(ArcFile,Attr AND (anyfile - sysfile - hidden - readonly));
  RESET(ArcFile,1);
  IF (IORESULT = 0) THEN BEGIN
    IF (FILESIZE(ArcFile) >= 5) THEN BEGIN
      BLOCKREAD(ArcFile,C,5);
      IF (C[1] = 'P') AND (C[2] = 'K') AND (C[3] = #3) AND (C[4] = #4) THEN GetArcType := _Zip ELSE
      IF (C[1] = #$60) AND (C[2] = #$EA) THEN GetArcType := _Arj ELSE
      IF (C[4] = 'l') AND (C[5] = 'h') THEN GetArcType := _Lzh ELSE
      IF (C[1] = 'Z') AND (C[2] = 'O') AND (C[3] = 'O') THEN GetArcType := _Zoo ELSE
      IF (C[1] = #$1A) AND (C[2] = #$08) THEN GetArcType := _Arc ELSE
      IF (C[1] = #$1A) AND ((C[2] <= #$0B)) THEN GetArcType := _Pak ELSE
      IF (C[1] = 'R') AND (C[2] = 'a') AND (C[3] = 'r') AND (C[4] = '!') THEN GetArcType := _Rar;
    END;
    CLOSE(ArcFile);
  END;
  SETFATTR(ArcFile,Attr);
END;

END.
