{$I DEFINES.INC}
UNIT APVARS;

INTERFACE

USES ApPort,ApTimer;

TYPE ComPortDefinition = RECORD
     Device            : BYTE;      {1-Uart 2-Fossil 3-DigiBoard}
     Port              : BYTE;      {1 - 8}
     PortAddr          : STRING[4]; {"03F8" for COM1 - Leave as "0" for standard}
     IRQ               : BYTE;      {Port IRQ: 4 for COM1 - Set To 0 for standard}
     Baud              : LONGINT;   {Locked port speed}
     Command_Delay     : WORD;      {Milliseconds between modem commands}
     In_Buffer         : WORD;      {Modem input buffer size in bytes.}
     Out_Buffer        : WORD;      {Modem output buffer size in bytes.}
     HwFlow            : BOOLEAN;   {Use hardware flow control? [Y/N] }
     UsingBNU          : BOOLEAN;   {Use BNU Fossil routines? [Y/N]}
     END;

TYPE Modem_Commands    = RECORD
     Init1             : STRING[40];
     Init2             : STRING[40];
     Init3             : STRING[40];
     Answer            : STRING[10];
     OnHook            : STRING[10];
     OffHook           : STRING[10];
     Dial              : STRING[10];
     END;

TYPE File_Header       = RECORD
     FileName          : STRING[12];
     FileSize          : LONGINT;
     FileCrc           : STRING[8];
     END;

CONST
  ProtoDelay      = 550;
  RetryDelay      = 550;

VAR
  BBSPort         : PortRecPtr;
  ModemResult     : STRING;
  CommDef         : ComPortDefinition;
  Modem           : Modem_Commands;
  Doing_Receive   : BOOLEAN;
  ActualBaud      : LONGINT;
  FileQueue       : ARRAY[1..15] OF STRING[80];
  FilesInQueue    : BYTE;
  CurrentFileNum  : WORD;
  WeAbort         : BOOLEAN;
  AbortedProtocol : BOOLEAN;

 {MaxModem Specific Variables}
  Header          : File_Header;
  AckTimer        : EventTimer;
  Buffer          : ARRAY[1..1024] OF BYTE;
  Cancelled       : BOOLEAN;
  TotalSent       : LONGINT;
  FileErrors      : LONGINT;
  TotalErrors     : LONGINT;
  WorkPath        : STRING;

IMPLEMENTATION

BEGIN
  ModemResult := '';
  WITH CommDef DO BEGIN
    Device        := 1;
    Port          := 1;
    PortAddr      := '0';
    IRQ           := 0;
    Baud          := 38400;
    Command_Delay := 500;
    In_Buffer     := 4096;
    Out_Buffer    := 4096;
    HwFlow        := TRUE;
    UsingBNU      := FALSE;
  END;
  WITH Modem DO BEGIN
    Init1   := 'AT&F&C1&D2H0W2S95=2';
    Init2   := '';
    Init3   := '';
    Answer  := 'ATA';
    OnHook  := 'ATH0';
    OffHook := 'ATH1';
    Dial    := 'ATDT';
  END;
END.
