/*      File: RG1004.H
        Author: Chris Bowlby
        Date: March 22, 1995
        Revision Date: NONE
        Notes: - This is a conversion of the pascal records that COTT LANG
                 has released. For Version 10-04, 10-05.
               - All names and variables, save two have remained the same
                 from their Pascal counter parts. these two variables have
                 been precceded by an "n".
*/

#ifndef RENEGADE_H
#define RENEGADE_H
#define VER             "10-04 Exp"
#define MAXPROTOCOLS    120
#define MAXEVENTS       10
#define MAXARCS         8
#define MAXBATCHFILES   50
#define MAXMENUCMDS     100
#define MAXRESULTCODES  18

typedef unsigned char astr[161];
typedef unsigned char str8[9];
typedef unsigned char ACString[21];     /* Access Condition String.        */
typedef unsigned char acrq[4];          /* Access Restriction Flags.       */

typedef struct {
    unsigned int rlogon         :1;     /* L - Limited To One Call A Day.  */
    unsigned int rchat          :1;     /* C - No Sysop Paging.            */
    unsigned int rvalidate      :1;     /* V - Posts Are Unvalidated.      */
    unsigned int ruserlist      :1;     /* U - Can't List Users.           */
    unsigned int ramsg          :1;     /* A - Can't Post An Auto Message. */
    unsigned int rpostan        :1;     /* * - Can't Post Anonymously.     */
    unsigned int rpost          :1;     /* P - Can't Post.                 */
    unsigned int remail         :1;     /* E - Can't Send Email.           */
    unsigned int rvoting        :1;     /* K - Can't Use Voting Booth.     */
    unsigned int rmsg           :1;     /* M - Force Email Deletion.       */
    unsigned int vt100          :1;     /* Supports VT100.                 */
    unsigned int hotkey         :1;     /* Hotkey Input Mode.              */
    unsigned int avatar         :1;     /* Supports Avatar.                */
    unsigned int pause          :1;     /* Screen Pausing.                 */
    unsigned int novice         :1;     /* User Requires Novice Help.      */
    unsigned int ansi           :1;     /* Supports Ansi.                  */
    unsigned int color          :1;     /* Supports Color.                 */
    unsigned int alert          :1;     /* Alert Sysop Upon Logon.         */
    unsigned int smw            :1;     /* Short Message(s) Waiting.       */
    unsigned int nomail         :1;     /* Mailbox Is Closed.              */
    unsigned int fnodlratio     :1;     /* 1 - No UL/DL Ratio.             */
    unsigned int fnopostratio   :1;     /* 2 - No Post/Call Ratio.         */
    unsigned int fnocredits     :1;     /* 3 - No Credits Checking.        */
    unsigned int fnodeletion    :1;     /* 4 - Protected From Deletion.    */
} uflags;

typedef struct {
    unsigned int lockedout      :1;     /* If Locked Out.                  */
    unsigned int deleted        :1;     /* If Deleted.                     */
    unsigned int trapactivity   :1;     /* If Trapping Users Activity.     */
    unsigned int trapseparate   :1;     /* If Trap To Separate TRAP File.  */
    unsigned int chatauto       :1;     /* If Auto Chat trapping.          */
    unsigned int chatseparate   :1;     /* If To Trap To Sparate CHAT File.*/
    unsigned int slogseparate   :1;     /* If Separate Sysop Log.          */
    unsigned int clsmsg         :1;     /* If Clear Screens.               */
    unsigned int RIP            :1;     /* If RIP Graphics Can be Used.    */
    unsigned int fseditor       :1;     /* If Full Screen Editor.          */
    unsigned int AutoDetect     :1;     /* Use Auto-Detect Emulation.      */
} suflags;

typedef struct {
    unsigned int atno           :1;     /* Anonymous Posts Not Allowed.    */
    unsigned int atyes          :1;     /* Anonymous Posts Are Allowed.    */
    unsigned int atforced       :1;     /* Force Anonymous.                */
    unsigned int atdearabby     :1;     /* "Dear Abby" Base.               */
    unsigned int atanyname      :1;     /* Post Under Any Name.            */
} anontyp;

typedef struct {
    unsigned int Private                :1;
    unsigned int Crash                  :1;
    unsigned int Recd                   :1;
    unsigned int NSent                  :1;
    unsigned int FileAttach             :1;
    unsigned int Intransit              :1;
    unsigned int Orphan                 :1;
    unsigned int KillSent               :1;
    unsigned int Local                  :1;
    unsigned int Hold                   :1;
    unsigned int Unused                 :1;
    unsigned int FileRequest            :1;
    unsigned int ReturnReceiptRequest   :1;
    unsigned int IsReturnReceipt        :1;
    unsigned int AuditRequest           :1;
    unsigned int FileUpdateRequest      :1;
} netattr;

typedef netattr NetAttribs;
typedef unsigned char colors[2][10];    /* Color Tables.                   */
typedef signed short int secrange[255]; /* Access Tables.                  */
typedef unsigned char mzscanr[32];      /* Which Message Bases To Scan.    */
typedef unsigned char fzscanr[32];      /* Which File Bases To Scan.       */
typedef long int mhireadr[250];         /* Lastread pointers.              */

                        /* USERS.IDX  -  Sorted Names Listing. */
typedef struct {
    unsigned char Name[37];             /* The Users Name.                 */
    unsigned int Number;                /* The Users Number.               */
    unsigned int Left;                  /* Left Node.                      */
    unsigned int Right;                 /* Right Node.                     */
    unsigned char RealName;             /* User's Real Name?               */
    unsigned char Deleted;              /* Deleted Or Not.                 */
} useridxrec;

                        /* USERS.DAT  -  User Records.         */
typedef struct {
    unsigned char name[37];             /* System Name.                    */
    unsigned char realname[37];         /* Real Name.                      */
    unsigned char pw[21];               /* Password.                       */
    unsigned char ph[13];               /* Phone Number.                   */
    unsigned char bday[9];              /* Birthdate.                      */
    unsigned char firston[9];           /* First On Date.                  */
    unsigned char laston[9];            /* Last On Date.                   */
    unsigned char street[31];           /* Street Address.                 */
    unsigned char citystate[31];        /* City, State.                    */
    unsigned char zipcode[11];          /* Zip Code.                       */
    unsigned char usrdefstr[3][36];     /* Defineable Strings.             */
    unsigned char note[36];             /* Sysop Note.                     */
    unsigned char userstartmenu[9];     /* Menu To Start At.               */
    unsigned char lockedfile[9];        /* Print Lockout Message.          */
    uflags flags;                       /* Flags.                          */
    suflags sflags;                     /* Status Flags.                   */
    acrq ar;                            /* AR Flags.                       */
    unsigned char vote[25];             /* Voting Data.                    */
    unsigned char sex;                  /* Gender.                         */
    long int ttimeon;                   /* Total Time On.                  */
    long int uk;                        /* UL K.                           */
    long int dk;                        /* DL K.                           */
    int tltoday;                        /* # Min Left Today.               */
    int forusr;                         /* Forward Mail To.                */
    int junkfp;                         /* "Junk".                         */
    unsigned int uploads;               /* Number Of Uploads.              */
    unsigned int downloads;             /* Number Of Downloads.            */
    unsigned int loggedon;              /* Number Of Times Logged On.      */
    unsigned int msgpost;               /* Number Of Message Posts.        */
    unsigned int emailsent;             /* Number Of Email Posts.          */
    unsigned int feedback;              /* Number Of Feedback Posts.       */
    unsigned int timebank;              /* Number Of Min in Bank.          */
    unsigned int timebankadd;           /* Number Of Min Added Today.      */
    unsigned int dlktoday;              /* Number Of Kbytes Dl Today.      */
    unsigned int dltoday;               /* Number Of Dl Today.             */
    unsigned char waiting;              /* Mail Waiting.                   */
    unsigned char linelen;              /* Line Length.                    */
    unsigned char pagelen;              /* Page Length.                    */
    unsigned char ontoday;              /* Number Of Times On Today.       */
    unsigned char illegal;              /* Number Of Illegal Logons.       */
    unsigned char barf;
    unsigned char lastmbase;            /* Number Of Last Message Base.    */
    unsigned char lastfbase;            /* Number Of Last File Base.       */
    unsigned char sl;                   /* Security Level.                 */
    unsigned char dsl;                  /* Download Security Level.        */
    mhireadr mhiread;                   /* Message Last Read Pointer.      */
    mzscanr mzscan;                     /* Which Message Bases To Scan.    */
    fzscanr fzscan;                     /* Which File Bases To Scan.       */
    colors cols;                        /* Use Colors.                     */
    unsigned char garbage;              /* Garbage.                        */
    unsigned int timebankwith;          /* Amount Of Time Withdrawn Today. */
    unsigned int passwordchanged;       /* Last Day Password Changed.      */
    unsigned char defarctype;           /* Default QWK Archive Type.       */
    char lastconf;                      /* Last Conference They Were In.   */
    long int lastqwk;                   /* Date/Time Of Last QWK Packet.   */
    unsigned char getownqwk;            /* Add Own Messages To QWK Packet? */
    unsigned char scanfilesqwk;         /* Scan File Bases For QWK Packet? */
    unsigned char privateqwk;           /* Get Private Mail In QWK Packet? */
    long int credit;                    /* Amount Of Credit A User Has.    */
    long int debit;                     /* Amount Of Debit A User Has.     */
    long int expiration;                /* Expiration Date Of This User.   */
    char expireto;                      /* Subscription Level To Expire To.*/
    unsigned char ColorScheme;          /* User's Color Scheme Number.     */
    unsigned char TeleConfEcho;         /* Echo Teleconf Lines?            */
    unsigned char TeleConfInt;          /* Interupt During Typing?         */
} userrec;

typedef struct {
    unsigned int mdeleted       :1;
    unsigned int sent           :1;
    unsigned int unvalidated    :1;
    unsigned int permanent      :1;
    unsigned int allowmci       :1;
    unsigned int netmail        :1;
    unsigned int prvt           :1;
    unsigned int forwarded      :1;
} msgstatusr;

typedef struct {
    unsigned char NewScan;              /* New Scan This Base?             */
    long int Lastread;                  /* Last Message Date Read.         */
} mhireadrec;

                        /* From/To Information For mheaderrec.  */
typedef struct {
    unsigned char anon;
    unsigned int usernum;               /* User Number.                    */
    unsigned char as[37];               /* Posted As.                      */
    unsigned char real[37];             /* Real Name.                      */
    unsigned char name[37];             /* System Name.                    */
    unsigned int zone;
    unsigned int net;
    unsigned int node;
    unsigned int point;
} fromtoinfo;

typedef struct {
    fromtoinfo from;                    /* Message From Info.              */
    fromtoinfo mto;                     /* Message To Info.                */
    long int pointer;                   /* Starting Info Of Text.          */
    unsigned int textsize;              /* Size Of Text.                   */
    unsigned int replyto;               /* ORIGINAL + REPLYTO = CURRENT.   */
    long int date;                      /* Date/Time Packed String.        */
    unsigned char dayofweek;            /* Message Day Of Week.            */
    msgstatusr status;                  /* Message Status Flags.           */
    unsigned int replies;               /* Times Replied To.               */
    unsigned char subject[41];          /* Subject Of Message.             */
    unsigned char origindate[20];       /* Date Of Echo/Group Messages.    */
    unsigned char fileattached;         /* 0=No, 1=Yes&Del, 2 = Yes&Save.  */
    NetAttribs netattribute;            /* Netmail Attributes.             */
    unsigned char res[2];               /* Reserved.                       */
} mheaderrec;

                        /* HISTORY.DAT  -  Summary Logs.        */
typedef struct {
    unsigned char date[9];
    unsigned int userbaud[5];
    unsigned int active;
    unsigned int callers;
    unsigned int newusers;
    unsigned int posts;
    unsigned int email;
    unsigned int feedback;
    unsigned int errors;
    unsigned int uploads;
    unsigned int downloads;
    long int uk;
    long int dk;
} historyrec;

                        /* Archive Configuration Records.       */
typedef struct {
    unsigned char active;               /* Active Or Not.                  */
    unsigned char ext[4];               /* File Extension.                 */
    unsigned char listline[26];         /* 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH. */
    unsigned char arcline[26];          /* Compression Command line.       */
    unsigned char unarcline[26];        /* De-Compression Command Line.    */
    unsigned char testline[26];         /* Integrety Test Line.            */
    unsigned char cmtline[26];          /* Comment Command Line.           */
    int succlevel;                      /* Succesas Errorlevel, -1 Ignore. */
} filearcinforec;

                        /* STRING.DAT                           */
typedef struct {
    unsigned char anonymous[81];        /* "[Anonymous]" String.           */
    unsigned char note[2][81];          /* Logon Notes (L #1-2).           */
    unsigned char lprompt[81];          /* Logon Prompt(L #3).             */
    char echoc;                         /* Echo Char For PW's.             */
    unsigned char yourpassword[81];     /* "Your Password".                */
    unsigned char yourphonenumber[81];  /* "Your Phone Number".            */
    unsigned char engage[81];           /* "Engage Chat".                  */
    unsigned char endchat[81];          /* "End Chat".                     */
    unsigned char wait[81];             /* "Sysop Working".                */
    unsigned char pause[81];            /* "Pause".                        */
    unsigned char entermsg1[81];        /* "Enter Message" Line #1.        */
    unsigned char entermsg2[81];        /* "Enter Message" Line #2.        */
    unsigned char newscan1[81];         /* "Newscan Begin".                */
    unsigned char newscan2[81];         /* "Newscan Done".                 */
    unsigned char scanmessage[81];      /* Message Scanning prompt.        */
    unsigned char automsgt[81];         /* Auto-Message Title.             */
    char autom;                         /* Auto-Message Border Characters. */
    unsigned char shelldos1[81];        /* ">> Sysop Shelling To DOS ...". */
    unsigned char shelldos2[81];        /* "... Thank You For Waiting.".   */
    unsigned char chatcall1[81];        /* "Paging Sysop, Please Wait...". */
    unsigned char chatcall2[81];        /* ">>><*><<<".                    */
    unsigned char shuttleprompt[81];    /* "Enter Your Name Od Number.".   */
    unsigned char namenotfound[81];     /* "Name Not Found In User List.". */
    unsigned char bulletinline[81];     /* Bulletin Line.                  */
    unsigned char protocolp[81];        /* "Protocol (?=List) :".          */
    unsigned char listline[81];         /* "List Files - P To Pause".      */
    unsigned char newline[81];          /* "Search For New Files -".       */
    unsigned char searchline[81];       /* "Search All Dirs For File Mask".*/
    unsigned char findline1[81];        /* "Search For Descriptions...".   */
    unsigned char findline2[81];        /* "Enter String To Search For.".  */
    unsigned char downloadline[81];     /* "Download - ".                  */
    unsigned char uploadline[81];       /* "Upload - ".                    */
    unsigned char viewline[81];         /* "View Interior Files - ".       */
    unsigned char nofilecredits[81];    /* "Insufficient File Credits.".   */
    unsigned char unbalance[81];        /* "Your UL/DL Ratio Is Unbalanced"*/
    unsigned char pninfo[81];           /* "P To Pause, N For Next Dir.".  */
    unsigned char gfnline1[81];         /* "[Enter]=All Files.".           */
    unsigned char gfnline2[81];         /* "File Mask: ".                  */
    unsigned char batchadd[81];         /* "File Added To Batch Queue.".   */
    unsigned char addbatch[81];         /* "Batch Download Flagging - ".   */
    unsigned char readq[81];            /* "Begin Reading At [1-54]".      */
    unsigned char scanq[81];            /* "Begin Scanning At [1-54]".     */
    unsigned char ndefault[81];         /* "Press [Enter] To Use Defaults".*/
    unsigned char newscanall[81];       /* ")[ Newscan All ](".            */ 
    unsigned char newscandone[81];      /* ")[ Newscan Done ](".           */
    unsigned char chatreason[81];       /* "Give Me A Good Reason To Chat".*/
    unsigned char quote_line[2][81];    /* Quoting So And So To So And So. */
    unsigned char userdefques[3][81];   /* User Defined Question 1-3.      */
    unsigned char userdefed[3][11];     /* User Def'd q, User Editor String*/
    unsigned char ncontinue[81];        /* "Continue?".                    */
} fstringrec;

                        /* MODEM.DAT  -  Status Flags.        */
typedef struct {
    unsigned int lockedport;            /* COM Port Locked At Constant Rate*/
    unsigned int xonxoff;               /* XON/XOFF (Software) Flow Control*/
    unsigned int ctsrts;                /* CTS/RTS (Hardware) Flow Control */
    unsigned int DigiBoard;             /* This Line Uses A Digiboard.     */
} ModemFlags;

typedef struct {
    long int InitBaud;                  /* Initialization Baud.            */
    unsigned char ComPort;              /* COM Port Number.                */
    ModemFlags MFlags;                  /* Status Flags.                   */
    unsigned char Init[31];             /* Init String.                    */
    unsigned char Answer[31];           /* Answer String Or Blank.         */
    unsigned char Hangup[31];           /* Hangup String.                  */
    unsigned char OffHook[31];          /* Phone Off-Hook String.          */
    unsigned char DoorPath[41];         /* Door Drop Files Written To.     */
    unsigned char TeleConfNormal[41];
    unsigned char TeleConfAnon[41];     /* Teleconferencing Strings.       */
    unsigned char TeleConfGlobal[41];
    unsigned char TeleConfPrivate[41];
    unsigned char OK[21];
    unsigned char RING[21];
    unsigned char RELIABLE[21];
    unsigned char CALLERID[21];
    unsigned char NOCARRIER[21];
    unsigned char CONNECT[22][21];      /* Connection Baud Rates.          */
    unsigned char UseCallerID;          /* Insert Caller ID Into Sysop Note*/
    ACString LogonACS;                  /* ACS String To Logon This Node.  */
    unsigned char IRQ[11];
    unsigned char Address[11];          /* Used Only For Function MCI Codes*/
    unsigned char AnserOnRing;          /* Answer On How MAny Rings?       */
    unsigned char MultiRing;            /* Answer Multi-Ring System Only.  */
} linerec;

typedef struct {
    unsigned char description[26];      /* Description.                    */
    unsigned char newsl;                /* New SL.                         */
    unsigned char newdsl;               /* New DSL.                        */
    acrq newar;                         /* New AR.                         */
    uflags newac;                       /* New AC.                         */
    int newfp;                          /* Nothing.                        */
    long int newcredit;                 /* New Credit (Added).             */
    unsigned int expiration;            /* Day's Until Expiration.         */
    char expireto;                      /* Validation Level To Expire To.  */
    unsigned char softar;               /* TRUE = AR ADDED, Else Replaces. */
    unsigned char softac;               /* TRUE = AC ADDED, Else Replaces. */
    unsigned char newmenu[9];           /* User Startout Menu.             */
} validationrec;

typedef struct {
    unsigned char datapath[41];         /* DATA Path.                      */
    unsigned char miscpath[41];         /* MISC Path.                      */
    unsigned char menupath[41];         /* MENU Path.                      */
    unsigned char logspath[41];         /* LOGS Path.                      */
    unsigned char msgpath[41];          /* MSGS Path.                      */
    unsigned char nodepath[41];         /* NODE List Path.                 */
    unsigned char temppath[41];         /* TEMP Path.                      */
    unsigned char protpath[41];         /* PROT Path.                      */
    unsigned char arcspath[41];         /* ARCS Path.                      */
    unsigned char bbsname[41];          /* BBS Name.                       */
    unsigned char bbsphone[13];         /* BBS Phone Number.               */
    unsigned char sysopname[30];        /* Sysop's Name.                   */
    int lowtime;                        /* Sysop Begin Minute (Minutes).   */
    int hitime;                         /* Sysop End Time.                 */
    int dllowtime;                      /* Normal DL Hours Begin.          */
    int dlhitime;                       /* Normal Dl Hours End.            */
    int minbaudlowtime;                 /* Minimum Baud Hours Begin.       */
    int minbaudhitime;                  /* Minimum Baud Hours End.         */
    int minbauddllowtime;               /* Minimum Baud DL Hours Begin.    */
    int minbauddlhitime;                /* Minimum Baud DL Hours End.      */
    long int minimumbaud;               /* Minimum Baud Rate To Logon.     */
    long int minimumdlbaud;             /* Minimum Baud Rate To DL.        */
    unsigned char shuttlelog;           /* Use Shuttle Logon?              */
    unsigned char closedsystem;         /* Allow New Users?                */
    unsigned char swapshell;            /* Swap On Shell?                  */
    ACString sysoppw;                   /* Sysop Password.                 */
    ACString newuserpw;                 /* New User Password.              */
    ACString minbaudoverride;           /* Override Minimum Baud Rate.     */
    ACString qwknetworkACS;             /* QWK Network REP ACS.            */
    unsigned char crapola2[9];
    ACString sop;                       /* Sysop.                          */
    ACString csop;                      /* Co-Sysop.                       */
    ACString msop;                      /* Message Sysop.                  */
    ACString fsop;                      /* File Sysop.                     */
    ACString spw;                       /* Sysop Password At Logon.        */
    ACString seepw;                     /* See Sysop PW's Remotely.        */
    ACString normpubpost;               /* Make Normal Public Posts.       */
    ACString normprivpost;              /* Make Normal E-Mail.             */
    ACString anonpubread;               /* See Who Posted Public Anon.     */
    ACString anonprivread;              /* See Who Sent Anon E-Mail.       */
    ACString anonpubpost;               /* Make Anon Posts.                */
    ACString anonprivpost;              /* Send Anon E-Mail.               */
    ACString seeunval;                  /* See Unvalidated Files.          */
    ACString dlunval;                   /* DL Unvalidated Files.           */
    ACString nodlratio;                 /* No DL/UL Ratio.                 */
    ACString nopostratio;               /* No Post/Call Ratio.             */
    ACString nofilecredits;             /* No File Credits Checking.       */
    ACString ulvalreq;                  /* Uploads Require Validation.     */
    ACString TeleConfMCI;               /* Access For MCI Codes In TeleChat*/
    unsigned char maxprivpost;          /* Max Email Sent Per Call.        */
    unsigned char maxfback;             /* Max Feedback Per Call.          */
    unsigned char maxpubpost;           /* Max Posts Per Call.             */
    unsigned char maxchat;              /* Max Sysop Pages Per Call.       */
    unsigned char maxwaiting;           /* Max Mail Waiting.               */
    unsigned char csmaxwaiting;         /* Max Mail Waiting For Co-Sysop.  */
    unsigned char junk1;           
    unsigned char junk2;
    unsigned char maxlogontries;        /* Tries Allowed For PW's At Logon.*/
    unsigned char sysopcolor;           /* Sysop Color In Chat Mode.       */
    unsigned char usercolor;            /* User Color In Chat Mode.        */
    int minspaceforpost;                /* Minimum Drive Space For Posts.  */
    int minspaceforupload;              /* Minimum Drive Space For Uploads.*/
    unsigned char backsysoplogs;        /* Day's To Keep SYSOP##.LOG.      */
    unsigned char eventwarningtime;     /* Minutes To Event To Warn User.  */
    unsigned char wfcblanktime;         /* Minutes Before Blanking WFC Menu*/
    unsigned char allowalias;           /* Allow Handles?                  */
    unsigned char phonepw;              /* Phone Number PW In Logon?       */
    unsigned char localsec;             /* Use Local Security?             */
    unsigned char globaltrap;           /* Trap Everyones Activity?        */
    unsigned char autochatopen;         /* Automatically Open Chat Buffer? */
    unsigned char autominlogon;         /* Auto-Message At Logon?          */
    unsigned char bullinlogon;          /* Bulletins At Logon?             */
    unsigned char lcallinlogon;         /* Last Few Callers At Logon?      */
    unsigned char yourinfoinlogon;      /* Your Info At Logon?             */
    unsigned char offhooklocallogon;    /* Phone Off-Hook For Local Logons?*/
    unsigned char forcevoting;          /* Manditory Voting?               */
    unsigned char compressbases;        /* Compress File/msg Base Numbers? */
    unsigned char searchdup;            /* Search For Dupes When UL?       */
    unsigned char slogtype;             /* Log Type File/Printer/Both      */
    unsigned char stripclog;            /* Strip Colors From Sysop Log?    */
    int newapp;                         /* Send New User Application To #. */
    int timeoutbell;                    /* Minutes Before Timeout Beep.    */
    int timeout;                        /* Minutes Before Timeout.         */
    unsigned char useems;               /* Use EMS For Overlay.            */
    unsigned char usebios;              /* Use BIOS For Video Output.      */
    unsigned char useiemsi;             /* Use IEMSI.                      */
    int alertbeep;                      /* Time Between Alert Beeps.       */
    filearcinforec filearcinfo[MAXARCS];/* Archive Specs.                  */
    unsigned char filearccomment[3][41];/* BBS Comment Files For Archives. */
    unsigned char udldratio;            /* Use UL/DL Ratio's.              */
    unsigned char filecreditratio;      /* Use auto File Credit Comp.      */
    unsigned char filecreditcomp;       /* File Credit Comp. Ratio.        */
    unsigned char filecreditcompbasesize;/* File Credit Base Comp. Size.   */
    unsigned char ulrefund;             /* % Of Time To Refund On UL's.    */
    unsigned char tosysopdir;           /* Sysop File Base.                */
    unsigned char validateallfiles;     /* Validate Files Automatically?   */
    int maxintemp;                      /* Max K Allowed In Temp.          */
    int minresume;                      /* Min K To Allow Resume-Later     */
    unsigned char filediz;              /* Search/Import File_id.diz?      */
    unsigned int maxqwktotal;           /* Max Msgs In A Packet.           */
    unsigned int maxqwkbase;            /* Max Msgs In A Base.             */
    int CreditMinute;                   /* Credits per Minute.             */
    int CreditPost;                     /* Credits Per Post.               */
    int CreditEmail;                    /* Credits Per Email Sent.         */
    unsigned char sysoppword;           /* Check For Sysop PW?             */
    int CreditFreeTime;                 /* Amount Of Free Time At Logon    */
    unsigned char TrapTeleConf;         /* Trap TeleChat To ROOMx.TRP?     */
    unsigned char RES98[6];
    unsigned char allstartmenu[9];      /* Logon Menu To Start Users On.   */
    unsigned char bulletprefix[9];      /* Default Bulletins Filename.     */
    secrange timeallow;                 /* Time Allowance.                 */
    secrange callallow;                 /* Call Allowance.                 */
    secrange dlratio;                   /* # UL's/# DL's Ratios.           */
    secrange dlkratio;                  /* DL k/UL k Ratios.               */
    secrange postratio;                 /* Posts Per Call Ratio.           */
    secrange dloneday;                  /* Max Number Of Dload Files/Day.  */
    secrange dlkoneday;                 /* Max k Downloaded/Day.           */
    unsigned char lastdate[9];          /* Last System Date.               */
    unsigned char curwindow;            /* Type Of Sysop Window In Use.    */
    unsigned char istopwindow;          /* Is Window At Top Of Screen?     */
    long int callernum;                 /* System Caller Number.           */
    int numusers;                       /* Number Of Users.                */
    unsigned char multpath[41];         /* MULT Path.                      */
    unsigned char junkola[3];           /* Not Used.                       */
    unsigned char recompress;           /* Recompress Like Archives?       */
    unsigned char rewardsystem;         /* Use File Rewarding System.      */
    unsigned int passwordchange;        /* Change PW At Least Every x Days.*/
    unsigned char netmailpath[41];      /* Path To Netmail.                */
    ACString netmailACS;                /* Do They Have Access To Netmail? */
    int rewardratio;                    /* % Of File Points To Reward Back */
    unsigned char birthdatecheck;       /* Check User's Bday Every x Logons*/
    ACString Invisible;                 /* Invisible Mode?                 */
    unsigned char fileattachpath[41];   /* Dir For File Attaches.          */
    ACString fileattachACS;             /* ACS To Attach Files To Messages.*/
    ACString changevote;                /* ACS To Change Their Vote.       */
    unsigned char trapgroup;            /* Record Group Chats?             */
    unsigned char qwktimeignore;        /* Ignore Time For QWK Dl's?       */
    unsigned char networkmode;          /* Network Mode?                   */
    unsigned char SwapTo;               /* Swap Where?                     */
    unsigned char res[23];              
    unsigned char windowon;             /* Is The Sysop Window On?         */
    long int regnumber;                 /* Registration Number.            */
    unsigned char chatcall;             /* Whether System Beeps After Chat */
    unsigned char packetname[9];        /* QWK Packet Name.                */
    unsigned char qwkwelcome[51];       /* QWK Welcome File Name.          */
    unsigned char qwknews[51];          /* QWK News File Name.             */
    unsigned char qwkgoodbye[51];       /* QWK Goodbye File Name.          */
    unsigned char qwklocalpath[41];     /* QWK Path For Local Useage.      */
    unsigned char dailylimits;          /* Daily File Limits On/Off.       */
    unsigned char multinode;            /* Enable Multinode Support.       */
    unsigned int daysonline;            /* Day's Online.                   */
    long int totalcalls;                /* Incase Different From Callernum.*/
    long int totalusage;                /* Total Usage In Minutes.         */
    long int totalposts;                /* Total Number Of Posts.          */
    long int totaldloads;               /* Total Number Of Dloads.         */
    long int totaluloads;               /* Total Number Of Uloads.         */
    unsigned char percall;              /* Time Limits Are per Call or Day.*/
    unsigned char testuploads;          /* Perform Integrety Test On Uloads*/
    unsigned char Origin[51];           /* Default Origin Line.            */
    unsigned char Text_Color;           /* Color Of Standard Text.         */
    unsigned char Quote_Color;          /* Color Of Quoted Text.           */
    unsigned char Tear_Color;           /* Color Of Tear Line.             */
    unsigned char Origin_Color;         /* Color Of Origin Line.           */
    unsigned char SKludge;              /* Show Kludge Lines?              */
    unsigned char SSeenby;              /* Show SEEN-BY Lines?             */
    unsigned char SOrigin;              /* Shoe Origin Line?               */
    unsigned char AddTear;              /* Show Tear Line?                 */
    NetAttribs Netattribute;            /* Default Netmail Attributes.     */
    struct {
        unsigned int zone;              /* 20 Addresses.                   */
        unsigned int net;               /* 21st Is For UUCP Address.       */
        unsigned int node;
        unsigned int point;
    } aka[21];
    unsigned char DefEchoPath[41];      /* Default Echomail Path.          */
    int CreditInternetMail;             /* Cost For InternetMail.          */
    unsigned char crap5[372];
    validationrec validation[26];       /* Validation Records A - Z.       */
    unsigned char macro[10][101];       /* Sysop Macros.                   */
} generalrec;

                        /* SHORTMSG.DAT  -  One-line Messages. */
typedef struct {
    astr msg;
    int destin;
} smr;

                        /* VOTING.DAT  -  Voting Records.      */
typedef struct {
    unsigned char description[66];      /* Voting Question.                */
    ACString ACS;                       /* ACS Required To Vote On This.   */
    unsigned int choicenumber;          /* Number Of Choices.              */
    unsigned int numvoted;              /* Number Of Votes On It.          */
    unsigned char madeby[36];           /* Who Created It.                 */
    struct {
        unsigned char description[66];  /* Answer Description Line #1.     */
        unsigned char description2[66]; /* Answer Description Line #2.     */
        int numvoted;                   /* # Users Who Picked This Answer. */
    } choices[25];
} votingr;

typedef struct {
    unsigned int mbunhidden     :1;     /* Whether Seen By Users W/O ACS.  */
    unsigned int mbrealname     :1;     /* Whether Real Names Are Forced.  */
    unsigned int mbcrap         :1;
    unsigned int mbinternet     :1;     /* If Internet Message Base        */
    unsigned int mbfilter       :1;     /* If To Filter ANSI/8-bit ASCII.  */
    unsigned int mbskludge      :1;     /* Strip INFA Kludge Lines.        */
    unsigned int mbsseenby      :1;     /* Strip SEEN-BY Lines.            */
    unsigned int mbsorigin      :1;     /* Strip Origin Lines.             */
    unsigned int mbprivate      :1;     /* Allow Private Messages.         */
    unsigned int mbforceread    :1;     /* Force The Reading Of this Base. */
    unsigned int mbScanOut      :1;     /* Needs To Be Scanned Out by RMail*/
    unsigned int mbaddtear      :1;     /* Add Tear/Origin Lines.          */
    unsigned int mbtopstar      :1;     /* Whether Top Star For GMail Base */
} mbflags;


                        /* MBASES.DAT  -  Message Base Records.  */
typedef struct {
    unsigned char name[41];             /* Message Base Description.       */
    unsigned char filename[9];          /* HDR/DAT Data Filename.          */
    unsigned char msgpath[41];          /* Messages Pathname.              */
    ACString ACS;                       /* Access Requirement.             */
    ACString postACS;                   /* Post Access Requirement.        */
    ACString mciACS;                    /* MCI Usage Requirment.           */
    ACString sysopACS;                  /* Message Base Sysop Requirement. */
    unsigned int maxmsgs;               /* Max Message Count.              */
    anontyp anonymous;                  /* Anonymous Type.                 */
    unsigned char password;             /* Base Password.                  */
    mbflags mbstat;                     /* Message Base Status Vars.       */
    int mbtype;                         /* 0=Local, 1=Echo, 2=Group.       */
    unsigned char origin[51];           /* Origin Line.                    */
    unsigned char text_color;           /* Color Of Standard Text.         */
    unsigned char quote_color;          /* Color Of Quoted Text.           */
    unsigned char tear_color;           /* Color Of Tear Line.             */
    unsigned char origin_color;         /* Color Of Origin Line.           */
    unsigned char aka;                  /* Alternate Address.              */
    unsigned int QWKIndex;              /* QWK Indexing Number.            */
    unsigned char res[11];              /* Reserved.                       */
} boardrec;

typedef struct {
    unsigned int fbnoratio      :1;     /* If <No Ratio> Active.           */
    unsigned int fbunhidden     :1;     /* Whether Seen By Users W/O ACS.  */
    unsigned int fbdirdlpath    :1;     /* If *.DIR File Stored In DLPATH. */
    unsigned int fbshowname     :1;     /* Show Uploaders In Listings.     */
    unsigned int fbusegifspecs  :1;     /* Whether To Use GIF Specs.       */
    unsigned int fbcdrom        :1;     /* Base Is Read Only.              */
    unsigned int fbshowdate     :1;     /* Show Date Uploaded In Listings. */
} fbflags;

                        /* FBASES.DAT  -  File Base Records.     */
typedef struct {
    unsigned char name[41];             /* Area Description.               */
    unsigned char filename[13];         /* Filename + ".DIR".              */
    unsigned char dlpath[41];           /* Download Path.                  */
    unsigned char ulpath[41];           /* Upload Path.                    */
    unsigned int maxfiles;              /* Max Files Allowed.              */
    unsigned char password[21];         /* Password Required.              */
    unsigned char arctype;              /* Wanted Archive Type. 0=Inactive.*/
    unsigned char cmttype;              /* Wanted Comment Type. 0=Inactive.*/
    int res1;
    fbflags fbstat;                     /* File Base Status Vars.          */
    ACString ACS;                       /* Acces Required.                 */
    ACString ulACS;                     /* Upload Access Requirements.     */
    ACString dlACS;                     /* Download Access Requirements.   */
    unsigned char res[10];              /* Reserved.                       */
} ulfrec;

                        /* EXTENDED.DAT  -  Extended Descriptions. */
typedef struct {
    unsigned char descr[4][51];        
} verbrec;

                        /* LASTON.DAT  -  Last Few Callers Records. */
typedef struct {
    long int callernum;                 /* System Caller Number.           */
    unsigned char name[37];             /* User Name Of Caller.            */
    unsigned int number;                /* User Number Of Caller.          */
    unsigned char citystate[31];        /* City/State Of Caller.           */ 
    unsigned char baud[6];              /* Baud Of Caller.                 */
    unsigned char timeon[9];            /* Time Logged On.                 */
    unsigned int daynum;                /* Day Num Logged On.              */
    unsigned char wasnew;               /* Was It A New User?              */
} lcallers;

                        /* EVENTS.DAT  - Event Records.                    */
typedef struct {
    unsigned char active;               /* Whether Active.                 */
    unsigned char description[31];      /* Event Description.              */
    char etype;                         /* ACS, Chat,Dos,External,Pack,Sort*/
    unsigned char execdata[21];         /* Errorlevel If E, Cmdline if D.  */
    unsigned char softevent;            /* Event Runs Whenever Convenient. */
    unsigned char missed;               /* Run Event Even If Missed.       */
    unsigned char monthly;              /* Monthly Event?                  */
    unsigned char busyduring;           /* Busy Phone During Event?        */
    int exectime;                       /* Time Of Execution.              */
    int durationorlastday;              /* Length Of Time Event Takes.     */
    unsigned char offhooktime;          /* Off-Hook Time Before, 0=NONE.   */
    unsigned char Enode;                /* Node Number To Exe. On, 0=NONE. */
    unsigned char execdays;             /* Bitwise Day's Or Day Of Month.  */
} eventrec;

typedef struct {
    unsigned int clrscrbefore   :1;     /* C: CLS Before Menu Display.     */
    unsigned int dontcenter     :1;     /* D: Don't Center Menu Titles.    */
    unsigned int nomenuprompt   :1;     /* N: No Menu Prompt.              */
    unsigned int forcepause     :1;     /* P: Pause Before Menu Display?   */
    unsigned int autotime       :1;     /* T: Is Time Displayed Auto?      */
    unsigned int forceline      :1;     /* F: Force Full Line Input.       */
    unsigned int NoGenericAnsi  :1;     /* 1: Don't Gen. Generic Prompt.   */
    unsigned int NoGenericAvatar :1;    /* 2: Don't Gen. Generic Prompt.   */
    unsigned int NoGenericRIP   :1;     /* 3: Don't Gen. Generic Prompt.   */
    unsigned int NoGlobalDisplayed :1;  /* 4: Don't Display Global Cmds.   */
    unsigned int NoGlobalUsed   :1;     /* 5: Don't Use Global Commands.   */
} mnuflags;

                        /* *.MNU  - Menu Records.              */
typedef struct {
    unsigned char menuname[3][101];     /* Menu Name.                      */
    unsigned char directive[13];        /* Help File Displayed.            */
    unsigned char longmenu[13];         /* Displayed In Place Of Long Menu.*/
    unsigned char menuprompt[121];      /* Menu Prompt.                    */
    ACString ACS;                       /* Access Requirements.            */
    unsigned char password[16];         /* Password Required.              */
    unsigned char fallback[9];          /* Fallback Menu.                  */
    unsigned char forcehelplevel;       /* Forced Help Level For Menus.    */
    unsigned char gencols;              /* Generic Menus: # Of Colomns.    */
    unsigned char gcol[3];              /* Generic Menus: Colors.          */
    mnuflags menuflags;                 /* Menu Status Variables.          */
} menurec;

typedef struct {
    unsigned int hidden         :1;     /* H: Is Command Always Hidden?    */
    unsigned int unhidden       :1;     /* C: Is Command Always Visible?   */
} cmdflags;

                        /* *.MNU  - Command Records.           */
typedef struct {
    unsigned char ldesc[71];            /* Long Command Description.       */
    unsigned char sdesc[36];            /* Short Command Description.      */
    unsigned char ckeys[15];            /* Command-Execution Keys.         */
    ACString ACS;                       /* Access Requirements.            */
    unsigned char cmdkeys[3];           /* Command Keys: Type Of Command.  */
    unsigned char options[51];          /* MSting: Command Data.           */
    cmdflags commandflags;              /* Command Status Variables.       */
} commandrec;

typedef struct {
    unsigned int xbactive       :1;
    unsigned int xbisbatch      :1;
    unsigned int xbisresume     :1;
    unsigned int xbxferokcode   :1;
    unsigned int xbbidirectional :1;
    unsigned int xbreliable     :1;
} xbflags;

                        /* PROTOCOL.DAT  -  Records.       */
typedef struct {
    xbflags xbstat;                     /* Protocol Flags.                 */
    unsigned char ckeys[15];            /* Command Keys.                   */
    unsigned char descr[41];            /* Description.                    */
    ACString ACS;                       /* Access String.                  */
    unsigned char templog[26];          /* Temp. Log File.                 */
    unsigned char uloadlog[26];         /* Ul Log File.                    */
    unsigned char dloadlog[26];         /* DL Log File.                    */
    unsigned char ulcmd[79];            /* UL Command Line.                */
    unsigned char dlcmd[79];            /* DL Command Line.                */
    unsigned char ulcode[6][7];         /* UL Codes.                       */
    unsigned char dlcode[6][7];         /* DL Codes.                       */
    unsigned char envcmd[61];           /* Environment Setup Command.      */
    unsigned char dlflist[26];          /* Dl File Lists.                  */
    int maxchrs;                        /* Max Chrs In Command Line.       */
    int logpf,logps;                    /* Pos In Log File For Data.       */
    unsigned char res[15];              /* Reserved.                       */
} protrec;

                        /* CONFRENC.DAT  -  Conference data.   */
typedef struct {
    struct {
        ACString ACS;                   /* Access Requirement.             */
        unsigned char name[41];         /* Name Of Conference.             */
    } conference[27];
} confrec;

typedef struct {
    unsigned int NActive        :1;     /* Is This Node Active?            */
    unsigned int NAvail         :1;     /* Is This Node's User Available?  */
    unsigned int NUpdate        :1;     /* Node Should Re-read the user.   */
    unsigned int NHangup        :1;     /* Hangup On This Node.            */
    unsigned int NRecycle       :1;     /* Recycle This Node To The OS.    */
    unsigned int NInvisible     :1;     /* This Node Is Invisible.         */
} nodeflags;

                        /* MULTNODE.DAT                    */
typedef struct {
    unsigned int User;                  /* What User Number.               */
    unsigned char UserName[37];         /* User's Name.                    */
    unsigned char CityState[31];        /* User's Location.                */
    char Sex;                           /* User's Sex.                     */
    unsigned char Age;                  /* User's Age.                     */
    long int LogonTime;                 /* What Time They Logged On.       */
    unsigned char Activity;             /* What Are They Doing?            */
    unsigned char Description[21];      /* Optional String.                */
    nodeflags Status;
    unsigned char Room;                 /* What Room Are They In?          */
    unsigned int Channel;               /* What Channel Are They In?       */
    unsigned char Invited[31][7];       /* Have They Been Invited?         */
    unsigned char Booted[31][7];        /* Have They Been Kicked off?      */
    unsigned char Forget[31][7];        /* Who Are They Forgetting?        */
} noderec;

                        /* ROOM.DAT                       */
typedef struct {
    unsigned char Topic[41];            /* Set By A /T Or Something.       */
    unsigned char Anonymous;            /* Is Room Anonymous?              */
    unsigned char Private;              /* Is Room Private?                */
    unsigned int Moderator;             /* Who Is The Moderator?           */
    unsigned char People;               /* Number Of People In Room.       */
} RoomRec;

                        /* *.SCN Files.                   */
typedef struct {
    unsigned char Newscan;              /* Scan This Base?                 */
    long int LastRead;                  /* Last Date Read.                 */
} scanrec;

                        /* SCHEME.DAT                     */
typedef struct {
    unsigned char Description[31];      /* Description Of The Color Scheme.*/
    unsigned char Color[200];           /* Colors In Scheme.               */
} SchemeRec;

/*      1 - 10 System Colors.
        11 -   File List Colors.
        28 -   Message List Colors.
        45 -   File Area List Colors.
        55 -   Message Area List Colors.
        65 -   User list Colors.
        80 -   Who's Online Colors.
        100 -  Last On Colors.
        115 -  QWK Colors.
        135 -  Email Colors.
*/
