(* Turbo Pascal structures for RemoteAccess 2.00.
  
   This document is (C) Copyright Andrew Milner & Wantree Development, 1993.
   All rights reserved.

*)

type
  AskType        = (Yes, No, Ask, Only);
  VideoType      = (Auto, Short, Long);
  MsgType        = (LocalMail, NetMail, EchoMail);
  MsgKindsType   = (Both, Private, Public, ROnly, NoReply);
  OrphanType     = (Ignore, Create, Kill);
  FlagType       = array[1..4] of Byte;
  Time           = String[5];
  Date           = String[8];
  LongDate       = String[9];
  ByteArray32    = Array[1..32] of Byte;

  NetAddress     = record
                     Zone,
                     Net,
                     Node,
                     Point          : Word;
                   end;

  LIMITSrecord   = record
                     Security,
                     Ltime,
                     L300,
                     L1200,
                     L2400,
                     L4800,
                     L7200,
                     L9600,
                     L12000,
                     L14400,
                     L16800,
                     L19200,
                     L38400,
                     Llocal,
                     RatioNum,
                     RatioK         : Word;
                     PerMinCost     : Real;
                     FreeSpace      : Array[1..42] of Byte;
                   end;

  LANGUAGErecord = record
                     Name           : String[20];
                     Attribute      : Byte;
                     DefName,
                     MenuPath,
                     TextPath,
                     QuesPath       : String[60];
                     Security       : Word;
                     Flags,
                     NotFlagsMask   : FlagType;
                     FreeSpace      : Array[1..190] of Byte;
                   end;

 TagFileRecord  = Record { New in RA 2.02; }
		Name           : String[12];
		Password       : String[15];
		Attrib         : Byte;
		AreaNum,
		RecordNum      : Word;
		Size           : Longint;
		FileDate       : Longint; {for uploads only}
		Cost           : Longint;
		CDRom          : Boolean;
		FoundFirst     : Boolean; {both of these fields}
		XferTime       : Word;    {are for internal use only}
  End;

  MSGINFOrecord  = record
                     LowMsg,
                     HighMsg,
                     TotalMsgs      : Word;
                     TotalOnBoard   : array[1..200] of Word;
                   end;

  MSGIDXrecord   = record
                     MsgNum         : Integer;
                     Board          : Byte;
                   end;

  MSGTOIDXrecord = String[35];

  MSGHDRrecord   = record
                     MsgNum         : Integer;
                     PrevReply,
                     NextReply,
                     TimesRead      : Word;
                     StartBlock     : Word;
                     NumBlocks,
                     DestNet,
                     DestNode,
                     OrigNet,
                     OrigNode       : Word;
                     DestZone,
                     OrigZone       : Byte;
                     Cost           : Word;
                     MsgAttr,
                     NetAttr,
                     Board          : Byte;
                     PostTime       : Time;
                     PostDate       : Date;
                     WhoTo,
                     WhoFrom        : MSGTOIDXrecord;
                     Subject        : String[72];
                   end;

  MSGTXTrecord   = String[255];

  USERONrecord   = record
                     Name,
                     Handle         : MSGTOIDXrecord;
                     Line           : Byte;
                     Baud           : Word;
                     City           : String[25];
                     Status,
                     Attribute      : Byte;
                     StatDesc       : String[10];
                     FreeSpace      : Array[1..98] of Byte;
                     NoCalls        : Word;
                   end;

                   { Status byte - 0 : Browsing (in a menu)
                                   1 : Uploading/downloading
                                   2 : Reading/posting messages
                                   3 : In a door/external utility
                                   4 : Chatting with sysop
                                   5 : Answering questionnaire 
                                   6 : RTC
                                   7 : New user logon
                                 255 : User-defined - display StatDesc

                     Attribute   - Bit 0 : Hidden
                                       1 : Wants chat
                                       2 : Reserved for RANETMGR
                                       3 : Do not disturb flag 
                                       6 : Ready (0=busy) }

  LASTCALLrecord = record
                     Line           : Byte;
                     Name,
                     Handle         : MSGTOIDXrecord;
                     City           : String[25];
                     Baud           : Word;
                     Times          : LongInt;
                     LogOn          : String[5];
                     LogOff         : String[5];
                     Attribute      : Byte;
                   end;

                { Attribute - Bit 0 : Hidden }

  FILESHDRrecord = record
                     Name           : String[12];
                     Size,
                     CRC32          : LongInt;
                     Uploader       : String[35];
                     UploadDate,
                     FileDate,
                     LastDL         : LongInt;
                     TimesDL        : Word;
                     Attrib         : Byte;
                     Password       : String[15];
                     KeyWord        : Array[1..5] of String[15];
                     Cost           : Word;
                     LongDescPtr    : LongInt;
                     FreeSpace      : Array[1..20] of Byte;
                   end;

          {Attrib - Bit 0 : Deleted
                        1 : Unlisted
                        2 : Free (don't adjust ratio) - Does NOT affect "Cost"
                        3 : Not available (don't allow downloads)
                        4 : Locked (no kill)
                        5 : Missing/offline
                        6 : No time restrictions - always allow DL
          }

  FILESIDXrecord = record
                     Name           : String[12];
                     UploadDate     : LongInt;
                     KeyWordCRC     : Array[1..5] of LongInt;
                     LongDescPtr    : LongInt;
                   end;

  LASTREADrecord = array[1..200] of Word;

  USERSIDXrecord = record
                     NameCRC32,
                     HandleCRC32    : LongInt;
                   end;

  COMBINEDrecord = array[1..200] of Word; 

  USERSrecord    = record
                     Name           : MSGTOIDXrecord;
                     Location       : String[25];
                     Organisation,
                     Address1,
                     Address2,
                     Address3       : String[50];
                     Handle         : String[35];
                     Comment        : String[80];
                     PasswordCRC    : LongInt;
                     DataPhone,
                     VoicePhone     : String[15];
                     LastTime       : Time;
                     LastDate       : Date;

                     Attribute,

                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }

                     Attribute2     : Byte;

                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist 
                            4 : Page priority 
                            5 : No echomail in mailbox scan
                            6 : Guest account 
                            7 : Post bill enabled }

                     Flags          : FlagType;
                     Credit,
                     Pending        : LongInt;
                     MsgsPosted,
                     Security       : Word;
                     LastRead,
                     NoCalls,
                     Uploads,
                     Downloads,
                     UploadsK,
                     DownloadsK,
                     TodayK         : LongInt;
                     Elapsed        : Integer;
                     ScreenLength   : Word;
                     LastPwdChange  : Byte;
                     Group          : Word;
                     CombinedInfo   : COMBINEDrecord;
                     FirstDate,
                     BirthDate,
                     SubDate        : Date;
                     ScreenWidth,
                     Language,
                     DateFormat     : Byte;      
                     ForwardTo      : String[35];
                     MsgArea,
                     FileArea       : Word;
                     DefaultProtocol: Char;
                     FileGroup      : Word;
                     LastDOBCheck   : Byte;
                     Sex            : Byte;
                     XIrecord       : LongInt;
                     MsgGroup       : Word;
                     FreeSpace      : Array[1..48] of Byte;
                   end;

  USERSXIrecord  = record
                     FreeSpace      : Array[1..200] of Byte;
                   end;

  SYSINFOrecord  = record
                     TotalCalls     : LongInt;
                     LastCaller     : MSGTOIDXrecord;
                     ExtraSpace     : array[1..128] of Byte;
                   end;

  TIMELOGrecord  = record
                     StartDate      : Date;
                     BusyPerHour    : array[0..23] of Word;
                     BusyPerDay     : array[0..6] of Word;
                   end;

  MNUrecord      = record
                     Typ            : Byte;
                     Security,
                     MaxSec         : Word;
                     NotFlagsMask,
                     Flags          : FlagType;
                     TimeLeft,
                     TimeUsed       : Word;
                     Age,
                     TermAttrib     : Byte;

                     {Bit 0 : ANSI
                          1 : AVT}

                     MinSpeed,
                     MaxSpeed,
                     Credit,
                     OptionCost,
                     PerMinCost     : LongInt;
                     Node,
                     Group          : ByteArray32;
                     StartTime,
                     StopTime       : Array[1..7] of Word;
                     Display        : String[135];
                     HotKey         : String[8];
                     MiscData       : String[135];
                     Foreground,
                     Background     : Byte;
                     FreeSpace      : Array[1..50] of Byte;
                   end;

  EVENTrecord    = record
                     Status         : Byte; { 0=Deleted 1=Enabled 2=Disabled }
                     StartTime      : Time;
                     ErrorLevel     : Byte;
                     Days           : Byte;
                     Forced         : Boolean;
                     LastTimeRun    : Date;
                   end;

  EVENTrecordArray = array[1..20] of EVENTrecord;

  MESSAGErecord  = record
                     Unused         : Array[1..4] of Byte; 
                     Name           : String[40];
                     Typ            : MsgType;
                     MsgKinds       : MsgKindsType;
                     Attribute      : Byte;

                      { Bit 0 : Enable EchoInfo
                            1 : Combined access
                            2 : File attaches
                            3 : Allow aliases
                            4 : Use SoftCRs as characters
                            5 : Force handle     
                            6 : Allow deletes 
                            7 : Is a JAM area }

                     DaysKill,    { Kill older than 'x' days }
                     RecvKill       : Byte; { Kill recv msgs, recv for more than 'x' days }
                     CountKill      : Word;

                     ReadSecurity   : Word;
                     ReadFlags,
                     ReadNotFlags   : FlagType;

                     WriteSecurity  : Word;
                     WriteFlags,
                     WriteNotFlags  : FlagType;

                     SysopSecurity  : Word;
                     SysopFlags,
                     SysopNotFlags  : FlagType;

                     OriginLine     : String[60];
                     AkaAddress     : Byte;
  
                     Age            : Byte;

                     JAMbase        : String[60];
                     Group          : Word;
                     AltGroup       : Array[1..3] of Word;

                     Attribute2     : Byte;

                      { Bit 0 : Include in all groups }

                     FreeSpace2     : Array[1..9] of Byte;
                   end;

  GROUPrecord    = record
                     AreaNum        : Word;
                     Name           : String[40];
                     Security       : Word;
                     Flags,
                     NotFlagsMask   : FlagType;
                     FreeSpace      : Array[1..100] of Byte;
                   end;

  FILESrecord    = record
                     Unused         : Array[1..4] of Byte;
                     Name           : String[40];
                     Attrib         : Byte;

                      { Bit 0 : Include in new files scan
                            1 : Include in upload dupe scan
							2 : Permit long descriptions
                            3 : Area is on CD-ROM 
                            4 : All files are FREE 
                            5 : Allow DLs not in FDB 
                            6 : Allow users to password uploads
                            7 : Scan uploads }

                     FilePath       : String[40];
                     KillDaysDL,
                     KillDaysFD     : Word;
                     Password       : String[15];
                     MoveArea       : Word;
                     Age,
                     ConvertExt     : Byte;
                     Group          : Word;
                     Attrib2        : Byte;

                      { Bit 0 : Include in all groups }

                     DefCost,
                     UploadArea,
                     UploadSecurity : Word;
                     UploadFlags,
                     UploadNotFlags : FlagType;
                     Security       : Word;
                     Flags,
                     NotFlags       : FlagType;
                     ListSecurity   : Word;
                     ListFlags,
                     ListNotFlags   : FlagType;
                     AltGroup       : Array[1..3] of Word;
                     Device         : Byte;
                     FreeSpace      : Array[1..13] of Byte;
                   end;

  CONFrecord     = record
                     Name,
                     Parent         : String[8];
                     Desc           : String[70];
                     Attr           : Byte;

                      { Bit 0 : Private
                            1 : Unlisted
                            2 : Global  
                            3 : Permanent
                            4 : Use handles
                                          }

                     Moderator      : String[35];
                     Language       : String[20];
                     Password       : String[15];
                     Security       : Word;
                     Flags          : FlagType;
                     NumNodes       : Byte;
                     Active         : Array[1..250] of Byte;
                     Child          : Array[1..250] of Boolean;
                     NotFlagsMask   : FlagType;
                     FreeSpace      : Array[1..96] of Byte;
                   end;

  MODEMrecord  = record
                   ComPort,
                   InitTries        : Byte;
                   BufferSize,
                   ModemDelay       : Word;
                   MaxSpeed         : LongInt;
                   SendBreak,
                   LockModem,
                   AnswerPhone,
                   OffHook          : Boolean;
                   InitStr,
                   InitStr2,
                   BusyStr          : String[70];
                   InitResp,
                   BusyResp,
                   Connect300,
                   Connect1200,
                   Connect2400,
                   Connect4800,
                   Connect7200,
                   Connect9600,
                   Connect12k,
                   Connect14k,
                   Connect16k,
                   Connect19k,
                   Connect38k,
                   ConnectFax       : String[40];
                   RingStr,
                   AnswerStr        : String[20];
                   ErrorFreeString  : String[15];
                   FreeSpace        : Array[1..300] of Byte;
                 end;

  ARCrecord = record
                Extension : String[3];
                UnpackCmd,
                PackCmd   : String[60];
              end;

  CONFIGrecord = record
    VersionID           : Word;
    xCommPort           : Byte;
    xBaud               : LongInt;
    xInitTries          : Byte;
    xInitStr,
    xBusyStr            : String[70];
    xInitResp,
    xBusyResp,
    xConnect300,
    xConnect1200,
    xConnect2400,
    xConnect4800,
    xConnect9600,
    xConnect19k,
    xConnect38k         : String[40];
    xAnswerPhone        : Boolean;
    xRing,
    xAnswerStr          : String[20];
    xFlushBuffer        : Boolean;
    xModemDelay         : Integer;

    MinimumBaud,
    GraphicsBaud,
    TransferBaud        : word;
    SlowBaudTimeStart,
    SlowBaudTimeEnd,
    DownloadTimeStart,
    DownloadTimeEnd     : Time;

    PageStart           : Array[0..6] of Time;
    PageEnd             : Array[0..6] of Time;

    SeriNum,
    CustNum             : String[22];
{}  FreeSpace1          : Array[1..24] of Byte;
    PwdExpiry           : Word;

    MenuPath,
    TextPath,
    AttachPath,
    NodelistPath,
    MsgBasePath,
    SysPath,
    ExternalEdCmd       : String[60];

    Address             : Array[0..9] of NetAddress;
    SystemName          : String[30];

    NewSecurity         : Word;
    NewCredit           : Word;
    NewFlags            : FlagType;

    OriginLine          : String[60];
    QuoteString         : String[15];
    Sysop               : String[35];
    LogFileName         : String[60];
    FastLogon,
    AllowSysRem,
    MonoMode,
    StrictPwdChecking,
    DirectWrite,
    SnowCheck           : Boolean;
    CreditFactor        : Integer;

    UserTimeOut,
    LogonTime,
    PasswordTries,
    MaxPage,
    PageLength          : Word;
    CheckForMultiLogon,
    ExcludeSysopFromList,
    OneWordNames        : Boolean;
    CheckMail           : AskType;
    AskVoicePhone,
    AskDataPhone,
    DoFullMailCheck,
    AllowFileShells,
    FixUploadDates,
    FreezeChat          : Boolean;
    ANSI,                       { ANSI: Yes, no, or ask new users     }
    ClearScreen,                { Clear:        "                     }
    MorePrompt          : AskType;    { More:         "                     }
    UploadMsgs          : Boolean;
    KillSent            : AskType;    { Kill/Sent     "                     }

    CrashAskSec         : Word;       { Min sec# to ask 'Crash Mail ?'      }
    CrashAskFlags       : FlagType;
    CrashSec            : Word;       { Min sec# to always send crash mail. }
    CrashFlags          : FlagType;
    FAttachSec          : Word;       {        "    ask 'File Attach ?'     }
    FAttachFlags        : FlagType;

    NormFore,
    NormBack,
    StatFore,
    StatBack,
    HiBack,
    HiFore,
    WindFore,
    WindBack,
    ExitLocal,
    Exit300,
    Exit1200,
    Exit2400,
    Exit4800,
    Exit9600,
    Exit19k,
    Exit38k             : Byte;

    MultiLine           : Boolean;
    MinPwdLen           : Byte;
    MinUpSpace          : Word;
    HotKeys             : AskType;
    BorderFore,
    BorderBack,
    BarFore,
    BarBack,
    LogStyle,
    MultiTasker,
    PwdBoard            : Byte;
    xBufferSize         : Word;
    FKeys               : Array[1..10] of String[60];

    WhyPage             : Boolean;
    LeaveMsg            : Byte;
    ShowMissingFiles,
    xLockModem          : Boolean;
{}  FreeSpace2          : Array[1..10] of Byte;
    AllowNetmailReplies : Boolean;
    LogonPrompt         : String[40];
    CheckNewFiles       : AskType;
    ReplyHeader         : String[60];
    BlankSecs           : byte;
    ProtocolAttrib      : Array[1..6] of Byte;
    xErrorFreeString    : String[15];
    xDefaultCombined    : array[1..25] of Byte;
    RenumThreshold      : Word;
    LeftBracket,
    RightBracket        : Char;
    AskForHandle        : Boolean;
    AskForBirthDate     : Boolean;

    GroupMailSec        : Word;

    ConfirmMsgDeletes   : Boolean;

    FreeSpace4          : Array[1..30] of byte;

    TempScanDir         : String[60];
    ScanNow             : AskType;
    xUnknownArcAction,
    xFailedUnpackAction,
    FailedScanAction    : Byte; {Bit 0:Mark deleted, 1:Mark unlisted, 2:Mark notavail}
    xUnknownArcArea,
    xFailedUnpackArea,
    FailedScanArea      : Word;
    ScanCmd             : String[60];
    xDeductIfUnknown    : Boolean;

    NewUserGroup        : Byte;
    AVATAR              : AskType;
    BadPwdArea          : Byte;
    Location            : String[40];
    DoAfterAction       : Byte; {0 = wait for CR, > 0 = wait for x seconds}
{}  OldFileLine         : String[40];
    CRfore,
    CRback              : Byte;
    LangHdr             : String[40];
    xSendBreak          : Boolean;
{}  ListPath            : String[60];
    FullMsgView         : AskType;
    EMSI_Enable         : AskType;
    EMSI_NewUser        : Boolean;

    EchoChar            : String[1];
    xConnect7200,
    xConnect12000,
    xConnect14400       : String[40];
    Exit7200,
    Exit12000,
    Exit14400           : Byte;
    ChatCommand         : String[60];
    ExtEd               : AskType;
    NewuserLanguage     : Byte;
    LanguagePrompt      : String[40];
    VideoMode           : VideoType;
    AutoDetectANSI      : Boolean;
    xOffHook            : Boolean;
    NewUserDateFormat   : Byte;
    KeyboardPwd         : String[15];
    CapLocation         : Boolean;
    NewuserSub          : Byte;
    PrinterName         : String[4];
    HilitePromptFore,
    HiLitePromptBack    : Byte;
    xInitStr2           : String[70];
    AltJSwap            : Boolean;
    SemPath             : String[60];
    AutoChatCapture     : Boolean;

    FileBasePath        : String[60];
    NewFileTag          : Boolean;
    IgnoreDupeExt       : Boolean;
    TempCDFilePath      : String[60];
    TagFore,
    TagBack             : Byte;
    xConnect16k         : String[40];
    Exit16k,
    FilePayback         : Byte;
    FileLine,
    FileMissingLine     : String[200];
    NewUserULCredit     : Byte;
    NewUserULCreditK    : Word;
    ArcInfo             : Array[1..10] of ARCrecord;
    RAMGRAltFKeys       : Array[1..5] of String[60];
    ArcViewCmd          : String[60];
    xConnectFax         : String[40];
    ExitFax             : Byte;
    UseXMS,
    UseEMS              : Boolean;
    CheckDOB            : Byte;
    EchoCheck           : AskType;
    ccSec,
    ReturnRecSec        : Word;
    HonourNetReq        : Boolean;
    DefaultCombined     : COMBINEDrecord;
    AskForSex,
    AskForAddress       : Boolean;
    DLdesc              : AskType;
    NewPhoneScan        : Boolean;
    FutureExpansion : Array[1..587] of Byte;
  end;

  EXITINFOrecord = record
                     Baud             : Word;
                     SysInfo          : SYSINFOrecord;
                     TimeLogInfo      : TIMELOGrecord;
                     UserInfo         : USERSrecord;
                     EventInfo        : EVENTrecord;
                     NetMailEntered,
                     EchoMailEntered  : Boolean;
                     LoginTime        : Time;
                     LoginDate        : Date;
                     TimeLimit        : Word;
                     LoginSec         : LongInt;
                     UserRecord       : Integer;
                     ReadThru,
                     NumberPages,
                     DownloadLimit    : Word;
                     TimeOfCreation   : Time;
                     LogonPasswordCRC : LongInt;
                     WantChat         : Boolean;

                     DeductedTime     : Integer;
                     MenuStack        : Array[1..50] of String[8];
                     MenuStackPointer : Byte;
                     UserXIinfo       : USERSXIrecord;
                     ErrorFreeConnect,
                     SysopNext        : Boolean;

                     EMSI_Session     : Boolean;        { These fields hold  }
                     EMSI_Crtdef,                       { data related to an }
                     EMSI_Protocols,                    { EMSI session       }
                     EMSI_Capabilities,
                     EMSI_Requests,
                     EMSI_Software    : String[40];
                     Hold_Attr1,
                     Hold_Attr2,
                     Hold_Len         : Byte;

                     PageReason       : String[80];
                     StatusLine       : Byte;
                     LastCostMenu     : String[8];
                     MenuCostPerMin   : Word;

                     DoesAVT,
                     RIPmode          : Boolean;

                     ExtraSpace       : Array[1..86] of Byte;
                 end;

  PROTOCOLrecord = record
                     Name           : String[15];
                     ActiveKey      : Char;
                     OpusTypeCtlFile,
                     BatchAvailable : Boolean;
                     Attribute      : Byte; { 0=Disabled, 1=Enabled, 2=Errorfree}
                     LogFileName,
                     CtlFileName,
                     DnCmdString,
                     DnCtlString,
                     UpCmdString,
                     UpCtlString    : String[80];
                     UpLogKeyword,
                     DnLogKeyword   : String[20];
                     XferDescWordNum,
                     XferNameWordNum : Byte;
                   end;

(* End of "STRUCT.200" *)
