{ DCTCopy v0.01 - May 9, 1996                                               }
{                                                                           }
{    This is a simple program that will allow the SysOp to use alternating  }
{ ANSIs for his menus or random ones each time the next user logs in.       }
{ Because of its simplicity, I have decided to release the source code to   }
{ it too.  The MiscProc.Tpu unit is not included in the archive, so you     }
{ will have to make a few modifications for the program to compile.         }
{                                                                           }
{    You may do what you like with this code: modify it, distribute it,     }
{ call it your own, etc.  It's in the public domain.                        }
{                                                                           }
{ And now for the disclaimer...                                             }
{                                                                           }
{    The author, Daniel Traczynski, will take no responsibility to anything }
{ that this program may or may not do to your system.  Although the program }
{ has been tested thoroughly, no guarantee can be given that it will do     }
{ what it was made to do.  Nevertheless, if anything should happen, the     }
{ user is totally responsible and the author will be under no obligations   }
{ whatsoever.  By using this program and/or source code, you agree to this  }
{ disclaimer.                                                               }

Uses Crt, Dos, MiscProc;

Type Str30 = String[30];

Var FName    : String;  { Filename of CTL file.        }
    DirName  : String;  { Directory program resides in }
    NumFiles : Byte;    { Number of files to rename    }
    F        : Array[1..255] Of ^Str30;
    CurNum   : Array[1..255] Of Byte;
    Seq      : Boolean; { True=Sequential, False=Random (default) }
    X        : Byte;

Procedure ProcessCmdLine; { Process the command-line parameters and find out }
                          { what directory DCTCOPY.EXE resides in.           }
Var X    : Byte;
    Tmp  : String;
Begin
  DirName := UCase(ParamStr(0));
  While (DirName[Length(DirName)] <> '\') And (DirName <> '') Do
    Dec(DirName[0]);
  FName := 'DCTCOPY.CTL';
  Seq := False;
  For X := 1 To ParamCount Do Begin
    Tmp := ParamStr(X);
    If Tmp[1] In ['/', '-'] Then Begin
      Case UpCase(Tmp[2]) Of
        'C': Begin
               If Tmp[3] = ':' Then Delete(Tmp, 1, 3) Else Delete(Tmp, 1, 2);
               FName := UCase(Tmp);
             End;
        'S': Seq := True;
        'R': Seq := False;
        '?': Begin
               WriteKewl('USAGE:||');
               WriteKewl('DCTCOPY [/?] [/C[:]CTLFile] [/S');
               TextColor(9); Write('|/'); WriteKewl('R]||');
               WriteKewl(' /?           Brings up this help screen.|');
               WriteKewl(' /C[:]CTLFile Specify alternate .CTL file rather than the default DCTCOPY.CTL.|');
               WriteKewl(' /S           Use sequential mode.|');
               WriteKewl(' /R           Use random mode (default).||');
               Halt(0);
             End;
      End;
    End; { If Tmp[1] In ... }
  End; { For X := 1 To ... }
End;

Procedure LoadCfg;  { Load up the .CTL file. }
Var TFile : Text;
    Tmp   : String;
    SFile : File Of Byte;
    X, Y  : Byte;
Begin
  NumFiles := 0;
  Assign(TFile, FName);
  {$I-} Reset(TFile); {$I+}
  If IOResult <> 0 Then Begin
    WriteKewl('The file ' + FName + ' could not be found.');
    Halt(1);
  End;
  While Not Eof(TFile) Do Begin
    ReadLn(TFile, Tmp);
    Inc(NumFiles);
    New(F[NumFiles]);
    F[NumFiles]^ := UCase(Tmp);
  End; { While Not Eof ... }
  Close(TFile);

  If Seq Then Begin
    Y := 0;  { Dummy variable }
    Assign(SFile, DirName + 'DCTCOPY.DAT');
    {$I-} Reset(SFile); {$I+}
    If IOResult <> 0 Then Begin
      ReWrite(SFile);
      For X := 1 To NumFiles Do Write(SFile, Y);
      Seek(SFile, 0);
    End;
    Y := 1;  { Dummy variable }
    For X := 1 To NumFiles Do
      If Eof(SFile) Then CurNum[X] := 0
                    Else Read(SFile, CurNum[X]);
  End; { If Seq ... }
End;

Function FileExists(Const S: String) : Boolean;
Begin
  FileExists := (FSearch(S, '') <> '');
End;

Procedure CopyFile(Const Src, Dst: String); { This is straight out of TP's  }
                                            { online help.                  }
Var FromF, ToF : File;
    NumRead,
    NumWritten : Word;
    Buf        : Array[1..2048] Of Char;
Begin
  Assign(FromF, Src);
  Reset(FromF, 1);
  Assign(ToF, Dst);
  ReWrite(ToF, 1);
  Repeat
    BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
    BlockWrite(ToF, Buf, NumRead, NumWritten);
  Until (NumRead = 0) Or (NumWritten <> NumRead);
  Close(FromF);
  Close(ToF);
End;

Procedure Process(Const Cur: Byte);  { Process the actual file. }
Var Tmp : String;
    X   : Byte;
Begin
  If Seq Then Begin { If in sequential mode. }
    Inc(CurNum[Cur]);
    Str(CurNum[Cur], Tmp);
    If Not FileExists(F[Cur]^ + '.' + Tmp) Then Begin { Not found }
      CurNum[Cur] := 1;
      If Not FileExists(F[Cur]^ + '.1') Then Begin { File.1 doesn't exist either }
        WriteKewl('Unable to process ' + F[Cur]^ + '.|');
        Exit;
      End;
    End;
  End Else Begin { If Seq ... }
    For X := 1 To 255 Do Begin
      Str(X, Tmp);
      If Not FileExists(F[Cur]^ + '.' + Tmp) Then Break;
    End;
    Dec(X);
    If X = 0 Then Begin
      WriteKewl('Unable to process ' + F[Cur]^ + '.|');
      Exit;
    End;
    CurNum[Cur] := Random(X) + 1;
  End; { If Random }
  { We know the filename to copy, so let's do it }
  Str(CurNum[Cur], Tmp);
  WriteKewl('Copying ' + F[Cur]^ + '.' + Tmp + ' to ' + F[Cur]^ + '.ANS...');
  CopyFile(F[Cur]^ + '.' + Tmp, F[Cur]^ + '.ANS');
  WriteKewl('Done!|');
End;

Procedure SaveData;  { Save the data so if we're in sequential mode, we know }
                     { which file to select on the next run.                 }
Var SFile : File Of Byte;
    X     : Byte;
Begin
  Assign(SFile, DirName + 'RANDOM.DAT');
  ReWrite(SFile);
  For X := 1 To NumFiles Do Write(SFile, CurNum[X]);
  Close(SFile);
End;

Begin
  Randomize;
  ClrScr;
  WriteKewl('Random/Sequential File Copying Utility v0.01 By Dan Traczynski||');
  ProcessCmdLine;
  WriteKewl('Mode Selected: ');
  If Seq Then WriteLn('Sequential') Else WriteLn('Random');
  WriteLn;
  LoadCfg;
  For X := 1 To NumFiles Do Process(X);   { Process the files. }
  SaveData;
  { All done! }
End.