/*********************************Y2KDATE.C*********************************/
/*                                                                         */
/*                         (c) David Rance, 1999                           */
/*                                                                         */
/*  A program for correcting bad Y2K dates in *.MSG files. This source     */
/*  code is released to Fidonet sysops to help combat the problems brought */
/* about by the Y2K date rollover.                                         */
/*                                                                         */
/*      24/11/99        Program started.                                   */
/*      25/11/99        Version 0.1 finished.                              */
/*      27/11/99        Notified of a problem by Peter Wasgien where       */
/*                      *.MSG files produced by mega-tic have a space as   */
/*                      the first character of the date and only one space */
/*                      between the date and the time, so Y2KDATE thought  */
/*                      it was a SEAdog file! Fixed. Version 0.1a          */

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <io.h>
#include <process.h>

#define  INTRO_MSG "Y2KDATE - changes bad Y2K dates in *.MSG files     (c) 1999, David Rance"


/**************************FUNCTION DECLARATIONS****************************/

void proc_message(char *,char *),help();
int  fix_date(char *);

/****************************GLOBAL VARIABLES*******************************/

struct find_t c_file;
int    DEBUG;

/****************************START OF PROGRAM*******************************/

int main(int argc,char *argv[])
	{
	int DONE;
	char searchpath[40],msgpath[40];

	printf("\n%s\n",INTRO_MSG);
	if(argc<2)
		{
		printf("\nERROR:\tNeeds a path to your *.MSG files.");
		printf("\n\tType Y2KDATE ? for help.\n");
		exit(1);
		}
	if(strstr(argv[1],"?"))
		{
		help();
		exit(1);
		}
	if(strstr(argv[2],"d")||strstr(argv[2],"D"))
		DEBUG=1;
	strcpy(msgpath,argv[1]);
	if(access(msgpath,0))
		{
		printf("\nERROR:\tInvalid path\n");
		exit(1);
		}
	if(msgpath[strlen(msgpath)-1]!='\\')
		strcpy(msgpath+strlen(msgpath),"\\\0");
	strcpy(searchpath,msgpath);
	strcat(searchpath,"*.msg");
	DONE=_dos_findfirst(searchpath,_A_NORMAL,&c_file);
	while(!DONE)
		{
		proc_message(msgpath,c_file.name);
		DONE=_dos_findnext(&c_file);
		}
	printf("\n\nFinished!\n");
	return(0);
	}

/********************************END MAIN***********************************/
void proc_message(char *path,char *name)
	{
	char message_file[50];
	static char date[22];
	long cl;
	int CHANGED;

	FILE *msgpointer;

	cl=144;                               /* offset of date in message */
	strcpy(message_file,path);
	strcat(message_file,name);
	if((msgpointer=fopen(message_file,"r+b"))==NULL)
		{                                    /* update binary mode */
		printf("\nCouldn't open %s",message_file);
		exit(1);
		}
	fseek(msgpointer,cl,SEEK_SET);    /* position file pointer to date */
	fgets(date,21,msgpointer);                             /* get date */
	printf("\nChecking %s",name);
	CHANGED=fix_date(date);    /* examine date and change if necessary */
	if(CHANGED)  /* if the date is changed and not debug mode, save it */
		{
		fseek(msgpointer,cl,SEEK_SET); /* re-position file pointer */
		fputs(date,msgpointer);                   /* save new date */
		fputc('\0',msgpointer);   /* make sure it ends with 0 byte */
		printf(" - date changed");
		}
	fclose(msgpointer);                              /* close the file */
	return;
	}
/*****************************END PROC_MESSAGE******************************/

int fix_date(char *date)
	{
	char weekday[4],month[4],time[9];
	unsigned int day,year;
	int CHANGE;

	CHANGE=0;
	if(!isalpha(date[0]))                       /* is it a normal date? */
		sscanf(date,"%u %s %u %s",&day,month,&year,time);
	else                               /* or is it a SEAdog type date? */
		{
		sscanf(date,"%s %u %s %u %s",weekday,&day,month,&year,time);
		CHANGE=1;
		}
	if(year>99)                                  /* if the year is Y2K */
		{
		year-=100;                                    /* change it */
		CHANGE=1;
		}
	if(strlen(time)==5)                /* if the time field is short,  */
		{                                 /* as in SEAdog messages */
		strcat(time,":00");                     /* add the seconds */
		CHANGE=1;
		}
	if(CHANGE)             /* if the date is changed save it to buffer */
		{
		if(DEBUG)
			printf("\n\tOld date: %s",date);
		sprintf(date,"%2.2u %s %2.2u  %s",day,month,year,time);
		if(DEBUG)
			{
			printf("\n\tNew date: %s",date);
			printf("\n\tDebug mode: change not made");
			CHANGE=0;
			}
		}
	return(CHANGE);
	}

/*******************************END FIX_DATE********************************/
void help()
	{
	printf("\nUsage:\tY2KDATE <filepath> [-d]");
	printf("\n\n\twhere <filepath> is the sudirectory to your *.MSG files");
	printf("\n\tand the optional -d switch is for debug mode. In debug mode");
	printf("\n\tthe changes needed will be displayed on the screen but no");
	printf("\n\tchanges will actually be made.\n");
	return;
	}

/*******************************END PROGRAM*********************************/
