UNIT EchoDefs;

{   File structures for xMail v.1.00
    (c) 1993 Roger Kirchhoff & Stefan Graf
    Attention: These structures may change without notice !             }


  INTERFACE

  CONST

    AreaInfoName   = 'AREAS';    { Message Areas                         }
    NodeFileName   = 'NODE';     { Nodes                                 }
    DupeFileName   = 'DUPES';    { Double messages info                  }
    LinkFileName   = 'LINKS';    { Reply link info                       }
    MsgInfoName    = 'MSGINFO';  { *.MSG area info file                  }
    ConfTextName   = 'CONFNAME'; { Conference names                      }
    AreafixReqName = 'AREAREQ';  { Areas requested from Uplink           }
    AreafixDelName = 'AREADEL';  { Deleted Areas (to prevent automatic reinstallation }
    LockingName    = 'LINELOCK'; { Filename of line lock file            }
    EchoExt        = '.XM';

    LockKennung    = 1;

    PrivateAreaTag = 'RA-ECHO PVT AREA:';
    DupeInfoTag    = 'DUPE INFO:';


  TYPE

    msgbasetype   = (Hudson,Msg,PassThrough,Squish,jam);
{  Link info in LINKS.RAE
   One entry for every subject }

    MsgLinkRec   = RECORD
                     SubjectCRC,          { 16-Bit-CRC of Subjects    }
                     RecNumber,           { Record number in the Base }
                     LastMsg    : WORD;   { Message number            }
                   END;  { of RECORD }

{ DUPES.RAE double messages info
  One entry for every sent or received message }

    MsgDupeRec  = LONGINT;   { High-Word: 16-Bit-CRC of message-Headers }
                             { Low-Word:  date of the message           }


    MsgInfoRec    = RECORD
                      MsgNum  : WORD;            { Number of the message                   }
                      MsgDate : LONGINT;         { Date of the message                     }
                      Change  : BOOLEAN;         { TRUE, if these infos have changed since }
                    END;  { of RECORD }          { the message was last read               }
 

    MsgInfoFile   = RECORD
                      InfoOk   : BOOLEAN;        { TRUE, if the infos may be used          }
                      LastImp,                   { Info about the last imported message    }
                      LastExp,                   { Info about the last exported message    }
                      LastSave : MsgInfoRec;     { Info about the last written message     }
                    END;  { of RECORD }


    AddressRec    = RECORD
                      Zone,
                      Net,
                      Node,
                      Point  : WORD;
                      Domain : STRING [20];
                    END;  { of RECORD }

    AreafixReqRec = RECORD
                      InUse     : BOOLEAN;
                      AddFlag,
                      DelFlag   : BOOLEAN;
                      AreaName  : AreaNameStr;
                      NodeName  : STRING [30];
                      NodeAdr,
                      UplinkAdr : EchoAddrRec;
                      ReqDate   : LONGINT;
                      ReqCount  : WORD;
                    END;  { of RECORD }

    AreafixDelRec = RECORD
                      areaname : STRING[40];
                      deldate  : LONGINT;
                    END; { of RECORD }

    {Flags for netmail and packets}
    PacketFlags   = (NoFlags,Hold,Crash,Direct,KillSend,KillFileSend,TruncatFileSend);


    MailTypeDef   = (Echomail, Netmail, Localmail, Newmail);


    ArcProgramDef = (NoArc,
                     ZIPArc,
                     LZHArc,
                     PAKArc,
                     ARCArc,
                     ZOOArc,
                     LHAArc,
                     ARJArc,
                     HyperArc,
                     UnknownArc,
                     UserArc1,
                     UserArc2,
                     UserArc3,
                     UserArc4,
                     UserArc5,
                     UserArc6);

    NodeDatenRec  = RECORD
                      PointNr,                         { Point-Number                              }
                      NodeNr,                          { Node-Number                               }
                      NetNr,                           { Net-Number                                }
                      ZoneNr,                          { Zone-Number                               }
                      SendZone,                        { Zone of  Sender                           }
                      SendNet,                         { Net of  Sender                            }
                      SendNode,                        { Node of  Sender                           }
                      SendPoint     : WORD;            { Point of  Sender                          }
                      cDummy        : ARRAY [1..20] OF BOOLEAN; { Dummy, former Conferences        }
                      Access        : WORD;            { Access   Level                            }
                      NodeName      : STRING [30];     { Name of Node                              }
                      PassWord      : STRING [20];     { Password for Areafix/Filefix              }
                      ArcType       : ArcProgramDef;   { Definition of the arcer                   }
                      ArcPassword   : STRING [20];     { Password in Arcmail header                }
                      ReAddress     : BOOLEAN;         { TRUE, if address has to be ramapped       }
                                                       { to 3-d Pointnet address                   }
                      ArcMailStatus : PacketFlags;     { Status of  ArcMail-Packets for the Node   }
                                                       { Node o. Hold o. Crash o. Direct           }
                      NameExport    : BOOLEAN;         { TRUE, if Node wants to get mail addresed  }
                                                       { to his name no matter if he is linked to that echo }
                      AddPacket     : BOOLEAN;         { Append mail to exeistimg packets          }
                      TotalImport,                     { Totale Imports from this node (# of mails }
                      TotalExport   : WORD;            { Totale Exports to this node               }
                      NotifyFlag    : BOOLEAN;         { Does this node get notify messages        }
                      AcceptNewEchos: BOOLEAN;         { New echos received from this node are     }
                                                       { created as passthru echos                 }
                      nodeispassive : BOOLEAN;         { if FALSE mail will NOT be exported to     }
                                                       { this node                                 }
                      LastDate      : STRING [8];      { The last date the user requested via Filefix  }
                      AddNewAreas   : BOOLEAN;         {TRUE if the node gets new echos automatically }
                      NetArcType    : ArcProgramDef;   {Netmail Packer; NoArc = *.PKT             }
                      NetArcStatus  : PacketFlags;     { Status for netmail packets                }
                      MaxArcAge,                       { Maximum age of an arcmail packet (days)            }
                      MaxArcSize    : WORD;            { Maximum size of an arcmail packet (kb)             }
                      UseFTSCName   : BOOLEAN;         { Create arcmail packets with FTSC names             }
                      TotalImportL,                    { Totale Imports from this node (# of mails }
                      TotalExportL  : LONGINT;         { Totale Exports to this node               }
                      Credit        : LONGINT;         { Mail credit for cost sharing              }
                      PayUser       : BOOLEAN;         { Does the user pay for echomail ?          }
                      LastNotifyDate: LONGINT;         { Date when the node received last notify msg }
                      ForwardAreaReq: BOOLEAN;         { TRUE if areafix request of this user may be forwarded }
                      Conferences   : ARRAY [1..50] of BOOLEAN; {The conferences the node has      }
                      Dummy         : ARRAY [1..86] OF BYTE; { - unused - }
                    END;  { of RECORD }

    AreaDatenRec  = ARRAY [1..1000] OF BOOLEAN;
    { TRUE if the area is switched on for this node }

    NodeFileRec   = RECORD
                      NodeDaten  : NodeDatenRec;
                      AreaFeld   : AreaDatenRec;
                    END;  { of RECORD }


{ The file AREAS.RAE contains all 1000 echo areas, #1-200 are the internal
  message base areas, #201-1000 the passthru areas  }


    EchoAreaRec   = RECORD
                      Name           : STRING [40]; { Area Name                    }
                      Descr          : STRING [60]; { Description                  }
                      MailType       : MailTypeDef; { local, netmail or what       }
                      StoreType      : msgbasetype;
                      MsgDirectory   : STRING [60]; { ... and the corresponding directory }
                      ReadSecurity   : Word;        { Read access level            }
                      WriteSecurity  : Word;        { Write access level           }
                      OriginLine     : String [60]; { Origin line for this echo    }
                      AreaAddress    : AddressRec;  { Adress of sender for this echo      }
                      ConferenceNr   : Byte;        { The conference this echo belongs    }
                                                    { to. If 0 the echo has NO conference }
                      maxdays,
                      maxrecv,
                      maxcount,
                      totalimp,
                      totalexp       : WORD;        { Purge info }
                      totalimpL,
                      totalexpL      : LONGINT;     { total # of msgs imported/exported in this echo     }
                      BasePathStrip,                { Don't import PATH line to base                     }
                      ExportPathStrip,              { Strip PATH line for downlinks                      }
                      BaseSeenStrip,                { Don't import SEEN-BY to base                       }
                      ExportSeenStrip : BOOLEAN;    { Strip SEEN-BY for downlinks                        }
                      AbsCosts,
                      RelCosts       : WORD;        { The cost for each mail in this echo                }
                      LastActionDate : LONGINT;     { Last date something happened in this echo          }
                      NeverRemove    : BOOLEAN;     { Never remove this echo automatically               }
                      MaxDupes       : WORD;        { Maximum nr. of Dupes                               }
                      SkipPathCheck  : BOOLEAN;
                      Dummy          : ARRAY [1..106] OF BYTE; { unused                   }

                    END;  { of RECORD }

    ConfNameRec   = STRING [255];


IMPLEMENTATION

END.
