/*
 *  XMALLOC.H - Memory allocation routines with internal error checking.
 *  Written 1995-1997 by Andrew Clarke and released to the public domain.
 */

#ifndef __XMALLOC_H__
#define __XMALLOC_H__

#ifdef __cplusplus
extern "C"
{
#endif

void error(char *msg,...);

void *pxmalloc(size_t size, char *srce_fn, unsigned long srce_ln);
void *pxcalloc(size_t nitems, size_t size, char *srce_fn, unsigned long srce_ln);
void *pxrealloc(void *block, size_t size, char *blockn, char *srce_fn, unsigned long srce_ln);
char *pxstrdup(const char *s, char *srce_fn, unsigned long srce_ln);
void pxfree(void *block, char *blockn, char *srce_fn, unsigned long srce_ln);
void xmalloc_list(int hexdump);

#define xmalloc(size)         pxmalloc(size, __FILE__, __LINE__)
#define xcalloc(nitems, size) pxcalloc(nitems, size, __FILE__, __LINE__)
#define xrealloc(block, size) pxrealloc(block, size, #block, __FILE__, __LINE__)
#define xstrdup(s)            pxstrdup(s, __FILE__, __LINE__)
#define xfree(block)          pxfree(block, #block, __FILE__, __LINE__)

#ifdef __cplusplus
};
#endif

#endif
