/*
 *  USERLIST.C
 *
 *  Written by Paul Edwards and modified by Bill Bond.
 *  Released to the public domain.
 *
 *  Look up user name in a Fido userlist.  Modified to make it do a
 *  binary search by Bill Bond.
 *
 *  Note: The Fido userlist consists of fixed length records sorted
 *  alphabetically.  A record is in the format:
 *
 *  Bloggs, Joe      3:666/666
 *
 *
 *  Moddyfide by Kim Lykkegaard on the 20 dec 1997, to support a list
 *  of node entrys.
 *
 *  Rev. 2.    21 dec. 1997
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "xmalloc.h"
#include "userlist.h"

int DoMenu(int x1, int y1, int x2, int y2, char **Itms, int def, int selbox_id, char *topMsg);
#define SELBOX_WRTOVER   7
#define LOOKUPMAX 16


static long filelen(FILE * fp);

/*
 *  This demand at fidouser.lst type of list, but then we will make a
 *  multiply look up.
 */

ADDRESS lookup(char *name, char *fn) {

    FILE *fp;
    ADDRESS tmpAddr;
    char buf[200];
    char revName[200],
         last[62];
    char *nodeinfo[LOOKUPMAX];
    int lenRev, result, fureclen, done = 0, found=0, i, j;
    long low, mid, high;
    char *p;


    tmpAddr = CurArea.addr;
    if (tmpAddr.domain != NULL)
    {
        tmpAddr.domain = xstrdup(tmpAddr.domain);
    }
    tmpAddr.notfound = 1;
    fp = fopen(fn, "r");
    if (fp == NULL)
    {
        return (tmpAddr);
    }
    makeReverse(revName, name);
    strlwr(revName);
    lenRev = strlen(revName);
    if (fgets(buf, sizeof buf, fp) != NULL)
    {
        fureclen = strlen(buf) + 1;
    }
    high = filelen(fp) / fureclen;
    low = 0;

    while (low <= high && !done)
    {
        mid = low + (high - low) / 2;
        fseek(fp, (long)mid * fureclen, SEEK_SET);
        if (fgets(buf, sizeof buf, fp) != NULL) {
            strlwr(buf);
            result = strncmp(buf, revName, lenRev);
            if (result > 0) {
                high = mid - 1;
            } else if (result < 0) {
                low = mid + 1;
            } else {
                /*
                 *  we got a match, lets run back a see if we missed something.
                 */
                while (result == 0)
                {
                     mid=mid-10;
                     if (mid<0)
                     {
                         fseek(fp, 0L, SEEK_SET);
                         break;
                     }
                     fseek(fp, (long)mid * fureclen, SEEK_SET);
                     fgets(buf, sizeof buf, fp);
                     strlwr(buf);
                     result = strncmp(buf, revName, lenRev);
                }
                /*
                 *  now we got to before a match - so lets get the first match.
                 */
                while (result != 0) {
                     fgets(buf, sizeof buf, fp);
                     strlwr(buf);
                     result = strncmp(buf, revName, lenRev);
                }
                /*
                 *  Suprise!!!! now we got the first match.
                 *  we we will implement the lookup window.
                 */
                while ((result == 0) && (found<LOOKUPMAX))
                {
                     buf[strlen(buf)-1]=NULL;
                     buf[0]=toupper(buf[0]);
                     for(i=1; i<strlen(buf)-1; i++)
                     {
                        if ((buf[i] == ' ') && (buf[i+1]!=' '))
                        {
                           buf[i+1]=toupper(buf[i+1]);
                        }
                     }
                     nodeinfo[found++] = xstrdup(buf);
                     fgets(buf, sizeof buf, fp);
                     strlwr(buf);
                     result = strncmp(buf, revName, lenRev);
                }
                nodeinfo[found++] = NULL;
                result = DoMenu(6, 7, 6+62, 5+found, nodeinfo, 0, SELBOX_WRTOVER, " Nodelist lookup ");
                if (result == (unsigned long)-1)
                {
                    fclose(fp);
                    return tmpAddr;
                }
                strcpy(buf, nodeinfo[result]);
                /*
                 *  Hey, this means what the string name, not need to be
                 *  corretc anymore... let set it to the name form the entry.
                 */
                for (i=0; i<strlen(buf); i++)
                {
                    if ((buf[i]!=',') && (buf[i]!=' '))
                    {
                       last[i] = tolower(buf[i]);
                       last[i+1]=NULL;
                    }
                    if (buf[i]==' ')
                    {
                       break;
                    }
                }
                i++;
                for(j=i; j<strlen(buf); j++)
                {
                   revName[j-i]=tolower(buf[j]);
                   revName[j-i+1]=NULL;
                   if ((j!=i) && (buf[j-1]==' '))
                   {
                      revName[j-i]=toupper(buf[j]);
                   }
                   if ((buf[j]==' ') && (buf[j+1]==' '))
                   {
                      break;
                   }
                }
                last[0]=toupper(last[0]);
                revName[0]=toupper(revName[0]);
                strcpy(name, revName);
                strcat(name, last);

                for(i=0; i<found; i++)
                {
                    if (nodeinfo[i]==NULL)
                    {
                       break;
                    }
                    xfree(nodeinfo[i]);
                }
                p = buf + strlen(buf) - 1;
                while ((p >= buf) && (isspace(*p)))
                {
                    *p = '\0';
                    p--;
                }
                while ((p >= buf) && (!isspace(*p)))
                {
                    p--;
                }
                if ((p >= buf) && (isspace(*p)))
                {
                    p++;
                }
                if (tmpAddr.domain != NULL)
                {
                    xfree(tmpAddr.domain);
                }
                fclose(fp);
                /*
                 *  Now return the addr. info.
                 */
                return parsenode(p);
            }
        } else
        {
            done = 0;  /* force end of loop */
        }
    }
    fclose(fp);
    return tmpAddr;
}

void makeReverse(char *revName, char *name)
{
    char *lastSpace;
    int len;

    lastSpace = strrchr(name, ' ');
    if (lastSpace == NULL)
    {
        strcpy(revName, name);
        return;
    }
    len = strlen(lastSpace + 1);
    memcpy(revName, lastSpace + 1, len);
    memcpy(revName + len, ", ", 2);
    memcpy(revName + len + 2, name, (size_t) (lastSpace - name));
    *(revName + len + 2 + (size_t) (lastSpace - name)) = '\0';
}

static long filelen(FILE * fp)
{
    long ret;

    ret = fseek(fp, 0, SEEK_END);
    if (ret != 0L)
    {
        return (0L);
    }
    ret = ftell(fp);
    if (ret < 0)
    {
        ret = 0;
    }
    return ret;
}
