/*
 *  TEXTFILE.C
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis.
 *  Released to the public domain.
 *  Handles import and export of text files.
 *
 *  Lots of changes Dec. 1997 By Frank Adam
 *  Added file selection popup dialogue box.
 *
 *  Changes 17 Jan 1998 by Kim Lykkegaard
 *  Tryed to make it non Compiler dependet.
 *  atleast to make it compile under Watcom C
 *  guess that I'm programing in .-)
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <direct.h>
#include <sys\types.h>
#include <dos.h>

#if defined(PACIFIC)
#include <unixio.h>
#elif defined(SASC)
#include <fcntl.h>
#elif defined(UNIX) || defined(__DJGPP__)
#include <unistd.h>
#else
#include <io.h>
#endif

#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "winsys.h"
#include "menu.h"
#include "dialogs.h"
#include "xmalloc.h"
#include "wrap.h"
#include "date.h"
#include "nshow.h"
#include "quote.h"
#include "textfile.h"
#include "main.h"
#include "keys.h"
#include "screen.h"

#define TEXTLEN 2048

/* import export dialog decs and defs */

#include "help.h"
#include "dirute.h"

#define MAXF 1000   /* This could be increased, but let's get real..:) */
#define DRVATTR -1  /* used when a drive is selected */
#define HIGHBAR WndPrintf(9,top + (cur - curtop),hattr,"%-12s",files[cur]->name)
#define NORMBAR WndPrintf(9,top + (cur - curtop),nattr,"%-12s",files[cur]->name)
#define LPUTFILE WndPrintf(9,top + (i - curtop),nattr,"%-12s",files[i]->name)

struct FILES
{
 char name[13];
 int attrib;
 }**files;

int fmax;  /* maximum allocated */
char avdrives[8]; /* available drives (8 enough ,too much ?) */
WND *IEDhCurr, *IEDhWnd;  /* pointers to current and previous windows */

int WndWidth(void);
void WndFillField(int, int, int,unsigned char ,int );

int ImpExpDlg(char *,int);

void ImpExpDlgInit(int);
void ImpExpDlgDone(void);
void GetAvDrives(void);
LINE *makequote(LINE *, char *);
int wrap(LINE * cl, int x, int y, int rm);
char *getfilename(char *buffer);


int GetOptions(int opt)
{
     char *dest[] = {"Send to Default"," Send to File ",
                            "Send to Printer","    Cancel    ",NULL};
     char *modes[] = {"Text  Mode", "Quote Mode", "Msged Mode",NULL};
     char **p;
     int menux,
         menuh = 12,
         menuoff = 10;

     switch(opt)
     {
           case 0 :
                  menuoff = 15;
                  if (ST->outfile) /* include default option */
                  {
                     p = dest;
                     menuh++;      /* increase menu height as well */
                  }
                  else
                     p = &dest[1];
           break;

           case 1 :
                  p = modes;
           break;
     }

     menux = 38 - strlen(p[0]) / 2;
     menuoff = menux + menuoff;
     return DoMenu(menux,10, menuoff, menuh, p, 0, SELBOX_WRTMODE, NULL);
 }

void import(LINE * l)
{
     static char fn[PATHLEN];
     static char fname[PATHLEN];
     static char line[TEXTLEN];
     char *temp;
     FILE *fp;
     LINE *n;
     int ret;

      ret = GetString(" Import File ", "Name of file to import?",
                        fn, PATHLEN);

     /*
      *  If file exist no fancy layout, just open it.
      *  Else make file list.
      */
     if ((fp = fopen(fn, "r")) == NULL)
     {

        ret = ImpExpDlg(fn,0);      /* 0 = show import dirbox */
     }
     fclose(fp);

     /* not enough memory so do it the old way */
     if (ret < 0)
     {
         confirm("ERROR 1: Out of memory, lets try one more time.");
         ret = GetString(" Import File ", "Name of file to import?",
                           fn, PATHLEN);
      }

      if(!ret)
         return;                 /* either way */

      TTCurSet(1);

      fp = fopen(fn, "r");
      if (fp != NULL)
      {
         if (SW->importfn)
         {
            if (strstr(fn, "\\") || strstr(fn, "/"))
            {
                     temp = getfilename(fn);
            }
            else
            {
                     temp = strupr(fn);
            }
            strcpy(fname, temp);
            sprintf(line, "   ----- %s begins -----\n", fname);
            l->text = strdup(line);
         }

         while (fgets(line, sizeof line, fp) != NULL)
         {
            if (l->text != NULL)
            {
               n = xcalloc(1, sizeof *n);
               n->prev = l;
               n->next = l->next;

               if (n->next != NULL)
               {
                        n->next->prev = n;
               }

               l->next = n;
               l = n;
            }
            else
            {
               n = l;
            }

            n->text = strdup(line);
            if (strlen(n->text) > (size_t) SW->rm)
            {
               l = n->next;
               wrap(n, 1, maxy, SW->rm);

               if (!l)
               {
                  while (n->next)
                  {
                        n = n->next;
                  }
               }
               else
               {
                  n = l->prev;
               }

               l = n;
            }
         }

         if (SW->importfn)
         {
             if (l->text != NULL)
             {
                n = xcalloc(1, sizeof *n);
                n->prev = l;
                n->next = l->next;

                if (n->next != NULL)
                {
                         n->next->prev = n;
                }

                l->next = n;
                l = n;
             }
             sprintf(line, "   ----- %s ends -----\n", fname);
             l->text = strdup(line);
         }
         fclose(fp);
      }
}

/*
 *  getfilename; Used to isolate the filename on an import so that
 *  it does not import directories into the message. Used only by
 *  import().
 */

char *getfilename(char *buf)
{
         int x, y;
         char tempch[2];
         static char filename[PATHLEN + 1] = "";

         for (x = 0; x <= strlen(buf); x++)
         {
                  if (buf[strlen(buf) - x] == '\\' || buf[strlen(buf) - x] == '/')
                  {
                                break;
                  }
         }

         for (y = strlen(buf) - x + 1; y <= strlen(buf); y++)
         {
                  tempch[0] = buf[y];
                  tempch[1] = '\0';
                  if (y == strlen(buf) - x + 1)
                  {
                                strcpy(filename, tempch);
                  }
                  else
                  {
                                strcat(filename, tempch);
                  }
         }

         return filename;
}

/*
** Note: this is used to write from out of edit mode !
*/

void export(LINE * f)
{
     FILE *fp;
     char fn[PATHLEN + 1];
     int ret,
         target;

    target = GetOptions(0);

    if (!ST->outfile)
       target++;

    if (ST->outfile[0]=='?')
    {
       strcpy(ST->outfile, &ST->outfile[1]);
    }


     switch(target)
     {
        case 0:         /* set default output */
              strcpy(fn, ST->outfile);
              xfree(ST->outfile);
              ST->outfile = strdup(fn);
        break;

        case 2:         /* go to printer */
              strcpy(fn,"prn");
              xfree(ST->outfile);
              ST->outfile = strdup(fn);
        break;

        case 1:         /* do file picking */
              if (ST->outfile)
                    strcpy(fn, ST->outfile);
              else
                    strcpy(fn, "");

              ret = ImpExpDlg(fn,1);  /* 0 = show import dirbox */
              if (ret < 0)            /* not enough memory so do it the old way */
                 ret = GetString(" Export File ", "Name of file to export?",
                                  fn, PATHLEN);

              if (!ret)
                 return;  /* either way */

              xfree(ST->outfile);
              ST->outfile = strdup(fn);
        break;

        default :
           return;
     }

     ret = ID_ONE;

     if (target != 2)
     {
        fp = fopen(fn,"r");
        if (fp)
        {
           fclose(fp);
           ret = ChoiceBox("Output File Exists", fn, "Over-Write",
                           " Append "," Cancel ");
        }
     }

     switch(ret)
     {
         case ID_ONE :
            fp = fopen(fn, "w");
         break;
         case ID_TWO :
            fp = fopen(fn, "a");
         break;

         default :
            return;
     }

     if (fp == NULL)
     {
        ChoiceBox("", "ERROR 2: Access denied--nah nah na nah nah!", "  Ok  ", NULL, NULL);
        return;
     }

     while (f != NULL)  /* write it */
     {
        if (f->text && (*(f->text) != '\01' || SW->shownotes))
        {
           fputs(f->text, fp);
           if (strchr(f->text, '\n') == NULL)
           {
              fputc('\n', fp);
           }
        }
        f = f->next;
     }

     /* if output is to printer output a formfeed */
     if (isatty(fileno(fp)))
     {
              fputc(12, fp);
     }
     fclose(fp);
     TTCurSet(0);
}


/* Note: This is used to write from view mode */

void writetxt(void)
{
     LINE *f = message->text;
     char fn[PATHLEN];
     int ret,
         fmode,
         target;
     FILE *fp;

     if (ST->outfile)
        strcpy(fn, ST->outfile);
     else
        strcpy(fn, "");

        target = GetOptions(0);

     if (!ST->outfile)
        target++;

     if (ST->outfile[0]=='?')
     {
        strcpy(ST->outfile, &ST->outfile[1]);
     }

     switch(target)
     {
        case 0 :        /* set default output */
               strcpy(fn,ST->outfile);
               xfree(ST->outfile);
               ST->outfile = strdup(fn);
         break;

         case 2 :       /* go to printer */
               strcpy(fn,"prn");
               xfree(ST->outfile);
               ST->outfile = strdup(fn);
         break;

         case 1 :       /* do file picking */
/*               if (ST->outfile)
                  strcpy(fn, ST->outfile);
               else
                  strcpy(fn, ""); */
                  strcpy(fn, "*.*");

               ret = ImpExpDlg(fn,1);
               if (ret < 0)   /* not enough memory for flist, do it the old way */
                  ret = GetString(" Export File ", "Name of file to export?",
                                  fn, PATHLEN);

               if (!ret)
                  return;  /* either way */

               xfree(ST->outfile);
               ST->outfile = strdup(fn);
         break;

         default :
            return;
     }

     ret = ID_ONE;

     if (target != 2)   /* if not prn check if exists */
     {
        fp = fopen(fn,"r");
        if (!fp)
           ret = ID_ONE;
        else
        {
          /* could check here for a config setting to *force* ovr as well  */
          fclose(fp);
          ret = ChoiceBox("Output File", fn, "Over-Write"," Append "," Cancel ");
        }
     }

     switch(ret)
     {
         case ID_ONE :
            fp = fopen(fn, "w");
         break;
         case ID_TWO :
            fp = fopen(fn, "a");
         break;

         default:
            return;
     }

     fmode = GetOptions(1);
     if (fmode == -1)
     {
        fmode = 0;
        return;
     }

     if (fp == NULL)
     {
        confirm("ERROR 3: Access denied--nah nah na nah nah!");
        return;
     }

     if (fmode == 0)
     {
        fprintf(fp, "Date:   %s", itime(message->timestamp));
        fprintf(fp, "\nFrom:   %s", message->isfrom ? message->isfrom : "");
        fprintf(fp, " of %s", show_address(&message->from));
        fprintf(fp, "\nTo:     %s", message->isto ? message->isto : "");

        if (CurArea.netmail)
        {
           fprintf(fp, " of %s", show_address(&message->to));
        }
        fprintf(fp, "\nSubj:   %s", message->subj ? message->subj : "");
        MakeMsgAttrs(fn, &message->attrib, message->scanned, message->times_read);
        fprintf(fp, "\nAttr:   %s", fn);
        fprintf(fp, "\nConf:   %-30s", CurArea.description);
        fprintf(fp, "\n\n");
     }

     if (fmode == 1)
     {
        makequote(message->text, message->isfrom);
        f = message->text;
     }

     while (f != NULL)
     {
        if (f->text && (*(f->text) != '\01' || SW->shownotes))
        {
            fputs(f->text, fp);
            if (!strchr(f->text, '\n') && (!fmode || fmode == 1))
            {
               fprintf(fp, "\n");
            }
        }
        f = f->next;
     }

     /* if output is to printer output a formfeed */
     if (isatty(fileno(fp)))
     {
         fputc(12, fp);
     }

     fclose(fp);
     if (fmode == 1)
     {
        /* reread the old message text */
        set_area(SW->area);
     }
}




int AllocFiles(void)
{
    int i;

    files = malloc(sizeof(struct FILES*) * MAXF);

    if (NULL == files)
       return 0;

    for (i=0; i<MAXF; i++)
    {
       files[i] = malloc(sizeof(struct FILES));
       if (NULL == files[i])
          return fmax = i - 1;
    }

    return fmax = MAXF-1;
}

void KillFiles(void)
{
     while(fmax != 0) free(files[fmax--]);
     free(files);
}

int FileSort(const void *a,const void *b)
{
    struct FILES *a1 = (struct FILES*) a;
    struct FILES *b1 = (struct FILES*) b;

 return strcmp(a1->name,b1->name);
}


int getfiles(char *curdir, char *sfile)
{
    struct _dta f;
    int done,
        i,
        change=0,
        attrib,
        count = 0,
        dirc = 0;
    char sdir[PATHLEN];
    char fname[15];



    strcpy(sdir,curdir);
    if (sfile[0]==NULL)
    {
       strcat(sdir,"*.*");        /* slash supposed to be fixed at call */
    }
    else
    {
       strcat(sdir, sfile);        /* slash supposed to be fixed at call */
    }

    if (strlen(curdir) > 3)    /* must be subdir */
    {
       strcpy(files[count]->name,"..");
       files[count++]->attrib = _A_SUBDIR;
    }
    else                       /*  it must be the root so add the drives */
    {
      while (avdrives[dirc] != '\0')
      {
         if (avdrives[dirc] != *curdir)     /* ..except this one */
         {
            strcpy(files[count]->name,"[ :\\]");
            files[count]->name[1] = avdrives[dirc];
            files[count++]->attrib = DRVATTR;
         }
         dirc++;
      }     /* end while */
    } /* end else if root */

    done = dir_findfirst(sdir, 255, &f);

    while(!done)
    {
       sprintf(fname, "%s", f.name);


       if (!(f.attrib & _A_VOLID) && fname[0] != '.')
       {
          if (!(f.attrib & _A_SUBDIR))
             strlwr(fname);
          else
             strupr(fname);

          strncpy(files[count]->name,fname,13);
          files[count]->name[13] = '\0';
          files[count]->attrib = f.attrib;
          count++;

          if(count >= fmax)
           break;
       } /* end if */

       done = dir_findnext(&f);
    } /* end while */

    do {
       change=0;
       for (i=1; i<count; i++)
       {
          if (strcmp(files[i-1]->name, files[i]->name) > 0)
          {
             strcpy(fname, files[i]->name);
             attrib = files[i]->attrib;
             strcpy(files[i]->name, files[i-1]->name);
             files[i]->attrib = files[i-1]->attrib;
             strcpy(files[i-1]->name, fname);
             files[i-1]->attrib = attrib;
             change=1;
          }
       }
    } while (change!=0);

    do {
       change=0;
       for (i=1; i<count; i++)
       {
          if ((files[i-1]->name[0]!='[') && (files[i]->name[0]=='['))
          {
             strcpy(fname, files[i]->name);
             attrib = files[i]->attrib;
             strcpy(files[i]->name, files[i-1]->name);
             files[i]->attrib = files[i-1]->attrib;
             strcpy(files[i-1]->name, fname);
             files[i-1]->attrib = attrib;
             change=1;
          }
       }
    } while (change!=0);

    return count-1;
}


int showfiles(int maxfiles,struct FILES *retdir,int *current,int func)
{
    int top = 2,
        depth = 13,
        key = 0,
        i;
    int curtop,
        prnflag = 0,
        inppos,
        drop = 0,
        done;
    int nattr = CYAN | BLACK,
        hattr = YELLOW | BLACK;
    char temp[14];
    static int cur;
    curtop = *current;

    if (!curtop)
       cur = 0;

    WndPrintf(1,top-1, cm[IP_BTXT], "Pick :");

    if(func)
      WndPrintf(1,19,cm[IP_BTXT],"Type :");

    WndPrintf(6,top-1,cm[IP_BTXT] | _BLINK, ":");
    WndClear(9,top,20,15,nattr);
    for(i = curtop;i <= maxfiles && i <= (curtop + depth);i++)
    {
       WndPrintf(9,i+top,nattr,"%-12s",files[i]->name);
    }

    while(1)
    {
       HIGHBAR;
       key = GetKey();
       NORMBAR;
       switch(key)
       {
          case Key_F1  :
              if (ST->helpfile != NULL)
              {
                 DoHelp(3);
              }
          break;

          case Key_Tab :
              if (!func)
                 break;        /* don't go in if importing */

              *temp = '\0';
              inppos = done = 0;
              WndPrintf(6,top-1,cm[IP_BTXT],":");
              WndPrintf(6,19,cm[IP_BTXT] | _BLINK,":");
              while (!done)    /* PITA, getline assumes edit is done if
                                  the cursor goes passed the end  */
              {
                 drop = WndGetLine(8, 19, 12, temp, nattr | WHITE, &inppos,
                                   0, 0, 1, NULL);
                 switch(drop)
                 {
                    case Key_Esc :
                       drop = 0;
                       done = 1 ;
                       WndPrintf(6,19,cm[IP_NTXT],":");
                       WndPrintf(6,top-1,cm[IP_BTXT] | _BLINK,":");
                    break;
                    case Key_Ent : if(!*temp) drop = 0;
                       done = 1;
                    break;
                    default :
                      drop = 0;
                 }
              } /* end while (!done) */

              if (!drop)
                 break;

          case Key_Ent :
              if (!drop)
              {
                 strcpy(retdir->name,files[cur]->name);
                 retdir->attrib = files[cur]->attrib;
                 *current = curtop;
                 return key;
               }
               else
               {
                  drop = 0;
                  strcpy(retdir->name,temp);
                  retdir->attrib = 0;
                  return 13;
               }

        case Key_Esc :
            return 27;

        case Key_Up :
            if (cur > 0)
            {
               if (cur > curtop)
                  cur--;
               else
               {
                 cur--;
                 curtop--;
                 prnflag = 1;
               }
            }
        break;

        case Key_Dwn :
            if (cur < maxfiles)
            {
               if (cur < curtop + depth)
                  cur++;
               else
               {
                  cur++;
                  curtop++;
                  prnflag = 1;
               }
        }
        break;

        case Key_Home :
            curtop = 0;
            cur = 0;
            prnflag = 1;
        break;

        case Key_End :
            curtop = maxfiles - depth;
            if (curtop < 0)
               curtop = 0;

            cur = curtop;
            prnflag = 1;
        break;

        case Key_PgUp :
            if (curtop == 0 || maxfiles < depth)
               break;

            if (curtop < depth)
            {
               curtop = 0;
               cur = 0;
            }
            else
            {
               curtop -= depth;
               cur = curtop;
            }
            prnflag = 1;
        break;

        case Key_PgDn :
            if (curtop + depth > maxfiles)
               break;

            curtop += depth;
            cur = curtop;
            prnflag = 1;
        break;

        default:
          if (isalnum(key))
          {
             if (cur + depth < maxfiles)
                i = cur+1;
             else
                i = 0;

             for (; i <= maxfiles;i++)
             {
                   if (toupper(key) == toupper(*files[i]->name))
                   {
                      curtop = cur = i;
                      prnflag = 1;
                      break;
                   }
             }
          }


       } /* end switch */

       if (prnflag)
       {
          prnflag = 0;
          WndClear(9,top,20,15,cm[IP_NTXT]);
          for (i=curtop;i <= curtop + depth && i <= maxfiles; i++)
              LPUTFILE;
       }
    } /* end while */

}


void GetAvDrives()
{
     unsigned ct = 0,
              curd,
              i,
              dummy;

     #if __TURBOC__
         curd = getdisk();
     #else
         curd = _getdrive();
         curd--;
     #endif


     for (i = 0;i < 26 && ct < 7;i ++)
     {
         #if __TUBORC__
             setdisk(i);
             if (i == getdisk())
                avdrives[ct++] = i + 'A';
         #else
             _dos_setdrive(i+1, &dummy);
             if (i+1 == _getdrive())
                avdrives[ct++] = i + 'A';
         #endif
     }
     avdrives[ct] = '\0';

     #if __TUBORC__
        setdisk(curd);
     #else
        _dos_setdrive(curd+1, &dummy);
     #endif
}

void FixPath(char *path)  /* normalize to forward slashes */
{
     char *p = path;

     while(*p)
     {
        if (*p == '\\')
           *p = '/';

        p++;
     }
}


int ImpExpDlg(char *retpath, int func)
{
    int key = 0,
        i,
        j,
        max,
        cur = 0,
        retval;
    unsigned dummy;
    struct FILES curfile;
    char curdir[PATHLEN],
         currentdir[30];
    char homedir[PATHLEN],
         *sp;

    #if __TUBORC__
        int homedisk = getdisk();
    #else
        int homedisk = _getdrive();
        homedisk--;
    #endif

    if (AllocFiles() <= 0)
       return -1;

    GetAvDrives();
    getcwd(homedir, PATHLEN);
    strcpy(curdir,homedir);
    strcat(curdir,"/");
    ImpExpDlgInit(func);

/* work in progress */

    if (strpbrk(retpath, "\\/:") != NULL)
    {
       j=0;
       for(i=0; i<strlen(retpath); i++)
       {
          if ((retpath[i]=='\\') || (retpath[i]=='/') || (retpath[i]==':'))
          {
             j=i+1;
          }
       }
       strcpy(curdir, retpath);
       strcpy(retpath, &curdir[j]);
       curdir[j]=NULL;
    }

    max = getfiles(curdir, retpath);

    while(key != 27)
    {
         FixPath(curdir);
         if (strlen(curdir) > 22)
         {
            sp = strrchr(curdir,'/');
            sp--;
            while(sp > curdir && *sp != '/')
              sp--;

            sprintf(currentdir,"%.*s/..%s",10,curdir,sp);
         }
         else
            strcpy(currentdir,curdir);

         WndClear(3,18,25,18,CYAN);
         WndPrintf(3,18,CYAN,"%s",currentdir);

         key = showfiles(max,&curfile,&cur,func);

         if (key == Key_Ent)
         {
            if (curfile.attrib == DRVATTR)      /* asking for drive */
            {
               #if __TUBORC__
                   setdisk(curfile.name[1] - 'A');
               #else
                   _dos_setdrive(curfile.name[1]-'A'+1, &dummy);
               #endif
               chdir("/");
               sprintf(curdir,"%c:/",curfile.name[1],NULL);
            }

         else if(curfile.attrib & _A_SUBDIR)   /* asking for dir */
         {
            if (*curfile.name != '.')          /* build a new path */
            {
               getcwd(curdir, PATHLEN);
               if (strlen(curdir) > 3)         /* not the root so add a slash*/
                  strcat(curdir,"/");

               strcat(curdir,curfile.name);    /* add new dirname */
               strcat(curdir,"/");    /* and a trailer */
               chdir(curdir);
            }
         else                                  /* ".."  bit easier */
         {
              chdir(curfile.name);
              getcwd(curdir, PATHLEN);
              if (strlen(curdir) > 3)
                 strcat(curdir,"/");
         }
         } /* end else if dirattrib */

         else /* must be our selected file */
         {
            retval = 1;
            strcpy(retpath,curdir);
            strcat(retpath,curfile.name);
            break;
         }

         /* if we get here something changd so re-scan */
            max = getfiles(curdir, retpath);
            cur = 0;
       } /* end if 13 */

       else   /* key must be 27 we're done */
       {
          retval = 0;
          *retpath = '\0';
          TTCurSet(1);
          break;
       }
    }  /* end while */

    KillFiles();
    ImpExpDlgDone();

  /* restore startup */
    #if __TUBORC__
       setdisk(homedisk);
    #else
       _dos_setdrive(homedisk+1, &dummy);
    #endif

    chdir(homedir);

    return retval;
}

void ImpExpDlgInit(int func)
{

     IEDhCurr = WndTop();

     if (!func)  /* import */
     {
        IEDhWnd = WndPopUp(30,21,DBDR | SHADOW, cm[IP_BTXT], cm[IP_NTXT]);
        WndBox(8,1,21,16,cm[IP_BTXT],DBDR);
        WndCurr(IEDhWnd);
        WndTitle("Filename to Import", cm[IP_NTXT]);
     }
     else     /* write / export */
     {
        IEDhWnd = WndPopUp(30,21,DBDR | SHADOW, cm[IP_BTXT], cm[IP_NTXT]);
        WndBox(8,1,21,16,cm[IP_BTXT],DBDR);
        WndCurr(IEDhWnd);
        WndTitle("File to Export to", cm[IP_NTXT]);
        WndFillField(8,19,13,' ',CYAN);
     }
     TTCurSet(0);
}

void ImpExpDlgDone(void)
{

     WndClose(IEDhWnd);
     WndCurr(IEDhCurr);
     TTCurSet(0);
 }



