/*
 *  TEMPLATE.C
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  Handles the creation of messages from a template.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "quote.h"
#include "date.h"
#include "xmalloc.h"
#include "template.h"

#define TEXTLEN 250

#ifndef random
#define random(num) (int) (((long) rand() * (num)) / RAND_MAX)
#endif

int MakeTemplateMsg(msg * m, msg * oldmsg, int olda, int type)
{
    LINE *ln = NULL, *n;
    FILE *fp;
    int rn, i, j, look_for_rand;
    unsigned long pos1, pos2;
    char buf[TEXTLEN];
    char *l;

    fp = NULL;
    if (ST->template != NULL)
    {
        fp = fopen(ST->template, "r");
    }

    if (!ST->template || fp == NULL)
    {
        if (m->text && (type & MT_QUO))
        {
            ln = m->text;
            makequote(ln, oldmsg != NULL ? oldmsg->isfrom : m->isfrom);
        }
        return 0;
    }

    while (fgets(buf, TEXTLEN - 1, fp))
    {
        if (buf[0] == ';')
        {
            continue;
        }

        rn=0;
        /*
         *  Check for template random group.
         */

        if (buf[0] == '#')
        {
           look_for_rand=1;
           pos1 = ftell(fp);
           while (look_for_rand)
           {
              fgets(buf, TEXTLEN - 1, fp);
              if (buf[0]!='#')
              {
                 rn++;
              }
              else
              {
                pos2 = ftell(fp);
                fseek(fp, pos1, SEEK_SET);
                j = random(rn)-1;
                if (j<1) j=1;
                for(i=0; i<j; i++)
                {
                   fgets(buf, TEXTLEN - 1, fp);
                }
                fseek(fp, pos2, SEEK_SET);
                look_for_rand=0;
              }
           } /* end while look_for_rand */
        } /* end if buf[0]=='#' */

        if (buf[0] == '@' && buf[1] && buf[1] != '@')
        {
            switch (tolower(buf[1]))
            {
            case 'f':
                if (!(type & MT_FOR))
                {
                    continue;
                }
                break;

            case 'l':
                if (!(type & MT_FOL))
                {
                    continue;
                }
                break;

            case 'r':
                if (!(type & MT_RED))
                {
                    continue;
                }
                break;

            case 'a':
                if (!(type & MT_ARC))
                {
                    continue;
                }
                break;

            case 'q':
                if (!(type & MT_QUO))
                {
                    continue;
                }
                break;

            case 'n':
                if (!(type & MT_NEW))
                {
                    continue;
                }
                break;

            case 'm':
                if (ln)
                {
                    /* assign msg to follow */
                    ln->next = m->text;
                    if (ln->next)
                    {
                        ln->next->prev = ln;
                        ln = ln->next;
                    }
                }
                else
                {
                    ln = m->text;
                }
                if (!(type & MT_QUO))
                {
                    /* don't want a quote */
                    while (ln != NULL && ln->next != NULL)
                    {
                        ln = ln->next;
                    }
                }
                else
                {
                    /* we do want a quote */
                    makequote(ln, oldmsg != NULL ? oldmsg->isfrom : m->isfrom);

                    /* just in case we didn't get the beginning */
                    ln = m->text;
                    while (ln != NULL && ln->next != NULL)
                    {
                        ln = ln->next;
                    }
                }
                continue;

            default:
                /* break on things we don't know */
                break;
            }

            if (buf[2])
            {
                /* could be a blank line... */
                l = attrib_line(m, oldmsg, olda, buf + 2);
            }
            else
            {
                l = xstrdup("\n");
            }
        }
        else
        {
            l = attrib_line(m, oldmsg, olda, buf);
        }

        n = xcalloc(1, sizeof *n);

        n->templt = 1;  /* mark as a template line */

        if (ln)
        {
            n->next = ln->next;
        }

        n->prev = ln;

        if (ln)
        {
            ln->next = n;
        }

        if (n->next)
        {
            n->next->prev = n;
        }

        n->text = l;
        ln = n;
    }

    fclose(fp);

    /* we've finished; assign it to the beginning of the msg */

    if (m->text == NULL && ln != NULL)
    {
        /* find beginning of msg and assign it */

        while (ln->prev)
        {
            ln = ln->prev;
        }
        m->text = ln;
    }

    ln = m->text;
    while (ln && ln->prev)
    {
        ln = ln->prev;
    }
    m->text = ln;

    return 0;
}
