/*
 *  READMAIL.C
 *
 *  Written on 30-Jul-90 by jim nutt.  Changes on 10-Jul-94 by John Dennis.
 *  Released to the public domain.
 *
 *  Handles high-level message I/O.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#if defined(__MSC__) || defined(OS216)
#include <sys/types.h>
#include <sys/timeb.h>
#include <direct.h>
#endif

#if defined(MSDOS) && defined(__TURBOC__)
#include <dir.h>
#endif

#ifdef __WATCOMC__
#if defined(MSDOS) || defined(__NT__)
#include <direct.h>
#endif
#endif

#ifdef PACIFIC
#include <sys.h>
int bdos(int func, unsigned reg_dx, unsigned char reg_al);
#endif

#if defined(MSDOS) || defined(__NT__)
#include <dos.h>
#endif

#ifdef OS2
#define INCL_DOSFILEMGR
#include <fcntl.h>
#endif

#if defined(UNIX) || defined(__DJGPP__)
#include <unistd.h>
#endif

#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "xmalloc.h"
#include "config.h"
#include "quote.h"
#include "wrap.h"
#include "fecfg145.h"
#include "winsys.h"
#include "menu.h"
#include "dialogs.h"
#include "version.h"
#include "echotoss.h"
#include "readmail.h"
#include "date.h"

#ifndef random
#define random(num) (int) (((long) rand() * (num)) / RAND_MAX)
#endif

#define TEXTLEN 96

static void deleteCrapLine(LINE * crap);
static int is_sameaddr(ADDRESS * msg);

extern int set_rcvd;  /* located in msged.c */

#ifdef OS2
static unsigned long setDefaultDisk(unsigned short x);
#endif

static int changeDir(char *path);

extern void reply_oarea(void);
char emailadr[80];

long msgsize,
     quotesize,
     textsize;

void r_email(void) {

     if (uucp_gate.notfound) {
        ChoiceBox("", "ERROR 15: UUCP gate must be defined", "  Ok  ", NULL, NULL);
        return;
     }
     if (confirm(emailadr)) {
        SW->rotharea = MT_ARC | MT_QUO;
        SW->rquote = MT_QUO;
        if (emailadr[0] != 0) {
           xfree(message->isfrom);
           message->isfrom = NULL;
           message->isfrom = xstrdup(emailadr);
        }
        reply_oarea();
     }

}

LINE *clearbuffer(LINE * buffer)
{
    LINE *curline;

    curline = buffer;
    if (curline != NULL)
    {
        while (curline->next != NULL)
        {
            curline = curline->next;
            if (curline->prev == NULL)
            {
                continue;
            }
            if (curline->prev->text != NULL)
            {
                xfree(curline->prev->text);
            }
            curline->prev->next = NULL;
            xfree(curline->prev);
            curline->prev = NULL;
        }
        if (curline != NULL)
        {
            if (curline->text != NULL)
            {
                xfree(curline->text);
                curline->text = NULL;
            }
            xfree(curline);
        }
    }
    return NULL;
}

static void KillTrailingLF(char *text)
{
    char *s;

    if (text == NULL)
    {
        return;
    }

    s = strchr(text, '\n');
    if (s != NULL)
    {
        *s = '\0';
    }
}

msg *readmsg(unsigned long n)
{
    ADDRESS a;
    LINE *l;
    char *tokens[10];
    int headerfin = 0;
    int afound = 0;
    msg *m;
    char *text;
    char *t, *s;
    char *ptmp;
    char tmp[128];
    int goteot = 0;
    int gotsot = 0;
    int i,
        look_for_email_adr=1,
        snabela,
        fs,
        j;

    l = NULL;

    memset(&a, 0, sizeof a);
    emailadr[0]=NULL;

    msgsize = 0L;
    quotesize = 0L;
    textsize = 0L;

    m = MsgReadHeader(n, RD_ALL);
    if (m == NULL)
    {
        return NULL;
    }

    if (SW->twitmode)
    {
       if (num_twitname)
       {
          for(i=0; i<num_twitname; i++) {
              if (stricmp(twitname[i].name, m->isfrom) == 0) {
                  l = InsertAfter(l, "     .... WE GOT A NERD ....");
                  m->text = l;
                  return m;
              }
          }
       }
       if(num_twitsubj)
       {
          for(i=0; i<num_twitsubj; i++)
          {
              if (stricmp(m->subj, twitsubj[i].name) == 0) {
                  l = InsertAfter(l, "     .... WE FOUND A TWIT SUBJECT ....");
                  m->text = l;
                  return m;
              }
          } /* for i<num_twitsubj */
       }
    } /* if SW->Twitmode */

    stripSoft = 1;
    m->replyarea = NULL;
    m->areakludge = NULL;
    m->fwdfrom = NULL;
    m->fwdto = NULL;
    m->fwdorig = NULL;
    m->fwddest = NULL;
    m->fwdsubj = NULL;
    m->fwdarea = NULL;
    m->fwdmsgid = NULL;

    while ((text = MsgReadText(n)) != NULL)
    {
        msgsize = msgsize + strlen(text);
        if (*text == '\n' || *text == '\0' || !stricmp(text, "Lines:"))
        {
            headerfin = 1;  /* want to stop looking unix header info */
        }
        if ((headerfin) && (look_for_email_adr)) {
           if (strpbrk(text, "@")) {
              snabela=0;
              for (i=0; i<strlen(text); i++) {
                  if ((text[i]=='@') && (!snabela)) {
                     snabela = i;
                     look_for_email_adr=0;
                  }
              }
              fs=0;
              for(i=snabela; i>=0; i--) {
                  if (!(strchr("abcdefghijklmnopqrstuvwxyz@ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_", text[i])) && (fs==0)) {
                     fs=i+1;
                  }
              }
              j=0;
              snabela=1;
              for(i=fs; i<strlen(text); i++) {
                  if (!(strchr("abcdefghijklmnopqrstuvwxyz@ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.-_", text[i]))) {
                      snabela=0;
                  }
                  if (snabela) {
                     emailadr[j]=text[i];
                     j++;
                     emailadr[j]=NULL;
                  }
              }
           }
           else
           {
              emailadr[0]=NULL;
           }
        }
        if (*text == '\01')
        {
            switch (*(text + 1))
            {
            case 'A':
                if (strncmp(text + 1, "AREA:", 5) != 0)
                {
                    break;
                }
                s = text + 6;

                while (isspace(*s))
                {
                    s++;
                }

                if (m->replyarea != NULL)
                {
                    xfree(m->replyarea);
                }
                m->replyarea = xstrdup(s);
                KillTrailingLF(m->replyarea);
                if (m->areakludge != NULL)
                {
                    xfree(m->areakludge);
                }
                m->areakludge = xstrdup(s);
                KillTrailingLF(m->areakludge);
                break;

            case 'M':
                if (strncmp(text + 1, "MSGID:", 6) != 0)
                {
                    break;
                }
                s = text + 7;

                while (isspace(*s))
                {
                    s++;
                }

                if (m->msgid != NULL)
                {
                    xfree(m->msgid);
                }
                m->msgid = xstrdup(s);
                KillTrailingLF(m->msgid);
                break;

            case 'R':
                if (strncmp(text + 1, "REPLY:", 6) != 0)
                {
                    break;
                }
                s = text + 7;

                while (isspace(*s))
                {
                    s++;
                }

                if (arealist[SW->area].msgtype != QUICK)
                {
                    if (m->reply != NULL)
                    {
                        xfree(m->reply);
                    }
                    m->reply = xstrdup(s);
                    KillTrailingLF(m->reply);
                }
                break;

            case 'E':
                if (strncmp(text + 1, "EOT:", 4) == 0)
                {
                    goteot = 1;
                    if (gotsot && !(SW->showseenbys || SW->shownotes))
                    {
                        m->soteot = 1;
                    }
                }
                break;

            case 'S':
                if (strncmp(text + 1, "SOT:", 4) == 0)
                {
                    gotsot = 1;
                    stripSoft = 0;
                }
                break;

            case 'F':
                if (strncmp(text + 1, "FMPT", 4) != 0)
                {
                    break;
                }
                s = text + 5;
                m->from.point = atoi(s + 1);
                break;

            case 'T':
                if (strncmp(text + 1, "TOPT", 4) != 0)
                {
                    break;
                }
                s = text + 5;
                m->to.point = atoi(s + 1);
                break;

            case 'D':
                if (strncmp(text + 1, "DOMAIN", 6) != 0)
                {
                    break;
                }

                s = text + 7;
                strcpy(tmp, s);
                memset(tokens, 0, sizeof(tokens));
                parse_tokens(tmp, tokens, 4);

                if (!tokens[3])
                {
                    break;
                }

                memset(&a, 0, sizeof a);
                a = parsenode(tokens[1]);
                if (a.fidonet)
                {
                    if (m->to.domain != NULL)
                    {
                        xfree(m->to.domain);
                        m->to.domain = NULL;
                    }
                    m->to = a;
                    m->to.domain = xstrdup(tokens[0]);
                }
                memset(&a, 0, sizeof a);
                a = parsenode(tokens[3]);
                if (a.fidonet)
                {
                    if (m->from.domain != NULL)
                    {
                        xfree(m->from.domain);
                        m->from.domain = NULL;
                    }
                    m->from = a;
                    m->from.domain = xstrdup(tokens[2]);
                }
                break;

            case 'I':
                if (strncmp(text + 1, "INTL", 4) != 0)
                {
                    break;
                }

                s = text + 5;
                strcpy(tmp, s + 1);
                memset(tokens, 0, sizeof(tokens));
                parse_tokens(tmp, tokens, 2);

                if (!tokens[1])
                {
                    break;
                }

                memset(&a, 0, sizeof a);
                a = parsenode(tokens[0]);
                if (a.fidonet)
                {
                    if (m->to.domain != NULL)
                    {
                        xfree(m->to.domain);
                        m->to.domain = NULL;
                    }
                    m->to = a;
                }
                memset(&a, 0, sizeof a);
                a = parsenode(tokens[1]);
                if (a.fidonet)
                {
                    if (m->from.domain != NULL)
                    {
                        xfree(m->from.domain);
                        m->from.domain = NULL;
                    }
                    m->from = a;
                }
                break;
            }

            if (!SW->shownotes)
            {
                if (text != NULL)
                {
                    xfree(text);
                    text = NULL;
                }
                continue;
            }
        }

        if (*text == 'S')
        {
            if (strncmp(text, "SEEN-BY:", 8) == 0 &&
              !(SW->showseenbys || SW->shownotes) && (!gotsot || goteot))
            {
                if (text != NULL)
                {
                    xfree(text);
                    text = NULL;
                }
                continue;
            }
        }

        if (goteot && *text == '\n' && !(SW->showseenbys || SW->shownotes))
        {
            if (text != NULL)
            {
                xfree(text);
                text = NULL;
            }
            continue;
        }

        /* from Roland Gautschi */

        if (SW->tabexpand && strchr(text, '\t') != NULL)
        {
            do
            {
                ptmp = xstrdup(text);
                if (text != NULL)
                {
                    xfree(text);
                    text = NULL;
                }

                text = xmalloc(strlen(ptmp) + SW->tabsize);
                t = strchr(ptmp, '\t');

                /* characters before \t */

                strncpy(text, ptmp, (size_t) (t - ptmp));

                /* replace \t with spaces */

                memset(text + (size_t) (t - ptmp), ' ', SW->tabsize);

                /* copy the rest */

                strcpy(text + (size_t) (t - ptmp) + SW->tabsize, t + 1);
                xfree(ptmp);
            }
            while (strchr(text, '\t') != NULL);
        }

        if (CurArea.echomail)
        {
            if (afound == 0 && strlen(text) > 10 && *(text + 1) == '*')
            {
                if (!strncmp(text, " * Origin:", 10))
                {
                    /* probably the origin line */

                    s = strrchr(text, '(');
                    if (s != NULL)
                    {
                        while (*s && !isdigit(*s) && *s != ')')
                        {
                            s++;
                        }

                        if (isdigit(*s))
                        {
                            m->from = parsenode(s);
                        }
                    }
                    else
                    {
                        m->from.notfound = 1;
                    }
                }
            }
        }

        if (strncmp(text, "---", 3) == 0 && strncmp(text, "----", 4) != 0 &&
          !(SW->showtearlines || SW->shownotes) && (!gotsot || goteot))
        {
            if (text != NULL)
            {
                xfree(text);
                text = NULL;
            }
            continue;
        }

        if (strncmp(text, " * Origin:", 10) == 0 &&
          !(SW->showorigins || SW->shownotes) &&
          (!gotsot || goteot))
        {
            if (text != NULL)
            {
                xfree(text);
                text = NULL;
            }
            continue;
        }

        if ((CurArea.uucp || CurArea.news) && headerfin == 0)
        {
            char *s;

            if (CurArea.uucp)
            {
                if (strncmp(text, "To:", 3) == 0)
                {
                    s = strchr(text, ' ');
                    m->to.fidonet = 0;
                    m->to.internet = 0;
                    m->to.bangpath = 0;
                    m->to.notfound = 0;
                    while (isspace(*s))
                    {
                        s++;
                    }
                    if (strchr(s, '@') != NULL)
                    {
                        m->to.internet = 1;
                    }
                    else
                    {
                        m->to.bangpath = 1;
                    }
                    if (m->to.domain != NULL)
                    {
                        xfree(m->to.domain);
                        m->to.domain = NULL;
                    }
                    m->to.domain = xstrdup(s);
                    striptwhite(m->to.domain);
                    if (!SW->shownotes)
                    {
                        if (text != NULL)
                        {
                            xfree(text);
                            text = NULL;
                        }
                        continue;
                    }
                }
            }

            if (strncmp(text, "From:", 5) == 0)
            {
                s = strrchr(text, '(');
                if (s == NULL)
                {
                    if (m->isfrom != NULL)
                    {
                        xfree(m->isfrom);
                    }
                    m->isfrom = xstrdup("UUCP");
                }
                else
                {
                    *s = '\0';
                    t = strrchr(s + 1, ')');
                    if (t != NULL)
                    {
                        *t = '\0';
                    }
                    m->isfrom = xstrdup(s + 1);
                }
                s = strchr(text, ' ') + 1;
                m->from.fidonet = 0;
                m->from.internet = 0;
                m->from.bangpath = 0;
                m->from.notfound = 0;
                while (isspace(*s))
                {
                    s++;
                }
                if (strchr(s, '@') != NULL)
                {
                    m->from.internet = 1;
                }
                else
                {
                    m->from.bangpath = 1;
                }
                if (m->from.domain != NULL)
                {
                    xfree(m->from.domain);
                }
                m->from.domain = xstrdup(s);
                striptwhite(m->from.domain);
                if (!SW->shownotes)
                {
                    if (text != NULL)
                    {
                        xfree(text);
                        text = NULL;
                    }
                    continue;
                }
            }
        }

        if (*text != '\01' || SW->shownotes)
        {
            if (is_quote(text))
            {
                quotesize = quotesize + strlen(text);
            }
            else
            {
                textsize = textsize + strlen(text);
            }
            if (l == NULL)
            {
                l = xcalloc(1, sizeof(LINE));
                m->text = l;
                l->next = l->prev = NULL;
            }
            else
            {
                l->next = xcalloc(1, sizeof(LINE));
                if (l->next == NULL)
                {
                    xfree(text);
                    break;
                }
                l->next->next = NULL;
                l->next->prev = l;
                l = l->next;
            }

            l->block = 0;
            l->text = text;
            l->hide = (*text == '\01');

            if (is_quote(text))
            {
                l->quote = 1;
            }
            else
            {
                l->quote = 0;
            }

            if (l->quote)
            {
                if (strlen(l->text) > maxx)
                {
                    wrap(l, 1, maxy, maxx);
                    while (l->next)
                    {
                        l = l->next;
                    }
                }
            }
            else
            {
                if (*text != '\01' && *text != '\n' && strlen(text) > maxx)
                {
                    wrap(l, 1, maxy, maxx);
                    while (l->next)
                    {
                        l = l->next;
                    }
                }
            }
        }
        else
        {
            if (text != NULL)
            {
                xfree(text);
                text = NULL;
            }
        }
    }

    MsgClose();

    if (set_rcvd)
    {
        checkrcvd(m, n);
    }

    return m;
}

/*
 *  checkrcvd(); Checks to see if a message has been recieved. If so,
 *  reads the message header again (avoiding translations done in the
 *  original readinf process) and then writes the header to the message
 *  base.
 */

void checkrcvd(msg * m, unsigned long n)
{
    msg *mn;

    if (m->attrib.rcvd)
    {
        return;
    }

    m->times_read++;

    if (stricmp(ST->username, m->isto) == 0 && is_sameaddr(&m->to))
    {
        mn = MsgReadHeader(n, RD_HEADER);
        if (mn == NULL)
        {
            return;
        }
        mn->attrib.rcvd = 1;
        m->attrib.rcvd = 1;
        m->newrcvd = 1;
        mn->times_read++;
        MsgWriteHeader(mn, WR_HEADER);
        dispose(mn);
    }
}

static int is_sameaddr(ADDRESS * msg)
{
    if (!CurArea.netmail)
    {
        /* we only care about the address in netmail areas */
        return 1;
    }
    if (msg->zone != CurArea.addr.zone)
    {
        return 0;
    }
    if (msg->net != CurArea.addr.net)
    {
        return 0;
    }
    if (msg->node != CurArea.addr.node)
    {
        return 0;
    }
    if (msg->point != CurArea.addr.point)
    {
        return 0;
    }
    return 1;
}

/*
 *  Clears a message only - wipes the slate clean.
 */

void clearmsg(msg * m)
{
    if (m == NULL)
    {
        return;
    }

    /* kill the header stuff */

    if (m->reply != NULL)
    {
        xfree(m->reply);
        m->reply = NULL;
    }

    if (m->msgid != NULL)
    {
        xfree(m->msgid);
        m->msgid = NULL;
    }

    if (m->isfrom != NULL)
    {
        xfree(m->isfrom);
        m->isfrom = NULL;
    }

    if (m->isto != NULL)
    {
        xfree(m->isto);
        m->isto = NULL;
    }

    if (m->subj != NULL)
    {
        xfree(m->subj);
        m->subj = NULL;
    }

    if (m->replyarea != NULL)
    {
        xfree(m->replyarea);
        m->replyarea = NULL;
    }

    if (m->areakludge != NULL)
    {
        xfree(m->areakludge);
        m->areakludge = NULL;
    }

    if (m->fwdfrom != NULL)
    {
        xfree(m->fwdfrom);
        m->fwdfrom = NULL;
    }

    if (m->fwdto != NULL)
    {
        xfree(m->fwdto);
        m->fwdto = NULL;
    }

    if (m->fwdorig != NULL)
    {
        xfree(m->fwdorig);
        m->fwdorig = NULL;
    }

    if (m->fwddest != NULL)
    {
        xfree(m->fwddest);
        m->fwddest = NULL;
    }

    if (m->fwdsubj != NULL)
    {
        xfree(m->fwdsubj);
        m->fwdsubj = NULL;
    }

    if (m->fwdarea != NULL)
    {
        xfree(m->fwdarea);
        m->fwdarea = NULL;
    }

    if (m->fwdmsgid != NULL)
    {
        xfree(m->fwdmsgid);
        m->fwdmsgid = NULL;
    }

    if (m->to.domain != NULL)
    {
        xfree(m->to.domain);
        m->to.domain = NULL;
    }

    if (m->from.domain != NULL)
    {
        xfree(m->from.domain);
        m->from.domain = NULL;
    }

    if (m->text != NULL)
    {
        /* kill the text */
        m->text = clearbuffer(m->text);
    }

    /* clear the rest */
    memset(m, 0, sizeof *m);

    /* set the defaults */
    m->attrib.priv = CurArea.priv;
    m->attrib.crash = CurArea.crash;
    m->attrib.hold = CurArea.hold;
    m->attrib.direct = CurArea.direct;
    m->attrib.killsent = CurArea.killsent;
    m->attrib.local = 1;
}

int setcwd(char *path)
{
    char *p;

    p = strchr(path, ':');
    if (p == NULL)
    {
        p = path;
    }

    if (*p == ':')
    {
        p++;
#if defined(OS2)
        setDefaultDisk((unsigned short)(toupper(*path) - 'A' + 1));
#elif defined(MSDOS) && !defined(__FLAT__)
        bdos(14, toupper(*path) - 'A', 0);
#elif defined(__FLAT__)
        {
            unsigned dummy;
            _dos_setdrive(toupper(*path) - 'A' + 1, &dummy);
        }
#endif
    }

    return changeDir(p);
}

int isleap(int year)
{
    return year % 400 == 0 || (year % 4 == 0 && year % 100 != 0);
}

unsigned long unixtime(const struct tm *tm)
{
    int year, i;
    unsigned long result;

    result = 0UL;
    year = tm->tm_year + 1900;

    /* traverse through each year */

    for (i = 1970; i < year; i++)
    {
        result += 31536000UL;  /* 60s * 60m * 24h * 365d = 31536000s */
        if (isleap(i))
        {
            /* it was a leap year; add a day's worth of seconds */
            result += 86400UL;  /* 60s * 60m * 24h = 86400s */
        }
    }

    /*
     *  Traverse through each day of the year, adding a day's worth
     *  of seconds each time.
     */

    for (i = 0; i < tm->tm_yday; i++)
    {
        result += 86400UL;  /* 60s * 60m * 24h = 86400s */
    }

    /* now add the number of seconds remaining */

    result += 3600UL * tm->tm_hour;
    result += 60UL * tm->tm_min;
    result += (unsigned long) tm->tm_sec;

    return result;
}

unsigned long sec_time(void)
{
    time_t now;
    struct tm *tm;
    now = time(NULL);
    tm = localtime(&now);
    return unixtime(tm);
}

/*
 *  Inserts a line after the passed line and returns a pointer to it.
 */

LINE *InsertAfter(LINE * l, char *text)
{
    LINE *nl;

    nl = xcalloc(1, sizeof(LINE));
    nl->text = xstrdup(text);

    if (l == NULL)
    {
        return nl;
    }

    nl->next = l->next;
    nl->prev = l;
    l->next = nl;
    if (nl->next)
    {
        nl->next->prev = nl;
    }

    return nl;
}

/*
 *  Gets the origin line to use.
 */

static char *GetFastEchoOrigin(int board)
{
    FILE *fp;
    CONFIG feconfig;
    Area fearea;
    ExtensionHeader feexthdr;
    static OriginLines feorigin;
    word cnt;
    int found;

    fp = fopen(ST->fecfgpath, "rb");
    if (fp == NULL)
    {
        return NULL;
    }

    if (fread(&feconfig, sizeof feconfig, 1, fp) != 1)
    {
        return NULL;
    }

    fseek(fp, sizeof feconfig + feconfig.offset + feconfig.NodeCnt *
      feconfig.NodeRecSize, SEEK_SET);

    do
    {
        if (fread(&fearea, sizeof fearea, 1, fp) != 1)
        {
            return NULL;
        }
    }
    while (board != fearea.board);

    cnt = 0;
    found = 0;

    fseek(fp, sizeof feconfig, SEEK_SET);
    while (!found)
    {
        fread(&feexthdr, sizeof feexthdr, 1, fp);
        if (feexthdr.type == EH_ORIGINS)
        {
            do
            {
                if (fread(&feorigin, sizeof feorigin, 1, fp) != 1)
                {
                    return NULL;
                }
                cnt++;
            }
            while (cnt <= (word) ((fearea.flags.flags & 0x1f00) >> 8));
            found = 1;
        }
        else
        {
            fseek(fp, feexthdr.offset, SEEK_CUR);
        }
    }

    fclose(fp);

    if (feorigin.line && *feorigin.line != '\0')
    {
        return feorigin.line;
    }
    else
    {
        return NULL;
    }
}

static int lastspace(char *str)
{

       int i, j=0;

       for(i=0; i<strlen(str); i++)
       {
           if (str[i]==' ')
           {
              j=i;
           }
       }

       return j;

}

/*
 *  Insert name instedt of togen in line.
 *
 */
static void trans_token(char *t, msg *m)
{

       int i, index;
       char a[255], b[255], new[255], ch, namepart[50];

       if (!strchr(t, '@'))
       {
          return;
       }


    while(strchr(t, '@'))
    {
       if (strlen(t) > 200) /* well don't get to big on os */
       {
           return;
       }
           a[0] = NULL;
           b[0] = NULL;
           index = 0;

           for (i=0; i<strlen(t); i++)
           {
              if (t[i] == '@')   /* locate token */
              {
                 index = i;
              }
           }
           for (i=0; i<index; i++)
           {
               a[i] = t[i];;
               a[i+1]= NULL;
           }
           ch = toupper(t[index+1]); /* get token */
           for (i=index+2; i<strlen(t); i++)
           {
               b[i-(index+2)]=t[i];
               b[i-(index+2)+1]=NULL;
           }
           switch(ch)
           {
               case 'N':                      /* indsert full name */
                  sprintf(new, "%s%s%s", a, m->isto, b);
                  strcpy(t, new);
               break;
               case 'A':                      /* indsert Replyarea name */
                  sprintf(new, "%s%s%s", a, m->replyarea, b);
                  strcpy(t, new);
               break;
               case 'S':                      /* indsert Subj name */
                  sprintf(new, "%s%s%s", a, m->subj, b);
                  strcpy(t, new);
               break;
               case 'Y':                      /* indsert Your full name */
                  sprintf(new, "%s%s%s", a, m->isfrom, b);
                  strcpy(t, new);
               break;
               case 'I':                      /* indsert msgsize in byte */
                  sprintf(new, "%s%ld%s", a, msgsize, b);
                  strcpy(t, new);
               break;
               case 'Q':                      /* indsert quote % */
                  sprintf(new, "%s%ld%s", a, ((quotesize*100)/msgsize), b);
                  strcpy(t, new);
               break;
               case 'D':                      /* indsert date */
                  switch(toupper(b[0]))
                  {
                     case 'D':                /* dato */
                        strcpy(new, &b[1]);
                        strcpy(b, new);
                        sprintf(namepart, "%2.2s", mtime(m->timestamp));
                     break;
                     case 'M':                /* Month (jan, feb, .....) */
                        strcpy(new, &b[1]);
                        strcpy(b, new);
                        sprintf(namepart, "%9.9s", mtime(m->timestamp));
                        strcpy(new, &namepart[3]);
                        new[3]=NULL;
                        strcpy(namepart, new);
                     break;
                     case 'Y':                /* Year like 97 */
                        strcpy(new, &b[1]);
                        strcpy(b, new);
                        sprintf(namepart, "%9.9s", mtime(m->timestamp));
                        strcpy(new, &namepart[7]);
                        strcpy(namepart, new);
                     break;
                     case 'C':                /* Hey what century do we have? */
                        strcpy(new, &b[1]);
                        strcpy(b, new);
                        sprintf(namepart, "%9.9s", mtime(m->timestamp));
                        strcpy(new, &namepart[7]);
                        if (atoi(new)>70)
                        {
                            strcpy(namepart, "20");
                        }
                        else
                        {
                            strcpy(namepart, "21");
                        } /* you want more? get lost!  */
                     break;
                     case '4':                /* Hey write year like 1997 */
                        strcpy(new, &b[1]);
                        strcpy(b, new);
                        sprintf(namepart, "%9.9s", mtime(m->timestamp));
                        strcpy(new, &namepart[7]);
                        if (atoi(new)>70)
                        {
                            sprintf(namepart, "19%s", new);
                        }
                        else
                        {
                            sprintf(namepart, "20%s", new);
                        }                     /* you want more? get lost!  */
                     break;
                     default:                 /* Date in format DD Mon YY */
                        sprintf(namepart, "%9.9s", mtime(m->timestamp));
                     break;
                  }
                  sprintf(new, "%s%s%s", a, namepart, b);
                  strcpy(t, new);
               break;
               case 'T':                      /* indsert time hh:mm:ss */
                  sprintf(namepart, "%s", mtime(m->timestamp));
                  strcpy(new, &namepart[11]);
                  strcpy(namepart, new);
                  sprintf(new, "%s%s%s", a, namepart, b);
                  strcpy(t, new);
               break;
               case 'F':                      /* First Name in TO: Field of new message */
                  index = lastspace(m->isto);
                  if (index == 0)             /* Only one name */
                  {
                     strcpy(namepart, m->isto);
                  }
                  else
                  {
                     for(i=0; i<index; i++)
                     {
                        namepart[i]= m->isto[i];
                        namepart[i+1]=NULL;
                     }
                  }
                  sprintf(new, "%s%s%s", a, namepart, b);
                  strcpy(t, new);
               break;
               case 'L':                      /* Last Name in TO: Field of new message */
                  index=lastspace(m->isto);
                  if (index == 0)
                  {           /* only one name */
                      strcpy(namepart, m->isto);
                  }
                  else
                  {
                     for(i=index+1; i<strlen(m->isto); i++)
                     {
                        namepart[i-index-1]= m->isto[i];
                        namepart[i-index]=NULL;
                     }
                  }
                  sprintf(new, "%s%s%s", a, namepart, b);
                  strcpy(t, new);
               break;
           }                                  /* end switch */
    }                                         /* end while */

    if (strlen(t)<80)
    {
        return;
    }

}

static void GetTag(char *tag)
{

    FILE *fp;
    char path[255];


    if (!SW->override)
    {

        if (CurArea.msgtype == SQUISH)
        {
            sprintf(path, "%s.sqt", CurArea.path);
        }
        else
        {
            sprintf(path, "%s\\tag", CurArea.path);
        }

        fp = fopen(path, "r");
        if (fp != NULL)
        {
            int i, orgnum, orgcnt;

            i = 0;
            orgnum = 0;
            orgcnt = 0;

            do
            {
                *tag = '\0';
                fgets(tag, 250, fp);
                if (*tag)
                {
                    orgcnt++;
                }
            }
            while (!feof(fp));

            orgnum = random(orgcnt) + 1;

            rewind(fp);

            do
            {
                *tag = '\0';
                fgets(tag, 250, fp);
                if (*tag)
                {
                    i++;
                }
                if (i == orgnum)
                {
                    break;
                }
            } while (!feof(fp));

            fclose(fp);
        }
        else
        {
           tag[0] = NULL;
        }
    }
    else
    {
        tag[0] = NULL;
    }


    striptwhite(tag);

}

static void GetOrigin(char *origin)
{
    FILE *fp;
    char path[255];

    if (SW->override == 0)
    {
        if (CurArea.msgtype == SQUISH)
        {
            sprintf(path, "%s.sqo", CurArea.path);
        }
        else
        {
            sprintf(path, "%s\\origin", CurArea.path);
        }

        fp = fopen(path, "r");
        if (fp != NULL)
        {
            int i, orgnum, orgcnt;

            i = 0;
            orgnum = 0;
            orgcnt = 0;

            do
            {
                *origin = '\0';
                fgets(origin, 65, fp);
                if (*origin)
                {
                    orgcnt++;
                }
            }
            while (!feof(fp));

            orgnum = random(orgcnt) + 1;

            rewind(fp);

            do
            {
                *origin = '\0';
                fgets(origin, 65, fp);
                if (*origin)
                {
                    i++;
                }
                if (i == orgnum)
                {
                    break;
                }
            }
            while (!feof(fp));

            fclose(fp);
        }
        else
        {
            sprintf(origin, "%s", ST->origin);
            if (CurArea.msgtype == QUICK && areas_type == AT_FASTECHO)
            {
                char *feorigin;
                feorigin = GetFastEchoOrigin(CurArea.board);
                if (feorigin != NULL)
                {
                    sprintf(origin, "%s", ST->origin);
                }
            }
        }
    }
    else
    {
        sprintf(origin, "%s", ST->origin);
    }
    striptwhite(origin);
}

static void InvalidateKludges(msg * m)
{
    LINE *line;

    line = m->text;
    while (line != NULL)
    {
        char *p;
        p = line->text;
        if (p != NULL)
        {
            if (*p == '\01')
            {
                *p = '@';
            }
            else if (strstr(p, "SEEN-BY: ") == p)
            {
                *(p + 4) = '+';
            }
            else if (strstr(p, "---\n") == p || strstr(p, "--- ") == p ||
              strstr(p, " * Origin: ") == p)
            {
                *(p + 1) = '+';
            }
        }
        line = line->next;
    }
}

static void StripKludges(msg * m)
{
    LINE *line;
    int got_origin, got_tear, got_text, got_tag;

    /* traverse forwards through linked list until the end */

    line = m->text;
    while (line->next != NULL)
    {
        line = line->next;
    }

    /* now go backwards, removing any unwanted stuff */

    got_origin = 0;
    got_tear = 0;
    got_text = 0;
    got_tag = 0;

    while (line != NULL)
    {
        char *p;

        p = line->text;
        if (p != NULL)
        {
            if (strstr(p, "\01MSGID: ") == p || strstr(p, "\01REPLY: ") == p ||
              strstr(p, "\01FLAGS ") == p || strstr(p, "\01PID: ") == p ||
              strstr(p, "\01SOT:") == p || strstr(p, "\01EOT:") == p)
            {
                *p = '\0';
            }
            else if (CurArea.netmail)
            {
                if (strstr(p, "\01INTL ") == p || strstr(p, "\01TOPT ") == p ||
                  strstr(p, "\01FMPT ") == p || strstr(p, "\01DOMAIN ") == p ||
                  strstr(p, "\01Via ") == p)
                {
                    *p = '\0';
                }
                else if (!got_text && !got_origin && strstr(p, " * Origin: ") == p)
                {
                    *p = '\0';
                    got_origin = 1;
                }
                else if (!got_text && !got_tear && (strstr(p, "---\n") == p ||
                  strstr(p, "--- ") == p))
                {
                    *p = '\0';
                    got_tear = 1;
                }
                else if (!got_text && !got_tag && strstr(p, "... ") == p)
                {
                    *p = '\0';
                    got_tag = 1;
                }
            }
            else if (!CurArea.netmail)
            {
                if (strstr(p, "SEEN-BY: ") == p || strstr(p, "\01PATH: ") == p)
                {
                    *p = '\0';
                }
                else if (!got_text && !got_origin && strstr(p, " * Origin: ") == p)
                {
                    *p = '\0';
                    got_origin = 1;
                }
                else if (!got_text && !got_tear && (strstr(p, "---\n") == p ||
                  strstr(p, "--- ") == p))
                {
                    *p = '\0';
                    got_tear = 1;
                }
                else if (!got_text && !got_tag && strstr(p, "... ") == p)
                {
                    *p = '\0';
                    got_tag = 1;
                }
                else if (!got_text && (*p == '\n' || *p == '\r'))
                {
                    *p = '\0';
                }
                else if (!got_text && *p != '\0' && *p != '\n' && *p != '\r')
                {
                    got_text = 1;
                }
            }
        }

        line = line->prev;
    }
}

char *space_after_period(LINE *ln)
{
    int snt_count, spc_count;
    snt_count = 0;
    spc_count = 0;
    while (ln != NULL)
    {
        char *p;
        p = ln->text;
        while (*p != '\0')
        {
            if (*p == '.' && *(p + 1) == ' ')
            {
                snt_count++;
                spc_count++;
                if (*(p + 2) == ' ')
                {
                    spc_count++;
                }
            }
            p++;
        }
        ln = ln->prev;
    }
    if (snt_count != 0 && spc_count / snt_count == 2)
    {
        return "  ";
    }
    else
    {
        return " ";
    }
}

/*
 *  Sequence of events:
 *
 *  Original address is saved (what is displayed);
 *  Domain gates are checked for and address is modified if one found;
 *  if no domain gates, search for UUCP gate && mod address if found.
 *  check INTL
 *  check MSGID
 *  check REPLY
 *  do PID if one,
 *  If we found domain gate, do DOMAIN with original saved addresses.
 *  if we found UUCP, then do a "to:" kludge.
 */

/*
 *  Writes a message to disk.
 */

int writemsg(msg * m)
{
    LINE *curr, *l, *ufrom, *uto, *xblank, *xtear, *xorigin;
    ADDRESS to;
    ADDRESS from;
    unsigned long n;            /* UMSGID msgnum */
    unsigned long length;       /* length in bytes of the message */
    char text[255];             /* buffer useage */
    char origin[255];           /* out origin line */
    char tag[255];              /* out tag line */
    char *uucp_from;            /* saved UUCP from address */
    char *uucp_to;              /* saved UUCP to address */
    int domain_gated, uucp_gated;
    char *s;
    int i, abortWrite, len;
    static unsigned long now = 0L;

    domain_gated = 0;
    uucp_gated = 0;
    length = 0;
    n = m->msgnum;
    curr = NULL;
    uto = NULL;
    ufrom = NULL;
    uucp_from = NULL;
    uucp_to = NULL;
    xorigin = NULL;
    xtear = NULL;
    xblank = NULL;

    if (now == 0L)
    {
        now = sec_time();
    }

    if (m->invkludges)
    {
        InvalidateKludges(m);
    }
    else if (!m->rawcopy)
    {
        StripKludges(m);
    }

    if (!m->rawcopy)
    {
        /* save the original address */

        to = m->to;
        from = m->from;

        /* do domain gating */

        if ((SW->gate == GDOMAINS || SW->gate == BOTH) && SW->domains && m->to.domain)
        {
            /*
             *  If we have two domains and they're different, then we want to
             *  gate. If we have a to: domain and no from: domain, then we
             *  still may want to gate.  If we don't have a to: domain, then
             *  we don't want to gate the message (we assume it's destined to
             *  our own network).
             */

            if (m->to.domain || (m->from.domain && m->to.domain &&
              stricmp(m->from.domain, m->to.domain)))
            {
                for (i = 0; i < SW->domains; i++)
                {
                    if (!stricmp(domain_list[i].domain, m->to.domain))
                    {
                        domain_gated = 1;

                        if (m->attrib.crash || m->attrib.crash)
                        {
                            int ret;

                            ret = ChoiceBox(" Crash ", "Crash message to?",
                              "Domain Gate", "Destination Node", NULL);

                            if (ret == ID_ONE)
                            {
                                m->to = domain_list[i];
                                if (domain_list[i].domain)
                                {
                                    m->to.domain = xstrdup(domain_list[i].domain);
                                }
                            }
                        }
                        else
                        {
                            m->to = domain_list[i];
                            if (domain_list[i].domain)
                            {
                                m->to.domain = xstrdup(domain_list[i].domain);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /* do uucp gating */

        if (m->to.internet || m->to.bangpath)
        {
            uucp_gated = 1;
            uucp_to = m->to.domain;
            m->to = uucp_gate;
            if (uucp_gate.domain)
            {
                m->to.domain = xstrdup(uucp_gate.domain);
            }
        }

        if (m->from.internet || m->from.bangpath)
        {
            uucp_gated = 1;
            uucp_from = m->from.domain;
            m->from = uucp_gate;
            if (uucp_gate.domain)
            {
                m->from.domain = xstrdup(uucp_gate.domain);
            }
        }

    /* find a matching destination aka from the origin zone */
        if ((CurArea.netmail) && (SW->matchaka))
        {
          if (m->from.zone != m->to.zone)
          {
              for (i = 0; i < SW->aliascount; i++)
              {
                  if (alias[i].zone == m->to.zone)
                  {
                      m->from = alias[i];
                      from = alias[i];
                      if (alias[i].domain != NULL)
                      {
                          m->from.domain = xstrdup(alias[i].domain);
                      }
                      break;
                  }
              }
          }
          if ((m->from.zone == m->to.zone) && (m->from.net != m->to.net))
          {
              for (i = 0; i < SW->aliascount; i++)
              {
                  if ((alias[i].net == m->to.net) && (alias[i].zone == m->to.zone))
                  {
                      m->from = alias[i];
                      from = alias[i];
                      if (alias[i].domain != NULL)
                      {
                          m->from.domain = xstrdup(alias[i].domain);
                      }
                      break;
                  }
              }
          }
        } /* end if curarea.netmail */

        /* do the netmail stuff */

        if (CurArea.netmail || CurArea.uucp)
        {
            sprintf(text, "\01INTL %d:%d/%d %d:%d/%d\r", m->to.zone,
               m->to.net, m->to.node, m->from.zone, m->from.net, m->from.node);
                curr = InsertAfter(curr, text);
            if (m->to.point)
            {
                sprintf(text, "\01TOPT %d\r", m->to.point);
                curr = InsertAfter(curr, text);
            }
            if (m->from.point)
            {
                sprintf(text, "\01FMPT %d\r", m->from.point);
                curr = InsertAfter(curr, text);
            }

        }

        /* these babies go everywhere */

        if (m->new)
        {
            if (SW->msgids)
            {
                sprintf(text, "\01MSGID: %s %08lx\r", show_address(&from), now++);
                curr = InsertAfter(curr, text);
            }
        }
        else
        {
            if (m->msgid)
            {
                sprintf(text, "\01MSGID: %s\r", m->msgid);
                curr = InsertAfter(curr, text);
            }
        }

        if (m->reply && (!m->new || SW->msgids))
        {
            sprintf(text, "\01REPLY: %s\r", m->reply);
            curr = InsertAfter(curr, text);
        }

        if ((SW->echoflags && CurArea.echomail) || (CurArea.netmail))
        {
            char flags[255];

            /* FLAGS control line */

            *flags = '\0';
            if (m->attrib.priv)
            {
                strcat(flags, " PVT");
            }
            if (m->attrib.crash)
            {
                strcat(flags, " CRA");
            }
            if (m->attrib.attach)
            {
                strcat(flags, " FIL");
            }
            if (m->attrib.killsent)
            {
                strcat(flags, " K/S");
            }
            if (m->attrib.hold)
            {
                strcat(flags, " HLD");
            }
            if (m->attrib.direct)
            {
                strcat(flags, " DIR");
            }
            if (m->attrib.freq)
            {
                strcat(flags, " FRQ");
            }
            if (m->attrib.rreq)
            {
                strcat(flags, " RRQ");
            }
            if (m->attrib.rcpt)
            {
                strcat(flags, " CFM");
            }
            if (*flags)
            {
                sprintf(text, "\01FLAGS%s\r", flags);
                curr = InsertAfter(curr, text);
            }
        }

        if (!SW->usetearlines || SW->usepid || CurArea.netmail)
        {
            sprintf(text, "\01PID: %s %s\r", PROG, PIDVER PIDBETA);
            curr = InsertAfter(curr, text);
        }

        /* domain gating */

        if (domain_gated)
        {
            sprintf(text, "\01DOMAIN %s %d:%d/%d.%d %s %d:%d/%d.%d\r",
              to.domain, to.zone, to.net, to.node, to.point, from.domain,
              from.zone, from.net, from.node, from.point);
            curr = InsertAfter(curr, text);
        }

        if (SW->soteot)
        {
            strcpy(text, "\01SOT:\r");
            curr = InsertAfter(curr, text);
        }

        if (uucp_gated)
        {
            int cr = 0;  /* we want to insert a \n after header info */

            if (uucp_from)
            {
                sprintf(text, "From: %s\r", uucp_from);
                curr = InsertAfter(curr, text);
                ufrom = curr;
                cr = 1;
            }

            if (uucp_to)
            {
                sprintf(text, "To: %s\r", uucp_to);
                curr = InsertAfter(curr, text);
                uto = curr;
                cr = 1;
            }

            if (cr == 1)
            {
                strcpy(text, "\n");
                curr = InsertAfter(curr, text);
            }
        }

        /*
         *  Actually assign the kludges we just created to the message body
         *  (before the text).
         */

        if (curr != NULL)
        {
            curr->next = m->text;
            if (m->text != NULL)
            {
                m->text->prev = curr;
            }

            while (curr->prev != NULL)
            {
                curr = curr->prev;
            }

            m->text = curr;
        }
    }

    l = m->text;
    while (l)
    {
        if (l->text == NULL)
        {
            l->text = xstrdup("\r");
        }

        if (*l->text)
        {
            s = strrchr(l->text, '\n');
            if (s != NULL)
            {
                *s = '\r';
            }
            else
            {
                char *text;

                text = xmalloc(strlen(l->text) + 3);
                strcpy(text, l->text);
                if (l->quote)
                {
                    strcat(text, "\r");
                }
                else
                {
                    if ((l->next == NULL || *(l->next->text) == '\0') &&
                      text[strlen(text) - 1] != '\r')
                    {
                        strcat(text, "\r");
                    }
                    else if (l->next != NULL && *(l->next->text) == '\n' &&
                      text[strlen(text) - 1] != '\r')
                    {
                        strcat(text, "\r");
                    }
                    else if (!isspace(*(text + strlen(text) - 1)))
                    {
                        if (*(text + strlen(text) - 1) == '.')
                        {
                            strcat(text, space_after_period(l));
                        }
                        else
                        {
                            strcat(text, " ");
                        }
                    }
                }
                if (l->text != NULL)
                {
                    xfree(l->text);
                }
                l->text = text;
            }
        }
        l = l->next;
    }

    /* find the end of the message */

    curr = m->text;
    while (curr->next != NULL)
    {
        curr = curr->next;
    }

    if (!m->rawcopy)
    {
        if (SW->soteot)
        {
            strcpy(text, "\01EOT:\r");
            curr = InsertAfter(curr, text);
        }

        if ((CurArea.echomail) || ((CurArea.netmail) && (SW->netmailorigin)))
        {
            if (*curr->text != '\r')
            {
                strcpy(text, "\r");
                curr = InsertAfter(curr, text);
                xblank = curr;
            }

            /* add a TAG line */

            GetTag(tag);
            trans_token(tag, m);
            if (tag[0] != NULL)
            {
               if (strlen(tag) > 75)
               {
                   for (i=75; i>0; i--)
                   {
                       if (tag[i]==' ')
                       {
                           tag[i]='\r';
                           strcpy(text, &tag[i+1]);
                           tag[i+1]=NULL;
                           strcat(tag, "    ");
                           strcat(tag, text);
                           strcat(tag, "\r");
                           break;
                       }
                   }
               }
               sprintf(text, "... %s\r", tag);
               curr = InsertAfter(curr, text);
            }

            /* add the tearline */

            if (SW->usepid)
            {
                sprintf(text, "---\r");
            }
            else
            {
                sprintf(text, "--- %s %s\r", PROG, VERSION CLOSED);
            }

            curr = InsertAfter(curr, text);
            xtear = curr;

            /* add the origin line */

            GetOrigin(origin);

            trans_token(origin, m);

           /*
            *  Check Origin len is legal!
            */

           len = strlen(SW->domainorigin ? show_address(&from) : show_4d(&from));
           len = len + 14;
           if (len > 80) len=80;
           if (len < 0) len=0;
           origin[SW->rm - len] = NULL;

            sprintf(text, " * Origin: %s (%s)\r", origin,
              SW->domainorigin ? show_address(&from) : show_4d(&from));

            curr = InsertAfter(curr, text);
            xorigin = curr;
        }
    }

        if (CurArea.netmail && SW->netmailvia)
        {
            time_t td;
            char time_str[80];

            td = time(NULL);
            strftime(time_str, 80, "%a %b %d %Y at %H:%M UTC", gmtime(&td));
            sprintf(text, "\01Via " PROG " " PIDVER PIDBETA " %s, %s\r",
              show_address(&from), time_str);
            curr = InsertAfter(curr, text);
        }

    /* we've made the new message up, now return it's length */

    l = m->text;
    while (l)
    {
        length += strlen(l->text);
        l = l->next;
    }

    if (!m->rawcopy)
    {
        /* remap point originated crashmail */

        if (!m->attrib.direct && !m->attrib.crash && m->from.point &&
          SW->pointnet != 0 && CurArea.netmail)
        {
            m->from.net = SW->pointnet;
            m->from.node = m->from.point;
            m->from.point = 0;
        }

        /* do any required zone gating */

        if (CurArea.addr.zone != m->to.zone && !m->attrib.direct &&
          !m->attrib.crash && CurArea.netmail && (SW->gate == GZONES ||
          SW->gate == BOTH))
        {
            m->to.node = m->to.zone;
            m->to.zone = CurArea.addr.zone;
            m->to.net = CurArea.addr.zone;
        }
    }

    abortWrite = 0;
    while (MsgWriteHeader(m, WR_ALL) == ERR_OPEN_MSG && !abortWrite)
    {
        int ret;

        ret = ChoiceBox("", "ERROR 17: Could not write message!",
          "Retry", "Cancel", NULL);

        if (ret == ID_TWO)
        {
            abortWrite = 1;
        }
    }

    if (!abortWrite)
    {
        l = m->text;
        while (l)
        {
            if (l->text && *l->text != '\0')
            {
                MsgWriteText(l->text, n, length);
            }

            /*
             *  The \r's have to be turned back into \n's because the
             *  message might be a CC: and so be needed again.
             */

            s = strrchr(l->text, '\r');
            if (s != NULL)
            {
                *s = '\n';
            }

            l = l->next;
        }

        MsgWriteText(NULL, n, length);
        MsgClose();
    }

    CurArea.new = 1;
    echotoss_add(&CurArea);

    /*
     *  Clean up. If this message is a CC, then we don't want this
     *  temporary information to remain.
     */

    if (uucp_from != NULL)
    {
        xfree(uucp_from);
        uucp_from = NULL;
        deleteCrapLine(ufrom);
    }

    if (uucp_to != NULL)
    {
        xfree(uucp_to);
        uucp_to = NULL;
        deleteCrapLine(uto);
    }

    deleteCrapLine(xblank);
    deleteCrapLine(xtear);
    deleteCrapLine(xorigin);

    if (abortWrite)
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

static void deleteCrapLine(LINE * crap)
{
    if (crap != NULL)
    {
        if (crap->prev != NULL)
        {
            crap->prev->next = crap->next;
        }
        if (crap->next != NULL)
        {
            crap->next->prev = crap->prev;
        }
        if (crap->text != NULL)
        {
            xfree(crap->text);
        }
        xfree(crap);
        crap = NULL;
    }
}

#ifdef OS2

#include <os2.h>

static unsigned long setDefaultDisk(unsigned short x)
{
#ifdef OS216
    return DosSelectDisk(x);
#else
    return DosSetDefaultDisk(x);
#endif
}

static int changeDir(char *path)
{
#ifdef OS216
    return chdir(path);
#else
    return DosSetCurrentDir((PSZ) path);
#endif
}

void mygetcwd(char *buf, int len)
{
#ifdef OS216
    getcwd(buf, len);
#else
    unsigned long ulen;
    ulen = len;
    DosQueryCurrentDir(0, (PSZ) buf, &ulen);
#endif
}

#else

static int changeDir(char *path)
{
    return chdir(path);
}

void mygetcwd(char *buf, int len)
{
#ifndef PACIFIC
    getcwd(buf, len);
#else
    getcwd(buf);
#endif
}

#endif
