/*
 *  MAIN.H
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  Contains global variables for use by Msged.  Most common functions
 *  are also prototyped here.
 */

#ifndef __MAIN_H__
#define __MAIN_H__

#define CM_NTXT     0
#define CM_QTXT     1
#define CM_KTXT     2
#define CM_TTXT     3
#define CM_ITXT     4
#define CM_DTXT     5
#define CM_FTXT     6
#define CM_HTXT     7
#define CM_BTXT     8
#define CM_ETXT     9
#define CM_WTXT     10
#define CM_NINF     11          /* net information */

#define MN_BTXT     12          /* menu border text */
#define MN_NTXT     13          /* menu normal text */
#define MN_STXT     14          /* menu selected text */

#define HP_BTXT     15          /* help window border text */
#define HP_TTXT     16          /* help window title text */
#define HP_NTXT     17          /* help normal text */
#define HP_HTXT     18          /* help highlighted text */

#define IN_BTXT     19
#define IN_NTXT     20

#define IP_BTXT     21
#define IP_NTXT     22
#define IP_ETXT     23

#define DL_BTXT     24          /* border */
#define DL_WTXT     25          /* window */
#define DL_CNRM     26          /* checkbox normal */
#define DL_CSEL     27          /* checkbox selected */
#define DL_ENRM     28          /* entry normal */
#define DL_ESEL     29          /* entry selected */
#define DL_BSEL     30          /* button selected */
#define DL_BNRM     31          /* button normal */
#define DL_BSHD     32          /* button shadow */

#define LS_BTXT     33          /* border */
#define LS_TTXT     34          /* title */
#define LS_NTXT     35          /* normal text */
#define LS_ITXT     36          /* info text */
#define LS_STXT     37          /* seletected text */

/* StyleColor */

#define SC_B        38          /* Bold */
#define SC_I        39          /* Italic */
#define SC_BI       40          /* BoldItalic */
#define SC_U        41          /* Underline */
#define SC_BU       42          /* BoldUnderline */
#define SC_IU       43          /* ItalicUnderline */
#define SC_BIU      44          /* BoldItalicUnderline */
#define SC_R        45          /* Reverse */
#define SC_RB       46          /* ReverseBold */
#define SC_RI       47          /* ReverseItalic */
#define SC_RBI      48          /* ReverseBoldItalic */
#define SC_RU       49          /* ReverseUnderline */
#define SC_RBU      50          /* ReverseBoldUnderline */
#define SC_RIU      51          /* ReverseItalicUnderline */
#define SC_RBIU     52          /* ReverseBoldItalicUnderline */

#define AS_MWB      53          /* Main Window Border */
#define AS_MWT      54          /* Main Window Title */
#define AS_SWBU     55          /* Sub Window Border Unselected */
#define AS_SWTU     56          /* Sub Window Title Unselected */
#define AS_SWBS     57          /* Sub Window Border Selected */
#define AS_SWTS     58          /* Sub Window Title Selected */
#define AS_SWNT     59          /* Sub Window Normal Text */
#define AS_SWHT     60          /* Sub Window Selected Text */
#define AS_SWST     61          /* Sub Window Highlight Text */
#define AS_SWC      62          /* Sub Window Cursor */
#define AS_SWGSNT   63          /* Sub Window Get String Normal text */
#define AS_SWGSHT   64          /* Sub Window Get String Highlight text */

#define FZ_LINES    65          /* Fuzzy color stile: Line */
#define FZ_FZ       66          /* Fuzzy color stile: evry thing else */
#define FZ_OTHER    67          /* Fuzzy color stile: evry thing else */
#define FZ_STUFF    68          /* Fuzzy color stile: evry thing else */

#define ID_MGRGT   100
#define ID_MGLFT   101
#define ID_SCRUP   102
#define ID_SCRDN   103
#define ID_QUIT    104
#define ID_EDIT    105
#define ID_SCAN    106
#define ID_AREA    107
#define ID_SETUP   108
#define ID_LNUP    109
#define ID_LNDN    110
#define ID_LIST    111          /* list */
#define ID_PARE    112          /* prev area */
#define ID_NARE    113          /* next area */

#define MNU_LEN    27

#ifdef INCL_MAIN

int cm[] =
{
    /* color table */

    /* Main window colors */

    LGREY | _BLACK,             /* Normal message text */
    WHITE | _BLACK,             /* Quoted message text */
    WHITE | _BLACK,             /* Kludge/information message text */
    WHITE | _BLACK,             /* Template message text */
    BLACK | _LGREY,             /* Status bar */
    WHITE | _BLACK,             /* Divider line between header and message text */
    LGREY | _BLACK,             /* The header titles (From: etc) */
    LGREY | _BLACK,             /* The header text */
    BLACK | _LGREY,             /* A selected block */
    WHITE | _BLACK,             /* Fields being edited in the header */
    WHITE | _BLACK,             /* Warnings */
    WHITE | _BLACK,             /* Network information (area/address) */

    /* Menu colors */

    WHITE | _BLACK,             /* Menu border color */
    LGREY | _BLACK,             /* Unselected text */
    BLACK | _LGREY,             /* Selected text */

    /* Help colors */

    BLACK | _LGREY,             /* Help border */
    BLACK | _LGREY,             /* Help title text */
    BLACK | _LGREY,             /* Normal text */
    BLACK | _LGREY,             /* Help highlight text */

    /* Info colors */

    WHITE | _BLACK,             /* Border color */
    WHITE | _BLACK,             /* Normal text color */

    /* Input colors */

    BLACK | _LGREY,             /* Border color */
    BLACK | _LGREY,             /* Normal text color */
    BLACK | _LGREY,             /* Edit field color */

    /* Dialog colors */

    BLACK | _LGREY,             /* Dialog box borders */
    BLACK | _LGREY,             /* Dialog box window text */
    BLACK | _LGREY,             /* Dialog checkbox normal color */
    BLACK | _LGREY,             /* Dialog checkbox selected color */
    BLACK | _LGREY,             /* Dialog entry field normal color */
    BLACK | _LGREY,             /* Dialog entry field selected color */
    WHITE | _BLACK,             /* Dialog button selected color */
    BLACK | _LGREY,             /* Dialog button normal color */
    BLACK | _LGREY,             /* Dialog button shadow color */

    /* list colors */

    LGREY | _BLACK,             /* List border color */
    WHITE | _BLACK,             /* List title color */
    LGREY | _BLACK,             /* List normal text color */
    WHITE | _BLACK,             /* List information text color */
    BLACK | _LGREY,             /* List selected text color */

    RED      | _BLACK,          /* Bold */
    BLUE     | _BLACK,          /* Italic */
    LMAGENTA | _BLACK,          /* BoldItalic */
    WHITE    | _BLACK,          /* Underline */
    YELLOW   | _BLUE,           /* BoldUnderline */
    LCYAN    | _BLACK,          /* ItalicUnderline */
    WHITE    | _BLUE,           /* BoldItalicUnderline */
    BLACK    | _LGREY,          /* Reverse */
    BLACK    | _RED,            /* ReverseBold */
    BLACK    | _BLUE,           /* ReverseItalic */
    BLACK    | _LMAGENTA,       /* ReverseBoldItalic */
    BLACK    | _WHITE,          /* ReverseUnderline */
    BLUE     | _YELLOW,         /* ReverseBoldUnderline */
    BLACK    | _LCYAN,          /* ReverseItalicUnderline */
    BLUE     | _WHITE,          /* ReverseBoldItalicUnderline */

    /* Advanced search color */
    RED    | _BLACK,             /* Main Window Border */
    YELLOW | _BLACK,             /* Main Window Title */
    DGREY  | _BLACK,             /* Sub Window Border Unselected */
    LGREY  | _BLACK,             /* Sub Window Tittle Unselected */
    CYAN   | _BLACK,             /* Sub Window Border Selected */
    LGREY  | _BLACK,             /* Sub Window Tittle Selected */
    LGREY  | _BLACK,             /* Sub Window Normal Text */
    YELLOW | _BLACK,             /* Sub Window  Highlight Text */
    WHITE  | _BLACK,             /* Sub Window  Selected Text */
    YELLOW | _BLACK,             /* Sub Window Cursor */
    WHITE  | _BLACK,             /* Get String Normal text */
    YELLOW | _BLACK,             /* Get String Highlight text */

    /* Fuzzy color stil */

    LCYAN  | _BLACK,             /* Get String Highlight text */
    BLUE   | _BLACK,             /* Get String Highlight text */
    LBLUE  | _BLACK,             /* Get String Highlight text */
    CYAN   | _BLACK             /* Get String Highlight text */
};

WND *hMnScr;                    /* handle to main screen window */

#else

extern int cm[];
extern WND *hMnScr;             /* handle to main screen window */
extern MC MouseMnu;

#endif

void AreaScan(void);

/* functions from init.c */

void InitVars(void);
void TermVars(void);

#endif
