/*
 *  INIT.C
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  Handles sub-system initialisation for Msged.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "fido.h"
#include "quick.h"
#ifdef USE_MSGAPI
#include "msg.h"
#endif
#include "winsys.h"
#define INCL_MAIN
#include "main.h"
#include "readmail.h"
#include "help.h"
#include "xmalloc.h"

struct _sv *string_vars;
struct _swv *switch_vars;

msghandle msgdo[] =
{
    {
        FidoMsgReadHeader,
        FidoMsgReadText,
        FidoMsgWriteHeader,
        FidoMsgWriteText,
        FidoMsgDelete,
        FidoAreaSetLast,
        FidoMsgAreaOpen,
        FidoMsgAreaClose,
        FidoMsgClose,
        FidoUidToMsgn,
        FidoMsgnToUid
    },
    {
        QuickMsgReadHeader,
        QuickMsgReadText,
        QuickMsgWriteHeader,
        QuickMsgWriteText,
        QuickMsgDelete,
        QuickAreaSetLast,
        QuickMsgAreaOpen,
        QuickMsgAreaClose,
        QuickMsgClose,
        QuickUidToMsgn,
        QuickMsgnToUid
    }
    ,
#ifdef USE_MSGAPI
    {
        SquishMsgReadHeader,
        SquishMsgReadText,
        SquishMsgWriteHeader,
        SquishMsgWriteText,
        SquishMsgDelete,
        SquishAreaSetLast,
        SquishMsgAreaOpen,
        SquishMsgAreaClose,
        SquishMsgClose,
        SquishUidToMsgn,
        SquishMsgnToUid
    }
#else
    {
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL
    }
#endif
};

D_LIST *node_lists = NULL;      /* the nodelists recognized by the system */
AREA *arealist = NULL;          /* list of areas */
ALIAS *aliaslist = NULL;        /* list of aliases */
ADDRESS *domain_list = NULL;    /* list of domain-gates */
ADDRESS *alias = NULL;          /* list of akas */
msg *message = NULL;            /* current message */
char **templates = NULL;        /* templates in system */
USER user_list[MAXUSERS];       /* list of users */
ADDRESS uucp_gate;              /* the uucp gate */

unsigned int *macros[41];       /* function key macros + 1 for autostart */
int maxx;                       /* maximum screen columns */
int maxy;                       /* maximum screen rows */
int rot13;
int stripSoft;
int softcrxlat = 0;
char squish_lock = 1;          /* lock squish msgbase for speed - defauld ON */

#ifndef UNIX

static char *getcomspec(void)
{
    char *comspec;
    comspec = getenv("COMSPEC");
    if (comspec == NULL)
    {
#if defined(MSDOS) || defined(__NT__)
        return "\\COMMAND.COM";
#elif defined(OS2)
        return "\\CMD.EXE";
#else
        return NULL;
#endif
    }
    return comspec;
}

#endif

void InitVars(void)
{
    /* Allocate some memory & initialize it. */

    string_vars = xmalloc(sizeof *string_vars);
    switch_vars = xmalloc(sizeof *switch_vars);

    memset(string_vars, 0, sizeof *string_vars);
    memset(switch_vars, 0, sizeof *switch_vars);
    memset(user_list, 0, sizeof *user_list);
    memset(macros, 0, sizeof *macros);

    /* Initialize all the variables to default values. */

    SW->rm = 80;
    SW->qm = 80;
    SW->tabsize = 4;
    SW->dummy1 = NO;
    SW->qquote = YES;
    SW->msgids = YES;
    SW->opusdate = NO;
    SW->shownotes = NO;
    SW->showseenbys = NO;
    SW->showorigins = YES;
    SW->showtearlines = YES;
    SW->confirmations = YES;
    SW->datearrived = YES;
    SW->showaddr = YES;
    SW->rawcc = YES;
    SW->savecc = YES;
    SW->hardquote = YES;
    SW->chopquote = NO;
    SW->showcr = NO;
    SW->showeol = NO;
    SW->showrealmsgn = NO;
    SW->usemouse = YES;
    SW->tabexpand = YES;
    SW->editcronly = NO;
    SW->usepid = NO;
    SW->soteot = NO;
    SW->showtime = NO;
    SW->importfn = YES;
    SW->dmore = NO;
    SW->statbar = YES;
    SW->rquote = MT_QUO;
    SW->rotharea = MT_QUO | MT_ARC;
    SW->rfollow = MT_QUO | MT_FOL;
    SW->rextra = MT_QUO | MT_FOL | MT_ARC;
    SW->showsystem = YES;
    SW->extformat = YES;
    SW->arealistexactmatch = YES;
    SW->echoflags = YES;
    SW->netmailvia = YES;
    SW->domainorigin = YES;
    SW->rightnextunreadarea = NO;
    SW->usetearlines = YES;
    SW->useoriginlines = YES;
    SW->startupscan = NO;
    SW->splashscreen = YES;
    SW->twitmode = YES;
    SW->areasort = SORTTAG;
    SW->sortdesc = NO;
    SW->sorttag = NO;
    SW->sortunread = NO;
    SW->editormenu = YES;
    SW->netmailorigin = YES;
    SW->showstat = YES;
    SW->layout = YES;
    SW->matchaka = YES;
    SW->fuzzycolor = YES;
    SW->stylecolor = YES;

#ifndef UNIX
    ST->comspec = xstrdup(getcomspec());
#endif

    ST->outfile = xstrdup("msged.txt");
    ST->quotestr = xstrdup(" > ");
    ST->echotoss = xstrdup("echotoss.log");
    ST->lastread = xstrdup("lastread");
    ST->cfgfile = xstrdup("msged.cfg");
    ST->uucpgate = xstrdup("UUCP");
    ST->html = xstrdup("MsGed.htm");
    ST->freqarea = xstrdup("NETMAIL");
    ST->uucparea = xstrdup("NETMAIL");

    uucp_gate.notfound = 1;
    squish_lock = 1;         /* lock squish msgbase for speed - defauld ON */
}

void TermVars(void)
{
    int i;

    if (group != NULL)
    {
        for (i = 0; i < SW->groups; i++)
        {
            if (group[i].search != NULL)
            {
                xfree(group[i].search);
            }
        }
        xfree(group);
        group = NULL;
    }

    if (arealist != NULL)
    {
        for (i = 0; i < SW->areas; i++)
        {
            if (arealist[i].addr.domain != NULL)
            {
                xfree(arealist[i].addr.domain);
            }
            if (arealist[i].description != NULL)
            {
                xfree(arealist[i].description);
            }
            if (arealist[i].tag != NULL)
            {
                xfree(arealist[i].tag);
            }
            if (arealist[i].path != NULL)
            {
                xfree(arealist[i].path);
            }
            if (arealist[i].origin != NULL)
            {
                xfree(arealist[i].origin);
            }
        }
        xfree(arealist);
        arealist = NULL;
    }

    for (i = 0; i <= 40; i++)
    {
        if (macros[i] != NULL)
        {
            xfree(macros[i]);
            macros[i] = NULL;
        }
    }

    if (node_lists != NULL)
    {
        for (i = 0; i < SW->nodelists; i++)
        {
            if (node_lists[i].name != NULL)
            {
                xfree(node_lists[i].name);
            }
            if (node_lists[i].base_name != NULL)
            {
                xfree(node_lists[i].base_name);
            }
            if (node_lists[i].sysop != NULL)
            {
                xfree(node_lists[i].sysop);
            }
        }
        xfree(node_lists);
        node_lists = NULL;
    }

    if (templates != NULL)
    {
        for (i = 0; i < SW->numtemplates; i++)
        {
            if (templates[i] != NULL)
            {
                xfree(templates[i]);
            }
        }
        xfree(templates);
        templates = NULL;
    }

    if (alias != NULL)
    {
        for (i = 0; i < SW->aliascount; i++)
        {
            if (alias[i].domain != NULL)
            {
                xfree(alias[i].domain);
            }
        }
        xfree(alias);
        alias = NULL;
    }

    for (i = 0; i < MAXUSERS; i++)
    {
        if (user_list[i].name != NULL)
        {
            xfree(user_list[i].name);
            user_list[i].name = NULL;
        }
        if (user_list[i].lastread != NULL)
        {
            xfree(user_list[i].lastread);
            user_list[i].lastread = NULL;
        }
        if (user_list[i].robotname != NULL)
        {
            xfree(user_list[i].robotname);
            user_list[i].robotname = NULL;
        }
    }

    if (ST->username != NULL)
    {
        xfree(ST->username);
        ST->username = NULL;
    }

    if (ST->quotestr != NULL)
    {
        xfree(ST->quotestr);
        ST->quotestr = NULL;
    }

    if (ST->fidolist != NULL)
    {
        xfree(ST->fidolist);
        ST->fidolist = NULL;
    }

    if (ST->userlist != NULL)
    {
        xfree(ST->userlist);
        ST->userlist = NULL;
    }

    if (ST->origin != NULL)
    {
        xfree(ST->origin);
        ST->origin = NULL;
    }

    if (ST->outfile != NULL)
    {
        xfree(ST->outfile);
        ST->outfile = NULL;
    }

    if (ST->home != NULL)
    {
        xfree(ST->home);
        ST->home = NULL;
    }

    if (ST->lastread != NULL)
    {
        xfree(ST->lastread);
        ST->lastread = NULL;
    }

    if (ST->cfgfile != NULL)
    {
        xfree(ST->cfgfile);
        ST->cfgfile = NULL;
    }

    if (ST->html != NULL)
    {
        xfree(ST->html);
        ST->html = NULL;
    }

    if (ST->echotoss != NULL)
    {
        xfree(ST->echotoss);
        ST->echotoss = NULL;
    }

    if (ST->template != NULL)
    {
        xfree(ST->template);
        ST->template = NULL;
    }

    if (ST->nodepath != NULL)
    {
        xfree(ST->nodepath);
        ST->nodepath = NULL;
    }

    if (ST->nodebase != NULL)
    {
        xfree(ST->nodebase);
        ST->nodebase = NULL;
    }

    if (ST->sysop != NULL)
    {
        xfree(ST->sysop);
        ST->sysop = NULL;
    }

    if (ST->swap_path != NULL)
    {
        xfree(ST->swap_path);
        ST->swap_path = NULL;
    }

    if (ST->helpfile != NULL)
    {
        xfree(ST->helpfile);
        ST->helpfile = NULL;
        HelpTerm();
    }

    if (ST->uucpgate != NULL)
    {
        xfree(ST->uucpgate);
        ST->uucpgate = NULL;
    }

    if (ST->comspec != NULL)
    {
        xfree(ST->comspec);
        ST->comspec = NULL;
    }

    if (ST->editorName != NULL)
    {
        xfree(ST->editorName);
        ST->editorName = NULL;
    }

    if (ST->quickbbs != NULL)
    {
        xfree(ST->quickbbs);
        ST->quickbbs = NULL;
    }

    if (ST->fecfgpath != NULL)
    {
        xfree(ST->fecfgpath);
        ST->fecfgpath = NULL;
    }

    if (switch_vars != NULL)
    {
        xfree(switch_vars);
        switch_vars = NULL;
    }

    if (string_vars != NULL)
    {
        xfree(string_vars);
        string_vars = NULL;
    }
}
