/*
 *  HELP.C
 *
 *  Written by John Dennis and released to the public domain.
 *
 *  Help subsystem code.
 */

#include <stdio.h>
#include <string.h>
#include "xmalloc.h"
#include "winsys.h"
#include "menu.h"
#include "main.h"
#include "keys.h"
#include "help.h"

static FILE *help;
static HFileHdr Fheader;
static HTopicHdr *topics;
static char line[255];
static int setup;
static int CurrTopic;
static int numTopics;

#define SW        switch_vars

extern struct _swv
{
    unsigned long useroffset;   /* offset into lastread file */
    int area;                   /* current area number */
    int areas;                  /* how many message areas */
    int aliascount;             /* how many aliases do you have? */
    int otheraliases;           /* how many "other" aliases? */
    int numtemplates;           /* how many templates in use? */
    int domains;                /* how many domains listed */
    int rm;                     /* the right margin */
    int qm;                     /* the quote margin */
    int pointnet;               /* private net number of point */
    int tabsize;                /* how many spaces for a tab */
    int nodelists;              /* number of nodelists */
    int rquote;                 /* dfns for the reply funcs; quote */
    int rotharea;               /* reply other area */
    int rfollow;                /* reply followup */
    int rextra;                 /* reply extra - user definable */
    int gate;                   /* zone/domain gate messages? */
    int override;               /* override the area origin line */
    int scanned;                /* areas have been scanned */
    int msgids;                 /* add msgid lines */
    int opusdate;               /* put in the opus time stamp */
    int shownotes;              /* show hidden lines */
    int showseenbys;            /* show seenby lines */
    int showorigins;            /* show origin lines */
    int showtearlines;          /* show tear lines */
    int confirmations;          /* confirm deletes, aborts? */
    int datearrived;            /* show the date msg arrived? */
    int showaddr;               /* shows curr address on screen */
    int dummy1;                 /* whether to use lastread/current */
    int qquote;                 /* quote quotes? */
    int savecc;                 /* save cc original copy? */
    int rawcc;                  /* save the raw cc msg? */
    int chopquote;              /* chop off the end of quoted msgs? */
    int hardquote;              /* don't reformat quoted text? */
    int showcr;                 /* show CRs? */
    int showeol;                /* show eol? */
    int showrealmsgn;           /* show real msg#s in <alt><l> */
    int usemouse;               /* use the mouse? */
    int tabexpand;              /* expand tabs? */
    int editcronly;             /* show CRs in editor only */
    int usepid;                 /* use a PID instead of a tear line */
    int soteot;                 /* use SOT/EOT */
    int showtime;               /* show time in main message area? */
    int importfn;               /* show the filename headers on import */
    int dmore;                  /* display msg numbers at top of screen */
    int statbar;                /* show statbar */
    int showsystem;             /* show system name? */
    int extformat;              /* format externally-edited messages? */
    int arealistexactmatch;     /* exact match area names in area list? */
    int echoflags;              /* use FLAGS control line in echomail? */
    int netmailvia;             /* use Via control line in netmail? */
    int domainorigin;           /* write domain information to origin line? */
    int rightnextunreadarea;    /* key right to next unread area? */
    int usetearlines;           /* add tear lines in echomail? */
    int useoriginlines;         /* add origin lines in echomail? */
    int groups;                 /* how many groups? */
    int startupscan;            /* scan areas for new mail at startup? */
    int splashscreen;           /* display "splash screen" at startup? */
    int twitmode;               /* Use twitmode */
    char areasort;              /* Sort area yse/no */
    char sortdesc;              /* Sort after Description */
    char sorttag;               /* Sort after AreaTag */
    char sortunread;            /* Move Unread Areas to top */
    char editormenu;            /* Define use of menu window the external editor */
    char netmailorigin;         /* shall we use tearline and Origin in netmail? */
    char showstat;              /* Show msg size and quote % */
    char layout;                /* use old or new layout? (defauld = new) */
};

extern struct _swv *switch_vars; /* array of switches */

void HelpInit(char *fileName)
{
    int i;

    setup = 0;
    help = fopen(fileName, "rb");
    if (help == NULL)
    {
        return;
    }
    fread(&Fheader, sizeof(HFileHdr), 1, help);
    numTopics = (Fheader.topics[1] << 8) | Fheader.topics[0];
    topics = xcalloc(numTopics, sizeof *topics);
    for (i = 0; i < numTopics; i++)
    {
        fread(&topics[i], sizeof (HTopicHdr), 1, help);
    }
    setup = 1;
    CurrTopic = 0;
}

void DisplayPage(long offset, int max)
{
    char *s;
    int done;
    int line_num;

    done = 0;
    line_num = 0;

    fseek(help, offset, SEEK_SET);

    WndClear(0, 0, 54, 14, cm[HP_NTXT]);

    while (!done)
    {
        if (line_num == max)
        {
            break;
        }

        if (fgets(line, 254, help) == NULL)
        {
            break;
        }

        if (!strncmp(line, "*Page", 5) || !strncmp(line, "*End", 4))
        {
            break;
        }

        if (*line != '\n')
        {
            s = strchr(line, '\n');
            if (s != NULL)
            {
                *s = '\0';
            }

            if (!strncmp(line, "*High", 5))
            {
                s = line + 5;
                WndWriteStr(0, line_num, cm[HP_HTXT], s);
            }
            else
            {
                WndWriteStr(0, line_num, cm[HP_NTXT], line);
            }
        }
        line_num++;
    }
}

void DoHelp(int topic)
{
    WND *hWnd, *hCurr;
    long offset[20];
    int depth, page, pages, ch, done;

    if (help == NULL)
    {
        return;
    }

    if (topic < 0 || topic > numTopics)
    {
        return;
    }

    fseek(help, topics[topic].offset, SEEK_SET);

    if (fgets(line, 254, help) == NULL)
    {
        return;
    }

    if (strncmp(line, "*Begin", 6))
    {
        return;
    }

    done = 0;
    pages = 1;
    offset[pages - 1] = ftell(help);

    while (!done)
    {
        if (fgets(line, 254, help) == NULL)
        {
            return;
        }

        if (!strncmp(line, "*End", 4))
        {
            break;
        }

        if (!strncmp(line, "*Page", 5))
        {
            pages++;
            offset[pages - 1] = ftell(help);
        }
    }

    fseek(help, offset[0], SEEK_SET);

    hCurr = WndTop();
    hWnd = WndPopUp(60, 18, SBDR | INSBDR, cm[HP_BTXT], cm[HP_NTXT]);


    WndTitle(" Help ", cm[HP_TTXT]);

    done = 0;
    page = 0;
    depth = 14;

    DisplayPage(offset[page], depth);

    while (!done)
    {
        ch = TTGetChr();
        switch (ch)
        {
        case Key_PgDn:
            if (page + 1 < pages)
            {
                page++;
                DisplayPage(offset[page], depth);
            }
            break;

        case Key_PgUp:
            if (page > 0)
            {
                page--;
                DisplayPage(offset[page], depth);
            }
            break;

        case Key_Esc:
            done = TRUE;
            break;

        default:
            break;
        }
    }
    WndClose(hWnd);
    WndCurr(hCurr);
}

void HelpTerm(void)
{
    if (topics != NULL)
    {
        xfree(topics);
    }
}
