/*
 *  FREQ.C
 *
 *  Written on 14-Jan-98 by Kim Lykkegaard.
 *  Released to the public domain.
 *
 *  Makes filerequest (FD-style) from a msgbody.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#if defined(__MSC__) || defined(OS216)
#include <sys/types.h>
#include <sys/timeb.h>
#include <direct.h>
#endif

#if defined(MSDOS) && defined(__TURBOC__)
#include <dir.h>
#endif

#ifdef __WATCOMC__
#if defined(MSDOS) || defined(__NT__)
#include <direct.h>
#endif
#endif

#ifdef PACIFIC
#include <sys.h>
int bdos(int func, unsigned reg_dx, unsigned char reg_al);
#endif

#if defined(MSDOS) || defined(__NT__)
#include <dos.h>
#endif

#ifdef OS2
#define INCL_DOSFILEMGR
#include <fcntl.h>
#endif

#if defined(UNIX) || defined(__DJGPP__)
#include <unistd.h>
#endif

#include "addr.h"
#include "nedit.h"
#include "msged.h"
#include "winsys.h"
#include "menu.h"
#include "main.h"
#include "xmalloc.h"
#include "screen.h"
#include "config.h"
#include "keys.h"
#include "version.h"
#include "readmail.h"
#include "dialogs.h"
#include "help.h"
#include "makemsgn.h"

void makefreq(void)
{

     EVT event;
     msg *m = NULL,
         *n = NULL;
     LINE *line, *curr, *l2;
     FREQ *freq;
     ADDRESS from;
     char file[256],
          txt[236],
          desc[256];
     int k;            /* UMSGID msgnum */
     int o;            /* old UMSGID msgnullm */
     unsigned long length;       /* length in bytes of the message */
     unsigned long now=0L;            /* UMSGID msgnum */
     int i,
         l=0,
         y,
         oy,
         pos,
         old_pos,
         Msg,
         max=16,
         maxy=16,
         redraw,
         starty,
         done=0,
         num_freq=0,
         gotdot=0,
         old_netmailorigin;
    WND *hCurr, *hWnd;

     line=NULL;
     curr=NULL;
     freq=NULL;
     old_netmailorigin = SW->netmailorigin;
     SW->netmailorigin = 0;

     if (now == 0L)
     {
        now = sec_time();
     }

     n = readmsg(CurArea.current);
     if ((m = readmsg(CurArea.current)) != NULL)
     {
        line = m->text;
        while (line->next != NULL)
        {
            l=0;
            strcpy(txt, line->text);
            txt[20]=NULL;
            if ((strchr(txt, '.')) && ((!strstr(txt, "---")) && (!strstr(txt, "..."))))
            {
               while(txt[0]==' ')
               {
                  strcpy(txt, &txt[1]);
                  l++;
                  if (strlen(txt)== 0)  /* this can happen - but just in case .-) */
                  {
                     break;
                  }
               }
               for(i=0; i<strlen(txt); i++)
               {
                   file[i]=txt[i];
                   file[i+1]=NULL;
                   if ((txt[i]=='.') && (!gotdot))
                   {
                      gotdot=1;
                   }
                   if ((txt[i]==' ') && (gotdot))
                   {
                      file[i]=NULL;
                      l=l+i+1;
                      break;
                   }
               }
               strcpy(txt, &line->text[l]);
               while(txt[0]==' ')
               {
                  strcpy(txt, &txt[1]);
                  l++;
                  if (strlen(txt)== 0)
                  {
                     txt[0]=NULL;
                     break;
                  }
               }
               i=strlen(txt)-1;
               while((txt[i]==' ') || (txt[i]=='\n') || (txt[i]=='\r'))
               {
                   txt[i]=NULL;
                   i--;
                   if (i<=0)
                   {
                      break;
                   }
               }
               strcpy(desc, txt);
               while(strchr(" 0123456789-.,[]()kbKB",desc[0]))
               {
                  strcpy(desc, &desc[1]);
                  if (strlen(desc) <=1)
                  {
                     desc[0]=NULL;
                     break;
                  }
               }
               if ((!strchr(file, ' ')) &&         /* If space in file name - drop it */
                  (file[strlen(file)-1] != '.') && /* If it end on . well it isn't a file  */
                  (strchr(file, '.')))
               {
                  freq = xrealloc(freq, (++num_freq) * sizeof(struct _freq));
                  freq[num_freq - 1].file = xstrdup(file);
                  freq[num_freq - 1].desc = xstrdup(desc);
                  freq[num_freq - 1].status = NULL;
               }
            }
            line = line->next;
        }
        freq = xrealloc(freq, (++num_freq) * sizeof(struct _freq));
        freq[num_freq - 1].file = xstrdup("FILES");
        sprintf(txt, "Filelist from %s", m->isfrom);
        freq[num_freq - 1].desc = xstrdup(txt);
        freq[num_freq - 1].status = NULL;

        hCurr = WndTop();

        if (num_freq < maxy)
        {
           maxy=num_freq;
        }

        hWnd = WndOpen(0, 6, 79, maxy+7, SBDR, cm[LS_BTXT], cm[LS_NTXT]);
        sprintf(txt, " File Request from %s ", m->isfrom);
        WndTitle(txt, cm[LS_NTXT]);


        y=0;
        oy=0;
        pos=0;
        old_pos=0;
        redraw=1;
        starty=0;
        while(!done)
        {
          if(redraw)
          {
        WndClose(hWnd);
        hWnd = WndOpen(0, 6, 79, maxy+7, SBDR, cm[LS_BTXT], cm[LS_NTXT]);
        sprintf(txt, " File Request from %s ", m->isfrom);
        WndTitle(txt, cm[LS_NTXT]);
              WndClear(0, 0, 76, maxy-starty-1, cm[LS_BTXT]);
              for (i=starty; i<maxy; i++)
              {
                  l=strlen(freq[i].file)+1;
                  if (l<15)
                  {
                     l=15;
                  }
                  if (strlen(freq[i].desc) > 60)
                  {
                     freq[i].desc[60]=NULL;
                  }
                  WndGotoXY(1, i-starty);
                  if (freq[i].status != NULL)
                  {
                      WndPutc('+', cm[LS_NTXT]);
                  }
                  WndWriteStr(2, i-starty, cm[LS_NTXT], freq[i].file);
                  WndWriteStr(2+l,i-starty, cm[LS_NTXT], freq[i].desc);
              }
              redraw=0;
           }
           if (oy!=y)
           {
              WndWriteStr(2, oy, cm[LS_NTXT], freq[old_pos].file);
           }
           WndWriteStr(2, y, cm[LS_STXT], freq[pos].file);
           oy=y;
           old_pos=pos;

           Msg = MnuGetMsg(&event, hWnd->wid);

           switch (event.msgtype)
           {
               case WND_WM_CHAR:
                   switch (Msg)
                   {
                      case Key_Up:
                           if (y>0)
                           {
                              y--;
                              pos--;
                           }
                           else
                           {
                              if ((starty>0) && (y==0))
                              {
                                 starty--;
                                 maxy--;
                                 pos--;
                                 redraw=1;
                                 y=0;
                                 oy=0;
                              }
                           }
                      break;
                      case Key_Dwn:
                           if (y<maxy-1-starty)
                           {
                              y++;
                              pos++;
                           }
                           else
                           {
                             if (maxy<num_freq-1)
                             {
                                 starty++;
                                 maxy++;
                                 pos++;
                                 redraw=1;
                             }
                           }
                      break;
                      case Key_PgUp:
                           if (starty>0)
                           {
                              starty=starty-max;
                              maxy=maxy-max;
                              pos=pos-max;
                              if (starty<0)
                              {
                                 starty=0;
                                 maxy=num_freq;
                                 if (maxy>max)
                                 {
                                    maxy=max;
                                 }
                                 pos=0;
                              }
                              y=0;
                              oy=0;
                              redraw=1;
                           }
                      break;
                      case Key_PgDn:
                           if (maxy<num_freq)
                           {
                              maxy=maxy+max;
                              starty=starty+max;
                              if (maxy>num_freq)
                              {
                                 maxy=num_freq;
                                 starty=maxy-max;
                              }
                              pos=starty;
                              oy=0;
                              y=0;
                              redraw=1;
                           }
                      break;
                      case Key_Home:
                           oy=0;
                           y=0;
                           pos=0;
                           redraw=1;
                      break;
                      case Key_Ins:
                           file[0]=NULL;
                           gotdot = GetString2(" FileName: ",
                                                file, 12);
                           file[13]=NULL;
                           strupr(file);

                           if (gotdot)
                           {

                              freq = xrealloc(freq, (++num_freq) * sizeof(struct _freq));
                              freq[num_freq - 1].file = xstrdup(file);
                              freq[num_freq - 1].desc = xstrdup("We love MsGed....");
                              freq[num_freq - 1].status =  1;
                              if (maxy < max)
                                 maxy++;
                           }
                           else
                           {
                             /*
                              * We only want to break if the use don't add new file.
                             */
                             break;
                           }
                      case Key_End:
                           if (maxy<num_freq)
                           {
                              maxy=num_freq;
                              starty=maxy-max;
                              pos=num_freq-1;
                              y=maxy-1;
                              oy=maxy-1;
                           }
                           else
                           {
                              oy=maxy-1;
                              y=maxy-1;
                              pos=maxy-1;
                           }
                           redraw=1;
                      break;
                      case Key_Spc:
                           freq[pos].status = !freq[pos].status;
                           WndGotoXY(1, y);
                           if (freq[pos].status != NULL)
                           {
                               WndPutc('+', cm[LS_NTXT]);
                           }
                           else
                           {
                               WndPutc(' ', cm[LS_NTXT]);
                           }
                           if (y<maxy-starty-1)
                           {
                              y++;
                              pos++;
                           }
                           else
                           {
                             if (maxy<num_freq-1)
                             {
                                 starty++;
                                 maxy++;
                                 pos++;
                                 redraw=1;
                             }
                           }
                      break;
                      case Key_A_X:
                      case Key_Esc:
                         done=1;
                      break;
                      case Key_F1:
                      case 0x2300:
                          if (ST->helpfile != NULL)
                          {
                             DoHelp(4);
                          }
                      break;
                      case Key_Ent:
                         done=2;
                      break;
                   }
               break;
               default:
                   break;
           }

        }

        WndClose(hWnd);
        WndCurr(hCurr);

        if ((done==1) || ((done==2) && (num_freq<1)))
        {
           for(i=0; i<num_freq; i++)
           {
               if (freq[i].file==NULL)
               {
                  break;
               }
               xfree(freq[i].file);
               if (freq[i].desc==NULL)
               {
                  break;
               }
               xfree(freq[i].desc);
           }
           return;
        }

        o=SW->area;

        gotdot=0; /* reuse not nice, but save a int */
        for (k = 0; k < SW->areas; k++)
        {
            if (!stricmp(ST->freqarea, arealist[k].tag))
            {
                gotdot=1;
                break;
            }
        }

       if (gotdot) {

          set_area(k); /* k er en int for area nr. */


          m->msgnum = MsgnToUid(CurArea.messages);

          from=m->from;

          xfree(m->text);
          m->text=NULL;

          if (SW->msgids)
          {
              sprintf(txt, "\01MSGID: %s %08lx\r", show_address(&from), now++);
              curr = InsertAfter(curr, txt);
          }

          if (curr != NULL)
          {
              curr->next = m->text;
              if (m->text != NULL)
              {
                  m->text->prev = curr;
              }

              while (curr->prev != NULL)
              {
                  curr = curr->prev;
              }

              m->text = curr;
          }

          l2 = m->text;
          length=0L;
          while (l2)
          {
              length += strlen(l2->text);
              l2 = l2->next;
          }

          txt[0]=NULL;
          for(i=0; i<num_freq; i++)
          {
             if (freq[i].status != NULL)
             {
                strcat(txt, freq[i].file);
                strcat(txt, " ");
             }
             if (strlen(txt) > 55) /* check subj isn't yo big */
             {
                 txt[strlen(txt)-1]=NULL;      /* kill last space */
                 m->msgnum++;


                 m->isto = xstrdup(n->isfrom);
                 xfree(m->isfrom);
                 m->isfrom = NULL;
                 m->isfrom = xstrdup(ST->username);
                 m->to = n->from;
                 m->from = CurArea.addr;
                 m->timestamp = time(NULL);
                 m->replyto = 0;
                 m->new = 1;
                 m->cost = 0;
                 m->times_read = 0;
                 m->scanned = 0;
                 m->soteot = 0;
                 m->time_arvd = 0;
                 clear_attributes(&m->attrib);
                 m->attrib.sent = 0;
                 m->attrib.orphan = 0;
                 m->attrib.local = 1;
                 m->scanned = 0;
                 m->attrib.freq = 1;
                 m->attrib.direct = 1;
                 m->attrib.killsent = 1;
                 m->subj=xstrdup(txt);


                 CurArea.last++;
                 writemsg(m);
                 txt[0]=NULL;
             }
          }
          txt[strlen(txt)-1]=NULL;      /* kill last space */

           m->isto = xstrdup(n->isfrom);
           xfree(m->isfrom);
           m->isfrom = NULL;
           m->isfrom = xstrdup(ST->username);
           m->to = n->from;
           m->from = CurArea.addr;
           m->timestamp = time(NULL);
           m->replyto = 0;
           m->new = 1;
           m->cost = 0;
           m->times_read = 0;
           m->scanned = 0;
           m->soteot = 0;
           m->time_arvd = 0;
           clear_attributes(&m->attrib);
           m->attrib.sent = 0;
           m->attrib.orphan = 0;
           m->attrib.local = 1;
           m->scanned = 0;
           m->attrib.freq = 1;
           m->attrib.direct = 1;
           m->attrib.killsent = 1;
           m->subj=xstrdup(txt);

           if (strlen(txt)!=0)
           {
              CurArea.last++;
              m->msgnum++;
              writemsg(m);
           }
        }

     }   /* end gotdot (found a area to make req. in) */
     else
     {
        ChoiceBox("", "ET phone home???", "  Ok  ", NULL, NULL);
     }

     dispose(m);
     dispose(n);

     SW->netmailorigin = old_netmailorigin;

     for(i=0; i<num_freq; i++)
     {
         if (freq[i].file==NULL)
         {
            break;
         }
         xfree(freq[i].file);
         if (freq[i].desc==NULL)
         {
            break;
         }
         xfree(freq[i].desc);
     }

     set_area(o);

}
