/*
 *  Written by Matthew Parker with modifications by Andrew Clarke
 *  and others, and released to the public domain.
 */

#include <stdlib.h>

#if defined(__FLAT__) && !defined(__DJGPP__)

#include <string.h>
#include <i86.h>
#include "rmi.h"

struct rminfo RMINF;

#else

#include <stdio.h>
#include <dos.h>
#include <conio.h>

#ifdef __DJGPP__
#include <dpmi.h>
#endif

#endif

void dos_pause(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    __dpmi_int(0x28, &r);
#elif defined(__FLAT__)
    int86x(0x28);
#else
#ifdef __TURBOC__
    geninterrupt(0x28);
#else
    union REGS r;
    int86(0x28, &r, &r);
#endif
#endif
}

void dv_pause(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
#ifdef TOPVIEW
    r.x.ax = 0x101A;
    __dpmi_int(0x15, &r);
#endif
    r.x.ax = 0x1000;
    __dpmi_int(0x15, &r);
#ifdef TOPVIEW
    r.x.ax = 0x1025;
    __dpmi_int(0x15, &r);
#endif
#elif defined(__FLAT__)
#ifdef TOPVIEW
    RMINF.EAX = 0x101A;
    int86x(0x15);
#endif
    RMINF.EAX = 0x1000;
    int86x(0x15);
#ifdef TOPVIEW
    RMINF.EAX = 0x1025;
    int86x(0x15);
#endif
#else
#ifdef TOPVIEW
#ifdef __TURBOC__
    _AX = 0x101A;
    geninterrupt(0x15);
#else
    union REGS r;
    r.x.ax = 0x101A;
    int86(0x15, &r, &r);
#endif
#endif
#ifdef __TURBOC__
    _AX = 0x1000;
    geninterrupt(0x15);
#else
    union REGS r;
    r.x.ax = 0x1000;
    int86(0x15, &r, &r);
#endif
#ifdef TOPVIEW
#ifdef __TURBOC__
    _AX = 0x1025;
    geninterrupt(0x15);
#else
    r.x.ax = 0x1025;
    int86(0x15, &r, &r);
#endif
#endif
#endif
}

void win_pause(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    r.x.ax = 0x1680;
    __dpmi_int(0x2F, &r);
#elif defined(__FLAT__)
    RMINF.EAX = 0x1680;
    int86x(0x2F);
#else
#ifdef __TURBOC__
    _AX = 0x1680;
    geninterrupt(0x2F);
#else
    union REGS r;
    r.x.ax = 0x1680;
    int86(0x2F, &r, &r);
#endif
#endif
}

int dv_running(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    r.x.ax = 0x2B01;
    r.x.cx = 0x4445;
    r.x.dx = 0x5351;
    __dpmi_int(0x21, &r);
    return r.h.al != 0xFF;
#elif defined(__FLAT__)
    RMINF.EAX = 0x2B01;
    RMINF.ECX = 0x4445;
    RMINF.EDX = 0x5351;
    int86x(0x21);
    return (RMINF.EAX & 0xFF) != 0xFF;
#else
#ifdef __TURBOC__
    _AX = 0x2B01;
    _CX = 0x4445;
    _DX = 0x5351;
    geninterrupt(0x21);
    return _AL != 0xFF;
#else
    union REGS r;
    r.x.ax = 0x2B01;
    r.x.cx = 0x4445;
    r.x.dx = 0x5351;
    int86(0x21, &r, &r);
    return r.h.al != 0xFF;
#endif
#endif
}

int os2_running(void)
{
#if defined(__FLAT__) || defined(__DJGPP__) || defined(__TURBOC__) || defined(__WATCOMC__)
    return _osmajor >= 10;
#else
    union REGS r;
    r.x.ah = 0x30;
    int86(0x21, &r, &r);
    return r.h.al >= 10;
#endif
}

int win_running(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    r.x.ax = 0x160A;
    __dpmi_int(0x2F, &r);
    return r.x.ax == 0;
#elif defined(__FLAT__)
    RMINF.EAX = 0x160A;
    int86x(0x2F);
    return RMINF.EAX == 0;
#else
#ifdef __TURBOC__
    _AX = 0x160A;
    geninterrupt(0x2F);
    return _AX == 0;
#else
    union REGS r;
    r.x.ax = 0x160A;
    int86(0x2F, &r, &r);
    return r.x.ax == 0;
#endif
#endif
}

int kbdhit(void)
{
#if defined(__FLAT__) && !defined(__DJGPP__)
    RMINF.EAX = 0x100;
    int86x(0x16);
    return !(RMINF.flags & INTR_ZF);
#else
    return kbhit() ? 1 : 0;
#endif
}

unsigned int obtkey(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    r.x.ax = 0;
    __dpmi_int(0x16, &r);
    if (r.h.al == 0)
    {
        return r.x.ax;
    }
    else
    {
        return r.h.al;
    }
#elif defined(__FLAT__)
    RMINF.EAX = 0;
    int86x(0x16);
    if ((RMINF.EAX & 0xFF) == 0)
    {
        return RMINF.EAX & 0xFFFF;
    }
    else
    {
        return (unsigned) (RMINF.EAX & 0xFF);
    }
#else
#ifdef __TURBOC__
    _AX = 0x00;
    geninterrupt(0x16);
    if (_AL == 0)
    {
        return _AX;
    }
    else
    {
        return _AL;
    }
#else
    union REGS r;
    r.x.ax = 0x00;
    int86(0x16, &r, &r);
    if (r.h.al == 0)
    {
        return r.x.ax;
    }
    else
    {
        return r.h.al;
    }
#endif
#endif
}

unsigned int dosavmem(void)
{
#if defined(__DJGPP__)
    __dpmi_regs r;
    r.h.ah = 0x48;
    r.x.bx = 0xffff;
    __dpmi_int(0x21, &r);
    if (r.x.flags)
    {
        return r.x.bx;
    }
    else
    {
        r.x.es = r.x.ax;
        r.h.ah = 0x49;
        __dpmi_int(0x21, &r);
        return 0xffff;
    }
#elif defined(__FLAT__)
    union REGS regs;
    struct SREGS sregs;

    struct
    {
        unsigned int LargestBlockAvail;
        unsigned int MaxUnlockedPage;
        unsigned int LargestLockablePage;
        unsigned int LinAddrSpace;
        unsigned int NumFreePagesAvail;
        unsigned int NumPhysicalPagesFree;
        unsigned int TotalPhysicalPages;
        unsigned int FreeLinAddrSpace;
        unsigned int SizeOfPageFile;
        unsigned int Reserved[3];
    } mi;

    regs.x.eax = 0x00000500;
    memset(&sregs, 0, sizeof sregs);
    sregs.es = FP_SEG(&mi);
    regs.x.edi = FP_OFF(&mi);
    int386x(0x31, &regs, &regs, &sregs );
    return mi.LargestBlockAvail;
#else
#ifdef __TURBOC__
    _AH = 0x48;
    _BX = 0xFFFF;
    geninterrupt(0x21);
    if (_FLAGS & 0x01)  /* if (r.x.cflag) */
    {
        return _BX;
    }
    else
    {
        _ES = _AX;
        _AH = 0x49;
        geninterrupt(0x21);
        return 0xFFFF;
    }
#else
    union REGS r;
    struct SREGS s;
    r.h.ah = 0x48;
    r.x.bx = 0xffff;
    int86(0x21, &r, &r);
    if (r.x.cflag)
    {
        return r.x.bx;
    }
    else
    {
        s.es = r.x.ax;
        r.h.ah = 0x49;
        int86x(0x21, &r, &r, &s);
        return 0xffff;
    }
#endif
#endif
}

#if defined(__FLAT__) && !defined(__DJGPP__)

void int86x(unsigned short inty)
{
    union REGS regs;
    struct SREGS sregs;
    segread(&sregs);
    regs.w.ax = 0x0300;
    regs.w.bx = inty;
    regs.w.cx = 0;
    sregs.es = FP_SEG(&RMINF);
    regs.x.edi = FP_OFF(&RMINF);
    int386x(0x31, &regs, &regs, &sregs);
}

#endif
