/*
 *  DLIST.H - Doubly linked-list management functions.
 *  Adapted from 1995 public domain C code by Scott Pitcher.
 *  Modified 1995-1997 by Andrew Clarke and released to the public domain.
 */

#ifndef __DLIST_H__
#define __DLIST_H__

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct dlistnode
{
    struct dlistnode *L_prev;
    struct dlistnode *L_next;
    void *L_element;
}
DLISTNODE, *PDLISTNODE;

typedef struct
{
    PDLISTNODE L_first;
    PDLISTNODE L_last;
    unsigned long L_elements;
}
DLIST, *PDLIST;

PDLIST dlistInit(void);
void dlistTerm(PDLIST p_list);
void *dlistGetElement(PDLISTNODE p_node);
void dlistSetElement(PDLISTNODE p_node, void *p_element);
DLISTNODE *dlistCreateNode(void *p_element);
void dlistDeleteNode(PDLISTNODE p_node);
void dlistAddNode(PDLIST p_list, PDLISTNODE p_node);
void dlistDropNode(PDLIST p_list, PDLISTNODE p_node);

PDLISTNODE dlistTravFirst(PDLIST p_list);
PDLISTNODE dlistTravLast(PDLIST p_list);
PDLISTNODE dlistTravPrevious(PDLISTNODE p_node);
PDLISTNODE dlistTravNext(PDLISTNODE p_node);

int dlistCompareNodes(PDLISTNODE p_node1, PDLISTNODE p_node2, int (*fcmp) (const void *, const void *));
void dlistSwapNodes(PDLISTNODE p_node1, PDLISTNODE p_node2);
PDLISTNODE dlistSearch(PDLIST p_list, void *p_element, int (*fcmp) (const void *, const void *));
unsigned long dlistTotalNodes(PDLIST p_list);
int dlistIsEmpty(PDLIST p_list);

#ifdef __cplusplus
};
#endif

#endif
